-- Adminer 4.8.1 MySQL 5.5.62-0ubuntu0.14.04.1-log dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `tea_actionscheduler_actions`;
CREATE TABLE `tea_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8_unicode_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tea_actionscheduler_actions` (`action_id`, `hook`, `status`, `scheduled_date_gmt`, `scheduled_date_local`, `args`, `schedule`, `group_id`, `attempts`, `last_attempt_gmt`, `last_attempt_local`, `claim_id`, `extended_args`) VALUES
(8017,	'rocket_preload_job_check_finished',	'complete',	'2024-02-04 15:25:54',	'2024-02-04 07:25:54',	'[1707060294]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1707060354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1707060354;}',	2,	1,	'2024-02-04 15:26:12',	'2024-02-04 07:26:12',	0,	NULL),
(8018,	'rocket_preload_job_check_finished',	'complete',	'2024-02-07 02:29:16',	'2024-02-06 18:29:16',	'[1707272896]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1707272956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1707272956;}',	2,	1,	'2024-02-07 02:31:21',	'2024-02-06 18:31:21',	0,	NULL),
(8019,	'rocket_preload_job_check_finished',	'complete',	'2024-02-07 02:32:31',	'2024-02-06 18:32:31',	'[1707273091]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1707273151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1707273151;}',	2,	1,	'2024-02-07 02:32:39',	'2024-02-06 18:32:39',	0,	NULL),
(8020,	'rocket_preload_job_check_finished',	'complete',	'2024-02-07 07:33:51',	'2024-02-06 23:33:51',	'[1707291171]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1707291231;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1707291231;}',	2,	1,	'2024-02-07 07:33:57',	'2024-02-06 23:33:57',	0,	NULL),
(8021,	'rocket_preload_job_check_finished',	'complete',	'2024-02-07 07:36:46',	'2024-02-06 23:36:46',	'[1707291346]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1707291406;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1707291406;}',	2,	1,	'2024-02-07 07:36:58',	'2024-02-06 23:36:58',	0,	NULL),
(8022,	'rocket_preload_job_check_finished',	'complete',	'2024-02-11 15:33:46',	'2024-02-11 07:33:46',	'[1707665566]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1707665626;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1707665626;}',	2,	1,	'2024-02-11 15:34:44',	'2024-02-11 07:34:44',	0,	NULL),
(8023,	'rocket_preload_job_check_finished',	'complete',	'2024-02-13 15:04:56',	'2024-02-13 07:04:56',	'[1707836636]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1707836696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1707836696;}',	2,	1,	'2024-02-13 15:04:56',	'2024-02-13 07:04:56',	0,	NULL),
(8024,	'rocket_preload_job_check_finished',	'complete',	'2024-02-18 15:26:16',	'2024-02-18 07:26:16',	'[1708269916]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1708269976;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1708269976;}',	2,	1,	'2024-02-18 15:27:18',	'2024-02-18 07:27:18',	0,	NULL),
(8025,	'rocket_preload_job_check_finished',	'complete',	'2024-02-25 15:34:21',	'2024-02-25 07:34:21',	'[1708875201]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1708875261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1708875261;}',	2,	1,	'2024-02-25 15:34:58',	'2024-02-25 07:34:58',	0,	NULL),
(8026,	'action_scheduler/migration_hook',	'complete',	'2024-02-28 18:47:08',	'2024-02-28 10:47:08',	'[]',	'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1709146028;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1709146028;}',	1,	1,	'2024-02-28 18:47:11',	'2024-02-28 10:47:11',	0,	NULL);

DROP TABLE IF EXISTS `tea_actionscheduler_claims`;
CREATE TABLE `tea_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `tea_actionscheduler_groups`;
CREATE TABLE `tea_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tea_actionscheduler_groups` (`group_id`, `slug`) VALUES
(1,	'action-scheduler-migration'),
(2,	'rocket-preload');

DROP TABLE IF EXISTS `tea_actionscheduler_logs`;
CREATE TABLE `tea_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tea_actionscheduler_logs` (`log_id`, `action_id`, `message`, `log_date_gmt`, `log_date_local`) VALUES
(301,	8017,	'action created',	'2024-02-04 15:24:54',	'2024-02-04 07:24:54'),
(302,	8017,	'action started via WP Cron',	'2024-02-04 15:26:12',	'2024-02-04 07:26:12'),
(303,	8017,	'action complete via WP Cron',	'2024-02-04 15:26:12',	'2024-02-04 07:26:12'),
(304,	8018,	'action created',	'2024-02-07 02:28:16',	'2024-02-06 18:28:16'),
(305,	8018,	'action started via WP Cron',	'2024-02-07 02:31:21',	'2024-02-06 18:31:21'),
(306,	8018,	'action complete via WP Cron',	'2024-02-07 02:31:21',	'2024-02-06 18:31:21'),
(307,	8019,	'action created',	'2024-02-07 02:31:31',	'2024-02-06 18:31:31'),
(308,	8019,	'action started via WP Cron',	'2024-02-07 02:32:39',	'2024-02-06 18:32:39'),
(309,	8019,	'action complete via WP Cron',	'2024-02-07 02:32:39',	'2024-02-06 18:32:39'),
(310,	8020,	'action created',	'2024-02-07 07:32:51',	'2024-02-06 23:32:51'),
(311,	8020,	'action started via Async Request',	'2024-02-07 07:33:57',	'2024-02-06 23:33:57'),
(312,	8020,	'action complete via Async Request',	'2024-02-07 07:33:57',	'2024-02-06 23:33:57'),
(313,	8021,	'action created',	'2024-02-07 07:35:46',	'2024-02-06 23:35:46'),
(314,	8021,	'action started via Async Request',	'2024-02-07 07:36:58',	'2024-02-06 23:36:58'),
(315,	8021,	'action complete via Async Request',	'2024-02-07 07:36:58',	'2024-02-06 23:36:58'),
(316,	8022,	'action created',	'2024-02-11 15:32:46',	'2024-02-11 07:32:46'),
(317,	8022,	'action started via WP Cron',	'2024-02-11 15:34:44',	'2024-02-11 07:34:44'),
(318,	8022,	'action complete via WP Cron',	'2024-02-11 15:34:44',	'2024-02-11 07:34:44'),
(319,	8023,	'action created',	'2024-02-13 15:03:56',	'2024-02-13 07:03:56'),
(320,	8023,	'action started via WP Cron',	'2024-02-13 15:04:56',	'2024-02-13 07:04:56'),
(321,	8023,	'action complete via WP Cron',	'2024-02-13 15:04:56',	'2024-02-13 07:04:56'),
(322,	8024,	'action created',	'2024-02-18 15:25:16',	'2024-02-18 07:25:16'),
(323,	8024,	'action started via WP Cron',	'2024-02-18 15:27:18',	'2024-02-18 07:27:18'),
(324,	8024,	'action complete via WP Cron',	'2024-02-18 15:27:18',	'2024-02-18 07:27:18'),
(325,	8025,	'action created',	'2024-02-25 15:33:21',	'2024-02-25 07:33:21'),
(326,	8025,	'action started via WP Cron',	'2024-02-25 15:34:58',	'2024-02-25 07:34:58'),
(327,	8025,	'action complete via WP Cron',	'2024-02-25 15:34:58',	'2024-02-25 07:34:58'),
(328,	8026,	'action created',	'2024-02-28 18:46:08',	'2024-02-28 10:46:08'),
(329,	8026,	'action started via WP Cron',	'2024-02-28 18:47:11',	'2024-02-28 10:47:11'),
(330,	8026,	'action complete via WP Cron',	'2024-02-28 18:47:11',	'2024-02-28 10:47:11');

DROP TABLE IF EXISTS `tea_commentmeta`;
CREATE TABLE `tea_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `tea_comments`;
CREATE TABLE `tea_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `tea_links`;
CREATE TABLE `tea_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `tea_options`;
CREATE TABLE `tea_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tea_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1,	'siteurl',	'https://www.megajustice.com',	'yes'),
(2,	'home',	'https://www.megajustice.com',	'yes'),
(3,	'blogname',	'Pawlowski Mastrilli Law Group',	'yes'),
(4,	'blogdescription',	'',	'yes'),
(5,	'users_can_register',	'0',	'yes'),
(6,	'admin_email',	'cms@site-mail.com',	'yes'),
(7,	'start_of_week',	'1',	'yes'),
(8,	'use_balanceTags',	'0',	'yes'),
(9,	'use_smilies',	'1',	'yes'),
(10,	'require_name_email',	'1',	'yes'),
(11,	'comments_notify',	'1',	'yes'),
(12,	'posts_per_rss',	'10',	'yes'),
(13,	'rss_use_excerpt',	'0',	'yes'),
(14,	'mailserver_url',	'mail.example.com',	'yes'),
(15,	'mailserver_login',	'login@example.com',	'yes'),
(16,	'mailserver_pass',	'password',	'yes'),
(17,	'mailserver_port',	'110',	'yes'),
(18,	'default_category',	'1',	'yes'),
(19,	'default_comment_status',	'closed',	'yes'),
(20,	'default_ping_status',	'closed',	'yes'),
(21,	'default_pingback_flag',	'1',	'yes'),
(22,	'posts_per_page',	'10',	'yes'),
(23,	'date_format',	'F j, Y',	'yes'),
(24,	'time_format',	'g:i a',	'yes'),
(25,	'links_updated_date_format',	'F j, Y g:i a',	'yes'),
(26,	'comment_moderation',	'1',	'yes'),
(27,	'moderation_notify',	'1',	'yes'),
(28,	'permalink_structure',	'/%postname%/',	'yes'),
(30,	'hack_file',	'0',	'yes'),
(31,	'blog_charset',	'UTF-8',	'yes'),
(32,	'moderation_keys',	'',	'no'),
(33,	'active_plugins',	'a:10:{i:0;s:53:\"addfunc-head-footer-code/addfunc-head-footer-code.php\";i:1;s:45:\"classic-editor-addon/classic-editor-addon.php\";i:2;s:33:\"disable-emojis/disable-emojis.php\";i:3;s:45:\"disable-lazy-loading/disable-lazy-loading.php\";i:4;s:33:\"dsk-open-graph/dsk-open-graph.php\";i:5;s:19:\"dsk-seo/dsk-seo.php\";i:6;s:39:\"dsk-website-forms/dsk-website-forms.php\";i:7;s:45:\"simple-page-ordering/simple-page-ordering.php\";i:8;s:37:\"subslide-chooser/subslide-chooser.php\";i:9;s:32:\"xml-sitemap-feed/xml-sitemap.php\";}',	'yes'),
(34,	'category_base',	'',	'yes'),
(35,	'ping_sites',	'http://rpc.pingomatic.com/',	'yes'),
(36,	'comment_max_links',	'2',	'yes'),
(37,	'gmt_offset',	'',	'yes'),
(38,	'default_email_category',	'1',	'yes'),
(39,	'recently_edited',	'a:5:{i:0;s:140:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content/themes/pawlowski-mastrilli-law-group_mirror/page-contact-us.php\";i:2;s:130:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content/themes/pawlowski-mastrilli-law-group_mirror/style.css\";i:3;s:123:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content/themes/pawlowski-mastrilli-law-group/style.css\";i:4;s:129:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content/themes/pawlowski-mastrilli-law-group_mirror/data.php\";i:5;s:136:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content/themes/pawlowski-mastrilli-law-group/includes/data-core.php\";}',	'no'),
(40,	'template',	'universal_mm',	'yes'),
(41,	'stylesheet',	'pawlowski-mastrilli-law-group',	'yes'),
(44,	'comment_registration',	'0',	'yes'),
(45,	'html_type',	'text/html',	'yes'),
(46,	'use_trackback',	'0',	'yes'),
(47,	'default_role',	'subscriber',	'yes'),
(48,	'db_version',	'56657',	'yes'),
(49,	'uploads_use_yearmonth_folders',	'1',	'yes'),
(50,	'upload_path',	'',	'yes'),
(51,	'blog_public',	'1',	'yes'),
(52,	'default_link_category',	'2',	'yes'),
(53,	'show_on_front',	'page',	'yes'),
(54,	'tag_base',	'',	'yes'),
(55,	'show_avatars',	'1',	'yes'),
(56,	'avatar_rating',	'G',	'yes'),
(57,	'upload_url_path',	'',	'yes'),
(58,	'thumbnail_size_w',	'150',	'yes'),
(59,	'thumbnail_size_h',	'150',	'yes'),
(60,	'thumbnail_crop',	'1',	'yes'),
(61,	'medium_size_w',	'300',	'yes'),
(62,	'medium_size_h',	'300',	'yes'),
(63,	'avatar_default',	'mystery',	'yes'),
(64,	'large_size_w',	'1024',	'yes'),
(65,	'large_size_h',	'1024',	'yes'),
(66,	'image_default_link_type',	'none',	'yes'),
(67,	'image_default_size',	'',	'yes'),
(68,	'image_default_align',	'',	'yes'),
(69,	'close_comments_for_old_posts',	'1',	'yes'),
(70,	'close_comments_days_old',	'14',	'yes'),
(71,	'thread_comments',	'1',	'yes'),
(72,	'thread_comments_depth',	'5',	'yes'),
(73,	'page_comments',	'0',	'yes'),
(74,	'comments_per_page',	'50',	'yes'),
(75,	'default_comments_page',	'newest',	'yes'),
(76,	'comment_order',	'asc',	'yes'),
(77,	'sticky_posts',	'a:0:{}',	'yes'),
(78,	'widget_categories',	'a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(79,	'widget_text',	'a:0:{}',	'yes'),
(80,	'widget_rss',	'a:0:{}',	'yes'),
(81,	'uninstall_plugins',	'a:3:{s:29:\"safe-search-replace/index.php\";s:21:\"Ssr_Plugin::uninstall\";s:59:\"email-notification-on-login/email-notification-on-login.php\";s:20:\"apa_enol_f_uninstall\";s:20:\"worker/functions.php\";s:13:\"mwp_uninstall\";}',	'no'),
(82,	'timezone_string',	'America/Los_Angeles',	'yes'),
(84,	'page_on_front',	'2472',	'yes'),
(85,	'default_post_format',	'0',	'yes'),
(86,	'link_manager_enabled',	'0',	'yes'),
(87,	'finished_splitting_shared_terms',	'1',	'yes'),
(88,	'site_icon',	'0',	'yes'),
(89,	'medium_large_size_w',	'768',	'yes'),
(90,	'medium_large_size_h',	'0',	'yes'),
(91,	'wp_page_for_privacy_policy',	'3',	'yes'),
(92,	'show_comments_cookies_opt_in',	'1',	'yes'),
(93,	'initial_db_version',	'44719',	'yes'),
(94,	'tea_user_roles',	'a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:75:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:20:\"rocket_purge_opcache\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"edit_theme_options\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}',	'yes'),
(95,	'fresh_site',	'0',	'yes'),
(96,	'widget_search',	'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(97,	'widget_recent-posts',	'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(98,	'widget_recent-comments',	'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(99,	'widget_archives',	'a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(100,	'widget_meta',	'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(101,	'sidebars_widgets',	'a:2:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}',	'yes'),
(102,	'cron',	'a:21:{i:1709323783;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1709323832;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1709324850;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1709324855;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1709326140;a:1:{s:23:\"rocket_purge_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:34:\"rocket_expired_cache_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1709326403;a:1:{s:31:\"wptc_trigger_truncate_cron_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1709328455;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1709331475;a:1:{s:22:\"mwp_update_public_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1709345383;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1709346323;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1709348591;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1709359200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"e6888b68b3badeb26bd94a8704ba20a6\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1709359200;}}}}i:1709388582;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1709388602;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1709419047;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1709479461;a:1:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1709618400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"087256870708a63b7564b4b2b53f9543\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1709618400;}}}}i:1709682532;a:1:{s:27:\"rocket_cache_dir_size_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1709877600;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"295ca2719bfca4e4d5d2b90c2e54e27f\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1709877600;}}}}i:1709881237;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}',	'yes'),
(103,	'widget_pages',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(104,	'widget_calendar',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(105,	'widget_media_audio',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(106,	'widget_media_image',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(107,	'widget_media_gallery',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(108,	'widget_media_video',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(109,	'nonce_key',	'4XY:JwN-!bG(hjquT*c~QkJ:qR mJP<Yo2[4fnK_[6#5A6tcDt(o+;G`D*%mdX(E',	'no'),
(110,	'nonce_salt',	'K_rgIwff0$|tt77Y=dPqMA7BE1xAXIuBt?bf`*(hdM[>7M2b:E}g&mtej[&)!w=e',	'no'),
(111,	'widget_tag_cloud',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(112,	'widget_nav_menu',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(113,	'widget_custom_html',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(115,	'recovery_keys',	'a:0:{}',	'yes'),
(121,	'auth_key',	'DKa!oQ)P^;>We#t^hm4-BL~g,}vPQJC%2ET5e^yl2;o:;G([tfuEVKwxPY(vtsc:',	'no'),
(122,	'auth_salt',	'6nUEo!04@?s>bKv6k9~CmC&OZD[NC{g[DIU.MQQus^r?CIr[G.-f/F+]+6S:.7 y',	'no'),
(123,	'logged_in_key',	'/ }-($TaoQ}N,}waN!`~Q(x&<.`C8Yp3uwH+A.J||qXbix1[h;{/S+X/WT(m?FE]',	'no'),
(124,	'logged_in_salt',	'%&l;8(Xo!v+B`LvVFg_06L),DcMuu |;!O%s3pw&z-](60sF{+eF)-zi9[wB#xC]',	'no'),
(145,	'recently_activated',	'a:1:{s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:1709145966;}',	'yes'),
(146,	'dsk_authors_with_unique_name',	'a:0:{}',	'yes'),
(147,	'dsk_author_default_name',	'The Pawlowski//Mastrilli Law Group',	'yes'),
(148,	'dsk_default_author_url',	'',	'yes'),
(149,	'dsk_author_url_pref',	'0',	'yes'),
(150,	'nc_admin_theme_options',	'a:1:{s:8:\"branding\";i:2;}',	'yes'),
(151,	'nextClient_forms',	'a:5:{s:10:\"recipients\";s:23:\"phillip@megajustice.com\";s:22:\"recipientsFormSpecific\";s:0:\"\";s:7:\"subject\";s:31:\"megajustice.com Form Submission\";s:9:\"uncaptcha\";s:0:\"\";s:9:\"blacklist\";s:0:\"\";}',	'yes'),
(152,	'sendgrid_from_name',	'',	'yes'),
(153,	'sendgrid_from_email',	'',	'yes'),
(154,	'sendgrid_content_type',	'plaintext',	'yes'),
(155,	'sendgrid_mc_widget_notice_dismissed',	'true',	'yes'),
(156,	'sendgrid_port',	'587',	'yes'),
(157,	'nc_init_activated',	'1',	'yes'),
(161,	'bsr_version',	'1.3.7',	'yes'),
(162,	'c932dd40dd20e8ec23458556e8b35232',	'a:2:{s:7:\"timeout\";i:1583247666;s:5:\"value\";s:8861:\"{\"new_version\":\"1.3.7\",\"stable_version\":\"1.3.7\",\"name\":\"Better Search Replace Pro\",\"slug\":\"better-search-replace\",\"url\":\"https:\\/\\/bettersearchreplace.com\\/products\\/better-search-replace-pro\\/?changelog=1\",\"last_updated\":\"10 months ago\",\"homepage\":\"https:\\/\\/bettersearchreplace.com\\/products\\/better-search-replace-pro\\/\",\"sections\":{\"description\":\"<p>A premium database plugin that goes beyond searching and replacing to allow for one-click backups, imports, and more.<\\/p>\\n\",\"changelog\":\"<p><strong>1.3.7 - February 26, 2019<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Existing strings that match the \\\"Replace with\\\" string are not highlighted in results<\\/li>\\n<li>Fix: Some special characters interfering with search\\/replace<\\/li>\\n<li>Fix: Percentage sign not saved correctly in backups<\\/li>\\n<li>Fix: Hyphen in table name interfering with backups<\\/li>\\n<li>Security: Pass template filenames through `sanitize_file_name()`<\\/li>\\n<li>Security: Verify nonce when downloading diagnostic info<\\/li>\\n<\\/ul>\\n<p><strong>1.3.6 - January 22, 2018<\\/strong><\\/p>\\n<ul>\\n<li>Security: Store backup files in temp directory (props @Ov3rfly)<\\/li>\\n<\\/ul>\\n<p><strong>1.3.5 - January 3, 2018<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Only one table searched on some environments (props @Ov3rfly)<\\/li>\\n<\\/ul>\\n<p><strong>1.3.4 - September 18, 2017<\\/strong><\\/p>\\n<ul>\\n<li>Security: Check if data is serialized before unserializing it<\\/li>\\n<li>Improvement: Increased size of table select<\\/li>\\n<li>Improvement: Updated plugin updater class<\\/li>\\n<li>Improvement: Max Results setting added to diagnostic info for easier troubleshooting<\\/li>\\n<li>Fix: Profiles with quotes in name not working correctly<\\/li>\\n<li>Fix: Updated links on plugin help tab<\\/li>\\n<\\/ul>\\n<p><strong>1.3.3 - November 10, 2016<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Outdated links to old website<\\/li>\\n<li>Fix: Prevent requests to invalid tabs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.2 - June 2, 2016<\\/strong><\\/p>\\n<ul>\\n<li>Fix: CSS not loaded on details page<\\/li>\\n<\\/ul>\\n<p><strong>1.3.1 - December 8, 2015<\\/strong><\\/p>\\n<ul>\\n<li>Added: Link to pro support and documentation in help tab<\\/li>\\n<li>Tweak: \\\"Back to Overview\\\" link now fixed to top of \\\"View Details\\\" box<\\/li>\\n<li>Fix: Bug with case-insensitive searches in serialized objects<\\/li>\\n<li>Fix: Bug with early skip due to lack of primary key<\\/li>\\n<\\/ul>\\n<p><strong>1.3 - November 24, 2015<\\/strong><\\/p>\\n<ul>\\n<li>Added Gzip support for backups and imports<\\/li>\\n<li>Added ability to run a search\\/replace profile on a backup<\\/li>\\n<li>Small bugfixes<\\/li>\\n<\\/ul>\\n<p><strong>1.2.7<\\/strong><\\/p>\\n<ul>\\n<li>Small cleanup<\\/li>\\n<li>Improved styles and wording for license status<\\/li>\\n<li>Updated translations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.6<\\/strong><\\/p>\\n<ul>\\n<li>Added ability to change the number of results saved for reviewing<\\/li>\\n<li>Improved progress bar info and styles<\\/li>\\n<li>Small cleanup<\\/li>\\n<\\/ul>\\n<p><strong>1.2.5<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue preventing profiles from loading<\\/li>\\n<\\/ul>\\n<p><strong>1.2.4<\\/strong><\\/p>\\n<ul>\\n<li>Added \\\"Settings saved\\\" notice when saving settings<\\/li>\\n<li>Fixed bug with wp_magic_quotes interfering with some search strings<\\/li>\\n<\\/ul>\\n<p><strong>1.2.3<\\/strong><\\/p>\\n<ul>\\n<li>Fixed bug with searching for backslashes<\\/li>\\n<li>Fixed potential bug with getting tables in large multisites<\\/li>\\n<li>Fixed potential notice in append_report<\\/li>\\n<li>Fixed bug with saving profiles with some special characters<\\/li>\\n<li>Improved handling of missing primary keys<\\/li>\\n<\\/ul>\\n<p><strong>1.2.2<\\/strong><\\/p>\\n<ul>\\n<li>Fixed AJAX conflict with WooCommerce<\\/li>\\n<li>Fixed a few issues with translations<\\/li>\\n<li>Tweaked \\\"System Info\\\" to use get_locale() instead of WP_LANG constant<\\/li>\\n<li>Updated German translation (props @Linus Ziegenhagen)<\\/li>\\n<\\/ul>\\n<p><strong>1.2.1<\\/strong><\\/p>\\n<ul>\\n<li>Fixed minor issue with display of progress bar<\\/li>\\n<li>Updated translation file<\\/li>\\n<\\/ul>\\n<p><strong>1.2<\\/strong><\\/p>\\n<ul>\\n<li>Switched to AJAX bulk processing<\\/li>\\n<li>Decreased minimum \\\"Max Page Size\\\" to 1,000<\\/li>\\n<li>Bugfixes and improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.1<\\/strong><\\/p>\\n<ul>\\n<li>Decreased default page size for better performance on shared hosting\\/large DBs<\\/li>\\n<li>Misc bugfixes and small cleanup<\\/li>\\n<\\/ul>\\n<p><strong>1.1<\\/strong><\\/p>\\n<ul>\\n<li>Initial release of pro version<\\/li>\\n<\\/ul>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":\"a:2:{s:2:\\\"1x\\\";s:71:\\\"https:\\/\\/bettersearchreplace.com\\/content\\/uploads\\/edd\\/2015\\/09\\/bsr-pro.png\\\";s:2:\\\"2x\\\";s:71:\\\"https:\\/\\/bettersearchreplace.com\\/content\\/uploads\\/edd\\/2015\\/09\\/bsr-pro.png\\\";}\",\"description\":[\"<p>A premium database plugin that goes beyond searching and replacing to allow for one-click backups, imports, and more.<\\/p>\\n\"],\"changelog\":[\"<p><strong>1.3.7 - February 26, 2019<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Existing strings that match the \\\"Replace with\\\" string are not highlighted in results<\\/li>\\n<li>Fix: Some special characters interfering with search\\/replace<\\/li>\\n<li>Fix: Percentage sign not saved correctly in backups<\\/li>\\n<li>Fix: Hyphen in table name interfering with backups<\\/li>\\n<li>Security: Pass template filenames through `sanitize_file_name()`<\\/li>\\n<li>Security: Verify nonce when downloading diagnostic info<\\/li>\\n<\\/ul>\\n<p><strong>1.3.6 - January 22, 2018<\\/strong><\\/p>\\n<ul>\\n<li>Security: Store backup files in temp directory (props @Ov3rfly)<\\/li>\\n<\\/ul>\\n<p><strong>1.3.5 - January 3, 2018<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Only one table searched on some environments (props @Ov3rfly)<\\/li>\\n<\\/ul>\\n<p><strong>1.3.4 - September 18, 2017<\\/strong><\\/p>\\n<ul>\\n<li>Security: Check if data is serialized before unserializing it<\\/li>\\n<li>Improvement: Increased size of table select<\\/li>\\n<li>Improvement: Updated plugin updater class<\\/li>\\n<li>Improvement: Max Results setting added to diagnostic info for easier troubleshooting<\\/li>\\n<li>Fix: Profiles with quotes in name not working correctly<\\/li>\\n<li>Fix: Updated links on plugin help tab<\\/li>\\n<\\/ul>\\n<p><strong>1.3.3 - November 10, 2016<\\/strong><\\/p>\\n<ul>\\n<li>Fix: Outdated links to old website<\\/li>\\n<li>Fix: Prevent requests to invalid tabs<\\/li>\\n<\\/ul>\\n<p><strong>1.3.2 - June 2, 2016<\\/strong><\\/p>\\n<ul>\\n<li>Fix: CSS not loaded on details page<\\/li>\\n<\\/ul>\\n<p><strong>1.3.1 - December 8, 2015<\\/strong><\\/p>\\n<ul>\\n<li>Added: Link to pro support and documentation in help tab<\\/li>\\n<li>Tweak: \\\"Back to Overview\\\" link now fixed to top of \\\"View Details\\\" box<\\/li>\\n<li>Fix: Bug with case-insensitive searches in serialized objects<\\/li>\\n<li>Fix: Bug with early skip due to lack of primary key<\\/li>\\n<\\/ul>\\n<p><strong>1.3 - November 24, 2015<\\/strong><\\/p>\\n<ul>\\n<li>Added Gzip support for backups and imports<\\/li>\\n<li>Added ability to run a search\\/replace profile on a backup<\\/li>\\n<li>Small bugfixes<\\/li>\\n<\\/ul>\\n<p><strong>1.2.7<\\/strong><\\/p>\\n<ul>\\n<li>Small cleanup<\\/li>\\n<li>Improved styles and wording for license status<\\/li>\\n<li>Updated translations<\\/li>\\n<\\/ul>\\n<p><strong>1.2.6<\\/strong><\\/p>\\n<ul>\\n<li>Added ability to change the number of results saved for reviewing<\\/li>\\n<li>Improved progress bar info and styles<\\/li>\\n<li>Small cleanup<\\/li>\\n<\\/ul>\\n<p><strong>1.2.5<\\/strong><\\/p>\\n<ul>\\n<li>Fixed issue preventing profiles from loading<\\/li>\\n<\\/ul>\\n<p><strong>1.2.4<\\/strong><\\/p>\\n<ul>\\n<li>Added \\\"Settings saved\\\" notice when saving settings<\\/li>\\n<li>Fixed bug with wp_magic_quotes interfering with some search strings<\\/li>\\n<\\/ul>\\n<p><strong>1.2.3<\\/strong><\\/p>\\n<ul>\\n<li>Fixed bug with searching for backslashes<\\/li>\\n<li>Fixed potential bug with getting tables in large multisites<\\/li>\\n<li>Fixed potential notice in append_report<\\/li>\\n<li>Fixed bug with saving profiles with some special characters<\\/li>\\n<li>Improved handling of missing primary keys<\\/li>\\n<\\/ul>\\n<p><strong>1.2.2<\\/strong><\\/p>\\n<ul>\\n<li>Fixed AJAX conflict with WooCommerce<\\/li>\\n<li>Fixed a few issues with translations<\\/li>\\n<li>Tweaked \\\"System Info\\\" to use get_locale() instead of WP_LANG constant<\\/li>\\n<li>Updated German translation (props @Linus Ziegenhagen)<\\/li>\\n<\\/ul>\\n<p><strong>1.2.1<\\/strong><\\/p>\\n<ul>\\n<li>Fixed minor issue with display of progress bar<\\/li>\\n<li>Updated translation file<\\/li>\\n<\\/ul>\\n<p><strong>1.2<\\/strong><\\/p>\\n<ul>\\n<li>Switched to AJAX bulk processing<\\/li>\\n<li>Decreased minimum \\\"Max Page Size\\\" to 1,000<\\/li>\\n<li>Bugfixes and improvements<\\/li>\\n<\\/ul>\\n<p><strong>1.1.1<\\/strong><\\/p>\\n<ul>\\n<li>Decreased default page size for better performance on shared hosting\\/large DBs<\\/li>\\n<li>Misc bugfixes and small cleanup<\\/li>\\n<\\/ul>\\n<p><strong>1.1<\\/strong><\\/p>\\n<ul>\\n<li>Initial release of pro version<\\/li>\\n<\\/ul>\\n\"]}\";}',	'no'),
(163,	'dsk_preview_mode_ips',	'a:31:{i:0;s:15:\"205.251.150.146\";i:1;s:12:\"72.18.14.162\";i:2;s:12:\"82.165.25.77\";i:3;s:13:\"72.186.235.28\";i:4;s:14:\"198.77.226.180\";i:5;s:12:\"47.200.114.9\";i:6;s:11:\"97.76.20.98\";i:7;s:15:\"189.143.211.103\";i:8;s:14:\"198.72.142.155\";i:9;s:13:\"107.72.162.32\";i:10;s:15:\"172.114.236.236\";i:11;s:13:\"35.137.50.122\";i:12;s:13:\"47.39.102.210\";i:13;s:13:\"76.168.14.240\";i:14;s:13:\"24.73.209.174\";i:15;s:15:\"189.143.113.188\";i:16;s:13:\"104.32.248.16\";i:17;s:15:\"189.143.125.134\";i:18;s:13:\"71.100.230.98\";i:19;s:15:\"189.143.107.117\";i:20;s:12:\"76.170.99.26\";i:21;s:14:\"172.250.246.76\";i:22;s:15:\"189.143.127.219\";i:23;s:14:\"162.253.68.164\";i:24;s:12:\"71.104.62.82\";i:25;s:13:\"66.192.111.82\";i:26;s:14:\"172.117.132.15\";i:27;s:12:\"73.202.38.90\";i:28;s:15:\"189.143.250.173\";i:29;s:12:\"174.250.28.2\";i:30;s:15:\"189.143.222.228\";}',	'yes'),
(164,	'theme_mods_universal',	'a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1578101288;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}s:18:\"nav_menu_locations\";a:1:{s:8:\"main-nav\";i:386;}}',	'yes'),
(173,	'page_for_posts',	'338',	'yes'),
(203,	'sendgrid_asm_permission',	'false',	'yes'),
(205,	'sendgrid_api_key',	'',	'yes'),
(206,	'sendgrid_reply_to',	'',	'yes'),
(207,	'sendgrid_categories',	'',	'yes'),
(208,	'sendgrid_stats_categories',	'',	'yes'),
(209,	'sendgrid_template',	'',	'yes'),
(210,	'sendgrid_api',	'api',	'yes'),
(236,	'current_theme',	'The Pawlowski//Mastrilli Law Group',	'yes'),
(237,	'theme_mods_pawlowski-mastrilli-law-group',	'a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:8:\"main-nav\";i:386;s:10:\"footer-nav\";i:385;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1578101285;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}',	'yes'),
(238,	'theme_switched',	'',	'yes'),
(239,	'nav_menu_options',	'a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}',	'yes'),
(334,	'WPLANG',	'',	'yes'),
(335,	'new_admin_email',	'cms@site-mail.com',	'yes'),
(746,	'admin_email_lifespan',	'1723388050',	'yes'),
(747,	'db_upgraded',	'',	'yes'),
(759,	'dsk_ga_phones',	'a:1:{s:12:\"phonenumbers\";s:96:\"877-242-4404\r\n813-242-4404\r\n813-279-7654\r\n727-800-7654\r\n727-203-7654\r\n863-337-7654\r\n813-492-7654\";}',	'yes'),
(790,	'secure_auth_key',	']IJP]J,=<tFPdJ-UW!RH-B6f^SCIHTr)7wM!aL(:@wf#Pm}(N=](b<K! Cd_H47B',	'no'),
(791,	'secure_auth_salt',	'(3XqJlxHj:-:Ev #Um2UXMa@ME*A9@Y+o?K@t0AJuuzobYnvYGFSzrDUqd1xVSwU',	'no'),
(796,	'aFhfc_site_wide_head_code',	'<!-- Global site tag (gtag.js) - Google Analytics -->\r\n<script async src=\"https://www.googletagmanager.com/gtag/js?id=UA-71217301-1\"></script>\r\n<script>\r\n  window.dataLayer = window.dataLayer || [];\r\n  function gtag(){dataLayer.push(arguments);}\r\n  gtag(\'js\', new Date());\r\n\r\n  gtag(\'config\', \'UA-71217301-1\');\r\n</script>\r\n\r\n<meta name=\"msvalidate.01\" content=\"5EAB83AA00205A57BAEC6276EE4757C4\" />\r\n\r\n<!-- Google Tag Manager -->\r\n<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({\'gtm.start\':\r\nnew Date().getTime(),event:\'gtm.js\'});var f=d.getElementsByTagName(s)[0],\r\nj=d.createElement(s),dl=l!=\'dataLayer\'?\'&l=\'+l:\'\';j.async=true;j.src=\r\n\'https://www.googletagmanager.com/gtm.js?id=\'+i+dl;f.parentNode.insertBefore(j,f);\r\n})(window,document,\'script\',\'dataLayer\',\'GTM-TVDLG3Z\');</script>\r\n<!-- End Google Tag Manager -->\r\n\r\n<script type=\"application/ld+json\">\r\n{\r\n  \"@context\": \"https://schema.org\",\r\n  \"@type\": \"LegalService\",\r\n  \"name\": \"Pawlowski//Mastrilli Law Group\",\r\n  \"image\": \"https://www.megajustice.com/wp-content/themes/pawlowski-mastrilli-law-group/img/header/header-logo.png\",\r\n  \"@id\": \"https://www.megajustice.com/\",\r\n  \"url\": \"https://www.megajustice.com/\",\r\n  \"telephone\": \"813-242-4404\",\r\n  \"priceRange\": \"Free Consultation\",\r\n  \"address\": {\r\n    \"@type\": \"PostalAddress\",\r\n    \"streetAddress\": \"1401 East 22nd Avenue\",\r\n    \"addressLocality\": \"Tampa\",\r\n    \"addressRegion\": \"FL\",\r\n    \"postalCode\": \"33605\",\r\n    \"addressCountry\": \"US\"\r\n  },\r\n  \"geo\": {\r\n    \"@type\": \"GeoCoordinates\",\r\n    \"latitude\": 27.9604864,\r\n    \"longitude\": -82.4398104\r\n  },\r\n  \"openingHoursSpecification\": {\r\n    \"@type\": \"OpeningHoursSpecification\",\r\n    \"dayOfWeek\": [\r\n      \"Monday\",\r\n      \"Tuesday\",\r\n      \"Wednesday\",\r\n      \"Thursday\",\r\n      \"Friday\",\r\n      \"Saturday\",\r\n      \"Sunday\"\r\n    ],\r\n    \"opens\": \"00:00\",\r\n    \"closes\": \"23:59\"\r\n  },\r\n  \"sameAs\": [\r\n    \"https://www.facebook.com/PersonalInjuryLawyersTampaFL\",\r\n    \"https://www.linkedin.com/in/vincent-pawlowski-05178b5/\"\r\n  ]\r\n}\r\n</script>\r\n\r\n<script type=\"application/ld+json\">\r\n{\r\n  \"@context\": \"http://schema.org\",\r\n  \"@type\": \"Product\",\r\n  \"aggregateRating\": {\r\n    \"@type\": \"AggregateRating\",\r\n    \"ratingValue\": \"4.1\",\r\n    \"reviewCount\": \"47\"\r\n  },\r\n  \"description\": \"The Pawlowski//Mastrilli Law Group is a full-service law firm, that has been fighting for the injured and accused for over 25 years.\",\r\n  \"name\": \"Pawlowski//Mastrilli Law Group\",\r\n  \"image\": \"https://www.megajustice.com/wp-content/themes/pawlowski-mastrilli-law-group/img/header/header-logo.png\",\r\n  \"review\": [\r\n    {\r\n      \"@type\": \"Review\",\r\n      \"author\": \"Cassandra Oblak\",\r\n      \"datePublished\": \"2019-12-23\",\r\n      \"description\": \"Highly recommend them. I\'ve used them twice.\",\r\n      \"name\": \"Highly recommend\",\r\n      \"reviewRating\": {\r\n        \"@type\": \"Rating\",\r\n        \"bestRating\": \"5\",\r\n        \"ratingValue\": \"5\",\r\n        \"worstRating\": \"0\"\r\n      }\r\n    }\r\n  ]\r\n}\r\n</script>\r\n\r\n<script async src=\"//237053.tctm.co/t.js\"></script>',	'yes'),
(797,	'aFhfc_head_code_priority',	'',	'yes'),
(798,	'aFhfc_site_wide_body_code',	'<!-- Google Tag Manager (noscript) -->\r\n<noscript><iframe src=\"https://www.googletagmanager.com/ns.html?id=GTM-TVDLG3Z\"\r\nheight=\"0\" width=\"0\" style=\"display:none;visibility:hidden\"></iframe></noscript>\r\n<!-- End Google Tag Manager (noscript) -->',	'yes'),
(799,	'aFhfc_site_wide_footer_code',	'',	'yes'),
(800,	'aFhfc_footer_code_priority',	'',	'yes'),
(849,	'manage-multiple-blogs',	'a:2:{s:5:\"blogs\";a:0:{}s:12:\"current_blog\";a:1:{s:4:\"type\";N;}}',	'yes'),
(850,	'iwp_client_activate_key',	'a03467f87229593a27064dc8813e43dbf871d0a4',	'yes'),
(851,	'iwp_client_all_plugins_history',	'a:20:{s:53:\"addfunc-head-footer-code/addfunc-head-footer-code.php\";s:3:\"2.3\";s:45:\"classic-editor-addon/classic-editor-addon.php\";s:5:\"4.3.0\";s:33:\"disable-emojis/disable-emojis.php\";s:5:\"1.7.6\";s:45:\"disable-lazy-loading/disable-lazy-loading.php\";s:3:\"1.9\";s:43:\"dsk-404-to-301-home/dsk-404-to-301-home.php\";s:5:\"0.9.6\";s:33:\"dsk-open-graph/dsk-open-graph.php\";s:5:\"1.0.3\";s:41:\"dsk-remove-wp-junk/dsk-remove-wp-junk.php\";s:5:\"1.0.1\";s:19:\"dsk-seo/dsk-seo.php\";s:5:\"1.1.5\";s:39:\"dsk-site-features/dsk-site-features.php\";s:5:\"0.9.8\";s:51:\"dsk-wcag-theme-switcher/dsk-wcag-theme-switcher.php\";s:5:\"1.1.0\";s:15:\"worker/init.php\";s:6:\"4.9.19\";s:49:\"dsk-public-author-info/dsk-public-author-info.php\";s:5:\"1.0.1\";s:49:\"sendgrid-email-delivery-simplified/wpsendgrid.php\";s:6:\"1.11.8\";s:45:\"simple-page-ordering/simple-page-ordering.php\";s:5:\"2.6.3\";s:37:\"subslide-chooser/subslide-chooser.php\";s:3:\"1.0\";s:43:\"website-admin-theme/website-admin-theme.php\";s:5:\"1.0.4\";s:31:\"website-forms/website-forms.php\";s:9:\"101.4.7.1\";s:23:\"wordfence/wordfence.php\";s:6:\"7.11.3\";s:23:\"wp-rocket/wp-rocket.php\";s:6:\"3.15.9\";s:32:\"xml-sitemap-feed/xml-sitemap.php\";s:5:\"5.4.5\";}',	'yes'),
(852,	'iwp_client_all_themes_history',	'a:5:{s:29:\"pawlowski-mastrilli-law-group\";s:5:\"100.0\";s:16:\"twentytwentyfour\";s:3:\"1.0\";s:17:\"twentytwentythree\";s:3:\"1.3\";s:15:\"twentytwentytwo\";s:3:\"1.6\";s:12:\"universal_mm\";s:5:\"1.2.6\";}',	'yes'),
(853,	'iwp_client_wp_version_old',	'6.4.3',	'yes'),
(854,	'iwp_client_replaced_old_hash_backup_files',	'1',	'yes'),
(855,	'iwp_backup_table_version',	'1.1.5',	'yes'),
(856,	'iwp_backup_processed_iterator_version',	'1.0.0',	'yes'),
(857,	'iwp_client_public_key',	'LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUExM29PQURlU3lyYVN1KzJKcHhPZwpMVHo2ZjRKOFFBRERrWTBYNUcyMnVTUUVQUUJYTDdXU3EvQVpwcXFveW9odU92TGhKaXNZL0NhbVEwRFRxa1dXCmVHOFQ1OEMrYXZxb1pWRTJzSDgwNGNGd0JteFBCUWJPS2JkbUYrQTBsc2xRSmJMd2g1TUM1Q1pzaDlNd0VOOU4KWnJncjg1Y2hFVTdVaFVtMnpNRE5WUWp5SU83cis2bklxSVdQdXN0NG1uOXlMV2JHRE1EQnNrVjZJamZEamNkdgp0WEovNWx5cEd1TThmR3crMWhkb3hUcFU4bitvYSt0WmMxYnA3OTdESDdxNFVYdy9FZFJDaDdPL0hlYUg1NWxxCk02US9TekJIRUtUd1BZL2FQZGhIMEI1STdsMjVwSE04SjM4ZGVMa1MxRHhuVExJaldEbHZseWFSYUFaWDUzVnkKVlFJREFRQUIKLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg==',	'yes'),
(858,	'iwp_client_action_message_id',	'5211911',	'yes'),
(859,	'is_save_activity_log',	'1',	'yes'),
(865,	'wordfence_ls_version',	'1.1.9',	'yes'),
(866,	'wordfence_version',	'7.11.3',	'yes'),
(867,	'wordfence_case',	'1',	'yes'),
(868,	'wordfence_installed',	'1',	'yes'),
(869,	'wordfenceActivated',	'1',	'yes'),
(870,	'wf_plugin_act_error',	'',	'yes'),
(880,	'wordfence_syncAttackDataAttempts',	'0',	'no'),
(882,	'wordfence_syncingAttackData',	'0',	'no'),
(883,	'wordfence_lastSyncAttackData',	'1709320703',	'no'),
(912,	'xmlsf_sitemaps',	'a:1:{s:7:\"sitemap\";s:11:\"sitemap.xml\";}',	'yes'),
(913,	'xmlsf_post_types',	'a:2:{s:4:\"post\";a:5:{s:6:\"active\";s:1:\"1\";s:7:\"archive\";s:6:\"yearly\";s:8:\"priority\";s:3:\"0.7\";s:16:\"dynamic_priority\";s:1:\"1\";s:4:\"tags\";a:1:{s:5:\"image\";s:8:\"featured\";}}s:4:\"page\";a:3:{s:6:\"active\";s:1:\"1\";s:8:\"priority\";s:3:\"0.9\";s:4:\"tags\";a:1:{s:5:\"image\";s:8:\"attached\";}}}',	'yes'),
(914,	'xmlsf_taxonomies',	'',	'yes'),
(915,	'xmlsf_taxonomy_settings',	'a:4:{s:6:\"active\";s:0:\"\";s:8:\"priority\";s:3:\"0.3\";s:16:\"dynamic_priority\";s:1:\"1\";s:5:\"limit\";s:4:\"5000\";}',	'yes'),
(917,	'xmlsf_robots',	'',	'no'),
(918,	'xmlsf_urls',	'',	'yes'),
(919,	'xmlsf_custom_sitemaps',	'',	'yes'),
(921,	'xmlsf_version',	'5.4.5',	'yes'),
(943,	'iwp_client_brand',	'a:8:{s:4:\"name\";N;s:4:\"desc\";N;s:6:\"author\";N;s:10:\"author_url\";N;s:4:\"hide\";s:1:\"1\";s:10:\"hideFWPCPB\";i:0;s:12:\"doChangesCPB\";N;s:14:\"hideUpdatesCPB\";i:0;}',	'yes'),
(949,	'wptc-premium-extensions',	'a:0:{}',	'no'),
(951,	'is_wptc_activation_redirected',	'1',	'yes'),
(1142,	'iwp_client_backup_tasks',	'a:2:{s:15:\"backhack_status\";a:5:{s:14:\"adminHistoryID\";i:5010695;s:7:\"db_dump\";a:2:{s:5:\"start\";d:1703396866.9936389923095703125;s:3:\"end\";d:1703396867.8712470531463623046875;}s:6:\"db_zip\";a:2:{s:5:\"start\";d:1703396867.8796699047088623046875;s:3:\"end\";d:1703396868.184832096099853515625;}s:7:\"dropbox\";a:2:{s:5:\"start\";d:1703396868.193264007568359375;s:3:\"end\";d:1703396870.896521091461181640625;}s:8:\"finished\";a:1:{s:3:\"end\";d:1703396870.909864902496337890625;}}s:12:\"task_results\";a:1:{i:5010695;a:6:{s:4:\"size\";s:8:\"22.58 MB\";s:11:\"backup_name\";s:9:\"All Sites\";s:9:\"mechanism\";s:10:\"singleCall\";s:4:\"time\";i:1703396868;s:14:\"adminHistoryID\";i:5010695;s:7:\"dropbox\";s:81:\"megajustice.com_scheduleBackup_db_2023-12-24_ff45db59652464ec32e864f4889e539b.zip\";}}}',	'yes'),
(1381,	'recovery_mode_email_last_sent',	'1578411879',	'yes'),
(1528,	'dsk_site_features',	'a:6:{s:20:\"multilingual_support\";i:0;s:13:\"g_amp_support\";i:0;s:12:\"mhmi_support\";i:1;s:14:\"mobile_support\";i:0;s:12:\"wcag_support\";i:0;s:13:\"ada_m_support\";i:1;}',	'yes'),
(1535,	'wp_rocket_settings',	'a:86:{s:12:\"cache_mobile\";i:1;s:23:\"do_caching_mobile_files\";i:1;s:19:\"purge_cron_interval\";i:7;s:15:\"purge_cron_unit\";s:14:\"DAY_IN_SECONDS\";s:11:\"minify_html\";i:1;s:11:\"exclude_css\";a:0:{}s:12:\"critical_css\";s:0:\"\";s:17:\"exclude_inline_js\";a:0:{}s:10:\"exclude_js\";a:0:{}s:17:\"defer_all_js_safe\";i:1;s:5:\"emoji\";i:1;s:6:\"embeds\";i:1;s:8:\"sitemaps\";a:0:{}s:12:\"dns_prefetch\";a:0:{}s:16:\"cache_reject_uri\";a:0:{}s:20:\"cache_reject_cookies\";a:0:{}s:15:\"cache_reject_ua\";a:0:{}s:17:\"cache_purge_pages\";a:0:{}s:19:\"cache_query_strings\";a:0:{}s:27:\"automatic_cleanup_frequency\";s:0:\"\";s:10:\"cdn_cnames\";a:0:{}s:8:\"cdn_zone\";a:0:{}s:16:\"cdn_reject_files\";a:0:{}s:24:\"heartbeat_admin_behavior\";s:18:\"reduce_periodicity\";s:25:\"heartbeat_editor_behavior\";s:18:\"reduce_periodicity\";s:23:\"heartbeat_site_behavior\";s:18:\"reduce_periodicity\";s:18:\"cloudflare_api_key\";s:0:\"\";s:16:\"cloudflare_email\";s:0:\"\";s:18:\"cloudflare_zone_id\";s:0:\"\";s:18:\"sucury_waf_api_key\";s:0:\"\";s:12:\"consumer_key\";s:8:\"ca4a4638\";s:14:\"consumer_email\";s:18:\"cms@nextclient.com\";s:10:\"secret_key\";s:8:\"263bcbd8\";s:7:\"license\";s:10:\"1575325286\";s:16:\"secret_cache_key\";s:22:\"5e1518e46228f923221528\";s:14:\"minify_css_key\";s:22:\"65cb84e4b3ac5004079626\";s:13:\"minify_js_key\";s:22:\"65cb84e4b3acb332600656\";s:7:\"version\";s:6:\"3.15.9\";s:23:\"cloudflare_old_settings\";s:0:\"\";s:25:\"sitemap_preload_url_crawl\";s:6:\"500000\";s:9:\"cache_ssl\";i:1;s:7:\"do_beta\";i:0;s:17:\"cache_logged_user\";i:0;s:19:\"minify_google_fonts\";i:0;s:10:\"minify_css\";i:0;s:9:\"minify_js\";i:0;s:22:\"minify_concatenate_css\";i:0;s:21:\"minify_concatenate_js\";i:0;s:12:\"defer_all_js\";i:0;s:8:\"lazyload\";i:0;s:16:\"lazyload_iframes\";i:0;s:16:\"lazyload_youtube\";i:0;s:20:\"remove_query_strings\";i:0;s:9:\"async_css\";i:0;s:18:\"database_revisions\";i:0;s:20:\"database_auto_drafts\";i:0;s:22:\"database_trashed_posts\";i:0;s:22:\"database_spam_comments\";i:0;s:25:\"database_trashed_comments\";i:0;s:27:\"database_expired_transients\";i:0;s:23:\"database_all_transients\";i:0;s:24:\"database_optimize_tables\";i:0;s:26:\"schedule_automatic_cleanup\";i:0;s:14:\"manual_preload\";i:0;s:15:\"sitemap_preload\";i:0;s:13:\"do_cloudflare\";i:0;s:18:\"cloudflare_devmode\";i:0;s:24:\"cloudflare_auto_settings\";i:0;s:27:\"cloudflare_protocol_rewrite\";i:0;s:21:\"sucury_waf_cache_sync\";i:0;s:17:\"control_heartbeat\";i:0;s:3:\"cdn\";i:0;s:18:\"varnish_auto_purge\";i:0;s:16:\"async_css_mobile\";i:0;s:13:\"preload_fonts\";a:0:{}s:8:\"delay_js\";i:0;s:16:\"delay_js_scripts\";a:43:{i:0;s:12:\"getbutton.io\";i:1;s:18:\"/app/js/api.min.js\";i:2;s:67:\"feedbackcompany.com/includes/widgets/feedback-company-widget.min.js\";i:3;s:46:\"snap.licdn.com/li.lms-analytics/insight.min.js\";i:4;s:29:\"static.ads-twitter.com/uwt.js\";i:5;s:31:\"platform.twitter.com/widgets.js\";i:6;s:4:\"twq(\";i:7;s:7:\"/sdk.js\";i:8;s:46:\"static.leadpages.net/leadbars/current/embed.js\";i:9;s:43:\"translate.google.com/translate_a/element.js\";i:10;s:19:\"widget.manychat.com\";i:11;s:21:\"xfbml.customerchat.js\";i:12;s:27:\"static.hotjar.com/c/hotjar-\";i:13;s:27:\"smartsuppchat.com/loader.js\";i:14;s:18:\"grecaptcha.execute\";i:15;s:8:\"Tawk_API\";i:16;s:11:\"shareaholic\";i:17;s:9:\"sharethis\";i:18;s:26:\"simple-share-buttons-adder\";i:19;s:8:\"addtoany\";i:20;s:12:\"font-awesome\";i:21;s:8:\"wpdiscuz\";i:22;s:15:\"cookie-law-info\";i:23;s:8:\"pinit.js\";i:24;s:8:\"/gtag/js\";i:25;s:5:\"gtag(\";i:26;s:7:\"/gtm.js\";i:27;s:5:\"/gtm-\";i:28;s:11:\"fbevents.js\";i:29;s:4:\"fbq(\";i:30;s:33:\"google-analytics.com/analytics.js\";i:31;s:5:\"ga( \'\";i:32;s:4:\"ga(\'\";i:33;s:10:\"ShopifyBuy\";i:34;s:13:\"ft.sdk.min.js\";i:35;s:31:\"apps.elfsight.com/p/platform.js\";i:36;s:27:\"livechatinc.com/tracking.js\";i:37;s:14:\"LiveChatWidget\";i:38;s:27:\"/busting/facebook-tracking/\";i:39;s:5:\"olark\";i:40;s:32:\"pixel-caffeine/build/frontend.js\";i:41;s:31:\"widget.trustpilot.com/bootstrap\";i:42;s:14:\"adsbygoogle.js\";}s:16:\"exclude_defer_js\";a:1:{i:0;s:42:\"/jquery-?[0-9.]*(.min|.slim|.slim.min)?.js\";}s:16:\"image_dimensions\";i:0;s:16:\"exclude_lazyload\";a:0:{}s:19:\"delay_js_exclusions\";a:0:{}s:17:\"remove_unused_css\";i:0;s:26:\"remove_unused_css_safelist\";a:0:{}s:20:\"preload_excluded_uri\";a:0:{}s:28:\"delay_js_exclusions_selected\";a:0:{}s:39:\"delay_js_exclusions_selected_exclusions\";a:0:{}}',	'yes'),
(1545,	'rocket_analytics_notice_displayed',	'1',	'yes'),
(13487,	'bsr_data',	'a:11:{s:13:\"select_tables\";a:1:{i:0;s:12:\"tea_postmeta\";}s:16:\"case_insensitive\";s:3:\"off\";s:13:\"replace_guids\";s:3:\"off\";s:7:\"dry_run\";s:2:\"on\";s:10:\"search_for\";s:12:\"877-242-4404\";s:12:\"replace_with\";s:12:\"813-803-6518\";s:15:\"completed_pages\";i:1;s:9:\"is_import\";b:0;s:9:\"is_backup\";b:0;s:12:\"save_profile\";s:0:\"\";s:11:\"total_pages\";i:1;}',	'yes'),
(18751,	'_transient_health-check-site-status-result',	'{\"good\":\"18\",\"recommended\":\"6\",\"critical\":\"1\"}',	'yes'),
(38644,	'disallowed_keys',	'',	'no'),
(38645,	'comment_previously_approved',	'1',	'yes'),
(38646,	'auto_plugin_theme_update_emails',	'a:0:{}',	'no'),
(38647,	'finished_updating_comment_type',	'1',	'yes'),
(49134,	'category_children',	'a:0:{}',	'yes'),
(56470,	'auto_update_core_dev',	'enabled',	'yes'),
(56471,	'auto_update_core_minor',	'enabled',	'yes'),
(56472,	'auto_update_core_major',	'unset',	'yes'),
(69596,	'https_detection_errors',	'a:0:{}',	'yes'),
(71535,	'wfls_last_role_change',	'1708032440',	'no'),
(85931,	'wpr_rucss_used_css_version',	'20220121',	'yes'),
(87708,	'widget_block',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(93984,	'wp_force_deactivated_plugins',	'a:0:{}',	'yes'),
(107178,	'xmlsf_authors',	'',	'yes'),
(107179,	'xmlsf_author_settings',	'a:3:{s:6:\"active\";s:1:\"1\";s:8:\"priority\";s:3:\"0.3\";s:5:\"limit\";s:4:\"1000\";}',	'yes'),
(119929,	'iwp_mu_plugin_version',	'1.0.1',	'yes'),
(177115,	'action_scheduler_hybrid_store_demarkation',	'7916',	'yes'),
(177116,	'schema-ActionScheduler_StoreSchema',	'6.0.1649822603',	'yes'),
(177117,	'schema-ActionScheduler_LoggerSchema',	'3.0.1649822603',	'yes'),
(177132,	'action_scheduler_lock_async-request-runner',	'1709310042',	'yes'),
(311573,	'user_count',	'2',	'no'),
(378476,	'wpr_rocket_cache_version',	'20220927',	'yes'),
(489508,	'rocket_cache_dir_size_check',	'1',	'yes'),
(727578,	'wp_rocket_no_licence',	'0',	'yes'),
(795674,	'wp_rocket_last_base_url',	'aHR0cHM6Ly93d3cubWVnYWp1c3RpY2UuY29tLw==',	'yes'),
(866982,	'wp_attachment_pages_enabled',	'1',	'yes'),
(903099,	'can_compress_scripts',	'0',	'yes'),
(907059,	'iwp_file_list_table_version',	'1.1',	'yes'),
(907428,	'IWP_lastmessage',	'/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content/plugins/iwp-client/backup/backup.core.class.php-- line--2556--function--iwp_update_option (Feb 29 23:34:30)',	'yes'),
(907977,	'IWP_dropbox',	'a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:6:\"folder\";s:5:\"daily\";s:15:\"tk_access_token\";s:856:\"/rbEBITcbTJUqphLQEVfuBndlfTmonfEIUbgr/3U/fwqSYbLEEfDgl3UNZmtWZKwPdXQGIAC0ZIlKGr590NiaTHnwMeuFuVEEofYXavM9QL8spQxtYMLSc+zJxD+pr5WzkD5UpeU6EV3VxG/lRyG4zgn3DlwJRvebeApCBjiIH+STx6XwcX1KTvnK7jfmmqGOV7uCbzobut9GPCXNSld03CgjSnv5fkVRbuwdbxqzByrUnyMiFUEQo+MsTeidAkCDDYjnjqjPtFK1wWPKfSfaLUnia3hRP7h24ue9EXkpApzm47sgPzYLVOh7qoFhGppv5OfMkezif7KsDaNENae8VlatToXspsHpcOgpNC1kOsIFCs7plL4BUdV86tjlN91m/ZJ3Dd1rEvkpM89bRMRbMog7v6BpiUhewtafVT92yCELuFTICHu7KU6dYAU/PYhtsYNwrpqQuDmzFidEFrqBT7tR+YTJexlCIj8rpfn+sImfjxlUKPQ5HljSwO+kkS/lrDq/OsiFhB1cfsD0lxI/LHAPiGhmIL6TZQwTn/06jWg2bn2bYBccTV6CF9i9ooH9mzZ1U6O+UdY16/JkpnqbhS7DZcHIjqIbpSXTMVkA6XiRo4ihintHAZz3AAW3Kc41SxgqpwLu3a8Ro6M7XeF/ePWeu6LaZ8/HbdsoAv0wF0385jrAyz9h1wom7Et5thfhPZGa0ov7/wSI8yr7x8EEPOUY8JaTjV39IYM2wmbXw+4zl9gsyndA0GVA/II2r731z8pkX8F0FtCbbd8WqeDo3UaHKJXInMp+yW4sBTyTqvL3Cfy4GIwcjD+TfFXv5I95d2z6AWpdEVY4rW7RmZyiQ==\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}',	'yes'),
(907978,	'IWP_delete_local',	'1',	'yes'),
(907979,	'IWP_default_includes',	'google,wp-config.php,.htaccess,',	'yes'),
(907980,	'IWP_service',	'dropbox',	'yes'),
(907981,	'IWP_retain',	'14',	'yes'),
(907982,	'IWP_retain_db',	'14',	'yes'),
(907983,	'IWP_default_exclude_tables',	'bwps_log,statpress,slim_stats,redirection_logs,Counterize,Counterize_Referers,Counterize_UserAgents,wbz404_logs,wbz404_redirects,tts_trafficstats,tts_referrer_stats,wponlinebackup_generations,svisitor_stat,simple_feed_stats,itsec_log,relevanssi_log,blc_instances,wysija_email_user_stat,woocommerce_sessions,et_bloom_stats,redirection_404,iwp_file_list,wptc_activity_log,wptc_current_process,wptc_processed_iterator,wptc_processed_restored_files,',	'yes'),
(907988,	'IWP_last_scheduled_d',	'1709278448',	'yes'),
(907991,	'IWP_backup_history',	'a:18:{i:1709278448;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-29-2334__51a20c6df549_6.4.3-db.gz\";s:7:\"db-size\";i:5219746;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"a3a46bd9d0916ad4a47e9ddef26ab843cf487015\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"bbaed635eb36578dbbbf03dd18543a4c17f9bef6afca5959921da5787eb1abfd\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-29-2334_Pawlowski_Mastrilli_Law_Group_51a20c6df549_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"51a20c6df549\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"4qGiv6vdNK+AAHRZJrr9YI/CvJMjuLYir5Kz5ISDsqiCuGivYnW28ZqS5CC4lU+XlkJJTwW/VcQzmKBxzoePy3U44LD6fGDU43pUQ9j1dQexhsOA1gF5pQ9SsG8zAFgPx5ooqaIZf+elzZfPbjI3dUW+1YKocphruQB+8abxgUtlQGB5QOCHYs4g+i2KLsX2VFvd/AlVs2qeevI2/6NooWHnEs6eKqlegRlCoO1HLwukN2sg8UyzO/pMymdPYBxY7CoxF7LWyva50BAl0kuvB2LcOWS+avOO8vBl13V+DLPG7uiNwAXHX8uarL7nje8JYosQrWHayieoeuKTG0ay5p3+R0hizGtcCAcLAQF/Zl04TahVUoUXj6aFPkK0eZJ26JGpZUsVci1squnD4VA9gPL0qHDs2boV4h9QwhyBdkL3skUhesbkdpoTCIS4aWAj/jG/h5qpxnvrHPwWKu3TNzEaH6Vmr4CWlupVoixhud0hXX7jm2PQJm4EgXiTPaCdDbxwTUZp6tdxtesX3G1tynbuCwU7xOiaFNFKoCZ1VuoZH5dHmmqTc9XFcmA4CJf6jex53TOyw3qJlvJpE6d8NWGYhKy0M1ZouJODlSUJ5/nlzqR7fXQxRA3HzwL0KTXRE248KbFPk0UjwRQOsEYqUmFXhyQFgFN5E8HnzjFxgrXpmzdvZik6du3xUT+Sa83ueveAnPSvU9xyp8kAjP1FWr5P9HPE6gIBTqnu0F+w6WgRRQ1vgUmRXWHZ+DRgX8ilHC2bDiCyceG9lzbpkLCYkxZ9P+yQQOOwRmpyikDvlL80g5ZJz2iAGDe/6B79OVWGtbI38V1u/UPhyTzNAs+xmg==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1709193299;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-28-2354__dd5a3711ee61_6.4.3-db.gz\";s:7:\"db-size\";i:5435433;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"f32336942eb29301379b79d6125ffe761e6d6c98\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"b7f09bcdb2838915228bae1a2eac8aca3898ff222b72914fef0c7e6fb58a1ac5\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-28-2354_Pawlowski_Mastrilli_Law_Group_dd5a3711ee61_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"dd5a3711ee61\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"HxicZOAybeNStgbgYvGj26dQfuPQH6k4sc3hPIz3pIGgU8ow4sUvkLKlHvwAKw1C9XdxPV99eSDS0qzktqT+W5u9UmRqrqeZg4uDYp9T6ePx29ybE0Qlt+YmFLHOpD448WclIgqbJ9Xz80Diq0dM0MT1ftkpXI5LsFvtwEHB5VmKkKZvq59k6tlq+Wf3FVKdWSsZRFgvWTITD3PwHB5ZMvDFVOvUdEpjV3D5fF0xZsnVXc/BHE64f1Rqdf8E26jaKogmpNqwxKUkUzlRasel67CD5K+HJNhOUT5elXgPpTdWn6pPFa8IMAygs+qe05w/pVui9lu68hXJ33AbgU3g0cqfL6mHYPjNMf6WilHRytH0VAnj6hwWt2wlGJjr5gv2LJK5a75g7PJLBvkFRF+nay5fOdnE2qthLBwnIiu+aGQA3dM9eDxfFR8ui9p8fnN0rAvcZSbIHFF6Fy7SfYA1OwTIp9D0mX1L4x5dwByDLIf6B+iAntUViZgKgS5Bt/1oqLkiIqW3tJdiVrthjYmMT1TWuxqoKI2o3QQ3pXUpbkX1woKWEJL5h4Th+FNeSQl8/8IORGFAolXTi5re/SVF96Wx0BM0ToK0ixIYWI0OcmhlPOuKLd0V7fqnpxRASfbL2bqNIZgGjXSCJd4K+zQxT7xfGdsjF3wx8R1IJYF1vrtR3R2Vw4el9WApl1st+7ztawEf6pnt9G/ee1LDI99i45Z5pTnYRaSx7Jrc2PQ0juOd5wOKJdtCPljUG9tm6nnPStq1UZPBzkv4UgFuzbs8oan2e1jauuR4w7IzLqfm0ww03qp4CNQhUF6SPNBArQdERfvFsTCQ5Hq5ou7xDoCOgg==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1709108949;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-28-0029__000b5962cb7c_6.4.3-db.gz\";s:7:\"db-size\";i:5426101;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"f43c3348b88064a4f7a052cbf16273e19e5dcebf\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"b58d86976d2d82c2cbba157d19efa7ce99afb53f58d71253d732f38ae223a530\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-28-0029_Pawlowski_Mastrilli_Law_Group_000b5962cb7c_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"000b5962cb7c\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"Y3CH7gd+QIFPZVFNY+kh3f/yA/+yo1GwzwCLkpfmygmqOtZyYmZ5bCw5bOc9SO/ChCLesKcow54BYQtYLe+7O/NDIe5Vp5SrwziwYihRFqy0gsNoxc+5md660tcqIO2/6h9cP2FIjME7ZdNZaMFr47nxi5F3PMvN+Y9nf+YlRQ7cPd+T1++6pO/VvC1ZaM7t3dRzLGkIgIhyvGKTDMivlZkKIbkLNMKcPo6kxt5V9zYAf8kaWTq3EKqaKL/Y5irOwFNzUWaXN3JI43MgsagJ9Pfroterb7B5tyNOx+ju0w52CO1/TSnVM621ZsvKoA7lksNw2YeMQuzvISgS3D1TbLR1Af+GlX0w+Tg4C9pPyuXsqWOXw49MsbXb9TIZuKWNMtnvDh+HKuyXC3e4TIG26dC/zmfIJJ1jqh6pvvtlsxkbHimpS30kW1OvUdBBWkexa4+WcWW1I3fs+N/jlBHJAbzXLHL0LdmZMD5CBZ8Ue7uLhNLo5F8xmKkwwlbJ+MLkLH9//+tOoxAOrwnI/hbrrYfRKTc+sX5wV+xCYieX1iQG15j9n9VwpE/vVF3cUZ99gByh1HH9vEFfwm/FecIRxXW8Nqb1H+gJF/XA73KsyWTZrsAZhDoiggbx3yVQcTturEFVpYZMDB7c/xvPuJwezg80u2Zo0l90Tzhk9gC9HbK4SyXvfP8cUs2Zpi24Abc2SNAmwCEDUgn3dXH3izK1kYHaRPMuzEjC5a4vhzQdVaRl//wvBNEPvgpXqqfIz9T/xUlqH/CzIzoYx4Nwx9X3P+LwavNoXhUblMUyHG+vA5bac0AP1vqIzZgs6tM2Z+RHmZMFHaJunbVeyMBYWPidxg==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1709014424;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-26-2213__ad168a8710a4_6.4.3-db.gz\";s:7:\"db-size\";i:5195227;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"b403237d6e08b875b052633349ad535640a1e5cc\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"64d7adb18fc414a0d37933cdf9d394c47fb1b6316706da46bda444fa55767cca\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-26-2213_Pawlowski_Mastrilli_Law_Group_ad168a8710a4_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"ad168a8710a4\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"3DUGp8B3DYnN0xCycPhS5IyQS++wM5+92XtsA8oDC1WbstY37urSrsC5+NqE2AGw6cr2iHk5LgdddKri/Vdys8AWCvoQLeuoNcbD4OI0SFYwywBfqLrj2vUoXTAM5vP5I1G55SZp3x/LTuj/tqOwX2u3j+j72jynlYA5XW+DCqm6qkCVrwGFDP7jXFDDe66PgghnYVPG3D/hNKfeAP3wCKIflHHIzf98D2nIA6zMNv0bcA675yBGcZxCS6UXYBIQiNSigg9cY6VwduIB8hXQv2OMXv0X/bEA1Rvnq4IYpwZ2HQCHzzNXxeXKBgPFxP0+RIPsdeB4uDLCLaoW286JNF9xq+cb6UIWJRpEPy7pHwIlFQzFBoL+a+ASRxU0kZ4RNFSBsBC6Xm899BbmxV4aYns5dqbKGCy2w4eGHATW9jESX0pKxZB4tEYBCDwScl8rDekFGBH31DUATlR4ACVEPt/qDM5f7PHAU9VabeIyI96kM1i53Cf825fi9H3pe0mgojS5JdEFtSYBuEURxswHCBBXbbvb1J+MbIUD40jA4Rq4YAx4N2pUjWOB5PljX19Iz8v6V5eBM+ITFq3k97ky7Bv+UwQfLppHaALt5B4szDjcaDsqlmvS6oBVT6c0Rej/lPb1sP0uLhWExq/P+0/x91pWGTxqWX3cTSMYvylvqTy/GUJ0v5n2ZU6mIEfizqmHAUDzBhcw9oxRmod03r8k7mrEQVhLu7nsxaLdllRm7gpKvdfOYPOIkO9URWo9ID4bMtiAAJ8FEieaiNhb2c1cr2iOxr3dIK6RTKTJoPVTvyN1nMirWQ2BruRNpb85BTmRpE5mJLqV8uCprmwW3sElxg==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708935847;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-26-0024__849cb79b9ce6_6.4.3-db.gz\";s:7:\"db-size\";i:5185923;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"61c913ac3e1f8a96831d1eb8d33dea0b8b3ef96c\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"2038de39efa55659305814ccd3c0b8148fb8077ee4e46a5b50d6393ceaa1785f\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-26-0024_Pawlowski_Mastrilli_Law_Group_849cb79b9ce6_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"849cb79b9ce6\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"vT+1Stc29pvqFa94SD8zw49WHEWeDfyowIRygdhv+YY76G1l9Y6UL/9YJr00hKENes+8BsdZxObv3Q1jCrLkX8La6Bek/B2bZHEYOXeKk1oUgnymqMSUPHu79SD7GvpImakDyuYmyTY085XrcGdu4kl6lUAaMIeunZpOMCI6Tdfhul3Qo7pBpYuLk74RZJX5bfV79+Jo7l9z98fQMNn3gLIEQMmWh9zsr3Fg5b5W/7DjNIDzA4oOn8RMEgnE249FH58iBv+kNxrHdpcD72tDx/6MKCuRYj7dEDxZlaDICUmFF4hZTb+Fi/8Nxsqdz4IgepWfLOIwTxAlf0cFyVqOsfJcMLRCWz/a9u0jjImGX5pyOzIuP68uzRqZ38CMICCrx9ZEH82R/F7c5MUS8970n5bcsNEIHhBWsBK6MOki1j11nyhqTugspPAXT2d5gEJoNyxtOHt3D6JmdM5AhKhzgbfZtbaltHzLweI0dncy1WBhJwwhz2x1qYWiZ5Vss8w4eovMix9V0kU2A5uTj9lof2LU9IPlLN/deSp7OehzvmPTbMe7lriQ5bt01EGyQcrG9p1E8JrHVJbI6//cUD2nqjxXORz2mAbfxIOpjeKY3Lq0LB7fv0eDeWluFqizpwNUOYz5igYQv6RbyShkWulBM6WPWHpgW7gzC9nxB03YnZsPkQ0PJ7C9Hfg0zGx2+MzIJ+tWebbh+gNYVSDDdA9r/N4WubITBbKsR4Lr7A49A38W+CzfaWIXTwFmRq5LoDnxtLaZGmN2x4U3Kp5A4GFk1d2YayhH+aCH3h074NrvFANPljrYWe9fw6o14VoX1PA364EDIiSHO/YQ+AlRLeVkJg==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708858991;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-25-0303__3b3a7f737898_6.4.3-db.gz\";s:7:\"db-size\";i:5203012;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"70c4aa74b480a6c60dd4abcbf8c8e82c5270a247\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"fd020e9094e07bcc8f9cf2693db7e2e8c03990d972c253560496fe1f2c3e5fc3\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-25-0303_Pawlowski_Mastrilli_Law_Group_3b3a7f737898_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"3b3a7f737898\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"y8y6FUlN6vTq2DSXWCQ9DPftG4M1uHIhA4nmKmYN1da/fsn3wwHuXcAF/K+x5WCcY4gPE6YU4YteV9xDmGMeHCa/Dx8SevfwivIbokaWkDygTQPohZ8AdMRlIonF5YmWWk7yzTeCrHOoJb07VpKTKur0fukBnD3C40Qv3fC7NMd9gqa3XN2OW7jVgDrE2XuhZwlMMguvKbFLqnwH9frIwtFyUaQyruA6gkP6oJdvrnAFhyemA9OkY/hRmO/YsNkt3/Nx6gJQWVGwJ5VBxz7DXDXDLZ26Tm/HNCOY8WXh5FTBQwC8D2vPOL9SZWStfWNPO9rYnTpEUqDodSyShIMyzZKMY3eGkBEr4vpflm9QPGAgnV//L2otqmU9XHNNNYEquymoruEaxZlbx0Y53SKlThbyQmy2QY4kcw7xyIr66qc0k6wxtmByvkI6UWB8Pd5pEimebL6cnyv2hqGcsicW6vIT4F3EzEdM7/j3Nlvd83VZFsfibMkP44pdtsidEGHg4pDp+41ZvLQTp9vVl1KT31cMFV/hQYddEs7Xu0p+CP605dRE/ouHciTRQL6HqklkYk054lQVbNceOyJ1r492tRyyhaw0uLYRtm1lrnDDyfprOybch8B8BULcNdVWcx+cHMPUXIw4k57kgJszM5t0ixIJMh86hHjUSe+DEqZV+dTLFahDSE3jdnudDEwbqqFxU9lfNHrJ+ucwNvMc9pZaR3syTEJRoHUJAlksMBeiQoam8Ge2NjFdfd4WX1yut4U9YcJ4eODmoDNIlf0WFej2qPLXCm56hsRVljGsVzDwmcv+bsj0+J9cua3u4omnZfTzH66vNGIZbGmYU1Pu8pXrrg==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708794907;a:25:{s:7:\"plugins\";a:1:{i:0;s:70:\"megajustice.com_backup_2024-02-24-0915__6e049383493d_6.4.3-plugins.zip\";}s:12:\"plugins-size\";i:21769315;s:6:\"themes\";a:1:{i:0;s:69:\"megajustice.com_backup_2024-02-24-0915__6e049383493d_6.4.3-themes.zip\";}s:11:\"themes-size\";i:33688467;s:7:\"uploads\";a:1:{i:0;s:70:\"megajustice.com_backup_2024-02-24-0915__6e049383493d_6.4.3-uploads.zip\";}s:12:\"uploads-size\";i:19617555;s:6:\"others\";a:1:{i:0;s:69:\"megajustice.com_backup_2024-02-24-0915__6e049383493d_6.4.3-others.zip\";}s:11:\"others-size\";i:83913;s:4:\"more\";a:1:{i:0;s:67:\"megajustice.com_backup_2024-02-24-0915__6e049383493d_6.4.3-more.zip\";}s:9:\"more-size\";i:4890;s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-24-0915__6e049383493d_6.4.3-db.gz\";s:7:\"db-size\";i:5160681;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:6:{s:8:\"plugins0\";s:40:\"12810990ab2ef68e9d1e29e051a9a745b610fe8e\";s:7:\"themes0\";s:40:\"be6ea6b38186022e7f20eb9e1ff3854387b1c0fb\";s:8:\"uploads0\";s:40:\"ba2b904b997354da090a3fa9e864553d23413a02\";s:7:\"others0\";s:40:\"07dd5c64b90ce4dec2f7106b2614631224077df3\";s:5:\"more0\";s:40:\"d092a66e50c6d48db6335d98cc4260110975ffc2\";s:3:\"db0\";s:40:\"fd87b7336df339277e17c5df7193988b03593340\";}s:6:\"sha256\";a:6:{s:8:\"plugins0\";s:64:\"ae1f36a79d51ddbaeaf8b90ceeac3a1819f1a503c515517f43277291a195e063\";s:7:\"themes0\";s:64:\"c2b3e9485ea229868d7bf73f40c97681a2814bcea0fc3d80e00d06ffc7f76df9\";s:8:\"uploads0\";s:64:\"2368ad811f7abebcaedc7b95860b1f6392061e1597a8624678ce2499943db817\";s:7:\"others0\";s:64:\"755aec564fca8d06e93b181745e00fb341d23e3d9b5c50a3e16bdd7bc503f3f4\";s:5:\"more0\";s:64:\"370f57676b8df00ac321337085f61a0d6fe2892bc5c988f01e3a8b6408fe4645\";s:3:\"db0\";s:64:\"e58a4c800169b34b303972081ec54653cf8d61f201a0813d5687264bd3c6bfc6\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-24-0915_Pawlowski_Mastrilli_Law_Group_6e049383493d_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"6e049383493d\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"CJ3GnZHOlKZdrBINlm3gb7f/bPEohMf+AbRaJSRpzL/WKm+XWfB1wrc0yj18QOfOCwq78gMNa1fMLuqLrHJnANG8T8Ufw2nFin/hVYoHoj81GVe78lz0xt5Yz4tOSwb7gsTmvj37t/YFvGrqMuteNlIJJCDYjiEmGuN1ObBFgZvhLG4XacNZLffNKv6RvjQN/eHIJufIAQcYYkDMgWS5x64L+mzEr3k7l1GLVHNvNAbvALEdGVrcU3srgja0djkSFQaaiJZtlKPgjLSICCz++f4hAa21yN6phL9I2O2UeMoCYTBbgzVFQvhnvXdLMJ39e5XdYO3alQ/o16nB/Q55enSjq55UlMPk9NYEBkh3iY3UU6sDvsISMHeF5B9I12UqTOLibrEOVdET0T18Cf3O3etIoYaJH4hsJ9VrAb7TRPe161dKTmku8m9j5FeB10O/uufrnXedS+qRD2u9djhVKxeaSbX/I/mm0ubhyMNh87ld5JqwCvN5qjVix7kOf5XVz2gaOZcC+D4YfMLIgtZHpG3c6+J6bz+TS78ioK/o0hzBWn+O8zUOp2x028cV1PiBrHNLjnyN5MQToEFeFXcCKtq+SCFlPsKEZqEIPkdZi3RbpQ3d2+2fVSoON2nTf0GKPbG0iWeJZB7Hh7Q00DtkAg9XpEfd4GiAq3DSRZsDXHQc6tIiC572FKk6RP4R1EioXxxrVuKjv/zv/LrdAtlLiJN8r5BnMS4iGi0Ff2qSEARfswQ75thEXwcnWWgIFHm/MRRFYJL3YSEVK/YwOFY7jVV3Uaqqo+LsNavgJVM9ekmi7hR/jv5FiN2uHo2NdTVa8zQrtQ78yBt0Uq3Dd6yArQ==\";s:6:\"folder\";s:6:\"weekly\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"401668daba8815b38c9036630c604d1c\";s:11:\"backup_name\";s:35:\"Weekly Full Backup - MileMark (A-M)\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708794128;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-24-0902__1f55a4cdf512_6.4.3-db.gz\";s:7:\"db-size\";i:5159668;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"3bd7570c17d9aa819c5d38aa19ba7f6154926027\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"f4f4f9d8634fd5cd9bf8ecb76ee7391414f27604d2afcf10d974dfed0fd406a9\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-24-0902_Pawlowski_Mastrilli_Law_Group_1f55a4cdf512_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"1f55a4cdf512\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"CJ3GnZHOlKZdrBINlm3gb7f/bPEohMf+AbRaJSRpzL/WKm+XWfB1wrc0yj18QOfOCwq78gMNa1fMLuqLrHJnANG8T8Ufw2nFin/hVYoHoj81GVe78lz0xt5Yz4tOSwb7gsTmvj37t/YFvGrqMuteNlIJJCDYjiEmGuN1ObBFgZvhLG4XacNZLffNKv6RvjQN/eHIJufIAQcYYkDMgWS5x64L+mzEr3k7l1GLVHNvNAbvALEdGVrcU3srgja0djkSFQaaiJZtlKPgjLSICCz++f4hAa21yN6phL9I2O2UeMoCYTBbgzVFQvhnvXdLMJ39e5XdYO3alQ/o16nB/Q55enSjq55UlMPk9NYEBkh3iY3UU6sDvsISMHeF5B9I12UqTOLibrEOVdET0T18Cf3O3etIoYaJH4hsJ9VrAb7TRPe161dKTmku8m9j5FeB10O/uufrnXedS+qRD2u9djhVKxeaSbX/I/mm0ubhyMNh87ld5JqwCvN5qjVix7kOf5XVz2gaOZcC+D4YfMLIgtZHpG3c6+J6bz+TS78ioK/o0hzBWn+O8zUOp2x028cV1PiBrHNLjnyN5MQToEFeFXcCKtq+SCFlPsKEZqEIPkdZi3RbpQ3d2+2fVSoON2nTf0GKPbG0iWeJZB7Hh7Q00DtkAg9XpEfd4GiAq3DSRZsDXHQc6tIiC572FKk6RP4R1EioXxxrVuKjv/zv/LrdAtlLiJN8r5BnMS4iGi0Ff2qSEARfswQ75thEXwcnWWgIFHm/MRRFYJL3YSEVK/YwOFY7jVV3Uaqqo+LsNavgJVM9ekmi7hR/jv5FiN2uHo2NdTVa8zQrtQ78yBt0Uq3Dd6yArQ==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708674413;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-22-2346__a82395c4cac2_6.4.3-db.gz\";s:7:\"db-size\";i:5170531;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"d43b01da3bd7709b3a72f92f551cb266d217ea63\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"f7ee9b1e56ee6524bbb2b6c79b52807d8d8fc7ffeca1030b5169ddab64dc9ff1\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-22-2346_Pawlowski_Mastrilli_Law_Group_a82395c4cac2_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"a82395c4cac2\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"xNsw989rKIGBKdSzwoxGYVb6Rr7DzaWkqT0J58fNNL62/09nQp3nBbFbow0mSDMQb6OEaP6IiAiojXQfP/k2icGRsHwBswps4j4tle0M+kx/Az46Xl4WBKeta3zbKFsBlqKmiAnwyn+yAAL/oM6Rt0Q8jwg/9/RFH2Snj8GQVj+pE8BOfgMZ2CBhHhqeeO4r29UfQTwi9csmTCCpvYxyElS8fq5NgV4e/1K2fpmIXTaRZQ+gsIlEnh6p7IklD90PDJMUjDcmRMshdbAWprnTrNP3WxvPS1w2bDoRIyeWasbSBnKJHCQkcYeHfZkLbX89FH5fUDOV5MI6TEI3MuyTe0dkJD9DkMvcdoKlfvwHS6gCNGOVS8XwGxeJ0urnETjei7Am55fTy7YqzSm9ESfseduMGqrFV2ZVbn+89P0fqIea8FSX2HNNOWGcSJXF4vmtmmqHZYh6YuiVoIHHmbbFZc7zz+vJiGAq6bcjH6nH2WOWFgahbjmS4Kd/f3ysPQEG8DWBKwfwn6GTay0LZE6wU9Vp58ZRh3khm5V5N0XfgKwIRRf1lZpk+5tEXozIduXmDrELeASotO2/HiWd+Ou7JCV2OFB4XGQMvbflypNWwm4OPRs7dnghRFP+Z+k+6gB6uiSHlSkNOCr4JTompU/l+RaEmu4MGSN0t83GoVZRG5L/wWmbWI3rbKoCrXgpZ69RH8TvSfG85KWxdhZIibtJBZBzn6pXxfJNxzgIfcdawwL7uvx5Ys+VfiCKUsJV6lgN79JxS0owyK2GA5tb1+425EV9808fKpdO0XZu9VZ5jISH/ZBiZN/ptoNv+COYBlZqjVsZB8t+EySViAPX2hn8Kg==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708584065;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-21-2241__3a0ce8b7a613_6.4.3-db.gz\";s:7:\"db-size\";i:5167653;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"314dd1e8f456c5384eb0342f7ae4c86baf538346\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"03d19bbc7fe5f3f17081653ec8e34fbdc295627a61fcb444addaed387b6175bc\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-21-2241_Pawlowski_Mastrilli_Law_Group_3a0ce8b7a613_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"3a0ce8b7a613\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"hcIl4W+esr+BUVl2ftLomDWc9GgLVKwkgNtZrPsptbbyvOXgNDPEueltUkeqWiW2ce0P3g/9JOQFiSBuSAXAeLJZAA3BpHhMEnIQhY6Sm4oDnTWhesuS7ow3HdVz4twnaWOOue/dRlJHH1as6DvfPJhtp3nsxuvEFdR8UBFqqPst6Uj75WbUQ2HjY1f3TiKJTqXr/V4a7hMDS8GiQm+gU197G8E4SugkruzWSLnvcUwkUJCpnq0gDuPlDXLONkuxdMS6Vhgv0Za0fGbAQMnop33k0Bq1avKndTU9nDej9laefXKr0ADA4sojGgBC8RLaATWDLXIDKLMgzFsGO0bstAJuWzN3SXGHYbpr8XDfS8YEmb/vtJ+Rb4ZpNvwRE8IcPfErpwtgt4axlc/gbNhFYVMu7IHM2v92FG3sxXTU7j6T4/EaHRrYXV4jatB22EHVSt3hTbBTR65SIW/f9EgKGQPFw3QoyGA/yuNACZPCGLdg5TdQQYctMYhLZvvo/2DBDTOgHGvX05PXQxYEwyVs42wD1z6JxpZwGCJnxAo1d6FZtu9sx8/bkTKxSUEXTZIDgGjn/TLC6FSZulsu+aIadrrU3SczTK7l0niVoaIOHAaLLDRw3tFiH2zeJCIXTJJWVp8WMNyLDMXhQbSj4afYZEkjc3+jPuhInJweb0oA10c+vWUUEaXWAMHcl8ICUr3SAKLlZtR+S8ZI7RYMs6aIEgSbNmV75QovhiBwsNd4wdnYOsgGVU9VmS4gQz0hWkySlnoNFLDYiJ3gJ3YuhZXqvHMBKLkEhsHmKezgtaEfWU5zqQWD5NpQoIK43eD5ZXzj8ZI68mXvSMrQFQFRKcGuVw==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708498533;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-20-2255__4ad31ce6af06_6.4.3-db.gz\";s:7:\"db-size\";i:5137885;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"550628985400dde775a8ac1b8946451842c3b2af\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"b92d739b72997a8ae627f26759484ae6022019a4ec8b98cb3862b75097974c44\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-20-2255_Pawlowski_Mastrilli_Law_Group_4ad31ce6af06_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"4ad31ce6af06\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"jKnOOpxlffLC0UVtzJ5lqAsat3y7uvVRTvAxgi3aEVCX+pB8fduOSgvuD2Uhucmx+RFwbyn2sAAWdIV7NprDDw21EDTR1taqw7Oa0fuUUTiz7+x1IZ6o1BWnddmxdo6kTWyQbJGe61oCdJYS2QtVxolJY1jL3cTxF5RpJQJ/w3Xvw21QfBxT+xxRS9n8xyXOKEmB4k1X4PjN7lI/XGUV9K4FZVzY/Mqc/KNrvPI3+X8qM58Ak/qcQVhNBpmPhBiiwjrXbIaO4czsPa4KO/nBjg9IDPWh9+J0cJIECe+V70s92slvh6sangayoUMjLAFQn6gIPcgNHIxAVJfrq9EZwY+x8aNfkhTOr4/4m3WRV2ENBBYZuIbue3ejtpbmpW05YZHA4ITLhVAzgY4oREnluQFdjkM5L/1e66IxFaXtE0zJduNkD6ewlUt/6NLZdpFQHXmWGa2Q9brQz0iKMgbLAe919zPLGBS7GLnfUHiXV79iDH27uWqsNTGMV28BihxpGNhK99m5mCSadwSLWwsav9ytBWTrrosVAR6ra1tqQZ67ZdHQkal5B4dgSk0Fj8PKkXg8mmkmHD4UwjZ1haV9vVry1dLUmz+iJE6/rc8dJz7UZWbpaoNHaJUUK8GdxButLJENH3QyhUQyGs7cS9S21/uOtozHEdzKnjH06HqHDRQdWMBgDdFxASV8lGMskHRVFw4LFphTJuZ2Y4mQwULtkH09e1+JdH+7R2Xfehf26bkANQ+/0jgBdCmyMxHzWvhHBUXAoCIywUGHNj/i1gSEH6H64tsy7OIr77n9DNxX3NXSWdoDd2SsDUTjonFXnk5x1JpgCmR3B/6BYC3EzsE/wQ==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708414755;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-19-2339__36cbf14a20d2_6.4.3-db.gz\";s:7:\"db-size\";i:5116149;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"8f16f655b13ce304182ab694ffbfd508fed7f2d0\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"c8f937aa207b3852245b52b1aa829cc0fb89e08f87a41132b632bebf3f8ffb28\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-19-2339_Pawlowski_Mastrilli_Law_Group_36cbf14a20d2_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"36cbf14a20d2\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"Moe05EpnQ9CeIAnuw08bFnazPESvieDBN0M8gHo8zDZHu2hqdygIFezlH+F0SvCb186VLWCB+5O118+2iL4WGd3eI0lSf+n1qajXpTabdwMgvBWQzNMS/wFifHB1uIXrFbxZmodkr9La2curf0n2aRvCDChYSGM00of1E/8DGewe2J+NdvIAu8Mtai/GWAvHI9rcDhvBFQWdJBBhtviPSE82AIEjC6FNw2xjXRzEce9Y8hU9fsEisVJHF3cPeHKAGaRpnJ6LElLpu71sqAaiQZu6KfW8nW28WksXzLwa6t0TG3hJ+eVoM9HS0MGNUSCqi0F7Yie4D9bHEKp/LagoIy6rKODLczjtwBPrm7ZwbonkkpN3vMXfaIa5kzJnCTOzRKeFxkHGBdLMKrqbRIp3n5kaRiwQyNQanqqB4cyBS6l2yvgy3bkL+EZhCxdhLsdZldECrPZHYRYPByTqupsmsyrk82yA/tdPshodbwqw4Rf9vMDL+e+MTqLolg1py0CdyTSvgxSwtpDQtEB7j2O518NyNmBK3SaRsD6kjbQDKQBICs5kdcxTQUeKj2fPe5k44b7mn9f+ZD+ZG5FHeAvQs14VnybmJXozGIw6Ll0BE4uDCOsiYePVCWTyGxQNfa0NnFOM8S5zZGiX9P1IFcZ0tIqucYosy9HiQuTPqUfsa6ewYK8xY5/aWAz6nv/Ya/2/fm6C3eDKDJ153TT6+ZJIhdBUyNpznnfcVTu0qXWc8Nl/+uOezV1WCs9UZaINgko59P7EEZy77ZcTFkOMEJEtMwcX2pL3IC85PHgBhWA9QB4032WELdAmE2qo1AgVa0n2hjGgOiiJGY7vt4Df67veQA==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708323666;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-18-2221__92766ac7028e_6.4.3-db.gz\";s:7:\"db-size\";i:5120789;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"1afc034ca437b56c0412d5c35efbdf6a7c6a322c\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"9ba160cf6e56710c5c896adb6c65753b0efd3ff93f5c9dc5487e056a4a9d4e27\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-18-2221_Pawlowski_Mastrilli_Law_Group_92766ac7028e_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"92766ac7028e\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"eEmP0PhornTC4XhmaVMVHyAZj0EBv6QuRmN+67BKd3PVVSfC61be6w/OUFbTtnsOiJ7KCp6IlPZIiNbiqCX8uiTXtBSql8dIn9M0BhN5X+/v/zUgDGaKeCQL/giaJY5TUh9ms1jyggUk6GIQsEdNcS5w/8qgl/M2+bLlgm2eWBPD/4QnyN1UIudNRQlYKFxs5iYDa8jlhyL7G7FOzVhZiYxnNHg4+aAXIuypAKIVqNRizGRBCYcd0BbSMtjlY+KHfBD5G47e2fu6WktNzmSDvqnDJcwvmsEayEFVxDGmhOpjL7EvqM8pYbl1NZ6Uwhbmw6F5H6LM8YPOzUuXrX0pLxYfzb/IrNjckwLxUtxq7/z5W2OzSQpXEYMAFzhFJCco8f+D5eMfU+Dp0G1/FWbAGZfseNRsYn5frAAIrSlLTO5XDuHSvBuYkCYrqFH+6ABX01RwDZVH8BDmx7WznmOIzkqQ93SziJ0X1PT2vFizuXIKCJE8MC3BhqS+nk8sY/tkl/uTKl3G9Bxw7tdBeTl6yhscc1AImFvvTAYLhaKpVN94XBxt6NNTGpRhx+9IMrDmMqjNeulNR0juNzKHi/z53Vmi/qbo4V+Mylzl1YeXfvmb+L/FFIY/KG/BveLn6BjJI3s/ICssomH6FpPfHzcCU6nJZJk16fxipZnNDrZ3sdWoTbfcsEwKsfkSW2+W8rJbF5C7AIzIZyG74v0SNw45dbYNxMNz8qepCruBOkoErpYDpjLPX+HrzZTRBenx9+Sd2B+dTBBC4YaKdawrqf41EW7fW9ta/EwvXU+qdWMRtBN86QtiTWy8uqJANXOz5d3pUDaZv7skAUpIN2M65bwAvg==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708250411;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-18-0200__72ac88e0e543_6.4.3-db.gz\";s:7:\"db-size\";i:5178122;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"bed1cda3a693c444db50b03abe17a8bf4764216f\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"ca6fe74ed113c43229f5401b6f8b5c748282cad3129672efa9098bde4394d1b3\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-18-0200_Pawlowski_Mastrilli_Law_Group_72ac88e0e543_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"72ac88e0e543\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"B8dWYz8d8WuqL9SggNYVuvJNVlhwPkB0gRp8u+JTarSXcKWYWkurZIBqk8+oK52pVkCUHx21lmLTMMAUBwlHwHRWVcCC8tUiJdl2mynmMOKttiv/oACDsXB/5274tmpd5b8ZUSv3xUq4OZ+FRa7IPsnTmKyEjlIWDn3O3J3TnVlWQgoaWi2w+l1MxIMTRKb9QJRFWkRCzSE8XtjmiMEuxVbS9Vs5rXW3Y2N9meYssF6hTaYrCJhY6DlbqrQrd/hkv6/RXf9OMyU1x+YN6TraRzEMBaaJkplTa6koSsS8N30U0VwB7882CWr+UFG9SIdFsEtZgsHYyDtppklLyJ5Ja8yxzcBUR9XoXdxSKcHEjTKFU4pCLAFxUra9/d2OKW9pJ0FRvhaSiueiBbJUGmLjhuoftAcDl6qD1Ww+0qnNINPvEKZTcDKNtKtJxEiEUYvefs+JDOxBSXyjf4vMBbjQVgWbBT9pF+xPygmfkfIUfLouwNp4Mew5MvFi4XDntunFysfti2evnT4sgaosSAHoYch8SAlHI8TXeCykYGden7eqfsYE6tcXXd0ZpE6m4b+2PmdVoH6F6xnFi245D0tMrf7X8h6f0FFOw1BpH18mVplo5vn8/8kAyQa8Xf7l0J1X1kU6O4/kRKAYLGbnJagpk2S/QNBO1BHUavO53VdXcxsvdK2gKhcJzfc7FDmMULvVMD3TjIRqE/Lq+x1yXcVV9CASuiIlgPz1X4+Mhz7CNZ+zCREvnQ4Hayj6TkKyEmlL6tUb2yIe9x8/EjM+xWQH/U0JrktRNmS+XBWUUeOnY/v764l7HdfIhCi5l68SDSBK39lw/8f/H98fSchm5ONWHw==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708185886;a:25:{s:7:\"plugins\";a:1:{i:0;s:70:\"megajustice.com_backup_2024-02-17-0804__5d7b2737f065_6.4.3-plugins.zip\";}s:12:\"plugins-size\";i:21769315;s:6:\"themes\";a:1:{i:0;s:69:\"megajustice.com_backup_2024-02-17-0804__5d7b2737f065_6.4.3-themes.zip\";}s:11:\"themes-size\";i:33688467;s:7:\"uploads\";a:1:{i:0;s:70:\"megajustice.com_backup_2024-02-17-0804__5d7b2737f065_6.4.3-uploads.zip\";}s:12:\"uploads-size\";i:19617555;s:6:\"others\";a:1:{i:0;s:69:\"megajustice.com_backup_2024-02-17-0804__5d7b2737f065_6.4.3-others.zip\";}s:11:\"others-size\";i:83811;s:4:\"more\";a:1:{i:0;s:67:\"megajustice.com_backup_2024-02-17-0804__5d7b2737f065_6.4.3-more.zip\";}s:9:\"more-size\";i:4890;s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-17-0804__5d7b2737f065_6.4.3-db.gz\";s:7:\"db-size\";i:5190966;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:6:{s:8:\"plugins0\";s:40:\"12810990ab2ef68e9d1e29e051a9a745b610fe8e\";s:7:\"themes0\";s:40:\"be6ea6b38186022e7f20eb9e1ff3854387b1c0fb\";s:8:\"uploads0\";s:40:\"0a24db463b016ed00c00090a7573bd5656fa0412\";s:7:\"others0\";s:40:\"83c7278c44073fa8fbf3e730539d0fb847014af4\";s:5:\"more0\";s:40:\"d092a66e50c6d48db6335d98cc4260110975ffc2\";s:3:\"db0\";s:40:\"6f64101e835e18f905df44b4ca1e791886c748ad\";}s:6:\"sha256\";a:6:{s:8:\"plugins0\";s:64:\"ae1f36a79d51ddbaeaf8b90ceeac3a1819f1a503c515517f43277291a195e063\";s:7:\"themes0\";s:64:\"c2b3e9485ea229868d7bf73f40c97681a2814bcea0fc3d80e00d06ffc7f76df9\";s:8:\"uploads0\";s:64:\"32dd95ddc66a0ad50e2fa18dae52e0023ae991a02ef601046c70097bde4fb340\";s:7:\"others0\";s:64:\"1e14f736a81da7e3446d18a435442fa3cde9f651816f7797ece02c1a82cb83d4\";s:5:\"more0\";s:64:\"370f57676b8df00ac321337085f61a0d6fe2892bc5c988f01e3a8b6408fe4645\";s:3:\"db0\";s:64:\"6c3cfeee340147202b9cb6f76341e877783d73528c5a34060a3b383a68c4bce3\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-17-0804_Pawlowski_Mastrilli_Law_Group_5d7b2737f065_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"5d7b2737f065\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"JtimdofV0YUlHb3r/tiUydwaSeSUOsjNf2jOdQVhtU0HiV9/uk4pbOkgbhKYu3ZA778qRzjNTFQLspPUYYuO2RQPZG2RvSMfXhm3ytBeXH87vAn/bqG+1JewJZUwRNtfkCPaUUkcioUIJ6z/oI+hujcSyPOitzd9EWbQ7UxzJESOnV3avgS0J9MA7tmjRNlnNpL9mZ0q7PY44CPytMTLy4+87Xq8lGyunbwLadg/uCrvjG3AMK0SZlikkFcYgzUhLceuyF9BwM5Aynvn63RI9tduGMCTRJ1SDjqlp/O4aaIy1UH9N1q8/zsgKvPKhKauEj7Tm4NtCN9iWRBD2ZizUIfk5bz8MwGO+vEXp3Z+6/12+5dUry12+FF0wMVyzHLJk6zagpAl72kk8W5gs0ldfCcyxF11cHjeKGwEPZAd9yvjlFScugSjxEqkL/qVLwx1PtGJKhZkGD7Blgcv7U1prWoz8qMNbxNVssLfwVTIILijrf15mP7fDn8+01UOr4YVmhk+vGmSC6hCRnH6+1X0df5ALo42nf5eRUA+zX6eIxF2dSXPMaSB82UvTR5B8qb8p4L/D1OWczHfNuZfMU3Ucm9u7x3JUBQaMP1v0B357rUjN7r0bD5/RYu2h2QRWmZyp7tkJKW1CaLeAVjr0W9mV5peOvL7EW6Ni+jkXnPssl99g/JtmM3XS8/RAv9gjjmtq/ei8zk8YwICUZt6qEV0dSqoeobpL++WCUdrdUiapkLYqFYgdnxOPliasrrrmYShnEPzGnqh9SHu3dAJEfEAmSnPW1e0E9XX0ZrC8JtJgrkgM6MGUUNfTMzNhIbtuB2+8K5psgnAlCJh+laKG9fJMA==\";s:6:\"folder\";s:6:\"weekly\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"401668daba8815b38c9036630c604d1c\";s:11:\"backup_name\";s:35:\"Weekly Full Backup - MileMark (A-M)\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1708185192;a:15:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-17-0753__09b73faa3398_6.4.3-db.gz\";s:7:\"db-size\";i:5190284;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"61f9af3578bc5e918ab39605aabe59a772a41272\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"dba89ec61721085ef4d780caf2d5ff8d84e8f224b9e74b8258229a1772549aa9\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-17-0753_Pawlowski_Mastrilli_Law_Group_09b73faa3398_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"09b73faa3398\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"JtimdofV0YUlHb3r/tiUydwaSeSUOsjNf2jOdQVhtU0HiV9/uk4pbOkgbhKYu3ZA778qRzjNTFQLspPUYYuO2RQPZG2RvSMfXhm3ytBeXH87vAn/bqG+1JewJZUwRNtfkCPaUUkcioUIJ6z/oI+hujcSyPOitzd9EWbQ7UxzJESOnV3avgS0J9MA7tmjRNlnNpL9mZ0q7PY44CPytMTLy4+87Xq8lGyunbwLadg/uCrvjG3AMK0SZlikkFcYgzUhLceuyF9BwM5Aynvn63RI9tduGMCTRJ1SDjqlp/O4aaIy1UH9N1q8/zsgKvPKhKauEj7Tm4NtCN9iWRBD2ZizUIfk5bz8MwGO+vEXp3Z+6/12+5dUry12+FF0wMVyzHLJk6zagpAl72kk8W5gs0ldfCcyxF11cHjeKGwEPZAd9yvjlFScugSjxEqkL/qVLwx1PtGJKhZkGD7Blgcv7U1prWoz8qMNbxNVssLfwVTIILijrf15mP7fDn8+01UOr4YVmhk+vGmSC6hCRnH6+1X0df5ALo42nf5eRUA+zX6eIxF2dSXPMaSB82UvTR5B8qb8p4L/D1OWczHfNuZfMU3Ucm9u7x3JUBQaMP1v0B357rUjN7r0bD5/RYu2h2QRWmZyp7tkJKW1CaLeAVjr0W9mV5peOvL7EW6Ni+jkXnPssl99g/JtmM3XS8/RAv9gjjmtq/ei8zk8YwICUZt6qEV0dSqoeobpL++WCUdrdUiapkLYqFYgdnxOPliasrrrmYShnEPzGnqh9SHu3dAJEfEAmSnPW1e0E9XX0ZrC8JtJgrkgM6MGUUNfTMzNhIbtuB2+8K5psgnAlCJh+laKG9fJMA==\";s:6:\"folder\";s:5:\"daily\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"8cd6c6dda664b3d12f96c8eb3aa179ad\";s:11:\"backup_name\";s:15:\"Daily DB Backup\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1707580667;a:25:{s:7:\"plugins\";a:1:{i:0;s:70:\"megajustice.com_backup_2024-02-10-0757__a950eabf6c98_6.4.3-plugins.zip\";}s:12:\"plugins-size\";i:21657792;s:6:\"themes\";a:1:{i:0;s:69:\"megajustice.com_backup_2024-02-10-0757__a950eabf6c98_6.4.3-themes.zip\";}s:11:\"themes-size\";i:33688467;s:7:\"uploads\";a:1:{i:0;s:70:\"megajustice.com_backup_2024-02-10-0757__a950eabf6c98_6.4.3-uploads.zip\";}s:12:\"uploads-size\";i:19617555;s:6:\"others\";a:1:{i:0;s:69:\"megajustice.com_backup_2024-02-10-0757__a950eabf6c98_6.4.3-others.zip\";}s:11:\"others-size\";i:83646;s:4:\"more\";a:1:{i:0;s:67:\"megajustice.com_backup_2024-02-10-0757__a950eabf6c98_6.4.3-more.zip\";}s:9:\"more-size\";i:4890;s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-10-0757__a950eabf6c98_6.4.3-db.gz\";s:7:\"db-size\";i:5165021;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:6:{s:8:\"plugins0\";s:40:\"adb6813a98b173a505180861c9b04330aac041bd\";s:7:\"themes0\";s:40:\"be6ea6b38186022e7f20eb9e1ff3854387b1c0fb\";s:8:\"uploads0\";s:40:\"4de051413b1c7d59cdb0277057333c489dcbc480\";s:7:\"others0\";s:40:\"3b22a067cdb3311e138c98e3213d2908b23ecb06\";s:5:\"more0\";s:40:\"d092a66e50c6d48db6335d98cc4260110975ffc2\";s:3:\"db0\";s:40:\"5debbf29451e7fcbfc2e9f6a2a84730e7806609b\";}s:6:\"sha256\";a:6:{s:8:\"plugins0\";s:64:\"42ab20f3ea2ce0758df7a78cd373bef534d73633bf7e25ec8af1c433121d97f2\";s:7:\"themes0\";s:64:\"c2b3e9485ea229868d7bf73f40c97681a2814bcea0fc3d80e00d06ffc7f76df9\";s:8:\"uploads0\";s:64:\"195671d11f5da10739918370095bb1876f5ec9c453ff5cab8ae5831814294c08\";s:7:\"others0\";s:64:\"c0cfe36ad22c751632cf4472f1ab3a8bc9e0df48c66c67b57cf0d56c1828dfad\";s:5:\"more0\";s:64:\"370f57676b8df00ac321337085f61a0d6fe2892bc5c988f01e3a8b6408fe4645\";s:3:\"db0\";s:64:\"86c20b6d0692db039f738ab20d87a18c26c3d2a7ce2a77b406fd3b37646eab51\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-10-0757_Pawlowski_Mastrilli_Law_Group_a950eabf6c98_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"a950eabf6c98\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:8:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:15:\"tk_access_token\";s:856:\"juhrEdL9xkSVIGrs5c4qJQFXPzFgeMQaJbdmibygP/QzhVRQkWlsnypbYdcxXDXpWjV8vRpEWQoOgn6B0GmSYm/z6AElbq4iNvnqh82o1TwUOgKBlMmuDfydlPKKyEadbPPEL5DHCWs8gnUslfLkhpmhgm1AEwVglV+n0y9/ewv6wZmKTFoYd2PM/WTT0tejbqmE+qrGu5k6rXf+Wz9IB385Fv0xb3dzNCv8qf+bN7wNYAqFqs+m+5g2YTzoL6i7qhv7SpB3NNfLfBxAifJCl8Oc9+HX+syOVliX3jdrlGDnW01NwI//Lg2os9RWlGllzu+U5urPIJ9y+RQ1XpLg7YbJpHLthV7ALCeC2sXyKTR7BA/n2eFpqIGPoWM9gO89Gvqta8UKS1lRNwsOIgW1OTK2/twjAk8A4lxdk5sqhfn8dsuJtZPLvEJ0WQkXRhtS2S1n1uCsMevLvZeB1nDM/HJN7M9leIFpOpucTp/JYKzQQQfTu/vaQ+89NjCVhNsYCjWsj/aPCU9EZCjxHaWdUfnjQLg3TO8Jl2uhuX7h4n+Sr/drRRVWk/c67jER/uHA/pZRavv9icvqqJNxymS74KYB3aS3AB9YiShnFIuGSc5enH7CPHzq29viB18XV+Zoa+uGmQ0dH3v5qVn/hCNtZKBYDfNMTcVykkOX49RpHsQ3ivW+wSjQ4couM6YKWZoNQhkKyyy5EF5yXEZcJDHlmdP0FhW5WpNU46ebk5cizJs8ty9ZEvBK6a18UuGDW0MqO5PGIbkp2xn0PsAFiMPu8LP/PbbjHmxxtnEnq2/YgoMn1knzqH2XmS9KxRuVhU2rduqggu/Zka4BvrLvyIt6Ww==\";s:6:\"folder\";s:6:\"weekly\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";}s:5:\"label\";s:32:\"401668daba8815b38c9036630c604d1c\";s:11:\"backup_name\";s:35:\"Weekly Full Backup - MileMark (A-M)\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}i:1707000192;a:24:{s:7:\"plugins\";a:1:{i:0;s:70:\"megajustice.com_backup_2024-02-03-1443__bb1c7b45f085_6.4.3-plugins.zip\";}s:12:\"plugins-size\";i:21656766;s:6:\"themes\";a:1:{i:0;s:69:\"megajustice.com_backup_2024-02-03-1443__bb1c7b45f085_6.4.3-themes.zip\";}s:11:\"themes-size\";i:31031038;s:7:\"uploads\";a:1:{i:0;s:70:\"megajustice.com_backup_2024-02-03-1443__bb1c7b45f085_6.4.3-uploads.zip\";}s:12:\"uploads-size\";i:19617555;s:6:\"others\";a:1:{i:0;s:69:\"megajustice.com_backup_2024-02-03-1443__bb1c7b45f085_6.4.3-others.zip\";}s:11:\"others-size\";i:83404;s:4:\"more\";a:1:{i:0;s:67:\"megajustice.com_backup_2024-02-03-1443__bb1c7b45f085_6.4.3-more.zip\";}s:9:\"more-size\";i:4892;s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-03-1443__bb1c7b45f085_6.4.3-db.gz\";s:9:\"checksums\";a:2:{s:4:\"sha1\";a:6:{s:8:\"plugins0\";s:40:\"4e6253a371109a37c270f756c414b2923e4d564e\";s:7:\"themes0\";s:40:\"d836e203e04a724edefbf42ff52c7c2445312430\";s:8:\"uploads0\";s:40:\"5f2384520f49b066146f321f95ea26c9a73d779c\";s:7:\"others0\";s:40:\"b5026fb2327cf4f5b83e7dcd8dbbe84ca0ac7cd9\";s:5:\"more0\";s:40:\"c1e9e7f9c9a56ae8bb8b760a3eda0dcb8c81c19d\";s:3:\"db0\";s:40:\"dc7c30741bcf7d615c880588100a731f79f6d304\";}s:6:\"sha256\";a:6:{s:8:\"plugins0\";s:64:\"336c43b91fb18e2e53ec9cbe5f6fab5e60950f33217a86d9737be8f20429b4fd\";s:7:\"themes0\";s:64:\"a37235a894e78e3156f1b62a6c7b114af9f3476b158ba6bfe0333ef1a458952d\";s:8:\"uploads0\";s:64:\"9c68070eeb547187b884e96e92d1918963309b18a88fb3f755b227faf6f64718\";s:7:\"others0\";s:64:\"58ad46b18858e17cab9110e09fad10e14ee3fe29226d2398152eca72592e7570\";s:5:\"more0\";s:64:\"c80995de25029bffb7c20c4a0adab06b22d38befbc528d3af3978255b5fbb3cc\";s:3:\"db0\";s:64:\"d5a0cdf31090b50a2d7296ad5d49f0ee62852e011c4d3adccf877e3ae19b726d\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-03-1443_Pawlowski_Mastrilli_Law_Group_bb1c7b45f085_backup_meta_6.4.3.tmp\";s:5:\"nonce\";s:12:\"bb1c7b45f085\";s:7:\"service\";a:1:{i:0;s:7:\"dropbox\";}s:15:\"service_setting\";a:9:{s:6:\"appkey\";s:15:\"hp3xgdihd8qzfdt\";s:6:\"secret\";s:15:\"l3tbnc76wna729g\";s:6:\"folder\";s:6:\"weekly\";s:15:\"tk_access_token\";s:856:\"RAL3yxrnvjU0P/eOdqOynSng7JULpavT0ULGQyaIXL2l+w9EdBU6dX5wqMH1gqY42PBuvVOom8xLN9bq3Kv1LU2FANqa5rMzKo3hwD+uB7dynHe6Uix2ZEu7MEfFZbEic5RnIOypuPvzpB1uV3ZlDaL3Cv5JlXazah7GUNZYUFccCo0wmLDJfZ/SaXHKrWnDuq+eiyeZq67Rja0D2Q6cIkbrjmsKUFyOSrggZw39eCoeZtEAh/Cuc/IdJ7JcKBjNeZuiyFyaZW5ZMPqmLP1Z8dlNvDFeGK4eTbZKOLscTUuLuXYpoRNYnHAbsQUIaK1j6qM1qiv//W9gG/RxG3v35lkgOeC56aNSMYA2OcJNRQLeyDPqWzKgaBAmEjP7yQm6NVtViphLTHp1XK1KQfvVSd52LOz2TzdnPz0XbPkijqeN8VidGTD5tulPsglpiQipRu/9O++zUQVOz4GpHvakxUs8z1HNTGblDNLa+HRybjqtB80AbWpbXLom/n+BKvNr0+C13/7sUsbo+m3dlweSUe+d5IAYF7bB60wNkQGwZCDCEKfpQh+TWM3JN7f4xsTRQ6OmG5rs8+wkuiRNtrSaEx1qzF8skN3Rmq5fQ1V56JsoldRXknwVMy9nD8fsdMZmtU+GDTMUqCWOO4UK5FL/Zspw6EC5G1EX09f02H6Ys62KaMOZAHS6SfdtTktzllOI48XfWTvqK6JRf+KpqUixcE3B2udy1aEEydAmrSlEdNNxP6fq4iasxAyTUzXVIha+AwsKpKINTXPwrXeAdXzlyJavAhYp0QVC9Yf2wlyDUBv+bZcI6kzjGDmq1IjbGC6HD5VmiMAApPOFfCzlireWpg==\";s:9:\"ownername\";s:0:\"\";s:4:\"CSRF\";s:0:\"\";s:19:\"dropbox_site_folder\";s:1:\"1\";s:5:\"email\";s:22:\"support@nextclient.com\";s:7:\"version\";i:1;}s:5:\"label\";s:32:\"401668daba8815b38c9036630c604d1c\";s:11:\"backup_name\";s:35:\"Weekly Full Backup - MileMark (A-M)\";s:18:\"created_by_version\";s:6:\"1.12.5\";s:12:\"is_multisite\";b:0;s:14:\"wp_content_url\";s:38:\"https://www.megajustice.com/wp-content\";s:15:\"wp_content_path\";s:76:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/wp-content\";s:7:\"old_url\";s:27:\"https://www.megajustice.com\";s:13:\"old_file_path\";s:66:\"/mnt/stor3-wc2-dfw1/483892/974207/www.megajustice.com/web/content/\";}}',	'yes'),
(907992,	'IWP_last_backup',	'a:5:{s:11:\"backup_time\";i:1709278448;s:12:\"backup_array\";a:4:{s:2:\"db\";s:64:\"megajustice.com_backup_2024-02-29-2334__51a20c6df549_6.4.3-db.gz\";s:7:\"db-size\";i:5219746;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:1:{s:3:\"db0\";s:40:\"a3a46bd9d0916ad4a47e9ddef26ab843cf487015\";}s:6:\"sha256\";a:1:{s:3:\"db0\";s:64:\"bbaed635eb36578dbbbf03dd18543a4c17f9bef6afca5959921da5787eb1abfd\";}}s:20:\"backup_file_basename\";s:103:\"megajustice.com_backup_2024-02-29-2334_Pawlowski_Mastrilli_Law_Group_51a20c6df549_backup_meta_6.4.3.tmp\";}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"51a20c6df549\";}',	'yes'),
(913645,	'IWP_googledrive',	'a:7:{s:8:\"clientid\";s:72:\"287234391709-kth4me2r0qabg4s6q6ibn10er6ktm1ol.apps.googleusercontent.com\";s:6:\"secret\";s:35:\"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\";s:5:\"token\";s:102:\"1//061Q5fq2sTn2OCgYIARAAGAYSNgF-L9IrnI8gYrqvWGw65P6TXAnc1RN_oQ98bvZ7Xbb0geqaQ4cc5jwqHf4OVJET1JRwsqfCDQ\";s:16:\"tmp_access_token\";s:218:\"ya29.a0AfB_byDm7Kniio7JWkPTk22alwAV2U-RjVCASG1niBXfWElJJT1fkXZTN8PHIQ_UUs527EEzZkjEWc0QvVcsjBEMmZ3G0_GFphm5hSYIMS_fcGubq6JlXGPaqX9R30Y-klF2ai35PHINrPXoS_Ufl8wF_mzHQb93MH2LaCgYKATMSARASFQHGX2Miupi5553pW9bf596IIg0Mxw0171\";s:18:\"gdrive_site_folder\";s:1:\"1\";s:9:\"ownername\";s:0:\"\";s:7:\"version\";i:1;}',	'yes'),
(913650,	'IWP_last_scheduled_fd',	'1708794907',	'yes'),
(914310,	'mwp_service_key',	'4543493c-65d9-4cd9-9a3b-d2547ed185e4',	'yes'),
(914313,	'mwp_openssl_parameters',	'a:2:{s:4:\"time\";i:1709252584;s:7:\"working\";b:1;}',	'yes'),
(914316,	'mwp_incremental_update_active',	'',	'yes'),
(914317,	'mwp_recovering',	'',	'yes'),
(914318,	'mwp_core_autoupdate',	'',	'yes'),
(914319,	'mwp_container_parameters',	'a:0:{}',	'yes'),
(914320,	'mwp_container_site_parameters',	'a:0:{}',	'yes'),
(914321,	'mwp_maintenace_mode',	'a:0:{}',	'yes'),
(914323,	'worker_migration_version',	'2',	'yes'),
(914324,	'_worker_nossl_key',	'',	'yes'),
(914325,	'_worker_public_key',	'LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUE0azJhazdtS0tDS0o5K2ZaNW5rMwpsaDQ2RW5KcVEzVEI4RVV5VDNyemlEOGE4YWJPSVBQSEtVU2c4M0xZaldydG8wdGs5WUZiU1RUekhsK1hPQTNPCkw0eHNxdlpFOER6OXZtelNkN1k2NSttWlZlbDFEbktwRkh6aGJ0bVZLemZiTEFBenByemV4ZnN3ZGVIUHEwQ1EKVkJhQk1vM0xaYUluQVlocnZsTW0xZWlyWWYwZmkwbzVId2wxNEk3c1NHNVFMOThIQmZjRnN5ejVIY2o5aTUrOQpsemRMYnRhKytiNXI5ekFJR3BULzN6STRBN1JMd05pYmNhcFNPV0VXTkp4aEE3VFBBbnU5NmdFZjVmUWw1bGRRCldpNkgxT3N1YkxoLzFLTlkwWEw3ckJwdktQYUpGZGFWcFBBQkVBRDZ3OEpNM0M1dFVOTzJINUpWZnVVWFBIY00KdlFJREFRQUIKLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg==',	'yes'),
(914327,	'mwp_worker_configuration',	'a:9:{s:10:\"master_url\";s:21:\"https://managewp.com/\";s:15:\"master_cron_url\";s:75:\"https://managewp.com/wp-content/plugins/master/mwp-notifications-handle.php\";s:20:\"noti_cache_life_time\";s:5:\"86400\";s:27:\"noti_treshold_spam_comments\";s:2:\"10\";s:30:\"noti_treshold_pending_comments\";s:1:\"0\";s:31:\"noti_treshold_approved_comments\";s:1:\"0\";s:19:\"noti_treshold_posts\";s:1:\"0\";s:20:\"noti_treshold_drafts\";s:1:\"0\";s:8:\"key_name\";s:8:\"managewp\";}',	'yes'),
(914331,	'mwp_communication_keys',	'a:1:{i:13748774;a:2:{s:3:\"key\";s:36:\"ede6ceb6-9a9d-4658-a79f-0dd5a24b80bd\";s:5:\"added\";i:1704061080;}}',	'yes'),
(914332,	'mwp_key_last_used_ede6ceb6-9a9d-4658-a79f-0dd5a24b80bd',	'1704061080',	'yes'),
(914333,	'mmb_stats_filter',	'a:1:{s:7:\"plugins\";a:1:{s:7:\"cleanup\";a:1:{s:9:\"revisions\";a:1:{s:11:\"num_to_keep\";i:5;}}}}',	'yes'),
(914334,	'mwp_public_keys_refresh_time',	'1709245188',	'yes'),
(914335,	'mwp_public_keys',	'a:8:{i:0;a:6:{s:2:\"id\";s:19:\"managewp_1707357901\";s:7:\"service\";s:8:\"managewp\";s:9:\"validFrom\";s:19:\"2024-02-23 01:26:15\";s:7:\"validTo\";s:19:\"2024-03-26 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2AZiYTw/vuoqYk5JEEaY\nZCRrIRh2RYw4CsTl5jdfc2uJXibRnP71G8+/CHh7eyLbGBUQ5HNEbDlZPs90nKOH\nm28qpnOzzJY7g3m0KMLizR3Ru0+r+u8sUOcU77BJgChOlC1VUmtvo0WBYaO2ECXt\n3MNU1em/fj3UkkghDewjZ/ltngZx497BNuRVCLvXBGdEef7N/EjoW3JPR0W6dOy+\nLQWKWrsG9B21AeNqLVqTIWjr8x9CbjREO/BsEhc/9lKJfJ83IH+fVivu2dv7Rka0\nucWQfG1TAtp/avSCtpaLWgWHLmGLkiEEjtCW2gnb2PVGzHj36n6dbQgcNW/zHOEq\noQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:1;a:6:{s:2:\"id\";s:23:\"managewp_dev_1707357902\";s:7:\"service\";s:12:\"managewp_dev\";s:9:\"validFrom\";s:19:\"2024-02-23 01:26:15\";s:7:\"validTo\";s:19:\"2024-03-26 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3D3GkAX5rSAU1AdCnS/r\nswVEWRN5JYseZhqO4XfBdZ1/CKFenl9cPLB6pImupgq7BXz7qHuKknSytVmDU+Gw\n2D38mKDZid2bRUHrBQB9rPx0hUi4m+GeLHc0lcAQFaaEA2NwucSV5hstiHbHk/Hc\n9Kzm2h2jW8/mvenUBVmj7FJ9L6QLT7VhYL1SotXLlPGZY4mdP682FR7MXZp7qCYz\ndInQ5Yp0L1nfjlcKVHjf9gXmh4KtEbnNNSjclvr1jZ4eToqX3jmVxTm3GakqYAAC\nIVH4jTdZt5o9umSfBfPheMQ5dalv2uMaOL8XfRKK2kUJ2zP1275I5kDD3oR3a4gF\nSQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:0;}i:2;a:6:{s:2:\"id\";s:16:\"mwp20_1707357902\";s:7:\"service\";s:5:\"mwp20\";s:9:\"validFrom\";s:19:\"2024-02-23 01:26:15\";s:7:\"validTo\";s:19:\"2024-03-26 01:26:15\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmMXJdyNFjzonZPFZBJIw\nhRMTMs/X+GOajOh3FdhUa1LEiV3Y878HJaURzRvZcVK26ERZ+aROU7amXoKKOqGY\niWsrwGAVkRje+ncu5QaJB1SlPezN2Y5VJdY6waIBvN0B+DODlVJM4ONl31KggiTw\n/sZcpPJtvf/KFjOSDIJOsp/bTyOi6C7sxY+RazWloo3DcsqGsK828InYqVDW0JMs\nLq8kS3VijZARyJPXAiZjphJvpO3nytnhV+awycy4nnxcMYU5MLJEV1NyKQPO50rG\n+xsD/wzcnRGQ1XhQA4sp9YiJ30BjEXH5miKwF2VQ8o+eJcDqLT+rKGEZLUgwB35v\n/wIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:3;a:6:{s:2:\"id\";s:15:\"wpps_1706965502\";s:7:\"service\";s:4:\"wpps\";s:9:\"validFrom\";s:19:\"2024-02-18 13:05:01\";s:7:\"validTo\";s:19:\"2024-03-21 13:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuOce1Siv9dtwAYeUn2TG\nm7usSVpXFfBBeFYqqNtQ4Yg/kgfN/48++Yd26FpjLICapmJwKd1jxLps3WleZila\nlZzCw5oRZ+j6Oh52Zt6sJRe48iH9Oq4A0dVwB4HVziUbvp/wgZeNadBZ86dQQ0Em\n1VOTO3vq/qZ16CmJO+LkAIIUavhaowQb0uMyIh1X8hcjhO3BhbT+zdtHNaXEeOSI\nZx8PKp4hDPmkihTBZRdRkCKTtvvpQvMV2B22WCKCFJy8owKvhkb47XRYaYguTJLQ\n98SIgh+RFoTM7kX3BCg+AV40t7u8KtX5qSfHkvIX25EoNdruFX1fwPi8uFKIOJEI\n8wIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:4;a:6:{s:2:\"id\";s:25:\"cookie_service_1705597501\";s:7:\"service\";s:14:\"cookie_service\";s:9:\"validFrom\";s:19:\"2024-02-02 16:27:25\";s:7:\"validTo\";s:19:\"2024-03-05 16:27:25\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAohNfBD9pEav7YKnSV7VX\n1KlDsl3YmK+RTZ/ehmTiYDAk7SFs0PRt3QBl+ZczimDOKpf5e8te+R3CFL03SYRK\nDRAaw/e/5Fk5ctXSlS5leKyt6oIX3xCUmw/3ffTddJRxD3ViadMZYnJNhI1XxUMl\ng9szagLGqBOom4AVZXml0EJvSG/73PYLCCq1HjYfu/viesCfPAlTmgRhp94wW12y\nzr/hx3rC1dOwtXrU6R/eKOllCyDyLucgGQnNmLXOapl7lnAzE5NC04GGVuk0O3ke\niPHL9vEGALthnCst105afq84WKkWYeU2NE4IH5d/CYlwYfgv2MXe3wfzLD5LlkhJ\n/QIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:5;a:6:{s:2:\"id\";s:25:\"cookie_service_1708189501\";s:7:\"service\";s:14:\"cookie_service\";s:9:\"validFrom\";s:19:\"2024-03-03 16:27:25\";s:7:\"validTo\";s:19:\"2024-04-04 16:27:25\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA1v3AhRNOLFANL7fNXOxk\nT+qx2cFKVljQ0rIPYxLKSZrs/R/9ebX6rKbr4tAvW6bAmSWCPyUfFy6Zi2xwLs+I\n3z1ZDLxbkB2ovvDSElM8Q0HQ1S25tmXlSQRo9fMesAD53FOpin20xycsgWXhhIZG\np0d6P1Ue8oWMr5q/wrdWbGG2eP6c/rhizNHk5biNwOr4tJwyd0vN8brW32PD22V9\n97S/fanzpCfUdtXAQNCVFUDaqW/3q5HAxO2KzLwMllU64UDy105ztoI2qYVxYkoL\nld2y5Tnjd1WLc1hk/A3ZUdOBPA5dB6idYYiRWmJuScfyeGVkpLfu629ToWKm4ei4\n4wIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:6;a:6:{s:2:\"id\";s:15:\"mwp1_1707055501\";s:7:\"service\";s:4:\"mwp1\";s:9:\"validFrom\";s:19:\"2024-02-19 14:05:01\";s:7:\"validTo\";s:19:\"2024-03-22 14:05:01\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtNDLDiGIXhkkxuLPxhRI\nUEYwxqZ6hf0hvixpkPKzItpG3G5BpbQiMCssmiuVLVv3Hom+1OoOmdAU2Jbd74w8\ndp/pi8b8cOzKv6mGoqV7virrJ+X92+KPCP18rGFT7+ol3vewy9kXSU2qm+61Hkl0\nh1ajD7bzR+moKTVp/JNOmBB3X0Fz4DZ+zMP2RLIL6Po7/EVvRQYgE/PB5iuOn3WS\nUBHsRkm9pIGejKLzfgQ/BS3lItAOcSqtY4OUUkaEHYpglRY8Y1H7zU8mje4iwgXP\ngbP9SowV6jXkMohk23p3FzZKfivDTYjQeV7t0J3CkgpYX9hXxAU9u9ynSZDBIfE1\nkQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}i:7;a:6:{s:2:\"id\";s:20:\"migration_1707311102\";s:7:\"service\";s:9:\"migration\";s:9:\"validFrom\";s:19:\"2024-02-22 13:05:02\";s:7:\"validTo\";s:19:\"2024-03-25 13:05:02\";s:9:\"publicKey\";s:451:\"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAndOOC2/C7skcKeFSp9T5\nPXs5c0MGdQd/WFVukALBpKdMaKpuxtnbog4k2o9Qva2ACUe1gWk3obpeFp+gAqq5\n8NJquQubSzHJrds24KE+YDs62ASGph4jE9vFpHIJ4r/8CpPZsbGLJHtqaE6yK+Rc\nmYaaM63s0Lq3JWlwOG2b7kaS/z94uvgsizuh39t9OrBsOQK40cMrvNuu2B5U3V91\nQSiCzD3zGomKvVr+Dl0gbIpHkoN8I/YnULepP5+VfN6v76c53g+JkGvE7L8E37Fz\nmD5O1JgkZsBxaQ8kzey/mdrbQ9uMI1mzKCpQBJVkPUfUj+EKfLNk0WAfTZ0vIb/C\nTQIDAQAB\n-----END PUBLIC KEY-----\n\";s:13:\"useServiceKey\";b:1;}}',	'yes'),
(914336,	'mwp_potential_key',	'8ba157fc-76f2-463c-be4d-f7b7e8b4a079',	'yes'),
(914337,	'mwp_potential_key_time',	'1709252584',	'yes'),
(914338,	'user_hit_count',	'a:60:{s:10:\"2024-01-02\";i:390;s:10:\"2024-01-03\";i:440;s:10:\"2024-01-04\";i:230;s:10:\"2024-01-05\";i:312;s:10:\"2024-01-06\";i:3602;s:10:\"2024-01-07\";i:12282;s:10:\"2024-01-08\";i:18047;s:10:\"2024-01-09\";i:4524;s:10:\"2024-01-10\";i:391;s:10:\"2024-01-11\";i:300;s:10:\"2024-01-12\";i:306;s:10:\"2024-01-13\";i:339;s:10:\"2024-01-14\";i:255;s:10:\"2024-01-15\";i:363;s:10:\"2024-01-16\";i:1049;s:10:\"2024-01-17\";i:308;s:10:\"2024-01-18\";i:279;s:10:\"2024-01-19\";i:290;s:10:\"2024-01-20\";i:264;s:10:\"2024-01-21\";i:249;s:10:\"2024-01-22\";i:326;s:10:\"2024-01-23\";i:220;s:10:\"2024-01-24\";i:316;s:10:\"2024-01-25\";i:381;s:10:\"2024-01-26\";i:261;s:10:\"2024-01-27\";i:394;s:10:\"2024-01-28\";i:370;s:10:\"2024-01-29\";i:359;s:10:\"2024-01-30\";i:497;s:10:\"2024-01-31\";i:465;s:10:\"2024-02-01\";i:702;s:10:\"2024-02-02\";i:755;s:10:\"2024-02-03\";i:584;s:10:\"2024-02-04\";i:499;s:10:\"2024-02-05\";i:1434;s:10:\"2024-02-06\";i:340;s:10:\"2024-02-07\";i:530;s:10:\"2024-02-08\";i:232;s:10:\"2024-02-09\";i:227;s:10:\"2024-02-10\";i:1501;s:10:\"2024-02-11\";i:246;s:10:\"2024-02-12\";i:415;s:10:\"2024-02-13\";i:675;s:10:\"2024-02-14\";i:471;s:10:\"2024-02-15\";i:317;s:10:\"2024-02-16\";i:305;s:10:\"2024-02-17\";i:438;s:10:\"2024-02-18\";i:186;s:10:\"2024-02-19\";i:679;s:10:\"2024-02-20\";i:349;s:10:\"2024-02-21\";i:391;s:10:\"2024-02-22\";i:667;s:10:\"2024-02-23\";i:900;s:10:\"2024-02-24\";i:441;s:10:\"2024-02-25\";i:344;s:10:\"2024-02-26\";i:305;s:10:\"2024-02-27\";i:545;s:10:\"2024-02-28\";i:338;s:10:\"2024-02-29\";i:800;s:10:\"2024-03-01\";i:301;}',	'yes'),
(914339,	'mwp_key_last_used_13748774',	'1707419394',	'yes'),
(914340,	'mwp_new_communication_established',	'1',	'yes'),
(921867,	'IWP_unlocked_d',	'1',	'no'),
(921868,	'IWP_last_lock_time_d',	'2024-03-01 07:34:08',	'no'),
(921869,	'IWP_semaphore_d',	'0',	'no'),
(921870,	'IWP_backup_status',	'0',	'yes'),
(929288,	'IWP_unlocked_fd',	'1',	'no'),
(929289,	'IWP_last_lock_time_fd',	'2024-02-24 17:15:07',	'no'),
(929290,	'IWP_semaphore_fd',	'0',	'no'),
(948445,	'_transient_timeout_wpr_dynamic_lists_delayjs',	'1709479996',	'no'),
(948446,	'_transient_wpr_dynamic_lists_delayjs',	'O:8:\"stdClass\":3:{s:7:\"plugins\";O:8:\"stdClass\":207:{s:36:\"ffc21030-519a-4853-8cea-49f959e82731\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:def67a2c1ddd6df2353e4772b6fd4e5b\";s:5:\"title\";s:51:\"Additional Variation Images Gallery for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:45:\"/woo-variation-gallery/assets/js/slick.min.js\";i:3;s:48:\"/woo-variation-gallery/assets/js/frontend.min.js\";i:4;s:33:\"/wp-includes/js/underscore.min.js\";i:5;s:23:\"variation_custom_fields\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:47:\"woo-variation-gallery/woo-variation-gallery.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"0e7dc253-acd0-4421-877f-a7101d848717\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:4b82cc7379d46c6272f5d556bb264eec\";s:5:\"title\";s:12:\"Advanced Ads\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:16:\"/uploads/(.*).js\";i:3;s:18:\"advanced_ads_ready\";i:4;s:14:\"advadsCfpQueue\";i:5;s:11:\"adsbygoogle\";i:6;s:16:\"adservice.google\";i:7;s:17:\"/advanced-ads(.*)\";i:8;s:12:\"advads_items\";i:9;s:19:\"advads_tracking_ads\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"advanced-ads/advanced-ads.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"a4d5c058-9120-47ee-977c-f30f83fb1a75\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:a076fbb79772f497349a76ee74a7f708\";s:5:\"title\";s:52:\"All-in-one Compliance for GDPR / CCPA Cookie Consent\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:13:\"iubenda_cs.js\";i:1;s:8:\"var _iub\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:55:\"iubenda-cookie-law-solution/iubenda_cookie_solution.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"79a5082f-821a-4a4b-a0e3-caaf22cf3f75\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:9bdceaa1bb89135730a3b2aa4db94c22\";s:5:\"title\";s:17:\"AMO Team Showcase\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:40:\"/amo-team-showcase/public/js/wookmark.js\";i:3;s:56:\"/amo-team-showcase/public/js/amo-team-showcase-public.js\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:11:\"amoTeamVars\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:39:\"amo-team-showcase/amo-team-showcase.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"90c7fd90-3adf-4cb7-8a92-845bdbd95d27\";O:8:\"stdClass\":8:{s:5:\"title\";s:46:\"Anti-Spam by CleanTalk - Prevent console error\";s:9:\"condition\";s:36:\"cleantalk-spam-protect/cleantalk.php\";s:10:\"exclusions\";a:2:{i:0;s:17:\"ctPublicFunctions\";i:1;s:8:\"ctPublic\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ed2ade77cd44e21b1703b093c002a903\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1699370420;}s:36:\"e054f840-700a-4549-bbba-485473a53f71\";O:8:\"stdClass\":8:{s:5:\"title\";s:39:\"AnWP Football Leagues - Calendar Widget\";s:9:\"condition\";s:53:\"football-leagues-by-anwppro/anwp-football-leagues.php\";s:10:\"exclusions\";a:6:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:33:\"/football-leagues-by-anwppro/(.*)\";i:2;s:49:\"/football-leagues-by-anwppro-premium-premium/(.*)\";i:3;s:16:\"window.AnWPFLPro\";i:4;s:22:\"window.AnWPFLTabulator\";i:5;s:48:\"/elementor/assets/lib/flatpickr/flatpickr.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e7581089f33fdf0a970d5c5deb16ff50\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1708535321;}s:36:\"1d058cae-4460-4354-bab3-a96445650bd8\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:b739df50f3f5bf400075f17dca652517\";s:5:\"title\";s:22:\"AnyWhere Elementor Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:38:\"/anywhere-elementor-pro/build/index.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:49:\"anywhere-elementor-pro/anywhere-elementor-pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"8a1614c7-55b1-4b6d-88e5-6e8ddc630dae\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:46741e77eaf4d13a0c80be6b86379758\";s:5:\"title\";s:17:\"Astra - Pro Addon\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:32:\"/astra-addon/astra-addon-(.*).js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"astra-addon/astra-addon.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"37d96403-f9ea-4481-b2f8-374d7c93e61a\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:ccd87807930a1856717fd276c336db9a\";s:5:\"title\";s:14:\"Beaver Builder\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/uploads/bb-plugin/\";i:3;s:25:\"/bb-plugin/js/yui3.min.js\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:33:\"/bb-plugin/js/fl-slideshow.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:42:\"beaver-builder-lite-version/fl-builder.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f83dbf3b-783e-4ef9-9b18-8a469ca7102d\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Bloom\";s:9:\"condition\";s:15:\"bloom/bloom.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:7:\"/bloom/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e57cdfbc09f4e0f7445c279d9f580bdd\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1685189070;}s:36:\"135aadd2-cd4a-44ae-8dcf-801f3f2316c0\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:055ef01accbad6378e3d1a4965600964\";s:5:\"title\";s:6:\"Booked\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:8:\"/booked/\";i:1;s:31:\"/js/jquery/ui/datepicker.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:17:\"booked/booked.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"ddfee9b0-e5a9-4d3f-8c21-b999cbb61c33\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:492f9b0d55f3bf07c68e915ea1dfb72a\";s:5:\"title\";s:6:\"Bookly\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:53:\"/bookly-responsive-appointment-booking-tool/frontend/\";i:3;s:13:\"window.bookly\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:51:\"bookly-responsive-appointment-booking-tool/main.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"7a013fd6-0881-4dbe-8e93-33edefe7f717\";O:8:\"stdClass\":8:{s:5:\"title\";s:14:\"Borlabs Cookie\";s:9:\"condition\";s:33:\"borlabs-cookie/borlabs-cookie.php\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"borlabsCookieConfig\";i:3;s:21:\"borlabs-cookie.min.js\";i:4;s:27:\"borlabsCookieContentBlocker\";i:5;s:16:\"BorlabsCookieBox\";i:6;s:12:\"allFbWidgets\";i:7;s:34:\"/borlabs-cookie/assets/javascript/\";i:8;s:21:\"borlabs-cookie-config\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e1ec2daca513de476bd3dae79366e9ab\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1702497952;}s:36:\"3999e680-4049-4494-945c-768cecc1a2c4\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:43019d66af7b41e65bb602c01e10c6a0\";s:5:\"title\";s:5:\"Brizy\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:58:\"/brizy/public/editor-build/(.*)-wp/editor/js/group-(.*).js\";i:3;s:55:\"/brizy/public/editor-build/(.*)-wp/editor/js/preview.js\";i:4;s:10:\"Brizy.emit\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:15:\"brizy/brizy.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"af4d9357-3def-42a1-86b7-419553444b4d\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5c317f9f244597d8f236ecb7d8e41752\";s:5:\"title\";s:52:\"Carousel Upsells and Related Product for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:76:\"/carousel-upsells-and-related-product-for-woocommerce/assets/js/glide.min.js\";i:1;s:22:\"carusel_poduct_related\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:91:\"carousel-upsells-and-related-product-for-woocommerce/ffxf-woo-glide-related-and-upsells.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"1d866d90-5451-43ba-a4d1-75b64f9235e1\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0a3a29603ebac8fe0808f64f5c8edbb2\";s:5:\"title\";s:26:\"clickskeks.at Cookiebanner\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:10:\"clickskeks\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:20:\"clickskeks/index.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c09695cc-2387-4416-881a-c0b392188a26\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Complianz\";s:9:\"condition\";s:33:\"complianz-gdpr/complianz-gpdr.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"complianz\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:a766f95208154cd69a3e15150a42f325\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1685188788;}s:36:\"b5e146fc-0b7c-4c6c-a631-8da246d3bd89\";O:8:\"stdClass\":8:{s:5:\"title\";s:36:\"Conerstone Builder - Fix mobile menu\";s:9:\"condition\";s:27:\"cornerstone/cornerstone.php\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:46:\"/cornerstone/assets/js/site/cs-classic.(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f8f8c81535b5e0073aa3c56b6dd3df5b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1708614275;}s:36:\"7e551e3b-fbe4-4235-87a9-b476bc9e2020\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:949b1b923d51d10a2fb67a2a39d166b3\";s:5:\"title\";s:11:\"Content Egg\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:42:\"/content-egg/res/js/morrisjs/morris.min.js\";i:3;s:43:\"/content-egg/res/js/morrisjs/raphael.min.js\";i:4;s:11:\"Morris.Area\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"content-egg/content-egg.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"7fbca6c5-9239-4550-a755-6f041f867a57\";O:8:\"stdClass\":8:{s:5:\"title\";s:42:\"Cookie Notice & Compliance for GDPR / CCPA\";s:9:\"condition\";s:31:\"cookie-notice/cookie-notice.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:15:\"/cookie-notice/\";i:3;s:10:\"var cnArgs\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:213d0f883ae27aefb3a7937656bbd11e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681379736;}s:36:\"26722567-fe35-44b5-a5a7-fb0f3a38c3f2\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:1d10ad30bbcf0fd4b26e9625a07abcfc\";s:5:\"title\";s:13:\"Cookiebot CMP\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:21:\"consent.cookiebot.com\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:23:\"cookiebot/cookiebot.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"74110e36-89e5-440d-bec3-7133da3277c2\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:edcf103293ceab711e999d419d038ca1\";s:5:\"title\";s:23:\"Coupon Referral Program\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:25:\"/coupon-referral-program/\";i:3;s:42:\"/wp-includes/js/jquery/ui/draggable.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:51:\"coupon-referral-program/coupon-referral-program.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"ed63e02f-d6c5-481a-bcb9-aae15f72aa21\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:c3e26264dcfd25802805b4fd1a2a449c\";s:5:\"title\";s:29:\"Crisp - Live Chat and Chatbot\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:20:\"CRISP_RUNTIME_CONFIG\";i:3;s:4:\"l.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:15:\"crisp/crisp.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"a8eb622b-279c-4f84-86e0-785e9497add7\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:6e4bf949e12f0bebfefb48f6c316102a\";s:5:\"title\";s:24:\"Custom Twitter Feeds pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:47:\"/custom-twitter-feeds-pro/js/ctf-scripts.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:48:\"custom-twitter-feeds-pro/custom-twitter-feed.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"1624ef15-e25b-406d-bdf9-d4b78d7a59e7\";O:8:\"stdClass\":8:{s:5:\"title\";s:39:\"Customer Reviews for WooCommerce Plugin\";s:9:\"condition\";s:38:\"customer-reviews-woocommerce/ivole.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:43:\"/customer-reviews-woocommerce/js/colcade.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1f893b343e72ce55e6c9013fbda172fa\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704734788;}s:36:\"c15fe3b3-0eaa-48f9-bf04-0e778b1f8c63\";O:8:\"stdClass\":8:{s:5:\"title\";s:14:\"Divi - Supreme\";s:9:\"condition\";s:53:\"supreme-modules-for-divi/supreme-modules-for-divi.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:26:\"/Divi/js/custom.unified.js\";i:5;s:21:\"/js/magnific-popup.js\";i:6;s:8:\"var DIVI\";i:7;s:26:\"/supreme-modules-for-divi/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b5489ae4d8b949f536d6dd2e5b0c1a95\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738701;}s:36:\"dd31451b-989a-4517-b02a-e2c2e2023366\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5caed322df984bbfd3ecb506cf12b688\";s:5:\"title\";s:12:\"Divi Den Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:54:\"/ddpro/build/freddie/js/freddieScriptPageTransition.js\";i:3;s:48:\"/ddpro/build/freddie/js/freddieScriptsHeaders.js\";i:4;s:49:\"/ddpro/build/freddie/js/freddieScriptsContents.js\";i:5;s:40:\"/ddpro/build/freddie/js/gsap/gsap.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:15:\"ddpro/ddpro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"2b006370-cc90-42c1-9656-a30fbfbc91c6\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:402d9b241b04934dd30f32e7ba490e63\";s:5:\"title\";s:11:\"Divi Mobile\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"divi-menu\";i:3;s:6:\"dm_nav\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"divi-mobile/divi-mobile.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"666bbed9-7ce3-457c-ad6e-b5e056d05010\";O:8:\"stdClass\":8:{s:5:\"title\";s:13:\"Divi Overlays\";s:9:\"condition\";s:31:\"divi-overlays/divi-overlays.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:26:\"/Divi/js/custom.unified.js\";i:5;s:8:\"var DIVI\";i:6;s:15:\"/divi-overlays/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1c828c93d87298d2a27c76e13d0880ba\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738664;}s:36:\"42a404af-7792-44be-9baa-565dc3baf25d\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"Divi Pixel\";s:9:\"condition\";s:25:\"divi-pixel/divi-pixel.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:43:\"/divi-pixel/dist/public/js/hamburger.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:dd2494945a487a6cc74d3ab1b2137ccb\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1686859169;}s:36:\"85f5c099-c481-4c38-bbb9-8b76113bdfd5\";O:8:\"stdClass\":8:{s:5:\"title\";s:16:\"Divi Supreme Pro\";s:9:\"condition\";s:61:\"supreme-modules-pro-for-divi/supreme-modules-pro-for-divi.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"elm.style.display\";i:3;s:76:\"/supreme-modules-pro-for-divi/includes/modules/ImageCarousel/frontend.min.js\";i:4;s:60:\"/supreme-modules-pro-for-divi/public/js/swiper-bundle.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3d5f0ae7751702fd1bb490fcf991a334\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1695118162;}s:36:\"0b78d762-c7be-45de-9aae-0c5078ec0619\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:b5fc0101608d0b0627268dc49e3e1f8f\";s:5:\"title\";s:12:\"Divi Toolbox\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:20:\"jQuery(\'.preloader\')\";i:3;s:42:\"/divi-toolbox/assets/js/toolbox-scripts.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"divi-toolbox/divi-toolbox.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"31a34440-1383-40c4-8920-effcf99f2165\";O:8:\"stdClass\":8:{s:5:\"title\";s:17:\"Dracula Dark Mode\";s:9:\"condition\";s:36:\"dracula-dark-mode-premium/plugin.php\";s:10:\"exclusions\";a:9:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:68:\"/wp-content/plugins/dracula-dark-mode-premium/assets/js/dark-mode.js\";i:2;s:67:\"/wp-content/plugins/dracula-dark-mode-premium/assets/js/frontend.js\";i:3;s:44:\"/wp-includes/js/dist/vendor/react-dom.min.js\";i:4;s:40:\"/wp-includes/js/dist/vendor/react.min.js\";i:5;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:6;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:7;s:32:\"/wp-includes/js/dist/i18n.min.js\";i:8;s:15:\"draculaDarkMode\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5e8a5d8d3830136d84d0f3676f1bf5a5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704210236;}s:36:\"8baba0f8-4449-47d8-a87d-9b6a116e7684\";O:8:\"stdClass\":8:{s:5:\"title\";s:48:\"Dynamic Pricing & Discounts Lite for WooCommerce\";s:9:\"condition\";s:85:\"woo-dynamic-pricing-discounts-lite/dynamic-pricing-discounts-lite-for-woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:79:\"/woo-dynamic-pricing-discounts-lite/assets/OwlCarousel/dist/owl.carousel.min.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:185062bf08db42515488e1853d1f4917\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677857247;}s:36:\"0fa129f2-5869-4db7-9bf0-69e4b3549ee2\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:27478327aa44075a86176fad95640d76\";s:5:\"title\";s:39:\"Dynamic Product Gallery for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/woocommerce-dynamic-gallery/\";i:3;s:21:\"a3revWCDynamicGallery\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:62:\"woocommerce-dynamic-gallery/wc_dynamic_gallery_woocommerce.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"9958c6be-2f67-4791-95c3-a7ad96d599c0\";O:8:\"stdClass\":8:{s:5:\"title\";s:47:\"Dynamic Product Gallery Premium for WooCommerce\";s:9:\"condition\";s:66:\"woocommerce-dynamic-gallery-pro/wc_dynamic_gallery_woocommerce.php\";s:10:\"exclusions\";a:5:{i:0;s:55:\"/jquery-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:55:\"/jquery-migrate(.*)(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:2;s:74:\"/woocommerce-dynamic-gallery-pro/assets/js/mygallery/jquery.a3-dgallery.js\";i:3;s:18:\"settings_defaults_\";i:4;s:21:\"a3revWCDynamicGallery\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:11dc02a76019f00422f4ac85f47f5135\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683208937;}s:36:\"ce26ed21-1be5-481f-80d4-31edfac6d890\";O:8:\"stdClass\":8:{s:5:\"title\";s:43:\"Dynamic.ooo - Dynamic Content for Elementor\";s:9:\"condition\";s:63:\"dynamic-content-for-elementor/dynamic-content-for-elementor.php\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:38:\"/dynamic-content-for-elementor/assets/\";i:8;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:9;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:d2bd5b348abe016bdc722acce7755062\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683355024;}s:36:\"6a3161a6-1a6f-457a-a9ee-54b376981927\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:ee1dec033c6481a77fe88de5bef1a02d\";s:5:\"title\";s:22:\"Easy Table of Contents\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:46:\"/easy-table-of-contents/assets/js/front.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:49:\"easy-table-of-contents/easy-table-of-contents.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"25a534a0-2c1f-4cf4-9e19-7941bc032b3a\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"Ecwid Ecommerce Shopping Cart\";s:9:\"condition\";s:43:\"ecwid-shopping-cart/ecwid-shopping-cart.php\";s:10:\"exclusions\";a:11:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:23:\"app.ecwid.com/script.js\";i:3;s:35:\"/ecwid-shopping-cart/js/frontend.js\";i:4;s:38:\"/ecwid-shopping-cart/js/static-page.js\";i:5;s:20:\"ecwidParamswindow.ec\";i:6;s:13:\"jQuery.mobile\";i:7;s:7:\"xSearch\";i:8;s:13:\"xCategoriesV2\";i:9;s:15:\"xProductBrowser\";i:10;s:10:\"Ecwid.init\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:41c8f5f0ab00cb39654aedd783d194e0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704734846;}s:36:\"40464325-5bae-4a20-bc97-553499e09a73\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Elementor\";s:9:\"condition\";s:23:\"elementor/elementor.php\";s:10:\"exclusions\";a:13:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:28:\"/happy-elementor-addons-pro/\";i:8;s:43:\"/header-footer-elementor/inc/js/frontend.js\";i:9;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:10;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:11;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:12;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1d15783218a3137bec4ee8df5353e218\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694425872;}s:36:\"ac86b64c-c80a-4053-894d-6caa8b4fdce8\";O:8:\"stdClass\":8:{s:5:\"title\";s:25:\"Elementor  Loop Carrousel\";s:9:\"condition\";s:23:\"elementor/elementor.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:3;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:4;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:5;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0eb8d0bbd1c7ca05ac133ea634f676b7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694442056;}s:36:\"a8fc9fd1-f6d3-41eb-abe9-ef176de6d7e2\";O:8:\"stdClass\":8:{s:5:\"title\";s:39:\"Elementor - Lazy Load Background Images\";s:9:\"condition\";s:23:\"elementor/elementor.php\";s:10:\"exclusions\";a:1:{i:0;s:19:\"lazyloadRunObserver\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:bf248cb2876558452a566c5dd89262b8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694453032;}s:36:\"1948aff5-7850-4979-91fa-0ce181484508\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:de658ae6c2d05a5a4a947efecf5e0c16\";s:5:\"title\";s:21:\"Elementor Custom Skin\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:31:\"/ele-custom-skin(.*)/assets/js/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:35:\"ele-custom-skin/ele-custom-skin.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"25708299-c596-4416-8ad8-740aee0f2752\";O:8:\"stdClass\":8:{s:5:\"title\";s:13:\"Elementor Pro\";s:9:\"condition\";s:31:\"elementor-pro/elementor-pro.php\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:28:\"/happy-elementor-addons-pro/\";i:8;s:43:\"/header-footer-elementor/inc/js/frontend.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:030ad23e3851ed7adfa7b9b6c13cf5a6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679490021;}s:36:\"f34dd874-4b34-41e6-a31c-ece3c1efbffc\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:305581ad4294a30eeb1247982f626005\";s:5:\"title\";s:26:\"Elementor Pro - SmartMenus\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:61:\"/elementor-pro/assets/lib/smartmenus/jquery.smartmenus.min.js\";i:3;s:59:\"/elementor-pro/assets/js/preloaded-elements-handlers.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"elementor-pro/elementor-pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"111cc8b2-0be9-438b-9aa3-7f1e301a5697\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5ae9f5d99224d5ebc7d0c0bbf5b99787\";s:5:\"title\";s:26:\"Elementor Pro - User Cache\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:33:\"/wp-includes/js/underscore.min.js\";i:1;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:2;s:31:\"/wp-includes/js/backbone.min.js\";i:3;s:23:\"elementorAdminBarConfig\";i:4;s:21:\"elementorCommonConfig\";i:5;s:21:\"elementorWebCliConfig\";i:6;s:23:\"elementorDevToolsConfig\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"elementor-pro/elementor-pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c1713bf8-e0c3-4cb5-8b3f-841b06aa87ed\";O:8:\"stdClass\":8:{s:5:\"title\";s:27:\"ElementsKit Lite - Megamenu\";s:9:\"condition\";s:37:\"elementskit-lite/elementskit-lite.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:17:\"/elementskit(.*)/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b91fed2fc4478dbb7067742c1ee4691b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683270249;}s:36:\"706ff35d-8e33-4b04-a986-346faff704e9\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:417192424139d89fb2a5b1ee1f2b9613\";s:5:\"title\";s:30:\"Essential Addons for Elementor\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:55:\"/essential-addons(-for)?-elementor(-lite)?/.*(.min)?.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"b38556dc-2bc4-430f-9c55-7191cf7773db\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:057757d0593ad9d2dc58124f0077a5df\";s:5:\"title\";s:34:\"Essential Addons for Elementor Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:55:\"/essential-addons(-for)?-elementor(-lite)?/.*(.min)?.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:56:\"essential-addons-elementor/essential_adons_elementor.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"719b988f-0d60-40c2-ba46-88f943119cb1\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:c8e6c490f6438f566ade600c33531a85\";s:5:\"title\";s:14:\"Essential Grid\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:16:\"/essential-grid/\";i:3;s:15:\"lightboxOptions\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:33:\"essential-grid/essential-grid.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"47d3d2ab-160d-4b07-ac25-8250b9e6a951\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:dafd19fa48a1fef890dc4348052fcb75\";s:5:\"title\";s:12:\"EventON Lite\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:28:\"/eventon-lite/assets/js/(.*)\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:24:\"eventon-lite/eventon.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"219968d7-cf1f-4ee0-917a-db35dcc93a3e\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:49ff465628fc3cb6d7f23ff81d9b8339\";s:5:\"title\";s:7:\"FacetWP\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:36:\"/facetwp/assets/js/dist/front.min.js\";i:1;s:11:\"window.FWP_\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:17:\"facetwp/index.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"acce5701-5917-48d5-83ab-3e626aa420c5\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:78a1c88a56fa957c802074b6418c6fac\";s:5:\"title\";s:21:\"FacetWP - Flyout menu\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:34:\"/facetwp-flyout/assets/js/front.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:33:\"facetwp-flyout/facetwp-flyout.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f2a5b95f-1a22-46d2-8b72-42a53e46ae3f\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5d7555892a3a9968fde3fa3a335fc3d8\";s:5:\"title\";s:40:\"FiboSearch - Ajax Search for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:32:\"/wp-includes/js/jquery/jquery.js\";i:1;s:40:\"/wp-includes/js/jquery/jquery-migrate.js\";i:2;s:56:\"/ajax-search-for-woocommerce-premium/assets/js/search.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"7d1404e9-be76-449c-87aa-919557abe82d\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:ad46179e8b0584abaf52056b846da227\";s:5:\"title\";s:9:\"FlexBlock\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:41:\"/flo-flex-builder/dist/flex-public.min.js\";i:2;s:9:\"flexDebug\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:37:\"flo-flex-builder/flo-flex-builder.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"b9c6a2dc-b226-4e2c-b85e-29ee55b8f751\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:567a2b15db30ef6bd4904e4317139aac\";s:5:\"title\";s:12:\"Fluent Forms\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:29:\"/fluentform/public/js/(.*).js\";i:2;s:32:\"/fluentformpro/public/js/(.*).js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"fluentform/fluentform.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"10874f8a-2855-4e80-bc46-e484589b76a8\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:e78c153103f698b2b34892332d6b3b62\";s:5:\"title\";s:13:\"Flying Images\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:12:\"flyingImages\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"nazy-load/flying-images.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"53958499-dacd-41d6-93bc-1534fe7d9eda\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5a0e40a6c5783856893b803189de1404\";s:5:\"title\";s:18:\"FooGallery Premium\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:57:\"/plugins/foobox-image-lightbox/free/js/foobox.free.min.js\";i:3;s:88:\"/plugins/foogallery-premium/pro/extensions/default-templates/shared/js/foogallery.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:33:\"foogallery-premium/foogallery.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"7870d704-2024-4622-838c-fad37d5c6753\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:ebb5efb57b19ae60e734e456ca2df3f8\";s:5:\"title\";s:16:\"Formidable Forms\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:7:\"frmSigs\";i:3;s:45:\"/formidable-signature/js/frm.signature.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"formidable/formidable.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"3f24f9b3-e59e-400f-a784-999f93f60fab\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0b08523445b8869a67ca40e777704692\";s:5:\"title\";s:10:\"Forminator\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:9:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:15:\"forminatorFront\";i:3;s:42:\"/forminator/build/front/front.multi.min.js\";i:4;s:52:\"/forminator/assets/js/library/jquery.validate.min.js\";i:5;s:58:\"/forminator/assets/forminator-ui/js/forminator-form.min.js\";i:6;s:55:\"/forminator/assets/forminator-ui/js/select2.full.min.js\";i:7;s:43:\"/wp-includes/js/jquery/ui/datepicker.min.js\";i:8;s:41:\"/wp-includes/js/dist/vendor/moment.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"forminator/forminator.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"3a600ded-3454-48fb-9811-46afa2ab3c05\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5759bf0d47ac3457485314b381a9b528\";s:5:\"title\";s:22:\"GDPR Cookie Compliance\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:44:\"/gdpr-cookie-compliance/dist/scripts/main.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:37:\"gdpr-cookie-compliance/moove-gdpr.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"e21aaa5e-7354-471d-ab86-85f99f48830c\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:ffb40036ab0583218561de7c28c6bd9b\";s:5:\"title\";s:19:\"GDPR Cookie Consent\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:36:\"/public/js/cookie-law-info-public.js\";i:3;s:8:\"Cli_Data\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:49:\"webtoffee-gdpr-cookie-consent/cookie-law-info.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c11ca4ea-1a23-49ee-9a6b-1e549de50ea2\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:3877953c5ec1e66db92ad844ae8ebafc\";s:5:\"title\";s:25:\"Getwid - Gutenberg Blocks\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:37:\"/wp-includes/js/jquery/ui/tabs.min.js\";i:3;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:17:\"getwid/getwid.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"79b33eb9-bc92-4d8a-afd8-1c61e70bed8f\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"GiveWP\";s:9:\"condition\";s:13:\"give/give.php\";s:10:\"exclusions\";a:5:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:28:\"/give/assets/dist/js/give.js\";i:2;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:3;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:4;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0fb3af06fc5c710a670220b054c292c5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1706652232;}s:36:\"3773bb33-b168-4f68-9963-512da24ac4da\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"GoodLayers Core\";s:9:\"condition\";s:35:\"goodlayers-core/goodlayers-core.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:34:\"/goodlayers-core/plugins/script.js\";i:3;s:43:\"/goodlayers-core/include/js/page-builder.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5f124509a56ca2e0644246919ec70434\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704734904;}s:36:\"2adabe9b-6e03-4a67-959f-492813d40f69\";O:8:\"stdClass\":8:{s:5:\"title\";s:38:\"Google Tag Manager for WooCommerce PRO\";s:9:\"condition\";s:47:\"gtm-ecommerce-woo-pro/gtm-ecommerce-woo-pro.php\";s:10:\"exclusions\";a:1:{i:0;s:54:\"/gtm-ecommerce-woo-pro/assets/gtm-ecommerce-woo-pro.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e54fd4313007b6fedf8ab4df0e05277a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1691218549;}s:36:\"7bf261ac-89d4-492f-8a3d-1c5809b9579a\";O:8:\"stdClass\":8:{s:5:\"title\";s:13:\"Gravity Forms\";s:9:\"condition\";s:29:\"gravityforms/gravityforms.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:14:\"/gravityforms/\";i:2;s:5:\"gform\";i:3;s:9:\"recaptcha\";i:4;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:5;s:40:\"/wp-includes/js/plupload/plupload.min.js\";i:6;s:37:\"/wp-includes/js/plupload/moxie.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:7a1c1606d094f6bff83c0ee155908367\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694457903;}s:36:\"12340193-5c35-4b0d-b0bc-bea690cf1cae\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:2f3112dd98c39aeb6bde618c9026a29f\";s:5:\"title\";s:11:\"Green Forms\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:13:\"leform.min.js\";i:2;s:24:\"leform_customjs_handlers\";i:3;s:15:\"leform_ajax_url\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"green-forms/green-forms.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"4d20b427-47cf-4cdf-91c7-ff53602d3b2a\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0eb769dddc58f998e913345841b1d0b3\";s:5:\"title\";s:6:\"GTM4WP\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:9:\"dataLayer\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:81:\"duracelltomi-google-tag-manager/duracelltomi-google-tag-manager-for-wordpress.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"a2b3c237-728c-49d6-882a-e3885444e9b4\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:3b085ccda851ccf129d9506462f0cd65\";s:5:\"title\";s:10:\"GTranslate\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:20:\"translate.google.com\";i:1;s:26:\"googleTranslateElementInit\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"gtranslate/gtranslate.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"40cd9336-e73f-4a61-a7f6-27ec1ca6892c\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:e1f17c1eac230219e6fec3ac07406a0d\";s:5:\"title\";s:5:\"HBook\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:7:\"/hbook/\";i:3;s:20:\"hb_booking_form_data\";i:4;s:11:\"hb_max_date\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:15:\"hbook/hbook.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"192224c7-df72-4e3d-8f13-3206ac5b2e90\";O:8:\"stdClass\":8:{s:5:\"title\";s:37:\"Helper - OpenAI Chatbot for WordPress\";s:9:\"condition\";s:17:\"/helper/index.php\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:24:\"/helper/js/helper.min.js\";i:2;s:9:\"mdpHelper\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:07311d992a8a9d6af91e4766d2cb9ac9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1691599768;}s:36:\"99cfbb2e-5678-42c2-928f-5cb09d7e43da\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:269c5766fba124a838ac012a4b5a1a13\";s:5:\"title\";s:39:\"HUSKY - Products Filter for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/woocommerce-products-filter/(.*)\";i:3;s:4:\"woof\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:37:\"woocommerce-products-filter/index.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"3a964eac-4aeb-49a7-9fd6-4c31b2645dee\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:d457acfec0f86aac6733f1446f4fc94f\";s:5:\"title\";s:18:\"Instagram Feed Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:41:\"/instagram-feed-pro/js/sbi-scripts.min.js\";i:3;s:23:\"sb_instagram_js_options\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:37:\"instagram-feed-pro/instagram-feed.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"8f9f4788-1b8d-468b-b291-1fcbd48618b9\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:513b0c0ec8e12130af9b4bbbb17d7275\";s:5:\"title\";s:20:\"Interactive Geo Maps\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:66:\"/interactive-geo-maps-premium/assets/public/map-service/app.min.js\";i:3;s:54:\"/interactive-geo-maps/assets/public/map-service/app.js\";i:4;s:9:\"iMapsData\";i:5;s:21:\"cdn.amcharts.com/lib/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:45:\"interactive-geo-maps/interactive-geo-maps.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"cf650ca3-afa0-4a13-9e4f-f7cca19abac6\";O:8:\"stdClass\":8:{s:5:\"title\";s:12:\"Ivory Search\";s:9:\"condition\";s:41:\"add-search-to-menu/add-search-to-menu.php\";s:10:\"exclusions\";a:2:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:49:\"/add-search-to-menu/public/js/ivory-search.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:7430e9d2c985ae0a3339a7b7e1acc318\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677852711;}s:36:\"17a5dd54-1f5e-4d57-a56d-a8a970651954\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:1c8a1e1ba89a601f88654f094139b469\";s:5:\"title\";s:9:\"JetBlocks\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:39:\"/jet-blocks/assets/js/jet-blocks.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"jet-blocks/jet-blocks.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"b6f78c90-9823-459a-8dc1-1257e5f0d4e3\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:dac9ec782180f33d0fcc7c4e0e569b9d\";s:5:\"title\";s:7:\"JetBlog\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:15:\"/elementor-pro/\";i:3;s:11:\"/elementor/\";i:4;s:10:\"/jet-blog/\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:18:\"hasJetBlogPlaylist\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:21:\"jet-blog/jet-blog.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"e17173d8-6ef8-4e27-ba0f-379c9aea7eda\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0fe8895d1da5247b73a5d0b482df4ac4\";s:5:\"title\";s:11:\"JetElements\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:14:\"/jet-elements/\";i:7;s:18:\"hasJetBlogPlaylist\";i:8;s:11:\"jetElements\";i:9;s:26:\"/wp-includes/js/jquery/ui/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"jet-elements/jet-elements.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"cfd77501-9c9e-4f11-b994-0178a592fc08\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"JetEngine\";s:9:\"condition\";s:25:\"jet-engine/jet-engine.php\";s:10:\"exclusions\";a:1:{i:0;s:12:\"/jet-engine/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:bc998e71546860c8c7f70c45a6c18972\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1686208296;}s:36:\"36fed829-a2d9-41b5-94f6-2c3b9f07a94e\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:433a3173f2d06f7d02c7b91c06ed215d\";s:5:\"title\";s:7:\"JetMenu\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:13:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:15:\"/elementor-pro/\";i:3;s:11:\"/elementor/\";i:4;s:42:\"/jet-blog/assets/js/lib/slick/slick.min.js\";i:5;s:14:\"/jet-elements/\";i:6;s:10:\"/jet-menu/\";i:7;s:23:\"elementorFrontendConfig\";i:8;s:26:\"ElementorProFrontendConfig\";i:9;s:18:\"hasJetBlogPlaylist\";i:10;s:17:\"JetEngineSettings\";i:11;s:21:\"jetMenuPublicSettings\";i:12;s:37:\"/jet-reviews/assets/js/lib/vue.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:21:\"jet-menu/jet-menu.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"580cfed7-f034-4e39-bc7a-cdd01923ce87\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:51714cfdb43f231a1c93e7cffb1007ab\";s:5:\"title\";s:8:\"JetPopup\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:46:\"/jet-popup/assets/js/lib/anime-js/anime.min.js\";i:1;s:42:\"/jet-popup/assets/js/jet-popup-frontend.js\";i:2;s:17:\"/jet-woo-builder/\";i:3;s:16:\"var jetPopupData\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:23:\"jet-popup/jet-popup.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"d9cd2730-12e2-42d7-a082-6f0efcd466cc\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:df3bc4b6a8a9f28a5ba24cb7496bbc72\";s:5:\"title\";s:17:\"JetProductGallery\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:56:\"/jet-woo-product-gallery/assets/lib/swiper/swiper.min.js\";i:3;s:65:\"/jet-woo-product-gallery/assets/js/jet-woo-product-gallery.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:51:\"jet-woo-product-gallery/jet-woo-product-gallery.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"544aa37b-4d52-4182-99e8-abe23585da14\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5921fc95965ac7fccb7296957bd9abff\";s:5:\"title\";s:10:\"JetReviews\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:46:\"/jet-reviews/assets/js/jet-reviews-frontend.js\";i:3;s:37:\"/jet-reviews/assets/js/lib/vue.min.js\";i:4;s:16:\"jetReviewsWidget\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"jet-reviews/jet-reviews.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"963c7804-eede-4570-bd63-67066588b758\";O:8:\"stdClass\":8:{s:5:\"title\";s:32:\"JetSearch - Search results popup\";s:9:\"condition\";s:25:\"jet-search/jet-search.php\";s:10:\"exclusions\";a:4:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:50:\"/jet-search/assets/lib/chosen/chosen.jquery.min.js\";i:2;s:35:\"/jet-search/assets/js/jet-search.js\";i:3;s:49:\"/jet-search/assets/lib/jet-plugins/jet-plugins.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:13e8760379022187de982df2226a5be4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1708541675;}s:36:\"a8460089-34b4-4f8f-8694-5d92fa48aa82\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"JetSmartFilters\";s:9:\"condition\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:10:\"exclusions\";a:1:{i:0;s:23:\"jetOffcanvasInitialized\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:0cd63a514de1f1acb88e2bde65c4bc8d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694447256;}s:36:\"fe3c4915-6f8b-49b7-aa9c-c97b264d9f12\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:a346b60514ef52afeffc6e2ef2793da3\";s:5:\"title\";s:9:\"JetSticky\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:25:\"/jetsticky-for-elementor/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:51:\"jetsticky-for-elementor/jetsticky-for-elementor.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"853479dc-fff5-47cf-9a60-bf9b00f71fc4\";O:8:\"stdClass\":8:{s:5:\"title\";s:21:\"JetTabs for Elementor\";s:9:\"condition\";s:21:\"jet-tabs/jet-tabs.php\";s:10:\"exclusions\";a:7:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:11:\"/elementor/\";i:2;s:15:\"/elementor-pro/\";i:3;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:63:\"/wp-content/plugins/jet-tabs/assets/js/jet-tabs-frontend.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:d887a6ffea25d759e8aecdb6b78917f7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1697130971;}s:36:\"b7f89562-230c-4f63-8360-7aad6df31e02\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:829272546b040d5aaeeeaf976b6cd4ec\";s:5:\"title\";s:9:\"JetTricks\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:12:\"/jet-tricks/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"jet-tricks/jet-tricks.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"90451e2a-553a-4496-9fa4-cffedbe69d43\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:f44f3dbd09149f57db370e4132b057db\";s:5:\"title\";s:28:\"JetWoo Widgets For Elementor\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:58:\"/jetwoo-widgets-for-elementor/assets/js/jet-woo-widgets.js\";i:7;s:49:\"/jet-woo-builder/assets/js/jet-woo-builder.min.js\";i:8;s:42:\"/jet-woo-builder/assets/js/frontend.min.js\";i:9;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"944718c2-48c6-4f53-aaa2-460d07e033cc\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:ed318a971f8a047bed5b02ad546a9c18\";s:5:\"title\";s:13:\"JetWooBuilder\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:11:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:3;s:32:\"/wp-includes/js/dist/i18n.min.js\";i:4;s:15:\"/elementor-pro/\";i:5;s:11:\"/elementor/\";i:6;s:23:\"elementorFrontendConfig\";i:7;s:26:\"ElementorProFrontendConfig\";i:8;s:17:\"JetEngineSettings\";i:9;s:17:\"/jet-woo-builder/\";i:10;s:65:\"/jet-woo-builder-custom-quantity-selectors-main/assets/js/main.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f5b62f59-1dae-4cdf-ac3f-f5e846fc9918\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:9562e253cd4ac2b1e1f70e32cb4e32dc\";s:5:\"title\";s:12:\"Layer Slider\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:62:\"/LayerSlider/assets/static/layerslider/js/layerslider.utils.js\";i:3;s:77:\"/LayerSlider/assets/static/layerslider/js/layerslider.kreaturamedia.jquery.js\";i:4;s:68:\"/LayerSlider/assets/static/layerslider/js/layerslider.transitions.js\";i:5;s:15:\"initLayerSlider\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"LayerSlider/layerslider.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"e2be718d-83a2-4fa0-bc98-f0df52be3dc1\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:1425e2735306796fe1539d9184a77e10\";s:5:\"title\";s:14:\"LoftLoader Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"loftloader.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:33:\"loftloader-pro/loftloader-pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"cfa18552-656e-453c-9e14-c07522dc6598\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0bf67b8ba84771e1a367fe24590ef09c\";s:5:\"title\";s:20:\"MailUp for WordPress\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:73:\"/mailup-email-and-newsletter-subscription-form/public/js/mailup-public.js\";i:1;s:15:\"mailup-js-extra\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:56:\"mailup-email-and-newsletter-subscription-form/mailup.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c5330c66-ba7b-45b1-87e4-ce590ab005dd\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:10d0de28911c5f66463b9c8783f8148a\";s:5:\"title\";s:11:\"Maintenance\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:13:\"/maintenance/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"maintenance/maintenance.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"267aef71-afa0-4848-b6f8-3e1ca15c3a23\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:9460789bdfe77425c895f130991a4cb4\";s:5:\"title\";s:15:\"Maps Marker Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:36:\"/maps-marker-pro/js/mapsmarkerpro.js\";i:1;s:17:\"var mapsMarkerPro\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:35:\"maps-marker-pro/maps-marker-pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"b5a88b63-e906-49b3-8134-420139915ea6\";O:8:\"stdClass\":8:{s:5:\"title\";s:13:\"Master Popups\";s:9:\"condition\";s:31:\"master-popups/master-popups.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:65:\"/plugins/master-popups/assets/public/js/master-popups-libs.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:8fd7bd2c8b0a33e62798573abd12be63\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681305305;}s:36:\"4be41549-bf4d-4c49-8346-0f8a3b88fdba\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:de888634cc4bd51576eed319d5a528fd\";s:5:\"title\";s:13:\"Master Slider\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:12:\"masterslider\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"master-slider/master-slider.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"087bee18-7cd1-4c10-8acc-19e1b7c4f4cd\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:b71309a89bf3c8b558b6fca5d6531919\";s:5:\"title\";s:13:\"Max Mega Menu\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:34:\"/wp-includes/js/hoverIntent.min.js\";i:3;s:27:\"/megamenu/js/maxmegamenu.js\";i:4;s:12:\"var megamenu\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:21:\"megamenu/megamenu.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"cf22f0b9-01f4-409e-8a93-ad6743095abd\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:94a7bae84ef2816494be4af66c577bfc\";s:5:\"title\";s:11:\"Meta Slider\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/ml-slider/\";i:3;s:14:\"var metaslider\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:23:\"ml-slider/ml-slider.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"bb2cbc0d-20da-415e-8218-c17f1db53579\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"Monarch\";s:9:\"condition\";s:19:\"monarch/monarch.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:22:\"dt-place-monarch-icons\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b7335d6d6d5c5134ea10ac2d9b04226c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677853476;}s:36:\"a98d6a80-4610-4ede-bd33-c3e15bed0a95\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:4f8651262425ef6d7c223c68a2ec2063\";s:5:\"title\";s:16:\"Monster Insights\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:13:\"__gtagTracker\";i:1;s:24:\"monsterinsights_frontend\";i:2;s:62:\"/google-analytics-for-wordpress/assets/js/frontend-gtag.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:50:\"google-analytics-for-wordpress/googleanalytics.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"26e1a36e-7a03-449e-8ecc-e42c41ca291c\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:f8fc66b302dec2327bdec0434a3b275b\";s:5:\"title\";s:11:\"Motion.page\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:40:\"/motionpage/core/includes/assets/js/(.*)\";i:1;s:45:\"/motionpage/core/includes/assets/js/gsap/(.*)\";i:2;s:26:\"/motionpage/assets/js/(.*)\";i:3;s:31:\"/motionpage/assets/js/gsap/(.*)\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"motionpage/motionpage.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"459fd663-7f80-45fd-8308-d3484981e161\";O:8:\"stdClass\":8:{s:5:\"title\";s:11:\"Ninja Forms\";s:9:\"condition\";s:27:\"ninja-forms/ninja-forms.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/wp-includes/js/underscore.min.js\";i:3;s:31:\"/wp-includes/js/backbone.min.js\";i:4;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:5;s:44:\"/ninja-forms/assets/js/min/front-end-deps.js\";i:6;s:39:\"/ninja-forms/assets/js/min/front-end.js\";i:7;s:3:\"nf-\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1d3ae9c1a96d5062616968b81eef319d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1703190792;}s:36:\"c97440dd-7592-40e7-8c98-dac20d39808f\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:723a588dcd49285ea9f7404e2379b47f\";s:5:\"title\";s:12:\"Ninja Tables\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:25:\"/ninja-tables(.*)/assets/\";i:3;s:25:\"/ninja-tables(.*)/public/\";i:4;s:41:\"/wp-includes/js/dist/vendor/moment.min.js\";i:5;s:21:\"ninja_table_instance_\";i:6;s:13:\"ninja_filter_\";i:7;s:31:\"ninja_table_ready_init_table_id\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"ninja-tables/ninja-tables.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"ebc01f06-8c35-47fa-9c63-8959c5cbd915\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:f41a52ab1dd50a81cd3a5e341af0007c\";s:5:\"title\";s:13:\"NotificationX\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:39:\"/notificationx/assets/public/js/(.*).js\";i:3;s:16:\"notificationXArr\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"notificationx/notificationx.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"3aaf4a1b-591a-48b7-8d60-e6d65c0f94c9\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:be8fc72a8b8e8eb5958be13737cff47c\";s:5:\"title\";s:23:\"Ocean Elementor Widgets\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:25:\"/ocean-elementor-widgets/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:51:\"ocean-elementor-widgets/ocean-elementor-widgets.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f053a7d3-62b0-4312-b0ca-6ff63380eb0b\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:1a14afe852fefe7b22ccad3893672a29\";s:5:\"title\";s:23:\"One Click Accessibility\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:40:\"/pojo-accessibility/assets/js/app.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"pojo-accessibility/pojo-accessibility.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"61e11800-48a9-4354-8a4c-ac9a2b4b033a\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:b9ed0fe6f2cdbd305691a6b857f4b3dc\";s:5:\"title\";s:30:\"OoohBoi Steroids for Elementor\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:32:\"/ooohboi-steroids-for-elementor/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:51:\"ooohboi-steroids-for-elementor/ooohboi-steroids.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"560b78a2-f051-490b-9dc6-a602dece0d81\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:f1ff18a3e04c4e0995fca9cabffe57a7\";s:5:\"title\";s:8:\"Optimole\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:12:\"optimoleData\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"optimole-wp/optimole-wp.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"b0fda458-4bf2-41e9-a159-60d4bb6102a6\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:48ec18bd3f59772d98f85dddab75e305\";s:5:\"title\";s:19:\"OSM - OpenStreetMap\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/osm/js/OL/\";i:3;s:28:\"/osm/js/osm-v3-plugin-lib.js\";i:4;s:7:\"vectorM\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:11:\"osm/osm.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"3743ed67-e0d1-4243-bb1f-ee48a445dd10\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:9eacf0b76484af0259cd788f4923f20c\";s:5:\"title\";s:9:\"OxyExtras\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:4:\"vime\";i:1;s:11:\"vime.esm.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:20:\"oxyextras/plugin.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"52a21e27-af5b-4476-8d6d-54c323fd1443\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:e852555c4b4789d78a96d76f503b3262\";s:5:\"title\";s:14:\"Oxygen Builder\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:38:\"/component-framework/vendor/aos/aos.js\";i:3;s:8:\"AOS.init\";i:4;s:20:\"oxygen_init_pro_menu\";i:5;s:26:\"oxy-pro-menu-show-dropdown\";i:6;s:17:\"oxy-shape-divider\";i:7;s:21:\"oxygenVSBInitToggleJs\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:20:\"oxygen/functions.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"ebd282b9-e175-4b83-90a2-fe12389ccd11\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:6f9419e58ec86c94e7698aaaaf9dc715\";s:5:\"title\";s:21:\"PageLoader by Bonfire\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/pageloader-by-bonfire/pageloader.js\";i:3;s:26:\"bonfire-pageloader-overlay\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:47:\"pageloader-by-bonfire/pageloader-by-bonfire.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"0baf6353-aa70-41a9-a3bc-d89870a5839b\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:3a4c4518eb0f60108ab4934fab27d335\";s:5:\"title\";s:12:\"PDF Embedder\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:24:\"/pdf-embedder/js/(.*).js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"pdf-embedder/pdf_embedder.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"cba51ec1-87cc-44eb-b12b-d652e3446507\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:4f90aca5957cccbf623e3bbc31afa204\";s:5:\"title\";s:30:\"Perfect Brands for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:57:\"/perfect-woocommerce-brands/assets/lib/slick/slick.min.js\";i:3;s:63:\"/perfect-woocommerce-brands/assets/js/functions-frontend.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:57:\"perfect-woocommerce-brands/perfect-woocommerce-brands.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"808e7a4e-025c-4fae-bf82-de3716e5eb0d\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:84fe214646388d7c021dda25003ac165\";s:5:\"title\";s:8:\"Photonic\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:65:\"/photonic/include/js/front-end/module/photonic-baguettebox.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:21:\"photonic/photonic.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"936aff7d-a8ac-4473-a7b5-4b1611b6c557\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:6838be282f853f71be282783cb1c162b\";s:5:\"title\";s:13:\"Pixel Caffein\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:33:\"/pixel-caffeine/build/frontend.js\";i:2;s:10:\"aepc_pixel\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:33:\"pixel-caffeine/pixel-caffeine.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"ab3a4ef5-2732-4b46-a7c3-17b4e9405cd1\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:afe0eb7c64d4556a7111c56dd8c4d307\";s:5:\"title\";s:29:\"Pixel Manager for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:41:\"/woocommerce-pixel-manager-pro/js/public/\";i:2;s:3:\"wpm\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:59:\"woocommerce-pixel-manager-pro/woocommerce-pixel-manager.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"2774f964-50b2-425e-8a30-0a02f421b7e4\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:38d4b2986868f543639cd1ebc3e510aa\";s:5:\"title\";s:13:\"Popup Builder\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:32:\"/popup-builder/public/js/(.*).js\";i:3;s:57:\"/popupbuilder-exit-intent/public/javascript/ExitIntent.js\";i:4;s:17:\"var sgpbPublicUrl\";i:5;s:17:\"SGPB_POPUP_PARAMS\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"popup-builder/popup-builder.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"82dbb1e5-31f9-43d7-b522-52819aa49ba5\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:786717922362642f34a7ff58e919bd95\";s:5:\"title\";s:11:\"Popup Maker\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:3;s:24:\"/pum/pum-site-scripts.js\";i:4;s:3:\"pum\";i:5;s:42:\"/plugins/popup-maker/assets/js/site.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"popup-maker/popup-maker.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"48e08305-1f1c-4ef4-9f13-24af1b155abc\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:17831cbb64e469c7f66224c8c63d0a58\";s:5:\"title\";s:30:\"PowerPack Addons for Elementor\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:59:\"/powerpack-lite-for-elementor/assets/js/min/frontend.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:57:\"powerpack-lite-for-elementor/powerpack-lite-elementor.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"e037ae2f-e36b-4f1a-ada8-eb8fde6746f2\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:80e1283ea1afead3ca904fad792643c5\";s:5:\"title\";s:14:\"Preloader Plus\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:20:\"/preloader-plus/(.*)\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:33:\"preloader-plus/preloader-plus.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"90fed478-e89a-455c-8371-836bee58fb81\";O:8:\"stdClass\":8:{s:5:\"title\";s:28:\"Premium Addons for Elementor\";s:9:\"condition\";s:61:\"premium-addons-for-elementor/premium-addons-for-elementor.php\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:74:\"/premium-addons-for-elementor/assets/frontend/min-js/premium-addons.min.js\";i:3;s:67:\"/premium-addons-for-elementor/assets/frontend/min-js/isotope.min.js\";i:4;s:49:\"/premium-addons-elementor/pa-frontend-(.*).min.js\";i:5;s:65:\"/premium-addons-for-elementor/assets/frontend/min-js/slick.min.js\";i:6;s:61:\"/premium-addons-pro/assets/frontend/min-js/tooltipster.min.js\";i:7;s:19:\"window.scopes_array\";i:8;s:13:\"lottie.min.js\";i:9;s:76:\"/premium-addons-for-elementor/assets/frontend/min-js/premium-nav-menu.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:debbfbbcbdf9ffb465bbc40008d99f02\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1693315214;}s:36:\"7e43c261-77be-48fc-b25a-8953a654ae85\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:100a0382fcf3d1b6b22da928bce46ea8\";s:5:\"title\";s:13:\"Presto Player\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:54:\"/wp-includes/js/dist/vendor/regenerator-runtime.min.js\";i:1;s:67:\"/presto-player/dist/components/web-components/web-components.esm.js\";i:2;s:42:\"/presto-player/src/player/player-static.js\";i:3;s:10:\"var player\";i:4;s:37:\"/wp-includes/js/dist/api-fetch.min.js\";i:5;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:6;s:32:\"/wp-includes/js/dist/i18n.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"presto-player/presto-player.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"3d6f509f-d040-4279-9a2f-a4e6eae1e9df\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:c0fce700121492b566517e68301db382\";s:5:\"title\";s:42:\"Price Based on Country for WooCommerce Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:79:\"/woocommerce-product-price-based-on-countries/assets/js/ajax-geolocation.min.js\";i:1;s:77:\"/woocommerce-price-based-country-pro-addon/assets/js/currency-switcher.min.js\";i:2;s:18:\"add-to-cart.min.js\";i:3;s:21:\"cart-fragments.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:87:\"woocommerce-price-based-country-pro-addon/woocommerce-price-based-country-pro-addon.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"b970bc8a-bcbe-4d08-8ac0-a6853ab3f036\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:f1ecfe258440b371124999ca3bfbfff3\";s:5:\"title\";s:12:\"Prime Slider\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:62:\"/plugins/bdthemes-prime-slider-lite/assets/js/bdt-uikit.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:52:\"bdthemes-prime-slider-lite/bdthemes-prime-slider.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"e5458963-f167-4b68-88e4-77dd39af2842\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:29ea8f4dd72f5a5c5927917fb0665a05\";s:5:\"title\";s:12:\"PRO Elements\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/pro-elements/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"pro-elements/pro-elements.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"b119ad72-f498-4576-bb71-9e6d8c37b68f\";O:8:\"stdClass\":8:{s:5:\"title\";s:39:\"Product Filter by WBW (for WooCommerce)\";s:9:\"condition\";s:41:\"woo-product-filter/woo-product-filter.php\";s:10:\"exclusions\";a:6:{i:0;s:55:\"/jquery-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:55:\"/jquery-migrate(.*)(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:2;s:83:\"/wp-content/plugins/woo-product-filter/modules/woofilters/js/frontend.woofilters.js\";i:3;s:38:\"/wp-includes/js/jquery/ui/mouse.min.js\";i:4;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:5;s:39:\"/wp-includes/js/jquery/ui/slider.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e57ad91e0d94fab011353af544873743\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1685686062;}s:36:\"7b779aca-e497-4da3-8e51-fa12837d15ab\";O:8:\"stdClass\":8:{s:5:\"title\";s:31:\"Product Filters for WooCommerce\";s:9:\"condition\";s:59:\"woocommerce-product-filters/woocommerce-product-filters.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/woocommerce-product-filters/\";i:3;s:51:\"/woocommerce/assets/js/accounting/accounting.min.js\";i:4;s:26:\"/wp-includes/js/jquery/ui/\";i:5;s:17:\"wcpf-load-project\";i:6;s:8:\"WCPFData\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:719469f1c977f7109d3d6ee21ecd5a16\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1691235154;}s:36:\"2b2a51f2-bd47-4591-92d8-4a690bce5d99\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:a898898b2b0ea2cd82e20a6d3a3aa47b\";s:5:\"title\";s:38:\"Product Gallery Slider for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/twist/assets/js/slick.min.js\";i:3;s:20:\"wpgs-public-js-after\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:15:\"twist/twist.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"062c5be3-e5ea-4958-9619-44e3410f237e\";O:8:\"stdClass\":8:{s:5:\"title\";s:37:\"Product Video Gallery for Woocommerce\";s:9:\"condition\";s:93:\"product-video-gallery-slider-for-woocommerce/product-video-gallery-slider-for-woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:70:\"/product-video-gallery-slider-for-woocommerce/public/js/nickx.front.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:bbc653a91f0635cd2edb0b741aa62b85\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1693512477;}s:36:\"34d225a4-688c-476b-846b-420774160d6b\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:e0b123d324c6fc85b8682660c34f8829\";s:5:\"title\";s:13:\"Rank Math SEO\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:11:\"local_ga_js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:30:\"seo-by-rank-math/rank-math.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"02305ca0-2c2a-4eef-a802-b8a942771ecc\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Retainful\";s:9:\"condition\";s:91:\"retainful-next-order-coupon-for-woocommerce/retainful-next-order-coupon-for-woocommerce.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:83:\"/retainful-next-order-coupon-for-woocommerce/src/premium/assets/js/atc-popup.min.js\";i:3;s:87:\"/retainful-next-order-coupon-for-woocommerce/src/premium/assets/js/exit-intent-popup.js\";i:4;s:13:\"retainful.com\";i:5;s:26:\"rnoc-add-to-cart-js-before\";i:6;s:26:\"rnoc_redirect_coupon_popup\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:f9fdee19ba6aed961d96d86e1521a761\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679331508;}s:36:\"b4055250-5813-400f-b663-d390fee989e4\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:d6a4d07d1b4022d886df52322dcd8a6f\";s:5:\"title\";s:17:\"Revolution Slider\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:28:\"/revslider/public/assets/js/\";i:3;s:22:\"/revslider-(.*)-addon/\";i:4;s:15:\"setREVStartSize\";i:5;s:11:\"rev_slider_\";i:6;s:10:\"revslider_\";i:7;s:17:\"window.RS_MODULES\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:23:\"revslider/revslider.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"0b4e061a-b366-4d5a-a00e-bded4b107133\";O:8:\"stdClass\":8:{s:5:\"title\";s:22:\"Royal Elementor Addons\";s:9:\"condition\";s:37:\"royal-elementor-addons/wpr-addons.php\";s:10:\"exclusions\";a:3:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:49:\"/royal-elementor-addons/assets/js/frontend.min.js\";i:2;s:62:\"/royal-elementor-addons/assets/js/lib/jarallax/jarallax.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:c4b464373716d7ac8e3cfb019aaa6102\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1688124503;}s:36:\"1b19ec89-171a-4f85-8c4b-b1bcfc6b1433\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5e3f85d8c82cc184b945415d1a862601\";s:5:\"title\";s:18:\"Sassy Social Share\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:58:\"/sassy-social-share/public/js/sassy-social-share-public.js\";i:3;s:19:\"heateorSssLoadEvent\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"sassy-social-share/sassy-social-share.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f5899925-2ab7-43b6-abc4-51b76d664ca6\";O:8:\"stdClass\":8:{s:5:\"title\";s:14:\"Scrollsequence\";s:9:\"condition\";s:41:\"scrollsequence-pro/scrollsequence-pro.php\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:51:\"/scrollsequence-pro/public/js/gsap__premium_only.js\";i:3;s:65:\"/scrollsequence-pro/public/js/gsap-scrolltrigger__premium_only.js\";i:4;s:54:\"/scrollsequence-pro/public/js/ssq-lib__premium_only.js\";i:5;s:27:\"scrollsequence-input-script\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3df51830b6b80668fc342c8dcea495cf\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1678111131;}s:36:\"043827fc-3df8-45d6-9cd2-14fbe962987a\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:9d60b5d2de4d828b78c7b088024377d6\";s:5:\"title\";s:37:\"ShiftNav Pro - Responsive Mobile Menu\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:39:\"/shiftnav-pro/assets/js/shiftnav(.*).js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"shiftnav-pro/shiftnav.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"bcbaf240-e76f-4620-b7d5-4852c46d4be7\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:56279bd768c8f27ad1972b6774738bcf\";s:5:\"title\";s:35:\"ShiftNav – Responsive Mobile Menu\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/shiftnav-responsive-mobile-menu/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:67:\"shiftnav-responsive-mobile-menu/shiftnav-responsive-mobile-menu.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"bbe0543b-b5af-467b-a90d-e2975d892d8d\";O:8:\"stdClass\":8:{s:5:\"title\";s:26:\"Short Pixel Adaptive Image\";s:9:\"condition\";s:45:\"shortpixel-adaptive-images/short-pixel-ai.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:51:\"/shortpixel-adaptive-images/assets/js/ai(.*).min.js\";i:3;s:13:\"spai_settings\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:1bc7ac87d8ab2301a1b904919dc7a798\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704734942;}s:36:\"543ab43a-6bd3-4948-a09e-3b95e7c9209d\";O:8:\"stdClass\":8:{s:5:\"title\";s:12:\"Showcase IDX\";s:9:\"condition\";s:28:\"showcase-idx/showcaseidx.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:4:\"SIDX\";i:3;s:37:\"search.showcaseidx.com/js/app-(.*).js\";i:4;s:17:\"cdn.shortpixel.ai\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ce4dea8ddc3caa8d00e95cec3202d32a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704734988;}s:36:\"a16bcab7-1169-46b9-a425-b091478d8312\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:3ea7d9f75ad03620b0bce2517bd5b8d1\";s:5:\"title\";s:21:\"Side Cart WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:61:\"/plugins/woocommerce/assets/js/frontend/cart-fragments.min.js\";i:3;s:58:\"/plugins/woocommerce/assets/js/frontend/add-to-cart.min.js\";i:4;s:67:\"/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js\";i:5;s:57:\"/plugins/woocommerce/assets/js/js-cookie/js.cookie.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:38:\"side-cart-woocommerce/xoo-wsc-main.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"521f748e-cf09-4019-bd28-b52daef5f16f\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:7843983bf90dbae16c6e889382c71b23\";s:5:\"title\";s:13:\"Simple Banner\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:15:\"/simple-banner/\";i:2;s:24:\"simpleBannerScriptParams\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"simple-banner/simple-banner.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"76026e82-d9cf-482c-b480-55c57693a184\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:b6825f971d35a5515d095564a2e40936\";s:5:\"title\";s:18:\"Site Kit by Google\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:33:\"google-analytics.com/analytics.js\";i:1;s:6:\"ga\\( \'\";i:2;s:5:\"ga\\(\'\";i:3;s:8:\"/gtag/js\";i:4;s:6:\"gtag\\(\";i:5;s:7:\"/gtm.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:35:\"google-site-kit/google-site-kit.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"79c458d7-f7f7-4072-919d-ad337bde6ae3\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"Slick Menu\";s:9:\"condition\";s:25:\"slick-menu/slick-menu.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:12:\"/slick-menu/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:5ce5dfecdc9d3292c69a1413bbd17d3c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735027;}s:36:\"99cf4942-49ea-4687-b156-405ed1ce1cfa\";O:8:\"stdClass\":8:{s:5:\"title\";s:14:\"Slide Anything\";s:9:\"condition\";s:33:\"slide-anything/slide-anything.php\";s:10:\"exclusions\";a:3:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:48:\"/slide-anything/owl-carousel/owl.carousel.min.js\";i:2;s:16:\"owl_goto.trigger\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:fff874cc48b80940210228c975df395c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1702907355;}s:36:\"dd0ea584-0c99-4c30-b46d-da35b94c9f0a\";O:8:\"stdClass\":8:{s:5:\"title\";s:19:\"Slider by Soliloquy\";s:9:\"condition\";s:33:\"soliloquy-lite/soliloquy-lite.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:16:\"soliloquy-min.js\";i:3;s:16:\"soliloquy_slider\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ffb5f8cc0ea17886dbd05f601ca3eec0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735068;}s:36:\"ecb2fffc-d289-4f68-ae94-71131f17deee\";O:8:\"stdClass\":8:{s:5:\"title\";s:14:\"Smart Slider 3\";s:9:\"condition\";s:33:\"smart-slider-3/smart-slider-3.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:23:\"/smart-slider-3/(.*).js\";i:3;s:3:\"_N2\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:2f373822dceb191c31c8ad2183d51869\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735119;}s:36:\"284ede43-bf80-419e-8414-46c26cb746f0\";O:8:\"stdClass\":8:{s:5:\"title\";s:18:\"Smart Slider 3 Pro\";s:9:\"condition\";s:55:\"nextend-smart-slider3-pro/nextend-smart-slider3-pro.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:21:\"/SmartSlider3/(.*).js\";i:3;s:3:\"_N2\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:720ec9fbbd8a52ce525959a68a5310b3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735152;}s:36:\"be70034f-def5-4771-9b3f-662eb218da2a\";O:8:\"stdClass\":8:{s:5:\"title\";s:28:\"Spectra - Show Slider Images\";s:9:\"condition\";s:63:\"ultimate-addons-for-gutenberg/ultimate-addons-for-gutenberg.php\";s:10:\"exclusions\";a:7:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:66:\"/ultimate-addons-for-gutenberg/assets/js/spectra-animations.min.js\";i:2;s:52:\"/ultimate-addons-for-gutenberg/assets/js/post.min.js\";i:3;s:51:\"/ultimate-addons-for-gutenberg/assets/js/aos.min.js\";i:4;s:13:\"/slick.min.js\";i:5;s:20:\"/imagesloaded.min.js\";i:6;s:16:\"UAGBPostCarousel\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:af16af31f83a874b9d0a9570d9c15ff7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1706824485;}s:36:\"c3334c29-4160-42df-a1ce-f8aeeaee8668\";O:8:\"stdClass\":8:{s:5:\"title\";s:16:\"Super Socializer\";s:9:\"condition\";s:37:\"super-socializer/super_socializer.php\";s:10:\"exclusions\";a:3:{i:0;s:8:\"theChamp\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:660defe26748470c3a47366cd4012579\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677853633;}s:36:\"f18b4242-fe3f-4e2b-bfc9-ac2fb3939a90\";O:8:\"stdClass\":8:{s:5:\"title\";s:13:\"Superfly Menu\";s:9:\"condition\";s:22:\"superfly-menu/main.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:33:\"/jquery-migrate((.*?)(.min?)?).js\";i:2;s:67:\"/superfly-menu/includes/vendor/looks_awesome/icon_manager/js/md5.js\";i:3;s:68:\"/superfly-menu/includes/vendor/looks_awesome/icon_manager/js/util.js\";i:4;s:31:\"/superfly-menu/js/public.min.js\";i:5;s:20:\"window.SFM_is_mobile\";i:6;s:21:\"var SFM_skew_disabled\";i:7;s:16:\"var SFM_template\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ccb15175093bc6c437b78797f0698a7b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1684301673;}s:36:\"1a05c00a-8562-45bc-80e8-987a4574b1c9\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"Symplr Ads\";s:9:\"condition\";s:28:\"symplr-ads/symplr-plugin.php\";s:10:\"exclusions\";a:2:{i:0;s:12:\"/symplr-ads/\";i:1;s:14:\"cdns.symplr.de\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:3b6d39e28a87e86c4659491e2368ff61\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1692199959;}s:36:\"858d2d7f-bdac-4d27-ba26-baa9ace96ba4\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:7d93008296bb5c7c43d4cba185ed2632\";s:5:\"title\";s:21:\"Tabby Responsive Tabs\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:34:\"/tabby-responsive-tabs/js/tabby.js\";i:3;s:12:\"RESPONSIVEUI\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:47:\"tabby-responsive-tabs/tabby-responsive-tabs.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"e44a5c93-bb77-4624-a121-d846905137ea\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:2f563bbb7e92363ec3fb2989a1c7dffe\";s:5:\"title\";s:29:\"The Plus Addons for Elementor\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:20:\"/theplus-addons/(.*)\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:70:\"the-plus-addons-for-elementor-page-builder/theplus_elementor_addon.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"2bbac961-b000-4802-ae97-d52472ec6750\";O:8:\"stdClass\":8:{s:5:\"title\";s:37:\"The Plus Addons for Elementor Premium\";s:9:\"condition\";s:51:\"theplus_elementor_addon/theplus_elementor_addon.php\";s:10:\"exclusions\";a:7:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:44:\"/wp-content/plugins/theplus_elementor_addon/\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:5;s:26:\"ElementorProFrontendConfig\";i:6;s:23:\"elementorFrontendConfig\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:6e127deaaeefbe57ff945b1f9e274518\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1688143611;}s:36:\"666b45e8-749c-4140-bd17-e1cd589e03ee\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:b9c418b47c986935a1151ab9b42f8971\";s:5:\"title\";s:15:\"ThemeREX Addons\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:32:\"/trx_addons/js/__scripts-full.js\";i:3;s:67:\"/trx_addons/components/cpt/layouts/shortcodes/menu/superfish.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"trx_addons/trx_addons.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"a750cada-eb58-4df4-9966-21c8a69332ba\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:75af9efe22c5cc776636266feb55adf1\";s:5:\"title\";s:16:\"Thrive Architect\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:45:\"thrive-visual-editor/thrive-visual-editor.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"13714cde-680e-4ca4-8607-c35952d6a5f2\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"Thrive Comments\";s:9:\"condition\";s:35:\"thrive-comments/thrive-comments.php\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/thrive-leads/\";i:3;s:15:\"window.TL_Const\";i:4;s:7:\"var ml=\";i:5;s:27:\"/thrive-comments/assets/js/\";i:6;s:14:\"ThriveComments\";i:7;s:33:\"/wp-includes/js/underscore.min.js\";i:8;s:31:\"/wp-includes/js/backbone.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:6a72d06ca2f6a888b0d9d5ea93af2edc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677852974;}s:36:\"aa7ca898-499f-4f04-b419-3de199996969\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:b84d82c02cade64ade00712b9c5652aa\";s:5:\"title\";s:12:\"Thrive Leads\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/thrive-leads/\";i:3;s:15:\"window.TL_Const\";i:4;s:7:\"var ml=\";i:5;s:27:\"/thrive-comments/assets/js/\";i:6;s:14:\"ThriveComments\";i:7;s:33:\"/wp-includes/js/underscore.min.js\";i:8;s:31:\"/wp-includes/js/backbone.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"thrive-leads/thrive-leads.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"9eee297a-8241-4ef2-af97-46074bd0898c\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5bb61b0559b0a3fd578315b553451327\";s:5:\"title\";s:19:\"Thrive Quiz Builder\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:43:\"thrive-quiz-builder/thrive-quiz-builder.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c2f3ec2a-5b09-4845-aa95-84841783fbfc\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:a7f3e5206abff19ca7cf142260181738\";s:5:\"title\";s:16:\"Thrive Ultimatum\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:18:\"/thrive-ultimatum/\";i:3;s:12:\"var TVE_Ult_\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:37:\"thrive-ultimatum/thrive-ultimatum.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"d48b8d2f-e071-4a30-840a-306154a115a0\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:f57be2014b6a489d053f8367fa6c0f9f\";s:5:\"title\";s:10:\"Tidio Chat\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:22:\"document.tidioChatCode\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:34:\"tidio-live-chat/tidio-elements.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"cb6d33ed-7eb4-4ff9-9ad0-7fc54fbecf6f\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:c9e0485ec256d4a6a8d92a98c18d76fc\";s:5:\"title\";s:14:\"Toolset Blocks\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:26:\"toolsetCommonEs.fontToHead\";i:3;s:27:\"toolsetCommonEs.styleToHead\";i:4;s:59:\"/toolset-blocks/vendor/toolset/blocks/public/js/frontend.js\";i:5;s:77:\"/toolset-blocks/vendor/toolset/common-es/public/toolset-common-es-frontend.js\";i:6;s:43:\"/toolset-blocks/public/js/views-frontend.js\";i:7;s:33:\"/wp-includes/js/underscore.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:27:\"toolset-blocks/wp-views.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"4bac6350-0925-49fb-904a-372f22fd6baf\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:71beda322b37f7fc7d456822493cb972\";s:5:\"title\";s:11:\"Top Bar Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:40:\"/plugins/topbar-pro/js/tpbr_front.min.js\";i:3;s:39:\"/plugins/topbar-pro/js/jquery.cookie.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:25:\"topbar-pro/topbar_pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"033486e7-0ddc-4915-a848-31504d00448e\";O:8:\"stdClass\":8:{s:5:\"title\";s:27:\"Twenty20 Image Before-After\";s:9:\"condition\";s:20:\"twenty20/ttwenty.php\";s:10:\"exclusions\";a:4:{i:0;s:27:\"/twenty20/assets/js/(.*).js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";i:3;s:22:\"twentytwenty-container\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:23441bba9d3602bc932d697c7cb8aa1f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677858089;}s:36:\"7675a34d-006e-4672-99d5-a81e1b8e47f9\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:3d59cc34167a7f8123e66b627148e0b7\";s:5:\"title\";s:8:\"UberMenu\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:35:\"/ubermenu/assets/js/ubermenu.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:21:\"ubermenu/ubermenu.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"8233178a-e7b3-43ce-b193-bd0d9c960933\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:86424c46157c1c7e2e1571055813beee\";s:5:\"title\";s:29:\"Ultimate Addons for Elementor\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:17:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:49:\"/ultimate-elementor/assets/lib/slick/slick.min.js\";i:3;s:54:\"/ultimate-elementor/assets/min-js/uael-frontend.min.js\";i:4;s:53:\"/ultimate-elementor/assets/lib/isotope/isotope.min.js\";i:5;s:73:\"/ultimate-elementor/assets/lib/jquery-element-resize/jquery_resize.min.js\";i:6;s:62:\"/ultimate-elementor/assets/lib/fancybox/jquery_fancybox.min.js\";i:7;s:71:\"/ultimate-elementor/assets/lib/justifiedgallery/justifiedgallery.min.js\";i:8;s:40:\"/elementor-pro/assets/js/frontend.min.js\";i:9;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:10;s:52:\"/js_composer/assets/js/dist/js_composer_front.min.js\";i:11;s:42:\"/elementor/assets/lib/swiper/swiper.min.js\";i:12;s:44:\"/nasa-core/assets/js/min/jquery.slick.min.js\";i:13;s:11:\"/elementor/\";i:14;s:15:\"/elementor-pro/\";i:15;s:26:\"ElementorProFrontendConfig\";i:16;s:23:\"elementorFrontendConfig\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"ultimate-elementor/ultimate-elementor.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"8bddf484-6c78-4147-a4e6-d3039904e5f6\";O:8:\"stdClass\":8:{s:5:\"title\";s:43:\"Ultimate Addons for Elementor - Mobile Menu\";s:9:\"condition\";s:41:\"ultimate-elementor/ultimate-elementor.php\";s:10:\"exclusions\";a:4:{i:0;s:55:\"/jquery-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:55:\"/jquery-migrate(.*)(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:2;s:46:\"/ultimate-elementor/assets/js/uael-nav-menu.js\";i:3;s:54:\"/ultimate-elementor/assets/min-js/uael-nav-menu.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:70cfade3a7adbb54196f6acccc5a176f\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1694771327;}s:36:\"028504f7-b1cd-4318-8a6d-ce186197e89d\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0f0a91f0c454021a5ff9fc25c3ed419f\";s:5:\"title\";s:41:\"Ultimate Addons for WPBakery Page Builder\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:27:\"/Ultimate_VC_Addons/assets/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"5754af3d-a6af-49eb-b731-bdd82f26dc4e\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:34db8636812bad84c8aea037c2ddc8c2\";s:5:\"title\";s:32:\"Ultimate Responsive Image Slider\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"sliderPro\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:69:\"ultimate-responsive-image-slider/ultimate-responsive-image-slider.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"78ae882d-ae31-4179-b677-8893814938c7\";O:8:\"stdClass\":8:{s:5:\"title\";s:49:\"Unlimited Elements for Elementor Premium - Slider\";s:9:\"condition\";s:67:\"unlimited-elements-for-elementor-premium/unlimited-elements-pro.php\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/elementor/\";i:3;s:15:\"/elementor-pro/\";i:4;s:26:\"ElementorProFrontendConfig\";i:5;s:23:\"elementorFrontendConfig\";i:6;s:42:\"/unlimited-elements-for-elementor-premium/\";i:7;s:3:\"uc_\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:17260bc347b8c29bee0010e9ec164184\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683270377;}s:36:\"051cbfbb-7ad2-4f06-a493-3cf423a80904\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:6717ef5673a956bc08ca4a5117065d53\";s:5:\"title\";s:34:\"Variation Swatches for WooCommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/jquery/ui/\";i:3;s:24:\"/woo-variation-swatches/\";i:4;s:28:\"/woo-variation-swatches-pro/\";i:5;s:17:\"underscore.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:49:\"woo-variation-swatches/woo-variation-swatches.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"6879caba-7224-4eca-bcb2-370785b495ea\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:57597b7683e01892932083413f085134\";s:5:\"title\";s:30:\"Web Accessibility By accessiBe\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/accessibe/\";i:3;s:6:\"acsbJS\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:24:\"accessibe/accessiebe.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"bd6732fe-4c2b-40a1-9035-8464057e2da5\";O:8:\"stdClass\":8:{s:5:\"title\";s:28:\"WooCommerce - Cart Fragments\";s:9:\"condition\";s:27:\"woocommerce/woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:53:\"/woocommerce/assets/js/frontend/cart-fragments.min.js\";i:2;s:49:\"/woocommerce/assets/js/js-cookie/js.cookie.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:201de694c6fc28c8d580a3b2ca484218\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1680937567;}s:36:\"d044900d-07e1-4533-9516-33106efcb259\";O:8:\"stdClass\":8:{s:5:\"title\";s:33:\"WooCommerce - Product description\";s:9:\"condition\";s:27:\"woocommerce/woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:61:\"/plugins/woocommerce/assets/js/frontend/single-product.min.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:a82644b4c9417ea3a240939a73344700\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679309756;}s:36:\"bff953b1-2213-4666-8112-76a84a3cc207\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"WooCommerce - Product Gallery\";s:9:\"condition\";s:27:\"woocommerce/woocommerce.php\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:55:\"/woocommerce/?(.*)/assets/js/zoom/jquery.zoom(.min)?.js\";i:3;s:40:\"/woocommerce/?(.*)/assets/js/photoswipe/\";i:4;s:67:\"/woocommerce/?(.*)/assets/js/flexslider/jquery.flexslider(.min)?.js\";i:5;s:62:\"/woocommerce/?(.*)/assets/js/frontend/single-product(.min)?.js\";i:6;s:24:\"wc_single_product_params\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:7665868ff97c265628f376523a4f9ecc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1686579689;}s:36:\"016e6ddf-c6e7-49ec-bd3f-2585d9e45895\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"WooCommerce - Select2 library\";s:9:\"condition\";s:27:\"woocommerce/woocommerce.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:45:\"/woocommerce/assets/js/select2/select2(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:4bca670bd5d55dd24b17fb0193b0891e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681459540;}s:36:\"b9b2c6d7-944f-4ae3-ae04-c9e2204b9dab\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:9165c768e978d6ad3f696db8c78ccbb2\";s:5:\"title\";s:30:\"WooCommerce Attribute Swatches\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:69:\"/iconic-woo-attribute-swatches-premium/assets/frontend/js/main.min.js\";i:3;s:82:\"/iconic-woo-attribute-swatches-premium/assets/vendor/flickity/flickity.pkgd.min.js\";i:4;s:15:\"iconic_was_vars\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:71:\"iconic-woo-attribute-swatches-premium/iconic-woo-attribute-swatches.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"4506c5e9-7349-44c9-9967-34370c83facb\";O:8:\"stdClass\":8:{s:5:\"title\";s:20:\"WooCommerce Bookings\";s:9:\"condition\";s:45:\"woocommerce-bookings/woocommerce-bookings.php\";s:10:\"exclusions\";a:9:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:38:\"/woocommerce-bookings/dist/frontend.js\";i:3;s:32:\"/wp-includes/js/dist/date.min.js\";i:4;s:41:\"/wp-includes/js/dist/vendor/moment.min.js\";i:5;s:43:\"/wp-includes/js/jquery/ui/datepicker.min.js\";i:6;s:33:\"/wp-includes/js/underscore.min.js\";i:7;s:59:\"/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js\";i:8;s:33:\"/wp-includes/js/dist/hooks.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:14dec6d289b9977fa3a74116feecebcc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1693998405;}s:36:\"fec9cd04-c358-45da-a1a8-1668b964016b\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:456f3b849ba3b6647246aca9d7cdaed5\";s:5:\"title\";s:31:\"WooCommerce Product Reviews Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:22:\"wc_product_reviews_pro\";i:3;s:90:\"/woocommerce-product-reviews-pro/assets/js/frontend/wc-product-reviews-pro-frontend.min.js\";i:4;s:57:\"/woocommerce/assets/js/jquery-tiptip/jquery.tipTip.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:67:\"woocommerce-product-reviews-pro/woocommerce-product-reviews-pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"551a9399-627f-4978-9bae-5cc8e0aefc82\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:c8577e74eef3b082fb6403760d53f68c\";s:5:\"title\";s:36:\"WooCommerce TM Extra Product Options\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:10:{i:0;s:58:\"/woocommerce-tm-extra-product-options/assets/js/epo.min.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";i:3;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";i:4;s:38:\"/wp-includes/js/jquery/ui/mouse.min.js\";i:5;s:39:\"/wp-includes/js/jquery/ui/slider.min.js\";i:6;s:33:\"/wp-includes/js/underscore.min.js\";i:7;s:30:\"/wp-includes/js/wp-util.min.js\";i:8;s:29:\"/wp-includes/js/dist/hooks.js\";i:9;s:28:\"/wp-includes/js/dist/i18n.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:69:\"woocommerce-tm-extra-product-options/tm-woo-extra-product-options.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"3cac4650-6a52-448e-8e48-e99a772a59a2\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:c6e6cab8c80fa3fe57d609f72d2d5c56\";s:5:\"title\";s:9:\"WooLentor\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:50:\"/woolementor/assets/third-party/slick/slick.min.js\";i:1;s:17:\"/woolentor-addons\";i:2;s:16:\"woolentor_addons\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:47:\"woolentor-addons/woolentor_addons_elementor.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"21af073d-d2ec-4d46-bbda-2c69f87f3f98\";O:8:\"stdClass\":8:{s:5:\"title\";s:31:\"Woolentor - Fix product gallery\";s:9:\"condition\";s:47:\"woolentor-addons/woolentor_addons_elementor.php\";s:10:\"exclusions\";a:4:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:20:\".woolentor-learg-img\";i:2;s:40:\"/woolentor-addons/assets/js/slick.min.js\";i:3;s:48:\"/woolentor-addons-pro/assets/lib/js/tippy.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:c5315e06dfc353cd57f85a60abe4e320\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1700061004;}s:36:\"67aeb4cb-1a00-4d10-a00c-34888b4c0dba\";O:8:\"stdClass\":8:{s:5:\"title\";s:25:\"WooThumbs for WooCommerce\";s:9:\"condition\";s:39:\"woothumbs-premium/woothumbs-premium.php\";s:10:\"exclusions\";a:5:{i:0;s:33:\"/wp-includes/js/dist/hooks.min.js\";i:1;s:33:\"/wp-includes/js/underscore.min.js\";i:2;s:31:\"/wp-includes/js/wp-embed.min.js\";i:3;s:30:\"/wp-includes/js/wp-util.min.js\";i:4;s:23:\"/woothumbs-premium/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:b97b1d3f627769e1dd8305aa25af993c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679065404;}s:36:\"c7a14763-88d0-4344-a6af-e0a8dc5fa8d5\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:31b9e812a025e5750a6ef0980ee7d2db\";s:5:\"title\";s:32:\"WordPress Mega Menu – QuadMenu\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/quadmenu\";i:3;s:13:\"#private-menu\";i:4;s:12:\"#public-menu\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:21:\"quadmenu/quadmenu.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f699fdbd-84a7-4f24-b729-3e4a4f83a4dd\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:601f8fc7d10cad1c2ec2949c0d9b1651\";s:5:\"title\";s:9:\"WP Armour\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:28:\"/honeypot/includes/js/wpa.js\";i:3;s:39:\"/wp-armour-extended/includes/js/wpae.js\";i:4;s:16:\"wpa_hidden_field\";i:5;s:12:\"wpa_add_test\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"wp-armour-extended/wp-armour-extended.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"6a28aae5-ef91-43fc-8204-92e3a25642b4\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:5728f3b9856dfe37a36ab15b0a637198\";s:5:\"title\";s:10:\"WP Go Maps\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"maps.googleapis.com\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:31:\"wp-google-maps/wpGoogleMaps.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c9b991d1-a653-404b-be85-e276b1814e7d\";O:8:\"stdClass\":8:{s:5:\"title\";s:17:\"WP Google Map Pro\";s:9:\"condition\";s:41:\"wp-google-map-gold/wp-google-map-gold.php\";s:10:\"exclusions\";a:5:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:27:\"maps.google.com/maps/api/js\";i:3;s:30:\"/wp-includes/js/masonry.min.js\";i:4;s:24:\"/wp-google-map-gold/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:dc12a9b7b9c4c7ce3c532b6b377739f2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677858391;}s:36:\"1f8f9fbf-fbf0-4e3a-b77c-af0fa47e950d\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:87f572f5f0ec143a8fceba77d0616197\";s:5:\"title\";s:18:\"WP Google Maps Pro\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/wp-google-maps(.*)\";i:3;s:19:\"maps.googleapis.com\";i:4;s:4:\"mgl_\";i:5;s:6:\"wpgmza\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"wp-google-maps-pro/wp-google-maps-pro.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"41e4b98c-e63f-4800-a478-02592562322b\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:3735ca768ede98b25795f4cb057ff4ed\";s:5:\"title\";s:20:\"WP iCal Availability\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:41:\"/wp-ical-availability/js/custom-select.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";i:3;s:22:\"/wp-ical-availability/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:45:\"wp-ical-availability/wp-ical-availability.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"2b06c5b8-dc32-4bb0-8504-3a9f1c3a1ec0\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"WP MapIt\";s:9:\"condition\";s:21:\"wp-mapit/wp_mapit.php\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:32:\"/wp-mapit/wp_mapit/js/leaflet.js\";i:3;s:42:\"/wp-mapit/wp_mapit/js/wp_mapit_multipin.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ba8d1c7f294a3f5b593556eb3b0bc7d9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679331261;}s:36:\"2039eafd-1c11-4e21-a61b-30857f291ae3\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:927b8bf7806f2d287559b86a0b455a59\";s:5:\"title\";s:18:\"WP Responsive Menu\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:24:\"/wp-responsive-menu/(.*)\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"wp-responsive-menu/wp-responsive-menu.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"e06be942-cccd-4b2d-a268-06dc78f0b820\";O:8:\"stdClass\":8:{s:5:\"title\";s:22:\"WP Search with Algolia\";s:9:\"condition\";s:34:\"wp-search-with-algolia/algolia.php\";s:10:\"exclusions\";a:4:{i:0;s:71:\"/wp-search-with-algolia/js/algoliasearch/dist/algoliasearch-lite.umd.js\";i:1;s:53:\"/wp-search-with-algolia/js/autocomplete-noconflict.js\";i:2;s:67:\"/wp-search-with-algolia/js/autocomplete.js/dist/autocomplete.min.js\";i:3;s:11:\"var algolia\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:43267e659d599fbb6b42c719b49bb7a7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677857180;}s:36:\"4fc2a7ae-b9e6-410e-93cf-e6d1962add6a\";O:8:\"stdClass\":8:{s:5:\"title\";s:18:\"WP Smart Preloader\";s:9:\"condition\";s:35:\"wp-smart-preloader/wp-preloader.php\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:55:\"/wp-smart-preloader/assets/js/wsp-main-script(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:4fb90fc73fc2b5d1e37ea2dadfd3cef3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704204597;}s:36:\"7ecf40ce-2bcd-412c-bb01-9e71fecf6be8\";O:8:\"stdClass\":8:{s:5:\"title\";s:16:\"WP Store Locator\";s:9:\"condition\";s:37:\"wp-store-locator/wp-store-locator.php\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:18:\"/wp-store-locator/\";i:3;s:33:\"/wp-includes/js/underscore.min.js\";i:4;s:15:\"maps.google.com\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:d37bb5054a24471ca1675d9ab49d01b0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735183;}s:36:\"7a1d19a2-3a48-40ab-8051-f642fc63ce2d\";O:8:\"stdClass\":8:{s:5:\"title\";s:21:\"WP Ultimate Post Grid\";s:9:\"condition\";s:47:\"wp-ultimate-post-grid/wp-ultimate-post-grid.php\";s:10:\"exclusions\";a:4:{i:0;s:67:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:37:\"/wp-ultimate-post-grid/dist/public.js\";i:2;s:53:\"/wp-ultimate-post-grid-premium/dist/public-premium.js\";i:3;s:15:\"wpupg_grid_args\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:e24341fef49bd64b89682d583218c108\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1686597940;}s:36:\"76c86163-ddf3-4113-b620-de9d5058f505\";O:8:\"stdClass\":8:{s:5:\"title\";s:21:\"WPBakery Page Builder\";s:9:\"condition\";s:27:\"js_composer/js_composer.php\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:52:\"/js_composer/assets/js/dist/js_composer_front.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:517d7d24da9a7072ed389d0fb30374a0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704404852;}s:36:\"0b8ff2c0-c3cd-4ec1-b7f5-c7751de6101b\";O:8:\"stdClass\":8:{s:5:\"title\";s:32:\"WPBakery Page Builder - Carousel\";s:9:\"condition\";s:27:\"js_composer/js_composer.php\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:57:\"/js_composer/assets/lib/vc_carousel/js/vc_carousel.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:76336ed3f04df091e669f89d908ef2ed\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704405212;}s:36:\"4f5e5b98-c326-4b9f-9ada-3b257862132c\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:1ec7138c950c355e7af60d49c81139fc\";s:5:\"title\";s:12:\"wpDataTables\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/wpdatatables/\";i:3;s:10:\"highcharts\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:29:\"wpdatatables/wpdatatables.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"18be1b8c-0bc4-4a01-abc6-a127aff380c6\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:c62ca58ea081c1271de8dadfa7daac69\";s:5:\"title\";s:7:\"WPForms\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:61:\"/wpforms-offline-forms/assets/js/wpforms-offline-forms.min.js\";i:1;s:30:\"wpforms-offline-forms-js-extra\";i:2;s:20:\"wpformsRecaptchaLoad\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:19:\"wpforms/wpforms.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"8a3cacb6-81bd-456a-a1cc-a4025f8e5234\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:0992ac952c0a05bb35e18b1d5744d346\";s:5:\"title\";s:12:\"WPForms Lite\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:20:\"wpformsRecaptchaLoad\";i:1;s:61:\"/wpforms-offline-forms/assets/js/wpforms-offline-forms.min.js\";i:2;s:30:\"wpforms-offline-forms-js-extra\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:24:\"wpforms-lite/wpforms.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"98bbd410-5b01-4244-a8eb-715765180328\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"XL WooCommerce Sales Triggers\";s:9:\"condition\";s:63:\"xl-woocommerce-sales-triggers/xl-woocommerce-sales-triggers.php\";s:10:\"exclusions\";a:3:{i:0;s:61:\"/xl-woocommerce-sales-triggers/assets/js/wcst_combined.min.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:ba9e526ddb0157e69757530c6b18b714\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1677856813;}s:36:\"bf9f9620-dd0e-4e6f-9a45-4eb78a148f42\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:58663fc781232169e865f6fe7cf1afaa\";s:5:\"title\";s:36:\"YITH WooCommerce Ajax Product Filter\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:71:\"/yith-woocommerce-ajax-navigation/assets/js/yith-wcan-shortcodes.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:41:\"yith-woocommerce-ajax-navigation/init.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"b053279d-e07c-438c-bb3e-3a1f4f5d7c5e\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"plugin:68b637fd247e40c8e135e4771d739b07\";s:5:\"title\";s:44:\"YITH WooCommerce AJAX Product Filter Premium\";s:4:\"type\";s:6:\"plugin\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:83:\"/yith-woocommerce-ajax-product-filter-premium/assets/js/yith-wcan-shortcodes.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:53:\"yith-woocommerce-ajax-product-filter-premium/init.php\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"d94dbbf3-bcab-4e47-9fbb-6b3a7cf92787\";O:8:\"stdClass\":8:{s:5:\"title\";s:36:\"Yotpo Social Reviews for Woocommerce\";s:9:\"condition\";s:49:\"yotpo-social-reviews-for-woocommerce/wc_yotpo.php\";s:10:\"exclusions\";a:1:{i:0;s:63:\"/yotpo-social-reviews-for-woocommerce/assets/js/headerScript.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:39:\"plugin:45ab742b3fccbd04d7bc973c8582be87\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1680686421;}}s:6:\"themes\";O:8:\"stdClass\":120:{s:36:\"9aeea459-91d3-44b6-8a26-b883dca8b402\";O:8:\"stdClass\":8:{s:5:\"title\";s:43:\"Agensy - Load page without User Interaction\";s:9:\"condition\";s:6:\"agensy\";s:10:\"exclusions\";a:8:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:28:\"/themes/agensy/js/scripts.js\";i:2;s:35:\"/themes/agensy/js/scripts-single.js\";i:3;s:28:\"/themes/agensy/js/wow.min.js\";i:4;s:33:\"/themes/agensy/js/TweenMax.min.js\";i:5;s:31:\"/themes/agensy/js/swiper.min.js\";i:6;s:73:\"/plugins/visualcomposer/assets/lib/bower/isotope/dist/isotope.pkgd.min.js\";i:7;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7ab7dfeb0db9c0c74c020be318c2e6d9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1707317936;}s:36:\"9c623554-5834-4669-9e96-1b894c1939b2\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:0193ea55fce2ada93b262f2824008c0f\";s:5:\"title\";s:7:\"Andaman\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/andaman/assets/js/\";i:3;s:41:\"/wp-andaman-plugins/shortcodes/vc_extend/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:7:\"andaman\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"7374c5a5-69f8-460f-b44f-dee884a824cd\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:24cbda63f1b898ade5562ab4ec6d97a5\";s:5:\"title\";s:6:\"Artale\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:6:{i:0;s:40:\"/artale-elementor/assets/js/modulobox.js\";i:1;s:47:\"/artale-elementor/assets/js/artale-elementor.js\";i:2;s:28:\"/artale/js/jquery-stellar.js\";i:3;s:33:\"/artale/js/core/artale-plugins.js\";i:4;s:32:\"/artale/js/core/artale-custom.js\";i:5;s:10:\"var loader\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:6:\"artale\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"23b01203-2a70-4394-9326-d59824def2d7\";O:8:\"stdClass\":8:{s:5:\"title\";s:16:\"Ashe Pro Premium\";s:9:\"condition\";s:16:\"ashe-pro-premium\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:18:\"/ashe-pro-premium/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:4791da3cbbd1ed86253a087f0287aeb4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704912793;}s:36:\"03a9cc62-c167-447d-beb2-65c76c96b056\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Astra\";s:9:\"condition\";s:5:\"astra\";s:10:\"exclusions\";a:1:{i:0;s:41:\"/astra/assets/js/minified/frontend.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:3cce5f3eaf76e098ba8e28f7bbba3f92\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1702486947;}s:36:\"2a2b54cb-8e1d-49d2-bfca-93eee231e470\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:72a8d63e59c10bdf512a62b862d143a7\";s:5:\"title\";s:16:\"Astra - Carousel\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:9:\"var astra\";i:1;s:38:\"/astra/assets/js/minified/style.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"astra\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"7783361f-66fc-4d95-a054-4e9545bb5b48\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Auteur\";s:9:\"condition\";s:13:\"g5plus-auteur\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/g5plus-auteur/assets/js/core.min.js\";i:3;s:30:\"/g5plus-auteur/assets/vendors/\";i:4;s:106:\"/auteur-framework/libs/smart-framework/assets/vendors/perfect-scrollbar/js/perfect-scrollbar.jquery.min.js\";i:5;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:6207fe478e269e7547bda70a46607a49\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737107;}s:36:\"4c618038-8fc7-4d48-8d41-a32da14e5c1e\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"AutoTrader\";s:9:\"condition\";s:10:\"autotrader\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/autotrader/(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:046dfeee2b77390c53e0e7f93b6a3792\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679736741;}s:36:\"18f04f23-35a0-4c45-8cb6-a91d57ca1790\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:835da12f43373029659f766920e81b47\";s:5:\"title\";s:44:\"Avada - Animations & mobile-specific actions\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:31:\"/uploads/fusion-scripts/(.*).js\";i:3;s:18:\"window.off_canvas_\";i:4;s:24:\"/plugins/fusion-builder/\";i:5;s:21:\"/plugins/fusion-core/\";i:6;s:16:\"/Avada/includes/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"90135867-1b95-498b-80d6-f5dbf2f6b318\";O:8:\"stdClass\":8:{s:5:\"title\";s:21:\"Avada - FAQ shortcode\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:41:\"/plugins/fusion-core/js/min/avada-faqs.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b084708c80d8582546e5430219aa4670\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1678277160;}s:36:\"d23b5bb1-1d7f-4109-bf69-b20a2be2d337\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:5e7a2248e1a53d9bb27b187deb541248\";s:5:\"title\";s:23:\"Avada - Fusion carousel\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:58:\"/includes/lib/assets/min/js/library/jquery.carouFredSel.js\";i:3;s:54:\"/includes/lib/assets/min/js/general/fusion-carousel.js\";i:4;s:18:\"fusionCarouselVars\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"98dfa8c1-e72a-4cef-a0b2-8f0c322490fc\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:f16fb109027f4994a7649a8b1663e6f7\";s:5:\"title\";s:19:\"Avada - Fusion form\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:52:\"/fusion-builder/assets/js/min/general/fusion-form.js\";i:3;s:59:\"/fusion-builder/assets/js/min/general/fusion-form-logics.js\";i:4;s:44:\"/includes/lib/assets/min/js/library/cssua.js\";i:5;s:45:\"/includes/lib/assets/min/js/general/fusion.js\";i:6;s:48:\"/includes/lib/assets/min/js/library/modernizr.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"026801fa-af67-47ba-b966-347693f0585f\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:33f50696d353d8bd4eb59ff6e8f44c97\";s:5:\"title\";s:27:\"Avada - Fusion grid gallery\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:55:\"/fusion-builder/assets/js/min/general/fusion-gallery.js\";i:3;s:51:\"/includes/lib/assets/min/js/library/imagesLoaded.js\";i:4;s:46:\"/includes/lib/assets/min/js/library/isotope.js\";i:5;s:46:\"/includes/lib/assets/min/js/library/packery.js\";i:6;s:48:\"/includes/lib/assets/min/js/library/lazysizes.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"c8349314-15a3-481e-973b-e4d936e4420e\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:56fa9993a573540c83eda9c49fae5e3c\";s:5:\"title\";s:21:\"Avada - Fusion slider\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:42:\"/fusion-core/js/min/avada-fusion-slider.js\";i:3;s:16:\"/Avada/includes/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"7a04bc85-0fec-4487-ae05-bb2e5d8d0420\";O:8:\"stdClass\":8:{s:5:\"title\";s:34:\"Avada - Load Portfolio on pageload\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/library/packery.js\";i:3;s:19:\"/library/isotope.js\";i:4;s:24:\"/library/imagesLoaded.js\";i:5;s:27:\"/general/fusion-lightbox.js\";i:6;s:38:\"/fusion-core/js/min/avada-portfolio.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c3f0ed4d94499b68c77d95db37d1d399\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1696601814;}s:36:\"55bd510c-78aa-49d5-8304-8be2ee2ab0da\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:2189c1c769d65cfc2182e4822847071b\";s:5:\"title\";s:19:\"Avada - Mobile menu\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/assets/min/js/general/avada-menu.js\";i:3;s:48:\"/includes/lib/assets/min/js/library/modernizr.js\";i:4;s:52:\"/includes/lib/assets/min/js/library/jquery.easing.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"ddf00672-c35c-4b68-aeca-925e68bf12b2\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:97a185f08af70c39c7e221faab0f73eb\";s:5:\"title\";s:17:\"Avada - OffCanvas\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:35:\"/uploads/fusion-scripts/(.*).min.js\";i:3;s:18:\"window.off_canvas_\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"17544cc3-9d3a-4611-bc5d-44d04e2786fa\";O:8:\"stdClass\":8:{s:5:\"title\";s:44:\"Avada - Show the Portfolio grid on page load\";s:9:\"condition\";s:5:\"Avada\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:51:\"/includes/lib/assets/min/js/library/imagesLoaded.js\";i:3;s:46:\"/includes/lib/assets/min/js/library/isotope.js\";i:4;s:48:\"/includes/lib/assets/min/js/library/lazysizes.js\";i:5;s:48:\"/includes/lib/assets/min/js/library/modernizr.js\";i:6;s:46:\"/includes/lib/assets/min/js/library/packery.js\";i:7;s:38:\"/fusion-core/js/min/avada-portfolio.js\";i:8;s:18:\"avadaPortfolioVars\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:9d1a9b0c2ca20fca764a82f197b962fd\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1696601823;}s:36:\"c6c3347c-14e0-4766-afa5-df33a47f5a5a\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:3ff44421b404c5efffa25e78e479e4ea\";s:5:\"title\";s:19:\"Avada - Sticky menu\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:42:\"/Avada/assets/min/js/general/avada-menu.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"232596c1-6a6a-4fe8-a5c3-a60fa74a9456\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:0d727d80bb132f17c737e55883fe4be0\";s:5:\"title\";s:35:\"Avada - WooCommerce product gallery\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:50:\"/assets/min/js/general/avada-woo-product-images.js\";i:3;s:56:\"/includes/lib/assets/min/js/library/jquery.flexslider.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:5:\"Avada\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"95ece7e4-3b19-45e5-aa28-14f833c9afca\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Avesa\";s:9:\"condition\";s:5:\"avesa\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"/avesa/js/main.js\";i:3;s:20:\"/avesa/js/isotope.js\";i:4;s:24:\"/sw_core/js/slick.min.js\";i:5;s:41:\"/avesa/js/bootstrap-datetimepicker.min.js\";i:6;s:26:\"/avesa/js/bootstrap.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:aad8bfcc594eec02e3b0d635198dee5e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737993;}s:36:\"f2bfe477-4e45-4e52-a7d9-4d0ba3a92258\";O:8:\"stdClass\":8:{s:5:\"title\";s:4:\"Besa\";s:9:\"condition\";s:4:\"besa\";s:10:\"exclusions\";a:2:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:9:\"/besa/js/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c238e89523c46ca28b08e401f42f6ccc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738204;}s:36:\"bd94908c-8138-4995-986b-47ec66494bdd\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"BeTheme\";s:9:\"condition\";s:7:\"betheme\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:9:\"/betheme/\";i:2;s:3:\"mfn\";i:3;s:37:\"/wp-includes/js/jquery/ui/tabs.min.js\";i:4;s:37:\"/wp-includes/js/jquery/ui/core.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b99156eb9eeb357c0a70bd3bda6861cc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738639;}s:36:\"190d2f1a-72a6-40ca-b08a-5c7ee7b0a6a5\";O:8:\"stdClass\":8:{s:5:\"title\";s:54:\"Bosa Online Education - Fixes animations and preloader\";s:9:\"condition\";s:21:\"bosa-online-education\";s:10:\"exclusions\";a:6:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:38:\"/bosa/assets/js/jquery.slicknav.min.js\";i:2;s:31:\"/bosa/assets/slick/slick.min.js\";i:3;s:29:\"/bosa/assets/js/navigation.js\";i:4;s:29:\"/bosa/assets/js/custom.min.js\";i:5;s:43:\"/bosa/assets/js/theia-sticky-sidebar.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:5430bf7b83c83a3687b3b7b437e961b0\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1708371742;}s:36:\"6fb2b9d7-6ecc-4260-999c-938fbebdbf01\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:de8504b73ea228d0ea9bbce69752092e\";s:5:\"title\";s:6:\"Bridge\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:27:\"/bridge-creative/bridge/js/\";i:2;s:16:\"/wp-includes/js/\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:6:\"bridge\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"65698b6b-85dd-41ef-8fd7-718f1e983dba\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"Car Dealer\";s:9:\"condition\";s:9:\"cardealer\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:27:\"/wp-includes/js/jquery/(.*)\";i:3;s:18:\"/cardealer/js/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b1111424fff61af8d1e152dcdd6810f6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737517;}s:36:\"3927d724-5a0a-402b-a838-858d30b54ea9\";O:8:\"stdClass\":8:{s:5:\"title\";s:34:\"Cardea - Show Page Content on Load\";s:9:\"condition\";s:9:\"cardea-wp\";s:10:\"exclusions\";a:5:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:28:\"/themes/cardea-wp/js/main.js\";i:2;s:37:\"/themes/cardea-wp/js/jquery.sticky.js\";i:3;s:38:\"/themes/cardea-wp/js/jquery.fitvids.js\";i:4;s:45:\"/themes/cardea-wp/js/jquery.smartmenus.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d65d1a8303b0c7508278884520e4bec7\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1698677525;}s:36:\"087fb457-a09d-4140-84bd-c9bc1e8195b7\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"CheerUp\";s:9:\"condition\";s:7:\"cheerup\";s:10:\"exclusions\";a:9:{i:0;s:36:\"/cheerup/js/jquery.sticky-sidebar.js\";i:1;s:32:\"/cheerup/js/object-fit-images.js\";i:2;s:29:\"/cheerup/js/jquery.fitvids.js\";i:3;s:34:\"/cheerup/js/jquery.mfp-lightbox.js\";i:4;s:27:\"/cheerup/js/ie-polyfills.js\";i:5;s:20:\"/cheerup/js/theme.js\";i:6;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:7;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:8;s:36:\"/wp-includes/js/jquery/jquery.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:13bcf562f45afb245dc4f76fecfba6d6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1696429398;}s:36:\"eb86aedb-91e6-480c-b76c-756ac1da41be\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Clover\";s:9:\"condition\";s:12:\"clover-theme\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/clover-theme/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:89372f3d9321ae09c94488592084da29\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738878;}s:36:\"6e90b649-5736-497f-9bc6-515900cfea8a\";O:8:\"stdClass\":8:{s:5:\"title\";s:17:\"Divi - Animations\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:26:\"/Divi/js/custom.unified.js\";i:5;s:21:\"/js/magnific-popup.js\";i:6;s:8:\"var DIVI\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c0abf30dba4ff13db836d1b01685953a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737389;}s:36:\"70916c43-4e02-4932-b6aa-91a1815bc755\";O:8:\"stdClass\":8:{s:5:\"title\";s:23:\"Divi - Background video\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:26:\"/Divi/js/custom.unified.js\";i:3;s:21:\"/js/mediaelement/(.*)\";i:4;s:4:\"mejs\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c7edea41ae6716291e2d32a2ab429209\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738240;}s:36:\"08531785-9818-4e30-903e-564637a2ad7a\";O:8:\"stdClass\":8:{s:5:\"title\";s:21:\"Divi - Counter module\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:26:\"/Divi/js/custom.unified.js\";i:5;s:21:\"/js/magnific-popup.js\";i:6;s:8:\"var DIVI\";i:7;s:71:\"/Divi/includes/builder/feature/dynamic-assets/assets/js/easypiechart.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2c46b9f5a770f260c3f7115bb330b2d5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679736810;}s:36:\"b996762a-84ef-440d-a089-73a187936fbf\";O:8:\"stdClass\":8:{s:5:\"title\";s:18:\"Divi - Mobile menu\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:23:\"/Divi/js/scripts.min.js\";i:3;s:26:\"/Divi/js/custom.unified.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b9116994f4e4b9b9fa574440c00d2f0d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738580;}s:36:\"ae096e1e-9c36-46ad-a3d1-c26ea507276b\";O:8:\"stdClass\":8:{s:5:\"title\";s:22:\"Divi - Sticky elements\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\".dipi_preloader_wrapper_outer\";i:3;s:23:\"/Divi/js/scripts.min.js\";i:4;s:74:\"/Divi/includes/builder/feature/dynamic-assets/assets/js/sticky-elements.js\";i:5;s:8:\"var DIVI\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:8b62db03c90245f3e690335b079b05dc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737191;}s:36:\"349f31f0-dd10-41d3-b0a4-9c5df64879f8\";O:8:\"stdClass\":8:{s:5:\"title\";s:18:\"Divi - Sticky menu\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:32:\"/js/jquery/jquery-migrate.min.js\";i:2;s:23:\"/Divi/js/scripts.min.js\";i:3;s:73:\"/Divi/includes/builder/feature/dynamic-assets/assets/js/magnific-popup.js\";i:4;s:12:\"jqueryParams\";i:5;s:11:\"firstHeader\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b7b84aca0f0dc6a1ced31d38626c50ea\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738821;}s:36:\"59563458-5f04-4959-b3e2-53e49e169d67\";O:8:\"stdClass\":8:{s:5:\"title\";s:40:\"Divi - WooCommerce Single Product Images\";s:9:\"condition\";s:4:\"Divi\";s:10:\"exclusions\";a:1:{i:0;s:23:\"/Divi/js/scripts.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:f9c5bdba8b39fc877b41dea00fa756f9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1684342262;}s:36:\"6426539e-4e43-4fef-ab5a-3eb7b2a8b057\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Eikra\";s:9:\"condition\";s:5:\"eikra\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:17:\"/eikra/assets/js/\";i:3;s:8:\"EikraObj\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:55d2581ad975eb6325bc97fc3d3b0cb8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738450;}s:36:\"59020bd6-069f-4f2d-afa2-fbdefa03211c\";O:8:\"stdClass\":8:{s:5:\"title\";s:4:\"Ekko\";s:9:\"condition\";s:4:\"ekko\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:6:\"/ekko/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2c06f4a1949f8ba4e77042a47674fd9e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737803;}s:36:\"d82f5cdd-c5d3-4596-94dc-1e25aaff2083\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Elessi\";s:9:\"condition\";s:12:\"elessi-theme\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:44:\"/elessi-theme/assets/js/min/functions.min.js\";i:3;s:39:\"/elessi-theme/assets/js/min/main.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d5d2b7fda7b8a2b5b91d430f7602e230\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737773;}s:36:\"f0587c21-54d0-429d-8efe-18a93dacb18d\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:5fc04cc678cb54567aedb51027933002\";s:5:\"title\";s:6:\"Enfold\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:41:\"/dynamic_avia/avia-footer-scripts-(.*).js\";i:3;s:18:\"var avia_is_mobile\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:6:\"enfold\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"cc0550cb-918e-419d-b4f2-1809cf666dbb\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:eb759a03d0ca292c948f09d004a2963f\";s:5:\"title\";s:20:\"Enfold - LayerSlider\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"layerslider\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:6:\"enfold\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"ec883654-4f63-4fae-a3ef-923dcbc2426d\";O:8:\"stdClass\":8:{s:5:\"title\";s:19:\"Enfold - Shortcodes\";s:9:\"condition\";s:6:\"enfold\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:18:\"/enfold/js/avia.js\";i:3;s:24:\"/enfold/js/shortcodes.js\";i:4;s:47:\"/enfold/config-templatebuilder/avia-shortcodes/\";i:5;s:25:\"/enfold/js/avia-compat.js\";i:6;s:37:\"/enfold/js/waypoints/waypoints.min.js\";i:7;s:31:\"/enfold/js/avia-snippet-(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:072fc4077d7071791d774d6ddbf5dc2a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1684519716;}s:36:\"fe3546f0-be3e-4173-8992-a7f6f203b82f\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"Envision\";s:9:\"condition\";s:8:\"envision\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:27:\"/envision/lib/js/app.min.js\";i:3;s:13:\"var CloudFwOp\";}s:10:\"is_default\";i:1;s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:fc5f7d69b646ed95835badc0fc23bc11\";s:10:\"created_at\";i:1679737494;}s:36:\"d997b942-19de-4710-9c81-79d3c65cbd76\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:047f009f2a1f4cdf2088c46be47e385b\";s:5:\"title\";s:6:\"Ewebot\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"/gt3-themes-core/\";i:3;s:27:\"/uploads/gt3-assets/js/(.*)\";i:4;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:6:\"ewebot\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"53d29aec-8ae4-4273-b748-f5bd52dfe177\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Farvis\";s:9:\"condition\";s:6:\"farvis\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:8:\"/farvis/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:26bff2f3a6ff6347d35edf5c77a35687\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737972;}s:36:\"fb01246b-a5f8-4021-b514-c02cf55e80bd\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"Flatsome\";s:9:\"condition\";s:8:\"flatsome\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:31:\"/flatsome/assets/js/flatsome.js\";i:3;s:41:\"/flatsome/assets/libs/packery.pkgd.min.js\";i:4;s:34:\"/flatsome/assets/js/woocommerce.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:26fb1cf80f074ca199d8a7e94c5fc796\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738732;}s:36:\"4d65dc12-9ce7-4171-94a7-9821fd95240e\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:28a6f8b3319c107a34603be0f01a4bcf\";s:5:\"title\";s:21:\"Flatsome - Google map\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"maps.googleapis.com\";i:3;s:18:\"google.maps.LatLng\";i:4;s:34:\"/wp-includes/js/hoverIntent.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:8:\"flatsome\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"890e15b6-c66b-4a9e-9b7d-55417df94916\";O:8:\"stdClass\":8:{s:5:\"title\";s:17:\"Flatsome - Images\";s:9:\"condition\";s:8:\"flatsome\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:58:\"/flatsome/inc/integrations/wp-rocket/flatsome-wp-rocket.js\";i:3;s:31:\"/flatsome/assets/js/flatsome.js\";i:4;s:65:\"/flatsome/inc/extensions/flatsome-lazy-load/flatsome-lazy-load.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:f2d60aad9f2f5395e3e145cf8f8ab165\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737691;}s:36:\"cb54d070-8ee0-4c35-9fa9-b2bac73ccf39\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Frida\";s:9:\"condition\";s:5:\"frida\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:7:\"/frida/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:109ddf56796a5133e12279f3daa5ff62\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738013;}s:36:\"9e78539a-03d9-442b-ab94-dd3b7a9658e4\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:80a330247d61d729fcd78dc01de6ed2f\";s:5:\"title\";s:27:\"GeneratePress - Mobile menu\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/generatepress/assets/js/menu.min.js\";i:1;s:17:\"generatepressMenu\";i:2;s:49:\"/gp-premium/menu-plus/functions/js/offside.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:13:\"generatepress\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"6373bbb2-877c-4075-b6e4-7c58d686b25c\";O:8:\"stdClass\":8:{s:5:\"title\";s:36:\"HealthFirst - Prevent console errors\";s:9:\"condition\";s:11:\"healthfirst\";s:10:\"exclusions\";a:7:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:34:\"/wp-includes/js/hoverIntent.min.js\";i:2;s:70:\"/wp-content/plugins/healthfirst-core/assets/js/healthfirst-core.min.js\";i:3;s:74:\"/wp-content/plugins/healthfirst-core/assets/plugins/modernizr/modernizr.js\";i:4;s:101:\"/wp-content/plugins/healthfirst-core/assets/plugins/perfect-scrollbar/perfect-scrollbar.jquery.min.js\";i:5;s:52:\"/wp-content/themes/healthfirst/assets/js/main.min.js\";i:6;s:83:\"/wp-content/themes/healthfirst/assets/plugins/waitforimages/jquery.waitforimages.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d244b3c692f8d023048207dbe9eb84da\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1699370973;}s:36:\"2c72e7e6-cb77-44e9-af87-d5c42ae6db52\";O:8:\"stdClass\":8:{s:5:\"title\";s:20:\"Honor - WPBakery fix\";s:9:\"condition\";s:5:\"honor\";s:10:\"exclusions\";a:3:{i:0;s:22:\"/honor/js/__scripts.js\";i:1;s:13:\"HONOR_STORAGE\";i:2;s:13:\"/js_composer/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:9f228373ff4d172655dbf5cb3b1bc23a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679736895;}s:36:\"9309d1d3-1035-4a2c-8ced-075bc3ff9957\";O:8:\"stdClass\":8:{s:5:\"title\";s:11:\"HotelMaster\";s:9:\"condition\";s:11:\"hotelmaster\";s:10:\"exclusions\";a:7:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:38:\"/hotelmaster/javascript/gdlr-script.js\";i:3;s:48:\"/hotelmaster/plugins/dl-menu/modernizr.custom.js\";i:4;s:45:\"/hotelmaster/plugins/dl-menu/jquery.dlmenu.js\";i:5;s:46:\"/hotelmaster/plugins/superfish/js/superfish.js\";i:6;s:37:\"/hotelmaster/plugins/jquery.easing.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:978eaddad3b1047e479407b6d92197aa\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738595;}s:36:\"4a09f745-cbb1-47c8-b50a-c8014d5d1335\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:e813a548bceac6765a1cdf2316f1a6ab\";s:5:\"title\";s:18:\"HotelMaster - Blog\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:30:\"/wp-includes/js/masonry.min.js\";i:1;s:44:\"/gp-premium/blog/functions/js/scripts.min.js\";i:2;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:11:\"hotelmaster\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f2d8f704-ec68-4278-9ca2-885daa0c1ce5\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:398a264e302e42640553681e8759cd07\";s:5:\"title\";s:21:\"HotelMaster - Masonry\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:49:\"/gp-premium/menu-plus/functions/js/offside.min.js\";i:1;s:7:\"offSide\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:11:\"hotelmaster\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"92b2e258-1f44-41c1-b1bd-f117f61ee49d\";O:8:\"stdClass\":8:{s:5:\"title\";s:31:\"Jannah Theme - Fix masonry grid\";s:9:\"condition\";s:6:\"jannah\";s:10:\"exclusions\";a:4:{i:0;s:36:\"/wp-includes/js/jquery/jquery.min.js\";i:1;s:30:\"/wp-includes/js/masonry.min.js\";i:2;s:44:\"/wp-includes/js/jquery/jquery.masonry.min.js\";i:3;s:4:\"tie-\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:35f7f183089309f52046377ca65e905a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1699642920;}s:36:\"df52436c-53d6-461a-b81a-cd0b21680524\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"JNews\";s:9:\"condition\";s:5:\"jnews\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:17:\"/jnews/assets/js/\";i:3;s:5:\"jnews\";i:4;s:4:\"jfla\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:5d90e451984f9d894b1aabb0d00f30a2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738860;}s:36:\"87ed69a2-3295-4fad-a82e-eeb02925a5dc\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Jobify\";s:9:\"condition\";s:6:\"jobify\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:24:\"/jobify/js/jobify.min.js\";i:3;s:30:\"/jobify/js/select2.full.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:592006aa4562a6915e344e5e2a09e5ee\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735224;}s:36:\"28a0b1ea-8d2f-4931-a48a-166b8df8a773\";O:8:\"stdClass\":8:{s:5:\"title\";s:4:\"JOYN\";s:9:\"condition\";s:4:\"joyn\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:81:\"/swift-framework/includes/page-builder/frontend-assets/js/lib/modernizr-custom.js\";i:3;s:78:\"/swift-framework/includes/page-builder/frontend-assets/js/spb-functions.min.js\";i:4;s:68:\"/swift-framework/includes/swift-slider/assets/js/swift-slider.min.js\";i:5;s:55:\"/swift-framework/public/js/lib/imagesloaded.pkgd.min.js\";i:6;s:28:\"/joyn/js/owl.carousel.min.js\";i:7;s:25:\"/joyn/js/theme-scripts.js\";i:8;s:21:\"/joyn/js/functions.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c395470ad2d4d681836cd942bbb03120\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738527;}s:36:\"542be60a-2346-4740-9a41-8a580c4f013c\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Juno Toys\";s:9:\"condition\";s:8:\"junotoys\";s:10:\"exclusions\";a:8:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:22:\"/jquery-migrate.min.js\";i:2;s:28:\"/junotoys/fw/js/core.init.js\";i:3;s:29:\"/junotoys/fw/js/core.utils.js\";i:4;s:28:\"/junotoys/fw/js/superfish.js\";i:5;s:32:\"/junotoys/fw/js/swiper/swiper.js\";i:6;s:41:\"/trx_utils/shortcodes/theme.shortcodes.js\";i:7;s:30:\"/wp-includes/js/jquery/ui/(.*)\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2acab38e8356d36355bb81d931e7fba4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737788;}s:36:\"06167710-10c7-446e-a08b-ce676e444102\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"Jupiter\";s:9:\"condition\";s:7:\"jupiter\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/jupiter/\";i:3;s:33:\"/wp-includes/js/underscore.min.js\";i:4;s:12:\"WebFont.load\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:89c5c30498c2989611f9044be006197c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738430;}s:36:\"5d042e1f-7e62-4ec4-ba31-30d396004522\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"JupiterX\";s:9:\"condition\";s:8:\"jupiterx\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"/jupiterx/(.*).js\";i:3;s:33:\"/wp-includes/js/underscore.min.js\";i:4;s:12:\"WebFont.load\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b06632962a4948d4944fd8d79ffbfceb\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737312;}s:36:\"c4b030ea-66a1-4729-85bf-a484e373a316\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"Kadence\";s:9:\"condition\";s:7:\"kadence\";s:10:\"exclusions\";a:3:{i:0;s:36:\"/kadence/assets/js/navigation.min.js\";i:1;s:22:\"mobile_menu_breakpoint\";i:2;s:13:\"kadenceConfig\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:4b7907ee68218db279648da9bf7102d1\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735260;}s:36:\"20c605b4-3e3a-4bb0-a5e5-a08e2cb0f31f\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Kalium\";s:9:\"condition\";s:6:\"kalium\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/kalium/assets/js/main.min.js\";i:3;s:22:\"mobile_menu_breakpoint\";i:4;s:6:\"var _k\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:1fcb99a1ab06e1e36635365ed3e59ce5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737406;}s:36:\"e1e04a7d-635a-4e28-83d9-e345ce40e354\";O:8:\"stdClass\":8:{s:5:\"title\";s:4:\"Kava\";s:9:\"condition\";s:4:\"kava\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:31:\"/kava/assets/js/theme-script.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:359d67efbf530c998245225dd3245a88\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738609;}s:36:\"e833c36e-ee89-4924-b608-3f28327c2f85\";O:8:\"stdClass\":8:{s:5:\"title\";s:3:\"Lay\";s:9:\"condition\";s:3:\"lay\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:31:\"/wp-includes/js/backbone.min.js\";i:2;s:33:\"/wp-includes/js/underscore.min.js\";i:3;s:5:\"/lay/\";i:4;s:19:\"/laytheme-carousel/\";i:5;s:15:\"window.laytheme\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7c718c6da874ea6e4b27c6d70bc4e7e8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737453;}s:36:\"2df2ef47-a833-4711-ba54-48dc62586f37\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:85d9922ac61ed833fd047a67029df8e5\";s:5:\"title\";s:8:\"LazaNews\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:17:\"/jquery.custom.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:8:\"lazanews\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"9443304a-34e9-4700-a03a-5f8f62f83ed1\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Listeo\";s:9:\"condition\";s:6:\"listeo\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/listeo/js/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:db7da585545001f5ae614a2810f08f3a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737244;}s:36:\"77afa73c-c4a8-42a8-aaee-43f6a761364e\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"ListingPro\";s:9:\"condition\";s:10:\"listingpro\";s:10:\"exclusions\";a:13:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:62:\"/listingpro/assets/lib/jquerym.menu/js/jquery.mmenu.min.all.js\";i:3;s:73:\"/listingpro/assets/lib/Magnific-Popup-master/jquery.magnific-popup.min.js\";i:4;s:41:\"/listingpro/assets/js/select2.full.min.js\";i:5;s:49:\"/listingpro/assets/js/jquery.city-autocomplete.js\";i:6;s:42:\"/listingpro/assets/js/chosen.jquery.min.js\";i:7;s:55:\"/listingpro/assets/lib/bootstrap/js/bootstrap-slider.js\";i:8;s:34:\"/listingpro/assets/js/jquery-ui.js\";i:9;s:31:\"/listingpro/assets/js/mapbox.js\";i:10;s:29:\"/listingpro/assets/js/main.js\";i:11;s:46:\"/listingpro/assets/js/leaflet.markercluster.js\";i:12;s:4:\"maps\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:0b365e43dfc65d2b1b70fac6510c7c9c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737938;}s:36:\"01b369b5-b578-4314-8e95-40b67a41d75a\";O:8:\"stdClass\":8:{s:5:\"title\";s:12:\"Master Study\";s:9:\"condition\";s:11:\"masterstudy\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:32:\"/masterstudy/assets/js/custom.js\";i:3;s:50:\"/masterstudy/assets/vendors/jquery.fancybox.min.js\";i:4;s:42:\"/masterstudy/assets/js/select2.full.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:0ee224c20e4ef7d546733d933db598f2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735299;}s:36:\"6b000cc7-d33b-4109-9c39-6119a5d81cde\";O:8:\"stdClass\":8:{s:5:\"title\";s:4:\"Maya\";s:9:\"condition\";s:4:\"maya\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/maya/js/jquery.mobilemenu.js\";i:3;s:25:\"/maya/js/jquery.custom.js\";i:4;s:38:\"/maya/core/includes/js/jquery.tipsy.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:719fe28004fcdd81a820602924aa8074\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737916;}s:36:\"ef3c76d6-1041-473d-81ea-a5a6e8c86735\";O:8:\"stdClass\":8:{s:5:\"title\";s:11:\"MH Magazine\";s:9:\"condition\";s:11:\"mh-magazine\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:13:\"/mh-magazine/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2a0cd6efc2f46be69de61712729a2ec9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737743;}s:36:\"9cbb2777-5524-43b8-af36-692b27452c0d\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"Minimog\";s:9:\"condition\";s:7:\"minimog\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/minimog/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:61c0c235042359ee7d2a9035e79a7da2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738135;}s:36:\"7eb81c74-8062-4a6c-bf66-b7c5bc160141\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"Moozo Elementor\";s:9:\"condition\";s:15:\"moozo-elementor\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:39:\"/moozo-elementor/assets/js/countdown.js\";i:3;s:57:\"/moozo-elementor/assets/vendor/countdown/countdown.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:2ddb538c8e6b6c766fffd0d5c861fd82\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738623;}s:36:\"e90b7bfa-9ff6-4e1a-bf29-6207d55fdd39\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Motor\";s:9:\"condition\";s:5:\"motor\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:10:\"/motor/js/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b33538179f5661a86cbe327a1793e199\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683973354;}s:36:\"445e625a-f955-41fa-84de-65d9ea19be07\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"My Listing\";s:9:\"condition\";s:10:\"my-listing\";s:10:\"exclusions\";a:7:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/my-listing/assets/\";i:3;s:41:\"/wp-includes/js/dist/vendor/moment.min.js\";i:4;s:19:\"maps.googleapis.com\";i:5;s:9:\"MyListing\";i:6;s:17:\"_Explore_Settings\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:afacb777229ddf5cabceacc64948057d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737725;}s:36:\"00b8cd2d-2781-4fbb-ac5d-00750ba94ac9\";O:8:\"stdClass\":8:{s:5:\"title\";s:18:\"Neve - Mobile menu\";s:9:\"condition\";s:4:\"neve\";s:10:\"exclusions\";a:1:{i:0;s:40:\"/neve/assets/js/build/modern/frontend.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:5ae731cc06dd9284f8172675a6fe81ab\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738714;}s:36:\"483abc54-f1fc-47dc-bfc1-a269c7d1c849\";O:8:\"stdClass\":8:{s:5:\"title\";s:18:\"Newspaper - Images\";s:9:\"condition\";s:9:\"Newspaper\";s:10:\"exclusions\";a:10:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"tagdiv_theme.min.js\";i:3;s:13:\"tdBlocksArray\";i:4;s:33:\"/wp-includes/js/underscore.min.js\";i:5;s:28:\"/td-cloud-library/assets/js/\";i:6;s:44:\"/npm/slick-carousel@1.8.1/slick/slick.min.js\";i:7;s:16:\"tdb-gallery-wrap\";i:8;s:13:\"tdBlocksArray\";i:9;s:4:\"tdb_\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:649ff22527bac2b1c8e0115cd3851d53\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1695805761;}s:36:\"50db8d14-d421-4237-be14-a6f7b5c11ec5\";O:8:\"stdClass\":8:{s:5:\"title\";s:28:\"Newspaper - Slider & YouTube\";s:9:\"condition\";s:9:\"Newspaper\";s:10:\"exclusions\";a:14:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"tagdiv_theme.min.js\";i:3;s:13:\"tdBlocksArray\";i:4;s:11:\"tdb_globals\";i:5;s:19:\"td_youtube_list_ids\";i:6;s:9:\"iosSlider\";i:7;s:53:\"/td-cloud-library/assets/js/js_files_for_front.min.js\";i:8;s:33:\"/wp-includes/js/underscore.min.js\";i:9;s:28:\"/td-cloud-library/assets/js/\";i:10;s:44:\"/npm/slick-carousel@1.8.1/slick/slick.min.js\";i:11;s:16:\"tdb-gallery-wrap\";i:12;s:13:\"tdBlocksArray\";i:13;s:4:\"tdb_\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7e2eeee57ae458c5959342eda6526bf1\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1695805747;}s:36:\"514f4c30-2b67-4648-960e-dfe1cc401ca5\";O:8:\"stdClass\":8:{s:5:\"title\";s:4:\"Niva\";s:9:\"condition\";s:4:\"niva\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/niva/js/\";i:3;s:26:\"/sweetthemes-framework/js/\";i:4;s:8:\"mt_typed\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c4838f73a344b829ed626635e210dcf4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738256;}s:36:\"e67ee504-c3b1-455e-88ab-1fae8c830652\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"OceanWP\";s:9:\"condition\";s:7:\"oceanwp\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/oceanwp/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:db37af4b7d12695d37d9256313a5f37a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737552;}s:36:\"e44e240a-8765-4f4f-b67e-d54e4b727506\";O:8:\"stdClass\":8:{s:5:\"title\";s:21:\"OceanWP - Mobile menu\";s:9:\"condition\";s:7:\"oceanwp\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:45:\"/ocean-side-panel/assets/js/side-panel.min.js\";i:3;s:39:\"/oceanwp/assets/js/theme.vanilla.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:9babbcd52b2ce558d299a06cd1130a11\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738463;}s:36:\"897b0100-958d-4a02-b6b2-1e753e9869f4\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"PenNews\";s:9:\"condition\";s:7:\"pennews\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:25:\"/pennews/js/script.min.js\";i:3;s:29:\"/pennews/js/script.lib.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:02811fa00bc1471bb5be0457ce0ee005\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735339;}s:36:\"edd3ba03-e0fd-4b6e-911b-60b29f3471bf\";O:8:\"stdClass\":8:{s:5:\"title\";s:15:\"Pharmacy Mentor\";s:9:\"condition\";s:14:\"pharmacymentor\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:16:\"/pharmacymentor/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:3188aaf1ef2c39937450f2a14ebb1174\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738214;}s:36:\"725415ff-cc76-45cc-a131-3170e5aa30fc\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Porto\";s:9:\"condition\";s:5:\"porto\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:26:\"/wp-includes/js/jquery/ui/\";i:3;s:18:\"/porto/js/theme.js\";i:4;s:22:\"/porto/js/theme.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:8493f398f200c8dffe60d46439dd3360\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737758;}s:36:\"2c19bcec-f3ff-4873-bfd7-db6bc0f6433c\";O:8:\"stdClass\":8:{s:5:\"title\";s:20:\"Porto - Owl Carousel\";s:9:\"condition\";s:5:\"porto\";s:10:\"exclusions\";a:6:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:26:\"/wp-includes/js/jquery/ui/\";i:2;s:25:\"/porto/js/theme(|.min).js\";i:3;s:37:\"/porto/js/libs/owl.carousel(|.min).js\";i:4;s:31:\"/porto/js/theme-async(|.min).js\";i:5;s:41:\"/prettyPhoto/jquery.prettyPhoto(|.min).js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:f34f5199fb7fca78852cd3fb7758f178\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1687527252;}s:36:\"5b11ec89-1cb2-4793-8b77-79e917e810a0\";O:8:\"stdClass\":8:{s:5:\"title\";s:35:\"Pro Theme - Fix menu and accordions\";s:9:\"condition\";s:3:\"pro\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:50:\"/pro/cornerstone/assets/js/site/cs-classic.(.*).js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:8f30d70dd2d9a0386445aef8fdd534a9\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1708100602;}s:36:\"31347ccb-f69e-4cd3-bd47-b80ce14ac76e\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"ProPhoto\";s:9:\"condition\";s:9:\"prophoto7\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:29:\"/prophoto7/js/bundle.front.js\";i:2;s:33:\"/wp-includes/js/underscore.min.js\";i:3;s:8:\"PROPHOTO\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:a5836a56c4472fade4dc6ebfe2281554\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737425;}s:36:\"a8208c04-865c-49aa-ab96-41e378d391c8\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Publisher\";s:9:\"condition\";s:9:\"publisher\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:14:\"/publisher/js/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:32c73be0cb175da278c8e2af0811b0d1\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738169;}s:36:\"a0d69f3d-1356-4a1d-a600-2f2f788b8a9a\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"REHub\";s:9:\"condition\";s:11:\"rehub-theme\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/rehub-theme/js/custom_floatpanel.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:321af1febb74f488cf911380893739b2\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738502;}s:36:\"8b74bbe5-7f32-42df-908f-78c99a8cad82\";O:8:\"stdClass\":8:{s:5:\"title\";s:3:\"Rey\";s:9:\"condition\";s:3:\"rey\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:20:\"/rey/scripts-(.*).js\";i:3;s:20:\"/rey-core/assets/js/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:e46567cd0f3ec9b37e7230dc87eac367\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737011;}s:36:\"5c9115d3-bcbd-49d6-8feb-4880d2b82bfe\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Rife Free\";s:9:\"condition\";s:9:\"rife-free\";s:10:\"exclusions\";a:5:{i:0;s:27:\"/rife-free/js/script.min.js\";i:1;s:33:\"/rife-free/js/isotope.pkgd.min.js\";i:2;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:3;s:25:\"/jquery-migrate(.min)?.js\";i:4;s:8:\"var reJS\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:74a449954de79625eccc6750e87af8f6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738107;}s:36:\"6542b2fd-1f91-4862-aa18-11eecc02faaf\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Roisin\";s:9:\"condition\";s:6:\"roisin\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:36:\"/themes/roisin/assets/js/main.min.js\";i:3;s:49:\"/plugins/roisin-core/assets/js/roisin-core.min.js\";i:4;s:34:\"/wp-includes/js/hoverIntent.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:8f38fe58034772931110930b91cb6797\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1685964523;}s:36:\"5a192ad9-d150-4aa0-8efc-d68131cb7a37\";O:8:\"stdClass\":8:{s:5:\"title\";s:20:\"Sahifa - Mobile Menu\";s:9:\"condition\";s:6:\"sahifa\";s:10:\"exclusions\";a:3:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:37:\"/themes/sahifa/js/ilightbox.packed.js\";i:2;s:23:\"/translate_a/element.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:06ebe49f4c1e5b04cece831f8bb198a3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1687540363;}s:36:\"7ae9d978-d63c-4a58-beb3-418bebb5b23c\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"Salient\";s:9:\"condition\";s:7:\"salient\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:9:\"/salient/\";i:3;s:12:\"winW > bodyW\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:b3e12d57ac23897be1bb2c673e3fc761\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735382;}s:36:\"35aaa6c5-4a37-4161-b504-fb3ebc4b1148\";O:8:\"stdClass\":8:{s:5:\"title\";s:23:\"Salient - Nectar slider\";s:9:\"condition\";s:7:\"salient\";s:10:\"exclusions\";a:3:{i:0;s:42:\"/salient-nectar-slider/js/nectar-slider.js\";i:1;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:2;s:25:\"/jquery-migrate(.min)?.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d612db1dd8dc76faa6a36a9ebfd336dc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704735415;}s:36:\"84c95206-3e59-4eb3-a0c9-e2231a1c0a48\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"SEO Lounge\";s:9:\"condition\";s:9:\"seolounge\";s:10:\"exclusions\";a:4:{i:0;s:67:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?$\";i:1;s:52:\"/js_composer/assets/js/dist/js_composer_front.min.js\";i:2;s:37:\"/seolounge/js/radiantthemes-custom.js\";i:3;s:39:\"/seolounge/js/radiantthemes-core.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:3d72b779d9c4ba6b51cc5b245b141433\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1691695809;}s:36:\"cd44aa56-088a-40dd-bf1e-f835efa68626\";O:8:\"stdClass\":8:{s:5:\"title\";s:11:\"Shoptimizer\";s:9:\"condition\";s:11:\"shoptimizer\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:37:\"/shoptimizer/assets/js/lazyload-bg.js\";i:3;s:34:\"/shoptimizer/assets/js/main.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:6c32b43f4da639e5901574fac6b7d387\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737143;}s:36:\"d2c48a48-430a-4eea-bc05-99b66f1f6a7b\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"SmartMag\";s:9:\"condition\";s:9:\"smart-mag\";s:10:\"exclusions\";a:1:{i:0;s:25:\"/smart-mag/js/lazyload.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:23d6b7878bd0087addb067db3fa39864\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738490;}s:36:\"dd0d9133-ef17-4dac-b174-9f25d535838f\";O:8:\"stdClass\":8:{s:5:\"title\";s:7:\"Soledad\";s:9:\"condition\";s:7:\"soledad\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:19:\"/soledad/js/main.js\";i:3;s:24:\"/soledad/js/more-post.js\";i:4;s:30:\"/soledad/js/libs-script.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d3f78b26c2d11c99230171cc6378d06e\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737664;}s:36:\"3b85dd6e-9534-477e-9b15-940d0e155c8d\";O:8:\"stdClass\":8:{s:5:\"title\";s:22:\"Spacious - Mobile Menu\";s:9:\"condition\";s:8:\"spacious\";s:10:\"exclusions\";a:2:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:26:\"/spacious/js/navigation.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d423c1f002b10b8682ee24d616b19c9c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1703192854;}s:36:\"d657dc56-5c04-439a-8987-401f89a65bf9\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Stockholm\";s:9:\"condition\";s:9:\"stockholm\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"/stockholm/js/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:fcfff492e00727b63cf5dff9f59bc2a4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738378;}s:36:\"121f9b1b-d3cd-4dde-915e-0b348abf6687\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"Storefront\";s:9:\"condition\";s:10:\"storefront\";s:10:\"exclusions\";a:1:{i:0;s:39:\"/storefront/assets/js/navigation.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:f0dca7e4eaedf573d4664be249845942\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738793;}s:36:\"41cfc83f-ff02-4a35-a3b7-e92db213b224\";O:8:\"stdClass\":8:{s:5:\"title\";s:10:\"StreamTube\";s:9:\"condition\";s:10:\"streamtube\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:12:\"/streamtube/\";i:3;s:17:\"/streamtube-core/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:9772ccddd470688f6bc6aee86e34d29b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679331431;}s:36:\"aec0a548-4c6b-400a-80ed-19a49e0faef0\";O:8:\"stdClass\":8:{s:5:\"title\";s:4:\"The7\";s:9:\"condition\";s:7:\"dt-the7\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";i:2;s:14:\"loader-removed\";i:3;s:34:\"/Ultimate_VC_Addons/assets/min-js/\";i:4;s:9:\"/dt-the7/\";i:5;s:13:\"/js_composer/\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:7934c689fd20e30b6bfc69bb9d46cb63\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737892;}s:36:\"538354ff-d69f-40be-b0cc-df3790599dd2\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"TheGem\";s:9:\"condition\";s:6:\"thegem\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/thegem/js/\";i:3;s:11:\"gemSettings\";i:4;s:15:\"thegemSlideshow\";i:5;s:19:\"tgpLazyItemsOptions\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:153c54fe73897da838ce39152b1db5a8\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738477;}s:36:\"84d95a79-270c-4223-b459-bb49c6acfaf1\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"Theme Electiman - Mobile Menu\";s:9:\"condition\";s:9:\"electiman\";s:10:\"exclusions\";a:8:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:41:\"/themes/electiman/assets/js/navigation.js\";i:2;s:45:\"/themes/electiman/assets/js/theme-pluginjs.js\";i:3;s:36:\"/themes/electiman/assets/js/theme.js\";i:4;s:40:\"/themes/electiman/assets/js/slick.min.js\";i:5;s:40:\"/themes/electiman/venobox/venobox.min.js\";i:6;s:47:\"/themes/electiman/assets/js/owl.carousel.min.js\";i:7;s:35:\"/wp-includes/js/imagesloaded.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:a59c888391c869ed4f3417c02d71fe15\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1702923332;}s:36:\"68f2de3b-e2b8-4edf-b82f-93fd7834c65f\";O:8:\"stdClass\":8:{s:5:\"title\";s:5:\"Total\";s:9:\"condition\";s:5:\"Total\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:29:\"/Total/assets/js/total.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:96b0141273eabab320119c467cdcaf17\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737571;}s:36:\"6dc1cb35-6b50-4da0-9834-dddf169edaa6\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:7c37c885d7fecf788f635734f99e8610\";s:5:\"title\";s:7:\"Townhub\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:5:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:31:\"/townhub-add-ons/assets/js/(.*)\";i:3;s:36:\"/wp-includes/js/dist/vendor/react.js\";i:4;s:40:\"/wp-includes/js/dist/vendor/react-dom.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:7:\"townhub\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f484f86b-e316-4871-9322-dee3925349fe\";O:8:\"stdClass\":8:{s:5:\"title\";s:29:\"Travel Monster - Owl Carousel\";s:9:\"condition\";s:14:\"travel-monster\";s:10:\"exclusions\";a:3:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:87:\"/wp-content/plugins/wp-travel-engine/assets/lib/owl-carousel(.*)/owl.carousel(|.min).js\";i:2;s:9:\"var isRtl\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:d3e8da87b3affd399205438fbc8a4f05\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1690822771;}s:36:\"3ec96c3f-a6bf-4748-9b7e-78864bd24add\";O:8:\"stdClass\":8:{s:5:\"title\";s:21:\"uDesign - Mobile Menu\";s:9:\"condition\";s:8:\"u-design\";s:10:\"exclusions\";a:4:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:50:\"/wp-content/themes/u-design/assets/js/theme.min.js\";i:2;s:64:\"/wp-content/themes/u-design/framework/assets/js/framework.min.js\";i:3;s:70:\"/wp-content/themes/u-design/framework/assets/js/framework-async.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:31ce70b0a02f8720a86d993816676943\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1699292981;}s:36:\"cb523239-27cc-461e-973d-c984a83223ac\";O:8:\"stdClass\":8:{s:5:\"title\";s:35:\"uDesign - Show Page Content on Load\";s:9:\"condition\";s:8:\"u-design\";s:10:\"exclusions\";a:3:{i:0;s:77:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>|$)\";i:1;s:50:\"/wp-content/themes/u-design/assets/js/theme.min.js\";i:2;s:64:\"/wp-content/themes/u-design/framework/assets/js/framework.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:c55edd40ad3f9321da577dad70bb130c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1698778683;}s:36:\"14cb0a85-8bee-491e-99d7-5f20a07f4bdd\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"Uncode\";s:9:\"condition\";s:6:\"uncode\";s:10:\"exclusions\";a:11:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:33:\"/uncode/library/js/init(.min)?.js\";i:3;s:36:\"/uncode/library/js/plugins(.min)?.js\";i:4;s:32:\"/uncode/library/js/app(.min)?.js\";i:5;s:47:\"/uncode/library/js/woocommerce-uncode(.min)?.js\";i:6;s:59:\"/wp-includes/js/mediaelement/mediaelement-and-player.min.js\";i:7;s:10:\"initHeader\";i:8;s:7:\"initBox\";i:9;s:13:\"fixMenuHeight\";i:10;s:7:\"initRow\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:18ba19b98aefbb6c0fde6c6bf92e9cfc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738154;}s:36:\"a1fbf155-720a-4704-9794-d6749ad6df59\";O:8:\"stdClass\":8:{s:5:\"title\";s:27:\"Vivo theme - Fix blank page\";s:9:\"condition\";s:4:\"vivo\";s:10:\"exclusions\";a:2:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:46:\"/vivo/framework/assets/js/bt_framework_misc.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:a140e640fed504586e24e7c0df30376b\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1704308662;}s:36:\"88e96479-1aa2-4adc-8f07-20bc0368a63f\";O:8:\"stdClass\":8:{s:5:\"title\";s:9:\"Werkstatt\";s:9:\"condition\";s:9:\"werkstatt\";s:10:\"exclusions\";a:6:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:21:\"/js/underscore.min.js\";i:3;s:34:\"/werkstatt/assets/js/vendor.min.js\";i:4;s:38:\"/werkstatt/assets/js/fullscreen.min.js\";i:5;s:31:\"/werkstatt/assets/js/app.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:38faa29db5a07b8fef6aee9cc11cafec\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737639;}s:36:\"60c4110b-a960-4d44-b619-6d79514dbf75\";O:8:\"stdClass\":8:{s:5:\"title\";s:8:\"Woodmart\";s:9:\"condition\";s:8:\"woodmart\";s:10:\"exclusions\";a:9:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:35:\"/wp-includes/js/imagesloaded.min.js\";i:3;s:24:\"/woodmart/js/scripts/wc/\";i:4;s:28:\"/woodmart/js/scripts/global/\";i:5;s:37:\"/woodmart/js/libs/owl.carousel.min.js\";i:6;s:33:\"/woodmart/js/libs/owl.carousel.js\";i:7;s:26:\"/woodmart/js/libs/slick.js\";i:8;s:37:\"/woodmart/js/libs/autocomplete.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:06338f13cb89e5309ad2eb7e4d457be4\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1695633901;}s:36:\"a4547b5b-10ab-407c-969c-269fddec07b8\";O:8:\"stdClass\":8:{s:5:\"title\";s:25:\"Woodmart - Cart Fragments\";s:9:\"condition\";s:8:\"woodmart\";s:10:\"exclusions\";a:4:{i:0;s:75:\"\\/jquery(-migrate)?-?([0-9.]+)?(.min|.slim|.slim.min)?.js(\\?(.*))?( |\'|\"|>)\";i:1;s:53:\"/woocommerce/assets/js/frontend/cart-fragments.min.js\";i:2;s:49:\"/woocommerce/assets/js/js-cookie/js.cookie.min.js\";i:3;s:49:\"/woodmart/js/scripts/wc/updateCartFragmentsFix.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:591f4f1b2e86b1e987cd8789df3ffce3\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1700584689;}s:36:\"119ebd1c-6b46-4f07-8d6a-3498d9c8814f\";O:8:\"stdClass\":8:{s:5:\"title\";s:6:\"XStore\";s:9:\"condition\";s:6:\"xstore\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:11:\"/xstore/js/\";i:3;s:66:\"/et-core-plugin/packages/st-woo-swatches/public/js/frontend.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:3de9d9ba385200548f177d9c704ae92a\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679738190;}s:36:\"9a7a548c-07a1-4dff-93fc-6e8230b67853\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"theme:119d329456073aa10969d7cbd9760f28\";s:5:\"title\";s:12:\"YOOtheme Pro\";s:4:\"type\";s:5:\"theme\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:3:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:12:\"uikit.min.js\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:8:\"yootheme\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:17.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"f74c499e-b7d9-4590-8671-379f51f468c8\";O:8:\"stdClass\":8:{s:5:\"title\";s:4:\"Zeen\";s:9:\"condition\";s:4:\"zeen\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:16:\"/zeen/assets/js/\";i:3;s:17:\"/js.cookie.min.js\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:2:\"id\";s:38:\"theme:acb52844f996627788836366404a3245\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679737859;}}s:7:\"scripts\";O:8:\"stdClass\":15:{s:36:\"dd0c5a5b-ec56-49f9-9aa4-89e1e3a6a28a\";O:8:\"stdClass\":7:{s:5:\"title\";s:10:\"Amazon Ads\";s:10:\"exclusions\";a:1:{i:0;s:19:\"amazon-adsystem.com\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:b82a5936d8ea0745016caeb71629ae5d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390276;}s:36:\"980edf32-c64b-4370-bf23-c62b079e71c3\";O:8:\"stdClass\":7:{s:5:\"title\";s:14:\"Google AdSense\";s:10:\"exclusions\";a:1:{i:0;s:11:\"adsbygoogle\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:0206e6040c8ff64b8d6ee5fef2ce1c90\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681377840;}s:36:\"2499bb90-0753-4b2b-9bd4-1525f94c7437\";O:8:\"stdClass\":7:{s:5:\"title\";s:16:\"Google Analytics\";s:10:\"exclusions\";a:3:{i:0;s:33:\"google-analytics.com/analytics.js\";i:1;s:6:\"ga\\( \'\";i:2;s:5:\"ga\\(\'\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:d86cf69a8b82547a94ca3f6a307cf9a6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681388311;}s:36:\"6f460036-3106-4b8c-9951-d32de9b1258f\";O:8:\"stdClass\":7:{s:5:\"title\";s:11:\"Google Maps\";s:10:\"exclusions\";a:2:{i:0;s:19:\"maps.googleapis.com\";i:1;s:15:\"maps.google.com\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:4d60ab2c6d11d753267484006c23e54c\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390259;}s:36:\"ac2d5720-9418-468c-80a0-3874ee743c0f\";O:8:\"stdClass\":7:{s:5:\"title\";s:15:\"Google Optimize\";s:10:\"exclusions\";a:3:{i:0;s:17:\"a,s,y,n,c,h,i,d,e\";i:1;s:30:\"googleoptimize.com/optimize.js\";i:2;s:10:\"async-hide\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:031a0cece38c4739df67f910dcabf1bd\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390261;}s:36:\"122e6ebb-51fd-477f-97fb-559593f1a48b\";O:8:\"stdClass\":7:{s:5:\"title\";s:16:\"Google Recaptcha\";s:10:\"exclusions\";a:1:{i:0;s:9:\"recaptcha\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:032cb16577cbf07bc7c02bac83bd936d\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390264;}s:36:\"219277ae-b2ac-4d42-913d-eaea40985295\";O:8:\"stdClass\":7:{s:5:\"title\";s:18:\"Google Tag Manager\";s:10:\"exclusions\";a:4:{i:0;s:8:\"/gtag/js\";i:1;s:6:\"gtag\\(\";i:2;s:7:\"/gtm.js\";i:3;s:10:\"async-hide\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:1d3c65b2b03ef35e14df6b163ea3a1f6\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390266;}s:36:\"f632e3f4-20e6-471e-a78d-86afbea63586\";O:8:\"stdClass\":7:{s:5:\"title\";s:7:\"HubSpot\";s:10:\"exclusions\";a:4:{i:0;s:45:\"/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js\";i:1;s:25:\"/jquery-migrate(.min)?.js\";i:2;s:14:\"js.hsforms.net\";i:3;s:18:\"hbspt.forms.create\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:de4bd8ef4675ebb85a055955de76d0ee\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1679331623;}s:36:\"5d606add-ffb8-4a06-b295-5f722710fbfd\";O:8:\"stdClass\":7:{s:5:\"title\";s:6:\"Refari\";s:10:\"exclusions\";a:2:{i:0;s:16:\"widget.refari.co\";i:1;s:6:\"refari\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:a705e197b13b47e72a105c923e044358\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1683797056;}s:36:\"742ec14a-27a1-4789-b9c8-a9c3a3cf7042\";O:8:\"stdClass\":7:{s:5:\"title\";s:10:\"Reviews.io\";s:10:\"exclusions\";a:2:{i:0;s:35:\"/carousel-inline-iframeless/dist.js\";i:1;s:20:\"carouselInlineWidget\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:4df445c576f45889506ba175a4c39fdc\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1684389426;}s:36:\"05d3eb78-f574-49be-95e1-3f11714005d1\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"script:ce7566d1d08cc094b74cf283cf9c56a5\";s:5:\"title\";s:6:\"Stripe\";s:4:\"type\";s:6:\"script\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:1:{i:0;s:13:\"js.stripe.com\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:0:\"\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}s:36:\"b56bf06c-2f8c-4757-b536-a689fb0e75f9\";O:8:\"stdClass\":7:{s:5:\"title\";s:7:\"Typekit\";s:10:\"exclusions\";a:1:{i:0;s:7:\"typekit\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:7815e38b93e3b500a632681bd594bd61\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390268;}s:36:\"49c38c0a-43b9-4237-88cb-57ddd519f0ad\";O:8:\"stdClass\":7:{s:5:\"title\";s:13:\"Venatus Media\";s:10:\"exclusions\";a:2:{i:0;s:18:\"/ad-manager.min.js\";i:1;s:8:\"__vm_add\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:abe11528732aed9a19a97e73b242faa5\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390272;}s:36:\"2c1d0998-8ab5-478c-8eb9-9e375b46363e\";O:8:\"stdClass\":7:{s:5:\"title\";s:6:\"Wistia\";s:10:\"exclusions\";a:1:{i:0;s:15:\"fast.wistia.com\";}s:8:\"icon_url\";s:0:\"\";s:4:\"type\";s:6:\"script\";s:2:\"id\";s:39:\"script:9a0111f8c3186c1cb3113587c660c041\";s:10:\"is_default\";i:0;s:10:\"created_at\";i:1681390274;}s:36:\"0627fe24-7e9d-400f-b064-d98bec2ba85e\";O:8:\"stdClass\":10:{s:2:\"id\";s:39:\"script:dbd1875130c71eb4b2ef768ad18d820c\";s:5:\"title\";s:10:\"Yandex Ads\";s:4:\"type\";s:6:\"script\";s:4:\"icon\";s:0:\"\";s:10:\"exclusions\";a:2:{i:0;s:9:\"yandex.ru\";i:1;s:18:\"window.yaContextCb\";}s:10:\"is_default\";i:0;s:9:\"condition\";s:0:\"\";s:10:\"created_at\";i:1676435704;s:10:\"updated_at\";s:27:\"2023-02-15T04:32:16.000000Z\";s:8:\"icon_url\";s:0:\"\";}}}',	'no'),
(968757,	'xmlsf_server',	'plugin',	'yes'),
(968758,	'xmlsf_disabled_providers',	'a:1:{i:0;s:10:\"taxonomies\";}',	'yes'),
(968759,	'_transient_xmlsf_images_meta_primed',	'a:2:{s:4:\"post\";a:6:{i:0;s:4:\"2019\";i:1;s:4:\"2018\";i:2;s:4:\"2017\";i:3;s:4:\"2016\";i:4;s:4:\"2015\";i:5;s:3:\"all\";}s:4:\"page\";a:1:{i:0;s:3:\"all\";}}',	'yes'),
(968760,	'_transient_xmlsf_comments_meta_primed',	'a:0:{}',	'yes'),
(968761,	'xmlsf_news_tags',	'a:3:{s:4:\"name\";s:0:\"\";s:9:\"post_type\";a:1:{i:0;s:4:\"post\";}s:10:\"categories\";s:0:\"\";}',	'yes'),
(968762,	'rewrite_rules',	'a:112:{s:25:\"^sitemap(?:_index)?\\.xml$\";s:22:\"index.php?feed=sitemap\";s:26:\"^sitemap-root\\.xml(\\.gz)?$\";s:38:\"index.php?feed=sitemap-root$matches[1]\";s:84:\"^sitemap-posttype-([a-z0-9\\-_]+?)(?:\\.([0-9]{4,8}))?(?:\\.([0-9]{1,2}))?\\.xml(\\.gz)?$\";s:82:\"index.php?feed=sitemap-posttype-$matches[1]$matches[4]&m=$matches[2]&w=$matches[3]\";s:28:\"^sitemap-author\\.xml(\\.gz)?$\";s:40:\"index.php?feed=sitemap-author$matches[1]\";s:28:\"^sitemap-custom\\.xml(\\.gz)?$\";s:40:\"index.php?feed=sitemap-custom$matches[1]\";s:46:\"^sitemap-taxonomy-([a-z0-9\\-_]+?)\\.xml(\\.gz)?$\";s:54:\"index.php?feed=sitemap-taxonomy-$matches[1]$matches[4]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:35:\"iwp_log/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"iwp_log/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"iwp_log/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"iwp_log/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"iwp_log/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"iwp_log/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"iwp_log/([^/]+)/embed/?$\";s:40:\"index.php?iwp_log=$matches[1]&embed=true\";s:28:\"iwp_log/([^/]+)/trackback/?$\";s:34:\"index.php?iwp_log=$matches[1]&tb=1\";s:36:\"iwp_log/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?iwp_log=$matches[1]&paged=$matches[2]\";s:43:\"iwp_log/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?iwp_log=$matches[1]&cpage=$matches[2]\";s:32:\"iwp_log/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?iwp_log=$matches[1]&page=$matches[2]\";s:24:\"iwp_log/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"iwp_log/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"iwp_log/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"iwp_log/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"iwp_log/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"iwp_log/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=2472&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}',	'yes'),
(970493,	'_site_transient_timeout_browser_3704fec71244879f9466644d29705721',	'1709694347',	'no'),
(970494,	'_site_transient_browser_3704fec71244879f9466644d29705721',	'a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"123.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}',	'no'),
(970495,	'_site_transient_timeout_php_check_e9a080274371e157ce748ced527522b3',	'1709694348',	'no'),
(970496,	'_site_transient_php_check_e9a080274371e157ce748ced527522b3',	'a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}',	'no'),
(970497,	'_transient_timeout_wpr_dynamic_lists',	'1709694348',	'no'),
(970498,	'_transient_wpr_dynamic_lists',	'O:8:\"stdClass\":12:{s:28:\"rucss_inline_atts_exclusions\";a:16:{i:0;s:26:\"rocket-lazyload-inline-css\";i:1;s:35:\"divi-style-parent-inline-inline-css\";i:2;s:14:\"gsf-custom-css\";i:3;s:29:\"extra-style-inline-inline-css\";i:4;s:30:\"woodmart-inline-css-inline-css\";i:5;s:30:\"woodmart_shortcodes-custom-css\";i:6;s:29:\"rs-plugin-settings-inline-css\";i:7;s:28:\"divi-style-inline-inline-css\";i:8;s:27:\"tcb-post-list-dynamic-style\";i:9;s:6:\"n2-ss-\";i:10;s:6:\"wpcf7-\";i:11;s:32:\"siteorigin-panels-layouts-footer\";i:12;s:28:\"xstore-inline-css-inline-css\";i:13;s:17:\"assets.reviews.io\";i:14;s:8:\"ezoicCSS\";i:15;s:4:\"stk-\";}s:31:\"rucss_inline_content_exclusions\";a:45:{i:0;s:14:\".wp-container-\";i:1;s:13:\".wp-elements-\";i:2;s:16:\"#wpv-expandable-\";i:3;s:16:\".custom-content-\";i:4;s:5:\"#thb-\";i:5;s:16:\".et_pb_text_dap_\";i:6;s:24:\"#gdlr-core-shape-divider\";i:7;s:8:\"#ultib3-\";i:8;s:10:\".uvc-wrap-\";i:9;s:26:\".jet-listing-dynamic-post-\";i:10;s:6:\".vcex_\";i:11;s:20:\".wprm-advanced-list-\";i:12;s:9:\".adsslot_\";i:13;s:7:\".jnews_\";i:14;s:21:\".cp-info-bar.content-\";i:15;s:16:\"#stockie-custom-\";i:16;s:13:\"#ohio-custom-\";i:17;s:5:\".uid-\";i:18;s:15:\"#wpfMainWrapper\";i:19;s:7:\"#penci_\";i:20;s:7:\"#penci-\";i:21;s:7:\".wpbs_s\";i:22;s:8:\"#apcore_\";i:23;s:8:\"#apress_\";i:24;s:6:\"#zolo_\";i:25;s:30:\".extended-products-grid#style-\";i:26;s:27:\".preloader#style-preloader-\";i:27;s:16:\".thegem-heading-\";i:28;s:15:\".thegem-button-\";i:29;s:15:\".thegem-custom-\";i:30;s:14:\".thegem-popup-\";i:31;s:9:\"#pattern-\";i:32;s:20:\"#thegem-video-frame-\";i:33;s:8:\"#thegem-\";i:34;s:14:\".qwery_inline_\";i:35;s:19:\".dcgd_submit_button\";i:36;s:8:\".irs-bar\";i:37;s:14:\".gallery-grid-\";i:38;s:13:\".cmplz-hidden\";i:39;s:13:\"#sqbquizouter\";i:40;s:19:\"#start_sqbquizouter\";i:41;s:13:\".flo-header--\";i:42;s:19:\".trx_addons_inline_\";i:43;s:21:\".wpp-cardview-compact\";i:44;s:13:\".e-loop-item-\";}s:26:\"defer_js_inline_exclusions\";a:10:{i:0;s:16:\"DOMContentLoaded\";i:1;s:14:\"document.write\";i:2;s:22:\"window.lazyLoadOptions\";i:3;s:5:\"N.N2_\";i:4;s:18:\"rev_slider_wrapper\";i:5;s:18:\"FB3D_CLIENT_LOCALE\";i:6;s:19:\"ewww_webp_supported\";i:7;s:21:\"anr_captcha_field_div\";i:8;s:24:\"renderInvisibleReCaptcha\";i:9;s:17:\"bookingInProgress\";}s:28:\"defer_js_external_exclusions\";a:36:{i:0;s:15:\"gist.github.com\";i:1;s:22:\"content.jwplatform.com\";i:2;s:14:\"js.hsforms.net\";i:3;s:16:\"www.uplaunch.com\";i:4;s:20:\"google.com/recaptcha\";i:5;s:20:\"widget.reviews.co.uk\";i:6;s:29:\"verify.authorize.net/anetseal\";i:7;s:43:\"lib/admin/assets/lib/webfont/webfont.min.js\";i:8;s:18:\"app.mailerlite.com\";i:9;s:17:\"widget.reviews.io\";i:10;s:35:\"simplybook.(.*)/v2/widget/widget.js\";i:11;s:32:\"/wp-includes/js/dist/i18n.min.js\";i:12;s:79:\"/wp-content/plugins/wpfront-notification-bar/js/wpfront-notification-bar(.*).js\";i:13;s:64:\"/wp-content/plugins/oxygen/component-framework/vendor/aos/aos.js\";i:14;s:70:\"/wp-content/plugins/ewww-image-optimizer/includes/check-webp(.min)?.js\";i:15;s:34:\"static.mailerlite.com/data/(.*).js\";i:16;s:37:\"cdn.voxpow.com/static/libs/v1/(.*).js\";i:17;s:40:\"cdn.voxpow.com/media/trackers/js/(.*).js\";i:18;s:15:\"use.typekit.net\";i:19;s:15:\"www.idxhome.com\";i:20;s:44:\"/wp-includes/js/dist/vendor/lodash(.min)?.js\";i:21;s:40:\"/wp-includes/js/dist/api-fetch(.min)?.js\";i:22;s:35:\"/wp-includes/js/dist/i18n(.min)?.js\";i:23;s:49:\"/wp-includes/js/dist/vendor/wp-polyfill(.min)?.js\";i:24;s:34:\"/wp-includes/js/dist/url(.min)?.js\";i:25;s:36:\"/wp-includes/js/dist/hooks(.min)?.js\";i:26;s:21:\"www.paypal.com/sdk/js\";i:27;s:18:\"js-eu1.hsforms.net\";i:28;s:18:\"yanovis.Voucher.js\";i:29;s:76:\"/carousel-upsells-and-related-product-for-woocommerce/assets/js/glide.min.js\";i:30;s:15:\"use.typekit.com\";i:31;s:39:\"/artale/modules/kirki/assets/webfont.js\";i:32;s:21:\"/api/scripts/lb_cs.js\";i:33;s:27:\"js.hscta.net/cta/current.js\";i:34;s:16:\"widget.refari.co\";i:35;s:20:\"player.vdocipher.com\";}s:19:\"delay_js_exclusions\";a:69:{i:0;s:10:\"nowprocket\";i:1;s:31:\"/wp-includes/js/wp-embed.min.js\";i:2;s:15:\"lazyLoadOptions\";i:3;s:13:\"lazyLoadThumb\";i:4;s:33:\"wp-rocket/assets/js/lazyload/(.*)\";i:5;s:30:\"et_core_page_resource_fallback\";i:6;s:25:\"window.\\$us === undefined\";i:7;s:8:\"js-extra\";i:8;s:20:\"fusionNavIsCollapsed\";i:9;s:26:\"/assets/js/smush-lazy-load\";i:10;s:13:\"eio_lazy_vars\";i:11;s:34:\"\\/lazysizes(\\.min|-pre|-post)?\\.js\";i:12;s:44:\"document\\.body\\.classList\\.remove\\(\"no-js\"\\)\";i:13;s:64:\"document\\.documentElement\\.className\\.replace\\( \'no-js\', \'js\' \\)\";i:14;s:17:\"et_animation_data\";i:15;s:16:\"wpforms_settings\";i:16;s:11:\"var nfForms\";i:17;s:14:\"//stats.wp.com\";i:18;s:9:\"_stq.push\";i:19;s:29:\"fluent_form_ff_form_instance_\";i:20;s:9:\"cpLoadCSS\";i:21;s:13:\"ninja_column_\";i:22;s:16:\"var rbs_gallery_\";i:23;s:12:\"var lepopup_\";i:24;s:28:\"var billing_additional_field\";i:25;s:10:\"var gtm4wp\";i:26;s:21:\"var dataLayer_content\";i:27;s:54:\"/ewww-image-optimizer/includes/load[_-]webp(\\.min)?.js\";i:28;s:52:\"/ewww-image-optimizer/includes/check-webp(\\.min)?.js\";i:29;s:19:\"ewww_webp_supported\";i:30;s:32:\"/dist/js/browser-redirect/app.js\";i:31;s:31:\"/perfmatters/js/lazyload.min.js\";i:32;s:16:\"lazyLoadInstance\";i:33;s:27:\"scripts.mediavine.com/tags/\";i:34;s:17:\"initCubePortfolio\";i:35;s:9:\"simpli.fi\";i:36;s:17:\"gforms_recaptcha_\";i:37;s:57:\"/jetpack-boost/vendor/automattic/jetpack-lazy-images/(.*)\";i:38;s:30:\"jetpack-lazy-images-js-enabled\";i:39;s:26:\"jetpack-boost-critical-css\";i:40;s:24:\"wpformsRecaptchaCallback\";i:41;s:20:\"booking-suedtirol-js\";i:42;s:26:\"wpcp_css_disable_selection\";i:43;s:41:\"/gravityforms/js/conditional_logic.min.js\";i:44;s:34:\"statcounter.com/counter/counter.js\";i:45;s:14:\"var sc_project\";i:46;s:59:\"/jetpack/jetpack_vendor/automattic/jetpack-lazy-images/(.*)\";i:47;s:55:\"/themify-builder/themify/js/modules/fallback(\\.min)?.js\";i:48;s:16:\"handlePixMessage\";i:49;s:16:\"var corner_video\";i:50;s:26:\"cdn.pixfuture.com/hb_v2.js\";i:51;s:25:\"cdn.pixfuture.com/pbix.js\";i:52;s:43:\"served-by.pixfuture.com/www/delivery/ads.js\";i:53;s:64:\"served-by.pixfuture.com/www/delivery/headerbid_sticky_refresh.js\";i:54;s:35:\"serv-vdo.pixfuture.com/vpaid/ads.js\";i:55;s:14:\"wprRemoveCPCSS\";i:56;s:19:\"window.jdgmSettings\";i:57;s:67:\"/photonic/include/js/front-end/nomodule/photonic-baguettebox.min.js\";i:58;s:52:\"/photonic/include/ext/baguettebox/baguettebox.min.js\";i:59;s:27:\"window.wsf_form_json_config\";i:60;s:20:\"et_link_options_data\";i:61;s:19:\"FuseboxPlayerAPIKey\";i:62;s:27:\"js.hscta.net/cta/current.js\";i:63;s:14:\"hbspt.cta.load\";i:64;s:27:\"consent.cookiebot.com/uc.js\";i:65;s:53:\"/woofilter-pro/woofilterpro/js/ion.rangeSlider.min.js\";i:66;s:21:\"barra.r7.com/barra.js\";i:67;s:26:\"rocket_css_lazyload_launch\";i:68;s:16:\"#wpr-lazyload-bg\";}s:18:\"js_minify_external\";a:123:{i:0;s:8:\"html5.js\";i:1;s:11:\"show_ads.js\";i:2;s:14:\"histats.com/js\";i:3;s:21:\"ws.amazon.com/widgets\";i:4;s:5:\"/ads/\";i:5;s:17:\"intensedebate.com\";i:6;s:20:\"scripts.chitika.net/\";i:7;s:12:\"jotform.com/\";i:8;s:15:\"gist.github.com\";i:9;s:16:\"forms.aweber.com\";i:10;s:21:\"video.unrulymedia.com\";i:11;s:12:\"stats.wp.com\";i:12;s:19:\"stats.wordpress.com\";i:13;s:23:\"widget.rafflecopter.com\";i:14;s:29:\"widget-prime.rafflecopter.com\";i:15;s:23:\"releases.flowplayer.org\";i:16;s:13:\"c.ad6media.fr\";i:17;s:19:\"cdn.stickyadstv.com\";i:18;s:12:\"www.smava.de\";i:19;s:20:\"contextual.media.net\";i:20;s:19:\"app.getresponse.com\";i:21;s:24:\"adserver.reklamstore.com\";i:22;s:9:\"s0.wp.com\";i:23;s:16:\"wprp.zemanta.com\";i:24;s:21:\"files.bannersnack.com\";i:25;s:22:\"smarticon.geotrust.com\";i:26;s:11:\"js.gleam.io\";i:27;s:25:\"ir-na.amazon-adsystem.com\";i:28;s:19:\"web.ventunotech.com\";i:29;s:20:\"verify.authorize.net\";i:30;s:21:\"ads.themoneytizer.com\";i:31;s:20:\"embed.finanzcheck.de\";i:32;s:20:\"imagesrv.adition.com\";i:33;s:15:\"js.juicyads.com\";i:34;s:18:\"form.jotformeu.com\";i:35;s:15:\"speakerdeck.com\";i:36;s:22:\"content.jwplatform.com\";i:37;s:24:\"ads.investingchannel.com\";i:38;s:13:\"app.ecwid.com\";i:39;s:20:\"www.industriejobs.de\";i:40;s:14:\"s.gravatar.com\";i:41;s:21:\"googlesyndication.com\";i:42;s:13:\"a.optmstr.com\";i:43;s:14:\"a.optmnstr.com\";i:44;s:13:\"a.opmnstr.com\";i:45;s:12:\"adthrive.com\";i:46;s:13:\"mediavine.com\";i:47;s:14:\"js.hsforms.net\";i:48;s:20:\"googleadservices.com\";i:49;s:16:\"f.convertkit.com\";i:50;s:16:\"recaptcha/api.js\";i:51;s:12:\"mailmunch.co\";i:52;s:20:\"apps.shareaholic.com\";i:53;s:28:\"dsms0mj1bbhn4.cloudfront.net\";i:54;s:12:\"nutrifox.com\";i:55;s:13:\"code.tidio.co\";i:56;s:16:\"www.uplaunch.com\";i:57;s:24:\"widget.reviewability.com\";i:58;s:36:\"embed-cdn.gettyimages.com/widgets.js\";i:59;s:18:\"app.mailerlite.com\";i:60;s:7:\"ck.page\";i:61;s:28:\"cdn.jsdelivr.net/gh/AmauriC/\";i:62;s:39:\"static.klaviyo.com/onsite/js/klaviyo.js\";i:63;s:32:\"a.omappapi.com/app/js/api.min.js\";i:64;s:19:\"static.zdassets.com\";i:65;s:58:\"feedbackcompany.com/widgets/feedback-company-widget.min.js\";i:66;s:17:\"widget.gleamjs.io\";i:67;s:14:\"phonewagon.com\";i:68;s:35:\"simplybook.asia/v2/widget/widget.js\";i:69;s:33:\"simplybook.it/v2/widget/widget.js\";i:70;s:33:\"simplybook.me/v2/widget/widget.js\";i:71;s:48:\"static.botsrv.com/website/js/widget2.36cf1446.js\";i:72;s:27:\"static.mailerlite.com/data/\";i:73;s:14:\"cdn.voxpow.com\";i:74;s:16:\"loader.knack.com\";i:75;s:46:\"embed.lpcontent.net/leadboxes/current/embed.js\";i:76;s:52:\"cc.cdn.civiccomputing.com/9/cookieControl-9.x.min.js\";i:77;s:21:\"cse.google.com/cse.js\";i:78;s:19:\"kit.fontawesome.com\";i:79;s:51:\"cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js\";i:80;s:46:\"static.leadpages.net/leadbars/current/embed.js\";i:81;s:27:\"booqable.com/v2/booqable.js\";i:82;s:18:\"googleoptimize.com\";i:83;s:52:\"cdna.hubpeople.com/js/widget_standalone_two_modes.js\";i:84;s:18:\"s3.tradingview.com\";i:85;s:26:\"www.vbt.io/ext/vbtforms.js\";i:86;s:16:\"cdn.callrail.com\";i:87;s:40:\"documentcloud.adobe.com/view-sdk/main.js\";i:88;s:21:\"static.cleverpush.com\";i:89;s:15:\"js.afterpay.com\";i:90;s:33:\"cdn.enable.co.il/licenses/enable-\";i:91;s:21:\"hcaptcha.com/1/api.js\";i:92;s:46:\"voucher.getavo.it/public/js/yanovis.Voucher.js\";i:93;s:18:\"js-eu1.hsforms.net\";i:94;s:34:\"statcounter.com/counter/counter.js\";i:95;s:11:\"snapppt.com\";i:96;s:15:\"use.typekit.com\";i:97;s:35:\"secure.gravatar.com/js/gprofiles.js\";i:98;s:32:\"cdn.jsdelivr.net/npm/hockeystack\";i:99;s:22:\"widget.prod.faslet.net\";i:100;s:31:\"ga.getresponse.com/script/ga.js\";i:101;s:16:\"cognitoforms.com\";i:102;s:15:\"usercentrics.eu\";i:103;s:16:\"cdn.amcharts.com\";i:104;s:5:\"umami\";i:105;s:20:\"cdn.popt.in/pixel.js\";i:106;s:9:\"m2d.m2.ai\";i:107;s:11:\"pubguru.net\";i:108;s:13:\"trustindex.io\";i:109;s:37:\"cdnjs.cloudflare.com/ajax/libs/prism/\";i:110;s:25:\"podigee-podcast-player.js\";i:111;s:24:\"tarteaucitron.io/load.js\";i:112;s:29:\"osm.klarnaservices.com/lib.js\";i:113;s:25:\"mein.clickskeks.at/app.js\";i:114;s:21:\"barra.r7.com/barra.js\";i:115;s:16:\"widget.refari.co\";i:116;s:20:\"widget.reviews.co.uk\";i:117;s:20:\"player.vdocipher.com\";i:118;s:26:\"www.instagram.com/embed.js\";i:119;s:13:\"smartframe.io\";i:120;s:36:\"challenges.cloudflare.com/turnstile/\";i:121;s:20:\"script.roboassist.ai\";i:122;s:16:\"cdn.hu-manity.co\";}s:21:\"js_move_after_combine\";a:106:{i:0;s:15:\"map_fusion_map_\";i:1;s:13:\"ec:addProduct\";i:2;s:16:\"ec:addImpression\";i:3;s:30:\"clear_better_facebook_comments\";i:4;s:29:\"vc-row-destroy-equal-heights-\";i:5;s:14:\"dfd-icon-list-\";i:6;s:12:\"SFM_template\";i:7;s:14:\"WLTChangeState\";i:8;s:9:\"wlt_star_\";i:9;s:17:\"wlt_pop_distance_\";i:10;s:14:\"smart_list_tip\";i:11;s:12:\"gd-wgt-pagi-\";i:12;s:11:\"data-rf-id=\";i:13;s:7:\"tvc_po=\";i:14;s:10:\"scrapeazon\";i:15;s:10:\"startclock\";i:16;s:22:\"it_logo_field_owl-box_\";i:17;s:15:\"td_live_css_uid\";i:18;s:17:\"wpvl_paramReplace\";i:19;s:11:\"tdAjaxCount\";i:20;s:9:\"mec_skin_\";i:21;s:4:\"_wca\";i:22;s:8:\"_taboola\";i:23;s:17:\"fbq(\'trackCustom\'\";i:24;s:11:\"fbq(\'track\'\";i:25;s:10:\"data.token\";i:26;s:7:\"sharrre\";i:27;s:19:\"dfads_ajax_load_ads\";i:28;s:13:\"tie_postviews\";i:29;s:10:\"wmp_update\";i:30;s:18:\"h5ab-print-article\";i:31;s:17:\"gform_ajax_frame_\";i:32;s:17:\"gform_post_render\";i:33;s:14:\"mts_view_count\";i:34;s:15:\"act_css_tooltip\";i:35;s:10:\"window.SLB\";i:36;s:14:\"wpt_view_count\";i:37;s:11:\"var dateNow\";i:38;s:16:\"gallery_product_\";i:39;s:21:\".flo-block-slideshow-\";i:40;s:17:\"data=\'api-key=ct-\";i:41;s:20:\"ip_common_function()\";i:42;s:31:\"(\"style#gsf-custom-css\").append\";i:43;s:22:\"a3revWCDynamicGallery_\";i:44;s:24:\"#owl-carousel-instagram-\";i:45;s:19:\"window.FlowFlowOpts\";i:46;s:16:\"jQuery(\'.td_uid_\";i:47;s:16:\"jQuery(\".slider-\";i:48;s:18:\"#dfd-vcard-widget-\";i:49;s:21:\"#sf-instagram-widget-\";i:50;s:18:\".woocommerce-tabs-\";i:51;s:16:\"penci_megamenu__\";i:52;s:18:\"vc_prepareHoverBox\";i:53;s:16:\"wp-temp-form-div\";i:54;s:25:\"_wswebinarsystem_already_\";i:55;s:23:\"#views-extra-css\").text\";i:56;s:20:\"fusetag.setTargeting\";i:57;s:20:\"hit.uptrendsdata.com\";i:58;s:27:\"callback:window.renderBadge\";i:59;s:29:\"test_run_nf_conditional_logic\";i:60;s:9:\"cb_nombre\";i:61;s:12:\"$(\'.fl-node-\";i:62;s:24:\"function($){google_maps_\";i:63;s:14:\"$(\"#myCarousel\";i:64;s:18:\"et_animation_data=\";i:65;s:13:\"current_url=\"\";i:66;s:44:\"CustomEvent.prototype=window.Event.prototype\";i:67;s:26:\"electro-wc-product-gallery\";i:68;s:14:\"woof_is_mobile\";i:69;s:20:\"jQuery(\'.videonextup\";i:70;s:10:\"wpp_params\";i:71;s:24:\"us.templateDirectoryUri=\";i:72;s:17:\".fat-gallery-item\";i:73;s:10:\".ratingbox\";i:74;s:33:\"user_rating.prototype.eraseCookie\";i:75;s:23:\"test_run_nf_conditional\";i:76;s:26:\"dpsp-networks-btns-wrapper\";i:77;s:19:\"pa_woo_product_info\";i:78;s:35:\"sharing_enabled_on_post_via_metabox\";i:79;s:22:\"#product-search-field-\";i:80;s:19:\"GOTMLS_login_offset\";i:81;s:40:\"berocket_aapf_time_to_fix_products_style\";i:82;s:27:\"window.vc_googleMapsPointer\";i:83;s:8:\"sinceID_\";i:84;s:31:\"#ut-background-video-ut-section\";i:85;s:26:\"+window.comment_tab_width+\";i:86;s:19:\"dfd-button-hover-in\";i:87;s:21:\"wpseo-address-wrapper\";i:88;s:24:\"platform.stumbleupon.com\";i:89;s:27:\"#woo_pp_ec_button_mini_cart\";i:90;s:14:\"#supercarousel\";i:91;s:10:\"blockClass\";i:92;s:11:\"tdbMenuItem\";i:93;s:13:\"tdbSearchItem\";i:94;s:17:\"best_seller_badge\";i:95;s:24:\"jQuery(\'#product-top-bar\";i:96;s:8:\"fb_desc-\";i:97;s:21:\"FC_regenerate_captcha\";i:98;s:34:\"wp_post_blocks_vars.listed_posts=[\";i:99;s:12:\"captcha-hash\";i:100;s:9:\"mapdata={\";i:101;s:11:\".ywpc-char-\";i:102;s:17:\").countdowntimer(\";i:103;s:16:\"jQuery(\"#td_uid_\";i:104;s:14:\"find(\'#td_uid_\";i:105;s:22:\"variation_estimate_msg\";}s:18:\"js_excluded_inline\";a:313:{i:0;s:14:\"document.write\";i:1;s:9:\"google_ad\";i:2;s:9:\"edToolbar\";i:3;s:4:\"gtag\";i:4;s:9:\"_gaq.push\";i:5;s:5:\"_gaLt\";i:6;s:21:\"GoogleAnalyticsObject\";i:7;s:17:\"syntaxhighlighter\";i:8;s:11:\"adsbygoogle\";i:9;s:7:\"ci_cap_\";i:10;s:4:\"_stq\";i:11;s:5:\"nonce\";i:12;s:7:\"post_id\";i:13;s:8:\"LogHuman\";i:14;s:15:\"idcomments_acct\";i:15;s:9:\"ch_client\";i:16;s:11:\"sc_online_t\";i:17;s:4:\"_stq\";i:18;s:17:\"bannersnack_embed\";i:19;s:15:\"vtn_player_type\";i:20;s:13:\"ven_video_key\";i:21;s:15:\"ANS_customer_id\";i:22;s:7:\"tdBlock\";i:23;s:12:\"tdLocalCache\";i:24;s:11:\"wpRestNonce\";i:25;s:6:\"\"url\":\";i:26;s:15:\"lazyLoadOptions\";i:27;s:8:\"adthrive\";i:28;s:7:\"loadCSS\";i:29;s:17:\"google_tag_params\";i:30;s:13:\"clicky_custom\";i:31;s:15:\"clicky_site_ids\";i:32;s:14:\"NSLPopupCenter\";i:33;s:4:\"_paq\";i:34;s:3:\"gtm\";i:35;s:9:\"dataLayer\";i:36;s:13:\"RecaptchaLoad\";i:37;s:20:\"WPCOM_sharing_counts\";i:38;s:22:\"jetpack_remote_comment\";i:39;s:15:\"subscribe-field\";i:40;s:9:\"contextly\";i:41;s:7:\"_mmunch\";i:42;s:14:\"gt_request_uri\";i:43;s:12:\"doGTranslate\";i:44;s:8:\"docTitle\";i:45;s:17:\"bs_ajax_paginate_\";i:46;s:20:\"bs_deferred_loading_\";i:47;s:22:\"theChampRedirectionUrl\";i:48;s:20:\"theChampFBCommentUrl\";i:49;s:23:\"theChampTwitterRedirect\";i:50;s:25:\"theChampRegRedirectionUrl\";i:51;s:14:\"ESSB_CACHE_URL\";i:52;s:30:\"oneall_social_login_providers_\";i:53;s:22:\"betterads_screen_width\";i:54;s:40:\"woocommerce_wishlist_add_to_wishlist_url\";i:55;s:21:\"arf_conditional_logic\";i:56;s:27:\"heateorSsHorSharingShortUrl\";i:57;s:8:\"TL_Const\";i:58;s:23:\"bimber_front_microshare\";i:59;s:17:\"setAttribute(\"id\"\";i:60;s:18:\"setAttribute( \"id\"\";i:61;s:14:\"TribeEventsPro\";i:62;s:14:\"peepsotimedata\";i:63;s:9:\"wphc_data\";i:64;s:10:\"hc_rand_id\";i:65;s:7:\"RBL_ADD\";i:66;s:18:\"AfsAnalyticsObject\";i:67;s:18:\"_thriveCurrentPost\";i:68;s:13:\"esc_login_url\";i:69;s:18:\"fwduvpMainPlaylist\";i:70;s:26:\"Bibblio.initRelatedContent\";i:71;s:9:\"showUFC()\";i:72;s:8:\"#iphorm-\";i:73;s:7:\"#fancy-\";i:74;s:13:\"ult-carousel-\";i:75;s:17:\"theChampLJAuthUrl\";i:76;s:6:\"f._fbq\";i:77;s:10:\"Insticator\";i:78;s:15:\"w2dc_js_objects\";i:79;s:11:\"cherry_ajax\";i:80;s:9:\"ad_block_\";i:81;s:23:\"elementorFrontendConfig\";i:82;s:5:\"zeen_\";i:83;s:16:\"disqusIdentifier\";i:84;s:14:\"currentAjaxUrl\";i:85;s:27:\"geodir_event_call_calendar_\";i:86;s:8:\"atatags-\";i:87;s:18:\"hbspt.forms.create\";i:88;s:19:\"function(c,h,i,m,p)\";i:89;s:11:\"dataTable({\";i:90;s:12:\"rankMath = {\";i:91;s:10:\"_atrk_opts\";i:92;s:16:\"quicklinkOptions\";i:93;s:11:\"ct_checkjs_\";i:94;s:18:\"WP_Statistics_http\";i:95;s:12:\"penci_block_\";i:96;s:15:\"omapi_localized\";i:97;s:10:\"omapi_data\";i:98;s:15:\"OptinMonsterApp\";i:99;s:9:\"tminusnow\";i:100;s:7:\"nfForms\";i:101;s:18:\"galleries.gallery_\";i:102;s:14:\"wcj_evt.prodID\";i:103;s:19:\"advads_tracking_ads\";i:104;s:28:\"advadsGATracking.postContext\";i:105;s:14:\"woopack_config\";i:106;s:14:\"ulp_content_id\";i:107;s:26:\"wp-cumulus/tagcloud.swf?r=\";i:108;s:24:\"ctSetCookie(\'ct_checkjs\'\";i:109;s:20:\"woof_really_curr_tax\";i:110;s:17:\"uLogin.customInit\";i:111;s:32:\"i18n_no_matching_variations_text\";i:112;s:22:\"alsp_map_markers_attrs\";i:113;s:13:\"var inc_opt =\";i:114;s:13:\"iworks_upprev\";i:115;s:19:\"yith_wcevti_tickets\";i:116;s:27:\"window.metrilo.ensure_cbuid\";i:117;s:13:\"metrilo.event\";i:118;s:19:\"wordpress_page_root\";i:119;s:9:\"wcct_info\";i:120;s:20:\"Springbot.product_id\";i:121;s:17:\"pysWooProductData\";i:122;s:11:\"dfd-heading\";i:123;s:8:\"owl=$(\"#\";i:124;s:14:\"penci_megamenu\";i:125;s:12:\"fts_security\";i:126;s:19:\"algoliaAutocomplete\";i:127;s:22:\"avia_framework_globals\";i:128;s:23:\"tabs.easyResponsiveTabs\";i:129;s:20:\"searchlocationHeader\";i:130;s:16:\"yithautocomplete\";i:131;s:19:\"data-parallax-speed\";i:132;s:14:\"currency_data=\";i:133;s:11:\"cedexisData\";i:134;s:23:\"function reenableButton\";i:135;s:12:\"#wpnbio-show\";i:136;s:29:\"e.Newsletter2GoTrackingObject\";i:137;s:15:\"var categories_\";i:138;s:14:\"\"+nRemaining+\"\";i:139;s:20:\"cartsguru_cart_token\";i:140;s:21:\"after_share_easyoptin\";i:141;s:18:\"location_data.push\";i:142;s:30:\"thirstyFunctions.isThirstyLink\";i:143;s:23:\"styles: \' #custom-menu-\";i:144;s:20:\"function svc_center_\";i:145;s:25:\"#svc_carousel2_container_\";i:146;s:11:\"advads.move\";i:147;s:9:\"elementid\";i:148;s:14:\"advads_has_ads\";i:149;s:14:\"wpseo_map_init\";i:150;s:20:\"mdf_current_page_url\";i:151;s:12:\"tptn_tracker\";i:152;s:20:\"dpsp_pin_button_data\";i:153;s:27:\"searchwp_live_search_params\";i:154;s:10:\"wpp_params\";i:155;s:21:\"top.location,thispage\";i:156;s:18:\"selection+pagelink\";i:157;s:20:\"ic_window_resolution\";i:158;s:11:\"PHP.wp_p_id\";i:159;s:29:\"ShopifyBuy.UI.onReady(client)\";i:160;s:16:\"orig_request_uri\";i:161;s:16:\"gie.widgets.load\";i:162;s:11:\"Adman.Flash\";i:163;s:11:\"PHP.wp_p_id\";i:164;s:26:\"window.broadstreetKeywords\";i:165;s:15:\"var productId =\";i:166;s:16:\"var flatsomeVars\";i:167;s:21:\"wc_product_block_data\";i:168;s:21:\"static.mailerlite.com\";i:169;s:10:\"amzn_assoc\";i:170;s:22:\"_bs_getParameterByName\";i:171;s:9:\"_stq.push\";i:172;s:9:\"h._remove\";i:173;s:16:\"var FlowFlowOpts\";i:174;s:14:\"var WCPFData =\";i:175;s:14:\"var _beeketing\";i:176;s:16:\"var _statcounter\";i:177;s:13:\"var actions =\";i:178;s:15:\"var current_url\";i:179;s:15:\"var object_name\";i:180;s:19:\"var the_ajax_script\";i:181;s:28:\"var wc_cart_fragments_params\";i:182;s:22:\"var woocommerce_params\";i:183;s:16:\"var wpml_cookies\";i:184;s:21:\"wc_add_to_cart_params\";i:185;s:26:\"window.broadstreetKeywords\";i:186;s:35:\"window.wc_ga_pro.available_gateways\";i:187;s:12:\"xa.prototype\";i:188;s:21:\"HOUZEZ_ajaxcalls_vars\";i:189;s:17:\"w2dc_maps_objects\";i:190;s:26:\"w2dc_controller_args_array\";i:191;s:22:\"w2dc_map_markers_attrs\";i:192;s:9:\"YT.Player\";i:193;s:9:\"WPFC.data\";i:194;s:23:\"function current_video_\";i:195;s:12:\"var videodiv\";i:196;s:22:\"var slider_wppasrotate\";i:197;s:8:\"wppas_ga\";i:198;s:14:\"var blockClass\";i:199;s:13:\"tarteaucitron\";i:200;s:21:\"pw_brand_product_list\";i:201;s:15:\"tminusCountDown\";i:202;s:23:\"pysWooSelectContentData\";i:203;s:13:\"wpvq_ans89733\";i:204;s:12:\"_isp_version\";i:205;s:16:\"price_range_data\";i:206;s:29:\"window.FeedbackCompanyWidgets\";i:207;s:22:\"woocs_current_currency\";i:208;s:30:\"woo_variation_swatches_options\";i:209;s:31:\"woocommerce_price_slider_params\";i:210;s:12:\"scriptParams\";i:211;s:19:\"form-adv-pagination\";i:212;s:23:\"borlabsCookiePrioritize\";i:213;s:21:\"urls_wpwidgetpolylang\";i:214;s:14:\"quickViewNonce\";i:215;s:22:\"frontendscripts_params\";i:216;s:21:\"nj-facebook-messenger\";i:217;s:20:\"var fb_mess_position\";i:218;s:36:\"init_particles_row_background_script\";i:219;s:15:\"setREVStartSize\";i:220;s:7:\"fl-node\";i:221;s:11:\"PPAccordion\";i:222;s:10:\"soliloquy_\";i:223;s:25:\"wprevpublicjs_script_vars\";i:224;s:19:\"DTGS_NONCE_FRONTEND\";i:225;s:17:\"et_animation_data\";i:226;s:17:\"archives-dropdown\";i:227;s:15:\"loftloaderCache\";i:228;s:17:\"SmartSliderSimple\";i:229;s:14:\"var nectarLove\";i:230;s:10:\"var incOpt\";i:231;s:33:\"RocketBrowserCompatibilityChecker\";i:232;s:24:\"RocketPreloadLinksConfig\";i:233;s:18:\"placementVersionId\";i:234;s:11:\"var useEdit\";i:235;s:23:\"var DTGS_NONCE_FRONTEND\";i:236;s:8:\"n2jQuery\";i:237;s:26:\"et_core_api_spam_recaptcha\";i:238;s:6:\"cnArgs\";i:239;s:14:\"__CF$cv$params\";i:240;s:17:\"trustbox_settings\";i:241;s:5:\"aepro\";i:242;s:10:\"cdn.jst.ai\";i:243;s:25:\"w2dc_fields_in_categories\";i:244;s:21:\"jetMenuPublicSettings\";i:245;s:17:\"JetTricksSettings\";i:246;s:10:\"aepc_pixel\";i:247;s:20:\"avadaWooCommerceVars\";i:248;s:7:\"var isb\";i:249;s:9:\"fcaPcPost\";i:250;s:10:\"csrf_token\";i:251;s:24:\"icwp_wpsf_vars_lpantibot\";i:252;s:11:\"wpvViewHead\";i:253;s:16:\"ed_school_plugin\";i:254;s:9:\"aps_comp_\";i:255;s:11:\"guaven_woos\";i:256;s:16:\"__lm_redirect_to\";i:257;s:17:\"__wpdm_view_count\";i:258;s:23:\"bookacti.booking_system\";i:259;s:10:\"nfFrontEnd\";i:260;s:20:\"view_quote_cart_link\";i:261;s:19:\"__eae_decode_emails\";i:262;s:20:\"divioverlays_ajaxurl\";i:263;s:10:\"var _EPYT_\";i:264;s:13:\"#ins-heading-\";i:265;s:12:\"#ins-button-\";i:266;s:20:\"tve_frontend_options\";i:267;s:8:\"lb24.src\";i:268;s:24:\"amazon_Login_accessToken\";i:269;s:21:\"porto_infinite_scroll\";i:270;s:14:\".adace-loader-\";i:271;s:11:\"adace_load_\";i:272;s:41:\"tagGroupsAccordiontaggroupscloudaccordion\";i:273;s:31:\"tagGroupsTabstaggroupscloudtabs\";i:274;s:16:\"jrRelatedWidgets\";i:275;s:14:\"UNCODE.initRow\";i:276;s:28:\"amp_mobile_redirect_disabled\";i:277;s:11:\"wpgdprcData\";i:278;s:28:\"wpml_browser_redirect_params\";i:279;s:13:\"swPreRegister\";i:280;s:15:\"kboard_settings\";i:281;s:23:\"ct_ultimate_gdpr_cookie\";i:282;s:23:\"wcpv_registration_local\";i:283;s:15:\"www.idxhome.com\";i:284;s:24:\"arf_footer_cl_logic_call\";i:285;s:23:\"reload_attached_coupons\";i:286;s:8:\"var ftpp\";i:287;s:15:\"forminatorFront\";i:288;s:6:\"_EPYT_\";i:289;s:23:\"edd_free_downloads_vars\";i:290;s:15:\"edd_stripe_vars\";i:291;s:7:\"var ASP\";i:292;s:18:\"ecwidOriginalTitle\";i:293;s:17:\"defaultCategoryId\";i:294;s:25:\"translation-revision-date\";i:295;s:20:\"google_conversion_id\";i:296;s:5:\"hbspt\";i:297;s:21:\"var marker_locations_\";i:298;s:13:\"var AdmMyAjax\";i:299;s:13:\"ifso_page_url\";i:300;s:21:\"referrer_for_pageload\";i:301;s:38:\"WoocommerceWidget/woocommerceWidget.js\";i:302;s:19:\"var ht_ctc_chat_var\";i:303;s:6:\"spuvar\";i:304;s:16:\"var wpilFrontend\";i:305;s:24:\"urls_polylangREPLACETOID\";i:306;s:34:\"e.setAttribute(\'unselectable\',on);\";i:307;s:16:\"try{Typekit.load\";i:308;s:9:\"iMapsData\";i:309;s:24:\"var wpforms_user_journey\";i:310;s:24:\"rocket_lazyload_css_data\";i:311;s:24:\"wcStoreApiNonceTimestamp\";i:312;s:21:\"createNonceMiddleware\";}s:24:\"cache_ignored_parameters\";a:69:{i:0;s:10:\"utm_source\";i:1;s:10:\"utm_medium\";i:2;s:12:\"utm_campaign\";i:3;s:9:\"utm_expid\";i:4;s:8:\"utm_term\";i:5;s:11:\"utm_content\";i:6;s:6:\"utm_id\";i:7;s:19:\"utm_source_platform\";i:8;s:19:\"utm_creative_format\";i:9;s:20:\"utm_marketing_tactic\";i:10;s:10:\"mtm_source\";i:11;s:10:\"mtm_medium\";i:12;s:12:\"mtm_campaign\";i:13;s:11:\"mtm_keyword\";i:14;s:7:\"mtm_cid\";i:15;s:11:\"mtm_content\";i:16;s:9:\"pk_source\";i:17;s:9:\"pk_medium\";i:18;s:11:\"pk_campaign\";i:19;s:10:\"pk_keyword\";i:20;s:6:\"pk_cid\";i:21;s:10:\"pk_content\";i:22;s:13:\"fb_action_ids\";i:23;s:15:\"fb_action_types\";i:24;s:9:\"fb_source\";i:25;s:6:\"fbclid\";i:26;s:10:\"campaignid\";i:27;s:9:\"adgroupid\";i:28;s:4:\"adid\";i:29;s:5:\"gclid\";i:30;s:12:\"age-verified\";i:31;s:12:\"ao_noptimize\";i:32;s:4:\"usqp\";i:33;s:11:\"cn-reloaded\";i:34;s:3:\"_ga\";i:35;s:5:\"sscid\";i:36;s:6:\"gclsrc\";i:37;s:3:\"_gl\";i:38;s:6:\"mc_cid\";i:39;s:6:\"mc_eid\";i:40;s:8:\"_bta_tid\";i:41;s:6:\"_bta_c\";i:42;s:11:\"trk_contact\";i:43;s:7:\"trk_msg\";i:44;s:10:\"trk_module\";i:45;s:7:\"trk_sid\";i:46;s:5:\"gdfms\";i:47;s:6:\"gdftrk\";i:48;s:5:\"gdffi\";i:49;s:3:\"_ke\";i:50;s:3:\"_kx\";i:51;s:21:\"redirect_log_mongo_id\";i:52;s:17:\"redirect_mongo_id\";i:53;s:15:\"sb_referer_host\";i:54;s:5:\"mkwid\";i:55;s:5:\"pcrid\";i:56;s:5:\"ef_id\";i:57;s:7:\"s_kwcid\";i:58;s:7:\"msclkid\";i:59;s:4:\"dm_i\";i:60;s:4:\"epik\";i:61;s:2:\"pp\";i:62;s:6:\"gbraid\";i:63;s:6:\"wbraid\";i:64;s:8:\"ssp_iabi\";i:65;s:8:\"ssp_iaba\";i:66;s:3:\"gad\";i:67;s:6:\"vgo_ee\";i:68;s:10:\"gad_source\";}s:18:\"preload_exclusions\";a:4:{i:0;s:9:\"void\\(.*;\";i:1;s:17:\"(.*)__trashed(.*)\";i:2;s:14:\"/jet-menu/(.*)\";i:3;s:15:\"/jet-popup/(.*)\";}s:16:\"exclude_js_files\";a:8:{i:0;s:32:\"/wp-includes/js/dist/i18n.min.js\";i:1;s:76:\"/interactive-3d-flipbook-powered-physics-engine/assets/js/html2canvas.min.js\";i:2;s:68:\"/interactive-3d-flipbook-powered-physics-engine/assets/js/pdf.min.js\";i:3;s:70:\"/interactive-3d-flipbook-powered-physics-engine/assets/js/three.min.js\";i:4;s:77:\"/interactive-3d-flipbook-powered-physics-engine/assets/js/3d-flip-book.min.js\";i:5;s:39:\"/google-site-kit/dist/assets/js/(.*).js\";i:6;s:45:\"/wp-live-chat-support/public/js/callus(.*).js\";i:7;s:41:\"/borlabs-cookie/assets/javascript/(.*).js\";}s:15:\"staging_domains\";a:28:{i:0;s:13:\".wpengine.com\";i:1;s:20:\".wpenginepowered.com\";i:2;s:16:\".pantheonsite.io\";i:3;s:18:\".flywheelsites.com\";i:4;s:20:\".flywheelstaging.com\";i:5;s:11:\".kinsta.com\";i:6;s:13:\".kinsta.cloud\";i:7;s:18:\".cloudwaysapps.com\";i:8;s:18:\".azurewebsites.net\";i:9;s:14:\".wpserveur.net\";i:10;s:19:\"-liquidwebsites.com\";i:11;s:16:\".myftpupload.com\";i:12;s:12:\".dream.press\";i:13;s:12:\".sg-host.com\";i:14;s:16:\".platformsh.site\";i:15;s:12:\".wpstage.net\";i:16;s:22:\".bigscoots-staging.com\";i:17;s:10:\".wpsc.site\";i:18;s:14:\".runcloud.link\";i:19;s:14:\".onrocket.site\";i:20;s:18:\".singlestaging.com\";i:21;s:13:\".myraidbox.de\";i:22;s:12:\".instawp.xyz\";i:23;s:11:\".instawp.co\";i:24;s:13:\".instawp.link\";i:25;s:12:\".instawp.app\";i:26;s:12:\".hstgr.cloud\";i:27;s:15:\".myhostpoint.ch\";}}',	'no'),
(970499,	'_transient_timeout_wpr_dynamic_lists_incompatible_plugins',	'1709694348',	'no'),
(970500,	'_transient_wpr_dynamic_lists_incompatible_plugins',	'O:8:\"stdClass\":6:{s:0:\"\";a:35:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:14:\"wp-super-cache\";s:4:\"file\";s:27:\"wp-super-cache/wp-cache.php\";}i:1;O:8:\"stdClass\":2:{s:4:\"slug\";s:23:\"enable-gzip-compression\";s:4:\"file\";s:51:\"enable-gzip-compression/enable-gzip-compression.php\";}i:2;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"quick-cache\";s:4:\"file\";s:27:\"quick-cache/quick-cache.php\";}i:3;O:8:\"stdClass\":2:{s:4:\"slug\";s:31:\"leverage-browser-caching-ninjas\";s:4:\"file\";s:66:\"leverage-browser-caching-ninjas/leverage-browser-caching-ninja.php\";}i:4;O:8:\"stdClass\":2:{s:4:\"slug\";s:28:\"wp-performance-score-booster\";s:4:\"file\";s:61:\"wp-performance-score-booster/wp-performance-score-booster.php\";}i:5;O:8:\"stdClass\":2:{s:4:\"slug\";s:15:\"litespeed-cache\";s:4:\"file\";s:35:\"litespeed-cache/litespeed-cache.php\";}i:6;O:8:\"stdClass\":2:{s:4:\"slug\";s:42:\"remove-query-strings-from-static-resources\";s:4:\"file\";s:67:\"remove-query-strings-from-static-resources/remove-query-strings.php\";}i:7;O:8:\"stdClass\":2:{s:4:\"slug\";s:19:\"wp-http-compression\";s:4:\"file\";s:43:\"wp-http-compression/wp-http-compression.php\";}i:8;O:8:\"stdClass\":2:{s:4:\"slug\";s:21:\"query-strings-remover\";s:4:\"file\";s:47:\"query-strings-remover/query-strings-remover.php\";}i:9;O:8:\"stdClass\":2:{s:4:\"slug\";s:13:\"page-optimize\";s:4:\"file\";s:31:\"page-optimize/page-optimize.php\";}i:10;O:8:\"stdClass\":2:{s:4:\"slug\";s:18:\"speed-booster-pack\";s:4:\"file\";s:41:\"speed-booster-pack/speed-booster-pack.php\";}i:11;O:8:\"stdClass\":2:{s:4:\"slug\";s:17:\"swift-performance\";s:4:\"file\";s:33:\"swift-performance/performance.php\";}i:12;O:8:\"stdClass\":2:{s:4:\"slug\";s:28:\"gzip-ninja-speed-compression\";s:4:\"file\";s:49:\"gzip-ninja-speed-compression/gzip-ninja-speed.php\";}i:13;O:8:\"stdClass\":2:{s:4:\"slug\";s:18:\"super-static-cache\";s:4:\"file\";s:41:\"super-static-cache/super-static-cache.php\";}i:14;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"lite-cache\";s:4:\"file\";s:21:\"lite-cache/plugin.php\";}i:15;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"hyper-cache\";s:4:\"file\";s:22:\"hyper-cache/plugin.php\";}i:16;O:8:\"stdClass\":2:{s:4:\"slug\";s:7:\"wp-ffpc\";s:4:\"file\";s:19:\"wp-ffpc/wp-ffpc.php\";}i:17;O:8:\"stdClass\":2:{s:4:\"slug\";s:13:\"wp-fast-cache\";s:4:\"file\";s:31:\"wp-fast-cache/wp-fast-cache.php\";}i:18;O:8:\"stdClass\":2:{s:4:\"slug\";s:19:\"psn-pagespeed-ninja\";s:4:\"file\";s:38:\"psn-pagespeed-ninja/pagespeedninja.php\";}i:19;O:8:\"stdClass\":2:{s:4:\"slug\";s:22:\"swift-performance-lite\";s:4:\"file\";s:38:\"swift-performance-lite/performance.php\";}i:20;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"force-gzip\";s:4:\"file\";s:25:\"force-gzip/force-gzip.php\";}i:21;O:8:\"stdClass\":2:{s:4:\"slug\";s:19:\"add-expires-headers\";s:4:\"file\";s:43:\"add-expires-headers/add-expires-headers.php\";}i:22;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"hyper-cache-extended\";s:4:\"file\";s:31:\"hyper-cache-extended/plugin.php\";}i:23;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"gator-cache\";s:4:\"file\";s:27:\"gator-cache/gator-cache.php\";}i:24;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"flexicache\";s:4:\"file\";s:24:\"flexicache/wp-plugin.php\";}i:25;O:8:\"stdClass\":2:{s:4:\"slug\";s:16:\"wp-fastest-cache\";s:4:\"file\";s:35:\"wp-fastest-cache/wpFastestCache.php\";}i:26;O:8:\"stdClass\":2:{s:4:\"slug\";s:26:\"wordpress-gzip-compression\";s:4:\"file\";s:35:\"wordpress-gzip-compression/ezgz.php\";}i:27;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"wp-optimize\";s:4:\"file\";s:27:\"wp-optimize/wp-optimize.php\";}i:28;O:8:\"stdClass\":2:{s:4:\"slug\";s:33:\"check-and-enable-gzip-compression\";s:4:\"file\";s:54:\"check-and-enable-gzip-compression/richards-toolbox.php\";}i:29;O:8:\"stdClass\":2:{s:4:\"slug\";s:24:\"far-future-expiry-header\";s:4:\"file\";s:50:\"far-future-expiry-header/far-future-expiration.php\";}i:30;O:8:\"stdClass\":2:{s:4:\"slug\";s:24:\"leverage-browser-caching\";s:4:\"file\";s:53:\"leverage-browser-caching/leverage-browser-caching.php\";}i:31;O:8:\"stdClass\":2:{s:4:\"slug\";s:12:\"wpcompressor\";s:4:\"file\";s:29:\"wpcompressor/wpcompressor.php\";}i:32;O:8:\"stdClass\":2:{s:4:\"slug\";s:11:\"combine-css\";s:4:\"file\";s:27:\"combine-css/combine-css.php\";}i:33;O:8:\"stdClass\":2:{s:4:\"slug\";s:14:\"w3-total-cache\";s:4:\"file\";s:33:\"w3-total-cache/w3-total-cache.php\";}i:34;O:8:\"stdClass\":2:{s:4:\"slug\";s:13:\"cache-enabler\";s:4:\"file\";s:31:\"cache-enabler/cache-enabler.php\";}}s:21:\"minify_css||minify_js\";a:9:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"merge-minify-refresh\";s:4:\"file\";s:45:\"merge-minify-refresh/merge-minify-refresh.php\";}i:1;O:8:\"stdClass\":2:{s:4:\"slug\";s:16:\"async-js-and-css\";s:4:\"file\";s:34:\"async-js-and-css/asyncJSandCSS.php\";}i:2;O:8:\"stdClass\":2:{s:4:\"slug\";s:15:\"wp-super-minify\";s:4:\"file\";s:35:\"wp-super-minify/wp-super-minify.php\";}i:3;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"fast-velocity-minify\";s:4:\"file\";s:28:\"fast-velocity-minify/fvm.php\";}i:4;O:8:\"stdClass\":2:{s:4:\"slug\";s:23:\"dependency-minification\";s:4:\"file\";s:51:\"dependency-minification/dependency-minification.php\";}i:5;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"bwp-minify\";s:4:\"file\";s:25:\"bwp-minify/bwp-minify.php\";}i:6;O:8:\"stdClass\":2:{s:4:\"slug\";s:8:\"minqueue\";s:4:\"file\";s:19:\"minqueue/plugin.php\";}i:7;O:8:\"stdClass\":2:{s:4:\"slug\";s:12:\"scripts-gzip\";s:4:\"file\";s:29:\"scripts-gzip/scripts_gzip.php\";}i:8;O:8:\"stdClass\":2:{s:4:\"slug\";s:9:\"wp-minify\";s:4:\"file\";s:23:\"wp-minify/wp-minify.php\";}}s:8:\"lazyload\";a:6:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:9:\"lazy-load\";s:4:\"file\";s:23:\"lazy-load/lazy-load.php\";}i:1;O:8:\"stdClass\":2:{s:4:\"slug\";s:12:\"bj-lazy-load\";s:4:\"file\";s:29:\"bj-lazy-load/bj-lazy-load.php\";}i:2;O:8:\"stdClass\":2:{s:4:\"slug\";s:25:\"jquery-image-lazy-loading\";s:4:\"file\";s:46:\"jquery-image-lazy-loading/jq_img_lazy_load.php\";}i:3;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"crazy-lazy\";s:4:\"file\";s:25:\"crazy-lazy/crazy-lazy.php\";}i:4;O:8:\"stdClass\":2:{s:4:\"slug\";s:24:\"specify-image-dimensions\";s:4:\"file\";s:53:\"specify-image-dimensions/specify-image-dimensions.php\";}i:5;O:8:\"stdClass\":2:{s:4:\"slug\";s:18:\"advanced-lazy-load\";s:4:\"file\";s:40:\"advanced-lazy-load/advanced_lazyload.php\";}}s:9:\"minify_js\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:5:\"wp-js\";s:4:\"file\";s:15:\"wp-js/wp-js.php\";}i:1;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"scripts-to-footerphp\";s:4:\"file\";s:42:\"scripts-to-footerphp/scripts-to-footer.php\";}i:2;O:8:\"stdClass\":2:{s:4:\"slug\";s:10:\"combine-js\";s:4:\"file\";s:25:\"combine-js/combine-js.php\";}i:3;O:8:\"stdClass\":2:{s:4:\"slug\";s:17:\"footer-javascript\";s:4:\"file\";s:39:\"footer-javascript/footer-javascript.php\";}}s:17:\"control_heartbeat\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:17:\"heartbeat-control\";s:4:\"file\";s:39:\"heartbeat-control/heartbeat-control.php\";}}s:16:\"lazyload_iframes\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"slug\";s:20:\"lazy-load-for-videos\";s:4:\"file\";s:37:\"lazy-load-for-videos/codeispoetry.php\";}}}',	'no'),
(971197,	'_site_transient_timeout_browser_efc7ceb394754a3a8dc8c9981f3ae22b',	'1709738031',	'no'),
(971198,	'_site_transient_browser_efc7ceb394754a3a8dc8c9981f3ae22b',	'a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"121.0.0.0\";s:8:\"platform\";s:0:\"\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}',	'no'),
(971397,	'ai1wm_backups_labels',	'a:0:{}',	'yes'),
(971401,	'action_scheduler_migration_status',	'complete',	'yes'),
(973131,	'_site_transient_timeout_wp_rocket_update_data',	'1709321719',	'no'),
(973132,	'_site_transient_wp_rocket_update_data',	'O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:20:\"rocket_update_failed\";a:1:{i:0;s:245:\"An unexpected error occurred. Something may be wrong with WP-Rocket.me or this server&#8217;s configuration. If you continue to have problems, <a href=\"https://wp-rocket.me/support/?utm_source=wp_plugin&utm_medium=wp_rocket\">contact support</a>.\";}}s:10:\"error_data\";a:1:{s:20:\"rocket_update_failed\";a:2:{s:9:\"http_code\";i:202;s:8:\"response\";s:111:\"{\"success\":false,\"data\":{\"reason\":\"NO_UPDATE\",\"consumer_key\":\"ca4a4638\",\"consumer_email\":\"cms@nextclient.com\"}}\";}}s:18:\"\0*\0additional_data\";a:0:{}}',	'no'),
(973134,	'_site_transient_update_themes',	'O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1709324278;s:7:\"checked\";a:2:{s:29:\"pawlowski-mastrilli-law-group\";s:5:\"100.0\";s:12:\"universal_mm\";s:5:\"1.2.6\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}',	'no'),
(973135,	'_site_transient_update_core',	'O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.4.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.4.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.4.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.4.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.4.3\";s:7:\"version\";s:5:\"6.4.3\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1709324278;s:15:\"version_checked\";s:5:\"6.4.3\";s:12:\"translations\";a:0:{}}',	'no'),
(973305,	'_transient_timeout_wp_rocket_pricing',	'1709335507',	'no'),
(973306,	'_transient_wp_rocket_pricing',	'O:8:\"stdClass\":3:{s:8:\"licenses\";O:8:\"stdClass\":3:{s:6:\"single\";O:8:\"stdClass\":2:{s:6:\"prices\";O:8:\"stdClass\":3:{s:7:\"regular\";i:59;s:4:\"sale\";d:47.2000000000000028421709430404007434844970703125;s:7:\"renewal\";O:8:\"stdClass\":4:{s:14:\"is_grandfather\";d:47.2000000000000028421709430404007434844970703125;s:14:\"is_grandmother\";i:59;s:15:\"not_grandfather\";i:59;s:10:\"is_expired\";i:59;}}s:8:\"websites\";i:1;}s:4:\"plus\";O:8:\"stdClass\":2:{s:6:\"prices\";O:8:\"stdClass\":4:{s:7:\"regular\";i:119;s:4:\"sale\";d:95.2000000000000028421709430404007434844970703125;s:11:\"from_single\";O:8:\"stdClass\":2:{s:7:\"regular\";i:60;s:4:\"sale\";i:48;}s:7:\"renewal\";O:8:\"stdClass\":4:{s:14:\"is_grandfather\";d:95.2000000000000028421709430404007434844970703125;s:14:\"is_grandmother\";i:119;s:15:\"not_grandfather\";i:119;s:10:\"is_expired\";i:119;}}s:8:\"websites\";i:3;}s:8:\"infinite\";O:8:\"stdClass\":2:{s:6:\"prices\";O:8:\"stdClass\":5:{s:7:\"regular\";i:299;s:4:\"sale\";d:239.19999999999998863131622783839702606201171875;s:11:\"from_single\";O:8:\"stdClass\":2:{s:7:\"regular\";i:240;s:4:\"sale\";i:192;}s:9:\"from_plus\";O:8:\"stdClass\":2:{s:7:\"regular\";i:180;s:4:\"sale\";i:144;}s:7:\"renewal\";O:8:\"stdClass\":4:{s:14:\"is_grandfather\";d:239.19999999999998863131622783839702606201171875;s:14:\"is_grandmother\";i:299;s:15:\"not_grandfather\";i:299;s:10:\"is_expired\";i:299;}}s:8:\"websites\";s:9:\"unlimited\";}}s:8:\"renewals\";O:8:\"stdClass\":4:{s:10:\"extra_days\";i:15;s:16:\"grandfather_date\";i:1640995200;s:16:\"grandmother_date\";i:315532800;s:16:\"discount_percent\";O:8:\"stdClass\":3:{s:14:\"is_grandfather\";i:20;s:15:\"not_grandfather\";i:0;s:10:\"is_expired\";i:0;}}s:5:\"promo\";O:8:\"stdClass\":4:{s:4:\"name\";s:6:\"Spring\";s:16:\"discount_percent\";i:20;s:10:\"start_date\";i:1709769600;s:8:\"end_date\";i:1710547199;}}',	'no'),
(973385,	'_transient_timeout_wp_rocket_customer_data',	'1709388293',	'no'),
(973386,	'_transient_wp_rocket_customer_data',	'O:8:\"stdClass\":17:{s:2:\"ID\";s:6:\"115789\";s:10:\"first_name\";s:8:\"Lawrence\";s:5:\"email\";s:18:\"cms@nextclient.com\";s:15:\"licence_account\";s:2:\"-1\";s:15:\"licence_version\";s:6:\"3.15.9\";s:18:\"licence_expiration\";s:10:\"1733606150\";s:12:\"consumer_key\";s:8:\"ca4a4638\";s:14:\"is_blacklisted\";s:0:\"\";s:12:\"is_staggered\";s:1:\"0\";s:12:\"date_created\";s:10:\"1575324561\";s:6:\"status\";s:6:\"active\";s:10:\"is_blocked\";s:1:\"0\";s:14:\"has_auto_renew\";s:1:\"1\";s:19:\"has_one-com_account\";s:1:\"0\";s:11:\"renewal_url\";s:88:\"https://wp-rocket.me/checkout/renew/cms@nextclient.com/eb0a4b2dac7e828107296798c07dc112/\";s:16:\"upgrade_plus_url\";s:71:\"https://wp-rocket.me/checkout/upgrade/cms@nextclient.com/ca4a4638/plus/\";s:20:\"upgrade_infinite_url\";s:76:\"https://wp-rocket.me/checkout/upgrade/cms@nextclient.com /ca4a4638/infinite/\";}',	'no'),
(973513,	'_transient_timeout_wflginfl_00000000000000000000ffffcff6f074',	'1709315164',	'no'),
(973514,	'_transient_wflginfl_00000000000000000000ffffcff6f074',	'1',	'no'),
(973562,	'_transient_timeout_wflginfl_00000000000000000000ffffcff6f077',	'1709320653',	'no'),
(973563,	'_transient_wflginfl_00000000000000000000ffffcff6f077',	'1',	'no'),
(973580,	'_transient_timeout_wflginfl_00000000000000000000ffffcff6f076',	'1709322061',	'no'),
(973581,	'_transient_wflginfl_00000000000000000000ffffcff6f076',	'1',	'no'),
(973590,	'_transient_timeout_wflginfl_00000000000000000000ffffcff6f078',	'1709322764',	'no'),
(973591,	'_transient_wflginfl_00000000000000000000ffffcff6f078',	'1',	'no'),
(973595,	'_site_transient_timeout_theme_roots',	'1709326078',	'no'),
(973596,	'_site_transient_theme_roots',	'a:2:{s:29:\"pawlowski-mastrilli-law-group\";s:7:\"/themes\";s:12:\"universal_mm\";s:7:\"/themes\";}',	'no'),
(973598,	'_transient_timeout_wflginfl_00000000000000000000ffffcff6f07d',	'1709323475',	'no'),
(973599,	'_transient_wflginfl_00000000000000000000ffffcff6f07d',	'1',	'no'),
(973607,	'_transient_doing_cron',	'1709326584.8133931159973144531250',	'yes'),
(973608,	'_site_transient_timeout_community-events-902a357145c9c03388ab03fc8fce9939',	'1709367454',	'no'),
(973609,	'_site_transient_community-events-902a357145c9c03388ab03fc8fce9939',	'a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:10:\"76.168.8.0\";}s:6:\"events\";a:5:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:19:\"OC WordPress Meetup\";s:3:\"url\";s:58:\"https://www.meetup.com/oc-wordpress-group/events/298778501\";s:6:\"meetup\";s:18:\"OC WordPress Group\";s:10:\"meetup_url\";s:42:\"https://www.meetup.com/OC-Wordpress-Group/\";s:4:\"date\";s:19:\"2024-03-04 19:00:00\";s:8:\"end_date\";s:19:\"2024-03-04 21:00:00\";s:20:\"start_unix_timestamp\";i:1709607600;s:18:\"end_unix_timestamp\";i:1709614800;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:33.68;s:9:\"longitude\";d:-118.01;}}i:1;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:37:\"#IEWP Monthly Meetup (General Meetup)\";s:3:\"url\";s:54:\"https://www.meetup.com/inlandempirewp/events/298069890\";s:6:\"meetup\";s:36:\"Inland Empire WordPress Meetup Group\";s:10:\"meetup_url\";s:38:\"https://www.meetup.com/inlandempirewp/\";s:4:\"date\";s:19:\"2024-03-05 19:00:00\";s:8:\"end_date\";s:19:\"2024-03-05 21:00:00\";s:20:\"start_unix_timestamp\";i:1709694000;s:18:\"end_unix_timestamp\";i:1709701200;s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Riverside, CA, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:33.981945;s:9:\"longitude\";d:-117.3694;}}i:2;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:41:\"VIRTUAL WordPress Developer Night - #IEWP\";s:3:\"url\";s:54:\"https://www.meetup.com/inlandempirewp/events/292287739\";s:6:\"meetup\";s:36:\"Inland Empire WordPress Meetup Group\";s:10:\"meetup_url\";s:38:\"https://www.meetup.com/inlandempirewp/\";s:4:\"date\";s:19:\"2024-03-12 19:00:00\";s:8:\"end_date\";s:19:\"2024-03-12 21:00:00\";s:20:\"start_unix_timestamp\";i:1710295200;s:18:\"end_unix_timestamp\";i:1710302400;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:33.99;s:9:\"longitude\";d:-117.37;}}i:3;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:23:\"IEWP WordPress Helpdesk\";s:3:\"url\";s:54:\"https://www.meetup.com/inlandempirewp/events/292287736\";s:6:\"meetup\";s:36:\"Inland Empire WordPress Meetup Group\";s:10:\"meetup_url\";s:38:\"https://www.meetup.com/inlandempirewp/\";s:4:\"date\";s:19:\"2024-03-14 19:00:00\";s:8:\"end_date\";s:19:\"2024-03-14 21:00:00\";s:20:\"start_unix_timestamp\";i:1710468000;s:18:\"end_unix_timestamp\";i:1710475200;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:33.99;s:9:\"longitude\";d:-117.37;}}i:4;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:27:\"Let\'s talk about WordPress!\";s:3:\"url\";s:72:\"https://www.meetup.com/antelope-valley-wordpress-meetup/events/299522730\";s:6:\"meetup\";s:32:\"Antelope Valley WordPress Meetup\";s:10:\"meetup_url\";s:56:\"https://www.meetup.com/Antelope-Valley-WordPress-Meetup/\";s:4:\"date\";s:19:\"2024-03-20 19:00:00\";s:8:\"end_date\";s:19:\"2024-03-20 21:00:00\";s:20:\"start_unix_timestamp\";i:1710986400;s:18:\"end_unix_timestamp\";i:1710993600;s:8:\"location\";a:4:{s:8:\"location\";s:17:\"Palmdale, CA, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:34.598724;s:9:\"longitude\";d:-118.148056;}}}}',	'no'),
(973610,	'_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3',	'1709367454',	'no'),
(973611,	'_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3',	'1709367454',	'no'),
(973612,	'_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3',	'1709324254',	'no'),
(973613,	'_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9',	'1709367454',	'no'),
(973614,	'_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9',	'1709367454',	'no'),
(973615,	'_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9',	'1709324254',	'no'),
(973616,	'_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b',	'1709367454',	'no'),
(973617,	'_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b',	'<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2024/02/wordpress-6-5-beta-3/\'>WordPress 6.5 Beta 3</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2024/02/wordpress-6-5-beta-2/\'>WordPress 6.5 Beta 2</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/acquisition-alert-kestrel-acquires-seven-barn2-plugins\'>WPTavern: Acquisition Alert: Kestrel Acquires Seven Barn2 Plugins</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/the-block-bindings-api-brings-dynamic-data-to-blocks\'>WPTavern: The Block Bindings API Brings Dynamic Data to Blocks</a></li><li><a class=\'rsswidget\' href=\'https://dothewoo.io/all-things-cloudfest-2024-hackathon-with-christian-carole-and-alain/\'>Do The Woo Community: All Things CloudFest 2024 Hackathon with Christian, Carole and Alain</a></li></ul></div>',	'no'),
(973618,	'_site_transient_update_plugins',	'O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1709324278;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:53:\"addfunc-head-footer-code/addfunc-head-footer-code.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/addfunc-head-footer-code\";s:4:\"slug\";s:24:\"addfunc-head-footer-code\";s:6:\"plugin\";s:53:\"addfunc-head-footer-code/addfunc-head-footer-code.php\";s:11:\"new_version\";s:3:\"2.3\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/addfunc-head-footer-code/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/addfunc-head-footer-code.2.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:69:\"https://ps.w.org/addfunc-head-footer-code/assets/icon.svg?rev=1245441\";s:3:\"svg\";s:69:\"https://ps.w.org/addfunc-head-footer-code/assets/icon.svg?rev=1245441\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/addfunc-head-footer-code/assets/banner-1544x500.jpg?rev=1947786\";s:2:\"1x\";s:79:\"https://ps.w.org/addfunc-head-footer-code/assets/banner-772x250.jpg?rev=1036015\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.0.1\";}s:45:\"classic-editor-addon/classic-editor-addon.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/classic-editor-addon\";s:4:\"slug\";s:20:\"classic-editor-addon\";s:6:\"plugin\";s:45:\"classic-editor-addon/classic-editor-addon.php\";s:11:\"new_version\";s:5:\"4.3.0\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/classic-editor-addon/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/classic-editor-addon.4.3.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/classic-editor-addon/assets/icon-256x256.png?rev=2099466\";s:2:\"1x\";s:73:\"https://ps.w.org/classic-editor-addon/assets/icon-256x256.png?rev=2099466\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/classic-editor-addon/assets/banner-1544x500.jpg?rev=2099482\";s:2:\"1x\";s:75:\"https://ps.w.org/classic-editor-addon/assets/banner-772x250.jpg?rev=2099482\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:33:\"disable-emojis/disable-emojis.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/disable-emojis\";s:4:\"slug\";s:14:\"disable-emojis\";s:6:\"plugin\";s:33:\"disable-emojis/disable-emojis.php\";s:11:\"new_version\";s:5:\"1.7.6\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/disable-emojis/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/disable-emojis.1.7.6.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:65:\"https://s.w.org/plugins/geopattern-icon/disable-emojis_d3c7d6.svg\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/disable-emojis/assets/banner-1544x500.png?rev=1145188\";s:2:\"1x\";s:69:\"https://ps.w.org/disable-emojis/assets/banner-772x250.png?rev=1145188\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.8\";}s:45:\"disable-lazy-loading/disable-lazy-loading.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/disable-lazy-loading\";s:4:\"slug\";s:20:\"disable-lazy-loading\";s:6:\"plugin\";s:45:\"disable-lazy-loading/disable-lazy-loading.php\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/disable-lazy-loading/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/disable-lazy-loading.2.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/disable-lazy-loading/assets/icon-256x256.jpg?rev=2381380\";s:2:\"1x\";s:73:\"https://ps.w.org/disable-lazy-loading/assets/icon-128x128.jpg?rev=2381380\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.4\";}s:45:\"simple-page-ordering/simple-page-ordering.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:34:\"w.org/plugins/simple-page-ordering\";s:4:\"slug\";s:20:\"simple-page-ordering\";s:6:\"plugin\";s:45:\"simple-page-ordering/simple-page-ordering.php\";s:11:\"new_version\";s:5:\"2.6.3\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/simple-page-ordering/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/simple-page-ordering.2.6.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/simple-page-ordering/assets/icon-256x256.png?rev=2716033\";s:2:\"1x\";s:73:\"https://ps.w.org/simple-page-ordering/assets/icon-128x128.png?rev=2716033\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/simple-page-ordering/assets/banner-1544x500.png?rev=2716033\";s:2:\"1x\";s:75:\"https://ps.w.org/simple-page-ordering/assets/banner-772x250.png?rev=2716033\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.7\";}s:32:\"xml-sitemap-feed/xml-sitemap.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/xml-sitemap-feed\";s:4:\"slug\";s:16:\"xml-sitemap-feed\";s:6:\"plugin\";s:32:\"xml-sitemap-feed/xml-sitemap.php\";s:11:\"new_version\";s:5:\"5.4.5\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/xml-sitemap-feed/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/xml-sitemap-feed.5.4.5.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/xml-sitemap-feed/assets/icon-128x128.png?rev=1112143\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/xml-sitemap-feed/assets/banner-772x250.jpg?rev=1112143\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.4\";}}}',	'no'),
(973619,	'_site_transient_timeout_available_translations',	'1709336459',	'no'),
(973620,	'_site_transient_available_translations',	'a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.7\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.7/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-10-19 09:22:30\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.3/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.25/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-07 20:18:03\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-20 15:12:22\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-29 07:52:31\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-22 18:28:51\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-01 14:45:04\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-11 13:58:40\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-31 19:08:22\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-11-08 18:40:24\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-11-08 18:40:48\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.4.3/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-31 19:08:42\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.4.3/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-01 07:57:24\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.4/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-28 18:27:43\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-30 17:36:08\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-08-28 15:58:51\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-11-25 14:09:36\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-23 01:49:45\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-10-22 02:53:03\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-29 21:55:55\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-12 14:01:59\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-31 03:32:51\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.9/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.9/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.15/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-17 18:41:12\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.20\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.20/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-18 19:36:30\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-11-08 20:42:04\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-10-05 10:16:58\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-12 17:31:37\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-15 06:10:53\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-23 12:35:28\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-11-09 09:46:35\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-11-29 13:35:45\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-29 08:00:23\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.4/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-13 00:00:51\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-03-01 06:52:39\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.32\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.32/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-05-28 22:06:16\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-25 08:05:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-03 21:54:15\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.4/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-22 12:40:26\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-01 12:30:59\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.25/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-09 18:36:30\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-03 13:53:06\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.25/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-23 06:35:46\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.4/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.25\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.25/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.20\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.20/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.1.5\";s:7:\"updated\";s:19:\"2022-10-20 17:15:28\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.1.5/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-10-19 07:05:28\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-09 09:24:08\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.3/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-30 17:48:58\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.3/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-15 12:14:45\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-19 07:50:47\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.7\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.7/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-23 19:36:11\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-28 08:03:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-19 14:16:42\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.14\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.14/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.37\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.37/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-18 07:19:21\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-24 13:40:33\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-07 11:59:14\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-31 10:24:06\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-10-14 13:34:08\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.4.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.24/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-13 19:59:52\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.33\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.33/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-03 14:03:53\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-07 10:24:39\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.4.3/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2023-08-21 12:17:05\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-07 10:22:34\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-26 15:24:03\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-27 21:49:30\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.15/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-27 05:57:05\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.4.2\";s:7:\"updated\";s:19:\"2023-11-12 10:29:16\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-14 12:47:33\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-28 19:14:34\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-05 20:51:57\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-16 00:27:26\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-16 11:09:57\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.37\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.37/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.9\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.9/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.24\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.24/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-06 00:04:30\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-02-03 03:47:06\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-14 12:08:20\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.3/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.15\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.15/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2023-07-15 15:30:50\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.4/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-30 22:23:09\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.4.3\";s:7:\"updated\";s:19:\"2024-01-31 01:18:24\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.3/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.4\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.4/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}',	'no');

DROP TABLE IF EXISTS `tea_postmeta`;
CREATE TABLE `tea_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tea_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(34,	30,	'_edit_last',	'1'),
(35,	30,	'_title',	'Firm Overview | Pawlowski Mastrilli Law Group'),
(36,	30,	'_description',	'The Pawlowski//Mastrilli Law Group was founded here in Tampa in 1995 by exceptionally experienced attorneys.'),
(37,	30,	'_keywords',	''),
(38,	30,	'_subslideID',	'1'),
(46,	35,	'_edit_last',	'1'),
(47,	35,	'_title',	'Vincent R. Pawlowski, ESQ. | Pawlowski Mastrilli Law Group'),
(48,	35,	'_description',	'Vincent R. Pawlowski, ESQ. is an exceptional client advocate with more than 20 years experience in the areas of personal injury and wrongful death.'),
(49,	35,	'_keywords',	''),
(50,	35,	'_subslideID',	''),
(54,	39,	'_edit_last',	'1'),
(55,	39,	'_title',	'Kenneth W. Mastrilli, ESQ. | Pawlowski Mastrilli Law Group'),
(56,	39,	'_description',	'Kenneth W. Mastrilli, ESQ. has devoted 28 years of his legal career as an advocate for the injured in all types of personal injury and workmen\'s compensation claims.'),
(57,	39,	'_keywords',	''),
(58,	46,	'_edit_last',	'3'),
(59,	46,	'_title',	'Personal Injury'),
(60,	46,	'_description',	'Our skilled and knowledgeable personal injury lawyers utilize a wide range of resources and fight to ensure the best possible outcome for your case.'),
(61,	46,	'_keywords',	'Tampa Personal Injury Lawyer'),
(62,	46,	'_subslideID',	'4'),
(63,	48,	'_edit_last',	'3'),
(64,	48,	'_title',	'Tampa Car Accident Lawyer'),
(65,	48,	'_description',	'The Tampa car accident lawyers at The Pawlowski//Mastrilli Law Group are skilled and experienced lawyers who can provide protection and will fight for your rights.'),
(66,	48,	'_keywords',	'Tampa Car Accident Lawyer'),
(67,	48,	'_subslideID',	'6'),
(68,	50,	'_edit_last',	'1'),
(69,	50,	'_title',	'Tampa Uninsured Motorist Lawyer'),
(70,	50,	'_description',	'The experienced Tampa uninsured accident lawyers at The Pawlowski//Mastrilli Law Group can assist you in your quest to get a settlement or damages that are fair.'),
(71,	50,	'_keywords',	'Tampa Uninsured Motorist Lawyer'),
(72,	50,	'aFhfc_head_code',	''),
(73,	50,	'aFhfc_footer_code',	''),
(74,	52,	'_edit_last',	'1'),
(75,	52,	'_title',	'Tampa DUI Accident Lawyer'),
(76,	52,	'_description',	'Our Tampa DUI accident lawyers help Florida drunk driving auto accident victims recover compensation for their injuries.'),
(77,	52,	'_keywords',	'Tampa DUI Accident Lawyer'),
(80,	54,	'_edit_last',	'1'),
(81,	54,	'_title',	'Tampa Hit & Run Accident Lawyer'),
(82,	54,	'_description',	'Tampa hit & run accident lawyers at The Pawlowski//Mastrilli Law Group help victims of Florida hit & run car accidents recover for their injuries.'),
(83,	54,	'_keywords',	'Tampa Hit & Run Accident Lawyer'),
(86,	56,	'_edit_last',	'1'),
(87,	56,	'_title',	'Tampa Truck Accident Lawyer'),
(88,	56,	'_description',	'There are roughly 500,000 truck accidents each year. contact our experienced Tampa truck accident lawyers today.'),
(89,	56,	'_keywords',	'Tampa Truck Accident Lawyer'),
(90,	56,	'aFhfc_head_code',	''),
(91,	56,	'aFhfc_footer_code',	''),
(92,	58,	'_edit_last',	'1'),
(93,	58,	'_title',	'Tampa Truck Safety Regulations Lawyer'),
(94,	58,	'_description',	'Tampa truck accident lawyers at The Pawlowski//Mastrilli Law Group discuss role of FMCSA trucking regulatios in truck accident cases.'),
(95,	58,	'_keywords',	'Florida Trucking Safety Regulations Lawyer'),
(98,	60,	'_edit_last',	'1'),
(99,	60,	'_title',	'Tampa Motorcycle Accident Lawyer'),
(100,	60,	'_description',	'The risk of being involved in an accident on the road is compounded if you are on a motorcycle, contact our Tampa motorcycle accident lawyers today.'),
(101,	60,	'_keywords',	'Tampa Motorcycle Accident Lawyer'),
(102,	60,	'aFhfc_head_code',	''),
(103,	60,	'aFhfc_footer_code',	''),
(104,	62,	'_edit_last',	'1'),
(105,	62,	'_title',	'Tampa Defective Product Lawyer'),
(106,	62,	'_description',	'When you invest in a product, you inherently trust it will work as intended, when something goes wrong contact our Tampa defective product lawyers..'),
(107,	62,	'_keywords',	'Tampa Defective Products Lawyer'),
(108,	62,	'aFhfc_head_code',	''),
(109,	62,	'aFhfc_footer_code',	''),
(110,	64,	'_edit_last',	'1'),
(111,	64,	'_title',	'Tampa Pharmaceutical & Medication Injury Lawyer'),
(112,	64,	'_description',	'If you experience medication error or injury contact our Tampa pharmaceutical & medication injury lawyers.'),
(113,	64,	'_keywords',	'Tampa Pharmaceutical & Medication Injury Lawyer'),
(114,	64,	'aFhfc_head_code',	''),
(115,	64,	'aFhfc_footer_code',	''),
(116,	66,	'_edit_last',	'1'),
(117,	66,	'_title',	'Tampa Medical Malpractice Lawyer'),
(118,	66,	'_description',	'Our Tampa medical malpractice lawyers help victims of Florida medical malpractice recover for surgical errors & medical mistakes.'),
(119,	66,	'_keywords',	'Tampa Medical Malpractice Lawyer'),
(122,	68,	'_edit_last',	'1'),
(123,	68,	'_title',	'Tampa Workplace Accident Lawyer'),
(124,	68,	'_description',	'Our Tampa workplace accident injury lawyers help workplace accident victims recover Florida workers\' compensation & other damages.'),
(125,	68,	'_keywords',	'Tampa Workplace Accident Lawyer'),
(128,	2472,	'_edit_last',	'1'),
(129,	2472,	'_title',	'Pawlowski//Mastrilli Law Group'),
(130,	2472,	'_description',	'Our Tampa lawyers can help whether you have been injured in a car, truck or motorcycle accident, work accident, or other unfortunate reason.'),
(131,	2472,	'_keywords',	'Tampa Injury & Accident Lawyer'),
(132,	2473,	'_description',	'Please give us a call or contact us via email using our contact form.'),
(133,	2473,	'_edit_last',	'1'),
(134,	2473,	'_title',	'Contact Us | Pawlowski Mastrilli Law Group'),
(135,	2473,	'_keywords',	''),
(136,	2473,	'_subslideID',	''),
(137,	2474,	'_title',	'Disclaimer | Pawlowski Mastrilli Law Group'),
(138,	2475,	'_title',	'Thank You | Pawlowski Mastrilli Law Group'),
(139,	2476,	'_title',	'Site Map | Pawlowski Mastrilli Law Group'),
(140,	70,	'_edit_last',	'1'),
(141,	70,	'_title',	'Tampa Premises Liability Lawyer'),
(142,	70,	'_description',	'Our Tampa premises liability lawyers help Florida premises liability victims recover compensation for slip & fall & dog bites.'),
(143,	70,	'_keywords',	'Tampa Premises Liability Lawyer'),
(146,	72,	'_edit_last',	'1'),
(147,	72,	'_title',	'Tampa Nursing Home Abuse Lawyer'),
(148,	72,	'_description',	'Our Tampa nursing home abuse lawyers know that families expect their loved ones will be cared for by professional and qualified caretakers.'),
(149,	72,	'_keywords',	'Tampa Nursing Home Neglect Lawyer'),
(150,	72,	'aFhfc_head_code',	''),
(151,	72,	'aFhfc_footer_code',	''),
(152,	74,	'_edit_last',	'1'),
(153,	74,	'_title',	'Tampa Airplane Accident Lawyer'),
(154,	74,	'_description',	'While the NTSB investigates all commercial and private aviation accidents, it is our Tampa airplane accident lawyers who will fight to protect your rights.'),
(155,	74,	'_keywords',	'Tampa Airplane Accident Lawyer'),
(156,	74,	'aFhfc_head_code',	''),
(157,	74,	'aFhfc_footer_code',	''),
(158,	76,	'_edit_last',	'1'),
(159,	76,	'_title',	'Tampa Insurance Bad Faith Lawyer'),
(160,	76,	'_description',	'Our Tampa insurance bad faith lawyers have years of experience successfully holding those guilty of Bad Faith accountable and winning compensation.'),
(161,	76,	'_keywords',	'Tampa Insurance Bad Faith Lawyer'),
(162,	76,	'aFhfc_head_code',	''),
(163,	76,	'aFhfc_footer_code',	''),
(164,	78,	'_edit_last',	'1'),
(165,	78,	'_title',	'Tampa Catastrophic Injury Lawyer'),
(166,	78,	'_description',	'Our Tampa catastrophic injury lawyers are dedicated to fighting for the rights of our clients and ensuring a fair and necessary amount of compensation.'),
(167,	78,	'_keywords',	'Tamap Catastrophic Injury Lawyer'),
(168,	78,	'aFhfc_head_code',	''),
(169,	78,	'aFhfc_footer_code',	''),
(170,	80,	'_edit_last',	'1'),
(171,	80,	'_title',	'Tampa Wrongful Death Lawyer'),
(172,	80,	'_description',	'A wrongful death suit may help garner monetary damages on behalf of surviving family, contact our experienced Tampa wrongful death lawyers.'),
(173,	80,	'_keywords',	'Tampa Wrongful Death Lawyer'),
(174,	80,	'aFhfc_head_code',	''),
(175,	80,	'aFhfc_footer_code',	''),
(176,	82,	'_edit_last',	'3'),
(177,	82,	'_title',	'Tampa Criminal Lawyer'),
(178,	82,	'_description',	'Contact our Tampa criminal lawyers for issues involving drug crimes, DUI, felony, misdemeanor, gun charges, license and traffic violations & more.'),
(179,	82,	'_keywords',	'Tampa Criminal Lawyer'),
(180,	84,	'_edit_last',	'1'),
(181,	84,	'_title',	'Tampa Drug Crime Lawyer'),
(182,	84,	'_description',	'Florida has some of the toughest drug laws in the United States, contact our experienced Tampa drug crime defense lawyers.'),
(183,	84,	'_keywords',	'Tampa Drug Crime Lawyer'),
(184,	84,	'aFhfc_head_code',	''),
(185,	84,	'aFhfc_footer_code',	''),
(186,	86,	'_edit_last',	'1'),
(187,	86,	'_title',	'Tampa DUI Defense Lawyer'),
(188,	86,	'_description',	'DUI laws are very strict in Florida, contact our experienced Tampa DUI lawyers for aggressive DUI defense.'),
(189,	86,	'_keywords',	'Tampa DUI Defense Lawyer'),
(190,	86,	'aFhfc_head_code',	''),
(191,	86,	'aFhfc_footer_code',	''),
(192,	88,	'_edit_last',	'1'),
(193,	88,	'_title',	'Tampa Felony Lawyer'),
(194,	88,	'_description',	'A felony conviction of any kind can have serious consequences on every aspect of your life, contact our Tampa felony defense lawyers.'),
(195,	88,	'_keywords',	'Tampa Felony Defense Lawyer'),
(196,	88,	'aFhfc_head_code',	''),
(197,	88,	'aFhfc_footer_code',	''),
(198,	90,	'_edit_last',	'1'),
(199,	90,	'_title',	'Tampa Misdemeanor Lawyer'),
(200,	90,	'_description',	'Our Tampa misdemeanor lawyers have the experience and dedication needed to help make sure your misdemeanor case is handled in the best possible way.'),
(201,	90,	'_keywords',	'Tampa Misdemeanor Lawyer'),
(202,	90,	'aFhfc_head_code',	''),
(203,	90,	'aFhfc_footer_code',	''),
(204,	92,	'_edit_last',	'1'),
(205,	92,	'_title',	'Tampa Gun & Weapon Crime Lawyer'),
(206,	92,	'_description',	'Gun and weapons charges in Florida can yield serious legal consequences, contact our Tampa gun crime lawyers.'),
(207,	92,	'_keywords',	'Tampa Gun & Weapon Crime Lawyer'),
(208,	92,	'aFhfc_head_code',	''),
(209,	92,	'aFhfc_footer_code',	''),
(210,	94,	'_edit_last',	'1'),
(211,	94,	'_title',	'Tampa License Suspension Lawyer'),
(212,	94,	'_description',	'If you are pulled over or in an accident while your license is suspended, revoked, or cancelled in Florida, contact our Tampa license suspension lawyers.'),
(213,	94,	'_keywords',	'Tampa License Suspension Lawyer'),
(214,	94,	'aFhfc_head_code',	''),
(215,	94,	'aFhfc_footer_code',	''),
(216,	96,	'_edit_last',	'1'),
(217,	96,	'_title',	'Tampa Traffic Violation Lawyer'),
(218,	96,	'_description',	'Our Tampa traffic violation lawyers can take on your case and do all we can to ensure your traffic ticket citation has a minimal impact.'),
(219,	96,	'_keywords',	'Tampa Traffic Violation Lawyer'),
(220,	96,	'aFhfc_head_code',	''),
(221,	96,	'aFhfc_footer_code',	''),
(222,	338,	'_edit_last',	'1'),
(223,	338,	'_title',	'Blog | Pawlowski Mastrilli Law Group'),
(224,	338,	'_description',	'View our articles and blog posts and contact our Tampa personal injury and criminal defense attorneys any time.'),
(225,	338,	'_keywords',	''),
(226,	338,	'aFhfc_head_code',	''),
(227,	338,	'aFhfc_footer_code',	''),
(228,	370,	'_edit_last',	'3'),
(229,	370,	'_title',	'Dena M. Dymtrow, ESQ. | Pawlowski Mastrilli Law Group'),
(230,	370,	'_description',	'Dena M. Dymtrow, ESQ. has more than eighteen years of experience in the areas of criminal defense, DUI/DWI, drug crimes, sex crimes, domestic violence, family law & more.'),
(231,	370,	'_keywords',	''),
(235,	427,	'_edit_last',	'1'),
(236,	427,	'_title',	'Tampa Family Lawyer'),
(237,	427,	'_description',	'Our experienced Tampa family & divorce lawyers can help your through tough times, contact us today.'),
(238,	427,	'_keywords',	'Tampa Family Lawyer'),
(239,	427,	'aFhfc_head_code',	''),
(240,	427,	'aFhfc_footer_code',	''),
(241,	2279,	'_edit_last',	'1'),
(242,	2279,	'_title',	'Download Our App | Pawlowski Mastrilli Law Group'),
(243,	2279,	'_description',	'Download our app for iPhone or Android.'),
(244,	2279,	'_keywords',	''),
(245,	2279,	'_subslideID',	''),
(246,	2279,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2018/04/google-play.png\";s:5:\"title\";s:11:\"google-play\";s:7:\"caption\";s:0:\"\";}'),
(247,	2279,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2018/04/apple-store.png\";s:5:\"title\";s:11:\"apple-store\";s:7:\"caption\";s:0:\"\";}'),
(254,	2612,	'_edit_last',	'1'),
(255,	2612,	'_title',	'Tampa Personal Injury & Auto Accident FAQ'),
(256,	2612,	'_description',	'View our Tampa Personal Injury & Auto Accident FAQ, contact The Pawlowski//Mastrilli Law Group anytime.'),
(257,	2612,	'_keywords',	'Tampa Personal Injury & Auto Accident FAQ'),
(258,	2612,	'_subslideID',	''),
(259,	2555,	'_edit_last',	'1'),
(260,	2555,	'_title',	'Tampa Child Support Lawyer'),
(261,	2555,	'_description',	'If you need assistance with child support, contact the experienced Tampa child support lawyers at The Pawlowski//Mastrilli Law Group today.'),
(262,	2555,	'_keywords',	'Tampa Child Support Lawyer'),
(263,	2609,	'_edit_last',	'1'),
(264,	2609,	'_title',	'Tampa Uncontested Divorce Lawyer'),
(265,	2609,	'_description',	'If you need divorce assistance, consider contacting the Tampa uncontested divorce lawyers at The Pawlowski//Mastrilli Law Group.'),
(266,	2609,	'_keywords',	'Tampa Uncontested Divorce Lawyer'),
(267,	2609,	'_xmlsf_priority',	'0.0'),
(268,	2682,	'_edit_last',	'1'),
(269,	2682,	'_title',	'Tampa Divorce Appeals Lawyer'),
(270,	2682,	'_description',	'If you need help with divorce appeals in Tampa, contact the family lawyers at The Pawlowski//Mastrilli Law Group today.'),
(271,	2682,	'_keywords',	'Tampa Divorce Appeals Lawyer'),
(272,	2683,	'_edit_last',	'1'),
(273,	2683,	'_title',	'Tampa Prenuptial Agreement Lawyer'),
(274,	2683,	'_description',	'If you need a prenuptial agreement lawyer in Tampa, contact the experienced legal team at The Pawlowski//Mastrilli Law Group today.'),
(275,	2683,	'_keywords',	'Tampa Prenuptial Agreement Lawyer'),
(276,	2684,	'_edit_last',	'1'),
(277,	2684,	'_title',	'Tampa Collaborative Divorce Lawyer'),
(278,	2684,	'_description',	'If you need collaborative divorce assistance, call the Tampa family lawyers at The Pawlowski//Mastrilli Law Group today.'),
(279,	2684,	'_keywords',	'Tampa Collaborative Divorce Lawyer'),
(280,	2685,	'_edit_last',	'1'),
(281,	2685,	'_title',	'Tampa Contested Divorce Lawyer'),
(282,	2685,	'_description',	'If you need assistance with a contested divorce case, contact the family lawyers at The Pawlowski//Mastrilli Law Group today.'),
(283,	2685,	'_keywords',	'Tampa Contested Divorce Lawyer'),
(284,	2686,	'_edit_last',	'1'),
(285,	2686,	'_title',	'Tampa Fathers’ Rights Lawyer'),
(286,	2686,	'_description',	'If you need divorce assistance concerning fathers\' rights in Tampa, contact the family lawyers at The Pawlowski//Mastrilli Law Group today.'),
(287,	2686,	'_keywords',	'Tampa Fathers’ Rights Lawyer'),
(288,	2687,	'_edit_last',	'3'),
(289,	2687,	'_title',	'Tampa Child Custody Lawyer'),
(290,	2687,	'_description',	'If you need help with child custody arrangements, contact the experienced Tampa child custody lawyers at The Pawlowski//Mastrilli Law Group today.'),
(291,	2687,	'_keywords',	'Tampa Child Custody Lawyer'),
(292,	2688,	'_edit_last',	'1'),
(293,	2688,	'_title',	'Tampa Modification & Enforcement of Final Judgments Lawyer'),
(294,	2688,	'_description',	'If you need assistance with changing or enforcing child support or time sharing agreement, call the modification & enforcement lawyers at The Pawlowski//Mastrilli Law Group.'),
(295,	2688,	'_keywords',	'Tampa Modification & Enforcement of Final Judgments Lawyer'),
(297,	2689,	'_edit_last',	'1'),
(298,	2689,	'_title',	'Tampa Prenuptial & Post-Marital Agreement Lawyer'),
(299,	2689,	'_description',	'If you are thinking about entering into a prenuptial or post-marital agreement, call the family lawyers at The Pawlowski//Mastrilli Law Group today.'),
(300,	2689,	'_keywords',	'Tampa Prenuptial & Post-Marital Agreement Lawyer'),
(302,	2690,	'_edit_last',	'1'),
(303,	2690,	'_title',	'Tampa Child Support Modification Lawyer'),
(304,	2690,	'_description',	'Contact one of the child support modification lawyers today at The Pawlowski//Mastrilli Law Group if you need assistance with changing your child support order.'),
(305,	2690,	'_keywords',	'Tampa Child Support Modification Lawyer'),
(307,	2691,	'_edit_last',	'1'),
(308,	2691,	'_title',	'Tampa Domestic Violence Lawyer'),
(309,	2691,	'_description',	'If you are experiencing a domestic violence situation, call the Tampa domestic violence lawyers at The Pawlowski//Mastrilli Law Group as soon as possible.'),
(310,	2691,	'_keywords',	'Tampa Domestic Violence Lawyer'),
(312,	2692,	'_edit_last',	'1'),
(313,	2692,	'_title',	'Tampa Stepparent & Relative Adoption Lawyer'),
(314,	2692,	'_description',	'If you wish to adopt your stepchild, contact the Tampa stepparent adoption lawyers at The Pawlowski//Mastrilli Law Group today.'),
(315,	2692,	'_keywords',	'Tampa Stepparent & Relative Adoption Lawyer'),
(316,	2692,	'_xmlsf_priority',	'0.0'),
(317,	2693,	'_edit_last',	'1'),
(318,	2693,	'_title',	'Tampa Service by Publication Lawyer'),
(319,	2693,	'_description',	'If you are seeking a Tampa divorce lawyer to help you with service by publication, call the family lawyers at The Pawlowski // Mastrilli Group today.'),
(320,	2693,	'_keywords',	'Tampa Service by Publication Lawyer'),
(322,	2694,	'_edit_last',	'1'),
(323,	2694,	'_title',	'Tampa Adoption Lawyer'),
(324,	2694,	'_description',	'If you need help with adoption procedures in Tampa, call the adoption lawyers at The Pawlowski//Mastrilli Law Group today.'),
(325,	2694,	'_keywords',	'Tampa Adoption Lawyer'),
(326,	2694,	'_xmlsf_priority',	'0.0'),
(327,	2695,	'_edit_last',	'1'),
(328,	2695,	'_title',	'Tampa Asset & Debt Division Lawyer'),
(329,	2695,	'_description',	'If you need assistance with asset and debt division in Tampa, contact the divorce lawyers at The Pawlowski//Mastrilli Law Group today.'),
(330,	2695,	'_keywords',	'Tampa Asset & Debt Division Lawyer'),
(331,	2695,	'_xmlsf_priority',	'0.0'),
(332,	2696,	'_edit_last',	'1'),
(333,	2696,	'_title',	'Tampa Annulment & Divorce Lawyer'),
(334,	2696,	'_description',	'If you need legal advice for an annulment or divorce, call the Tampa divorce lawyers at The Pawlowski//Mastrilli Law Group today.'),
(335,	2696,	'_keywords',	'Tampa Annulment & Divorce Lawyer'),
(336,	2696,	'_xmlsf_priority',	'0.0'),
(337,	2697,	'_edit_last',	'3'),
(338,	2697,	'_title',	'Tampa Alimony Lawyer'),
(339,	2697,	'_description',	'When seeking spousal support, reach out to the experienced Tampa alimony lawyers at The Pawlowski//Mastrilli Law Group today.'),
(340,	2697,	'_keywords',	'Tampa Alimony Lawyer'),
(341,	2697,	'_xmlsf_priority',	'0.0'),
(342,	2698,	'_edit_last',	'1'),
(343,	2698,	'_title',	'Tampa Default Divorce Lawyer'),
(344,	2698,	'_description',	'If you need assistance with a default divorce, call the default divorce lawyers at The Pawlowski//Mastrilli Law Group in Tampa today.'),
(345,	2698,	'_keywords',	'Tampa Default Divorce Lawyer'),
(346,	2698,	'_xmlsf_priority',	'0.0'),
(347,	2699,	'_edit_last',	'1'),
(348,	2699,	'_title',	'Tampa Divorce Lawyer'),
(349,	2699,	'_description',	'For divorce assistance in Florida, call the experienced Tampa divorce lawyers at The Pawlowski//Mastrilli Law Group today.'),
(350,	2699,	'_keywords',	'Tampa Divorce Lawyer'),
(351,	2699,	'_xmlsf_priority',	'0.0'),
(352,	2627,	'_edit_last',	'1'),
(353,	2627,	'_title',	'Tampa LGBTQ Same Sex Divorce Lawyer'),
(354,	2627,	'_description',	'If you need assistance in a same sex divorce, reach out to the experienced Tampa LGBTQ divorce lawyers at The Pawlowski//Mastrilli Law Group today.'),
(355,	2627,	'_keywords',	'Tampa LGBTQ Same Sex Divorce Lawyer'),
(356,	2627,	'_xmlsf_priority',	'0.0'),
(357,	2700,	'_edit_last',	'1'),
(358,	2700,	'_title',	'Tampa Parenting Plan Lawyer'),
(359,	2700,	'_description',	'If you are considering divorce and have children, contact one of our Tampa parenting plan lawyers at The Pawlowski//Mastrilli Law Group today.'),
(360,	2700,	'_keywords',	'Tampa Parenting Plan Lawyer'),
(361,	2701,	'_edit_last',	'1'),
(362,	2701,	'_title',	'Tampa Low Cost/Flat Fee Unbundled Services'),
(363,	2701,	'_description',	'If you are looking for assistance with your divorce or any other family law matters in Tampa, contact The Pawlowski//Mastrilli Law Group today.'),
(364,	2701,	'_keywords',	'Tampa Low Cost/Flat Fee Unbundled Services'),
(365,	2702,	'_edit_last',	'1'),
(366,	2702,	'_title',	'Tampa Military Divorce Lawyer'),
(367,	2702,	'_description',	'If you need help with a military divorce, contact the Tampa military divorce lawyers at The Pawlowski//Mastrilli Law Group today.'),
(368,	2702,	'_keywords',	'Tampa Military Divorce Lawyer'),
(369,	2703,	'_edit_last',	'1'),
(370,	2703,	'_title',	'Tampa Postnuptial Agreement Lawyer'),
(371,	2703,	'_description',	'If you need the assistance of a postnuptial agreement lawyer, please call the family law experts at The Pawlowski//Mastrilli Law Group today.'),
(372,	2703,	'_keywords',	'Tampa Postnuptial Agreement Lawyer'),
(374,	2704,	'_edit_last',	'1'),
(375,	2704,	'_title',	'Tampa Paternity Lawyer'),
(376,	2704,	'_description',	'If you need assistance with a Tampa paternity case, contact the paternity lawyers at The Pawlowski//Mastrilli Law Group today.'),
(377,	2704,	'_keywords',	'Tampa Paternity Lawyer'),
(379,	2705,	'_edit_last',	'1'),
(380,	2705,	'_title',	'Tampa Mediation Lawyer'),
(381,	2705,	'_description',	'If you are involved in a dispute with your spouse or another family member, call the Tampa mediation lawyers at The Pawlowski//Mastrilli Law Group today.'),
(382,	2705,	'_keywords',	'Tampa Mediation Lawyer'),
(384,	2708,	'_edit_last',	'1'),
(385,	2708,	'_title',	'Tampa Independent Adoption Lawyer'),
(386,	2708,	'_description',	'If you are ready to grow your family via independent adoption, reach out to the Tampa adoption lawyers at The Pawlowski//Mastrilli Law Group today.'),
(387,	2708,	'_keywords',	'Tampa Independent Adoption Lawyer'),
(388,	2708,	'_xmlsf_priority',	'0.0'),
(389,	2710,	'_edit_last',	'1'),
(390,	2710,	'_title',	'Tampa Retirement & Pension Division Lawyer'),
(391,	2710,	'_description',	'If you are looking for a Tampa divorce lawyer who is qualified in the division of retirement accounts, contact the legal team at The Pawlowski//Mastrilli Law Group'),
(392,	2710,	'_keywords',	'Tampa Retirement & Pension Division Lawyer'),
(393,	2710,	'_xmlsf_priority',	'0.0'),
(394,	3021,	'_edit_last',	'1'),
(395,	3021,	'_title',	'Tampa Hurricane Damage Lawyer'),
(396,	3021,	'_description',	'At The Pawlowski//Mastrilli Law Group, our top-rated Tampa hurricane daTage lawyers are dedicated advocates for policyholders.'),
(397,	3021,	'_keywords',	'Tampa Hurricane Damage Lawyer'),
(398,	3021,	'_subslideID',	'8'),
(404,	3271,	'_edit_last',	'1'),
(405,	3271,	'_title',	'Kimberly A. Burchins, ESQ. | Pawlowski Mastrilli Law Group'),
(406,	3271,	'_description',	'Kimberly A. Burchins has over 20 years experience in the areas of personal injury, auto accidents and injuries and workers’ compensation as a case manager.'),
(407,	3271,	'_keywords',	''),
(408,	3271,	'_subslideID',	''),
(1469,	155,	'_wp_attached_file',	'2015/09/vincent-pawlowski.jpg'),
(1470,	155,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:240;s:4:\"file\";s:29:\"2015/09/vincent-pawlowski.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"vincent-pawlowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:29:\"vincent-pawlowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:29:\"vincent-pawlowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:29:\"vincent-pawlowski-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1471,	157,	'_wp_attached_file',	'2015/09/William_R_Franchi.jpg'),
(1472,	157,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:240;s:4:\"file\";s:29:\"2015/09/William_R_Franchi.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"William_R_Franchi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:29:\"William_R_Franchi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:29:\"William_R_Franchi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:29:\"William_R_Franchi-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1473,	160,	'_wp_attached_file',	'2015/09/Kenneth_W_Mastrilli.jpg'),
(1474,	160,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:240;s:4:\"file\";s:31:\"2015/09/Kenneth_W_Mastrilli.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Kenneth_W_Mastrilli-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"Kenneth_W_Mastrilli-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:31:\"Kenneth_W_Mastrilli-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:31:\"Kenneth_W_Mastrilli-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1475,	166,	'_wp_attached_file',	'2015/09/Zachary_C_Smith.jpg'),
(1476,	166,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:240;s:4:\"file\";s:27:\"2015/09/Zachary_C_Smith.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Zachary_C_Smith-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"Zachary_C_Smith-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:27:\"Zachary_C_Smith-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:27:\"Zachary_C_Smith-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1477,	203,	'_wp_attached_file',	'2015/09/credit_card_logo.png'),
(1478,	203,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:150;s:6:\"height\";i:24;s:4:\"file\";s:28:\"2015/09/credit_card_logo.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"credit_card_logo-150x24.png\";s:5:\"width\";i:150;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"credit_card_logo-150x24.png\";s:5:\"width\";i:150;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:27:\"credit_card_logo-150x24.png\";s:5:\"width\";i:150;s:6:\"height\";i:24;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1479,	205,	'_wp_attached_file',	'2015/09/recovery_flow_chart.jpg'),
(1480,	205,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:410;s:6:\"height\";i:400;s:4:\"file\";s:31:\"2015/09/recovery_flow_chart.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"recovery_flow_chart-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"recovery_flow_chart-300x293.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:293;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"recovery_flow_chart-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:31:\"recovery_flow_chart-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:31:\"recovery_flow_chart-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1481,	358,	'_wp_attached_file',	'2015/09/Smith-Zach-BBPi.jpg'),
(1482,	358,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1500;s:4:\"file\";s:27:\"2015/09/Smith-Zach-BBPi.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Smith-Zach-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"Smith-Zach-BBPi-240x300.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"Smith-Zach-BBPi-768x960.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"Smith-Zach-BBPi-819x1024.jpg\";s:5:\"width\";i:819;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"Smith-Zach-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:27:\"Smith-Zach-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:27:\"Smith-Zach-BBPi-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:2:\"14\";s:6:\"credit\";s:29:\"Bob Baggett Photography, Inc.\";s:6:\"camera\";s:11:\"NIKON D300S\";s:7:\"caption\";s:62:\"@2015\r3110 West Azeele Street\rTampa Florida 33609\r813-870-0349\";s:17:\"created_timestamp\";s:10:\"1435231163\";s:9:\"copyright\";s:7:\"08.2015\";s:12:\"focal_length\";s:2:\"38\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:10:\"Zack Smith\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1483,	359,	'_wp_attached_file',	'2015/09/Mastrilli-Ken-BBPi.jpg'),
(1484,	359,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1500;s:4:\"file\";s:30:\"2015/09/Mastrilli-Ken-BBPi.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"Mastrilli-Ken-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"Mastrilli-Ken-BBPi-240x300.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"Mastrilli-Ken-BBPi-768x960.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"Mastrilli-Ken-BBPi-819x1024.jpg\";s:5:\"width\";i:819;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"Mastrilli-Ken-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:30:\"Mastrilli-Ken-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:30:\"Mastrilli-Ken-BBPi-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:2:\"14\";s:6:\"credit\";s:29:\"Bob Baggett Photography, Inc.\";s:6:\"camera\";s:11:\"NIKON D300S\";s:7:\"caption\";s:62:\"@2015\r3110 West Azeele Street\rTampa Florida 33609\r813-870-0349\";s:17:\"created_timestamp\";s:10:\"1435231421\";s:9:\"copyright\";s:7:\"08.2015\";s:12:\"focal_length\";s:2:\"40\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:13:\"Ken Martrilli\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1485,	360,	'_wp_attached_file',	'2015/09/Franchi-William-BBPi.jpg'),
(1486,	360,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1500;s:4:\"file\";s:32:\"2015/09/Franchi-William-BBPi.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"Franchi-William-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"Franchi-William-BBPi-240x300.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"Franchi-William-BBPi-768x960.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:33:\"Franchi-William-BBPi-819x1024.jpg\";s:5:\"width\";i:819;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:32:\"Franchi-William-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:32:\"Franchi-William-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:32:\"Franchi-William-BBPi-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:2:\"13\";s:6:\"credit\";s:29:\"Bob Baggett Photography, Inc.\";s:6:\"camera\";s:11:\"NIKON D300S\";s:7:\"caption\";s:62:\"@2015\r3110 West Azeele Street\rTampa Florida 33609\r813-870-0349\";s:17:\"created_timestamp\";s:10:\"1435228368\";s:9:\"copyright\";s:7:\"08.2015\";s:12:\"focal_length\";s:2:\"38\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:15:\"William Franchi\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1487,	368,	'_wp_attached_file',	'2015/10/Vince_Pawlowski.jpg'),
(1488,	368,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:240;s:4:\"file\";s:27:\"2015/10/Vince_Pawlowski.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"Vince_Pawlowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"Vince_Pawlowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:27:\"Vince_Pawlowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:27:\"Vince_Pawlowski-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1489,	374,	'_wp_attached_file',	'2015/10/Dena_Seiden.jpg'),
(1490,	374,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:201;s:6:\"height\";i:201;s:4:\"file\";s:23:\"2015/10/Dena_Seiden.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Dena_Seiden-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"Dena_Seiden-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"Dena_Seiden-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"Dena_Seiden-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1491,	378,	'_wp_attached_file',	'2015/10/MichaelRozum.jpg'),
(1492,	378,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:2448;s:6:\"height\";i:3264;s:4:\"file\";s:24:\"2015/10/MichaelRozum.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"MichaelRozum-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"MichaelRozum-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"MichaelRozum-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"MichaelRozum-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"MichaelRozum-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"MichaelRozum-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"MichaelRozum-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone 6\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1444321040\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"4.15\";s:3:\"iso\";s:2:\"40\";s:13:\"shutter_speed\";s:17:\"0.016666666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1493,	379,	'_wp_attached_file',	'2015/10/ChrisDale.jpg'),
(1494,	379,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:2448;s:6:\"height\";i:3264;s:4:\"file\";s:21:\"2015/10/ChrisDale.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"ChrisDale-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"ChrisDale-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"ChrisDale-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"ChrisDale-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"ChrisDale-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"ChrisDale-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"ChrisDale-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.2\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone 6\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1444323308\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"4.15\";s:3:\"iso\";s:2:\"40\";s:13:\"shutter_speed\";s:17:\"0.033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1495,	777,	'_wp_attached_file',	'2015/10/Seiden-Dena-BBPi.jpg'),
(1496,	777,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1500;s:4:\"file\";s:28:\"2015/10/Seiden-Dena-BBPi.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"Seiden-Dena-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"Seiden-Dena-BBPi-240x300.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"Seiden-Dena-BBPi-768x960.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"Seiden-Dena-BBPi-819x1024.jpg\";s:5:\"width\";i:819;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:28:\"Seiden-Dena-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:28:\"Seiden-Dena-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:28:\"Seiden-Dena-BBPi-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:2:\"14\";s:6:\"credit\";s:29:\"Bob Baggett Photography, Inc.\";s:6:\"camera\";s:11:\"NIKON D300S\";s:7:\"caption\";s:62:\"@2016\r3110 West Azeele Street\rTampa Florida 33609\r813-870-0349\";s:17:\"created_timestamp\";s:10:\"1463484176\";s:9:\"copyright\";s:7:\"05.2016\";s:12:\"focal_length\";s:2:\"56\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:11:\"Dena Seiden\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1497,	781,	'_wp_attached_file',	'2015/10/Dale-Christopher-BBPi.jpg'),
(1498,	781,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:1200;s:6:\"height\";i:1500;s:4:\"file\";s:33:\"2015/10/Dale-Christopher-BBPi.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Dale-Christopher-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Dale-Christopher-BBPi-240x300.jpg\";s:5:\"width\";i:240;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"Dale-Christopher-BBPi-768x960.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:960;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"Dale-Christopher-BBPi-819x1024.jpg\";s:5:\"width\";i:819;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"Dale-Christopher-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:33:\"Dale-Christopher-BBPi-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:33:\"Dale-Christopher-BBPi-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:2:\"13\";s:6:\"credit\";s:29:\"Bob Baggett Photography, Inc.\";s:6:\"camera\";s:11:\"NIKON D300S\";s:7:\"caption\";s:62:\"@2016\r3110 West Azeele Street\rTampa Florida 33609\r813-870-0349\";s:17:\"created_timestamp\";s:10:\"1462794224\";s:9:\"copyright\";s:7:\"05.2016\";s:12:\"focal_length\";s:2:\"34\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:5:\"0.005\";s:5:\"title\";s:16:\"Christopher Dale\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1499,	836,	'_wp_attached_file',	'2015/09/million-dollar-advocates.png'),
(1500,	836,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:36:\"2015/09/million-dollar-advocates.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1501,	836,	'_wp_attachment_image_alt',	'Million Dollar Advocates'),
(1502,	837,	'_wp_attached_file',	'2015/09/multi-million-dollar-advocates.png'),
(1503,	837,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:42:\"2015/09/multi-million-dollar-advocates.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1504,	837,	'_wp_attachment_image_alt',	'Multi-Million Dollar Advocates'),
(1505,	1031,	'_wp_attached_file',	'2016/10/BirthInjury.jpg'),
(1506,	1031,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:465;s:6:\"height\";i:247;s:4:\"file\";s:23:\"2016/10/BirthInjury.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"BirthInjury-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"BirthInjury-300x159.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:159;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"BirthInjury-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"BirthInjury-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"BirthInjury-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1507,	1033,	'_wp_attached_file',	'2016/10/Truck3.jpg'),
(1508,	1033,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:485;s:6:\"height\";i:322;s:4:\"file\";s:18:\"2016/10/Truck3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"Truck3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"Truck3-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:18:\"Truck3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:18:\"Truck3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:18:\"Truck3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1509,	1063,	'_wp_attached_file',	'2016/10/DUI_Check.jpg'),
(1510,	1063,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:244;s:6:\"height\";i:170;s:4:\"file\";s:21:\"2016/10/DUI_Check.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"DUI_Check-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"DUI_Check-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"DUI_Check-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"DUI_Check-200x170.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1511,	1074,	'_wp_attached_file',	'2016/10/BrainInjury1.jpg'),
(1512,	1074,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:241;s:6:\"height\";i:239;s:4:\"file\";s:24:\"2016/10/BrainInjury1.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"BrainInjury1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"BrainInjury1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"BrainInjury1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"BrainInjury1-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1513,	1086,	'_wp_attached_file',	'2016/10/WorkInjuryClaim.jpg'),
(1514,	1086,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:489;s:6:\"height\";i:302;s:4:\"file\";s:27:\"2016/10/WorkInjuryClaim.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"WorkInjuryClaim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"WorkInjuryClaim-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"WorkInjuryClaim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:27:\"WorkInjuryClaim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:27:\"WorkInjuryClaim-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1515,	1273,	'_wp_attached_file',	'2016/11/CrimRecord2.jpg'),
(1516,	1273,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:237;s:6:\"height\";i:246;s:4:\"file\";s:23:\"2016/11/CrimRecord2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"CrimRecord2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"CrimRecord2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"CrimRecord2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"CrimRecord2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1517,	1285,	'_wp_attached_file',	'2016/11/Fire2.jpg'),
(1518,	1285,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:482;s:6:\"height\";i:339;s:4:\"file\";s:17:\"2016/11/Fire2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Fire2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"Fire2-300x211.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:211;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:17:\"Fire2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:17:\"Fire2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:17:\"Fire2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1519,	1294,	'_wp_attached_file',	'2016/11/NursingHome2.jpg'),
(1520,	1294,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:468;s:6:\"height\";i:284;s:4:\"file\";s:24:\"2016/11/NursingHome2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"NursingHome2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"NursingHome2-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"NursingHome2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"NursingHome2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"NursingHome2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1521,	1308,	'_wp_attached_file',	'2016/11/Accident.jpg'),
(1522,	1308,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:489;s:6:\"height\";i:352;s:4:\"file\";s:20:\"2016/11/Accident.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Accident-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Accident-300x216.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:216;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Accident-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Accident-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Accident-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1523,	1312,	'_wp_attached_file',	'2016/11/ArrestWord.jpg'),
(1524,	1312,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:492;s:6:\"height\";i:328;s:4:\"file\";s:22:\"2016/11/ArrestWord.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"ArrestWord-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"ArrestWord-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"ArrestWord-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"ArrestWord-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"ArrestWord-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1525,	1340,	'_wp_attached_file',	'2016/12/HipRepl.jpg'),
(1526,	1340,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:480;s:6:\"height\";i:369;s:4:\"file\";s:19:\"2016/12/HipRepl.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"HipRepl-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"HipRepl-300x231.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"HipRepl-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"HipRepl-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"HipRepl-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1527,	1422,	'_wp_attached_file',	'2016/12/Slip.jpg'),
(1528,	1422,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:305;s:6:\"height\";i:305;s:4:\"file\";s:16:\"2016/12/Slip.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"Slip-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"Slip-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"Slip-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"Slip-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"Slip-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1529,	1425,	'_wp_attached_file',	'2016/12/CarInsur2.jpg'),
(1530,	1425,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:488;s:6:\"height\";i:267;s:4:\"file\";s:21:\"2016/12/CarInsur2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"CarInsur2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"CarInsur2-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"CarInsur2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"CarInsur2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"CarInsur2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1531,	1428,	'_wp_attached_file',	'2016/12/Marijuana2.jpg'),
(1532,	1428,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:477;s:6:\"height\";i:340;s:4:\"file\";s:22:\"2016/12/Marijuana2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Marijuana2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Marijuana2-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"Marijuana2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"Marijuana2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"Marijuana2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1533,	1431,	'_wp_attached_file',	'2016/12/Accident4.jpg'),
(1534,	1431,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:478;s:6:\"height\";i:317;s:4:\"file\";s:21:\"2016/12/Accident4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Accident4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"Accident4-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"Accident4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"Accident4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"Accident4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1535,	1467,	'_wp_attached_file',	'2017/01/DentalM.jpg'),
(1536,	1467,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:460;s:6:\"height\";i:294;s:4:\"file\";s:19:\"2017/01/DentalM.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"DentalM-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"DentalM-300x192.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"DentalM-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"DentalM-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"DentalM-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1537,	1486,	'_wp_attached_file',	'2017/01/ECigg2.jpg'),
(1538,	1486,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:292;s:6:\"height\";i:331;s:4:\"file\";s:18:\"2017/01/ECigg2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"ECigg2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:18:\"ECigg2-265x300.jpg\";s:5:\"width\";i:265;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:18:\"ECigg2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:18:\"ECigg2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:18:\"ECigg2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1539,	1504,	'_wp_attached_file',	'2017/01/Dog.jpg'),
(1540,	1504,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:304;s:6:\"height\";i:241;s:4:\"file\";s:15:\"2017/01/Dog.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"Dog-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"Dog-300x238.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:238;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:15:\"Dog-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:15:\"Dog-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:15:\"Dog-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1541,	1524,	'_wp_attached_file',	'2017/01/DUI5.jpg'),
(1542,	1524,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:483;s:6:\"height\";i:322;s:4:\"file\";s:16:\"2017/01/DUI5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"DUI5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"DUI5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"DUI5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"DUI5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"DUI5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1543,	1536,	'_wp_attached_file',	'2017/02/WC_1.jpg'),
(1544,	1536,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:348;s:6:\"height\";i:326;s:4:\"file\";s:16:\"2017/02/WC_1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"WC_1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"WC_1-300x281.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:281;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"WC_1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"WC_1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"WC_1-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1545,	1553,	'_wp_attached_file',	'2017/02/Probation.jpg'),
(1546,	1553,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:246;s:6:\"height\";i:243;s:4:\"file\";s:21:\"2017/02/Probation.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Probation-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"Probation-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"Probation-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"Probation-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1547,	1568,	'_wp_attached_file',	'2017/02/TruckAcc.jpg'),
(1548,	1568,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:492;s:6:\"height\";i:356;s:4:\"file\";s:20:\"2017/02/TruckAcc.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"TruckAcc-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"TruckAcc-300x217.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:217;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"TruckAcc-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"TruckAcc-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"TruckAcc-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1549,	1578,	'_wp_attached_file',	'2017/02/CarInsur.jpg'),
(1550,	1578,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:492;s:6:\"height\";i:329;s:4:\"file\";s:20:\"2017/02/CarInsur.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"CarInsur-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"CarInsur-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"CarInsur-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"CarInsur-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"CarInsur-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1551,	1595,	'_wp_attached_file',	'2017/03/CrimDef2.jpg'),
(1552,	1595,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:413;s:6:\"height\";i:365;s:4:\"file\";s:20:\"2017/03/CrimDef2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"CrimDef2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"CrimDef2-300x265.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:265;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"CrimDef2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"CrimDef2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"CrimDef2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1553,	1615,	'_wp_attached_file',	'2017/03/Pool3.jpg'),
(1554,	1615,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:471;s:6:\"height\";i:323;s:4:\"file\";s:17:\"2017/03/Pool3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Pool3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"Pool3-300x206.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:17:\"Pool3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:17:\"Pool3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:17:\"Pool3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1555,	1626,	'_wp_attached_file',	'2017/03/Gavel_Cuffs2.jpg'),
(1556,	1626,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:493;s:6:\"height\";i:302;s:4:\"file\";s:24:\"2017/03/Gavel_Cuffs2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"Gavel_Cuffs2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"Gavel_Cuffs2-300x184.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:184;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"Gavel_Cuffs2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"Gavel_Cuffs2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"Gavel_Cuffs2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1557,	1690,	'_wp_attached_file',	'2017/03/InjuryClaim.jpg'),
(1558,	1690,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:482;s:6:\"height\";i:251;s:4:\"file\";s:23:\"2017/03/InjuryClaim.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"InjuryClaim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"InjuryClaim-300x156.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:156;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"InjuryClaim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"InjuryClaim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"InjuryClaim-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1559,	1716,	'_wp_attached_file',	'2017/04/Jason.jpg'),
(1560,	1716,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:240;s:4:\"file\";s:17:\"2017/04/Jason.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Jason-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:17:\"Jason-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:17:\"Jason-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:17:\"Jason-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1561,	1755,	'_wp_attached_file',	'2017/04/CellAccident.jpg'),
(1562,	1755,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:470;s:6:\"height\";i:323;s:4:\"file\";s:24:\"2017/04/CellAccident.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"CellAccident-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"CellAccident-300x206.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"CellAccident-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"CellAccident-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"CellAccident-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1563,	1759,	'_wp_attached_file',	'2017/04/CarAcc4.jpg'),
(1564,	1759,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:234;s:6:\"height\";i:225;s:4:\"file\";s:19:\"2017/04/CarAcc4.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"CarAcc4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"CarAcc4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"CarAcc4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"CarAcc4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1565,	1762,	'_wp_attached_file',	'2017/04/Arrest_Bars.jpg'),
(1566,	1762,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:489;s:6:\"height\";i:312;s:4:\"file\";s:23:\"2017/04/Arrest_Bars.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Arrest_Bars-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Arrest_Bars-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"Arrest_Bars-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"Arrest_Bars-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"Arrest_Bars-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1567,	1765,	'_wp_attached_file',	'2017/04/WC_2.jpg'),
(1568,	1765,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:239;s:6:\"height\";i:223;s:4:\"file\";s:16:\"2017/04/WC_2.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"WC_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"WC_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"WC_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"WC_2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1569,	1771,	'_wp_attached_file',	'2017/04/Whiplash.jpg'),
(1570,	1771,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:345;s:6:\"height\";i:316;s:4:\"file\";s:20:\"2017/04/Whiplash.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Whiplash-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Whiplash-300x275.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:275;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Whiplash-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Whiplash-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Whiplash-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1571,	1794,	'_wp_attached_file',	'2017/05/CellPhone.jpg'),
(1572,	1794,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:276;s:6:\"height\";i:299;s:4:\"file\";s:21:\"2017/05/CellPhone.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"CellPhone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"CellPhone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"CellPhone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"CellPhone-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1573,	1804,	'_wp_attached_file',	'2017/05/Dog4.jpg'),
(1574,	1804,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:444;s:6:\"height\";i:269;s:4:\"file\";s:16:\"2017/05/Dog4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"Dog4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"Dog4-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"Dog4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"Dog4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"Dog4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1575,	1820,	'_wp_attached_file',	'2017/05/SlipFall.jpg'),
(1576,	1820,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:303;s:6:\"height\";i:303;s:4:\"file\";s:20:\"2017/05/SlipFall.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"SlipFall-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"SlipFall-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"SlipFall-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"SlipFall-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"SlipFall-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1577,	1821,	'_wp_attached_file',	'2017/05/CarCrash.jpg'),
(1578,	1821,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:485;s:6:\"height\";i:269;s:4:\"file\";s:20:\"2017/05/CarCrash.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"CarCrash-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"CarCrash-300x166.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"CarCrash-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"CarCrash-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"CarCrash-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1579,	1838,	'_wp_attached_file',	'2017/06/DriverLicense.jpg'),
(1580,	1838,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:250;s:6:\"height\";i:249;s:4:\"file\";s:25:\"2017/06/DriverLicense.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"DriverLicense-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"DriverLicense-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:25:\"DriverLicense-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:25:\"DriverLicense-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1581,	1852,	'_wp_attached_file',	'2017/06/Bus2.jpg'),
(1582,	1852,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:278;s:6:\"height\";i:331;s:4:\"file\";s:16:\"2017/06/Bus2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"Bus2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"Bus2-252x300.jpg\";s:5:\"width\";i:252;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"Bus2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"Bus2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"Bus2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1583,	1865,	'_wp_attached_file',	'2017/06/Boat.jpg'),
(1584,	1865,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:456;s:6:\"height\";i:239;s:4:\"file\";s:16:\"2017/06/Boat.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"Boat-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"Boat-300x157.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:157;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"Boat-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"Boat-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"Boat-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1585,	1873,	'_wp_attached_file',	'2017/06/dalton.jpg'),
(1586,	1873,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:180;s:6:\"height\";i:240;s:4:\"file\";s:18:\"2017/06/dalton.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"dalton-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:18:\"dalton-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:18:\"dalton-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:18:\"dalton-180x200.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1587,	1887,	'_wp_attached_file',	'2017/06/Liability3.jpg'),
(1588,	1887,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:485;s:6:\"height\";i:364;s:4:\"file\";s:22:\"2017/06/Liability3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Liability3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Liability3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"Liability3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"Liability3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"Liability3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1589,	1903,	'_wp_attached_file',	'2017/06/WC_3.jpg'),
(1590,	1903,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:250;s:6:\"height\";i:241;s:4:\"file\";s:16:\"2017/06/WC_3.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"WC_3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"WC_3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"WC_3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"WC_3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1591,	1907,	'_wp_attached_file',	'2017/06/MedMal5.jpg'),
(1592,	1907,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:257;s:6:\"height\";i:281;s:4:\"file\";s:19:\"2017/06/MedMal5.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"MedMal5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"MedMal5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"MedMal5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"MedMal5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1593,	1911,	'_wp_attached_file',	'2017/06/DUI5.jpg'),
(1594,	1911,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:483;s:6:\"height\";i:322;s:4:\"file\";s:16:\"2017/06/DUI5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"DUI5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"DUI5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"DUI5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"DUI5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"DUI5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1595,	2295,	'_wp_attached_file',	'2018/04/apple-store.png'),
(1596,	2295,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:210;s:6:\"height\";i:126;s:4:\"file\";s:23:\"2018/04/apple-store.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"apple-store-150x126.png\";s:5:\"width\";i:150;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"apple-store-150x126.png\";s:5:\"width\";i:150;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"apple-store-150x126.png\";s:5:\"width\";i:150;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"apple-store-200x126.png\";s:5:\"width\";i:200;s:6:\"height\";i:126;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1597,	2296,	'_wp_attached_file',	'2018/04/google-play.png'),
(1598,	2296,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:216;s:6:\"height\";i:127;s:4:\"file\";s:23:\"2018/04/google-play.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"google-play-150x127.png\";s:5:\"width\";i:150;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"google-play-150x127.png\";s:5:\"width\";i:150;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"google-play-150x127.png\";s:5:\"width\";i:150;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"google-play-200x127.png\";s:5:\"width\";i:200;s:6:\"height\";i:127;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1599,	2455,	'_wp_attached_file',	'2018/07/matt-mincone.jpg'),
(1600,	2455,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:240;s:4:\"file\";s:24:\"2018/07/matt-mincone.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"matt-mincone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"matt-mincone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"matt-mincone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"matt-mincone-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1601,	2677,	'_wp_attached_file',	'2018/09/dena.jpg'),
(1602,	2677,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:196;s:6:\"height\";i:240;s:4:\"file\";s:16:\"2018/09/dena.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"dena-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"dena-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"dena-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"dena-196x200.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1603,	2804,	'_wp_attached_file',	'2018/10/Custody2.jpg'),
(1604,	2804,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:480;s:6:\"height\";i:315;s:4:\"file\";s:20:\"2018/10/Custody2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Custody2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Custody2-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Custody2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Custody2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Custody2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1605,	2807,	'_wp_attached_file',	'2018/10/Parenting1.jpg'),
(1606,	2807,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:431;s:6:\"height\";i:399;s:4:\"file\";s:22:\"2018/10/Parenting1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Parenting1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Parenting1-300x278.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"Parenting1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"Parenting1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"Parenting1-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1607,	2831,	'_wp_attached_file',	'2018/11/Alimony8.jpg'),
(1608,	2831,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:238;s:6:\"height\";i:248;s:4:\"file\";s:20:\"2018/11/Alimony8.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Alimony8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Alimony8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Alimony8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Alimony8-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1609,	2834,	'_wp_attached_file',	'2018/11/CSupport5.jpg'),
(1610,	2834,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:478;s:6:\"height\";i:270;s:4:\"file\";s:21:\"2018/11/CSupport5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"CSupport5-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"CSupport5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"CSupport5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1611,	2871,	'_wp_attached_file',	'2018/11/Custody5.jpg'),
(1612,	2871,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:450;s:6:\"height\";i:302;s:4:\"file\";s:20:\"2018/11/Custody5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Custody5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Custody5-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Custody5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Custody5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Custody5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1613,	2873,	'_wp_attached_file',	'2018/11/Div12.jpg'),
(1614,	2873,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:427;s:6:\"height\";i:285;s:4:\"file\";s:17:\"2018/11/Div12.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Div12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"Div12-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:17:\"Div12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:17:\"Div12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:17:\"Div12-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1615,	2901,	'_wp_attached_file',	'2018/12/CSupport6.jpg'),
(1616,	2901,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:367;s:6:\"height\";i:306;s:4:\"file\";s:21:\"2018/12/CSupport6.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"CSupport6-300x250.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"CSupport6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"CSupport6-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1617,	2905,	'_wp_attached_file',	'2018/12/MomDaughter2.jpg'),
(1618,	2905,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:259;s:6:\"height\";i:330;s:4:\"file\";s:24:\"2018/12/MomDaughter2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"MomDaughter2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"MomDaughter2-235x300.jpg\";s:5:\"width\";i:235;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"MomDaughter2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"MomDaughter2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"MomDaughter2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1619,	2925,	'_wp_attached_file',	'2018/12/Prenup5.jpg'),
(1620,	2925,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:292;s:6:\"height\";i:327;s:4:\"file\";s:19:\"2018/12/Prenup5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Prenup5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"Prenup5-268x300.jpg\";s:5:\"width\";i:268;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"Prenup5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"Prenup5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"Prenup5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1621,	2927,	'_wp_attached_file',	'2018/12/Accident5.jpg'),
(1622,	2927,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:447;s:6:\"height\";i:288;s:4:\"file\";s:21:\"2018/12/Accident5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Accident5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"Accident5-300x193.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:193;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"Accident5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"Accident5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"Accident5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1623,	2968,	'_wp_attached_file',	'2019/01/FamCourt.jpg'),
(1624,	2968,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:218;s:6:\"height\";i:244;s:4:\"file\";s:20:\"2019/01/FamCourt.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"FamCourt-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"FamCourt-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"FamCourt-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"FamCourt-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1625,	2971,	'_wp_attached_file',	'2019/01/PetCustody.jpg'),
(1626,	2971,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:182;s:6:\"height\";i:224;s:4:\"file\";s:22:\"2019/01/PetCustody.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"PetCustody-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"PetCustody-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"PetCustody-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"PetCustody-182x200.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1627,	2983,	'_wp_attached_file',	'2019/01/Family4.jpg'),
(1628,	2983,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:291;s:6:\"height\";i:325;s:4:\"file\";s:19:\"2019/01/Family4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Family4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"Family4-269x300.jpg\";s:5:\"width\";i:269;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"Family4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"Family4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"Family4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1629,	2985,	'_wp_attached_file',	'2019/01/ArguingCouple.jpg'),
(1630,	2985,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:884;s:6:\"height\";i:611;s:4:\"file\";s:25:\"2019/01/ArguingCouple.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"ArguingCouple-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"ArguingCouple-300x207.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"ArguingCouple-768x531.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:531;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"ArguingCouple-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:25:\"ArguingCouple-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:25:\"ArguingCouple-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1631,	2998,	'_wp_attached_file',	'2019/01/Divorce8.jpg'),
(1632,	2998,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:486;s:6:\"height\";i:310;s:4:\"file\";s:20:\"2019/01/Divorce8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Divorce8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Divorce8-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Divorce8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Divorce8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Divorce8-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1633,	3006,	'_wp_attached_file',	'2019/01/Drowsy3.jpg'),
(1634,	3006,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:240;s:6:\"height\";i:295;s:4:\"file\";s:19:\"2019/01/Drowsy3.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Drowsy3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"Drowsy3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"Drowsy3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"Drowsy3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1635,	3039,	'_wp_attached_file',	'2019/02/Divorce2.jpg'),
(1636,	3039,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:491;s:6:\"height\";i:360;s:4:\"file\";s:20:\"2019/02/Divorce2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Divorce2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Divorce2-300x220.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:220;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Divorce2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Divorce2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Divorce2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1637,	3042,	'_wp_attached_file',	'2019/02/DivDecree.jpg'),
(1638,	3042,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:474;s:6:\"height\";i:316;s:4:\"file\";s:21:\"2019/02/DivDecree.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"DivDecree-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"DivDecree-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"DivDecree-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"DivDecree-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"DivDecree-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1639,	3053,	'_wp_attached_file',	'2019/02/Grandmother.jpg'),
(1640,	3053,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:460;s:6:\"height\";i:314;s:4:\"file\";s:23:\"2019/02/Grandmother.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Grandmother-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"Grandmother-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"Grandmother-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"Grandmother-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"Grandmother-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1641,	3055,	'_wp_attached_file',	'2019/02/DivMoney.jpg'),
(1642,	3055,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:493;s:6:\"height\";i:301;s:4:\"file\";s:20:\"2019/02/DivMoney.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DivMoney-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"DivMoney-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"DivMoney-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"DivMoney-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"DivMoney-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1643,	3089,	'_wp_attached_file',	'2019/02/FamLaw2.jpg'),
(1644,	3089,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:480;s:6:\"height\";i:305;s:4:\"file\";s:19:\"2019/02/FamLaw2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"FamLaw2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"FamLaw2-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"FamLaw2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"FamLaw2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"FamLaw2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1645,	3092,	'_wp_attached_file',	'2019/02/CSupport7.jpg'),
(1646,	3092,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:352;s:6:\"height\";i:330;s:4:\"file\";s:21:\"2019/02/CSupport7.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"CSupport7-300x281.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:281;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"CSupport7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"CSupport7-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1647,	3098,	'_wp_attached_file',	'2019/02/Roundabout.jpg'),
(1648,	3098,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:235;s:6:\"height\";i:251;s:4:\"file\";s:22:\"2019/02/Roundabout.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Roundabout-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"Roundabout-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"Roundabout-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"Roundabout-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1649,	3100,	'_wp_attached_file',	'2019/02/Div17.jpg'),
(1650,	3100,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:257;s:6:\"height\";i:269;s:4:\"file\";s:17:\"2019/02/Div17.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Div17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:17:\"Div17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:17:\"Div17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:17:\"Div17-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1651,	3118,	'_wp_attached_file',	'2019/03/Marriage2-e1551891215525.jpg'),
(1652,	3118,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:297;s:6:\"height\";i:306;s:4:\"file\";s:36:\"2019/03/Marriage2-e1551891215525.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"Marriage2-e1551891215525-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"Marriage2-e1551891215525-291x300.jpg\";s:5:\"width\";i:291;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:36:\"Marriage2-e1551891215525-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:36:\"Marriage2-e1551891215525-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:36:\"Marriage2-e1551891215525-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1653,	3118,	'_wp_attachment_backup_sizes',	'a:6:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:456;s:6:\"height\";i:313;s:4:\"file\";s:13:\"Marriage2.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:21:\"Marriage2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:21:\"Marriage2-300x206.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"post-thumbnail-orig\";a:4:{s:4:\"file\";s:21:\"Marriage2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"postThumbMult-orig\";a:4:{s:4:\"file\";s:21:\"Marriage2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"postThumbSingle-orig\";a:4:{s:4:\"file\";s:21:\"Marriage2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}'),
(1654,	3120,	'_wp_attached_file',	'2019/03/Custody3.jpg'),
(1655,	3120,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:459;s:6:\"height\";i:328;s:4:\"file\";s:20:\"2019/03/Custody3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Custody3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Custody3-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Custody3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Custody3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Custody3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1656,	3142,	'_wp_attached_file',	'2019/03/ParentPlan.jpg'),
(1657,	3142,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:480;s:6:\"height\";i:298;s:4:\"file\";s:22:\"2019/03/ParentPlan.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"ParentPlan-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"ParentPlan-300x186.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:186;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"ParentPlan-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"ParentPlan-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"ParentPlan-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1658,	3145,	'_wp_attached_file',	'2019/03/Autopilot2.jpg'),
(1659,	3145,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:488;s:6:\"height\";i:318;s:4:\"file\";s:22:\"2019/03/Autopilot2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Autopilot2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Autopilot2-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"Autopilot2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"Autopilot2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"Autopilot2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1660,	3169,	'_wp_attached_file',	'2019/03/CarAccClaim.jpg'),
(1661,	3169,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:242;s:6:\"height\";i:257;s:4:\"file\";s:23:\"2019/03/CarAccClaim.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"CarAccClaim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"CarAccClaim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"CarAccClaim-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"CarAccClaim-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1662,	3171,	'_wp_attached_file',	'2019/03/Family2-e1553011649550.jpg'),
(1663,	3171,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:342;s:6:\"height\";i:266;s:4:\"file\";s:34:\"2019/03/Family2-e1553011649550.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"Family2-e1553011649550-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"Family2-e1553011649550-300x233.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:233;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:34:\"Family2-e1553011649550-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:34:\"Family2-e1553011649550-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:34:\"Family2-e1553011649550-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1664,	3171,	'_wp_attachment_backup_sizes',	'a:6:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:494;s:6:\"height\";i:280;s:4:\"file\";s:11:\"Family2.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:19:\"Family2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:19:\"Family2-300x170.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:170;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"post-thumbnail-orig\";a:4:{s:4:\"file\";s:19:\"Family2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"postThumbMult-orig\";a:4:{s:4:\"file\";s:19:\"Family2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"postThumbSingle-orig\";a:4:{s:4:\"file\";s:19:\"Family2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}'),
(1665,	3184,	'_wp_attached_file',	'2019/03/Div5.jpg'),
(1666,	3184,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:399;s:6:\"height\";i:246;s:4:\"file\";s:16:\"2019/03/Div5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"Div5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"Div5-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"Div5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"Div5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"Div5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1667,	3186,	'_wp_attached_file',	'2019/03/Alimony_Rings.jpg'),
(1668,	3186,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:222;s:6:\"height\";i:249;s:4:\"file\";s:25:\"2019/03/Alimony_Rings.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Alimony_Rings-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"Alimony_Rings-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:25:\"Alimony_Rings-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:25:\"Alimony_Rings-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1669,	3200,	'_wp_attached_file',	'2019/04/Paternity3.jpg'),
(1670,	3200,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:414;s:6:\"height\";i:348;s:4:\"file\";s:22:\"2019/04/Paternity3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Paternity3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Paternity3-300x252.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:252;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"Paternity3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"Paternity3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"Paternity3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1671,	3202,	'_wp_attached_file',	'2019/04/SocialM.jpg'),
(1672,	3202,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:230;s:6:\"height\";i:284;s:4:\"file\";s:19:\"2019/04/SocialM.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"SocialM-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"SocialM-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"SocialM-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"SocialM-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1673,	3226,	'_wp_attached_file',	'2019/04/CSupport8.jpg'),
(1674,	3226,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:313;s:6:\"height\";i:326;s:4:\"file\";s:21:\"2019/04/CSupport8.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"CSupport8-288x300.jpg\";s:5:\"width\";i:288;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"CSupport8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"CSupport8-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1675,	3230,	'_wp_attached_file',	'2019/04/Div20.jpg'),
(1676,	3230,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:219;s:6:\"height\";i:244;s:4:\"file\";s:17:\"2019/04/Div20.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Div20-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:17:\"Div20-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:17:\"Div20-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:17:\"Div20-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1677,	3233,	'_wp_attached_file',	'2019/04/CarCrash3.jpg'),
(1678,	3233,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:477;s:6:\"height\";i:316;s:4:\"file\";s:21:\"2019/04/CarCrash3.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"CarCrash3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"CarCrash3-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"CarCrash3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"CarCrash3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"CarCrash3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1679,	3236,	'_wp_attached_file',	'2019/04/Div_alcohol.jpg'),
(1680,	3236,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:146;s:6:\"height\";i:190;s:4:\"file\";s:23:\"2019/04/Div_alcohol.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Div_alcohol-146x150.jpg\";s:5:\"width\";i:146;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"Div_alcohol-146x150.jpg\";s:5:\"width\";i:146;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"Div_alcohol-146x150.jpg\";s:5:\"width\";i:146;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1681,	3263,	'_wp_attached_file',	'2019/04/CSupport9.jpg'),
(1682,	3263,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:213;s:6:\"height\";i:217;s:4:\"file\";s:21:\"2019/04/CSupport9.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"CSupport9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"CSupport9-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1683,	3265,	'_wp_attached_file',	'2019/04/Annulment.jpg'),
(1684,	3265,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:487;s:6:\"height\";i:326;s:4:\"file\";s:21:\"2019/04/Annulment.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Annulment-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"Annulment-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"Annulment-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"Annulment-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"Annulment-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1685,	3284,	'_wp_attached_file',	'2019/04/Prenup8.jpg'),
(1686,	3284,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:243;s:6:\"height\";i:267;s:4:\"file\";s:19:\"2019/04/Prenup8.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Prenup8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"Prenup8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"Prenup8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"Prenup8-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1687,	3286,	'_wp_attached_file',	'2019/04/Custody4.jpg'),
(1688,	3286,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:480;s:6:\"height\";i:318;s:4:\"file\";s:20:\"2019/04/Custody4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Custody4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Custody4-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Custody4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Custody4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Custody4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1689,	3313,	'_wp_attached_file',	'2019/05/Alimony4.jpg'),
(1690,	3313,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:365;s:6:\"height\";i:354;s:4:\"file\";s:20:\"2019/05/Alimony4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Alimony4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Alimony4-300x291.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:291;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Alimony4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Alimony4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Alimony4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1691,	3316,	'_wp_attached_file',	'2019/05/CarAcc5.jpg'),
(1692,	3316,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:478;s:6:\"height\";i:312;s:4:\"file\";s:19:\"2019/05/CarAcc5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"CarAcc5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"CarAcc5-300x196.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"CarAcc5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"CarAcc5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"CarAcc5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1693,	3327,	'_wp_attached_file',	'2019/05/Kimberly_Burchins.jpg'),
(1694,	3327,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:240;s:4:\"file\";s:29:\"2019/05/Kimberly_Burchins.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"Kimberly_Burchins-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:29:\"Kimberly_Burchins-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:29:\"Kimberly_Burchins-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:29:\"Kimberly_Burchins-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:13:\"iPhone 8 Plus\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1557477890\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"6.6\";s:3:\"iso\";s:3:\"320\";s:13:\"shutter_speed\";s:17:\"0.033333333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(1695,	3338,	'_wp_attached_file',	'2019/05/FatherDaughter.jpg'),
(1696,	3338,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:251;s:6:\"height\";i:294;s:4:\"file\";s:26:\"2019/05/FatherDaughter.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"FatherDaughter-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"FatherDaughter-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:26:\"FatherDaughter-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:26:\"FatherDaughter-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1697,	3340,	'_wp_attached_file',	'2019/05/ChildMoving.jpg'),
(1698,	3340,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:465;s:6:\"height\";i:293;s:4:\"file\";s:23:\"2019/05/ChildMoving.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"ChildMoving-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"ChildMoving-300x189.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:189;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"ChildMoving-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"ChildMoving-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"ChildMoving-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1699,	3350,	'_wp_attached_file',	'2019/05/CSupport5.jpg'),
(1700,	3350,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:478;s:6:\"height\";i:270;s:4:\"file\";s:21:\"2019/05/CSupport5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"CSupport5-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"CSupport5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"CSupport5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"CSupport5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1701,	3352,	'_wp_attached_file',	'2019/05/Depressed.jpg'),
(1702,	3352,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:183;s:6:\"height\";i:240;s:4:\"file\";s:21:\"2019/05/Depressed.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Depressed-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"Depressed-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"Depressed-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"Depressed-183x200.jpg\";s:5:\"width\";i:183;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1703,	3371,	'_wp_attached_file',	'2019/05/Accident5.jpg'),
(1704,	3371,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:447;s:6:\"height\";i:288;s:4:\"file\";s:21:\"2019/05/Accident5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Accident5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"Accident5-300x193.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:193;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"Accident5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"Accident5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"Accident5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1705,	3373,	'_wp_attached_file',	'2019/05/Div19.jpg'),
(1706,	3373,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:245;s:6:\"height\";i:258;s:4:\"file\";s:17:\"2019/05/Div19.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Div19-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:17:\"Div19-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:17:\"Div19-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:17:\"Div19-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1707,	3384,	'_wp_attached_file',	'2019/06/PetCustody.jpg'),
(1708,	3384,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:182;s:6:\"height\";i:224;s:4:\"file\";s:22:\"2019/06/PetCustody.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"PetCustody-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"PetCustody-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"PetCustody-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"PetCustody-182x200.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1709,	3387,	'_wp_attached_file',	'2019/06/DivWords.jpg'),
(1710,	3387,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:144;s:6:\"height\";i:158;s:4:\"file\";s:20:\"2019/06/DivWords.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DivWords-144x150.jpg\";s:5:\"width\";i:144;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"DivWords-144x150.jpg\";s:5:\"width\";i:144;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"DivWords-144x150.jpg\";s:5:\"width\";i:144;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1711,	3411,	'_wp_attached_file',	'2019/06/Alimony10.jpg'),
(1712,	3411,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:203;s:6:\"height\";i:263;s:4:\"file\";s:21:\"2019/06/Alimony10.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Alimony10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"Alimony10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"Alimony10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"Alimony10-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1713,	3413,	'_wp_attached_file',	'2019/06/DivMoney.jpg'),
(1714,	3413,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:493;s:6:\"height\";i:301;s:4:\"file\";s:20:\"2019/06/DivMoney.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"DivMoney-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"DivMoney-300x183.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:183;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"DivMoney-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"DivMoney-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"DivMoney-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1715,	3429,	'_wp_attached_file',	'2019/06/Motorcycle7.jpg'),
(1716,	3429,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:196;s:6:\"height\";i:234;s:4:\"file\";s:23:\"2019/06/Motorcycle7.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"Motorcycle7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"Motorcycle7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"Motorcycle7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"Motorcycle7-196x200.jpg\";s:5:\"width\";i:196;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1717,	3431,	'_wp_attached_file',	'2019/06/FamCourt.jpg'),
(1718,	3431,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:218;s:6:\"height\";i:244;s:4:\"file\";s:20:\"2019/06/FamCourt.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"FamCourt-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"FamCourt-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"FamCourt-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"FamCourt-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1719,	3442,	'_wp_attached_file',	'2019/06/FatherSon.jpg'),
(1720,	3442,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:276;s:6:\"height\";i:306;s:4:\"file\";s:21:\"2019/06/FatherSon.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"FatherSon-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"FatherSon-271x300.jpg\";s:5:\"width\";i:271;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"FatherSon-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"FatherSon-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"FatherSon-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1721,	3444,	'_wp_attached_file',	'2019/06/DivorcePlan.jpg'),
(1722,	3444,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:380;s:6:\"height\";i:354;s:4:\"file\";s:23:\"2019/06/DivorcePlan.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"DivorcePlan-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"DivorcePlan-300x279.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:279;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"DivorcePlan-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"DivorcePlan-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:23:\"DivorcePlan-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1723,	3483,	'_wp_attached_file',	'2019/07/Prenup5.jpg'),
(1724,	3483,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:292;s:6:\"height\";i:327;s:4:\"file\";s:19:\"2019/07/Prenup5.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Prenup5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"Prenup5-268x300.jpg\";s:5:\"width\";i:268;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"Prenup5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"Prenup5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"Prenup5-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1725,	3486,	'_wp_attached_file',	'2019/07/Accident.jpg'),
(1726,	3486,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:489;s:6:\"height\";i:352;s:4:\"file\";s:20:\"2019/07/Accident.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"Accident-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"Accident-300x216.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:216;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"Accident-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"Accident-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"Accident-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1727,	3500,	'_wp_attached_file',	'2019/07/CSupport11.jpg'),
(1728,	3500,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:299;s:6:\"height\";i:270;s:4:\"file\";s:22:\"2019/07/CSupport11.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"CSupport11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"CSupport11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"CSupport11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"CSupport11-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1729,	3502,	'_wp_attached_file',	'2019/07/StudentDebt2-e1563376436579.jpg'),
(1730,	3502,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:327;s:6:\"height\";i:293;s:4:\"file\";s:39:\"2019/07/StudentDebt2-e1563376436579.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"StudentDebt2-e1563376436579-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"StudentDebt2-e1563376436579-300x269.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:269;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:39:\"StudentDebt2-e1563376436579-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:39:\"StudentDebt2-e1563376436579-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:39:\"StudentDebt2-e1563376436579-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1731,	3502,	'_wp_attachment_backup_sizes',	'a:6:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:496;s:6:\"height\";i:299;s:4:\"file\";s:16:\"StudentDebt2.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:24:\"StudentDebt2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:24:\"StudentDebt2-300x181.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:181;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"post-thumbnail-orig\";a:4:{s:4:\"file\";s:24:\"StudentDebt2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"postThumbMult-orig\";a:4:{s:4:\"file\";s:24:\"StudentDebt2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"postThumbSingle-orig\";a:4:{s:4:\"file\";s:24:\"StudentDebt2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}'),
(1732,	3510,	'_wp_attached_file',	'2019/07/PI_Claim2.jpg'),
(1733,	3510,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:400;s:6:\"height\";i:363;s:4:\"file\";s:21:\"2019/07/PI_Claim2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"PI_Claim2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"PI_Claim2-300x272.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"PI_Claim2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:21:\"PI_Claim2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:21:\"PI_Claim2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1734,	3512,	'_wp_attached_file',	'2019/07/Div9.jpg'),
(1735,	3512,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:466;s:6:\"height\";i:308;s:4:\"file\";s:16:\"2019/07/Div9.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"Div9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"Div9-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:16:\"Div9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:16:\"Div9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:16:\"Div9-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1736,	3522,	'_wp_attached_file',	'2019/07/MomDaughter4.jpg'),
(1737,	3522,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:403;s:6:\"height\";i:300;s:4:\"file\";s:24:\"2019/07/MomDaughter4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"MomDaughter4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"MomDaughter4-300x223.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:223;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"MomDaughter4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"MomDaughter4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"MomDaughter4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1738,	3524,	'_wp_attached_file',	'2019/07/Rings.jpg'),
(1739,	3524,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:445;s:6:\"height\";i:300;s:4:\"file\";s:17:\"2019/07/Rings.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"Rings-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"Rings-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:17:\"Rings-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:17:\"Rings-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:17:\"Rings-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1740,	3556,	'_wp_attached_file',	'2019/08/Family4.jpg'),
(1741,	3556,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:400;s:6:\"height\";i:409;s:4:\"file\";s:19:\"2019/08/Family4.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Family4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"Family4-293x300.jpg\";s:5:\"width\";i:293;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"Family4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"Family4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"Family4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1742,	3558,	'_wp_attached_file',	'2019/08/DivDecr.jpg'),
(1743,	3558,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:487;s:6:\"height\";i:321;s:4:\"file\";s:19:\"2019/08/DivDecr.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"DivDecr-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"DivDecr-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"DivDecr-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"DivDecr-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"DivDecr-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1749,	30,	'_title',	'Firm Overview | Pawlowski Mastrilli Law Group'),
(1750,	30,	'_description',	'The Pawlowski//Mastrilli Law Group was founded here in Tampa in 1995 by exceptionally experienced attorneys.'),
(1751,	30,	'_keywords',	''),
(1752,	30,	'_subslideID',	'1'),
(1760,	46,	'_title',	'Personal Injury'),
(1761,	46,	'_description',	'Our skilled and knowledgeable personal injury lawyers utilize a wide range of resources and fight to ensure the best possible outcome for your case.'),
(1762,	46,	'_keywords',	'Tampa Personal Injury Lawyer'),
(1763,	46,	'_subslideID',	'4'),
(1764,	48,	'_title',	'Tampa Car Accident Lawyer'),
(1765,	48,	'_description',	'The Tampa car accident lawyers at The Pawlowski//Mastrilli Law Group are skilled and experienced lawyers who can provide protection and will fight for your rights.'),
(1766,	48,	'_keywords',	'Tampa Car Accident Lawyer'),
(1767,	48,	'_subslideID',	'6'),
(1768,	50,	'_title',	'Tampa Uninsured Motorist Lawyer'),
(1769,	50,	'_description',	'The experienced Tampa uninsured accident lawyers at The Pawlowski//Mastrilli Law Group can assist you in your quest to get a settlement or damages that are fair.'),
(1770,	50,	'_keywords',	'Tampa Uninsured Motorist Lawyer'),
(1771,	50,	'aFhfc_head_code',	''),
(1772,	50,	'aFhfc_footer_code',	''),
(1773,	56,	'_title',	'Tampa Truck Accident Lawyer'),
(1774,	56,	'_description',	'There are roughly 500,000 truck accidents each year. contact our experienced Tampa truck accident lawyers today.'),
(1775,	56,	'_keywords',	'Tampa Truck Accident Lawyer'),
(1776,	56,	'aFhfc_head_code',	''),
(1777,	56,	'aFhfc_footer_code',	''),
(1778,	60,	'_title',	'Tampa Motorcycle Accident Lawyer'),
(1779,	60,	'_description',	'The risk of being involved in an accident on the road is compounded if you are on a motorcycle, contact our Tampa motorcycle accident lawyers today.'),
(1780,	60,	'_keywords',	'Tampa Motorcycle Accident Lawyer'),
(1781,	60,	'aFhfc_head_code',	''),
(1782,	60,	'aFhfc_footer_code',	''),
(1783,	62,	'_title',	'Tampa Defective Product Lawyer'),
(1784,	62,	'_description',	'When you invest in a product, you inherently trust it will work as intended, when something goes wrong contact our Tampa defective product lawyers..'),
(1785,	62,	'_keywords',	'Tampa Defective Products Lawyer'),
(1786,	62,	'aFhfc_head_code',	''),
(1787,	62,	'aFhfc_footer_code',	''),
(1788,	64,	'_title',	'Tampa Pharmaceutical & Medication Injury Lawyer'),
(1789,	64,	'_description',	'If you experience medication error or injury contact our Tampa pharmaceutical & medication injury lawyers.'),
(1790,	64,	'_keywords',	'Tampa Pharmaceutical & Medication Injury Lawyer'),
(1791,	64,	'aFhfc_head_code',	''),
(1792,	64,	'aFhfc_footer_code',	''),
(1793,	70,	'_title',	'Tampa Premises Liability Lawyer'),
(1794,	70,	'_description',	'Our Tampa premises liability lawyers help Florida premises liability victims recover compensation for slip & fall & dog bites.'),
(1795,	70,	'_keywords',	'Tampa Premises Liability Lawyer'),
(1798,	72,	'_title',	'Tampa Nursing Home Abuse Lawyer'),
(1799,	72,	'_description',	'Our Tampa nursing home abuse lawyers know that families expect their loved ones will be cared for by professional and qualified caretakers.'),
(1800,	72,	'_keywords',	'Tampa Nursing Home Neglect Lawyer'),
(1801,	72,	'aFhfc_head_code',	''),
(1802,	72,	'aFhfc_footer_code',	''),
(1803,	74,	'_title',	'Tampa Airplane Accident Lawyer'),
(1804,	74,	'_description',	'While the NTSB investigates all commercial and private aviation accidents, it is our Tampa airplane accident lawyers who will fight to protect your rights.'),
(1805,	74,	'_keywords',	'Tampa Airplane Accident Lawyer'),
(1806,	74,	'aFhfc_head_code',	''),
(1807,	74,	'aFhfc_footer_code',	''),
(1808,	76,	'_title',	'Tampa Insurance Bad Faith Lawyer'),
(1809,	76,	'_description',	'Our Tampa insurance bad faith lawyers have years of experience successfully holding those guilty of Bad Faith accountable and winning compensation.'),
(1810,	76,	'_keywords',	'Tampa Insurance Bad Faith Lawyer'),
(1811,	76,	'aFhfc_head_code',	''),
(1812,	76,	'aFhfc_footer_code',	''),
(1813,	78,	'_title',	'Tampa Catastrophic Injury Lawyer'),
(1814,	78,	'_description',	'Our Tampa catastrophic injury lawyers are dedicated to fighting for the rights of our clients and ensuring a fair and necessary amount of compensation.'),
(1815,	78,	'_keywords',	'Tamap Catastrophic Injury Lawyer'),
(1816,	78,	'aFhfc_head_code',	''),
(1817,	78,	'aFhfc_footer_code',	''),
(1818,	80,	'_title',	'Tampa Wrongful Death Lawyer'),
(1819,	80,	'_description',	'A wrongful death suit may help garner monetary damages on behalf of surviving family, contact our experienced Tampa wrongful death lawyers.'),
(1820,	80,	'_keywords',	'Tampa Wrongful Death Lawyer'),
(1821,	80,	'aFhfc_head_code',	''),
(1822,	80,	'aFhfc_footer_code',	''),
(1823,	82,	'_title',	'Tampa Criminal Lawyer'),
(1824,	82,	'_description',	'Contact our Tampa criminal lawyers for issues involving drug crimes, DUI, felony, misdemeanor, gun charges, license and traffic violations & more.'),
(1825,	82,	'_keywords',	'Tampa Criminal Lawyer'),
(1826,	338,	'_title',	'Blog | Pawlowski Mastrilli Law Group'),
(1827,	338,	'_description',	'View our articles and blog posts and contact our Tampa personal injury and criminal defense attorneys any time.'),
(1828,	338,	'_keywords',	''),
(1829,	338,	'aFhfc_head_code',	''),
(1830,	338,	'aFhfc_footer_code',	''),
(1831,	2472,	'_title',	'Pawlowski//Mastrilli Law Group'),
(1832,	2472,	'_description',	'Our Tampa lawyers can help whether you have been injured in a car, truck or motorcycle accident, work accident, or other unfortunate reason.'),
(1833,	2472,	'_keywords',	'Tampa Injury & Accident Lawyer'),
(1834,	2473,	'_description',	'Please give us a call or contact us via email using our contact form.'),
(1835,	2473,	'_title',	'Contact Us | Pawlowski Mastrilli Law Group'),
(1836,	2473,	'_keywords',	''),
(1837,	2473,	'_subslideID',	''),
(1838,	2474,	'_title',	'Disclaimer | Pawlowski Mastrilli Law Group'),
(1839,	2476,	'_title',	'Site Map | Pawlowski Mastrilli Law Group'),
(1840,	52,	'_title',	'Tampa DUI Accident Lawyer'),
(1841,	52,	'_description',	'Our Tampa DUI accident lawyers help Florida drunk driving auto accident victims recover compensation for their injuries.'),
(1842,	52,	'_keywords',	'Tampa DUI Accident Lawyer'),
(1850,	66,	'_title',	'Tampa Medical Malpractice Lawyer'),
(1851,	66,	'_description',	'Our Tampa medical malpractice lawyers help victims of Florida medical malpractice recover for surgical errors & medical mistakes.'),
(1852,	66,	'_keywords',	'Tampa Medical Malpractice Lawyer'),
(1855,	68,	'_title',	'Tampa Workplace Accident Lawyer'),
(1856,	68,	'_description',	'Our Tampa workplace accident injury lawyers help workplace accident victims recover Florida workers\' compensation & other damages.'),
(1857,	68,	'_keywords',	'Tampa Workplace Accident Lawyer'),
(1860,	84,	'_title',	'Tampa Drug Crime Lawyer'),
(1861,	84,	'_description',	'Florida has some of the toughest drug laws in the United States, contact our experienced Tampa drug crime defense lawyers.'),
(1862,	84,	'_keywords',	'Tampa Drug Crime Lawyer'),
(1863,	84,	'aFhfc_head_code',	''),
(1864,	84,	'aFhfc_footer_code',	''),
(1865,	86,	'_title',	'Tampa DUI Defense Lawyer'),
(1866,	86,	'_description',	'DUI laws are very strict in Florida, contact our experienced Tampa DUI lawyers for aggressive DUI defense.'),
(1867,	86,	'_keywords',	'Tampa DUI Defense Lawyer'),
(1868,	86,	'aFhfc_head_code',	''),
(1869,	86,	'aFhfc_footer_code',	''),
(1870,	88,	'_title',	'Tampa Felony Lawyer'),
(1871,	88,	'_description',	'A felony conviction of any kind can have serious consequences on every aspect of your life, contact our Tampa felony defense lawyers.'),
(1872,	88,	'_keywords',	'Tampa Felony Defense Lawyer'),
(1873,	88,	'aFhfc_head_code',	''),
(1874,	88,	'aFhfc_footer_code',	''),
(1875,	90,	'_title',	'Tampa Misdemeanor Lawyer'),
(1876,	90,	'_description',	'Our Tampa misdemeanor lawyers have the experience and dedication needed to help make sure your misdemeanor case is handled in the best possible way.'),
(1877,	90,	'_keywords',	'Tampa Misdemeanor Lawyer'),
(1878,	90,	'aFhfc_head_code',	''),
(1879,	90,	'aFhfc_footer_code',	''),
(1880,	92,	'_title',	'Tampa Gun & Weapon Crime Lawyer'),
(1881,	92,	'_description',	'Gun and weapons charges in Florida can yield serious legal consequences, contact our Tampa gun crime lawyers.'),
(1882,	92,	'_keywords',	'Tampa Gun & Weapon Crime Lawyer'),
(1883,	92,	'aFhfc_head_code',	''),
(1884,	92,	'aFhfc_footer_code',	''),
(1885,	94,	'_title',	'Tampa License Suspension Lawyer'),
(1886,	94,	'_description',	'If you are pulled over or in an accident while your license is suspended, revoked, or cancelled in Florida, contact our Tampa license suspension lawyers.'),
(1887,	94,	'_keywords',	'Tampa License Suspension Lawyer'),
(1888,	94,	'aFhfc_head_code',	''),
(1889,	94,	'aFhfc_footer_code',	''),
(1890,	96,	'_title',	'Tampa Traffic Violation Lawyer'),
(1891,	96,	'_description',	'Our Tampa traffic violation lawyers can take on your case and do all we can to ensure your traffic ticket citation has a minimal impact.'),
(1892,	96,	'_keywords',	'Tampa Traffic Violation Lawyer'),
(1893,	96,	'aFhfc_head_code',	''),
(1894,	96,	'aFhfc_footer_code',	''),
(1895,	427,	'_title',	'Tampa Family Lawyer'),
(1896,	427,	'_description',	'Our experienced Tampa family & divorce lawyers can help your through tough times, contact us today.'),
(1897,	427,	'_keywords',	'Tampa Family Lawyer'),
(1898,	427,	'aFhfc_head_code',	''),
(1899,	427,	'aFhfc_footer_code',	''),
(1900,	2279,	'_title',	'Download Our App | Pawlowski Mastrilli Law Group'),
(1901,	2279,	'_description',	'Download our app for iPhone or Android.'),
(1902,	2279,	'_keywords',	''),
(1903,	2279,	'_subslideID',	''),
(1904,	2279,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2018/04/google-play.png\";s:5:\"title\";s:11:\"google-play\";s:7:\"caption\";s:0:\"\";}'),
(1905,	2279,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2018/04/apple-store.png\";s:5:\"title\";s:11:\"apple-store\";s:7:\"caption\";s:0:\"\";}'),
(1906,	3562,	'_menu_item_type',	'post_type'),
(1907,	3562,	'_menu_item_menu_item_parent',	'0'),
(1908,	3562,	'_menu_item_object_id',	'2476'),
(1909,	3562,	'_menu_item_object',	'page'),
(1910,	3562,	'_menu_item_target',	''),
(1911,	3562,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1912,	3562,	'_menu_item_xfn',	''),
(1913,	3562,	'_menu_item_url',	''),
(1914,	3563,	'_menu_item_type',	'post_type'),
(1915,	3563,	'_menu_item_menu_item_parent',	'0'),
(1916,	3563,	'_menu_item_object_id',	'2472'),
(1917,	3563,	'_menu_item_object',	'page'),
(1918,	3563,	'_menu_item_target',	''),
(1919,	3563,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1920,	3563,	'_menu_item_xfn',	''),
(1921,	3563,	'_menu_item_url',	''),
(1922,	3564,	'_menu_item_type',	'post_type'),
(1923,	3564,	'_menu_item_menu_item_parent',	'0'),
(1924,	3564,	'_menu_item_object_id',	'30'),
(1925,	3564,	'_menu_item_object',	'page'),
(1926,	3564,	'_menu_item_target',	''),
(1927,	3564,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1928,	3564,	'_menu_item_xfn',	'nofollow'),
(1929,	3564,	'_menu_item_url',	''),
(1930,	3565,	'_menu_item_type',	'post_type'),
(1931,	3565,	'_menu_item_menu_item_parent',	'4399'),
(1932,	3565,	'_menu_item_object_id',	'46'),
(1933,	3565,	'_menu_item_object',	'page'),
(1934,	3565,	'_menu_item_target',	''),
(1935,	3565,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1936,	3565,	'_menu_item_xfn',	''),
(1937,	3565,	'_menu_item_url',	''),
(1938,	3021,	'_title',	'Tampa Hurricane Damage Lawyer'),
(1939,	3021,	'_description',	'At The Pawlowski//Mastrilli Law Group, our top-rated Tampa hurricane daTage lawyers are dedicated advocates for policyholders.'),
(1940,	3021,	'_keywords',	'Tampa Hurricane Damage Lawyer'),
(1941,	3021,	'_subslideID',	'8'),
(1946,	3566,	'_menu_item_type',	'post_type'),
(1947,	3566,	'_menu_item_menu_item_parent',	'4400'),
(1948,	3566,	'_menu_item_object_id',	'82'),
(1949,	3566,	'_menu_item_object',	'page'),
(1950,	3566,	'_menu_item_target',	''),
(1951,	3566,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1952,	3566,	'_menu_item_xfn',	''),
(1953,	3566,	'_menu_item_url',	''),
(1954,	3567,	'_menu_item_type',	'post_type'),
(1955,	3567,	'_menu_item_menu_item_parent',	'0'),
(1956,	3567,	'_menu_item_object_id',	'2473'),
(1957,	3567,	'_menu_item_object',	'page'),
(1958,	3567,	'_menu_item_target',	''),
(1959,	3567,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1960,	3567,	'_menu_item_xfn',	'nofollow'),
(1961,	3567,	'_menu_item_url',	''),
(1962,	3568,	'_menu_item_type',	'post_type'),
(1963,	3568,	'_menu_item_menu_item_parent',	'0'),
(1964,	3568,	'_menu_item_object_id',	'2474'),
(1965,	3568,	'_menu_item_object',	'page'),
(1966,	3568,	'_menu_item_target',	''),
(1967,	3568,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1968,	3568,	'_menu_item_xfn',	'nofollow'),
(1969,	3568,	'_menu_item_url',	''),
(1970,	3569,	'_menu_item_type',	'post_type'),
(1971,	3569,	'_menu_item_menu_item_parent',	'0'),
(1972,	3569,	'_menu_item_object_id',	'48'),
(1973,	3569,	'_menu_item_object',	'page'),
(1974,	3569,	'_menu_item_target',	''),
(1975,	3569,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1976,	3569,	'_menu_item_xfn',	''),
(1977,	3569,	'_menu_item_url',	''),
(1978,	3570,	'_menu_item_type',	'post_type'),
(1979,	3570,	'_menu_item_menu_item_parent',	'0'),
(1980,	3570,	'_menu_item_object_id',	'74'),
(1981,	3570,	'_menu_item_object',	'page'),
(1982,	3570,	'_menu_item_target',	''),
(1983,	3570,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1984,	3570,	'_menu_item_xfn',	''),
(1985,	3570,	'_menu_item_url',	''),
(1986,	3571,	'_menu_item_type',	'post_type'),
(1987,	3571,	'_menu_item_menu_item_parent',	'0'),
(1988,	3571,	'_menu_item_object_id',	'76'),
(1989,	3571,	'_menu_item_object',	'page'),
(1990,	3571,	'_menu_item_target',	''),
(1991,	3571,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(1992,	3571,	'_menu_item_xfn',	''),
(1993,	3571,	'_menu_item_url',	''),
(1994,	3572,	'_menu_item_type',	'post_type'),
(1995,	3572,	'_menu_item_menu_item_parent',	'0'),
(1996,	3572,	'_menu_item_object_id',	'62'),
(1997,	3572,	'_menu_item_object',	'page'),
(1998,	3572,	'_menu_item_target',	''),
(1999,	3572,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2000,	3572,	'_menu_item_xfn',	''),
(2001,	3572,	'_menu_item_url',	''),
(2002,	3573,	'_menu_item_type',	'post_type'),
(2003,	3573,	'_menu_item_menu_item_parent',	'0'),
(2004,	3573,	'_menu_item_object_id',	'60'),
(2005,	3573,	'_menu_item_object',	'page'),
(2006,	3573,	'_menu_item_target',	''),
(2007,	3573,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2008,	3573,	'_menu_item_xfn',	''),
(2009,	3573,	'_menu_item_url',	''),
(2010,	3574,	'_menu_item_type',	'post_type'),
(2011,	3574,	'_menu_item_menu_item_parent',	'0'),
(2012,	3574,	'_menu_item_object_id',	'78'),
(2013,	3574,	'_menu_item_object',	'page'),
(2014,	3574,	'_menu_item_target',	''),
(2015,	3574,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2016,	3574,	'_menu_item_xfn',	''),
(2017,	3574,	'_menu_item_url',	''),
(2018,	3575,	'_menu_item_type',	'post_type'),
(2019,	3575,	'_menu_item_menu_item_parent',	'0'),
(2020,	3575,	'_menu_item_object_id',	'72'),
(2021,	3575,	'_menu_item_object',	'page'),
(2022,	3575,	'_menu_item_target',	''),
(2023,	3575,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2024,	3575,	'_menu_item_xfn',	''),
(2025,	3575,	'_menu_item_url',	''),
(2026,	3576,	'_menu_item_type',	'post_type'),
(2027,	3576,	'_menu_item_menu_item_parent',	'0'),
(2028,	3576,	'_menu_item_object_id',	'70'),
(2029,	3576,	'_menu_item_object',	'page'),
(2030,	3576,	'_menu_item_target',	''),
(2031,	3576,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2032,	3576,	'_menu_item_xfn',	''),
(2033,	3576,	'_menu_item_url',	''),
(2034,	3577,	'_menu_item_type',	'post_type'),
(2035,	3577,	'_menu_item_menu_item_parent',	'0'),
(2036,	3577,	'_menu_item_object_id',	'64'),
(2037,	3577,	'_menu_item_object',	'page'),
(2038,	3577,	'_menu_item_target',	''),
(2039,	3577,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2040,	3577,	'_menu_item_xfn',	''),
(2041,	3577,	'_menu_item_url',	''),
(2042,	3578,	'_menu_item_type',	'post_type'),
(2043,	3578,	'_menu_item_menu_item_parent',	'0'),
(2044,	3578,	'_menu_item_object_id',	'56'),
(2045,	3578,	'_menu_item_object',	'page'),
(2046,	3578,	'_menu_item_target',	''),
(2047,	3578,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2048,	3578,	'_menu_item_xfn',	''),
(2049,	3578,	'_menu_item_url',	''),
(2050,	3579,	'_menu_item_type',	'post_type'),
(2051,	3579,	'_menu_item_menu_item_parent',	'0'),
(2052,	3579,	'_menu_item_object_id',	'50'),
(2053,	3579,	'_menu_item_object',	'page'),
(2054,	3579,	'_menu_item_target',	''),
(2055,	3579,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2056,	3579,	'_menu_item_xfn',	''),
(2057,	3579,	'_menu_item_url',	''),
(2058,	3580,	'_menu_item_type',	'post_type'),
(2059,	3580,	'_menu_item_menu_item_parent',	'0'),
(2060,	3580,	'_menu_item_object_id',	'80'),
(2061,	3580,	'_menu_item_object',	'page'),
(2062,	3580,	'_menu_item_target',	''),
(2063,	3580,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2064,	3580,	'_menu_item_xfn',	''),
(2065,	3580,	'_menu_item_url',	''),
(2066,	3581,	'_menu_item_type',	'post_type'),
(2067,	3581,	'_menu_item_menu_item_parent',	'0'),
(2068,	3581,	'_menu_item_object_id',	'338'),
(2069,	3581,	'_menu_item_object',	'page'),
(2070,	3581,	'_menu_item_target',	''),
(2071,	3581,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2072,	3581,	'_menu_item_xfn',	''),
(2073,	3581,	'_menu_item_url',	''),
(2074,	3582,	'_menu_item_type',	'post_type'),
(2075,	3582,	'_menu_item_menu_item_parent',	'0'),
(2076,	3582,	'_menu_item_object_id',	'84'),
(2077,	3582,	'_menu_item_object',	'page'),
(2078,	3582,	'_menu_item_target',	''),
(2079,	3582,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2080,	3582,	'_menu_item_xfn',	''),
(2081,	3582,	'_menu_item_url',	''),
(2082,	3583,	'_menu_item_type',	'post_type'),
(2083,	3583,	'_menu_item_menu_item_parent',	'0'),
(2084,	3583,	'_menu_item_object_id',	'86'),
(2085,	3583,	'_menu_item_object',	'page'),
(2086,	3583,	'_menu_item_target',	''),
(2087,	3583,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2088,	3583,	'_menu_item_xfn',	''),
(2089,	3583,	'_menu_item_url',	''),
(2090,	3584,	'_menu_item_type',	'post_type'),
(2091,	3584,	'_menu_item_menu_item_parent',	'0'),
(2092,	3584,	'_menu_item_object_id',	'88'),
(2093,	3584,	'_menu_item_object',	'page'),
(2094,	3584,	'_menu_item_target',	''),
(2095,	3584,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2096,	3584,	'_menu_item_xfn',	''),
(2097,	3584,	'_menu_item_url',	''),
(2098,	3585,	'_menu_item_type',	'post_type'),
(2099,	3585,	'_menu_item_menu_item_parent',	'0'),
(2100,	3585,	'_menu_item_object_id',	'92'),
(2101,	3585,	'_menu_item_object',	'page'),
(2102,	3585,	'_menu_item_target',	''),
(2103,	3585,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2104,	3585,	'_menu_item_xfn',	''),
(2105,	3585,	'_menu_item_url',	''),
(2106,	3586,	'_menu_item_type',	'post_type'),
(2107,	3586,	'_menu_item_menu_item_parent',	'0'),
(2108,	3586,	'_menu_item_object_id',	'94'),
(2109,	3586,	'_menu_item_object',	'page'),
(2110,	3586,	'_menu_item_target',	''),
(2111,	3586,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2112,	3586,	'_menu_item_xfn',	''),
(2113,	3586,	'_menu_item_url',	''),
(2114,	3587,	'_menu_item_type',	'post_type'),
(2115,	3587,	'_menu_item_menu_item_parent',	'0'),
(2116,	3587,	'_menu_item_object_id',	'96'),
(2117,	3587,	'_menu_item_object',	'page'),
(2118,	3587,	'_menu_item_target',	''),
(2119,	3587,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2120,	3587,	'_menu_item_xfn',	''),
(2121,	3587,	'_menu_item_url',	''),
(2122,	3588,	'_menu_item_type',	'post_type'),
(2123,	3588,	'_menu_item_menu_item_parent',	'4401'),
(2124,	3588,	'_menu_item_object_id',	'427'),
(2125,	3588,	'_menu_item_object',	'page'),
(2126,	3588,	'_menu_item_target',	''),
(2127,	3588,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2128,	3588,	'_menu_item_xfn',	''),
(2129,	3588,	'_menu_item_url',	''),
(2130,	3589,	'_menu_item_type',	'post_type'),
(2131,	3589,	'_menu_item_menu_item_parent',	'0'),
(2132,	3589,	'_menu_item_object_id',	'52'),
(2133,	3589,	'_menu_item_object',	'page'),
(2134,	3589,	'_menu_item_target',	''),
(2135,	3589,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2136,	3589,	'_menu_item_xfn',	''),
(2137,	3589,	'_menu_item_url',	''),
(2146,	3591,	'_menu_item_type',	'post_type'),
(2147,	3591,	'_menu_item_menu_item_parent',	'0'),
(2148,	3591,	'_menu_item_object_id',	'66'),
(2149,	3591,	'_menu_item_object',	'page'),
(2150,	3591,	'_menu_item_target',	''),
(2151,	3591,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2152,	3591,	'_menu_item_xfn',	''),
(2153,	3591,	'_menu_item_url',	''),
(2154,	3592,	'_menu_item_type',	'post_type'),
(2155,	3592,	'_menu_item_menu_item_parent',	'0'),
(2156,	3592,	'_menu_item_object_id',	'68'),
(2157,	3592,	'_menu_item_object',	'page'),
(2158,	3592,	'_menu_item_target',	''),
(2159,	3592,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2160,	3592,	'_menu_item_xfn',	''),
(2161,	3592,	'_menu_item_url',	''),
(2162,	3593,	'_menu_item_type',	'post_type'),
(2163,	3593,	'_menu_item_menu_item_parent',	'0'),
(2164,	3593,	'_menu_item_object_id',	'90'),
(2165,	3593,	'_menu_item_object',	'page'),
(2166,	3593,	'_menu_item_target',	''),
(2167,	3593,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2168,	3593,	'_menu_item_xfn',	''),
(2169,	3593,	'_menu_item_url',	''),
(2194,	3597,	'_menu_item_type',	'post_type'),
(2195,	3597,	'_menu_item_menu_item_parent',	'4398'),
(2196,	3597,	'_menu_item_object_id',	'48'),
(2197,	3597,	'_menu_item_object',	'page'),
(2198,	3597,	'_menu_item_target',	''),
(2199,	3597,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(2200,	3597,	'_menu_item_xfn',	''),
(2201,	3597,	'_menu_item_url',	''),
(2210,	39,	'_edit_lock',	'1686177319:1'),
(2211,	2472,	'_edit_lock',	'1690260682:1'),
(2212,	2279,	'_edit_lock',	'1583263511:1'),
(2213,	30,	'_edit_lock',	'1686175379:1'),
(2214,	35,	'_edit_lock',	'1686177222:1'),
(2215,	370,	'_edit_lock',	'1583261201:1'),
(2217,	3271,	'_edit_lock',	'1686245455:1'),
(2218,	74,	'_edit_lock',	'1594320213:3'),
(2219,	78,	'_edit_lock',	'1583261215:1'),
(2220,	46,	'_edit_lock',	'1709133239:3'),
(2221,	62,	'_edit_lock',	'1577742897:1'),
(2222,	76,	'_edit_lock',	'1583261360:1'),
(2223,	66,	'_edit_lock',	'1633395080:1'),
(2224,	72,	'_edit_lock',	'1583261225:1'),
(2225,	60,	'_edit_lock',	'1583261222:1'),
(2226,	70,	'_edit_lock',	'1633395217:1'),
(2227,	56,	'_edit_lock',	'1577743051:1'),
(2228,	64,	'_edit_lock',	'1583261373:1'),
(2229,	58,	'_edit_lock',	'1633395088:1'),
(2230,	68,	'_edit_lock',	'1633395216:1'),
(2231,	80,	'_edit_lock',	'1583261378:1'),
(2232,	48,	'_edit_lock',	'1586274895:3'),
(2233,	52,	'_edit_lock',	'1633395291:1'),
(2234,	54,	'_edit_lock',	'1633395230:1'),
(2236,	50,	'_edit_lock',	'1583261305:1'),
(2237,	82,	'_edit_lock',	'1586272048:3'),
(2238,	84,	'_edit_lock',	'1577743330:1'),
(2239,	86,	'_edit_lock',	'1583261448:1'),
(2240,	88,	'_edit_lock',	'1583261450:1'),
(2241,	92,	'_edit_lock',	'1583261314:1'),
(2242,	94,	'_edit_lock',	'1583261459:1'),
(2243,	90,	'_edit_lock',	'1583261462:1'),
(2244,	427,	'_edit_lock',	'1583261466:1'),
(2245,	96,	'_edit_lock',	'1583261464:1'),
(2246,	2694,	'_edit_lock',	'1583263171:1'),
(2247,	2696,	'_edit_lock',	'1583263172:1'),
(2248,	2697,	'_edit_lock',	'1583263101:1'),
(2249,	2695,	'_edit_lock',	'1583263172:1'),
(2250,	2687,	'_edit_lock',	'1583263020:1'),
(2252,	2555,	'_edit_lock',	'1583263321:1'),
(2253,	2690,	'_edit_lock',	'1633392613:1'),
(2254,	2684,	'_edit_lock',	'1583263016:1'),
(2255,	2685,	'_edit_lock',	'1583263017:1'),
(2256,	2698,	'_edit_lock',	'1583263102:1'),
(2257,	2682,	'_edit_lock',	'1583261469:1'),
(2258,	2699,	'_edit_lock',	'1583263102:1'),
(2259,	2691,	'_edit_lock',	'1633392798:1'),
(2260,	2686,	'_edit_lock',	'1583263019:1'),
(2261,	2708,	'_edit_lock',	'1583263317:1'),
(2262,	2627,	'_edit_lock',	'1583261468:1'),
(2263,	2701,	'_edit_lock',	'1583263256:1'),
(2264,	2705,	'_edit_lock',	'1633392661:1'),
(2265,	2702,	'_edit_lock',	'1583263258:1'),
(2266,	2688,	'_edit_lock',	'1633392798:1'),
(2267,	2700,	'_edit_lock',	'1633392799:1'),
(2268,	2704,	'_edit_lock',	'1633392799:1'),
(2269,	2689,	'_edit_lock',	'1633392798:1'),
(2270,	2683,	'_edit_lock',	'1633393509:1'),
(2271,	2703,	'_edit_lock',	'1633392798:1'),
(2272,	2710,	'_edit_lock',	'1583263319:1'),
(2273,	2693,	'_edit_lock',	'1633392798:1'),
(2274,	2692,	'_edit_lock',	'1583263148:1'),
(2275,	2609,	'_edit_lock',	'1583261467:1'),
(2276,	3021,	'_edit_lock',	'1633392661:1'),
(2277,	2612,	'_edit_lock',	'1583263198:1'),
(2279,	2473,	'_edit_lock',	'1680071447:1'),
(2281,	2474,	'_edit_lock',	'1583263508:1'),
(2282,	2475,	'_edit_lock',	'1583263510:1'),
(2283,	2474,	'_edit_last',	'1'),
(2284,	2474,	'_description',	''),
(2285,	2474,	'_keywords',	''),
(2286,	2475,	'_edit_last',	'1'),
(2287,	2475,	'_description',	''),
(2288,	2475,	'_keywords',	''),
(2298,	1033,	'_wp_attachment_image_alt',	'truck accident'),
(2307,	427,	'_subslideID',	'7'),
(2308,	82,	'_subslideID',	'5'),
(2309,	3689,	'_wp_attached_file',	'2019/09/vincent-r-pawlowski.jpg'),
(2310,	3689,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:320;s:6:\"height\";i:384;s:4:\"file\";s:31:\"2019/09/vincent-r-pawlowski.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"vincent-r-pawlowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"vincent-r-pawlowski-250x300.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"vincent-r-pawlowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:31:\"vincent-r-pawlowski-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:31:\"vincent-r-pawlowski-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2311,	3691,	'_wp_attached_file',	'2019/09/kenneth-w-mastrilli.jpg'),
(2312,	3691,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:320;s:6:\"height\";i:384;s:4:\"file\";s:31:\"2019/09/kenneth-w-mastrilli.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"kenneth-w-mastrilli-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"kenneth-w-mastrilli-250x300.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"kenneth-w-mastrilli-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:31:\"kenneth-w-mastrilli-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:31:\"kenneth-w-mastrilli-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2313,	39,	'_subslideID',	''),
(2314,	3693,	'_wp_attached_file',	'2019/09/dena-m-dymtrow.jpg'),
(2315,	3693,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:320;s:6:\"height\";i:384;s:4:\"file\";s:26:\"2019/09/dena-m-dymtrow.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-250x300.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2316,	370,	'_subslideID',	''),
(2317,	3695,	'_wp_attached_file',	'2019/09/matt-j-mincone.jpg'),
(2318,	3695,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:320;s:6:\"height\";i:384;s:4:\"file\";s:26:\"2019/09/matt-j-mincone.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"matt-j-mincone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"matt-j-mincone-250x300.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"matt-j-mincone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:26:\"matt-j-mincone-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:26:\"matt-j-mincone-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2319,	3697,	'_wp_attached_file',	'2019/09/kimberly-a-burchins.jpg'),
(2320,	3697,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:320;s:6:\"height\";i:384;s:4:\"file\";s:31:\"2019/09/kimberly-a-burchins.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"kimberly-a-burchins-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"kimberly-a-burchins-250x300.jpg\";s:5:\"width\";i:250;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"kimberly-a-burchins-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:31:\"kimberly-a-burchins-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:31:\"kimberly-a-burchins-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2333,	3711,	'_wp_attached_file',	'2019/09/kenneth-w-mastrilli-1.jpg'),
(2334,	3711,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:363;s:6:\"height\";i:512;s:4:\"file\";s:33:\"2019/09/kenneth-w-mastrilli-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"kenneth-w-mastrilli-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"kenneth-w-mastrilli-1-213x300.jpg\";s:5:\"width\";i:213;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"kenneth-w-mastrilli-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:33:\"kenneth-w-mastrilli-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:33:\"kenneth-w-mastrilli-1-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2335,	3713,	'_wp_attached_file',	'2019/09/dena-m-dymtrow-1.jpg'),
(2336,	3713,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:585;s:6:\"height\";i:389;s:4:\"file\";s:28:\"2019/09/dena-m-dymtrow-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"dena-m-dymtrow-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"dena-m-dymtrow-1-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:28:\"dena-m-dymtrow-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:28:\"dena-m-dymtrow-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:28:\"dena-m-dymtrow-1-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2337,	3715,	'_wp_attached_file',	'2019/09/matthew-j-mincone-1.jpg'),
(2338,	3715,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:584;s:6:\"height\";i:389;s:4:\"file\";s:31:\"2019/09/matthew-j-mincone-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"matthew-j-mincone-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"matthew-j-mincone-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:31:\"matthew-j-mincone-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:31:\"matthew-j-mincone-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:31:\"matthew-j-mincone-1-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2339,	3717,	'_wp_attached_file',	'2019/09/kimberly-a-burchins-1.jpg'),
(2340,	3717,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:341;s:6:\"height\";i:511;s:4:\"file\";s:33:\"2019/09/kimberly-a-burchins-1.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"kimberly-a-burchins-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"kimberly-a-burchins-1-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:33:\"kimberly-a-burchins-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:33:\"kimberly-a-burchins-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:33:\"kimberly-a-burchins-1-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2439,	50,	'_subslideID',	''),
(2440,	52,	'_subslideID',	''),
(2442,	54,	'_subslideID',	''),
(2443,	56,	'_subslideID',	''),
(2444,	58,	'_subslideID',	''),
(2445,	60,	'_subslideID',	''),
(2446,	62,	'_subslideID',	''),
(2447,	64,	'_subslideID',	''),
(2448,	66,	'_subslideID',	''),
(2449,	68,	'_subslideID',	''),
(2450,	70,	'_subslideID',	''),
(2451,	72,	'_subslideID',	''),
(2452,	74,	'_subslideID',	''),
(2453,	76,	'_subslideID',	''),
(2454,	78,	'_subslideID',	''),
(2455,	80,	'_subslideID',	''),
(2456,	84,	'_subslideID',	''),
(2457,	86,	'_subslideID',	''),
(2458,	88,	'_subslideID',	''),
(2459,	90,	'_subslideID',	''),
(2460,	92,	'_subslideID',	''),
(2461,	94,	'_subslideID',	''),
(2462,	96,	'_subslideID',	''),
(2784,	2708,	'_subslideID',	''),
(2892,	2694,	'_subslideID',	''),
(2893,	2683,	'_subslideID',	''),
(2894,	2695,	'_subslideID',	''),
(2895,	2555,	'_subslideID',	''),
(2896,	2690,	'_subslideID',	''),
(2897,	2685,	'_subslideID',	''),
(2898,	2698,	'_subslideID',	''),
(2899,	2699,	'_subslideID',	''),
(2900,	2691,	'_subslideID',	''),
(2901,	2686,	'_subslideID',	''),
(2902,	2692,	'_subslideID',	''),
(2903,	2689,	'_subslideID',	''),
(2904,	2688,	'_subslideID',	''),
(2905,	2682,	'_subslideID',	''),
(2906,	2684,	'_subslideID',	''),
(2907,	2687,	'_subslideID',	''),
(2908,	2696,	'_subslideID',	''),
(2909,	2609,	'_subslideID',	''),
(2910,	2710,	'_subslideID',	''),
(2911,	2703,	'_subslideID',	''),
(2912,	2704,	'_subslideID',	''),
(2913,	2700,	'_subslideID',	''),
(2914,	2702,	'_subslideID',	''),
(2915,	2705,	'_subslideID',	''),
(2916,	2701,	'_subslideID',	''),
(2917,	2627,	'_subslideID',	''),
(3686,	4073,	'_edit_lock',	'1583261447:1'),
(3687,	4073,	'_edit_last',	'1'),
(3688,	4073,	'_title',	'Tampa Arrests | Tampa Criminal Defense Attorneys | The Pawlowski//Mastrilli Law Group'),
(3689,	4073,	'_description',	'Tampa criminal defense attorneys The Pawlowski//Mastrilli Law Group help those who have been arrested in Tampa get bail & protect the rights of the accused with do’s & don’ts.'),
(3690,	4073,	'_keywords',	''),
(3691,	4073,	'_subslideID',	''),
(3701,	2474,	'_subslideID',	''),
(3702,	2693,	'_subslideID',	''),
(3703,	2697,	'_subslideID',	''),
(3704,	338,	'_edit_lock',	'1583263361:1'),
(3705,	338,	'_subslideID',	''),
(4062,	4344,	'_edit_last',	'3'),
(4063,	4344,	'_title',	'St. Petersburg Insurance Liability Lawyer'),
(4064,	4344,	'_description',	'If you have an insurance claim that you believe isn’t being processed fairly or you need help, contact our St. Petersburg insurance liability lawyers.'),
(4065,	4344,	'_keywords',	'St. Petersburg Insurance Liability Lawyer'),
(4066,	4344,	'_subslideID',	''),
(4067,	4345,	'_edit_last',	'3'),
(4068,	4345,	'_title',	'Hurricane Damage Lawyer'),
(4069,	4345,	'_description',	'Our hurricane damage lawyers have years of experience, know how to negotiate settlements & understand the tactics that insurance adjusters use.'),
(4070,	4345,	'_keywords',	'St. Petersburg Hurricane Damage Lawyer'),
(4071,	4345,	'_subslideID',	''),
(4072,	4346,	'_edit_last',	'3'),
(4073,	4346,	'_title',	'St. Petersburg Criminal Lawyer'),
(4074,	4346,	'_description',	'If you are arrested, the first call that you make should be to a reputable St. Petersburg criminal lawyer, contact us today.'),
(4075,	4346,	'_keywords',	'St. Petersburg Criminal Lawyer'),
(4076,	4346,	'_subslideID',	''),
(4077,	4347,	'_edit_last',	'3'),
(4078,	4347,	'_title',	'St. Petersburg Family Lawyer'),
(4079,	4347,	'_description',	'Our St. Petersburg family lawyers are passionate about providing high-level legal representation to our clients and securing favorable case outcomes.'),
(4080,	4347,	'_keywords',	'St. Petersburg Family Lawyer'),
(4081,	4347,	'_subslideID',	''),
(4082,	4348,	'_edit_last',	'3'),
(4083,	4348,	'_title',	'St. Petersburg Wrongful Death Lawyer'),
(4084,	4348,	'_description',	'Our experienced St. Petersburg wrongful death lawyers understand the emotional nature of wrongful death suits, contact us today.'),
(4085,	4348,	'_keywords',	'St. Petersburg Wrongful Death Lawyer'),
(4086,	4348,	'_subslideID',	''),
(4087,	4349,	'_edit_last',	'3'),
(4088,	4349,	'_title',	'St. Petersburg Workplace Accident Lawyer'),
(4089,	4349,	'_description',	'Reach out to our experienced St. Petersburg workplace accident lawyers today to learn more about how we can help and what your rights are.'),
(4090,	4349,	'_keywords',	'St. Petersburg Workplace Accident Lawyer'),
(4091,	4349,	'_subslideID',	''),
(4092,	4350,	'_edit_last',	'3'),
(4093,	4350,	'_title',	'St. Petersburg Uninsured Motorist Lawyer'),
(4094,	4350,	'_description',	'Our St. Petersburg uninsured motorist lawyers at The Pawlowski//Mastrilli Law Group can help, contact us today.'),
(4095,	4350,	'_keywords',	'St. Petersburg Uninsured Motorist Lawyer'),
(4096,	4350,	'_subslideID',	''),
(4097,	4351,	'_edit_last',	'3'),
(4098,	4351,	'_title',	'St. Petersburg Truck Accident Lawyer'),
(4099,	4351,	'_description',	'Our St. Petersburg truck accident lawyers understand the devastating nature of truck accidents, and want to help if you’ve been in a crash.'),
(4100,	4351,	'_keywords',	'St. Petersburg Truck Accident Lawyer'),
(4101,	4351,	'_subslideID',	''),
(4102,	4352,	'_edit_last',	'3'),
(4103,	4352,	'_title',	'St. Petersburg Pharmaceutical Injury Lawyer'),
(4104,	4352,	'_description',	'If you have been injured by taking a defective drug, our St. Petersburg pharmaceutical injury lawyers can help, contact us today.'),
(4105,	4352,	'_keywords',	'St. Petersburg Pharmaceutical Injury Lawyer'),
(4106,	4352,	'_subslideID',	''),
(4107,	4353,	'_edit_last',	'3'),
(4108,	4353,	'_title',	'St. Petersburg Premises Liability Lawyer'),
(4109,	4353,	'_description',	'Our experienced St. Petersburg premises liability lawyers can help you to understand the laws regarding dangerous premises in our state and liability.'),
(4110,	4353,	'_keywords',	'St. Petersburg Premises Liability Lawyer'),
(4111,	4353,	'_subslideID',	''),
(4112,	4354,	'_edit_last',	'3'),
(4113,	4354,	'_title',	'St. Petersburg Nursing Home Abuse Lawyer'),
(4114,	4354,	'_description',	'Our St. Petersburg nursing home abuse lawyers are passionate about standing up for those who need our help the most, and there is no group more vulnerable than the elderly.'),
(4115,	4354,	'_keywords',	'St. Petersburg Nursing Home Abuse Lawyer'),
(4116,	4354,	'_subslideID',	''),
(4117,	4355,	'_edit_last',	'3'),
(4118,	4355,	'_title',	'St. Petersburg Motorcycle Accident Lawyer'),
(4119,	4355,	'_description',	'If you have been involved in a motorcycle accident in our state, our St. Petersburg motorcycle accident lawyers can help.'),
(4120,	4355,	'_keywords',	'St. Petersburg Motorcycle Accident Lawyer'),
(4121,	4355,	'_subslideID',	''),
(4122,	4356,	'_edit_last',	'3'),
(4123,	4356,	'_title',	'St. Petersburg Insurance Bad Faith Lawyer'),
(4124,	4356,	'_description',	'To schedule a free consultation, please call our St. Petersburg insurance bad faith lawyers directly or send us a message at your convenience.'),
(4125,	4356,	'_keywords',	'St. Petersburg Insurance Bad Faith Lawyer'),
(4126,	4356,	'_subslideID',	''),
(4127,	4357,	'_edit_last',	'3'),
(4128,	4357,	'_title',	'St. Petersburg Medical Malpractice Lawyer'),
(4129,	4357,	'_description',	'At The Pawlowski//Mastrilli Law Group, our St. Petersburg medical malpractice lawyers can help, reach out to us today to learn more.'),
(4130,	4357,	'_keywords',	'St. Petersburg Medical Malpractice Lawyer'),
(4131,	4357,	'_subslideID',	''),
(4132,	4358,	'_edit_last',	'3'),
(4133,	4358,	'_title',	'St. Petersburg Hit & Run Lawyer'),
(4134,	4358,	'_description',	'At the law office of The Pawlowski//Mastrilli Law Group, our experienced St. Petersburg hit & run lawyers can help, contact us today.'),
(4135,	4358,	'_keywords',	'St. Petersburg Hit & Run Lawyer'),
(4136,	4358,	'_subslideID',	''),
(4137,	4359,	'_edit_last',	'3'),
(4138,	4359,	'_title',	'St. Petersburg DUI Accident Lawyer'),
(4139,	4359,	'_description',	'If you are hit by a drunk driver, our St. Petersburg DUI accident lawyers will be by your side to build your case and help you to recover compensation.'),
(4140,	4359,	'_keywords',	'St. Petersburg DUI Accident Lawyer'),
(4141,	4359,	'_subslideID',	''),
(4142,	4360,	'_edit_last',	'3'),
(4143,	4360,	'_title',	'St. Petersburg Commercial Vehicle Accident Lawyer'),
(4144,	4360,	'_description',	'Our St. Petersburg commercial vehicle accident lawyers are passionate about helping those who have been injured in a serious accident.'),
(4145,	4360,	'_keywords',	'St. Petersburg Commercial Vehicle Accident Lawyer'),
(4146,	4360,	'_subslideID',	''),
(4147,	4361,	'_edit_last',	'3'),
(4148,	4361,	'_title',	'St. Petersburg Catastrophic Injury Lawyer'),
(4149,	4361,	'_description',	'At The Pawlowski//Mastrilli Law Group, our St. Petersburg catastrophic injury lawyers understand what you’re going through and we want to help.'),
(4150,	4361,	'_keywords',	'St. Petersburg Catastrophic Injury Lawyer'),
(4151,	4361,	'_subslideID',	''),
(4152,	4362,	'_edit_last',	'3'),
(4153,	4362,	'_title',	'St. Petersburg Car Accident Lawyer'),
(4154,	4362,	'_description',	'At The Pawlowski//Mastrilli Law Group, our St. Petersburg car accident lawyers have seen firsthand how devastating serious car accidents can be, contact us now.'),
(4155,	4362,	'_keywords',	'St. Petersburg Car Accident Lawyer'),
(4156,	4362,	'_subslideID',	''),
(4157,	4363,	'_edit_last',	'3'),
(4158,	4363,	'_title',	'St. Petersburg Auto Accident Lawyer'),
(4159,	4363,	'_description',	'At The Pawlowski//Mastrilli Law Group, our St. Petersburg auto accident lawyers are here to serve you, reach us today for your free consultation.'),
(4160,	4363,	'_keywords',	'St. Petersburg Auto Accident Lawyer'),
(4161,	4363,	'_subslideID',	''),
(4162,	4364,	'_edit_last',	'3'),
(4163,	4364,	'_title',	'St. Petersburg Personal Injury Lawyer'),
(4164,	4364,	'_description',	'At the office of The Pawlowski//Mastrilli Law Group, our St. Petersburg personal injury lawyers in Florida can help, contact us today.'),
(4165,	4364,	'_keywords',	'St. Petersburg Personal Injury Lawyer'),
(4166,	4364,	'_subslideID',	''),
(4169,	4371,	'_title',	'Clearwater Hurricane Damage Lawyer '),
(4170,	4371,	'_description',	'For help understanding sources of compensation after a hurricane, or how to file an insurance claim, contact our Clearwater hurricane damage lawyers today.'),
(4171,	4371,	'_keywords',	'Clearwater Hurricane Damage Lawyer '),
(4172,	4371,	'_subslideID',	''),
(4173,	4372,	'_title',	'Clearwater Insurance Liability Lawyer'),
(4174,	4372,	'_description',	'With any insurance related questions, call the Clearwater insurance liability lawyers at The Pawlowski//Mastrilli Law Group today.'),
(4175,	4372,	'_keywords',	'Clearwater Insurance Liability Lawyer'),
(4176,	4372,	'_subslideID',	''),
(4177,	4373,	'_title',	'Clearwater Criminal Lawyer'),
(4178,	4373,	'_description',	'With any criminal law related matter, call the Clearwater criminal defense lawyers at The Pawlowski//Mastrilli Law Group today.'),
(4179,	4373,	'_keywords',	'Clearwater Criminal Lawyer'),
(4180,	4373,	'_subslideID',	''),
(4181,	4374,	'_title',	'Clearwater Family Lawyer'),
(4182,	4374,	'_description',	'With any type of family matter, call the Clearwater family lawyers at The Pawlowski Mastrilli Law group today.'),
(4183,	4374,	'_keywords',	'Clearwater Family Lawyer'),
(4184,	4374,	'_subslideID',	''),
(4185,	4375,	'_title',	'Clearwater Workplace Accident Lawyer'),
(4186,	4375,	'_description',	'Call the experienced Clearwater workplace accident lawyers at The Pawlowski//Mastrilli Law Group if you have been injured on the job.'),
(4187,	4375,	'_keywords',	'Clearwater Workplace Accident Lawyer'),
(4188,	4375,	'_subslideID',	''),
(4189,	4376,	'_title',	'Clearwater Uninsured Motorist Lawyer'),
(4190,	4376,	'_description',	'If you have been in a crash with an uninsured motorist, call the Clearwater uninsured motorist lawyers at The Pawlowski//Mastrilli Law Group today.'),
(4191,	4376,	'_keywords',	'Clearwater Uninsured Motorist Lawyer'),
(4192,	4376,	'_subslideID',	''),
(4193,	4377,	'_title',	'Clearwater Truck Accident Lawyer'),
(4194,	4377,	'_description',	'If you were injured in a truck accident, call the Clearwater truck accident lawyers at The Pawlowski//Mastrilli Law Group today.'),
(4195,	4377,	'_keywords',	'Clearwater Truck Accident Lawyer'),
(4196,	4377,	'_subslideID',	''),
(4197,	4378,	'_title',	'Clearwater Pharmaceutical Injury Lawyer'),
(4198,	4378,	'_description',	'f you have suffered a pharmaceutical injury, call the Clearwater pharmaceutical injury lawyers at The Pawlowski Mastrilli Law Group today.'),
(4199,	4378,	'_keywords',	'Clearwater Pharmaceutical Injury Lawyer'),
(4200,	4378,	'_subslideID',	''),
(4201,	4379,	'_title',	'Clearwater Premises Liability Lawyer'),
(4202,	4379,	'_description',	'If you have been harmed on a property other than your own, including public property, call our Clearwater premises liability lawyers today.'),
(4203,	4379,	'_keywords',	'Clearwater Premises Liability Lawyer'),
(4204,	4379,	'_subslideID',	''),
(4205,	4380,	'_title',	'Clearwater Nursing Home Abuse Lawyer'),
(4206,	4380,	'_description',	'Call The Clearwater nursing home abuse lawyers at The Pawlowski//Mastrilli Law Group for help if you or your loved one is a victim of nursing home abuse.'),
(4207,	4380,	'_keywords',	'Clearwater Nursing Home Abuse Lawyer'),
(4208,	4380,	'_subslideID',	''),
(4209,	4381,	'_title',	'Clearwater Motorcycle Accident Lawyer'),
(4210,	4381,	'_description',	'If you have been injured in a motorcycle crash, call the Clearwater motorcycle accident lawyers at The Pawlowski//Mastrilli Law Group today.'),
(4211,	4381,	'_keywords',	'Clearwater Motorcycle Accident Lawyer'),
(4212,	4381,	'_subslideID',	''),
(4213,	4382,	'_title',	'Clearwater Insurance Bad Faith Lawyer'),
(4214,	4382,	'_description',	'At the law offices of The Pawloski//Mastrilli Law Group, our Clearwater insurance bad faith lawyers can help when you are navigating the claims process.'),
(4215,	4382,	'_keywords',	'Clearwater Insurance Bad Faith Lawyer'),
(4216,	4382,	'_subslideID',	''),
(4217,	4383,	'_title',	'Clearwater Medical Malpractice Lawyer'),
(4218,	4383,	'_description',	'The Clearwater medical malpractice lawyers at The Pawlowski//Mastrilli Law Group can help you file a malpractice suit.'),
(4219,	4383,	'_keywords',	'Clearwater Medical Malpractice Lawyer'),
(4220,	4383,	'_subslideID',	''),
(4221,	4384,	'_title',	'Clearwater Hit & Run Accident Lawyer'),
(4222,	4384,	'_description',	'If you’ve been in a crash with a driver who left the scene, our Clearwater hit & run accident lawyers at The Pawlowski//Mastrilli Law Group can help.'),
(4223,	4384,	'_keywords',	'Clearwater Hit & Run Accident Lawyer'),
(4224,	4384,	'_subslideID',	''),
(4225,	4385,	'_title',	'Clearwater DUI Accident Lawyer'),
(4226,	4385,	'_description',	'If you have been harmed in a crash, our experienced Clearwater DUI accident lawyers at the office of The Pawlowski//Mastrilli Law Group can help.'),
(4227,	4385,	'_keywords',	'Clearwater DUI Accident Lawyer'),
(4228,	4385,	'_subslideID',	''),
(4229,	4386,	'_title',	'Clearwater Commercial Vehicle Accident Lawyer'),
(4230,	4386,	'_description',	'If you’ve been in a crash or lost a loved one, please reach out to our Clearwater commercial vehicle accident lawyers today.'),
(4231,	4386,	'_keywords',	'Clearwater Commercial Vehicle Accident Lawyer'),
(4232,	4386,	'_subslideID',	''),
(4233,	4387,	'_title',	'Clearwater Catastrophic Injury Lawyer'),
(4234,	4387,	'_description',	'If you have suffered a catastrophic injury, call the Clearwater catastrophic injury lawyers at The Pawlowski//Mastrilli Law Group today.'),
(4235,	4387,	'_keywords',	'Clearwater Catastrophic Injury Lawyer'),
(4236,	4387,	'_subslideID',	''),
(4237,	4388,	'_title',	'Clearwater Car Accident Lawyer'),
(4238,	4388,	'_description',	'If you’ve been in a crash caused by the negligence of a party other than yourself, our Clearwater car accident lawyers can help.'),
(4239,	4388,	'_keywords',	'Clearwater Car Accident Lawyer'),
(4240,	4388,	'_subslideID',	''),
(4241,	4389,	'_title',	'Clearwater Auto Accident Lawyer'),
(4242,	4389,	'_description',	'If you are dealing with serious injuries & losses following a crash caused by another’s negligence, call our experienced Clearwater auto accident lawyers today.'),
(4243,	4389,	'_keywords',	'Clearwater Auto Accident Lawyer'),
(4244,	4389,	'_subslideID',	''),
(4245,	4390,	'_title',	'Clearwater Personal Injury Lawyer'),
(4246,	4390,	'_description',	'If you need help with any personal injury matter, call the Clearwater personal injury lawyers at The Pawlowski//Mastrilli Law Group today.'),
(4247,	4390,	'_keywords',	'Clearwater Personal Injury Lawyer'),
(4248,	4390,	'_subslideID',	''),
(4249,	4391,	'_title',	'Clearwater Wrongful Death Lawyer'),
(4250,	4391,	'_description',	'If you have lost your loved one in an accident, call the Clearwater wrongful death lawyers at The Pawlowski//Mastrilli Law Group today.'),
(4251,	4391,	'_keywords',	'Clearwater Wrongful Death Lawyer'),
(4252,	4391,	'_subslideID',	''),
(4253,	4397,	'_menu_item_type',	'custom'),
(4254,	4397,	'_menu_item_menu_item_parent',	'0'),
(4255,	4397,	'_menu_item_object_id',	'4397'),
(4256,	4397,	'_menu_item_object',	'custom'),
(4257,	4397,	'_menu_item_target',	''),
(4258,	4397,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(4259,	4397,	'_menu_item_xfn',	''),
(4260,	4397,	'_menu_item_url',	''),
(4262,	4398,	'_menu_item_type',	'custom'),
(4263,	4398,	'_menu_item_menu_item_parent',	'4397'),
(4264,	4398,	'_menu_item_object_id',	'4398'),
(4265,	4398,	'_menu_item_object',	'custom'),
(4266,	4398,	'_menu_item_target',	''),
(4267,	4398,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(4268,	4398,	'_menu_item_xfn',	''),
(4269,	4398,	'_menu_item_url',	''),
(4271,	4399,	'_menu_item_type',	'custom'),
(4272,	4399,	'_menu_item_menu_item_parent',	'4397'),
(4273,	4399,	'_menu_item_object_id',	'4399'),
(4274,	4399,	'_menu_item_object',	'custom'),
(4275,	4399,	'_menu_item_target',	''),
(4276,	4399,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(4277,	4399,	'_menu_item_xfn',	''),
(4278,	4399,	'_menu_item_url',	''),
(4280,	4400,	'_menu_item_type',	'custom'),
(4281,	4400,	'_menu_item_menu_item_parent',	'4397'),
(4282,	4400,	'_menu_item_object_id',	'4400'),
(4283,	4400,	'_menu_item_object',	'custom'),
(4284,	4400,	'_menu_item_target',	''),
(4285,	4400,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(4286,	4400,	'_menu_item_xfn',	''),
(4287,	4400,	'_menu_item_url',	''),
(4289,	4401,	'_menu_item_type',	'custom'),
(4290,	4401,	'_menu_item_menu_item_parent',	'4397'),
(4291,	4401,	'_menu_item_object_id',	'4401'),
(4292,	4401,	'_menu_item_object',	'custom'),
(4293,	4401,	'_menu_item_target',	''),
(4294,	4401,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(4295,	4401,	'_menu_item_xfn',	''),
(4296,	4401,	'_menu_item_url',	''),
(4379,	4388,	'_edit_lock',	'1586275054:3'),
(4380,	4373,	'_edit_lock',	'1583263289:1'),
(4381,	4389,	'_edit_lock',	'1583263283:1'),
(4382,	4389,	'_edit_last',	'3'),
(4383,	4388,	'_edit_last',	'3'),
(4387,	4362,	'_edit_lock',	'1583263472:1'),
(4388,	4363,	'_edit_lock',	'1583263332:1'),
(4425,	4431,	'_menu_item_type',	'custom'),
(4426,	4431,	'_menu_item_menu_item_parent',	'4397'),
(4427,	4431,	'_menu_item_object_id',	'4431'),
(4428,	4431,	'_menu_item_object',	'custom'),
(4429,	4431,	'_menu_item_target',	''),
(4430,	4431,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(4431,	4431,	'_menu_item_xfn',	''),
(4432,	4431,	'_menu_item_url',	''),
(4454,	4435,	'_wp_attached_file',	'2019/12/team-attorney-2-v2.jpg'),
(4455,	4435,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:624;s:6:\"height\";i:384;s:4:\"file\";s:30:\"2019/12/team-attorney-2-v2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-2-v2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"team-attorney-2-v2-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-2-v2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:30:\"team-attorney-2-v2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:30:\"team-attorney-2-v2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(4456,	4436,	'_wp_attached_file',	'2019/12/team-attorney-3-v2.jpg'),
(4457,	4436,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:624;s:6:\"height\";i:384;s:4:\"file\";s:30:\"2019/12/team-attorney-3-v2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-3-v2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"team-attorney-3-v2-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-3-v2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:30:\"team-attorney-3-v2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:30:\"team-attorney-3-v2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(4458,	4437,	'_wp_attached_file',	'2019/12/team-attorney-4-v2.jpg'),
(4459,	4437,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:624;s:6:\"height\";i:384;s:4:\"file\";s:30:\"2019/12/team-attorney-4-v2.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-4-v2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"team-attorney-4-v2-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-4-v2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:30:\"team-attorney-4-v2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:30:\"team-attorney-4-v2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(4462,	4443,	'_wp_attached_file',	'2019/12/dena-m-dymtrow.jpg'),
(4463,	4443,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:220;s:6:\"height\";i:310;s:4:\"file\";s:26:\"2019/12/dena-m-dymtrow.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-213x300.jpg\";s:5:\"width\";i:213;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:26:\"dena-m-dymtrow-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(4464,	4364,	'_edit_lock',	'1583263291:1'),
(4465,	4361,	'_edit_lock',	'1583263432:1'),
(4466,	4360,	'_edit_lock',	'1586274691:3'),
(4467,	4358,	'_edit_lock',	'1583263476:1'),
(4468,	4357,	'_edit_lock',	'1583263428:1'),
(4469,	4355,	'_edit_lock',	'1586272250:3'),
(4470,	4354,	'_edit_lock',	'1583263292:1'),
(4471,	4353,	'_edit_lock',	'1583263292:1'),
(4472,	4352,	'_edit_lock',	'1583263292:1'),
(4473,	4350,	'_edit_lock',	'1583263480:1'),
(4474,	4348,	'_edit_lock',	'1583263434:1'),
(4475,	4347,	'_edit_lock',	'1583263481:1'),
(4476,	4391,	'_edit_lock',	'1583263282:1'),
(4477,	4391,	'_edit_last',	'3'),
(4478,	4375,	'_edit_lock',	'1583263281:1'),
(4479,	4375,	'_edit_last',	'3'),
(4480,	4380,	'_edit_lock',	'1583263362:1'),
(4481,	4380,	'_edit_last',	'3'),
(4482,	4383,	'_edit_lock',	'1583263358:1'),
(4483,	4383,	'_edit_last',	'3'),
(4484,	4372,	'_edit_lock',	'1583263356:1'),
(4485,	4372,	'_edit_last',	'3'),
(4486,	4387,	'_edit_lock',	'1583263202:1'),
(4487,	4387,	'_edit_last',	'3'),
(4488,	4376,	'_edit_lock',	'1583263289:1'),
(4489,	4376,	'_edit_last',	'3'),
(4490,	4377,	'_edit_lock',	'1583263288:1'),
(4491,	4377,	'_edit_last',	'3'),
(4492,	4381,	'_edit_lock',	'1583263288:1'),
(4493,	4381,	'_edit_last',	'3'),
(4494,	4384,	'_edit_lock',	'1583263286:1'),
(4495,	4384,	'_edit_last',	'3'),
(4496,	4386,	'_edit_lock',	'1586274543:3'),
(4497,	4386,	'_edit_last',	'3'),
(4498,	4371,	'_edit_lock',	'1583263291:1'),
(4499,	4371,	'_edit_last',	'3'),
(4500,	4385,	'_edit_lock',	'1583263284:1'),
(4501,	4385,	'_edit_last',	'3'),
(4502,	4390,	'_edit_lock',	'1594320760:3'),
(4503,	4390,	'_edit_last',	'3'),
(4504,	4373,	'_edit_last',	'3'),
(4965,	4382,	'_edit_lock',	'1583263354:1'),
(4966,	4378,	'_edit_lock',	'1583263363:1'),
(4967,	4379,	'_edit_lock',	'1583263365:1'),
(4968,	4374,	'_edit_lock',	'1583263290:1'),
(4969,	4356,	'_edit_lock',	'1583263426:1'),
(4970,	4344,	'_edit_lock',	'1583263433:1'),
(4971,	4349,	'_edit_lock',	'1583263435:1'),
(4972,	4359,	'_edit_lock',	'1583263332:1'),
(4973,	4351,	'_edit_lock',	'1583263477:1'),
(4974,	4345,	'_edit_lock',	'1709133312:3'),
(4975,	4346,	'_edit_lock',	'1583263483:1'),
(7669,	4378,	'_edit_last',	'3'),
(7786,	4896,	'iwp_log_type',	'scheduleBackup'),
(7787,	4896,	'iwp_log_action',	'schedule'),
(7788,	4896,	'iwp_log_activities_type',	'iwp_log'),
(7789,	4896,	'iwp_log_actions',	'backups'),
(7790,	4896,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(7916,	4943,	'iwp_log_type',	'scheduleBackup'),
(7917,	4943,	'iwp_log_action',	'schedule'),
(7918,	4943,	'iwp_log_activities_type',	'iwp_log'),
(7919,	4943,	'iwp_log_actions',	'backups'),
(7920,	4943,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(7925,	4382,	'_edit_last',	'3'),
(7926,	4379,	'_edit_last',	'3'),
(7927,	4374,	'_edit_last',	'3'),
(8415,	397,	'_title',	'Investigating A Small Plane Crash | Tampa Aviation Accidents Attorneys'),
(8416,	397,	'_description',	'If you or a loved one has been injured in an aircraft accident, contact The Pawlowski//Mastrilli Law Group in Tampa for legal advice.'),
(8417,	397,	'_keywords',	''),
(8420,	397,	'_subslideID',	''),
(8421,	399,	'_title',	'Florida Gun Penalties | Tampa Criminal Defense Lawyers'),
(8422,	399,	'_description',	'If you or a loved has been charged with a weapons violation, contact the aggressive defense attorneys at The Pawlowski//Mastrilli Law Group in Tampa for help.'),
(8423,	399,	'_keywords',	''),
(8426,	399,	'_subslideID',	''),
(8427,	401,	'_title',	'License Suspension Ramifications | Tampa Criminal Defense Lawyers'),
(8428,	401,	'_description',	'If you or a loved is facing a license suspension, call The Pawlowski//Mastrilli Law Group in Tampa for a free consultation.'),
(8429,	401,	'_keywords',	''),
(8432,	401,	'_subslideID',	''),
(8433,	403,	'_title',	'In-Home Services Injuries | Tampa Product Liability Lawyers'),
(8434,	403,	'_description',	'If you or a loved has been injured by a company\'s services inside your home, contact The Pawlowski//Mastrilli Law Group in Tampa for a free consultation.'),
(8435,	403,	'_keywords',	''),
(8438,	403,	'_subslideID',	''),
(8439,	405,	'_title',	'Legalities Of A Food Recall | Tampa Injury Attorneys'),
(8440,	405,	'_description',	'If you or a loved has been injured by a food-borne illness, contact The Pawlowski//Mastrilli Law Group in Tampa for a free consultation.'),
(8441,	405,	'_keywords',	''),
(8444,	405,	'_subslideID',	''),
(8445,	407,	'_title',	'What is Flakka? | Tampa Criminal Defense Lawyers'),
(8446,	407,	'_description',	'If you or a loved has been charged with possession of a synthetic drug, contact The Pawlowski//Mastrilli Law Group in Tampa for a free consultation.'),
(8447,	407,	'_keywords',	''),
(8450,	407,	'_subslideID',	''),
(8451,	409,	'_title',	'Aircraft Landing Investigation | Tampa Personal Injury Lawyers'),
(8452,	409,	'_description',	'If you or a loved was injured in an aviation accident, contact The Pawlowski//Mastrilli Law Group in Tampa for a free consultation.'),
(8453,	409,	'_keywords',	''),
(8456,	409,	'_subslideID',	''),
(8457,	411,	'_title',	'Social Media Pics Result In Felony Charges | Tampa Criminal Defense Lawyers'),
(8458,	411,	'_description',	'If you or a loved is facing felony charges, contact The Pawlowski//Mastrilli Law Group in Tampa for a free consultation.'),
(8459,	411,	'_keywords',	''),
(8462,	411,	'_subslideID',	''),
(8463,	413,	'_title',	'Fatal Florida Wrong Way Accident | Tampa Accident Lawyers'),
(8464,	413,	'_description',	'If you or a loved was injured in a wrong way accident, contact the injury attorneys at The Pawlowski//Mastrilli Law Group in Tampa for legal assistance.'),
(8465,	413,	'_keywords',	''),
(8468,	413,	'_subslideID',	''),
(8469,	415,	'_title',	'Fraud And Identity Theft In South Florida | Tampa Criminal Defense Attorney'),
(8470,	415,	'_description',	'If you or a loved is facing identity theft charges, contact The Pawlowski//Mastrilli Law Group for a free consultation in Tampa.'),
(8471,	415,	'_keywords',	''),
(8474,	415,	'_subslideID',	''),
(8477,	499,	'_title',	'Thanksgiving Holiday Food Drive'),
(8478,	499,	'_description',	''),
(8479,	499,	'_keywords',	''),
(8480,	499,	'_subslideID',	''),
(8483,	673,	'_title',	'Is Your Loved One A Victim Of Nursing Home Abuse? | Tampa Injury Lawyers'),
(8484,	673,	'_description',	'If you or a loved has been the victim of nursing home neglect or abuse, contact The Pawlowski//Mastrilli Law Group in Tampa for a free consultation.'),
(8485,	673,	'_keywords',	''),
(8486,	673,	'_subslideID',	''),
(8489,	675,	'_title',	'Garbage Truck Accident Dangers | Tampa Personal Injury Lawyers'),
(8490,	675,	'_description',	'If you have been injured in an accident, contact the injury attorneys at The Pawlowski//Mastrilli Law Group for a free case consultation.'),
(8491,	675,	'_keywords',	''),
(8492,	675,	'_subslideID',	''),
(8495,	677,	'_title',	'Anatomy Of A Vehicle Recall | Tampa Product Liability Attorneys'),
(8496,	677,	'_description',	'If an injury occurs as a result of a defect, contact the injury attorneys at The Pawlowski//Mastrilli Law Group in Tampa for a free case evaluation.'),
(8497,	677,	'_keywords',	''),
(8498,	677,	'_subslideID',	''),
(8501,	679,	'_title',	'Facing A DUI Manslaughter Charge? | Tampa Criminal Defense Lawyers'),
(8502,	679,	'_description',	'The experienced Tampa attorneys at The Pawlowski//Mastrilli Law Group will fight aggressively to defend your freedom and good reputation.'),
(8503,	679,	'_keywords',	''),
(8504,	679,	'_subslideID',	''),
(8507,	681,	'_title',	'Florida Medical Malpractice Cases | Tampa Medical Malpractice Lawyers'),
(8508,	681,	'_description',	'If you believe you have a medical malpractice claim, contact The Pawlowski//Mastrilli Law Group in Tampa Bay for a free case evaluation.'),
(8509,	681,	'_keywords',	''),
(8510,	681,	'_subslideID',	''),
(8513,	683,	'_title',	'Group Home Injuries | Tampa Personal Injury Lawyers'),
(8514,	683,	'_description',	'If your child or loved one received an injury or improper care within a Florida group home, contact The Pawlowski//Mastrilli Law Group for a free case evaluation.'),
(8515,	683,	'_keywords',	''),
(8516,	683,	'_subslideID',	''),
(8519,	685,	'_title',	'Defending A Pickpocket Charge | Tampa Criminal Defense Lawyers'),
(8520,	685,	'_description',	'If you are facing pick pocket charges, contact an experienced defense attorney at The Pawlowski//Mastrilli Law Group to discuss your case.'),
(8521,	685,	'_keywords',	''),
(8522,	685,	'_subslideID',	''),
(8525,	710,	'_title',	'Nightclub Injuries | Tampa Personal Injury Attorneys'),
(8526,	710,	'_description',	'If you suffered from a nightclub-related injury, contact an experienced personal injury lawyer at The Pawlowski//Mastrilli Law Group to discuss your case.'),
(8527,	710,	'_keywords',	''),
(8528,	710,	'_subslideID',	''),
(8529,	712,	'aFhfc_head_code',	''),
(8530,	712,	'aFhfc_footer_code',	''),
(8531,	712,	'_title',	'Major Methamphetamine Bust In Florida | Tampa Criminal Defense Lawyers'),
(8532,	712,	'_description',	'If you are facing criminal drug charges, contact an experienced defense attorney at The Pawlowski//Mastrilli Law Group in the Tampa area to discuss your case.'),
(8533,	712,	'_keywords',	''),
(8534,	712,	'_subslideID',	''),
(8537,	714,	'_title',	'DUI Manslaughter In Florida | Tampa Criminal Defense Attorneys'),
(8538,	714,	'_description',	'If you are facing a charge of DUI, contact an experienced Florida defense attorney at The Pawlowski//Mastrilli Law Group to discuss the merits of your case.'),
(8539,	714,	'_keywords',	''),
(8540,	714,	'_subslideID',	''),
(8543,	716,	'_title',	'Higher Accident Deductible Does Not Equal Savings For Drivers | Tampa Auto Accident Attorneys'),
(8544,	716,	'_description',	'The attorneys of The Pawlowski//Mastrilli Law Group possess the experience and knowledge to assist you with your auto accident case.'),
(8545,	716,	'_keywords',	''),
(8546,	716,	'_subslideID',	''),
(8547,	718,	'aFhfc_head_code',	''),
(8548,	718,	'aFhfc_footer_code',	''),
(8549,	718,	'_title',	'Were You Charged With Drug Possession In Florida? | Tampa Criminal Defense Lawyers'),
(8550,	718,	'_description',	'If you have been charged with a drug crime in Florida, contact the Tampa defense team at The Pawlowski//Mastrilli Law Group for help.'),
(8551,	718,	'_keywords',	''),
(8552,	718,	'_subslideID',	''),
(8555,	720,	'_title',	'Florida Concealed Weapons Charge | Tampa Criminal Defense Lawyers'),
(8556,	720,	'_description',	'The Pawlowski//Mastrilli Law Group in Tampa has successfully helped Floridians charged with weapons crimes.'),
(8557,	720,	'_keywords',	''),
(8558,	720,	'_subslideID',	''),
(8561,	747,	'_title',	'Comparative Fault In Florida Car Accidents | Tampa Auto Accident Attorneys'),
(8562,	747,	'_description',	'The Pawlowski//Mastrilli Law Group legal team has successfully helped injured Florida car accident victims get the full and fair compensation they deserve.'),
(8563,	747,	'_keywords',	''),
(8564,	747,	'_subslideID',	''),
(8567,	750,	'_title',	'Florida Medical Malpractice: Doctor Misdiagnosis | Tampa Medical Malpractice Attorneys'),
(8568,	750,	'_description',	'At The Pawlowski//Mastrilli Law Group, we have extensive experience fighting for the victims of Tampa medical malpractice.'),
(8569,	750,	'_keywords',	''),
(8570,	750,	'_subslideID',	''),
(8573,	752,	'_title',	'Florida DUI: Refusal To Submit Laws And Defense | Tampa Criminal Defense Attorneys'),
(8574,	752,	'_description',	'At The Pawlowski//Mastrilli Law Group, we have extensive experience helping Floridians charged with DUI and DUI refusal violations.'),
(8575,	752,	'_keywords',	''),
(8576,	752,	'_subslideID',	''),
(8579,	754,	'_title',	'Liability In Florida Commercial Truck Accidents | Tampa Accident Attorneys'),
(8580,	754,	'_description',	'At The Pawlowski//Mastrilli Law Group in Tampa Bay we work hard to get justice for the victims of commercial truck accidents.'),
(8581,	754,	'_keywords',	''),
(8582,	754,	'_subslideID',	''),
(8583,	756,	'aFhfc_head_code',	''),
(8584,	756,	'aFhfc_footer_code',	''),
(8585,	756,	'_title',	'Florida Motorcycle Accidents: Unique Risks | Tampa Accident Lawyers'),
(8586,	756,	'_description',	'At The Pawlowski//Mastrilli Law Group we have extensive experience helping Florida motorcycle accident victims recover full and fair compensation.'),
(8587,	756,	'_keywords',	''),
(8588,	756,	'_subslideID',	''),
(8589,	759,	'aFhfc_head_code',	''),
(8590,	759,	'aFhfc_footer_code',	''),
(8591,	759,	'_title',	'Florida Teen Driver Charged After Leaving The Scene Of A Deadly Accident | Tampa Criminal Defense Lawyers'),
(8592,	759,	'_description',	'At The Pawlowski//Mastrilli Law Group in Tampa, we will comprehensively investigate your case and work hard to protect your rights.'),
(8593,	759,	'_keywords',	''),
(8594,	759,	'_subslideID',	''),
(8597,	791,	'_title',	'Supreme Court Of Florida Clarifies ‘Duty To Retreat’ Obligation | Tampa Defense Attorneys'),
(8598,	791,	'_description',	'The experienced criminal defense attorneys at The Pawlowski//Mastrilli Law Group can help you craft a strong defense if you are facing criminal charges.'),
(8599,	791,	'_keywords',	''),
(8600,	791,	'_subslideID',	''),
(8603,	794,	'_title',	'Do I Need A Car Accident Attorney? | Tampa Auto Accident Lawyers'),
(8604,	794,	'_description',	'The experienced car accident attorneys at The Pawlowski//Mastrilli Law Group will work aggressively to make sure that you recover the fair compensation you deserve.'),
(8605,	794,	'_keywords',	''),
(8606,	794,	'_subslideID',	''),
(8609,	796,	'_title',	'Florida Medication Injuries | Tampa Pharmaceutical Injury Attorneys'),
(8610,	796,	'_description',	'The experienced and compassionate pharmaceutical injury attorneys at The Pawlowski//Mastrilli Law Group can help if you are a victim of malpractice in Florida.'),
(8611,	796,	'_keywords',	''),
(8612,	796,	'_subslideID',	''),
(8615,	798,	'_title',	'Accused Of Violating Probation? Here Is What You Need To Know | Tampa Criminal Defense Lawyers'),
(8616,	798,	'_description',	'If you have been accused of violating probation, contact The Pawlowski//Mastrilli Law Group in Tampa for a free consultation.'),
(8617,	798,	'_keywords',	''),
(8618,	798,	'_subslideID',	''),
(8621,	800,	'_title',	'Was Your Work Injury Caused By A Third Party? | Tampa Workers Compensation Lawyers'),
(8622,	800,	'_description',	'The experienced workplace injury attorneys at The Pawlowski//Mastrilli Law Group in Tampa will help protect your rights.'),
(8623,	800,	'_keywords',	''),
(8624,	800,	'_subslideID',	''),
(8625,	802,	'aFhfc_head_code',	''),
(8626,	802,	'aFhfc_footer_code',	''),
(8627,	802,	'_title',	'Florida Drug Charges: Probable Cause | Tampa Criminal Defense Lawyers'),
(8628,	802,	'_description',	'If you have been arrested for drug possession, or any other drug crime, contact the Florida defense attorneys at The Pawlowski//Mastrilli Law Group for a free consultation.'),
(8629,	802,	'_keywords',	''),
(8630,	802,	'_subslideID',	''),
(8633,	804,	'_title',	'Florida Car Accident Injuries: Distracted Driving | Tampa Auto Accident Attorneys'),
(8634,	804,	'_description',	'If you have been injured in a distracted driving accident, contact The Pawlowski//Mastrilli Law Group in Tampa Bay to schedule your free initial legal consultation.'),
(8635,	804,	'_keywords',	''),
(8636,	804,	'_subslideID',	''),
(8639,	899,	'_title',	'Controversy Arises Over Forceful Arrest Of Tampa Teenager | Tampa Criminal Defense Attorneys'),
(8640,	899,	'_description',	'If you have been charged with misdemeanor resisting arrest, the experienced criminal defense attorneys at The Pawlowski//Mastrilli Law Group will help.'),
(8641,	899,	'_keywords',	''),
(8642,	899,	'_subslideID',	''),
(8645,	902,	'_title',	'Bad Faith Insurance Claims In Florida | Tampa Bad Faith Insurance Attorneys'),
(8646,	902,	'_description',	'The Pawlowski//Mastrilli Law Group has the knowledge and experience to get you the compensation you deserve if you are a victim of an unfair insurance claim settlement.'),
(8647,	902,	'_keywords',	''),
(8648,	902,	'_subslideID',	''),
(8649,	905,	'aFhfc_head_code',	''),
(8650,	905,	'aFhfc_footer_code',	''),
(8651,	905,	'_title',	'Identifying Nursing Home Abuse | Tampa Nursing Home Abuse Attorneys'),
(8652,	905,	'_description',	'At The Pawlowski//Mastrilli Law Group in Tampa, our experienced nursing home neglect attorneys will help you put an end to the abuse, and will guide you through legal action.'),
(8653,	905,	'_keywords',	''),
(8654,	905,	'_subslideID',	''),
(8657,	907,	'_title',	'Arrested In Florida? What You Need To Know | Tampa Criminal Defense Lawyers'),
(8658,	907,	'_description',	'The experienced criminal defense lawyers at The Pawlowski//Mastrilli Law Group will always work aggressively to protect your rights and your freedom.'),
(8659,	907,	'_keywords',	''),
(8660,	907,	'_subslideID',	''),
(8663,	909,	'_title',	'Florida DUI: What is ‘Actual Physical Control’ | Tampa DUI Defense Attorneys'),
(8664,	909,	'_description',	'If you have been arrested for a DUI, contact The Pawlowski//Mastrilli Law Group, our DUI defense attorneys to fight aggressively to help protect your freedom.'),
(8665,	909,	'_keywords',	''),
(8666,	909,	'_subslideID',	''),
(8669,	911,	'_title',	'Car Accident Injuries: Recovering Lost Wages In Florida | Tampa Auto Accident Attorneys'),
(8670,	911,	'_description',	'At The Pawlowski//Mastrilli Law Group, our experienced car accident attorneys fight aggressively to help victims recover full and fair compensation.'),
(8671,	911,	'_keywords',	''),
(8672,	911,	'_subslideID',	''),
(8673,	959,	'aFhfc_head_code',	''),
(8674,	959,	'aFhfc_footer_code',	''),
(8675,	959,	'_title',	'What You Need To Know About Battery Charges In Florida | Tampa Criminal Defense Attorneys'),
(8676,	959,	'_description',	'If you have been charged, do not hesitate to contact the experienced criminal defense attorneys at The Pawlowski//Mastrilli Law Group today.'),
(8677,	959,	'_keywords',	''),
(8678,	959,	'_subslideID',	''),
(8681,	961,	'_title',	'Florida Product Liability Claims | Tampa Product Liability Attorneys'),
(8682,	961,	'_description',	'At The Pawlowski//Mastrilli Law Group, our defective products attorneys have the experience necessary to help you recover the compensation you deserve.'),
(8683,	961,	'_keywords',	''),
(8684,	961,	'_subslideID',	''),
(8687,	963,	'_title',	'First Deadly Self Driving Car Accident Occurs In Florida | Tampa Personal Injury Lawyers'),
(8688,	963,	'_description',	'If you have been injured in car accident, the passionate attorneys at The Pawlowski//Mastrilli Law Group in Tampa can help.'),
(8689,	963,	'_keywords',	''),
(8690,	963,	'_subslideID',	''),
(8693,	965,	'_title',	'Florida DUI Arrests: Administrative License Suspension | Tampa DUI Defense Lawyers'),
(8694,	965,	'_description',	'Contact the passionate DUI criminal defense attorneys at The Pawlowski//Mastrilli Law Group for aggressive legal protection.'),
(8695,	965,	'_keywords',	''),
(8696,	965,	'_subslideID',	''),
(8699,	967,	'_title',	'Were You Injured At A Tampa Area Business? | Tampa Premises Liability Lawyers'),
(8700,	967,	'_description',	'If you have been injured at a Florida business, contact an aggressive personal injury attorney at The Pawlowski//Mastrilli Law Group for legal assistance.'),
(8701,	967,	'_keywords',	''),
(8702,	967,	'_subslideID',	''),
(8705,	969,	'_title',	'Florida Personal Injury Lawsuits: Can I Afford An Attorney? | Tampa Personal Injury Lawyers'),
(8706,	969,	'_description',	'If you or a loved one has suffered an injury in the Tampa area, contact the Pawlowski / /Mastrilli Law Group for a free review of your claim.'),
(8707,	969,	'_keywords',	''),
(8708,	969,	'_subslideID',	''),
(8709,	1024,	'aFhfc_head_code',	''),
(8710,	1024,	'aFhfc_footer_code',	''),
(8711,	1024,	'_title',	'What Will A Florida Truck Accident Attorney Do For You? | Tampa Personal Injury Attorneys'),
(8712,	1024,	'_description',	'If you have been injured in a truck accident, the experienced truck accident attorneys at The Pawlowski//Mastrilli Law Group are standing by, ready to help.'),
(8713,	1024,	'_keywords',	''),
(8714,	1024,	'_oembed_0a4d9af20ba08cc0dac09bceaf8dbae0',	'{{unknown}}'),
(8715,	1024,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:65:\"https://www.megajustice.com/wp-content/uploads/2016/10/Truck3.jpg\";s:5:\"title\";s:6:\"truck3\";s:7:\"caption\";s:0:\"\";}'),
(8716,	1024,	'_thumbnail_id',	'1033'),
(8717,	1024,	'_subslideID',	''),
(8718,	1024,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:65:\"https://www.megajustice.com/wp-content/uploads/2016/10/Truck3.jpg\";s:5:\"title\";s:14:\"truck accident\";s:7:\"caption\";s:0:\"\";}'),
(8719,	1026,	'aFhfc_head_code',	''),
(8720,	1026,	'aFhfc_footer_code',	''),
(8721,	1026,	'_title',	'My Florida Workers’ Compensation Claim Was Denied, What Can I Do Now? | Tampa Personal Injury Attorneys'),
(8722,	1026,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Florida workers’ compensation attorneys have helped many injured workers recover the full and fair compensation that they deserve.'),
(8723,	1026,	'_keywords',	''),
(8724,	1026,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:74:\"https://www.megajustice.com/wp-content/uploads/2016/10/WorkInjuryClaim.jpg\";s:5:\"title\";s:15:\"workinjuryclaim\";s:7:\"caption\";s:0:\"\";}'),
(8725,	1026,	'_subslideID',	''),
(8728,	1028,	'_title',	'What Is Pediatric Hip Dysplasia? | Tampa Birth Injury Lawyers'),
(8729,	1028,	'_description',	'If your infant has suffered from pediatric hip dysplasia, do not hesitate to contact the medical malpractice attorneys at The Pawlowski//Mastrilli Law Group for help.'),
(8730,	1028,	'_keywords',	''),
(8731,	1028,	'_oembed_81a69fe5bb291213bf073bc4c2e3bf28',	'{{unknown}}'),
(8732,	1028,	'_oembed_7b2e51ce1ac633674a470c2204121087',	'<blockquote class=\"wp-embedded-content\" data-secret=\"c2usm4mJJJ\"><a href=\"https://hipdysplasia.org/developmental-dysplasia-of-the-hip/\">What is Hip Dysplasia?</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"position: absolute; clip: rect(1px, 1px, 1px, 1px);\" title=\"&#8220;What is Hip Dysplasia?&#8221; &#8212; International Hip Dysplasia Institute\" src=\"https://hipdysplasia.org/developmental-dysplasia-of-the-hip/embed/#?secret=c2usm4mJJJ\" data-secret=\"c2usm4mJJJ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>'),
(8733,	1028,	'_oembed_time_7b2e51ce1ac633674a470c2204121087',	'1633394866'),
(8734,	1028,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2016/10/BirthInjury.jpg\";s:5:\"title\";s:11:\"birthinjury\";s:7:\"caption\";s:0:\"\";}'),
(8735,	1028,	'_subslideID',	''),
(8736,	1035,	'aFhfc_head_code',	''),
(8737,	1035,	'aFhfc_footer_code',	''),
(8738,	1035,	'_title',	'Three Ways You Could Be Arrested For A DUI In Florida | Tampa DUI Defense Lawyers'),
(8739,	1035,	'_description',	'If you have been charged with a DUI, contact an aggressive DUI defense attorney at The Pawlowski//Mastrilli Law Group for a free review of your case.'),
(8740,	1035,	'_keywords',	''),
(8741,	1035,	'_oembed_07bb3b55fe27489598beb2211c49d5c9',	'{{unknown}}'),
(8742,	1035,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2016/10/DUI_Check.jpg\";s:5:\"title\";s:9:\"dui_check\";s:7:\"caption\";s:0:\"\";}'),
(8743,	1035,	'_subslideID',	''),
(8746,	1037,	'_title',	'Sealing or Expunging a Criminal Record in Florida - FAQs | Tampa Criminal Defense Attorneys'),
(8747,	1037,	'_description',	'At The Pawlowski//Mastrilli Law Group, our criminal defense lawyers have helped protect the rights of many people throughout the Tampa region.'),
(8748,	1037,	'_keywords',	''),
(8749,	1037,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2016/11/CrimRecord2.jpg\";s:5:\"title\";s:11:\"crimrecord2\";s:7:\"caption\";s:0:\"\";}'),
(8750,	1037,	'_subslideID',	''),
(8751,	1039,	'aFhfc_head_code',	''),
(8752,	1039,	'aFhfc_footer_code',	''),
(8753,	1039,	'_title',	'Did You Suffer A Burn Injury In Florida? | Tampa Personal Injury Attorneys'),
(8754,	1039,	'_description',	'At The Pawlowski//Mastrilli Law Group, our personal injury attorneys have extensive experience helping victims recover the full and fair compensation that they deserve.'),
(8755,	1039,	'_keywords',	''),
(8756,	1039,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2016/11/Fire2.jpg\";s:5:\"title\";s:5:\"fire2\";s:7:\"caption\";s:0:\"\";}'),
(8757,	1039,	'_subslideID',	''),
(8760,	1041,	'_title',	'Traumatic Brain Injury Claims In Florida | Tampa Traumatic Brain Injury Lawyers'),
(8761,	1041,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Florida personal injury lawyers have helped protect the rights many brain injury victims.'),
(8762,	1041,	'_keywords',	''),
(8763,	1041,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2016/10/BrainInjury1.jpg\";s:5:\"title\";s:12:\"braininjury1\";s:7:\"caption\";s:0:\"\";}'),
(8764,	1041,	'_subslideID',	''),
(8765,	1043,	'aFhfc_head_code',	''),
(8766,	1043,	'aFhfc_footer_code',	''),
(8767,	1043,	'_title',	'Nursing Home Residents Have Important Rights | Tampa Nursing Home Abuse Attorneys'),
(8768,	1043,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Tampa nursing home neglect attorneys have extensive experience protecting residents from abuse.'),
(8769,	1043,	'_keywords',	''),
(8770,	1043,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2016/11/NursingHome2.jpg\";s:5:\"title\";s:12:\"nursinghome2\";s:7:\"caption\";s:0:\"\";}'),
(8771,	1043,	'_subslideID',	''),
(8774,	1306,	'_title',	'Highway Fatalities Were Up Significantly In The First Half Of 2016 | Tampa Auto Accident Attorneys'),
(8775,	1306,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Tampa accident attorneys have helped many injured victims throughout the Tampa region, including Oldsmar, Odessa, and Ruskin.'),
(8776,	1306,	'_keywords',	''),
(8777,	1306,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2016/11/Accident.jpg\";s:5:\"title\";s:8:\"accident\";s:7:\"caption\";s:0:\"\";}'),
(8778,	1306,	'_subslideID',	''),
(8779,	1310,	'aFhfc_head_code',	''),
(8780,	1310,	'aFhfc_footer_code',	''),
(8781,	1310,	'_title',	'Six Things You Need To Remember After Being Arrested In Florida | Tampa Criminal Defense Attorneys'),
(8782,	1310,	'_description',	'If you have been arrested in Florida, please contact The Pawlowski//Mastrilli Law Group for aggressive legal defense representation.'),
(8783,	1310,	'_keywords',	''),
(8784,	1310,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2016/11/ArrestWord.jpg\";s:5:\"title\";s:10:\"arrestword\";s:7:\"caption\";s:0:\"\";}'),
(8785,	1310,	'_subslideID',	''),
(8786,	1314,	'aFhfc_head_code',	''),
(8787,	1314,	'aFhfc_footer_code',	''),
(8788,	1314,	'_title',	'Defective Medical Devices Are A Serious Safety Hazard | Tampa Personal Injury Lawyers'),
(8789,	1314,	'_description',	'If you or a loved one has been injured by a defective medical device, contact The Pawlowski//Mastrilli Law Group in Tampa for a free initial case review.'),
(8790,	1314,	'_keywords',	''),
(8791,	1314,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2016/12/HipRepl.jpg\";s:5:\"title\";s:7:\"hiprepl\";s:7:\"caption\";s:0:\"\";}'),
(8792,	1314,	'_subslideID',	''),
(8795,	1316,	'_title',	'Were You Injured In A Slip And Fall Accident? | Tampa Premises Liability Lawyers'),
(8796,	1316,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Tampa premises liability lawyers have helped many slip and fall victims recover fair compensation for their accident.'),
(8797,	1316,	'_keywords',	''),
(8798,	1316,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2016/12/Slip.jpg\";s:5:\"title\";s:4:\"Slip\";s:7:\"caption\";s:0:\"\";}'),
(8799,	1316,	'_subslideID',	''),
(8800,	1318,	'aFhfc_head_code',	''),
(8801,	1318,	'aFhfc_footer_code',	''),
(8802,	1318,	'_title',	'Florida Car Accidents: How To Handle An Uninsured Motorist | Tampa Auto Accident Attorneys'),
(8803,	1318,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Tampa car accident attorneys have extensive experience handling Florida uninsured motorist claims.'),
(8804,	1318,	'_keywords',	''),
(8805,	1318,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2016/12/CarInsur2.jpg\";s:5:\"title\";s:9:\"CarInsur2\";s:7:\"caption\";s:0:\"\";}'),
(8806,	1318,	'_subslideID',	''),
(8809,	1320,	'_title',	'Were You Injured In A Tampa Bay Uber Accident? | Tampa Personal Injury Attorneys'),
(8810,	1320,	'_description',	'If you have been seriously injured in an Florida Uber or Lyft accident, contact The Pawlowski//Mastrilli Law Group car wreck lawyers to protect your legal rights.'),
(8811,	1320,	'_keywords',	''),
(8812,	1320,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2016/12/Accident4.jpg\";s:5:\"title\";s:9:\"Accident4\";s:7:\"caption\";s:0:\"\";}'),
(8813,	1320,	'_subslideID',	''),
(8814,	1322,	'aFhfc_head_code',	''),
(8815,	1322,	'aFhfc_footer_code',	''),
(8816,	1322,	'_title',	'The State Of Marijuana Laws And Enforcement In Tampa Bay | Tampa Drug Crimes Attorneys'),
(8817,	1322,	'_description',	'If you have been arrested for drug possession, please get your case in the hands of our experienced Tampa drug crimes lawyers at The Pawlowski//Mastrilli Law Group as soon as possible.'),
(8818,	1322,	'_keywords',	''),
(8819,	1322,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2016/12/Marijuana2.jpg\";s:5:\"title\";s:10:\"Marijuana2\";s:7:\"caption\";s:0:\"\";}'),
(8820,	1322,	'_subslideID',	''),
(8823,	1465,	'_title',	'Were You The Victim Of Dental Malpractice In Tampa | Tampa Dental Malpractice Attorneys'),
(8824,	1465,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Florida medical malpractice lawyers work aggressively to help victims recover the compensation they deserve.'),
(8825,	1465,	'_keywords',	''),
(8826,	1465,	'_thumbnail_id',	'1467'),
(8827,	1465,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2017/01/DentalM.jpg\";s:5:\"title\";s:7:\"DentalM\";s:7:\"caption\";s:0:\"\";}'),
(8828,	1465,	'_subslideID',	''),
(8830,	1468,	'aFhfc_head_code',	''),
(8831,	1468,	'aFhfc_footer_code',	''),
(8832,	1468,	'_title',	'What To Do After A Dog Bite In Florida | Tampa Personal Injury Attorneys'),
(8833,	1468,	'_description',	'The Pawlowski//Mastrilli Law Group represents injury victims throughout the Tampa region, including in Hillsborough County, Pinellas County and Pasco County.'),
(8834,	1468,	'_keywords',	''),
(8835,	1468,	'_thumbnail_id',	'1504'),
(8836,	1468,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:62:\"https://www.megajustice.com/wp-content/uploads/2017/01/Dog.jpg\";s:5:\"title\";s:3:\"Dog\";s:7:\"caption\";s:0:\"\";}'),
(8837,	1468,	'_subslideID',	''),
(8838,	1468,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:62:\"https://www.megajustice.com/wp-content/uploads/2017/01/Dog.jpg\";s:5:\"title\";s:3:\"Dog\";s:7:\"caption\";s:0:\"\";}'),
(8839,	1470,	'aFhfc_head_code',	''),
(8840,	1470,	'aFhfc_footer_code',	''),
(8841,	1470,	'_title',	'Florida Wrongful Death Claims: Four Frequently Asked Questions | Tampa Wrongful Death Attorneys'),
(8842,	1470,	'_description',	'At The Pawlowski//Mastrilli Law Group, our compassionate Tampa wrongful death attorneys have helped many families take legal action after the avoidable death of a loved one.'),
(8843,	1470,	'_keywords',	''),
(8844,	1470,	'_subslideID',	''),
(8847,	1472,	'_title',	'Exploding E-Cigarette Severely Burns Man | Tampa Product Liability Lawyers'),
(8848,	1472,	'_description',	'The Pawlowski//Mastrilli Law Group proudly serves victims throughout the Tampa Bay region, including in Saint Petersburg and Durant.'),
(8849,	1472,	'_keywords',	''),
(8850,	1472,	'_thumbnail_id',	'1486'),
(8851,	1472,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:65:\"https://www.megajustice.com/wp-content/uploads/2017/01/ECigg2.jpg\";s:5:\"title\";s:6:\"ECigg2\";s:7:\"caption\";s:0:\"\";}'),
(8852,	1472,	'_subslideID',	''),
(8854,	1474,	'aFhfc_head_code',	''),
(8855,	1474,	'aFhfc_footer_code',	''),
(8856,	1474,	'_title',	'The Importance Of Gathering Evidence In A Florida DUI Case | Tampa DUI Defense Attorneys'),
(8857,	1474,	'_description',	'The Pawlowski//Mastrilli Law Group represents clients throughout the Tampa region, including in Pasco County, Hillsborough County and Pinellas County.'),
(8858,	1474,	'_keywords',	''),
(8859,	1474,	'_thumbnail_id',	'1524'),
(8860,	1474,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/01/DUI5.jpg\";s:5:\"title\";s:4:\"DUI5\";s:7:\"caption\";s:0:\"\";}'),
(8861,	1474,	'_subslideID',	''),
(8862,	1474,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/01/DUI5.jpg\";s:5:\"title\";s:4:\"DUI5\";s:7:\"caption\";s:0:\"\";}'),
(8863,	1534,	'aFhfc_head_code',	''),
(8864,	1534,	'aFhfc_footer_code',	''),
(8865,	1534,	'_title',	'Repetitive Stress Injuries And Florida Workers’ Compensation Claims | Tampa Workers Compensation Lawyers'),
(8866,	1534,	'_description',	'The workers’ compensation lawyers at The Pawlowski//Mastrilli Law Group protect the rights of injured workers in the Tampa Bay region, Pasco County and Hillsborough County.'),
(8867,	1534,	'_keywords',	''),
(8868,	1534,	'_thumbnail_id',	'1536'),
(8869,	1534,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/02/WC_1.jpg\";s:5:\"title\";s:4:\"WC_1\";s:7:\"caption\";s:0:\"\";}'),
(8870,	1534,	'_subslideID',	''),
(8871,	1534,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/02/WC_1.jpg\";s:5:\"title\";s:4:\"WC_1\";s:7:\"caption\";s:0:\"\";}'),
(8872,	1537,	'aFhfc_head_code',	''),
(8873,	1537,	'aFhfc_footer_code',	''),
(8874,	1537,	'_title',	'What Happens If You Violate Probation In Florida? | Tampa Criminal Defense Lawyers'),
(8875,	1537,	'_description',	'If you have been accused of violating probation in Florida, contact the aggressive criminal defense lawyers at The Pawlowski//Mastrilli Law Group in Tampa for help.'),
(8876,	1537,	'_keywords',	''),
(8877,	1537,	'_thumbnail_id',	'1553'),
(8878,	1537,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2017/02/Probation.jpg\";s:5:\"title\";s:9:\"Probation\";s:7:\"caption\";s:0:\"\";}'),
(8879,	1537,	'_subslideID',	''),
(8880,	1537,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2017/02/Probation.jpg\";s:5:\"title\";s:9:\"Probation\";s:7:\"caption\";s:0:\"\";}'),
(8883,	1539,	'_title',	'How To Strengthen Commercial Trucking Safety | Tampa Truck Accident Lawyers'),
(8884,	1539,	'_description',	'Please contact the truck accident lawyers at The Pawlowski//Mastrilli Law Group in Tampa for immediate legal assistance, free initial consultation available.'),
(8885,	1539,	'_keywords',	''),
(8886,	1539,	'_thumbnail_id',	'1568'),
(8887,	1539,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2017/02/TruckAcc.jpg\";s:5:\"title\";s:8:\"TruckAcc\";s:7:\"caption\";s:0:\"\";}'),
(8888,	1539,	'_subslideID',	''),
(8890,	1541,	'aFhfc_head_code',	''),
(8891,	1541,	'aFhfc_footer_code',	''),
(8892,	1541,	'_title',	'Four Tips For Dealing With The Insurance Adjuster After A Florida Car Accident | Tampa Auto Accident Attorneys'),
(8893,	1541,	'_description',	'Please contact the experienced personal injury attorneys at The Pawlowski//Mastrilli Law Group for immediate assistance with your insurance company following a car accident.'),
(8894,	1541,	'_keywords',	''),
(8895,	1541,	'_thumbnail_id',	'1578'),
(8896,	1541,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2017/02/CarInsur.jpg\";s:5:\"title\";s:8:\"CarInsur\";s:7:\"caption\";s:0:\"\";}'),
(8897,	1541,	'_subslideID',	''),
(8898,	1541,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2017/02/CarInsur.jpg\";s:5:\"title\";s:8:\"CarInsur\";s:7:\"caption\";s:0:\"\";}'),
(8899,	1594,	'_thumbnail_id',	'1595'),
(8902,	1594,	'_title',	'Understanding Evidence: The Chain Of Custody | Tampa Criminal Defense Lawyers'),
(8903,	1594,	'_description',	'At The Pawlowski//Mastrilli Law Group we protect the rights of individuals throughout the Tampa region, including in Dover, Brandon, Thonotosassa, Lithia and Durant.'),
(8904,	1594,	'_keywords',	''),
(8905,	1594,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2017/03/CrimDef2.jpg\";s:5:\"title\";s:8:\"CrimDef2\";s:7:\"caption\";s:0:\"\";}'),
(8906,	1594,	'_subslideID',	''),
(8910,	1597,	'_title',	'Florida Appeals Court Denies Defendant’s Motion To Suppress Evidence | Tampa Criminal Defense Lawyers'),
(8911,	1597,	'_description',	'If you have been charged with a crime, contact the aggressive criminal defense attorneys at The Pawlowski//Mastrilli Law Group for help.'),
(8912,	1597,	'_keywords',	''),
(8913,	1597,	'_thumbnail_id',	'1626'),
(8914,	1597,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2017/03/Gavel_Cuffs2.jpg\";s:5:\"title\";s:12:\"Gavel_Cuffs2\";s:7:\"caption\";s:0:\"\";}'),
(8915,	1597,	'_subslideID',	''),
(8919,	1599,	'_title',	'Florida Personal Injury Claims: Amputations and Loss of Limbs | Tampa Personal Injury Attorneys'),
(8920,	1599,	'_description',	'At The Pawlowski//Mastrilli Law Group, our personal injury team has experience handling catastrophic injury claims, including cases involving loss of limb and amputations.'),
(8921,	1599,	'_keywords',	''),
(8922,	1599,	'_thumbnail_id',	'1690'),
(8923,	1599,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2017/03/InjuryClaim.jpg\";s:5:\"title\";s:11:\"InjuryClaim\";s:7:\"caption\";s:0:\"\";}'),
(8924,	1599,	'_subslideID',	''),
(8928,	1601,	'_title',	'Were You Injured In A Swimming Pool Accident? Learn More About Your Legal Rights | Tampa Premises Liability Lawyers'),
(8929,	1601,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Tampa premises liability attorneys have extensive experience handling swimming pool accident claims.'),
(8930,	1601,	'_keywords',	''),
(8931,	1601,	'_thumbnail_id',	'1615'),
(8932,	1601,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2017/03/Pool3.jpg\";s:5:\"title\";s:5:\"Pool3\";s:7:\"caption\";s:0:\"\";}'),
(8933,	1601,	'_subslideID',	''),
(8935,	1754,	'_thumbnail_id',	'1755'),
(8936,	1754,	'_title',	'You Should Always Take Pictures After A Car Accident | Tampa Bay Car Accident Lawyers'),
(8937,	1754,	'_description',	'The Pawlowski//Mastrilli Law Group represents victims throughout the Tampa region, including in Valrico, Sydney, Apollo Beach, Dover, Brandon and Thonotosassa.'),
(8938,	1754,	'_keywords',	''),
(8939,	1754,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2017/04/CellAccident.jpg\";s:5:\"title\";s:12:\"CellAccident\";s:7:\"caption\";s:0:\"\";}'),
(8940,	1754,	'_subslideID',	''),
(8941,	1754,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2017/04/CellAccident.jpg\";s:5:\"title\";s:12:\"CellAccident\";s:7:\"caption\";s:0:\"\";}'),
(8942,	1757,	'_title',	'Florida Rental Car Accidents: Understanding Liability | Tampa Auto Accident Attorneys'),
(8943,	1757,	'_description',	'At The Pawlowski//Mastrilli Law Group, our aggressive Tampa car accident lawyers have helped many victims recover fair injury compensation.'),
(8944,	1757,	'_keywords',	''),
(8945,	1757,	'_thumbnail_id',	'1759'),
(8946,	1757,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2017/04/CarAcc4.jpg\";s:5:\"title\";s:7:\"CarAcc4\";s:7:\"caption\";s:0:\"\";}'),
(8947,	1757,	'_subslideID',	''),
(8949,	1761,	'_thumbnail_id',	'1762'),
(8950,	1761,	'_title',	'What You Need To Know About Florida’s Pre-Trial Intervention Program | Tampa Criminal Defense Attorneys'),
(8951,	1761,	'_description',	'If you or a loved one is facing criminal charges in Florida, please contact our Tampa Bay criminal defense attorneys at The Pawlowski//Mastrilli Law Group for help.'),
(8952,	1761,	'_keywords',	''),
(8953,	1761,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2017/04/Arrest_Bars.jpg\";s:5:\"title\";s:11:\"Arrest_Bars\";s:7:\"caption\";s:0:\"\";}'),
(8954,	1761,	'_subslideID',	''),
(8955,	1761,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2017/04/Arrest_Bars.jpg\";s:5:\"title\";s:11:\"Arrest_Bars\";s:7:\"caption\";s:0:\"\";}'),
(8956,	1764,	'_thumbnail_id',	'1765'),
(8957,	1764,	'_title',	'Tampa Roofing Company Failed To Follow Safety Regulations, Now Faces DOL Lawsuit | Tampa Workers Compensation Lawyers'),
(8958,	1764,	'_description',	'At The Pawlowski//Mastrilli Law Group in Tampa, we have extensive experience handling Florida workers’ compensation claims.'),
(8959,	1764,	'_keywords',	''),
(8960,	1764,	'_subslideID',	''),
(8961,	1764,	'_wp_old_slug',	'tampa-roofing-company-failed-to-follow-safety-regulations-now-faces-dol-lawsuit'),
(8962,	1764,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/04/WC_2.jpg\";s:5:\"title\";s:4:\"WC_2\";s:7:\"caption\";s:0:\"\";}'),
(8964,	1769,	'_title',	'Florida Car Accident Injuries: Whiplash | Tampa Bay Car Accident Lawyers'),
(8965,	1769,	'_description',	'The aggressive auto accident claims attorneys at The Pawlowski//Mastrilli Law Group can help if you were injured in a car accident in Tampa.'),
(8966,	1769,	'_keywords',	''),
(8967,	1769,	'_thumbnail_id',	'1771'),
(8968,	1769,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2017/04/Whiplash.jpg\";s:5:\"title\";s:8:\"Whiplash\";s:7:\"caption\";s:0:\"\";}'),
(8969,	1769,	'_subslideID',	''),
(8970,	1769,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2017/04/Whiplash.jpg\";s:5:\"title\";s:8:\"Whiplash\";s:7:\"caption\";s:0:\"\";}'),
(8971,	1791,	'_title',	'Can Florida Police Search Your Cell Phone? | Tampa Criminal Defense Attorneys'),
(8972,	1791,	'_description',	'If you are facing criminal charges in Florida, contact our Tampa office today at The Pawlowski//Mastrilli Law Group for a free initial consultation.'),
(8973,	1791,	'_keywords',	''),
(8974,	1791,	'_thumbnail_id',	'1794'),
(8975,	1791,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2017/05/CellPhone.jpg\";s:5:\"title\";s:9:\"CellPhone\";s:7:\"caption\";s:0:\"\";}'),
(8976,	1791,	'_subslideID',	''),
(8978,	1795,	'_title',	'Landlord Liability For Florida Dog Bite Injuries | Tampa Personal Injury Lawyers'),
(8979,	1795,	'_description',	'At The Pawlowski//Mastrilli Law Group in Tampa, our dedicated personal injury attorneys have the skills and experience necessary to hold negligent landlords liable.'),
(8980,	1795,	'_keywords',	''),
(8981,	1795,	'_thumbnail_id',	'1804'),
(8982,	1795,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/05/Dog4.jpg\";s:5:\"title\";s:4:\"Dog4\";s:7:\"caption\";s:0:\"\";}'),
(8983,	1795,	'_subslideID',	''),
(8984,	1795,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/05/Dog4.jpg\";s:5:\"title\";s:4:\"Dog4\";s:7:\"caption\";s:0:\"\";}'),
(8985,	1797,	'_title',	'Florida Appeals Court Rules In Favor Of Plaintiff In Slip And Fall Case | Tampa Bay Premises Liability Lawyers'),
(8986,	1797,	'_description',	'At The Pawlowski//Mastrilli Law Group, we represent victims throughout the region, including in Hillsborough County, Pasco County and Pinellas County.'),
(8987,	1797,	'_keywords',	''),
(8988,	1797,	'_thumbnail_id',	'1820'),
(8989,	1797,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2017/05/SlipFall.jpg\";s:5:\"title\";s:8:\"SlipFall\";s:7:\"caption\";s:0:\"\";}'),
(8990,	1797,	'_subslideID',	''),
(8992,	1799,	'_title',	'Florida Car Accidents Statistics | Tampa Bay Car Accident Lawyers'),
(8993,	1799,	'_description',	'The Pawlowski//Mastrilli Law Group in Tampa Bay has extensive experience handling auto accident claims, including DUI accident cases.'),
(8994,	1799,	'_keywords',	''),
(8995,	1799,	'_thumbnail_id',	'1821'),
(8996,	1799,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2017/05/CarCrash.jpg\";s:5:\"title\";s:8:\"CarCrash\";s:7:\"caption\";s:0:\"\";}'),
(8997,	1799,	'_subslideID',	''),
(8998,	1799,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2017/05/CarCrash.jpg\";s:5:\"title\";s:8:\"CarCrash\";s:7:\"caption\";s:0:\"\";}'),
(8999,	1836,	'_title',	'Were Your Charged With Driving With A Suspended License In Florida? | Tampa Criminal Defense Attorneys'),
(9000,	1836,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Tampa Bay attorneys have extensive experience handling cases involving suspended, revoked, and cancelled license cases.'),
(9001,	1836,	'_keywords',	''),
(9002,	1836,	'_thumbnail_id',	'1838'),
(9003,	1836,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:72:\"https://www.megajustice.com/wp-content/uploads/2017/06/DriverLicense.jpg\";s:5:\"title\";s:13:\"DriverLicense\";s:7:\"caption\";s:0:\"\";}'),
(9004,	1836,	'_subslideID',	''),
(9005,	1836,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:72:\"https://www.megajustice.com/wp-content/uploads/2017/06/DriverLicense.jpg\";s:5:\"title\";s:13:\"DriverLicense\";s:7:\"caption\";s:0:\"\";}'),
(9006,	1839,	'_title',	'Tampa Bay Bus Accidents: Frequently Asked Questions | Florida Personal Injury Attorneys'),
(9007,	1839,	'_description',	'The Pawlowski//Mastrilli Law Group serves communities throughout West Central Florida, including in Hillsborough County, Pasco County and Pinellas County.'),
(9008,	1839,	'_keywords',	''),
(9009,	1839,	'_thumbnail_id',	'1852'),
(9010,	1839,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/06/Bus2.jpg\";s:5:\"title\";s:4:\"Bus2\";s:7:\"caption\";s:0:\"\";}'),
(9011,	1839,	'_subslideID',	''),
(9013,	1841,	'_title',	'FDA Links Breast Implants To Rare Blood Cancer | Florida Defectice Medical Device Litigation Attorneys'),
(9014,	1841,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Florida products liability attorneys have extensive experience handling claims involving defective medical industry products.'),
(9015,	1841,	'_keywords',	''),
(9016,	1841,	'_thumbnail_id',	'1887'),
(9017,	1841,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2017/06/Liability3.jpg\";s:5:\"title\";s:10:\"Liability3\";s:7:\"caption\";s:0:\"\";}'),
(9018,	1841,	'_subslideID',	''),
(9020,	1843,	'_title',	'Florida Boat Accident Injury Lawsuits | Florida Personal Injury Attorneys'),
(9021,	1843,	'_description',	'If you were injured in a boating accident, the Tampa Bay personal injury lawyers at The Pawlowski//Mastrilli Law Group can help.'),
(9022,	1843,	'_keywords',	''),
(9023,	1843,	'_thumbnail_id',	'1865'),
(9024,	1843,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/06/Boat.jpg\";s:5:\"title\";s:4:\"Boat\";s:7:\"caption\";s:0:\"\";}'),
(9025,	1843,	'_subslideID',	''),
(9026,	1843,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/06/Boat.jpg\";s:5:\"title\";s:4:\"Boat\";s:7:\"caption\";s:0:\"\";}'),
(9027,	1901,	'_title',	'Do My Injuries Qualify For Workers’ Compensation In Florida? | Tampa Workers Compensation Lawyers'),
(9028,	1901,	'_description',	'At The Pawlowski//Mastrilli Law Group in Tampa, our team has helped many work injury victims obtain their full and fair benefits.'),
(9029,	1901,	'_keywords',	''),
(9030,	1901,	'_thumbnail_id',	'1903'),
(9031,	1901,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/06/WC_3.jpg\";s:5:\"title\";s:4:\"WC_3\";s:7:\"caption\";s:0:\"\";}'),
(9032,	1901,	'_subslideID',	''),
(9033,	1901,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/06/WC_3.jpg\";s:5:\"title\";s:4:\"WC_3\";s:7:\"caption\";s:0:\"\";}'),
(9034,	1905,	'_title',	'Florida Medical Malpractice: Anesthesia Errors | Tampa Medical Malpractice Attorneys'),
(9035,	1905,	'_description',	'At The Pawlowski//Mastrilli Law Group, our Tampa medical malpractice lawyers have helped many victims recover full compensation for their damages.'),
(9036,	1905,	'_keywords',	''),
(9037,	1905,	'_thumbnail_id',	'1907'),
(9038,	1905,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2017/06/MedMal5.jpg\";s:5:\"title\";s:7:\"MedMal5\";s:7:\"caption\";s:0:\"\";}'),
(9039,	1905,	'_subslideID',	''),
(9041,	1909,	'_title',	'Were You Arrested For DUI In Tampa? You Have Ten Days To Take Action | Tampa DUI Defense Attorneys'),
(9042,	1909,	'_description',	'The Pawlowski//Mastrilli Law Group in Tampa Bay serves communities throughout the region, including in Hillsborough County, Pinellas County and Pasco County.'),
(9043,	1909,	'_keywords',	''),
(9044,	1909,	'_thumbnail_id',	'1911'),
(9045,	1909,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/06/DUI5.jpg\";s:5:\"title\";s:4:\"DUI5\";s:7:\"caption\";s:0:\"\";}'),
(9046,	1909,	'_subslideID',	''),
(9047,	1909,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2017/06/DUI5.jpg\";s:5:\"title\";s:4:\"DUI5\";s:7:\"caption\";s:0:\"\";}'),
(9048,	2803,	'_thumbnail_id',	'2804'),
(9049,	2803,	'_title',	'Custody Doesn’t Mean What You Think In Florida | Tampa Family Law Attorneys'),
(9050,	2803,	'_description',	'If you have a Florida divorce or child custody problem, contact Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for help.'),
(9051,	2803,	'_keywords',	''),
(9052,	2803,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2018/10/Custody2.jpg\";s:5:\"title\";s:8:\"Custody2\";s:7:\"caption\";s:0:\"\";}'),
(9053,	2803,	'_subslideID',	''),
(9054,	2803,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2018/10/Custody2.jpg\";s:5:\"title\";s:8:\"Custody2\";s:7:\"caption\";s:0:\"\";}'),
(9055,	2806,	'_thumbnail_id',	'2807'),
(9056,	2806,	'_title',	'Florida Supreme Court Gives Rights To Biological Fathers | Tampa Family Lawyers'),
(9057,	2806,	'_description',	'If you have a paternity, custody or child support issue in Florida, contact Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for help.'),
(9058,	2806,	'_keywords',	''),
(9059,	2806,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2018/10/Parenting1.jpg\";s:5:\"title\";s:10:\"Parenting1\";s:7:\"caption\";s:0:\"\";}'),
(9060,	2806,	'_subslideID',	''),
(9061,	2806,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2018/10/Parenting1.jpg\";s:5:\"title\";s:10:\"Parenting1\";s:7:\"caption\";s:0:\"\";}'),
(9062,	2830,	'_thumbnail_id',	'2831'),
(9063,	2830,	'_title',	'Understand The Purpose And Types Of Alimony | Tampa Family Lawyers'),
(9064,	2830,	'_description',	'Contact Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for help.'),
(9065,	2830,	'_keywords',	''),
(9066,	2830,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2018/11/Alimony8.jpg\";s:5:\"title\";s:8:\"Alimony8\";s:7:\"caption\";s:0:\"\";}'),
(9067,	2830,	'_subslideID',	''),
(9068,	2830,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2018/11/Alimony8.jpg\";s:5:\"title\";s:8:\"Alimony8\";s:7:\"caption\";s:0:\"\";}'),
(9069,	2833,	'_thumbnail_id',	'2834'),
(9070,	2833,	'_title',	'You Can’t Underemploy Yourself To Avoid Payments In A Divorce | Tampa Family Lawyers'),
(9071,	2833,	'_description',	'Contact the Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for a consultation about your rights.'),
(9072,	2833,	'_keywords',	''),
(9073,	2833,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2018/11/CSupport5.jpg\";s:5:\"title\";s:9:\"CSupport5\";s:7:\"caption\";s:0:\"\";}'),
(9074,	2833,	'_subslideID',	''),
(9075,	2833,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2018/11/CSupport5.jpg\";s:5:\"title\";s:9:\"CSupport5\";s:7:\"caption\";s:0:\"\";}'),
(9076,	2869,	'_title',	'Should You Ask For A Guardian Ad Litem In A Custody Case? | Tampa Family Lawyers'),
(9077,	2869,	'_description',	'If you are getting divorced and are seeking custody of minor children, contact Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for help.'),
(9078,	2869,	'_keywords',	''),
(9079,	2869,	'_thumbnail_id',	'2871'),
(9080,	2869,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2018/11/Custody5.jpg\";s:5:\"title\";s:8:\"Custody5\";s:7:\"caption\";s:0:\"\";}'),
(9081,	2869,	'_subslideID',	''),
(9082,	2869,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2018/11/Custody5.jpg\";s:5:\"title\";s:8:\"Custody5\";s:7:\"caption\";s:0:\"\";}'),
(9083,	2872,	'_thumbnail_id',	'2873'),
(9084,	2872,	'_title',	'Planning Tips If You Are Thinking About Divorce | Tampa Divorce Lawyers'),
(9085,	2872,	'_description',	'If you are getting divorced and have questions about what to expect, contact the Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for guidance.'),
(9086,	2872,	'_keywords',	''),
(9087,	2872,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2018/11/Div12.jpg\";s:5:\"title\";s:5:\"Div12\";s:7:\"caption\";s:0:\"\";}'),
(9088,	2872,	'_subslideID',	''),
(9089,	2872,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2018/11/Div12.jpg\";s:5:\"title\";s:5:\"Div12\";s:7:\"caption\";s:0:\"\";}'),
(9090,	2900,	'_thumbnail_id',	'2901'),
(9091,	2900,	'_title',	'Can You Get A Garnishment If An Ex Stops Paying Support? | Tampa Family Lawyers'),
(9092,	2900,	'_description',	'Contact the Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for help and advice about enforcing a family law judgment.'),
(9093,	2900,	'_keywords',	''),
(9094,	2900,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2018/12/CSupport6.jpg\";s:5:\"title\";s:9:\"CSupport6\";s:7:\"caption\";s:0:\"\";}'),
(9095,	2900,	'_subslideID',	''),
(9096,	2900,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2018/12/CSupport6.jpg\";s:5:\"title\";s:9:\"CSupport6\";s:7:\"caption\";s:0:\"\";}'),
(9097,	2903,	'_title',	'Modifying Parenting Plans | Tampa Divorce Lawyers'),
(9098,	2903,	'_description',	'Contact the Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for help and advice.'),
(9099,	2903,	'_keywords',	''),
(9100,	2903,	'_thumbnail_id',	'2905'),
(9101,	2903,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2018/12/MomDaughter2.jpg\";s:5:\"title\";s:12:\"MomDaughter2\";s:7:\"caption\";s:0:\"\";}'),
(9102,	2903,	'_subslideID',	''),
(9103,	2903,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2018/12/MomDaughter2.jpg\";s:5:\"title\";s:12:\"MomDaughter2\";s:7:\"caption\";s:0:\"\";}'),
(9104,	2906,	'_title',	'Make Sure Your Prenuptial Agreement Isn’t Ambiguous | Tampa Family Law Attorneys'),
(9105,	2906,	'_description',	'Contact Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for a help and advice about drafting or reviewing any prenuptial agreements you may need.'),
(9106,	2906,	'_keywords',	''),
(9107,	2906,	'_thumbnail_id',	'2925'),
(9108,	2906,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2018/12/Prenup5.jpg\";s:5:\"title\";s:7:\"Prenup5\";s:7:\"caption\";s:0:\"\";}'),
(9109,	2906,	'_subslideID',	''),
(9110,	2906,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2018/12/Prenup5.jpg\";s:5:\"title\";s:7:\"Prenup5\";s:7:\"caption\";s:0:\"\";}'),
(9111,	2908,	'_title',	'Why Do Insurance Companies Fight Car Accident Cases | Tampa Car Accident Lawyers'),
(9112,	2908,	'_description',	'If you are in a car accident, contact Tampa injury law attorneys at The Pawlowski//Mastrilli Law Group for a help and advice.'),
(9113,	2908,	'_keywords',	''),
(9114,	2908,	'_thumbnail_id',	'2927'),
(9115,	2908,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2018/12/Accident5.jpg\";s:5:\"title\";s:9:\"Accident5\";s:7:\"caption\";s:0:\"\";}'),
(9116,	2908,	'_subslideID',	''),
(9117,	2908,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2018/12/Accident5.jpg\";s:5:\"title\";s:9:\"Accident5\";s:7:\"caption\";s:0:\"\";}'),
(9118,	2959,	'_title',	'What Can You Expect In Your Family Law Deposition? | Tampa Family Law Attorneys'),
(9119,	2959,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you through the toughest parts of your divorce or custody trial.'),
(9120,	2959,	'_keywords',	''),
(9121,	2959,	'_thumbnail_id',	'2983'),
(9122,	2959,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/01/Family4.jpg\";s:5:\"title\";s:7:\"Family4\";s:7:\"caption\";s:0:\"\";}'),
(9123,	2959,	'_subslideID',	''),
(9124,	2959,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/01/Family4.jpg\";s:5:\"title\";s:7:\"Family4\";s:7:\"caption\";s:0:\"\";}'),
(9125,	2961,	'_title',	'Accounting Or Business Valuation Expert For Your Divorce | Tampa Divorce Lawyers'),
(9126,	2961,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you make sure that your marital assets are fairly divided if you are getting divorced.'),
(9127,	2961,	'_keywords',	''),
(9128,	2961,	'_thumbnail_id',	'2998'),
(9129,	2961,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/01/Divorce8.jpg\";s:5:\"title\";s:8:\"Divorce8\";s:7:\"caption\";s:0:\"\";}'),
(9130,	2961,	'_subslideID',	''),
(9131,	2961,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/01/Divorce8.jpg\";s:5:\"title\";s:8:\"Divorce8\";s:7:\"caption\";s:0:\"\";}'),
(9132,	2963,	'_title',	'The Benefits Of Collaborative Divorces | Tampa Divorce Lawyers'),
(9133,	2963,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you negotiate a divorce, or help you try your divorce case in court.'),
(9134,	2963,	'_keywords',	''),
(9135,	2963,	'_thumbnail_id',	'2985'),
(9136,	2963,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:72:\"https://www.megajustice.com/wp-content/uploads/2019/01/ArguingCouple.jpg\";s:5:\"title\";s:13:\"ArguingCouple\";s:7:\"caption\";s:0:\"\";}'),
(9137,	2963,	'_subslideID',	''),
(9138,	2963,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:72:\"https://www.megajustice.com/wp-content/uploads/2019/01/ArguingCouple.jpg\";s:5:\"title\";s:13:\"ArguingCouple\";s:7:\"caption\";s:0:\"\";}'),
(9139,	2965,	'_title',	'Drowsy Driving Is A Serious Problem | Tampa Car Accident Lawyers'),
(9140,	2965,	'_description',	'Tampa injury law attorneys at The Pawlowski//Mastrilli Law Group can provide you help and advice about obtaining damages if you are in a car accident.'),
(9141,	2965,	'_keywords',	''),
(9142,	2965,	'_thumbnail_id',	'3006'),
(9143,	2965,	'_subslideID',	''),
(9144,	2965,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/01/Drowsy3.jpg\";s:5:\"title\";s:7:\"Drowsy3\";s:7:\"caption\";s:0:\"\";}'),
(9145,	2965,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/01/Drowsy3.jpg\";s:5:\"title\";s:7:\"Drowsy3\";s:7:\"caption\";s:0:\"\";}'),
(9146,	2967,	'_thumbnail_id',	'2968'),
(9147,	2967,	'_title',	'Inability To Pay Alimony Or Child Support | Tampa Family Law Attorneys'),
(9148,	2967,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you handle these problems as well as explore options for modifying divorce support orders.'),
(9149,	2967,	'_keywords',	''),
(9150,	2967,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/01/FamCourt.jpg\";s:5:\"title\";s:8:\"FamCourt\";s:7:\"caption\";s:0:\"\";}'),
(9151,	2967,	'_subslideID',	''),
(9152,	2967,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/01/FamCourt.jpg\";s:5:\"title\";s:8:\"FamCourt\";s:7:\"caption\";s:0:\"\";}'),
(9153,	2970,	'_thumbnail_id',	'2971'),
(9154,	2970,	'_title',	'Pet Custody Findings | Tampa Family Lawyers'),
(9155,	2970,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you handle these problems and let you know what to expect in your divorce case.'),
(9156,	2970,	'_keywords',	''),
(9157,	2970,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/01/PetCustody.jpg\";s:5:\"title\";s:10:\"PetCustody\";s:7:\"caption\";s:0:\"\";}'),
(9158,	2970,	'_subslideID',	''),
(9159,	2970,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/01/PetCustody.jpg\";s:5:\"title\";s:10:\"PetCustody\";s:7:\"caption\";s:0:\"\";}'),
(9160,	3038,	'_thumbnail_id',	'3039'),
(9161,	3038,	'_title',	'Lessons To Be Learned From Amazon’s Jeff Bezos’ Divorce | Tampa Divorce Lawyers'),
(9162,	3038,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you handle these problems.'),
(9163,	3038,	'_keywords',	''),
(9164,	3038,	'_subslideID',	''),
(9165,	3038,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/02/Divorce2.jpg\";s:5:\"title\";s:8:\"Divorce2\";s:7:\"caption\";s:0:\"\";}'),
(9166,	3038,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/02/Divorce2.jpg\";s:5:\"title\";s:8:\"Divorce2\";s:7:\"caption\";s:0:\"\";}'),
(9167,	3041,	'_thumbnail_id',	'3042'),
(9168,	3041,	'_title',	'What Is A QDRO In A Divorce Case And Do You Need One? | Tampa Asset & Debt Division Lawyers'),
(9169,	3041,	'_description',	'The Tampa asset and debt division attorneys at The Pawlowski//Mastrilli Law Group can help you handle problems dividing property.'),
(9170,	3041,	'_keywords',	''),
(9171,	3041,	'_subslideID',	''),
(9172,	3041,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/02/DivDecree.jpg\";s:5:\"title\";s:9:\"DivDecree\";s:7:\"caption\";s:0:\"\";}'),
(9173,	3041,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/02/DivDecree.jpg\";s:5:\"title\";s:9:\"DivDecree\";s:7:\"caption\";s:0:\"\";}'),
(9174,	3044,	'_title',	'Grandparents Custody And Time-Sharing Rights | Tampa Child Custody Lawyers'),
(9175,	3044,	'_description',	'Make sure to contact the Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for a help and advice about custody, time sharing or visitation issues.'),
(9176,	3044,	'_keywords',	''),
(9177,	3044,	'_subslideID',	''),
(9178,	3044,	'_thumbnail_id',	'3053'),
(9179,	3044,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/02/Grandmother.jpg\";s:5:\"title\";s:11:\"Grandmother\";s:7:\"caption\";s:0:\"\";}'),
(9180,	3044,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/02/Grandmother.jpg\";s:5:\"title\";s:11:\"Grandmother\";s:7:\"caption\";s:0:\"\";}'),
(9181,	3046,	'_title',	'Dividing Marital Debt | Tampa Asset Debt Division Attorneys'),
(9182,	3046,	'_description',	'Reach out to our Tampa family law attorneys at The Pawlowski//Mastrilli Law Group for a help and advice about negotiating a divorce.'),
(9183,	3046,	'_keywords',	''),
(9184,	3046,	'_subslideID',	''),
(9185,	3046,	'_thumbnail_id',	'3055'),
(9186,	3046,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/02/DivMoney.jpg\";s:5:\"title\";s:8:\"DivMoney\";s:7:\"caption\";s:0:\"\";}'),
(9187,	3046,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/02/DivMoney.jpg\";s:5:\"title\";s:8:\"DivMoney\";s:7:\"caption\";s:0:\"\";}'),
(9188,	3079,	'_title',	'Are Roundabouts The Key To Making The Roads Safer? | Tampa Car Accident Lawyers'),
(9189,	3079,	'_description',	'Tampa injury law attorneys at The Pawlowski//Mastrilli Law Group can provide you help in obtaining damages for injuries sustained in any type of car accident.'),
(9190,	3079,	'_keywords',	''),
(9191,	3079,	'_subslideID',	''),
(9192,	3079,	'_thumbnail_id',	'3098'),
(9193,	3079,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/02/Roundabout.jpg\";s:5:\"title\";s:10:\"Roundabout\";s:7:\"caption\";s:0:\"\";}'),
(9194,	3079,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/02/Roundabout.jpg\";s:5:\"title\";s:10:\"Roundabout\";s:7:\"caption\";s:0:\"\";}'),
(9195,	3081,	'_title',	'Assets In A Divorce | Tampa Divorce Lawyers'),
(9196,	3081,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you with your family law legal problems and questions.'),
(9197,	3081,	'_keywords',	''),
(9198,	3081,	'_subslideID',	''),
(9199,	3081,	'_thumbnail_id',	'3100'),
(9200,	3081,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2019/02/Div17.jpg\";s:5:\"title\";s:5:\"Div17\";s:7:\"caption\";s:0:\"\";}'),
(9201,	3081,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2019/02/Div17.jpg\";s:5:\"title\";s:5:\"Div17\";s:7:\"caption\";s:0:\"\";}'),
(9202,	3083,	'_title',	'What is a Common Law Marriage? | Tampa Family Lawyers'),
(9203,	3083,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you handle problems involving divorce and custody.'),
(9204,	3083,	'_keywords',	''),
(9205,	3083,	'_subslideID',	''),
(9206,	3083,	'_thumbnail_id',	'3118'),
(9207,	3083,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:83:\"https://www.megajustice.com/wp-content/uploads/2019/03/Marriage2-e1551891215525.jpg\";s:5:\"title\";s:9:\"Marriage2\";s:7:\"caption\";s:0:\"\";}'),
(9208,	3083,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:83:\"https://www.megajustice.com/wp-content/uploads/2019/03/Marriage2-e1551891215525.jpg\";s:5:\"title\";s:9:\"Marriage2\";s:7:\"caption\";s:0:\"\";}'),
(9209,	3085,	'_title',	'Can A Minor Testify In A Custody Dispute? | Tampa Child Custody Lawyers'),
(9210,	3085,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you with your sensitive family law legal problems.'),
(9211,	3085,	'_keywords',	''),
(9212,	3085,	'_subslideID',	''),
(9213,	3085,	'_thumbnail_id',	'3120'),
(9214,	3085,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/03/Custody3.jpg\";s:5:\"title\";s:8:\"Custody3\";s:7:\"caption\";s:0:\"\";}'),
(9215,	3085,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/03/Custody3.jpg\";s:5:\"title\";s:8:\"Custody3\";s:7:\"caption\";s:0:\"\";}'),
(9216,	3087,	'_thumbnail_id',	'3089'),
(9217,	3087,	'_title',	'Pay Attention To Your Financial Affidavits | Tampa Family Lawyers'),
(9218,	3087,	'_description',	'Our Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you with your family law legal problems and questions.'),
(9219,	3087,	'_keywords',	''),
(9220,	3087,	'_subslideID',	''),
(9221,	3087,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/02/FamLaw2.jpg\";s:5:\"title\";s:7:\"FamLaw2\";s:7:\"caption\";s:0:\"\";}'),
(9222,	3087,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/02/FamLaw2.jpg\";s:5:\"title\";s:7:\"FamLaw2\";s:7:\"caption\";s:0:\"\";}'),
(9223,	3091,	'_thumbnail_id',	'3092'),
(9224,	3091,	'_title',	'Can Parties Agree To Waive Child Support? | Tampa Child Support Attorneys'),
(9225,	3091,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you with your family law legal problems and questions.'),
(9226,	3091,	'_keywords',	''),
(9227,	3091,	'_subslideID',	''),
(9228,	3091,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/02/CSupport7.jpg\";s:5:\"title\";s:9:\"CSupport7\";s:7:\"caption\";s:0:\"\";}'),
(9229,	3091,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/02/CSupport7.jpg\";s:5:\"title\";s:9:\"CSupport7\";s:7:\"caption\";s:0:\"\";}'),
(9230,	3141,	'_thumbnail_id',	'3142'),
(9231,	3141,	'_title',	'What Is The Right Of First Refusal In A Parenting Plan? | Tampa Parenting Plans Lawyers'),
(9232,	3141,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you with your family law problems.'),
(9233,	3141,	'_keywords',	''),
(9234,	3141,	'_subslideID',	''),
(9235,	3141,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/03/ParentPlan.jpg\";s:5:\"title\";s:10:\"ParentPlan\";s:7:\"caption\";s:0:\"\";}'),
(9236,	3141,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/03/ParentPlan.jpg\";s:5:\"title\";s:10:\"ParentPlan\";s:7:\"caption\";s:0:\"\";}'),
(9237,	3129,	'_title',	'PIP Deductible Issue | Tampa Car Accident Lawyers'),
(9238,	3129,	'_description',	'Tampa car accident attorneys at The Pawlowski//Mastrilli Law Group can answer your questions and help you obtain damages for injuries.'),
(9239,	3129,	'_keywords',	''),
(9240,	3129,	'_subslideID',	''),
(9241,	3129,	'_thumbnail_id',	'3169'),
(9242,	3129,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/03/CarAccClaim.jpg\";s:5:\"title\";s:11:\"CarAccClaim\";s:7:\"caption\";s:0:\"\";}'),
(9243,	3129,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/03/CarAccClaim.jpg\";s:5:\"title\";s:11:\"CarAccClaim\";s:7:\"caption\";s:0:\"\";}'),
(9244,	3131,	'_title',	'Who Makes Medical Decisions For A Minor Child? | Tampa Family Lawyers'),
(9245,	3131,	'_description',	'Our Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you with your custody and timesharing questions.'),
(9246,	3131,	'_keywords',	''),
(9247,	3131,	'_subslideID',	''),
(9248,	3131,	'_thumbnail_id',	'3171'),
(9249,	3131,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:81:\"https://www.megajustice.com/wp-content/uploads/2019/03/Family2-e1553011649550.jpg\";s:5:\"title\";s:7:\"Family2\";s:7:\"caption\";s:0:\"\";}'),
(9250,	3131,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:81:\"https://www.megajustice.com/wp-content/uploads/2019/03/Family2-e1553011649550.jpg\";s:5:\"title\";s:7:\"Family2\";s:7:\"caption\";s:0:\"\";}'),
(9251,	3133,	'_title',	'Does Adultery Matter In A Divorce Case? | Tampa Divorce Lawyers'),
(9252,	3133,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you with your family law problems questions and assist you in your divorce.'),
(9253,	3133,	'_keywords',	''),
(9254,	3133,	'_subslideID',	''),
(9255,	3133,	'_thumbnail_id',	'3184'),
(9256,	3133,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2019/03/Div5.jpg\";s:5:\"title\";s:4:\"Div5\";s:7:\"caption\";s:0:\"\";}'),
(9257,	3133,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2019/03/Div5.jpg\";s:5:\"title\";s:4:\"Div5\";s:7:\"caption\";s:0:\"\";}'),
(9258,	3135,	'_title',	'The Benefit Of Taking On Additional Marital Debt | Tampa Divorce Lawyers'),
(9259,	3135,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you negotiate a unique and individual divorce settlement.'),
(9260,	3135,	'_keywords',	''),
(9261,	3135,	'_subslideID',	''),
(9262,	3135,	'_thumbnail_id',	'3186'),
(9263,	3135,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:72:\"https://www.megajustice.com/wp-content/uploads/2019/03/Alimony_Rings.jpg\";s:5:\"title\";s:13:\"Alimony_Rings\";s:7:\"caption\";s:0:\"\";}'),
(9264,	3135,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:72:\"https://www.megajustice.com/wp-content/uploads/2019/03/Alimony_Rings.jpg\";s:5:\"title\";s:13:\"Alimony_Rings\";s:7:\"caption\";s:0:\"\";}'),
(9265,	3137,	'_title',	'Can You Disestablish Paternity? | Tampa Paternity Lawyers'),
(9266,	3137,	'_description',	'The Tampa paternity attorneys at The Pawlowski//Mastrilli Law Group can help you with your family law and paternity problems.'),
(9267,	3137,	'_keywords',	''),
(9268,	3137,	'_subslideID',	''),
(9269,	3137,	'_thumbnail_id',	'3200'),
(9270,	3137,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/04/Paternity3.jpg\";s:5:\"title\";s:10:\"Paternity3\";s:7:\"caption\";s:0:\"\";}'),
(9271,	3137,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/04/Paternity3.jpg\";s:5:\"title\";s:10:\"Paternity3\";s:7:\"caption\";s:0:\"\";}'),
(9272,	3139,	'_title',	'Be Careful What You Post On Social Media | Tampa Divorce Lawyers'),
(9273,	3139,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you with your family law problems.'),
(9274,	3139,	'_keywords',	''),
(9275,	3139,	'_subslideID',	''),
(9276,	3139,	'_thumbnail_id',	'3202'),
(9277,	3139,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/04/SocialM.jpg\";s:5:\"title\";s:7:\"SocialM\";s:7:\"caption\";s:0:\"\";}'),
(9278,	3139,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/04/SocialM.jpg\";s:5:\"title\";s:7:\"SocialM\";s:7:\"caption\";s:0:\"\";}'),
(9279,	3144,	'_thumbnail_id',	'3145'),
(9280,	3144,	'_title',	'The Moral And Legal Ethics Of Self-Driving Cars | Tampa Car Accident Lawyers'),
(9281,	3144,	'_description',	'Tampa injury law attorneys at The Pawlowski//Mastrilli Law Group can answer your questions and help you obtain damages for injuries sustained in a car accident.'),
(9282,	3144,	'_keywords',	''),
(9283,	3144,	'_subslideID',	''),
(9284,	3144,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/03/Autopilot2.jpg\";s:5:\"title\";s:10:\"Autopilot2\";s:7:\"caption\";s:0:\"\";}'),
(9285,	3144,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/03/Autopilot2.jpg\";s:5:\"title\";s:10:\"Autopilot2\";s:7:\"caption\";s:0:\"\";}'),
(9286,	3225,	'_thumbnail_id',	'3226'),
(9287,	3225,	'_title',	'Father Ordered To Pay Child Support After 50 Years | Tampa Child Support Lawyers'),
(9288,	3225,	'_description',	'The Tampa child support attorneys at The Pawlowski//Mastrilli Law Group can help you with any child support payment.'),
(9289,	3225,	'_keywords',	''),
(9290,	3225,	'_subslideID',	''),
(9291,	3225,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/04/CSupport8.jpg\";s:5:\"title\";s:9:\"CSupport8\";s:7:\"caption\";s:0:\"\";}'),
(9292,	3225,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/04/CSupport8.jpg\";s:5:\"title\";s:9:\"CSupport8\";s:7:\"caption\";s:0:\"\";}'),
(9293,	3228,	'_thumbnail_id',	'3230'),
(9294,	3228,	'_title',	'Minimizing The Costs Of Divorce | Tampa Divorce Lawyers'),
(9295,	3228,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you with any child support payment, collection matters, or defenses that you may need to assert in court.'),
(9296,	3228,	'_keywords',	''),
(9297,	3228,	'_subslideID',	''),
(9298,	3228,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2019/04/Div20.jpg\";s:5:\"title\";s:5:\"Div20\";s:7:\"caption\";s:0:\"\";}'),
(9299,	3228,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2019/04/Div20.jpg\";s:5:\"title\";s:5:\"Div20\";s:7:\"caption\";s:0:\"\";}'),
(9300,	3232,	'_thumbnail_id',	'3233'),
(9301,	3232,	'_title',	'Dealing With Pre-Existing Injuries In Car Accidents | Tampa Car Accident Attorneys'),
(9302,	3232,	'_description',	'Tampa car accident attorneys at The Pawlowski//Mastrilli Law Group can answer your questions and help you obtain damages for injuries.'),
(9303,	3232,	'_keywords',	''),
(9304,	3232,	'_subslideID',	''),
(9305,	3232,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/04/CarCrash3.jpg\";s:5:\"title\";s:9:\"CarCrash3\";s:7:\"caption\";s:0:\"\";}'),
(9306,	3232,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/04/CarCrash3.jpg\";s:5:\"title\";s:9:\"CarCrash3\";s:7:\"caption\";s:0:\"\";}'),
(9307,	3235,	'_thumbnail_id',	'3236'),
(9308,	3235,	'_title',	'Is Drug Usage An Issue In Divorce Cases? | Tampa Divorce Attorneys'),
(9309,	3235,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you understand the issues that may come up in your divorce.'),
(9310,	3235,	'_keywords',	''),
(9311,	3235,	'_subslideID',	''),
(9312,	3235,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/04/Div_alcohol.jpg\";s:5:\"title\";s:11:\"Div_alcohol\";s:7:\"caption\";s:0:\"\";}'),
(9313,	3235,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/04/Div_alcohol.jpg\";s:5:\"title\";s:11:\"Div_alcohol\";s:7:\"caption\";s:0:\"\";}'),
(9314,	3238,	'_title',	'How Will Bankruptcy Affect Child Support And Alimony? | Tampa Child Support Lawyers'),
(9315,	3238,	'_description',	'Our Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you fight for alimony or child support.'),
(9316,	3238,	'_keywords',	''),
(9317,	3238,	'_subslideID',	''),
(9318,	3238,	'_thumbnail_id',	'3263'),
(9319,	3238,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/04/CSupport9.jpg\";s:5:\"title\";s:9:\"CSupport9\";s:7:\"caption\";s:0:\"\";}'),
(9320,	3238,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/04/CSupport9.jpg\";s:5:\"title\";s:9:\"CSupport9\";s:7:\"caption\";s:0:\"\";}'),
(9321,	3240,	'_title',	'What Is An Annulment? | Tampa Annulment Divorce Attorneys'),
(9322,	3240,	'_description',	'The Tampa annulment divorce attorneys at The Pawlowski//Mastrilli Law Group can help you understand all of your options if you are seeking a divorce.'),
(9323,	3240,	'_keywords',	''),
(9324,	3240,	'_subslideID',	''),
(9325,	3240,	'_thumbnail_id',	'3265'),
(9326,	3240,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/04/Annulment.jpg\";s:5:\"title\";s:9:\"Annulment\";s:7:\"caption\";s:0:\"\";}'),
(9327,	3240,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/04/Annulment.jpg\";s:5:\"title\";s:9:\"Annulment\";s:7:\"caption\";s:0:\"\";}'),
(9328,	3242,	'_title',	'Make Sure Your Prenuptial Agreement Is Enforceable | Tampa Prenuptial Agreenent Attorneys'),
(9329,	3242,	'_description',	'The Tampa prenuptial agreenent attorneys at The Pawlowski//Mastrilli Law Group can help you negotiate a prenuptial agreement.'),
(9330,	3242,	'_keywords',	''),
(9331,	3242,	'_subslideID',	''),
(9332,	3242,	'_thumbnail_id',	'3284'),
(9333,	3242,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/04/Prenup8.jpg\";s:5:\"title\";s:7:\"Prenup8\";s:7:\"caption\";s:0:\"\";}'),
(9334,	3242,	'_wp_old_date',	'2019-04-29'),
(9335,	3242,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/04/Prenup8.jpg\";s:5:\"title\";s:7:\"Prenup8\";s:7:\"caption\";s:0:\"\";}'),
(9336,	3244,	'_title',	'Timesharing Apps Cause Concern | Tampa Child Custody Lawyers'),
(9337,	3244,	'_description',	'Our Tampa child custody attorneys at The Pawlowski//Mastrilli Law Group can help you handle custody, timesharing and visitation problems.'),
(9338,	3244,	'_keywords',	''),
(9339,	3244,	'_subslideID',	''),
(9340,	3244,	'_thumbnail_id',	'3286'),
(9341,	3244,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/04/Custody4.jpg\";s:5:\"title\";s:8:\"Custody4\";s:7:\"caption\";s:0:\"\";}'),
(9342,	3244,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/04/Custody4.jpg\";s:5:\"title\";s:8:\"Custody4\";s:7:\"caption\";s:0:\"\";}'),
(9343,	3300,	'_title',	'What Happens When Children Don’t Want To Follow A Time-Sharing Agreement? | Tampa Family Lawyers'),
(9344,	3300,	'_description',	'The Tampa family lawyers at The Pawlowski//Mastrilli Law Group can help you with your questions or concerns about visitation, custody and timesharing.'),
(9345,	3300,	'_keywords',	''),
(9346,	3300,	'_subslideID',	''),
(9347,	3300,	'_thumbnail_id',	'3338'),
(9348,	3300,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:73:\"https://www.megajustice.com/wp-content/uploads/2019/05/FatherDaughter.jpg\";s:5:\"title\";s:14:\"FatherDaughter\";s:7:\"caption\";s:0:\"\";}'),
(9349,	3300,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:73:\"https://www.megajustice.com/wp-content/uploads/2019/05/FatherDaughter.jpg\";s:5:\"title\";s:14:\"FatherDaughter\";s:7:\"caption\";s:0:\"\";}'),
(9350,	3302,	'_title',	'Child Illegally Taken Out Of The Country | Tampa Family Law Attorneys'),
(9351,	3302,	'_description',	'The Tampa family lawyers at The Pawlowski//Mastrilli Law Group can help you enforce any child custody or support orders or agreements'),
(9352,	3302,	'_keywords',	''),
(9353,	3302,	'_subslideID',	''),
(9354,	3302,	'_thumbnail_id',	'3340'),
(9355,	3302,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/05/ChildMoving.jpg\";s:5:\"title\";s:11:\"ChildMoving\";s:7:\"caption\";s:0:\"\";}'),
(9356,	3302,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/05/ChildMoving.jpg\";s:5:\"title\";s:11:\"ChildMoving\";s:7:\"caption\";s:0:\"\";}'),
(9357,	3304,	'_title',	'No Gender Presumptions WIth Alimony Or Child Support | Tampa Family Lawyers'),
(9358,	3304,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you with your questions or concerns about alimony and child support.'),
(9359,	3304,	'_keywords',	''),
(9360,	3304,	'_subslideID',	''),
(9361,	3304,	'_thumbnail_id',	'3350'),
(9362,	3304,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/05/CSupport5.jpg\";s:5:\"title\";s:9:\"CSupport5\";s:7:\"caption\";s:0:\"\";}'),
(9363,	3304,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/05/CSupport5.jpg\";s:5:\"title\";s:9:\"CSupport5\";s:7:\"caption\";s:0:\"\";}'),
(9364,	3312,	'_thumbnail_id',	'3313'),
(9365,	3312,	'_title',	'The Benefits Of Lump Sum Alimony | Tampa Alimony Lawyers'),
(9366,	3312,	'_description',	'The Tampa alimony attorneys at The Pawlowski//Mastrilli Law Group you\'re a quick study! can help you with your questions or concerns about paying or receiving alimony.'),
(9367,	3312,	'_keywords',	''),
(9368,	3312,	'_subslideID',	''),
(9369,	3312,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/05/Alimony4.jpg\";s:5:\"title\";s:8:\"Alimony4\";s:7:\"caption\";s:0:\"\";}'),
(9370,	3312,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/05/Alimony4.jpg\";s:5:\"title\";s:8:\"Alimony4\";s:7:\"caption\";s:0:\"\";}'),
(9371,	3315,	'_thumbnail_id',	'3316'),
(9372,	3315,	'_title',	'The Art Of Jury Selection | Tampa Car Accident Lawyers'),
(9373,	3315,	'_description',	'Tampa car accident attorneys at The Pawlowski//Mastrilli Law Group can answer your questions and help you obtain damages for injuries sustained in a car accident.'),
(9374,	3315,	'_keywords',	''),
(9375,	3315,	'_subslideID',	''),
(9376,	3315,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/05/CarAcc5.jpg\";s:5:\"title\";s:7:\"CarAcc5\";s:7:\"caption\";s:0:\"\";}'),
(9377,	3315,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/05/CarAcc5.jpg\";s:5:\"title\";s:7:\"CarAcc5\";s:7:\"caption\";s:0:\"\";}'),
(9378,	3306,	'_title',	'Mental Exam Requires Specific Showings | Tampa Divorce Lawyers'),
(9379,	3306,	'_description',	'Our Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you litigate your contested custody case, and explain every step of the process to you.'),
(9380,	3306,	'_keywords',	''),
(9381,	3306,	'_subslideID',	''),
(9382,	3306,	'_thumbnail_id',	'3352'),
(9383,	3306,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/05/Depressed.jpg\";s:5:\"title\";s:9:\"Depressed\";s:7:\"caption\";s:0:\"\";}'),
(9384,	3306,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/05/Depressed.jpg\";s:5:\"title\";s:9:\"Depressed\";s:7:\"caption\";s:0:\"\";}'),
(9385,	3308,	'_title',	'Inference Stacking Is Allowed In Recent Injury Case | Tampa Personal Injury Lawyers'),
(9386,	3308,	'_description',	'The Tampa personal injury attorneys at The Pawlowski//Mastrilli Law Group can answer your questions and help you obtain damages for injuries sustained in a car accident.'),
(9387,	3308,	'_keywords',	''),
(9388,	3308,	'_subslideID',	''),
(9389,	3308,	'_thumbnail_id',	'3371'),
(9390,	3308,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/05/Accident5.jpg\";s:5:\"title\";s:9:\"Accident5\";s:7:\"caption\";s:0:\"\";}'),
(9391,	3308,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/05/Accident5.jpg\";s:5:\"title\";s:9:\"Accident5\";s:7:\"caption\";s:0:\"\";}'),
(9392,	3310,	'_title',	'Not Every Family Law Obligation Can Be Enforced By Contempt | Tampa Family Lawyers'),
(9393,	3310,	'_description',	'Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you draft an enforceable marital settlement agreement or enforce the terms of a divorce agreement.'),
(9394,	3310,	'_keywords',	''),
(9395,	3310,	'_subslideID',	''),
(9396,	3310,	'_thumbnail_id',	'3373'),
(9397,	3310,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2019/05/Div19.jpg\";s:5:\"title\";s:5:\"Div19\";s:7:\"caption\";s:0:\"\";}'),
(9398,	3310,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2019/05/Div19.jpg\";s:5:\"title\";s:5:\"Div19\";s:7:\"caption\";s:0:\"\";}'),
(9399,	3383,	'_thumbnail_id',	'3384'),
(9400,	3383,	'_title',	'Maine Court Makes Pet Custody Determination | Tampa Family Lawyers'),
(9401,	3383,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can explain every step of the custody process to you.'),
(9402,	3383,	'_keywords',	''),
(9403,	3383,	'_subslideID',	''),
(9404,	3383,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/06/PetCustody.jpg\";s:5:\"title\";s:10:\"PetCustody\";s:7:\"caption\";s:0:\"\";}'),
(9405,	3383,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/06/PetCustody.jpg\";s:5:\"title\";s:10:\"PetCustody\";s:7:\"caption\";s:0:\"\";}'),
(9406,	3386,	'_thumbnail_id',	'3387'),
(9407,	3386,	'_title',	'Ireland Looks To Reduce Divorce Waiting Period | Tampa Divorce Lawyers'),
(9408,	3386,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group understand the need to get through your divorce and to get on with your life.'),
(9409,	3386,	'_keywords',	''),
(9410,	3386,	'_subslideID',	''),
(9411,	3386,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/06/DivWords.jpg\";s:5:\"title\";s:8:\"DivWords\";s:7:\"caption\";s:0:\"\";}'),
(9412,	3386,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/06/DivWords.jpg\";s:5:\"title\";s:8:\"DivWords\";s:7:\"caption\";s:0:\"\";}'),
(9413,	3389,	'_title',	'Parties Seeking More Alimony | Tampa Family Lawyers'),
(9414,	3389,	'_description',	'The Tampa family attorneys at The Pawlowski//Mastrilli Law Group can explain every step of the alimony process to you.'),
(9415,	3389,	'_keywords',	''),
(9416,	3389,	'_subslideID',	''),
(9417,	3389,	'_thumbnail_id',	'3411'),
(9418,	3389,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/06/Alimony10.jpg\";s:5:\"title\";s:9:\"Alimony10\";s:7:\"caption\";s:0:\"\";}'),
(9419,	3389,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/06/Alimony10.jpg\";s:5:\"title\";s:9:\"Alimony10\";s:7:\"caption\";s:0:\"\";}'),
(9420,	3391,	'_title',	'Spouse Purposely Wasted Marital Assets | Tampa Divorce Lawyers'),
(9421,	3391,	'_description',	'The Pawlowski//Mastrilli Law Group can explain every step of the divorce process to you, and assist you in finding assets that may be hidden or wasted.'),
(9422,	3391,	'_keywords',	''),
(9423,	3391,	'_subslideID',	''),
(9424,	3391,	'_thumbnail_id',	'3413'),
(9425,	3391,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/06/DivMoney.jpg\";s:5:\"title\";s:8:\"DivMoney\";s:7:\"caption\";s:0:\"\";}'),
(9426,	3391,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/06/DivMoney.jpg\";s:5:\"title\";s:8:\"DivMoney\";s:7:\"caption\";s:0:\"\";}'),
(9427,	3393,	'_title',	'Use Common Sense To Stay Safe On Motorcycles | Tampa Personal Injury Lawyers'),
(9428,	3393,	'_description',	'The Tampa personal injury attorneys at The Pawlowski//Mastrilli Law Group can answer your questions and help you obtain damages for injuries sustained in a motorcycle accident.'),
(9429,	3393,	'_keywords',	''),
(9430,	3393,	'_subslideID',	''),
(9431,	3393,	'_thumbnail_id',	'3429'),
(9432,	3393,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/06/Motorcycle7.jpg\";s:5:\"title\";s:11:\"Motorcycle7\";s:7:\"caption\";s:0:\"\";}'),
(9433,	3393,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/06/Motorcycle7.jpg\";s:5:\"title\";s:11:\"Motorcycle7\";s:7:\"caption\";s:0:\"\";}'),
(9434,	3395,	'_title',	'The Court’s Role In Protecting Children Is Broad | Tampa Family Lawyers'),
(9435,	3395,	'_description',	'The Tampa family lawyers at The Pawlowski//Mastrilli Law Group can explain every step of the custody process to you.'),
(9436,	3395,	'_keywords',	''),
(9437,	3395,	'_subslideID',	''),
(9438,	3395,	'_thumbnail_id',	'3431'),
(9439,	3395,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/06/FamCourt.jpg\";s:5:\"title\";s:8:\"FamCourt\";s:7:\"caption\";s:0:\"\";}'),
(9440,	3395,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/06/FamCourt.jpg\";s:5:\"title\";s:8:\"FamCourt\";s:7:\"caption\";s:0:\"\";}'),
(9441,	3397,	'_title',	'Sole Custody Of A Child Is Difficult To Obtain | Tampa Family Lawyers'),
(9442,	3397,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you litigate your contested custody case.'),
(9443,	3397,	'_keywords',	''),
(9444,	3397,	'_subslideID',	''),
(9445,	3397,	'_thumbnail_id',	'3442'),
(9446,	3397,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/06/FatherSon.jpg\";s:5:\"title\";s:9:\"FatherSon\";s:7:\"caption\";s:0:\"\";}'),
(9447,	3397,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/06/FatherSon.jpg\";s:5:\"title\";s:9:\"FatherSon\";s:7:\"caption\";s:0:\"\";}'),
(9448,	3399,	'_title',	'Real World Advice To Be Prepared For A Divorce | Tampa Divorce Lawyers'),
(9449,	3399,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can explain every step of the process to you.'),
(9450,	3399,	'_keywords',	''),
(9451,	3399,	'_subslideID',	''),
(9452,	3399,	'_thumbnail_id',	'3444'),
(9453,	3399,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/06/DivorcePlan.jpg\";s:5:\"title\";s:11:\"DivorcePlan\";s:7:\"caption\";s:0:\"\";}'),
(9454,	3399,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2019/06/DivorcePlan.jpg\";s:5:\"title\";s:11:\"DivorcePlan\";s:7:\"caption\";s:0:\"\";}'),
(9455,	3466,	'_title',	'What Can Child Support Be Spent On? | Tampa Child Support Attorneys'),
(9456,	3466,	'_description',	'The Tampa child support attorneys at The Pawlowski//Mastrilli Law Group can help you understand your child support obligations.'),
(9457,	3466,	'_keywords',	''),
(9458,	3466,	'_subslideID',	''),
(9459,	3466,	'_thumbnail_id',	'3500'),
(9460,	3466,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/07/CSupport11.jpg\";s:5:\"title\";s:10:\"CSupport11\";s:7:\"caption\";s:0:\"\";}'),
(9461,	3466,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:69:\"https://www.megajustice.com/wp-content/uploads/2019/07/CSupport11.jpg\";s:5:\"title\";s:10:\"CSupport11\";s:7:\"caption\";s:0:\"\";}'),
(9462,	3468,	'_title',	'Dividing Student Loan Debt In A Divorce | Tampa Family Lawyers'),
(9463,	3468,	'_description',	'The Tampa family attorneys at The Pawlowski//Mastrilli Law Group can help you understand your obligations after a divorce.'),
(9464,	3468,	'_keywords',	''),
(9465,	3468,	'_subslideID',	''),
(9466,	3468,	'_thumbnail_id',	'3502'),
(9467,	3468,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:86:\"https://www.megajustice.com/wp-content/uploads/2019/07/StudentDebt2-e1563376436579.jpg\";s:5:\"title\";s:12:\"StudentDebt2\";s:7:\"caption\";s:0:\"\";}'),
(9468,	3468,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:86:\"https://www.megajustice.com/wp-content/uploads/2019/07/StudentDebt2-e1563376436579.jpg\";s:5:\"title\";s:12:\"StudentDebt2\";s:7:\"caption\";s:0:\"\";}'),
(9469,	3470,	'_title',	'Value Of Cases | Tampa Personal Injury Lawyers'),
(9470,	3470,	'_description',	'The Tampa personal injury attorneys at The Pawlowski//Mastrilli Law Group can answer your questions and help you obtain damages for injuries.'),
(9471,	3470,	'_keywords',	''),
(9472,	3470,	'_subslideID',	''),
(9473,	3470,	'_thumbnail_id',	'3510'),
(9474,	3470,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/07/PI_Claim2.jpg\";s:5:\"title\";s:9:\"PI_Claim2\";s:7:\"caption\";s:0:\"\";}'),
(9475,	3470,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:68:\"https://www.megajustice.com/wp-content/uploads/2019/07/PI_Claim2.jpg\";s:5:\"title\";s:9:\"PI_Claim2\";s:7:\"caption\";s:0:\"\";}'),
(9476,	3472,	'_title',	'Dividing Retirement Accounts In A Divorce | Tampa Divorce Lawyers'),
(9477,	3472,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you understand how and if your property will be divided by a court in a divorce.'),
(9478,	3472,	'_keywords',	''),
(9479,	3472,	'_subslideID',	''),
(9480,	3472,	'_thumbnail_id',	'3512'),
(9481,	3472,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2019/07/Div9.jpg\";s:5:\"title\";s:4:\"Div9\";s:7:\"caption\";s:0:\"\";}'),
(9482,	3472,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:63:\"https://www.megajustice.com/wp-content/uploads/2019/07/Div9.jpg\";s:5:\"title\";s:4:\"Div9\";s:7:\"caption\";s:0:\"\";}'),
(9483,	3474,	'_title',	'Temporary Support Can Help While A Case Is Going On | Tampa Child Custody Lawyers'),
(9484,	3474,	'_description',	'The Tampa child custody attorneys at The Pawlowski//Mastrilli Law Group understand the need to take care of your family’s needs'),
(9485,	3474,	'_keywords',	''),
(9486,	3474,	'_subslideID',	''),
(9487,	3474,	'_thumbnail_id',	'3522'),
(9488,	3474,	'_oembed_41e528c129cebca14e6492451ac02c6b',	'{{unknown}}'),
(9489,	3474,	'_oembed_3aef6026b495dc012e905bc8f9da2bff',	'{{unknown}}'),
(9490,	3474,	'_oembed_a019a5365fa84dfbe5c1844a0a88f3c7',	'{{unknown}}'),
(9491,	3474,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2019/07/MomDaughter4.jpg\";s:5:\"title\";s:12:\"MomDaughter4\";s:7:\"caption\";s:0:\"\";}'),
(9492,	3474,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2019/07/MomDaughter4.jpg\";s:5:\"title\";s:12:\"MomDaughter4\";s:7:\"caption\";s:0:\"\";}'),
(9493,	3476,	'_title',	'Who Gets The Rings After Separation Or Divorce? | Tampa Divorce Lawyers'),
(9494,	3476,	'_description',	'The Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you understand what property the Court may try to divide amongst you and your spouse'),
(9495,	3476,	'_keywords',	''),
(9496,	3476,	'_subslideID',	''),
(9497,	3476,	'_thumbnail_id',	'3524'),
(9498,	3476,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2019/07/Rings.jpg\";s:5:\"title\";s:5:\"Rings\";s:7:\"caption\";s:0:\"\";}'),
(9499,	3476,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:64:\"https://www.megajustice.com/wp-content/uploads/2019/07/Rings.jpg\";s:5:\"title\";s:5:\"Rings\";s:7:\"caption\";s:0:\"\";}'),
(9500,	3478,	'_title',	'Spying On Your Ex Can Be Useless Or Dangerous | Tampa Family Lawyers'),
(9501,	3478,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you understand what is and what is not allowable in your divorce case.'),
(9502,	3478,	'_keywords',	''),
(9503,	3478,	'_subslideID',	''),
(9504,	3478,	'_thumbnail_id',	'3556'),
(9505,	3478,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/08/Family4.jpg\";s:5:\"title\";s:7:\"Family4\";s:7:\"caption\";s:0:\"\";}'),
(9506,	3478,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/08/Family4.jpg\";s:5:\"title\";s:7:\"Family4\";s:7:\"caption\";s:0:\"\";}'),
(9507,	3482,	'_thumbnail_id',	'3483'),
(9508,	3482,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/07/Prenup5.jpg\";s:5:\"title\";s:7:\"Prenup5\";s:7:\"caption\";s:0:\"\";}'),
(9509,	3482,	'_title',	'Importance Of Separation Agreements | Tampa Divorce Lawyers'),
(9510,	3482,	'_description',	'Our Tampa divorce attorneys at The Pawlowski//Mastrilli Law Group can help you understand what will happen to your property in your divorce.'),
(9511,	3482,	'_keywords',	''),
(9512,	3482,	'_subslideID',	''),
(9513,	3482,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/07/Prenup5.jpg\";s:5:\"title\";s:7:\"Prenup5\";s:7:\"caption\";s:0:\"\";}'),
(9514,	3485,	'_thumbnail_id',	'3486'),
(9515,	3485,	'_title',	'Reminder To Have Uninsured Motorist Coverage | Tampa Car Accident Lawyers'),
(9516,	3485,	'_description',	'The Tampa car accident attorneys at The Pawlowski//Mastrilli Law Group can answer your questions and help you obtain damages for injuries sustained in a car accident.'),
(9517,	3485,	'_keywords',	''),
(9518,	3485,	'_subslideID',	''),
(9519,	3485,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/07/Accident.jpg\";s:5:\"title\";s:8:\"Accident\";s:7:\"caption\";s:0:\"\";}'),
(9520,	3485,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2019/07/Accident.jpg\";s:5:\"title\";s:8:\"Accident\";s:7:\"caption\";s:0:\"\";}'),
(9521,	3480,	'_title',	'Estate Issues That Arise From A Divorce | Tampa Family Lawyers'),
(9522,	3480,	'_description',	'The Tampa family law attorneys at The Pawlowski//Mastrilli Law Group can help you deal with problems that you may not immediately think of in your Florida divorce case'),
(9523,	3480,	'_keywords',	''),
(9524,	3480,	'_subslideID',	''),
(9525,	3480,	'_thumbnail_id',	'3558'),
(9526,	3480,	'_xmlsf_image_attached',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/08/DivDecr.jpg\";s:5:\"title\";s:7:\"DivDecr\";s:7:\"caption\";s:0:\"\";}'),
(9527,	3480,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2019/08/DivDecr.jpg\";s:5:\"title\";s:7:\"DivDecr\";s:7:\"caption\";s:0:\"\";}'),
(9528,	2963,	'_edit_lock',	'1578443789:1'),
(9529,	1534,	'_edit_lock',	'1578443837:1'),
(9530,	5158,	'iwp_log_type',	'scheduleBackup'),
(9531,	5158,	'iwp_log_action',	'schedule'),
(9532,	5158,	'iwp_log_activities_type',	'iwp_log'),
(9533,	5158,	'iwp_log_actions',	'backups'),
(9534,	5158,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9543,	5161,	'_wp_attached_file',	'2020/01/vincent-r-pawlowski-esq.jpg'),
(9544,	5161,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:315;s:6:\"height\";i:383;s:4:\"file\";s:35:\"2020/01/vincent-r-pawlowski-esq.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"vincent-r-pawlowski-esq-247x300.jpg\";s:5:\"width\";i:247;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"vincent-r-pawlowski-esq-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:35:\"vincent-r-pawlowski-esq-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:35:\"vincent-r-pawlowski-esq-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:35:\"vincent-r-pawlowski-esq-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(9547,	5164,	'iwp_log_type',	'scheduleBackup'),
(9548,	5164,	'iwp_log_action',	'schedule'),
(9549,	5164,	'iwp_log_activities_type',	'iwp_log'),
(9550,	5164,	'iwp_log_actions',	'backups'),
(9551,	5164,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9552,	5165,	'iwp_log_type',	'plugins'),
(9553,	5165,	'iwp_log_action',	'update'),
(9554,	5165,	'iwp_log_activities_type',	'automatic'),
(9555,	5165,	'iwp_log_actions',	'plugins-updated'),
(9556,	5165,	'iwp_log_details',	'a:4:{s:4:\"name\";s:37:\"Backup and Staging by WP Time Capsule\";s:4:\"slug\";s:35:\"wp-time-capsule/wp-time-capsule.php\";s:11:\"old_version\";s:7:\"1.21.15\";s:15:\"updated_version\";s:7:\"1.21.16\";}'),
(9557,	5166,	'iwp_log_type',	'scheduleBackup'),
(9558,	5166,	'iwp_log_action',	'schedule'),
(9559,	5166,	'iwp_log_activities_type',	'iwp_log'),
(9560,	5166,	'iwp_log_actions',	'backups'),
(9561,	5166,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9562,	5168,	'iwp_log_type',	'scheduleBackup'),
(9563,	5168,	'iwp_log_action',	'schedule'),
(9564,	5168,	'iwp_log_activities_type',	'iwp_log'),
(9565,	5168,	'iwp_log_actions',	'backups'),
(9566,	5168,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9567,	5170,	'iwp_log_type',	'scheduleBackup'),
(9568,	5170,	'iwp_log_action',	'schedule'),
(9569,	5170,	'iwp_log_activities_type',	'iwp_log'),
(9570,	5170,	'iwp_log_actions',	'backups'),
(9571,	5170,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9572,	5171,	'iwp_log_type',	'scheduleBackup'),
(9573,	5171,	'iwp_log_action',	'schedule'),
(9574,	5171,	'iwp_log_activities_type',	'iwp_log'),
(9575,	5171,	'iwp_log_actions',	'backups'),
(9576,	5171,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9577,	5173,	'iwp_log_type',	'scheduleBackup'),
(9578,	5173,	'iwp_log_action',	'schedule'),
(9579,	5173,	'iwp_log_activities_type',	'iwp_log'),
(9580,	5173,	'iwp_log_actions',	'backups'),
(9581,	5173,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9582,	5174,	'iwp_log_type',	'plugins'),
(9583,	5174,	'iwp_log_action',	'update'),
(9584,	5174,	'iwp_log_activities_type',	'automatic'),
(9585,	5174,	'iwp_log_actions',	'plugins-updated'),
(9586,	5174,	'iwp_log_details',	'a:4:{s:4:\"name\";s:37:\"Backup and Staging by WP Time Capsule\";s:4:\"slug\";s:35:\"wp-time-capsule/wp-time-capsule.php\";s:11:\"old_version\";s:7:\"1.21.16\";s:15:\"updated_version\";s:7:\"1.21.17\";}'),
(9587,	5175,	'iwp_log_type',	'plugins'),
(9588,	5175,	'iwp_log_action',	'update'),
(9589,	5175,	'iwp_log_activities_type',	'automatic'),
(9590,	5175,	'iwp_log_actions',	'plugins-updated'),
(9591,	5175,	'iwp_log_details',	'a:4:{s:4:\"name\";s:18:\"Wordfence Security\";s:4:\"slug\";s:23:\"wordfence/wordfence.php\";s:11:\"old_version\";s:5:\"7.4.2\";s:15:\"updated_version\";s:5:\"7.4.4\";}'),
(9592,	5176,	'iwp_log_type',	'plugins'),
(9593,	5176,	'iwp_log_action',	'update'),
(9594,	5176,	'iwp_log_activities_type',	'automatic'),
(9595,	5176,	'iwp_log_actions',	'plugins-updated'),
(9596,	5176,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:5:\"3.4.3\";s:15:\"updated_version\";s:5:\"3.4.4\";}'),
(9597,	5177,	'iwp_log_type',	'scheduleBackup'),
(9598,	5177,	'iwp_log_action',	'schedule'),
(9599,	5177,	'iwp_log_activities_type',	'iwp_log'),
(9600,	5177,	'iwp_log_actions',	'backups'),
(9601,	5177,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:1:\"1\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9602,	5178,	'iwp_log_type',	'scheduleBackup'),
(9603,	5178,	'iwp_log_action',	'schedule'),
(9604,	5178,	'iwp_log_activities_type',	'iwp_log'),
(9605,	5178,	'iwp_log_actions',	'backups'),
(9606,	5178,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9607,	5182,	'iwp_log_type',	'scheduleBackup'),
(9608,	5182,	'iwp_log_action',	'schedule'),
(9609,	5182,	'iwp_log_activities_type',	'iwp_log'),
(9610,	5182,	'iwp_log_actions',	'backups'),
(9611,	5182,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9612,	5183,	'iwp_log_type',	'plugins'),
(9613,	5183,	'iwp_log_action',	'update'),
(9614,	5183,	'iwp_log_activities_type',	'automatic'),
(9615,	5183,	'iwp_log_actions',	'plugins-updated'),
(9616,	5183,	'iwp_log_details',	'a:4:{s:4:\"name\";s:18:\"Wordfence Security\";s:4:\"slug\";s:23:\"wordfence/wordfence.php\";s:11:\"old_version\";s:5:\"7.4.4\";s:15:\"updated_version\";s:5:\"7.4.5\";}'),
(9617,	5184,	'iwp_log_type',	'scheduleBackup'),
(9618,	5184,	'iwp_log_action',	'schedule'),
(9619,	5184,	'iwp_log_activities_type',	'iwp_log'),
(9620,	5184,	'iwp_log_actions',	'backups'),
(9621,	5184,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9622,	5186,	'iwp_log_type',	'scheduleBackup'),
(9623,	5186,	'iwp_log_action',	'schedule'),
(9624,	5186,	'iwp_log_activities_type',	'iwp_log'),
(9625,	5186,	'iwp_log_actions',	'backups'),
(9626,	5186,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9627,	5187,	'iwp_log_type',	'scheduleBackup'),
(9628,	5187,	'iwp_log_action',	'schedule'),
(9629,	5187,	'iwp_log_activities_type',	'iwp_log'),
(9630,	5187,	'iwp_log_actions',	'backups'),
(9631,	5187,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9632,	5191,	'iwp_log_type',	'scheduleBackup'),
(9633,	5191,	'iwp_log_action',	'schedule'),
(9634,	5191,	'iwp_log_activities_type',	'iwp_log'),
(9635,	5191,	'iwp_log_actions',	'backups'),
(9636,	5191,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9637,	5193,	'iwp_log_type',	'plugins'),
(9638,	5193,	'iwp_log_action',	'update'),
(9639,	5193,	'iwp_log_activities_type',	'automatic'),
(9640,	5193,	'iwp_log_actions',	'plugins-updated'),
(9641,	5193,	'iwp_log_details',	'a:4:{s:4:\"name\";s:37:\"Backup and Staging by WP Time Capsule\";s:4:\"slug\";s:35:\"wp-time-capsule/wp-time-capsule.php\";s:11:\"old_version\";s:7:\"1.21.17\";s:15:\"updated_version\";s:7:\"1.21.18\";}'),
(9642,	5194,	'iwp_log_type',	'scheduleBackup'),
(9643,	5194,	'iwp_log_action',	'schedule'),
(9644,	5194,	'iwp_log_activities_type',	'iwp_log'),
(9645,	5194,	'iwp_log_actions',	'backups'),
(9646,	5194,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9647,	5195,	'iwp_log_type',	'scheduleBackup'),
(9648,	5195,	'iwp_log_action',	'schedule'),
(9649,	5195,	'iwp_log_activities_type',	'iwp_log'),
(9650,	5195,	'iwp_log_actions',	'backups'),
(9651,	5195,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9652,	5197,	'iwp_log_type',	'scheduleBackup'),
(9653,	5197,	'iwp_log_action',	'schedule'),
(9654,	5197,	'iwp_log_activities_type',	'iwp_log'),
(9655,	5197,	'iwp_log_actions',	'backups'),
(9656,	5197,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9657,	5198,	'iwp_log_type',	'scheduleBackup'),
(9658,	5198,	'iwp_log_action',	'schedule'),
(9659,	5198,	'iwp_log_activities_type',	'iwp_log'),
(9660,	5198,	'iwp_log_actions',	'backups'),
(9661,	5198,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9662,	5199,	'iwp_log_type',	'scheduleBackup'),
(9663,	5199,	'iwp_log_action',	'schedule'),
(9664,	5199,	'iwp_log_activities_type',	'iwp_log'),
(9665,	5199,	'iwp_log_actions',	'backups'),
(9666,	5199,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9667,	5201,	'iwp_log_type',	'scheduleBackup'),
(9668,	5201,	'iwp_log_action',	'schedule'),
(9669,	5201,	'iwp_log_activities_type',	'iwp_log'),
(9670,	5201,	'iwp_log_actions',	'backups'),
(9671,	5201,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9672,	5206,	'iwp_log_type',	'scheduleBackup'),
(9673,	5206,	'iwp_log_action',	'schedule'),
(9674,	5206,	'iwp_log_activities_type',	'iwp_log'),
(9675,	5206,	'iwp_log_actions',	'backups'),
(9676,	5206,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9677,	5207,	'iwp_log_type',	'scheduleBackup'),
(9678,	5207,	'iwp_log_action',	'schedule'),
(9679,	5207,	'iwp_log_activities_type',	'iwp_log'),
(9680,	5207,	'iwp_log_actions',	'backups'),
(9681,	5207,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9682,	5209,	'iwp_log_type',	'scheduleBackup'),
(9683,	5209,	'iwp_log_action',	'schedule'),
(9684,	5209,	'iwp_log_activities_type',	'iwp_log'),
(9685,	5209,	'iwp_log_actions',	'backups'),
(9686,	5209,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9687,	5210,	'iwp_log_type',	'scheduleBackup'),
(9688,	5210,	'iwp_log_action',	'schedule'),
(9689,	5210,	'iwp_log_activities_type',	'iwp_log'),
(9690,	5210,	'iwp_log_actions',	'backups'),
(9691,	5210,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9692,	5211,	'iwp_log_type',	'scheduleBackup'),
(9693,	5211,	'iwp_log_action',	'schedule'),
(9694,	5211,	'iwp_log_activities_type',	'iwp_log'),
(9695,	5211,	'iwp_log_actions',	'backups'),
(9696,	5211,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9697,	5212,	'iwp_log_type',	'scheduleBackup'),
(9698,	5212,	'iwp_log_action',	'schedule'),
(9699,	5212,	'iwp_log_activities_type',	'iwp_log'),
(9700,	5212,	'iwp_log_actions',	'backups'),
(9701,	5212,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9702,	5213,	'iwp_log_type',	'scheduleBackup'),
(9703,	5213,	'iwp_log_action',	'schedule'),
(9704,	5213,	'iwp_log_activities_type',	'iwp_log'),
(9705,	5213,	'iwp_log_actions',	'backups'),
(9706,	5213,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9707,	5214,	'iwp_log_type',	'scheduleBackup'),
(9708,	5214,	'iwp_log_action',	'schedule'),
(9709,	5214,	'iwp_log_activities_type',	'iwp_log'),
(9710,	5214,	'iwp_log_actions',	'backups'),
(9711,	5214,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9712,	5215,	'iwp_log_type',	'scheduleBackup'),
(9713,	5215,	'iwp_log_action',	'schedule'),
(9714,	5215,	'iwp_log_activities_type',	'iwp_log'),
(9715,	5215,	'iwp_log_actions',	'backups'),
(9716,	5215,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9717,	5216,	'_wp_attached_file',	'2020/02/team-attorney-1-v4.jpg'),
(9718,	5216,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:624;s:6:\"height\";i:384;s:4:\"file\";s:30:\"2020/02/team-attorney-1-v4.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"team-attorney-1-v4-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-1-v4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-1-v4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:30:\"team-attorney-1-v4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:30:\"team-attorney-1-v4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(9719,	5217,	'_wp_attached_file',	'2020/02/team-attorney-5-v4.jpg'),
(9720,	5217,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:624;s:6:\"height\";i:384;s:4:\"file\";s:30:\"2020/02/team-attorney-5-v4.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"team-attorney-5-v4-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-5-v4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"team-attorney-5-v4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:30:\"team-attorney-5-v4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:30:\"team-attorney-5-v4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(9744,	5223,	'iwp_log_type',	'plugins'),
(9745,	5223,	'iwp_log_action',	'update'),
(9746,	5223,	'iwp_log_activities_type',	'automatic'),
(9747,	5223,	'iwp_log_actions',	'plugins-updated'),
(9748,	5223,	'iwp_log_details',	'a:4:{s:4:\"name\";s:37:\"Backup and Staging by WP Time Capsule\";s:4:\"slug\";s:35:\"wp-time-capsule/wp-time-capsule.php\";s:11:\"old_version\";s:7:\"1.21.18\";s:15:\"updated_version\";s:7:\"1.21.19\";}'),
(9749,	5224,	'iwp_log_type',	'scheduleBackup'),
(9750,	5224,	'iwp_log_action',	'schedule'),
(9751,	5224,	'iwp_log_activities_type',	'iwp_log'),
(9752,	5224,	'iwp_log_actions',	'backups'),
(9753,	5224,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9754,	5228,	'iwp_log_type',	'scheduleBackup'),
(9755,	5228,	'iwp_log_action',	'schedule'),
(9756,	5228,	'iwp_log_activities_type',	'iwp_log'),
(9757,	5228,	'iwp_log_actions',	'backups'),
(9758,	5228,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9759,	5230,	'iwp_log_type',	'scheduleBackup'),
(9760,	5230,	'iwp_log_action',	'schedule'),
(9761,	5230,	'iwp_log_activities_type',	'iwp_log'),
(9762,	5230,	'iwp_log_actions',	'backups'),
(9763,	5230,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9764,	5231,	'iwp_log_type',	'scheduleBackup'),
(9765,	5231,	'iwp_log_action',	'schedule'),
(9766,	5231,	'iwp_log_activities_type',	'iwp_log'),
(9767,	5231,	'iwp_log_actions',	'backups'),
(9768,	5231,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9769,	5232,	'iwp_log_type',	'scheduleBackup'),
(9770,	5232,	'iwp_log_action',	'schedule'),
(9771,	5232,	'iwp_log_activities_type',	'iwp_log'),
(9772,	5232,	'iwp_log_actions',	'backups'),
(9773,	5232,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9774,	5234,	'iwp_log_type',	'scheduleBackup'),
(9775,	5234,	'iwp_log_action',	'schedule'),
(9776,	5234,	'iwp_log_activities_type',	'iwp_log'),
(9777,	5234,	'iwp_log_actions',	'backups'),
(9778,	5234,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9779,	5235,	'iwp_log_type',	'plugins'),
(9780,	5235,	'iwp_log_action',	'update'),
(9781,	5235,	'iwp_log_activities_type',	'automatic'),
(9782,	5235,	'iwp_log_actions',	'plugins-updated'),
(9783,	5235,	'iwp_log_details',	'a:4:{s:4:\"name\";s:37:\"Backup and Staging by WP Time Capsule\";s:4:\"slug\";s:35:\"wp-time-capsule/wp-time-capsule.php\";s:11:\"old_version\";s:7:\"1.21.19\";s:15:\"updated_version\";s:7:\"1.21.20\";}'),
(9784,	5236,	'iwp_log_type',	'scheduleBackup'),
(9785,	5236,	'iwp_log_action',	'schedule'),
(9786,	5236,	'iwp_log_activities_type',	'iwp_log'),
(9787,	5236,	'iwp_log_actions',	'backups'),
(9788,	5236,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9789,	5237,	'iwp_log_type',	'scheduleBackup'),
(9790,	5237,	'iwp_log_action',	'schedule'),
(9791,	5237,	'iwp_log_activities_type',	'iwp_log'),
(9792,	5237,	'iwp_log_actions',	'backups'),
(9793,	5237,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9794,	5238,	'iwp_log_type',	'plugins'),
(9795,	5238,	'iwp_log_action',	'update'),
(9796,	5238,	'iwp_log_activities_type',	'automatic'),
(9797,	5238,	'iwp_log_actions',	'plugins-updated'),
(9798,	5238,	'iwp_log_details',	'a:4:{s:4:\"name\";s:18:\"Wordfence Security\";s:4:\"slug\";s:23:\"wordfence/wordfence.php\";s:11:\"old_version\";s:5:\"7.4.5\";s:15:\"updated_version\";s:5:\"7.4.6\";}'),
(9799,	5239,	'iwp_log_type',	'scheduleBackup'),
(9800,	5239,	'iwp_log_action',	'schedule'),
(9801,	5239,	'iwp_log_activities_type',	'iwp_log'),
(9802,	5239,	'iwp_log_actions',	'backups'),
(9803,	5239,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9807,	5243,	'iwp_log_type',	'scheduleBackup'),
(9808,	5243,	'iwp_log_action',	'schedule'),
(9809,	5243,	'iwp_log_activities_type',	'iwp_log'),
(9810,	5243,	'iwp_log_actions',	'backups'),
(9811,	5243,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9812,	5244,	'iwp_log_type',	'scheduleBackup'),
(9813,	5244,	'iwp_log_action',	'schedule'),
(9814,	5244,	'iwp_log_activities_type',	'iwp_log'),
(9815,	5244,	'iwp_log_actions',	'backups'),
(9816,	5244,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9817,	5245,	'iwp_log_type',	'scheduleBackup'),
(9818,	5245,	'iwp_log_action',	'schedule'),
(9819,	5245,	'iwp_log_activities_type',	'iwp_log'),
(9820,	5245,	'iwp_log_actions',	'backups'),
(9821,	5245,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9822,	5247,	'iwp_log_type',	'scheduleBackup'),
(9823,	5247,	'iwp_log_action',	'schedule'),
(9824,	5247,	'iwp_log_activities_type',	'iwp_log'),
(9825,	5247,	'iwp_log_actions',	'backups'),
(9826,	5247,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9827,	5248,	'iwp_log_type',	'scheduleBackup'),
(9828,	5248,	'iwp_log_action',	'schedule'),
(9829,	5248,	'iwp_log_activities_type',	'iwp_log'),
(9830,	5248,	'iwp_log_actions',	'backups'),
(9831,	5248,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9832,	5250,	'iwp_log_type',	'scheduleBackup'),
(9833,	5250,	'iwp_log_action',	'schedule'),
(9834,	5250,	'iwp_log_activities_type',	'iwp_log'),
(9835,	5250,	'iwp_log_actions',	'backups'),
(9836,	5250,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9837,	5252,	'iwp_log_type',	'scheduleBackup'),
(9838,	5252,	'iwp_log_action',	'schedule'),
(9839,	5252,	'iwp_log_activities_type',	'iwp_log'),
(9840,	5252,	'iwp_log_actions',	'backups'),
(9841,	5252,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9842,	5253,	'iwp_log_type',	'scheduleBackup'),
(9843,	5253,	'iwp_log_action',	'schedule'),
(9844,	5253,	'iwp_log_activities_type',	'iwp_log'),
(9845,	5253,	'iwp_log_actions',	'backups'),
(9846,	5253,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9847,	5255,	'iwp_log_type',	'scheduleBackup'),
(9848,	5255,	'iwp_log_action',	'schedule'),
(9849,	5255,	'iwp_log_activities_type',	'iwp_log'),
(9850,	5255,	'iwp_log_actions',	'backups'),
(9851,	5255,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9852,	5256,	'iwp_log_type',	'scheduleBackup'),
(9853,	5256,	'iwp_log_action',	'schedule'),
(9854,	5256,	'iwp_log_activities_type',	'iwp_log'),
(9855,	5256,	'iwp_log_actions',	'backups'),
(9856,	5256,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9857,	5259,	'iwp_log_type',	'scheduleBackup'),
(9858,	5259,	'iwp_log_action',	'schedule'),
(9859,	5259,	'iwp_log_activities_type',	'iwp_log'),
(9860,	5259,	'iwp_log_actions',	'backups'),
(9861,	5259,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9862,	5263,	'_wp_attached_file',	'2020/02/team-attorney-placeholder-v2.png'),
(9863,	5263,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:624;s:6:\"height\";i:384;s:4:\"file\";s:40:\"2020/02/team-attorney-placeholder-v2.png\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:40:\"team-attorney-placeholder-v2-300x185.png\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:40:\"team-attorney-placeholder-v2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:40:\"team-attorney-placeholder-v2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:40:\"team-attorney-placeholder-v2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:40:\"team-attorney-placeholder-v2-200x200.png\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(9870,	5264,	'iwp_log_type',	'scheduleBackup'),
(9871,	5264,	'iwp_log_action',	'schedule'),
(9872,	5264,	'iwp_log_activities_type',	'iwp_log'),
(9873,	5264,	'iwp_log_actions',	'backups'),
(9874,	5264,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9875,	5265,	'iwp_log_type',	'scheduleBackup'),
(9876,	5265,	'iwp_log_action',	'schedule'),
(9877,	5265,	'iwp_log_activities_type',	'iwp_log'),
(9878,	5265,	'iwp_log_actions',	'backups'),
(9879,	5265,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9880,	5267,	'iwp_log_type',	'scheduleBackup'),
(9881,	5267,	'iwp_log_action',	'schedule'),
(9882,	5267,	'iwp_log_activities_type',	'iwp_log'),
(9883,	5267,	'iwp_log_actions',	'backups'),
(9884,	5267,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9885,	5271,	'iwp_log_type',	'plugins'),
(9886,	5271,	'iwp_log_action',	'update'),
(9887,	5271,	'iwp_log_activities_type',	'automatic'),
(9888,	5271,	'iwp_log_actions',	'plugins-updated'),
(9889,	5271,	'iwp_log_details',	'a:4:{s:4:\"name\";s:37:\"Backup and Staging by WP Time Capsule\";s:4:\"slug\";s:35:\"wp-time-capsule/wp-time-capsule.php\";s:11:\"old_version\";s:7:\"1.21.20\";s:15:\"updated_version\";s:7:\"1.21.21\";}'),
(9890,	5273,	'iwp_log_type',	'scheduleBackup'),
(9891,	5273,	'iwp_log_action',	'schedule'),
(9892,	5273,	'iwp_log_activities_type',	'iwp_log'),
(9893,	5273,	'iwp_log_actions',	'backups'),
(9894,	5273,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9991,	5274,	'iwp_log_type',	'scheduleBackup'),
(9992,	5274,	'iwp_log_action',	'schedule'),
(9993,	5274,	'iwp_log_activities_type',	'iwp_log'),
(9994,	5274,	'iwp_log_actions',	'backups'),
(9995,	5274,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(9996,	5275,	'iwp_log_type',	'scheduleBackup'),
(9997,	5275,	'iwp_log_action',	'schedule'),
(9998,	5275,	'iwp_log_activities_type',	'iwp_log'),
(9999,	5275,	'iwp_log_actions',	'backups'),
(10000,	5275,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10001,	5276,	'iwp_log_type',	'scheduleBackup'),
(10002,	5276,	'iwp_log_action',	'schedule'),
(10003,	5276,	'iwp_log_activities_type',	'iwp_log'),
(10004,	5276,	'iwp_log_actions',	'backups'),
(10005,	5276,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10006,	2476,	'_edit_lock',	'1583263510:1'),
(10009,	5292,	'iwp_log_type',	'scheduleBackup'),
(10010,	5292,	'iwp_log_action',	'schedule'),
(10011,	5292,	'iwp_log_activities_type',	'iwp_log'),
(10012,	5292,	'iwp_log_actions',	'backups'),
(10013,	5292,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10014,	5294,	'iwp_log_type',	'scheduleBackup'),
(10015,	5294,	'iwp_log_action',	'schedule'),
(10016,	5294,	'iwp_log_activities_type',	'iwp_log'),
(10017,	5294,	'iwp_log_actions',	'backups'),
(10018,	5294,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10019,	5295,	'iwp_log_type',	'scheduleBackup'),
(10020,	5295,	'iwp_log_action',	'schedule'),
(10021,	5295,	'iwp_log_activities_type',	'iwp_log'),
(10022,	5295,	'iwp_log_actions',	'backups'),
(10023,	5295,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10024,	5296,	'iwp_log_type',	'plugins'),
(10025,	5296,	'iwp_log_action',	'update'),
(10026,	5296,	'iwp_log_activities_type',	'automatic'),
(10027,	5296,	'iwp_log_actions',	'plugins-updated'),
(10028,	5296,	'iwp_log_details',	'a:4:{s:4:\"name\";s:20:\"Classic Editor Addon\";s:4:\"slug\";s:45:\"classic-editor-addon/classic-editor-addon.php\";s:11:\"old_version\";s:5:\"2.6.0\";s:15:\"updated_version\";s:5:\"2.6.1\";}'),
(10029,	5297,	'iwp_log_type',	'scheduleBackup'),
(10030,	5297,	'iwp_log_action',	'schedule'),
(10031,	5297,	'iwp_log_activities_type',	'iwp_log'),
(10032,	5297,	'iwp_log_actions',	'backups'),
(10033,	5297,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10034,	5298,	'iwp_log_type',	'scheduleBackup'),
(10035,	5298,	'iwp_log_action',	'schedule'),
(10036,	5298,	'iwp_log_activities_type',	'iwp_log'),
(10037,	5298,	'iwp_log_actions',	'backups'),
(10038,	5298,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10039,	5299,	'iwp_log_type',	'scheduleBackup'),
(10040,	5299,	'iwp_log_action',	'schedule'),
(10041,	5299,	'iwp_log_activities_type',	'iwp_log'),
(10042,	5299,	'iwp_log_actions',	'backups'),
(10043,	5299,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10050,	5302,	'iwp_log_type',	'scheduleBackup'),
(10051,	5302,	'iwp_log_action',	'schedule'),
(10052,	5302,	'iwp_log_activities_type',	'iwp_log'),
(10053,	5302,	'iwp_log_actions',	'backups'),
(10054,	5302,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10055,	5304,	'iwp_log_type',	'scheduleBackup'),
(10056,	5304,	'iwp_log_action',	'schedule'),
(10057,	5304,	'iwp_log_activities_type',	'iwp_log'),
(10058,	5304,	'iwp_log_actions',	'backups'),
(10059,	5304,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10060,	5306,	'iwp_log_type',	'plugins'),
(10061,	5306,	'iwp_log_action',	'update'),
(10062,	5306,	'iwp_log_activities_type',	'automatic'),
(10063,	5306,	'iwp_log_actions',	'plugins-updated'),
(10064,	5306,	'iwp_log_details',	'a:4:{s:4:\"name\";s:37:\"Backup and Staging by WP Time Capsule\";s:4:\"slug\";s:35:\"wp-time-capsule/wp-time-capsule.php\";s:11:\"old_version\";s:7:\"1.21.21\";s:15:\"updated_version\";s:7:\"1.21.22\";}'),
(10065,	5307,	'iwp_log_type',	'scheduleBackup'),
(10066,	5307,	'iwp_log_action',	'schedule'),
(10067,	5307,	'iwp_log_activities_type',	'iwp_log'),
(10068,	5307,	'iwp_log_actions',	'backups'),
(10069,	5307,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10070,	5309,	'iwp_log_type',	'plugins'),
(10071,	5309,	'iwp_log_action',	'update'),
(10072,	5309,	'iwp_log_activities_type',	'automatic'),
(10073,	5309,	'iwp_log_actions',	'plugins-updated'),
(10074,	5309,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:5:\"3.4.4\";s:15:\"updated_version\";s:7:\"3.5.0.3\";}'),
(10075,	5310,	'iwp_log_type',	'scheduleBackup'),
(10076,	5310,	'iwp_log_action',	'schedule'),
(10077,	5310,	'iwp_log_activities_type',	'iwp_log'),
(10078,	5310,	'iwp_log_actions',	'backups'),
(10079,	5310,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10080,	5311,	'iwp_log_type',	'scheduleBackup'),
(10081,	5311,	'iwp_log_action',	'schedule'),
(10082,	5311,	'iwp_log_activities_type',	'iwp_log'),
(10083,	5311,	'iwp_log_actions',	'backups'),
(10084,	5311,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10085,	5312,	'iwp_log_type',	'plugins'),
(10086,	5312,	'iwp_log_action',	'update'),
(10087,	5312,	'iwp_log_activities_type',	'automatic'),
(10088,	5312,	'iwp_log_actions',	'plugins-updated'),
(10089,	5312,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:7:\"3.5.0.3\";s:15:\"updated_version\";s:7:\"3.5.0.4\";}'),
(10090,	5313,	'iwp_log_type',	'scheduleBackup'),
(10091,	5313,	'iwp_log_action',	'schedule'),
(10092,	5313,	'iwp_log_activities_type',	'iwp_log'),
(10093,	5313,	'iwp_log_actions',	'backups'),
(10094,	5313,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10095,	5314,	'iwp_log_type',	'scheduleBackup'),
(10096,	5314,	'iwp_log_action',	'schedule'),
(10097,	5314,	'iwp_log_activities_type',	'iwp_log'),
(10098,	5314,	'iwp_log_actions',	'backups'),
(10099,	5314,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10100,	5315,	'iwp_log_type',	'scheduleBackup'),
(10101,	5315,	'iwp_log_action',	'schedule'),
(10102,	5315,	'iwp_log_activities_type',	'iwp_log'),
(10103,	5315,	'iwp_log_actions',	'backups'),
(10104,	5315,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10105,	5316,	'iwp_log_type',	'scheduleBackup'),
(10106,	5316,	'iwp_log_action',	'schedule'),
(10107,	5316,	'iwp_log_activities_type',	'iwp_log'),
(10108,	5316,	'iwp_log_actions',	'backups'),
(10109,	5316,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10110,	5318,	'iwp_log_type',	'scheduleBackup'),
(10111,	5318,	'iwp_log_action',	'schedule'),
(10112,	5318,	'iwp_log_activities_type',	'iwp_log'),
(10113,	5318,	'iwp_log_actions',	'backups'),
(10114,	5318,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10116,	5320,	'_edit_lock',	'1586275375:3'),
(10117,	5320,	'_edit_last',	'3'),
(10118,	5320,	'_title',	'Lakeland Personal Injury Lawyer'),
(10119,	5320,	'_description',	'If you or a loved one were recently injured in an accident through no fault of your own, contact an experienced Lakeland personal injury lawyer today.'),
(10120,	5320,	'_keywords',	'Lakeland Personal Injury Lawyer'),
(10121,	5320,	'_subslideID',	''),
(10122,	5322,	'_edit_lock',	'1584643660:3'),
(10123,	5322,	'_edit_last',	'3'),
(10124,	5322,	'_title',	'Lakeland Catastrophic Injury Lawyer'),
(10125,	5322,	'_description',	'To learn more about recovering compensation for your own accident-related catastrophic injury, call our Lakeland catastrophic injury lawyers today.'),
(10126,	5322,	'_keywords',	'Lakeland Catastrophic Injury Lawyer'),
(10127,	5322,	'_subslideID',	''),
(10128,	5324,	'_edit_lock',	'1586274543:3'),
(10129,	5324,	'_edit_last',	'3'),
(10130,	5324,	'_title',	'Lakeland Commercial Vehicle Accidents Lawyer'),
(10131,	5324,	'_description',	'If you were recently injured in a collision with a semi-truck or other commercial vehicle, call our Lakeland truck accident lawyers today.'),
(10132,	5324,	'_keywords',	'Lakeland Commercial Vehicle Accidents Lawyer'),
(10133,	5324,	'_subslideID',	''),
(10134,	5326,	'_edit_lock',	'1584741948:3'),
(10135,	5326,	'_edit_last',	'3'),
(10136,	5326,	'_title',	'Lakeland Insurance Bad Faith Lawyer'),
(10137,	5326,	'_description',	'If you need help to file a bad faith insurance claim, call the Lakeland bad faith insurance lawyers at the Pawlowski // Mastrilli Law Group today.'),
(10138,	5326,	'_keywords',	'Lakeland Insurance Bad Faith Lawyer'),
(10139,	5326,	'_subslideID',	''),
(10140,	5329,	'_edit_lock',	'1584643640:3'),
(10141,	5329,	'_edit_last',	'3'),
(10142,	5329,	'_title',	'Lakeland Insurance Liability Lawyer'),
(10143,	5329,	'_description',	'If you were in a car accident and your injuries were so severe that they exceeded the limits of your policy, call our Lakeland insurance liability lawyers.'),
(10144,	5329,	'_keywords',	'Lakeland Insurance Liability Lawyer'),
(10145,	5329,	'_subslideID',	''),
(10146,	5331,	'_edit_lock',	'1584643582:3'),
(10147,	5331,	'_edit_last',	'3'),
(10148,	5331,	'_title',	'Lakeland Medical Malpractice Lawyer'),
(10149,	5331,	'_description',	'If you are suffering an injury because of a doctor’s negligence, call the Lakeland medical malpractice lawyers at the Pawlowski // Mastrilli Law Group today.'),
(10150,	5331,	'_keywords',	'Lakeland Medical Malpractice Lawyer'),
(10151,	5331,	'_subslideID',	''),
(10152,	5333,	'_edit_lock',	'1586274621:3'),
(10153,	5333,	'_edit_last',	'3'),
(10154,	5333,	'_title',	'Lakeland Motorcycle Accident Lawyer'),
(10155,	5333,	'_description',	'If you or a loved one recently sustained an injury in a motorcycle accident, call our Lakeland motorcycle accident lawyers at Pawlowski // Mastrilli Law Group.'),
(10156,	5333,	'_keywords',	'Lakeland Motorcycle Accident Lawyer'),
(10157,	5333,	'_subslideID',	''),
(10173,	5345,	'iwp_log_type',	'plugins'),
(10174,	5345,	'iwp_log_action',	'update'),
(10175,	5345,	'iwp_log_activities_type',	'automatic'),
(10176,	5345,	'iwp_log_actions',	'plugins-updated'),
(10177,	5345,	'iwp_log_details',	'a:4:{s:4:\"name\";s:37:\"Backup and Staging by WP Time Capsule\";s:4:\"slug\";s:35:\"wp-time-capsule/wp-time-capsule.php\";s:11:\"old_version\";s:7:\"1.21.22\";s:15:\"updated_version\";s:7:\"1.21.24\";}'),
(10178,	5346,	'iwp_log_type',	'plugins'),
(10179,	5346,	'iwp_log_action',	'update'),
(10180,	5346,	'iwp_log_activities_type',	'automatic'),
(10181,	5346,	'iwp_log_actions',	'plugins-updated'),
(10182,	5346,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:7:\"3.5.0.4\";s:15:\"updated_version\";s:5:\"3.5.1\";}'),
(10183,	5347,	'iwp_log_type',	'scheduleBackup'),
(10184,	5347,	'iwp_log_action',	'schedule'),
(10185,	5347,	'iwp_log_activities_type',	'iwp_log'),
(10186,	5347,	'iwp_log_actions',	'backups'),
(10187,	5347,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10251,	5364,	'_edit_lock',	'1586275381:3'),
(10252,	5364,	'_edit_last',	'3'),
(10253,	5364,	'_title',	'Oldsmar Personal Injury Lawyer'),
(10254,	5364,	'_description',	'It is important to contact an experienced Oldsmar personal injury lawyer who can advise you, reach out to our firm today.'),
(10255,	5364,	'_keywords',	'Oldsmar Personal Injury Lawyer'),
(10256,	5364,	'_subslideID',	''),
(10257,	5366,	'_edit_lock',	'1584740894:3'),
(10258,	5366,	'_edit_last',	'3'),
(10259,	5366,	'_title',	'Oldsmar Catastrophic Injury Lawyer'),
(10260,	5366,	'_description',	'Speak with an experienced Oldsmar catastrophic injury lawyer who can help collect the monetary damages that will best allow victims to begin healing.'),
(10261,	5366,	'_keywords',	'Oldsmar Catastrophic Injury Lawyer'),
(10262,	5366,	'_subslideID',	''),
(10263,	5368,	'_edit_lock',	'1584741057:3'),
(10264,	5368,	'_edit_last',	'3'),
(10265,	5368,	'_title',	'Oldsmar Commercial Vehicle Accident Lawyer'),
(10266,	5368,	'_description',	'Contact an experienced Oldsmar truck accident lawyer who can help protect your interests.'),
(10267,	5368,	'_keywords',	'Oldsmar Commercial Vehicle Accident Lawyer'),
(10268,	5368,	'_subslideID',	''),
(10269,	5371,	'_edit_lock',	'1584741938:3'),
(10270,	5371,	'_edit_last',	'3'),
(10271,	5371,	'_title',	'Oldsmar Insurance Bad Faith Lawyer'),
(10272,	5371,	'_description',	'It is important to speak with an experienced Oldsmar bad faith insurance lawyer who can help you hold your insurer accountable.'),
(10273,	5371,	'_keywords',	'Oldsmar Insurance Bad Faith Lawyer'),
(10274,	5371,	'_subslideID',	''),
(10275,	5373,	'_edit_lock',	'1584741718:3'),
(10276,	5373,	'_edit_last',	'3'),
(10277,	5373,	'_title',	'Oldsmar Insurance Liability Lawyer'),
(10278,	5373,	'_description',	'It is important to speak with a knowledgeable Oldsmar insurance liability lawyer who can walk you through the claim filing process.'),
(10279,	5373,	'_keywords',	'Oldsmar Insurance Liability Lawyer'),
(10280,	5373,	'_subslideID',	''),
(10281,	5375,	'_edit_lock',	'1584741667:3'),
(10282,	5375,	'_edit_last',	'3'),
(10283,	5375,	'_title',	'Oldsmar Medical Malpractice Lawyer'),
(10284,	5375,	'_description',	'Retaining an experienced Oldsmar medical malpractice lawyer can make all the difference in the outcome of a case, contact us today.'),
(10285,	5375,	'_keywords',	'Oldsmar Medical Malpractice Lawyer'),
(10286,	5375,	'_subslideID',	''),
(10287,	5377,	'_edit_lock',	'1584741781:3'),
(10288,	5377,	'_edit_last',	'3'),
(10289,	5377,	'_title',	'Oldsmar Motorcycle Accident Lawyer'),
(10290,	5377,	'_description',	'Our experienced Oldsmar motorcycle accident lawyers are well-versed in the physical, emotional, and legal obstacles faced by injured motorcyclists, contact us.'),
(10291,	5377,	'_keywords',	'Oldsmar Motorcycle Accident Lawyer'),
(10292,	5377,	'_subslideID',	''),
(10302,	5384,	'iwp_log_type',	'scheduleBackup'),
(10303,	5384,	'iwp_log_action',	'schedule'),
(10304,	5384,	'iwp_log_activities_type',	'iwp_log'),
(10305,	5384,	'iwp_log_actions',	'backups'),
(10306,	5384,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10307,	5385,	'iwp_log_type',	'plugins'),
(10308,	5385,	'iwp_log_action',	'update'),
(10309,	5385,	'iwp_log_activities_type',	'automatic'),
(10310,	5385,	'iwp_log_actions',	'plugins-updated'),
(10311,	5385,	'iwp_log_details',	'a:4:{s:4:\"name\";s:20:\"Simple Page Ordering\";s:4:\"slug\";s:45:\"simple-page-ordering/simple-page-ordering.php\";s:11:\"old_version\";s:5:\"2.3.2\";s:15:\"updated_version\";s:5:\"2.3.3\";}'),
(10312,	5386,	'iwp_log_type',	'scheduleBackup'),
(10313,	5386,	'iwp_log_action',	'schedule'),
(10314,	5386,	'iwp_log_activities_type',	'iwp_log'),
(10315,	5386,	'iwp_log_actions',	'backups'),
(10316,	5386,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10317,	5387,	'iwp_log_type',	'scheduleBackup'),
(10318,	5387,	'iwp_log_action',	'schedule'),
(10319,	5387,	'iwp_log_activities_type',	'iwp_log'),
(10320,	5387,	'iwp_log_actions',	'backups'),
(10321,	5387,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10322,	5389,	'_edit_lock',	'1584990357:3'),
(10323,	5389,	'_edit_last',	'3'),
(10326,	5389,	'_title',	'COVID-19 Message'),
(10327,	5389,	'_description',	''),
(10328,	5389,	'_keywords',	''),
(10329,	5389,	'_subslideID',	''),
(10330,	5392,	'_edit_lock',	'1584999045:3'),
(10331,	5392,	'_edit_last',	'3'),
(10332,	5392,	'_title',	''),
(10333,	5392,	'_description',	''),
(10334,	5392,	'_keywords',	''),
(10335,	5392,	'_subslideID',	''),
(10336,	5398,	'iwp_log_type',	'scheduleBackup'),
(10337,	5398,	'iwp_log_action',	'schedule'),
(10338,	5398,	'iwp_log_activities_type',	'iwp_log'),
(10339,	5398,	'iwp_log_actions',	'backups'),
(10340,	5398,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10341,	5399,	'iwp_log_type',	'scheduleBackup'),
(10342,	5399,	'iwp_log_action',	'schedule'),
(10343,	5399,	'iwp_log_activities_type',	'iwp_log'),
(10344,	5399,	'iwp_log_actions',	'backups'),
(10345,	5399,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10347,	5401,	'_edit_lock',	'1585163165:3'),
(10348,	5401,	'_edit_last',	'3'),
(10349,	5401,	'_title',	'Oldsmar Nursing Home Abuse Lawyer'),
(10350,	5401,	'_description',	'If you believe that a loved one is being abused, call the Oldsmar nursing home abuse lawyers at Pawlowski // Mastrilli Law Group today.'),
(10351,	5401,	'_keywords',	'Oldsmar Nursing Home Abuse Lawyer'),
(10352,	5401,	'_subslideID',	''),
(10353,	5403,	'_edit_lock',	'1585163165:3'),
(10354,	5403,	'_edit_last',	'3'),
(10355,	5403,	'_title',	'Oldsmar Pharmaceutical Injury Lawyer'),
(10356,	5403,	'_description',	'If you were hurt as a result of a pharmaceutical drug-related injury, call the Oldsmar Pharmaceutical Injury Lawyers at Pawlowski // Mastrilli Law Group today.'),
(10357,	5403,	'_keywords',	'Oldsmar Pharmaceutical Injury Lawyer'),
(10358,	5403,	'_subslideID',	''),
(10359,	5405,	'_edit_lock',	'1585163166:3'),
(10360,	5405,	'_edit_last',	'3'),
(10361,	5405,	'_title',	'Oldsmar Premises Liability Lawyer'),
(10362,	5405,	'_description',	'If a landowner’s negligence caused your own injury, call the premises liability legal team at the Pawlowski // Mastrilli Law Group today.'),
(10363,	5405,	'_keywords',	'Oldsmar Premises Liability Lawyer'),
(10364,	5405,	'_subslideID',	''),
(10365,	5407,	'_edit_lock',	'1585163168:3'),
(10366,	5407,	'_edit_last',	'3'),
(10367,	5407,	'_title',	'Oldsmar Workplace Accident Lawyer'),
(10368,	5407,	'_description',	'To help with your personal injury claim after a workplace accident, call the Oldsmar Workplace Accident Lawyers at the Pawlowski // Mastrilli Law Group.'),
(10369,	5407,	'_keywords',	'Oldsmar Workplace Accident Lawyer'),
(10370,	5407,	'_subslideID',	''),
(10371,	5409,	'_edit_lock',	'1585163197:3'),
(10372,	5409,	'_edit_last',	'3'),
(10373,	5409,	'_title',	'Oldsmar Wrongful Death Lawyer'),
(10374,	5409,	'_description',	'If you lost a loved due to a wrongful death, call the Oldsmar wrongful death lawyers at Pawlowski // Mastrilli Law Group today.'),
(10375,	5409,	'_keywords',	'Oldsmar Wrongful Death Lawyer'),
(10376,	5409,	'_subslideID',	''),
(10377,	5411,	'_edit_lock',	'1586275570:3'),
(10378,	5411,	'_edit_last',	'3'),
(10379,	5411,	'_title',	'Oldsmar Car Accident Lawyer'),
(10380,	5411,	'_description',	'If you were recently injured in a collision in Florida, call the Oldsmar car accident lawyers at the Pawlowski // Mastrilli Law Group today.'),
(10381,	5411,	'_keywords',	'Oldsmar Car Accident Lawyer'),
(10382,	5411,	'_subslideID',	''),
(10383,	5413,	'_edit_lock',	'1585163197:3'),
(10384,	5413,	'_edit_last',	'3'),
(10385,	5413,	'_title',	'Oldsmar Auto Accident Lawyer'),
(10386,	5413,	'_description',	'If you were injured in a car accident, please call the Olds auto accident lawyers at the Pawlowski // Mastrilli Law Group today.'),
(10387,	5413,	'_keywords',	'Oldsmar Auto Accident Lawyer'),
(10388,	5413,	'_subslideID',	''),
(10416,	5421,	'iwp_log_type',	'scheduleBackup'),
(10417,	5421,	'iwp_log_action',	'schedule'),
(10418,	5421,	'iwp_log_activities_type',	'iwp_log'),
(10419,	5421,	'iwp_log_actions',	'backups'),
(10420,	5421,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10421,	5423,	'iwp_log_type',	'scheduleBackup'),
(10422,	5423,	'iwp_log_action',	'schedule'),
(10423,	5423,	'iwp_log_activities_type',	'iwp_log'),
(10424,	5423,	'iwp_log_actions',	'backups'),
(10425,	5423,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10426,	5424,	'iwp_log_type',	'scheduleBackup'),
(10427,	5424,	'iwp_log_action',	'schedule'),
(10428,	5424,	'iwp_log_activities_type',	'iwp_log'),
(10429,	5424,	'iwp_log_actions',	'backups'),
(10430,	5424,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10431,	5425,	'iwp_log_type',	'scheduleBackup'),
(10432,	5425,	'iwp_log_action',	'schedule'),
(10433,	5425,	'iwp_log_activities_type',	'iwp_log'),
(10434,	5425,	'iwp_log_actions',	'backups'),
(10435,	5425,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10436,	5426,	'iwp_log_type',	'scheduleBackup'),
(10437,	5426,	'iwp_log_action',	'schedule'),
(10438,	5426,	'iwp_log_activities_type',	'iwp_log'),
(10439,	5426,	'iwp_log_actions',	'backups'),
(10440,	5426,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10441,	5427,	'iwp_log_type',	'scheduleBackup'),
(10442,	5427,	'iwp_log_action',	'schedule'),
(10443,	5427,	'iwp_log_activities_type',	'iwp_log'),
(10444,	5427,	'iwp_log_actions',	'backups'),
(10445,	5427,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10446,	5428,	'iwp_log_type',	'scheduleBackup'),
(10447,	5428,	'iwp_log_action',	'schedule'),
(10448,	5428,	'iwp_log_activities_type',	'iwp_log'),
(10449,	5428,	'iwp_log_actions',	'backups'),
(10450,	5428,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10451,	5429,	'iwp_log_type',	'plugins'),
(10452,	5429,	'iwp_log_action',	'update'),
(10453,	5429,	'iwp_log_activities_type',	'automatic'),
(10454,	5429,	'iwp_log_actions',	'plugins-updated'),
(10455,	5429,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:5:\"3.5.1\";s:15:\"updated_version\";s:5:\"3.5.2\";}'),
(10456,	5430,	'iwp_log_type',	'scheduleBackup'),
(10457,	5430,	'iwp_log_action',	'schedule'),
(10458,	5430,	'iwp_log_activities_type',	'iwp_log'),
(10459,	5430,	'iwp_log_actions',	'backups'),
(10460,	5430,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10461,	5431,	'iwp_log_type',	'core'),
(10462,	5431,	'iwp_log_action',	'update'),
(10463,	5431,	'iwp_log_activities_type',	'automatic'),
(10464,	5431,	'iwp_log_actions',	'core-updated'),
(10465,	5431,	'iwp_log_details',	'a:2:{s:11:\"old_version\";s:5:\"5.3.2\";s:15:\"updated_version\";s:3:\"5.4\";}'),
(10466,	5432,	'iwp_log_type',	'scheduleBackup'),
(10467,	5432,	'iwp_log_action',	'schedule'),
(10468,	5432,	'iwp_log_activities_type',	'iwp_log'),
(10469,	5432,	'iwp_log_actions',	'backups'),
(10470,	5432,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10471,	5434,	'_edit_lock',	'1586272721:3'),
(10472,	5434,	'_edit_last',	'3'),
(10473,	5434,	'_title',	'Lakeland Nursing Home Abuse Lawyer'),
(10474,	5434,	'_description',	'If you suspect that your loved one is suffering from nursing home abuse, call our Lakeland nursing home abuse lawyers at the Pawlowski // Mastrilli Law Group.'),
(10475,	5434,	'_keywords',	'Lakeland Nursing Home Abuse Lawyer'),
(10476,	5434,	'_subslideID',	''),
(10478,	5437,	'_edit_lock',	'1586274332:3'),
(10479,	5437,	'_edit_last',	'3'),
(10480,	5437,	'_title',	'Lakeland Pharmaceutical Injury Lawyer'),
(10481,	5437,	'_description',	'If you suffered harm because of an error by a pharmacy practitioner, call our Lakeland pharmaceutical injury lawyers at the Pawlowski // Mastrilli Law Group.'),
(10482,	5437,	'_keywords',	'Lakeland Pharmaceutical Injury Lawyer'),
(10483,	5437,	'_subslideID',	''),
(10484,	5439,	'_edit_lock',	'1586274327:3'),
(10485,	5439,	'_edit_last',	'3'),
(10486,	5439,	'_title',	'Lakeland Premises Liability Lawyer'),
(10487,	5439,	'_description',	'If you were hurt in a slip and fall incident, call the Lakeland premises liability lawyers at the Pawlowski // Mastrilli Law Group today.'),
(10488,	5439,	'_keywords',	'Lakeland Premises Liability Lawyer'),
(10489,	5439,	'_subslideID',	''),
(10490,	5441,	'_edit_lock',	'1586274329:3'),
(10491,	5441,	'_edit_last',	'3'),
(10492,	5441,	'_title',	'Lakeland Workplace Accident Lawyer'),
(10493,	5441,	'_description',	'If you were hurt in a workplace accident, call our Lakeland workplace accident lawyers at the Pawlowski // Mastrilli Law Group today.'),
(10494,	5441,	'_keywords',	'Lakeland Workplace Accident Lawyer'),
(10495,	5441,	'_subslideID',	''),
(10496,	5443,	'_edit_lock',	'1586274366:3'),
(10497,	5443,	'_edit_last',	'3'),
(10498,	5443,	'_title',	'Lakeland Wrongful Death Lawyer'),
(10499,	5443,	'_description',	'If you lost a loved one due to a wrongful death accident, call the Lakeland wrongful death lawyers at the Pawlowski // Mastrilli Law Group.'),
(10500,	5443,	'_keywords',	'Lakeland Wrongful Death Lawyer'),
(10501,	5443,	'_subslideID',	''),
(10502,	5445,	'_edit_lock',	'1587059125:3'),
(10503,	5445,	'_edit_last',	'3'),
(10504,	5445,	'_title',	'Lakeland Car Accident Lawyer'),
(10505,	5445,	'_description',	'If you were hurt in an auto crash, call our Lakeland car accident lawyers at the Pawlowski // Mastrilli Law Group today.'),
(10506,	5445,	'_keywords',	'Lakeland Car Accident Lawyer'),
(10507,	5445,	'_subslideID',	''),
(10508,	5447,	'_edit_lock',	'1586271761:3'),
(10509,	5447,	'_edit_last',	'3'),
(10510,	5447,	'_title',	'Lakeland Auto Accident Lawyer'),
(10511,	5447,	'_description',	'If you or your loved one was hurt in a motor vehicle crash, call our Lakeland auto accident lawyers at the Pawlowski // Mastrilli Law Group today.'),
(10512,	5447,	'_keywords',	'Lakeland Auto Accident Lawyer'),
(10513,	5447,	'_subslideID',	''),
(10514,	5449,	'iwp_log_type',	'scheduleBackup'),
(10515,	5449,	'iwp_log_action',	'schedule'),
(10516,	5449,	'iwp_log_activities_type',	'iwp_log'),
(10517,	5449,	'iwp_log_actions',	'backups'),
(10518,	5449,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10519,	5450,	'iwp_log_type',	'scheduleBackup'),
(10520,	5450,	'iwp_log_action',	'schedule'),
(10521,	5450,	'iwp_log_activities_type',	'iwp_log'),
(10522,	5450,	'iwp_log_actions',	'backups'),
(10523,	5450,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10524,	5451,	'iwp_log_type',	'scheduleBackup'),
(10525,	5451,	'iwp_log_action',	'schedule'),
(10526,	5451,	'iwp_log_activities_type',	'iwp_log'),
(10527,	5451,	'iwp_log_actions',	'backups'),
(10528,	5451,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10529,	5453,	'_edit_lock',	'1586270997:3'),
(10530,	5453,	'_edit_last',	'3'),
(10531,	5453,	'_title',	'Tampa Insurance Liability Lawyer'),
(10532,	5453,	'_description',	'The Tampa insurance liability lawyers at Pawlowski // Mastrilli Law Group has experience handling both first and third party insurance claims.'),
(10533,	5453,	'_keywords',	'Tampa Insurance Liability Lawyer'),
(10534,	5453,	'_subslideID',	''),
(10535,	5455,	'_edit_lock',	'1586272535:3'),
(10536,	5455,	'_edit_last',	'3'),
(10537,	5455,	'_title',	'Oldsmar DUI Accident Lawyer'),
(10538,	5455,	'_description',	'If you were injured in a collision with a drunk driver, it is important to contact an experienced Oldsmar DUI accident lawyer at the Pawlowski // Mastrilli Law Group.'),
(10539,	5455,	'_keywords',	'Oldsmar DUI Accident Lawyer'),
(10540,	5455,	'_subslideID',	''),
(10541,	5457,	'_edit_lock',	'1586272392:3'),
(10542,	5457,	'_edit_last',	'3'),
(10543,	5457,	'_title',	'Oldsmar Hit & Run Accident Lawyer'),
(10544,	5457,	'_description',	'If you were injured in a hit and run accident, call the Oldsmar hit & run car accident lawyers at Pawlowski // Mastrilli Law Group today.'),
(10545,	5457,	'_keywords',	'Oldsmar Hit & Run Accident Lawyer'),
(10546,	5457,	'_subslideID',	''),
(10547,	5459,	'_edit_lock',	'1586272392:3'),
(10548,	5459,	'_edit_last',	'3'),
(10549,	5459,	'_title',	'Oldsmar Truck Accident Lawyer'),
(10550,	5459,	'_description',	'For help with your own truck accident claim, call one of the dedicated Oldsmar truck accident lawyers at Pawlowski // Mastrilli Law Group.'),
(10551,	5459,	'_keywords',	'Oldsmar Truck Accident Lawyer'),
(10552,	5459,	'_subslideID',	''),
(10553,	5461,	'_edit_lock',	'1586272418:3'),
(10554,	5461,	'_edit_last',	'3'),
(10555,	5461,	'_title',	'Oldsmar Uninsured Motorist Lawyer'),
(10556,	5461,	'_description',	'If you were recently injured in an accident that was caused by an uninsured driver, call the Oldsmar uninsured motorist lawyers.'),
(10557,	5461,	'_keywords',	'Oldsmar Uninsured Motorist Lawyer'),
(10558,	5461,	'_subslideID',	''),
(10559,	5463,	'_edit_lock',	'1586272647:3'),
(10560,	5463,	'_edit_last',	'3'),
(10561,	5463,	'_title',	'Oldsmar Family Lawyer'),
(10562,	5463,	'_description',	'For help with your family law matter, contact one of the experienced Oldsmar family lawyers at Pawlowski // Mastrilli Law Group today.'),
(10563,	5463,	'_keywords',	'Oldsmar Family Lawyer'),
(10564,	5463,	'_subslideID',	''),
(10565,	5465,	'_edit_lock',	'1586272658:3'),
(10566,	5465,	'_edit_last',	'3'),
(10567,	5465,	'_title',	'Oldsmar Hurricane Damage Lawyer'),
(10568,	5465,	'_description',	'If you need help with an insurer who has unfairly denied your hurricane damage claim, call our Oldsmar hurricane damage lawyers today.'),
(10569,	5465,	'_keywords',	'Oldsmar Hurricane Damage Lawyer'),
(10570,	5465,	'_subslideID',	''),
(10571,	5467,	'_edit_lock',	'1586272593:3'),
(10572,	5467,	'_edit_last',	'3'),
(10573,	5467,	'_title',	'Oldsmar Criminal Lawyer'),
(10574,	5467,	'_description',	'If you were recently accused of a crime, call the Oldsmar criminal lawyers at the Pawlowski // Mastrilli Law Group.'),
(10575,	5467,	'_keywords',	'Oldsmar Criminal Lawyer'),
(10576,	5467,	'_subslideID',	''),
(10577,	5470,	'iwp_log_type',	'scheduleBackup'),
(10578,	5470,	'iwp_log_action',	'schedule'),
(10579,	5470,	'iwp_log_activities_type',	'iwp_log'),
(10580,	5470,	'iwp_log_actions',	'backups'),
(10581,	5470,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10633,	5505,	'_menu_item_type',	'post_type'),
(10634,	5505,	'_menu_item_menu_item_parent',	'4431'),
(10635,	5505,	'_menu_item_object_id',	'5453'),
(10636,	5505,	'_menu_item_object',	'page'),
(10637,	5505,	'_menu_item_target',	''),
(10638,	5505,	'_menu_item_classes',	'a:1:{i:0;s:0:\"\";}'),
(10639,	5505,	'_menu_item_xfn',	''),
(10640,	5505,	'_menu_item_url',	''),
(10642,	5506,	'_edit_lock',	'1586296879:3'),
(10643,	5507,	'_wp_attached_file',	'2020/04/NTL-top-100-member-seal.png'),
(10644,	5507,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:4:\"file\";s:35:\"2020/04/NTL-top-100-member-seal.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10645,	5508,	'_wp_attached_file',	'2020/04/NTL-top-100-member-b.png'),
(10646,	5508,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:200;s:6:\"height\";i:108;s:4:\"file\";s:32:\"2020/04/NTL-top-100-member-b.png\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"NTL-top-100-member-b-150x108.png\";s:5:\"width\";i:150;s:6:\"height\";i:108;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:32:\"NTL-top-100-member-b-150x108.png\";s:5:\"width\";i:150;s:6:\"height\";i:108;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:32:\"NTL-top-100-member-b-150x108.png\";s:5:\"width\";i:150;s:6:\"height\";i:108;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10647,	5506,	'_edit_last',	'3'),
(10648,	5509,	'_wp_attached_file',	'2020/04/NTL-top-100-member-seal-1.png'),
(10649,	5509,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:75;s:6:\"height\";i:75;s:4:\"file\";s:37:\"2020/04/NTL-top-100-member-seal-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10650,	5510,	'_wp_attached_file',	'2020/04/download-3.jpeg'),
(10651,	5510,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:23:\"2020/04/download-3.jpeg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"download-3-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:23:\"download-3-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:23:\"download-3-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10652,	5506,	'_thumbnail_id',	'5510'),
(10656,	5506,	'_title',	'Vince Pawlowski recognized with the National Trial Lawyers Top 10” list for 2020'),
(10657,	5506,	'_description',	''),
(10658,	5506,	'_keywords',	''),
(10659,	5506,	'_subslideID',	''),
(10669,	5506,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:70:\"https://www.megajustice.com/wp-content/uploads/2020/04/download-3.jpeg\";s:5:\"title\";s:12:\"download (3)\";s:7:\"caption\";s:0:\"\";}'),
(10672,	5516,	'iwp_log_type',	'scheduleBackup'),
(10673,	5516,	'iwp_log_action',	'schedule'),
(10674,	5516,	'iwp_log_activities_type',	'iwp_log'),
(10675,	5516,	'iwp_log_actions',	'backups'),
(10676,	5516,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10677,	5517,	'iwp_log_type',	'plugins'),
(10678,	5517,	'iwp_log_action',	'update'),
(10679,	5517,	'iwp_log_activities_type',	'automatic'),
(10680,	5517,	'iwp_log_actions',	'plugins-updated'),
(10681,	5517,	'iwp_log_details',	'a:4:{s:4:\"name\";s:20:\"Simple Page Ordering\";s:4:\"slug\";s:45:\"simple-page-ordering/simple-page-ordering.php\";s:11:\"old_version\";s:5:\"2.3.3\";s:15:\"updated_version\";s:5:\"2.3.4\";}'),
(10686,	5521,	'_wp_attached_file',	'2020/04/national-trial-lawyers-top-100.jpg'),
(10687,	5521,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:42:\"2020/04/national-trial-lawyers-top-100.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:42:\"national-trial-lawyers-top-100-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:42:\"national-trial-lawyers-top-100-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:42:\"national-trial-lawyers-top-100-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10690,	5523,	'iwp_log_type',	'scheduleBackup'),
(10691,	5523,	'iwp_log_action',	'schedule'),
(10692,	5523,	'iwp_log_activities_type',	'iwp_log'),
(10693,	5523,	'iwp_log_actions',	'backups'),
(10694,	5523,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10695,	5524,	'iwp_log_type',	'scheduleBackup'),
(10696,	5524,	'iwp_log_action',	'schedule'),
(10697,	5524,	'iwp_log_activities_type',	'iwp_log'),
(10698,	5524,	'iwp_log_actions',	'backups'),
(10699,	5524,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10700,	5528,	'iwp_log_type',	'scheduleBackup'),
(10701,	5528,	'iwp_log_action',	'schedule'),
(10702,	5528,	'iwp_log_activities_type',	'iwp_log'),
(10703,	5528,	'iwp_log_actions',	'backups'),
(10704,	5528,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10705,	5529,	'iwp_log_type',	'scheduleBackup'),
(10706,	5529,	'iwp_log_action',	'schedule'),
(10707,	5529,	'iwp_log_activities_type',	'iwp_log'),
(10708,	5529,	'iwp_log_actions',	'backups'),
(10709,	5529,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10710,	5530,	'iwp_log_type',	'scheduleBackup'),
(10711,	5530,	'iwp_log_action',	'schedule'),
(10712,	5530,	'iwp_log_activities_type',	'iwp_log'),
(10713,	5530,	'iwp_log_actions',	'backups'),
(10714,	5530,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10715,	5531,	'_edit_lock',	'1586792016:3'),
(10716,	5531,	'_edit_last',	'3'),
(10717,	5532,	'_wp_attached_file',	'2020/04/CarAcc13.jpg'),
(10718,	5532,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:445;s:6:\"height\";i:300;s:4:\"file\";s:20:\"2020/04/CarAcc13.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"CarAcc13-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"CarAcc13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"CarAcc13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"CarAcc13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"CarAcc13-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10719,	5531,	'_thumbnail_id',	'5532'),
(10720,	5531,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:67:\"https://www.megajustice.com/wp-content/uploads/2020/04/CarAcc13.jpg\";s:5:\"title\";s:8:\"CarAcc13\";s:7:\"caption\";s:0:\"\";}'),
(10723,	5531,	'_title',	'Recovering Lost Wages When You Are Hurt In A Florida Car Crash'),
(10724,	5531,	'_description',	'The skilled Tampa personal injury attorneys at The Pawlowski//Mastrilli Law Group regularly represents people seriously hurt in auto accidents.'),
(10725,	5531,	'_keywords',	''),
(10726,	5531,	'_subslideID',	''),
(10727,	5534,	'_edit_lock',	'1593109883:3'),
(10728,	5534,	'_edit_last',	'3'),
(10729,	5534,	'_title',	'Know Your Rights If You Are Hurt In A Florida Boating Accident'),
(10730,	5534,	'_description',	'We urge you to contact our office today so we can begin working on getting you and your family the compensation you deserve.'),
(10731,	5534,	'_keywords',	''),
(10732,	5534,	'_subslideID',	''),
(10733,	5536,	'_edit_lock',	'1594319517:3'),
(10734,	5536,	'_edit_last',	'3'),
(10735,	5536,	'_title',	'Why Insurance Companies Deny Florida Accident Claims'),
(10736,	5536,	'_description',	'The Tampa car accident attorneys at The Pawlowski//Mastrilli Law Group represent Floridians who have been seriously injured in auto accidents.'),
(10737,	5536,	'_keywords',	''),
(10738,	5536,	'_subslideID',	''),
(10739,	5539,	'iwp_log_type',	'scheduleBackup'),
(10740,	5539,	'iwp_log_action',	'schedule'),
(10741,	5539,	'iwp_log_activities_type',	'iwp_log'),
(10742,	5539,	'iwp_log_actions',	'backups'),
(10743,	5539,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10744,	5540,	'iwp_log_type',	'scheduleBackup'),
(10745,	5540,	'iwp_log_action',	'schedule'),
(10746,	5540,	'iwp_log_activities_type',	'iwp_log'),
(10747,	5540,	'iwp_log_actions',	'backups'),
(10748,	5540,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10749,	5542,	'_edit_lock',	'1587058843:3'),
(10750,	5542,	'_edit_last',	'3'),
(10751,	5542,	'_title',	'Lakeland DUI Accident Lawyer'),
(10752,	5542,	'_description',	'If you are charged with a DUI that caused an accident, contact a Lakeland DUI accident lawyer at The Pawlowski // Mastrilli Law Group right away.'),
(10753,	5542,	'_keywords',	'Lakeland DUI Accident Lawyer'),
(10754,	5542,	'_subslideID',	''),
(10755,	5544,	'_edit_lock',	'1587058956:3'),
(10756,	5544,	'_edit_last',	'3'),
(10757,	5544,	'_title',	'Lakeland Hit & Run Lawyer'),
(10758,	5544,	'_description',	'If seeking compensation for your losses after a hit & run collision, call the Lakeland hit & run lawyers at The Pawlowski // Mastrilli Law Group.'),
(10759,	5544,	'_keywords',	'Lakeland Hit & Run Lawyer'),
(10760,	5544,	'_subslideID',	''),
(10761,	5546,	'_edit_lock',	'1587058845:3'),
(10762,	5546,	'_edit_last',	'3'),
(10763,	5546,	'_title',	'Lakeland Truck Accident Lawyer'),
(10764,	5546,	'_description',	'If you were hurt or lost a loved one in a truck accident, call the Lakeland truck accident lawyers at The Pawlowski // Mastrilli Law Group.'),
(10765,	5546,	'_keywords',	'Lakeland Truck Accident Lawyer'),
(10766,	5546,	'_subslideID',	''),
(10767,	5548,	'_edit_lock',	'1587058849:3'),
(10768,	5548,	'_edit_last',	'3'),
(10769,	5548,	'_title',	'Lakeland Uninsured Motorist Lawyer'),
(10770,	5548,	'_description',	'If you were hurt by an uninsured driver, call a Lakeland uninsured motorist lawyer at The Pawlowski // Mastrilli Law Group.'),
(10771,	5548,	'_keywords',	'Lakeland Uninsured Motorist Lawyer'),
(10772,	5548,	'_subslideID',	''),
(10773,	5550,	'_edit_lock',	'1587058979:3'),
(10774,	5550,	'_edit_last',	'3'),
(10775,	5550,	'_title',	'Lakeland Family Lawyer '),
(10776,	5550,	'_description',	'At the Pawlowski // Mastrilli Law Group, our Lakeland family lawyers have extensive experience representing clients in all types of family law cases.'),
(10777,	5550,	'_keywords',	'Lakeland Family Lawyer '),
(10778,	5550,	'_subslideID',	''),
(10779,	5552,	'_edit_lock',	'1587058982:3'),
(10780,	5552,	'_edit_last',	'3'),
(10781,	5552,	'_title',	'Lakeland Hurricane Damage Lawyer'),
(10782,	5552,	'_description',	'Our Lakeland hurricane damage lawyers at the Pawlowski // Mastrilli Law Group have extensive experience pursuing misconduct by insurers and protecting the rights of policyholder.'),
(10783,	5552,	'_keywords',	'Lakeland Hurricane Damage Lawyer'),
(10784,	5552,	'_subslideID',	''),
(10785,	5554,	'_edit_lock',	'1587058978:3'),
(10786,	5554,	'_edit_last',	'3'),
(10787,	5554,	'_title',	'Lakeland Criminal Lawyer'),
(10788,	5554,	'_description',	'Our Lakeland criminal defense lawyers at the Pawlowski // Mastrilli Law Group are experienced in all defense strategies.'),
(10789,	5554,	'_keywords',	'Lakeland Criminal Lawyer'),
(10790,	5554,	'_subslideID',	''),
(10791,	5556,	'iwp_log_type',	'scheduleBackup'),
(10792,	5556,	'iwp_log_action',	'schedule'),
(10793,	5556,	'iwp_log_activities_type',	'iwp_log'),
(10794,	5556,	'iwp_log_actions',	'backups'),
(10795,	5556,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10823,	5565,	'iwp_log_type',	'scheduleBackup'),
(10824,	5565,	'iwp_log_action',	'schedule'),
(10825,	5565,	'iwp_log_activities_type',	'iwp_log'),
(10826,	5565,	'iwp_log_actions',	'backups'),
(10827,	5565,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10828,	5566,	'iwp_log_type',	'scheduleBackup'),
(10829,	5566,	'iwp_log_action',	'schedule'),
(10830,	5566,	'iwp_log_activities_type',	'iwp_log'),
(10831,	5566,	'iwp_log_actions',	'backups'),
(10832,	5566,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10833,	5567,	'iwp_log_type',	'scheduleBackup'),
(10834,	5567,	'iwp_log_action',	'schedule'),
(10835,	5567,	'iwp_log_activities_type',	'iwp_log'),
(10836,	5567,	'iwp_log_actions',	'backups'),
(10837,	5567,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10838,	5568,	'iwp_log_type',	'scheduleBackup'),
(10839,	5568,	'iwp_log_action',	'schedule'),
(10840,	5568,	'iwp_log_activities_type',	'iwp_log'),
(10841,	5568,	'iwp_log_actions',	'backups'),
(10842,	5568,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10843,	5569,	'iwp_log_type',	'scheduleBackup'),
(10844,	5569,	'iwp_log_action',	'schedule'),
(10845,	5569,	'iwp_log_activities_type',	'iwp_log'),
(10846,	5569,	'iwp_log_actions',	'backups'),
(10847,	5569,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10848,	5570,	'iwp_log_type',	'plugins'),
(10849,	5570,	'iwp_log_action',	'update'),
(10850,	5570,	'iwp_log_activities_type',	'automatic'),
(10851,	5570,	'iwp_log_actions',	'plugins-updated'),
(10852,	5570,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:5:\"3.5.2\";s:15:\"updated_version\";s:5:\"3.5.3\";}'),
(10853,	5571,	'iwp_log_type',	'scheduleBackup'),
(10854,	5571,	'iwp_log_action',	'schedule'),
(10855,	5571,	'iwp_log_activities_type',	'iwp_log'),
(10856,	5571,	'iwp_log_actions',	'backups'),
(10857,	5571,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10858,	5572,	'_edit_lock',	'1587571283:3'),
(10859,	5572,	'_edit_last',	'3'),
(10860,	5573,	'_wp_attached_file',	'2020/04/Pedest7.jpg'),
(10861,	5573,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:439;s:6:\"height\";i:300;s:4:\"file\";s:19:\"2020/04/Pedest7.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"Pedest7-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Pedest7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"Pedest7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"Pedest7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"Pedest7-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10862,	5572,	'_thumbnail_id',	'5573'),
(10863,	5572,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:66:\"https://www.megajustice.com/wp-content/uploads/2020/04/Pedest7.jpg\";s:5:\"title\";s:7:\"Pedest7\";s:7:\"caption\";s:0:\"\";}'),
(10866,	5572,	'_title',	'Injured Pedestrians In Florida Can Recover Damages Even If They Share Fault'),
(10867,	5572,	'_description',	'The Pawlowski//Mastrilli Law Group vigorously represents injured pedestrians in the greater Tampa, Clearwater, Lakeland and St. Petersburg areas.'),
(10868,	5572,	'_keywords',	''),
(10869,	5572,	'_subslideID',	''),
(10870,	5575,	'_edit_lock',	'1587572005:3'),
(10871,	5575,	'_edit_last',	'3'),
(10872,	5575,	'_title',	'Frontline Workers In Florida Eligible For Covid-19 Workers Comp Benefits'),
(10873,	5575,	'_description',	'The dedicated Tampa workers’ compensation attorneys at Pawlowski//Mastrilli Law Group remain eager and available to serve clients during the COVID-19 crisis.'),
(10874,	5575,	'_keywords',	''),
(10875,	5575,	'_subslideID',	''),
(10876,	5577,	'_wp_attached_file',	'2020/04/EMS.jpg'),
(10877,	5577,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:424;s:6:\"height\";i:330;s:4:\"file\";s:15:\"2020/04/EMS.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"EMS-300x233.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:233;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"EMS-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:15:\"EMS-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:15:\"EMS-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:15:\"EMS-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10878,	5575,	'_thumbnail_id',	'5577'),
(10879,	5578,	'_edit_lock',	'1633392661:1'),
(10880,	5578,	'_edit_last',	'1'),
(10881,	5579,	'_wp_attached_file',	'2020/04/NursingHomeMask.jpg'),
(10882,	5579,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:464;s:6:\"height\";i:300;s:4:\"file\";s:27:\"2020/04/NursingHomeMask.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"NursingHomeMask-300x194.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:194;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"NursingHomeMask-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:27:\"NursingHomeMask-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:27:\"NursingHomeMask-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:27:\"NursingHomeMask-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10883,	5578,	'_thumbnail_id',	'5579'),
(10884,	5578,	'_title',	'In The Face Of Coronavirus, Nursing Home Safety Is More Important Than Ever'),
(10885,	5578,	'_description',	'The dedicated Tampa nursing home abuse attorneys at Pawlowski//Mastrilli Law Group remain available to serve clients during the COVID-19 crisis.'),
(10886,	5578,	'_keywords',	''),
(10887,	5578,	'_subslideID',	''),
(10888,	5581,	'_edit_lock',	'1587572356:3'),
(10889,	5581,	'_edit_last',	'3'),
(10890,	5582,	'_wp_attached_file',	'2020/04/Motorcyclist4.jpg'),
(10891,	5582,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:454;s:6:\"height\";i:300;s:4:\"file\";s:25:\"2020/04/Motorcyclist4.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"Motorcyclist4-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"Motorcyclist4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:25:\"Motorcyclist4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:25:\"Motorcyclist4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:25:\"Motorcyclist4-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10892,	5581,	'_thumbnail_id',	'5582'),
(10893,	5581,	'_title',	'Motorcycle Accidents Produce Devastating Injuries To Florida Bikers'),
(10894,	5581,	'_description',	'If you have any questions about your legal rights arising from a crash, we invite you to contact the Tampa motorcycle accident lawyers at Pawlowski//Mastrilli Law Group.'),
(10895,	5581,	'_keywords',	''),
(10896,	5581,	'_subslideID',	''),
(10897,	5584,	'_edit_lock',	'1587573863:3'),
(10898,	5584,	'_edit_last',	'3'),
(10899,	5584,	'_title',	'It’s Not A Good Idea To Give A Statement To An Insurance Company After A Crash'),
(10900,	5584,	'_description',	'At the Pawlowski//Mastrilli Law Group, we work with your best interests in mind and won’t let an insurance company get an unfair advantage because they wish to get information from you.'),
(10901,	5584,	'_keywords',	''),
(10902,	5584,	'_subslideID',	''),
(10903,	5586,	'_wp_attached_file',	'2020/04/InsuranceAdj.jpg'),
(10904,	5586,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:235;s:6:\"height\";i:259;s:4:\"file\";s:24:\"2020/04/InsuranceAdj.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"InsuranceAdj-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"InsuranceAdj-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"InsuranceAdj-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"InsuranceAdj-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10905,	5584,	'_thumbnail_id',	'5586'),
(10906,	5587,	'_edit_lock',	'1587574079:3'),
(10907,	5587,	'_edit_last',	'3'),
(10908,	5588,	'_wp_attached_file',	'2020/04/WrongfulDeath3.jpg'),
(10909,	5588,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:473;s:6:\"height\";i:318;s:4:\"file\";s:26:\"2020/04/WrongfulDeath3.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"WrongfulDeath3-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"WrongfulDeath3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"WrongfulDeath3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:26:\"WrongfulDeath3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:26:\"WrongfulDeath3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(10910,	5587,	'_thumbnail_id',	'5588'),
(10911,	5587,	'_title',	'Broward Judge’s Biased Remarks Disqualify Him From Wrongful Death Case, Appeals Court Rules'),
(10912,	5587,	'_description',	'At The Pawlowski//Mastrilli Law Group, our experienced Tampa wrongful death attorneys have helped many families obtain compensation after the preventable death of a loved one in traffic accidents.'),
(10913,	5587,	'_keywords',	''),
(10914,	5587,	'_subslideID',	''),
(10915,	5590,	'iwp_log_type',	'scheduleBackup'),
(10916,	5590,	'iwp_log_action',	'schedule'),
(10917,	5590,	'iwp_log_activities_type',	'iwp_log'),
(10918,	5590,	'iwp_log_actions',	'backups'),
(10919,	5590,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10920,	5575,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:62:\"https://www.megajustice.com/wp-content/uploads/2020/04/EMS.jpg\";s:5:\"title\";s:3:\"EMS\";s:7:\"caption\";s:0:\"\";}'),
(10968,	5599,	'iwp_log_type',	'scheduleBackup'),
(10969,	5599,	'iwp_log_action',	'schedule'),
(10970,	5599,	'iwp_log_activities_type',	'iwp_log'),
(10971,	5599,	'iwp_log_actions',	'backups'),
(10972,	5599,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10976,	5600,	'iwp_log_type',	'plugins'),
(10977,	5600,	'iwp_log_action',	'update'),
(10978,	5600,	'iwp_log_activities_type',	'automatic'),
(10979,	5600,	'iwp_log_actions',	'plugins-updated'),
(10980,	5600,	'iwp_log_details',	'a:4:{s:4:\"name\";s:18:\"Wordfence Security\";s:4:\"slug\";s:23:\"wordfence/wordfence.php\";s:11:\"old_version\";s:5:\"7.4.6\";s:15:\"updated_version\";s:5:\"7.4.7\";}'),
(10981,	5601,	'iwp_log_type',	'plugins'),
(10982,	5601,	'iwp_log_action',	'update'),
(10983,	5601,	'iwp_log_activities_type',	'automatic'),
(10984,	5601,	'iwp_log_actions',	'plugins-updated'),
(10985,	5601,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:5:\"3.5.3\";s:15:\"updated_version\";s:5:\"3.5.4\";}'),
(10986,	5602,	'iwp_log_type',	'scheduleBackup'),
(10987,	5602,	'iwp_log_action',	'schedule'),
(10988,	5602,	'iwp_log_activities_type',	'iwp_log'),
(10989,	5602,	'iwp_log_actions',	'backups'),
(10990,	5602,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10991,	5603,	'iwp_log_type',	'scheduleBackup'),
(10992,	5603,	'iwp_log_action',	'schedule'),
(10993,	5603,	'iwp_log_activities_type',	'iwp_log'),
(10994,	5603,	'iwp_log_actions',	'backups'),
(10995,	5603,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(10996,	5604,	'iwp_log_type',	'scheduleBackup'),
(10997,	5604,	'iwp_log_action',	'schedule'),
(10998,	5604,	'iwp_log_activities_type',	'iwp_log'),
(10999,	5604,	'iwp_log_actions',	'backups'),
(11000,	5604,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11001,	5581,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:72:\"https://www.megajustice.com/wp-content/uploads/2020/04/Motorcyclist4.jpg\";s:5:\"title\";s:13:\"Motorcyclist4\";s:7:\"caption\";s:0:\"\";}'),
(11004,	5605,	'iwp_log_type',	'scheduleBackup'),
(11005,	5605,	'iwp_log_action',	'schedule'),
(11006,	5605,	'iwp_log_activities_type',	'iwp_log'),
(11007,	5605,	'iwp_log_actions',	'backups'),
(11008,	5605,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11009,	5607,	'iwp_log_type',	'scheduleBackup'),
(11010,	5607,	'iwp_log_action',	'schedule'),
(11011,	5607,	'iwp_log_activities_type',	'iwp_log'),
(11012,	5607,	'iwp_log_actions',	'backups'),
(11013,	5607,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11014,	5584,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:71:\"https://www.megajustice.com/wp-content/uploads/2020/04/InsuranceAdj.jpg\";s:5:\"title\";s:12:\"InsuranceAdj\";s:7:\"caption\";s:0:\"\";}'),
(11017,	5610,	'iwp_log_type',	'scheduleBackup'),
(11018,	5610,	'iwp_log_action',	'schedule'),
(11019,	5610,	'iwp_log_activities_type',	'iwp_log'),
(11020,	5610,	'iwp_log_actions',	'backups'),
(11021,	5610,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11022,	5613,	'iwp_log_type',	'scheduleBackup'),
(11023,	5613,	'iwp_log_action',	'schedule'),
(11024,	5613,	'iwp_log_activities_type',	'iwp_log'),
(11025,	5613,	'iwp_log_actions',	'backups'),
(11026,	5613,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11027,	5587,	'_xmlsf_image_featured',	'a:3:{s:3:\"loc\";s:73:\"https://www.megajustice.com/wp-content/uploads/2020/04/WrongfulDeath3.jpg\";s:5:\"title\";s:14:\"WrongfulDeath3\";s:7:\"caption\";s:0:\"\";}'),
(11030,	5614,	'iwp_log_type',	'core'),
(11031,	5614,	'iwp_log_action',	'update'),
(11032,	5614,	'iwp_log_activities_type',	'automatic'),
(11033,	5614,	'iwp_log_actions',	'core-updated'),
(11034,	5614,	'iwp_log_details',	'a:2:{s:11:\"old_version\";s:3:\"5.4\";s:15:\"updated_version\";s:5:\"5.4.1\";}'),
(11035,	5615,	'iwp_log_type',	'scheduleBackup'),
(11036,	5615,	'iwp_log_action',	'schedule'),
(11037,	5615,	'iwp_log_activities_type',	'iwp_log'),
(11038,	5615,	'iwp_log_actions',	'backups'),
(11039,	5615,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11040,	5616,	'iwp_log_type',	'scheduleBackup'),
(11041,	5616,	'iwp_log_action',	'schedule'),
(11042,	5616,	'iwp_log_activities_type',	'iwp_log'),
(11043,	5616,	'iwp_log_actions',	'backups'),
(11044,	5616,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11045,	5618,	'iwp_log_type',	'scheduleBackup'),
(11046,	5618,	'iwp_log_action',	'schedule'),
(11047,	5618,	'iwp_log_activities_type',	'iwp_log'),
(11048,	5618,	'iwp_log_actions',	'backups'),
(11049,	5618,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11050,	5620,	'iwp_log_type',	'scheduleBackup'),
(11051,	5620,	'iwp_log_action',	'schedule'),
(11052,	5620,	'iwp_log_activities_type',	'iwp_log'),
(11053,	5620,	'iwp_log_actions',	'backups'),
(11054,	5620,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11055,	5621,	'iwp_log_type',	'scheduleBackup'),
(11056,	5621,	'iwp_log_action',	'schedule'),
(11057,	5621,	'iwp_log_activities_type',	'iwp_log'),
(11058,	5621,	'iwp_log_actions',	'backups'),
(11059,	5621,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11060,	5622,	'iwp_log_type',	'scheduleBackup'),
(11061,	5622,	'iwp_log_action',	'schedule'),
(11062,	5622,	'iwp_log_activities_type',	'iwp_log'),
(11063,	5622,	'iwp_log_actions',	'backups'),
(11064,	5622,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11065,	5624,	'iwp_log_type',	'scheduleBackup'),
(11066,	5624,	'iwp_log_action',	'schedule'),
(11067,	5624,	'iwp_log_activities_type',	'iwp_log'),
(11068,	5624,	'iwp_log_actions',	'backups'),
(11069,	5624,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11070,	5627,	'iwp_log_type',	'scheduleBackup'),
(11071,	5627,	'iwp_log_action',	'schedule'),
(11072,	5627,	'iwp_log_activities_type',	'iwp_log'),
(11073,	5627,	'iwp_log_actions',	'backups'),
(11074,	5627,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11075,	5628,	'iwp_log_type',	'scheduleBackup'),
(11076,	5628,	'iwp_log_action',	'schedule'),
(11077,	5628,	'iwp_log_activities_type',	'iwp_log'),
(11078,	5628,	'iwp_log_actions',	'backups'),
(11079,	5628,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11080,	5629,	'iwp_log_type',	'scheduleBackup'),
(11081,	5629,	'iwp_log_action',	'schedule'),
(11082,	5629,	'iwp_log_activities_type',	'iwp_log'),
(11083,	5629,	'iwp_log_actions',	'backups'),
(11084,	5629,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11085,	5630,	'iwp_log_type',	'scheduleBackup'),
(11086,	5630,	'iwp_log_action',	'schedule'),
(11087,	5630,	'iwp_log_activities_type',	'iwp_log'),
(11088,	5630,	'iwp_log_actions',	'backups'),
(11089,	5630,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11090,	5631,	'iwp_log_type',	'scheduleBackup'),
(11091,	5631,	'iwp_log_action',	'schedule'),
(11092,	5631,	'iwp_log_activities_type',	'iwp_log'),
(11093,	5631,	'iwp_log_actions',	'backups'),
(11094,	5631,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11095,	5633,	'_edit_lock',	'1633450313:1'),
(11096,	5633,	'_edit_last',	'1'),
(11097,	5634,	'_wp_attached_file',	'2020/05/CarAcc11.jpg'),
(11098,	5634,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:400;s:6:\"height\";i:407;s:4:\"file\";s:20:\"2020/05/CarAcc11.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"CarAcc11-295x300.jpg\";s:5:\"width\";i:295;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"CarAcc11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"CarAcc11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"CarAcc11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"CarAcc11-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(11099,	5633,	'_thumbnail_id',	'5634'),
(11103,	5633,	'_title',	'Understanding Rear-End Car Accidents'),
(11104,	5633,	'_description',	'The Tampa car accident lawyers at the Pawlowski//Mastrilli Law Group have 25 years of experience helping Florida residents who have been injured in car accidents.'),
(11105,	5633,	'_keywords',	''),
(11106,	5633,	'_subslideID',	''),
(11107,	5636,	'_edit_lock',	'1633450312:1'),
(11108,	5636,	'_edit_last',	'1'),
(11109,	5637,	'_wp_attached_file',	'2020/05/MedMal3.jpg'),
(11110,	5637,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:480;s:6:\"height\";i:319;s:4:\"file\";s:19:\"2020/05/MedMal3.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"MedMal3-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"MedMal3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"MedMal3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"MedMal3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"MedMal3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(11111,	5636,	'_thumbnail_id',	'5637'),
(11112,	5636,	'_title',	'Common Causes Of Medical Malpractice'),
(11113,	5636,	'_description',	'The Tampa medical malpractice attorneys at the Pawlowski//Mastrilli Law Group have 25 years of experience with medical malpractice and other injury cases.'),
(11114,	5636,	'_keywords',	''),
(11115,	5636,	'_subslideID',	''),
(11116,	5639,	'iwp_log_type',	'scheduleBackup'),
(11117,	5639,	'iwp_log_action',	'schedule'),
(11118,	5639,	'iwp_log_activities_type',	'iwp_log'),
(11119,	5639,	'iwp_log_actions',	'backups'),
(11120,	5639,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11122,	5642,	'iwp_log_type',	'scheduleBackup'),
(11123,	5642,	'iwp_log_action',	'schedule'),
(11124,	5642,	'iwp_log_activities_type',	'iwp_log'),
(11125,	5642,	'iwp_log_actions',	'backups'),
(11126,	5642,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11127,	5644,	'iwp_log_type',	'scheduleBackup'),
(11128,	5644,	'iwp_log_action',	'schedule'),
(11129,	5644,	'iwp_log_activities_type',	'iwp_log'),
(11130,	5644,	'iwp_log_actions',	'backups'),
(11131,	5644,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11132,	5645,	'iwp_log_type',	'plugins'),
(11133,	5645,	'iwp_log_action',	'update'),
(11134,	5645,	'iwp_log_activities_type',	'automatic'),
(11135,	5645,	'iwp_log_actions',	'plugins-updated'),
(11136,	5645,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:5:\"3.5.4\";s:15:\"updated_version\";s:7:\"3.5.5.1\";}'),
(11137,	5647,	'iwp_log_type',	'scheduleBackup'),
(11138,	5647,	'iwp_log_action',	'schedule'),
(11139,	5647,	'iwp_log_activities_type',	'iwp_log'),
(11140,	5647,	'iwp_log_actions',	'backups'),
(11141,	5647,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11142,	5648,	'iwp_log_type',	'scheduleBackup'),
(11143,	5648,	'iwp_log_action',	'schedule'),
(11144,	5648,	'iwp_log_activities_type',	'iwp_log'),
(11145,	5648,	'iwp_log_actions',	'backups'),
(11146,	5648,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11147,	5649,	'iwp_log_type',	'scheduleBackup'),
(11148,	5649,	'iwp_log_action',	'schedule'),
(11149,	5649,	'iwp_log_activities_type',	'iwp_log'),
(11150,	5649,	'iwp_log_actions',	'backups'),
(11151,	5649,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11152,	5651,	'iwp_log_type',	'scheduleBackup'),
(11153,	5651,	'iwp_log_action',	'schedule'),
(11154,	5651,	'iwp_log_activities_type',	'iwp_log'),
(11155,	5651,	'iwp_log_actions',	'backups'),
(11156,	5651,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11157,	5653,	'iwp_log_type',	'scheduleBackup'),
(11158,	5653,	'iwp_log_action',	'schedule'),
(11159,	5653,	'iwp_log_activities_type',	'iwp_log'),
(11160,	5653,	'iwp_log_actions',	'backups'),
(11161,	5653,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11162,	5655,	'iwp_log_type',	'scheduleBackup'),
(11163,	5655,	'iwp_log_action',	'schedule'),
(11164,	5655,	'iwp_log_activities_type',	'iwp_log'),
(11165,	5655,	'iwp_log_actions',	'backups'),
(11166,	5655,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11167,	5656,	'iwp_log_type',	'scheduleBackup'),
(11168,	5656,	'iwp_log_action',	'schedule'),
(11169,	5656,	'iwp_log_activities_type',	'iwp_log'),
(11170,	5656,	'iwp_log_actions',	'backups'),
(11171,	5656,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11172,	5657,	'iwp_log_type',	'scheduleBackup'),
(11173,	5657,	'iwp_log_action',	'schedule'),
(11174,	5657,	'iwp_log_activities_type',	'iwp_log'),
(11175,	5657,	'iwp_log_actions',	'backups'),
(11176,	5657,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11177,	5659,	'iwp_log_type',	'scheduleBackup'),
(11178,	5659,	'iwp_log_action',	'schedule'),
(11179,	5659,	'iwp_log_activities_type',	'iwp_log'),
(11180,	5659,	'iwp_log_actions',	'backups'),
(11181,	5659,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11182,	5660,	'iwp_log_type',	'scheduleBackup'),
(11183,	5660,	'iwp_log_action',	'schedule'),
(11184,	5660,	'iwp_log_activities_type',	'iwp_log'),
(11185,	5660,	'iwp_log_actions',	'backups'),
(11186,	5660,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11187,	5662,	'iwp_log_type',	'scheduleBackup'),
(11188,	5662,	'iwp_log_action',	'schedule'),
(11189,	5662,	'iwp_log_activities_type',	'iwp_log'),
(11190,	5662,	'iwp_log_actions',	'backups'),
(11191,	5662,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11192,	5664,	'_edit_lock',	'1633450175:1'),
(11193,	5664,	'_edit_last',	'1'),
(11194,	5665,	'_wp_attached_file',	'2020/05/NursingHome2.jpg'),
(11195,	5665,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:494;s:6:\"height\";i:300;s:4:\"file\";s:24:\"2020/05/NursingHome2.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"NursingHome2-300x182.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"NursingHome2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:24:\"NursingHome2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:24:\"NursingHome2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:24:\"NursingHome2-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(11196,	5664,	'_thumbnail_id',	'5665'),
(11200,	5664,	'_title',	'Signs Of Nursing Home Abuse And Neglect'),
(11201,	5664,	'_description',	'The Tampa nursing home abuse attorneys at the Pawlowski//Mastrilli Law Group can help you with your nursing home case.'),
(11202,	5664,	'_keywords',	''),
(11203,	5664,	'_subslideID',	''),
(11204,	5667,	'_edit_lock',	'1633450174:1'),
(11205,	5667,	'_edit_last',	'1'),
(11206,	5668,	'_wp_attached_file',	'2020/05/BadFaith.jpg'),
(11207,	5668,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:400;s:6:\"height\";i:383;s:4:\"file\";s:20:\"2020/05/BadFaith.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"BadFaith-300x287.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:287;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"BadFaith-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:20:\"BadFaith-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:20:\"BadFaith-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:20:\"BadFaith-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(11208,	5667,	'_thumbnail_id',	'5668'),
(11209,	5667,	'_title',	'What Is Bad Faith By An Insurance Company?'),
(11210,	5667,	'_description',	'The Tampa insurance bad faith lawyers at the Pawlowski//Mastrilli Law Group can help you with your accident claim.'),
(11211,	5667,	'_keywords',	''),
(11212,	5667,	'_subslideID',	''),
(11213,	5670,	'_edit_lock',	'1633450173:1'),
(11214,	5670,	'_edit_last',	'1'),
(11215,	5670,	'_title',	'Possible Premises Liability Claims Due To COVID-19'),
(11216,	5670,	'_description',	'Contact the Tampa premises liability attorneys at the Pawlowski//Mastrilli Law Group for help with your premises liability claim.'),
(11217,	5670,	'_keywords',	''),
(11218,	5670,	'_subslideID',	''),
(11219,	5672,	'_edit_lock',	'1633450173:1'),
(11220,	5672,	'_edit_last',	'1'),
(11221,	5672,	'_title',	'What Is Distracted Driving?'),
(11222,	5672,	'_description',	'The Tampa car accident lawyers at the Pawlowski//Mastrilli Law Group can help you with your case.'),
(11223,	5672,	'_keywords',	''),
(11224,	5672,	'_subslideID',	''),
(11225,	5674,	'iwp_log_type',	'scheduleBackup'),
(11226,	5674,	'iwp_log_action',	'schedule'),
(11227,	5674,	'iwp_log_activities_type',	'iwp_log'),
(11228,	5674,	'iwp_log_actions',	'backups'),
(11229,	5674,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11233,	5667,	'_wp_old_date',	'2020-05-27'),
(11234,	5675,	'iwp_log_type',	'scheduleBackup'),
(11235,	5675,	'iwp_log_action',	'schedule'),
(11236,	5675,	'iwp_log_activities_type',	'iwp_log'),
(11237,	5675,	'iwp_log_actions',	'backups'),
(11238,	5675,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11239,	5677,	'_wp_attached_file',	'2020/05/Liability3.jpg'),
(11240,	5677,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:485;s:6:\"height\";i:364;s:4:\"file\";s:22:\"2020/05/Liability3.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"Liability3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"Liability3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"Liability3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"Liability3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"Liability3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(11241,	5670,	'_thumbnail_id',	'5677'),
(11242,	5679,	'_wp_attached_file',	'2020/05/DistractedDriving3.jpg'),
(11243,	5679,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:473;s:6:\"height\";i:319;s:4:\"file\";s:30:\"2020/05/DistractedDriving3.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"DistractedDriving3-300x202.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"DistractedDriving3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:30:\"DistractedDriving3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:30:\"DistractedDriving3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:30:\"DistractedDriving3-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(11244,	5672,	'_thumbnail_id',	'5679'),
(11245,	5681,	'iwp_log_type',	'scheduleBackup'),
(11246,	5681,	'iwp_log_action',	'schedule'),
(11247,	5681,	'iwp_log_activities_type',	'iwp_log'),
(11248,	5681,	'iwp_log_actions',	'backups'),
(11249,	5681,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11250,	5682,	'iwp_log_type',	'scheduleBackup'),
(11251,	5682,	'iwp_log_action',	'schedule'),
(11252,	5682,	'iwp_log_activities_type',	'iwp_log'),
(11253,	5682,	'iwp_log_actions',	'backups'),
(11254,	5682,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11255,	5684,	'iwp_log_type',	'scheduleBackup'),
(11256,	5684,	'iwp_log_action',	'schedule'),
(11257,	5684,	'iwp_log_activities_type',	'iwp_log'),
(11258,	5684,	'iwp_log_actions',	'backups'),
(11259,	5684,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11263,	5687,	'iwp_log_type',	'scheduleBackup'),
(11264,	5687,	'iwp_log_action',	'schedule'),
(11265,	5687,	'iwp_log_activities_type',	'iwp_log'),
(11266,	5687,	'iwp_log_actions',	'backups'),
(11267,	5687,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11271,	5689,	'iwp_log_type',	'scheduleBackup'),
(11272,	5689,	'iwp_log_action',	'schedule'),
(11273,	5689,	'iwp_log_activities_type',	'iwp_log'),
(11274,	5689,	'iwp_log_actions',	'backups'),
(11275,	5689,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11276,	5692,	'iwp_log_type',	'scheduleBackup'),
(11277,	5692,	'iwp_log_action',	'schedule'),
(11278,	5692,	'iwp_log_activities_type',	'iwp_log'),
(11279,	5692,	'iwp_log_actions',	'backups'),
(11280,	5692,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11281,	5693,	'iwp_log_type',	'scheduleBackup'),
(11282,	5693,	'iwp_log_action',	'schedule'),
(11283,	5693,	'iwp_log_activities_type',	'iwp_log'),
(11284,	5693,	'iwp_log_actions',	'backups'),
(11285,	5693,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11286,	5694,	'iwp_log_type',	'scheduleBackup'),
(11287,	5694,	'iwp_log_action',	'schedule'),
(11288,	5694,	'iwp_log_activities_type',	'iwp_log'),
(11289,	5694,	'iwp_log_actions',	'backups'),
(11290,	5694,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11291,	5696,	'iwp_log_type',	'scheduleBackup'),
(11292,	5696,	'iwp_log_action',	'schedule'),
(11293,	5696,	'iwp_log_activities_type',	'iwp_log'),
(11294,	5696,	'iwp_log_actions',	'backups'),
(11295,	5696,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11296,	5698,	'iwp_log_type',	'scheduleBackup'),
(11297,	5698,	'iwp_log_action',	'schedule'),
(11298,	5698,	'iwp_log_activities_type',	'iwp_log'),
(11299,	5698,	'iwp_log_actions',	'backups'),
(11300,	5698,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11301,	5700,	'iwp_log_type',	'scheduleBackup'),
(11302,	5700,	'iwp_log_action',	'schedule'),
(11303,	5700,	'iwp_log_activities_type',	'iwp_log'),
(11304,	5700,	'iwp_log_actions',	'backups'),
(11305,	5700,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11306,	5701,	'iwp_log_type',	'scheduleBackup'),
(11307,	5701,	'iwp_log_action',	'schedule'),
(11308,	5701,	'iwp_log_activities_type',	'iwp_log'),
(11309,	5701,	'iwp_log_actions',	'backups'),
(11310,	5701,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11311,	5703,	'iwp_log_type',	'scheduleBackup'),
(11312,	5703,	'iwp_log_action',	'schedule'),
(11313,	5703,	'iwp_log_activities_type',	'iwp_log'),
(11314,	5703,	'iwp_log_actions',	'backups'),
(11315,	5703,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11316,	5704,	'iwp_log_type',	'plugins'),
(11317,	5704,	'iwp_log_action',	'update'),
(11318,	5704,	'iwp_log_activities_type',	'automatic'),
(11319,	5704,	'iwp_log_actions',	'plugins-updated'),
(11320,	5704,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:7:\"3.5.5.1\";s:15:\"updated_version\";s:7:\"3.6.0.1\";}'),
(11321,	5705,	'iwp_log_type',	'core'),
(11322,	5705,	'iwp_log_action',	'update'),
(11323,	5705,	'iwp_log_activities_type',	'automatic'),
(11324,	5705,	'iwp_log_actions',	'core-updated'),
(11325,	5705,	'iwp_log_details',	'a:2:{s:11:\"old_version\";s:5:\"5.4.1\";s:15:\"updated_version\";s:5:\"5.4.2\";}'),
(11326,	5706,	'iwp_log_type',	'scheduleBackup'),
(11327,	5706,	'iwp_log_action',	'schedule'),
(11328,	5706,	'iwp_log_activities_type',	'iwp_log'),
(11329,	5706,	'iwp_log_actions',	'backups'),
(11330,	5706,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11331,	5710,	'iwp_log_type',	'scheduleBackup'),
(11332,	5710,	'iwp_log_action',	'schedule'),
(11333,	5710,	'iwp_log_activities_type',	'iwp_log'),
(11334,	5710,	'iwp_log_actions',	'backups'),
(11335,	5710,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11336,	5711,	'iwp_log_type',	'scheduleBackup'),
(11337,	5711,	'iwp_log_action',	'schedule'),
(11338,	5711,	'iwp_log_activities_type',	'iwp_log'),
(11339,	5711,	'iwp_log_actions',	'backups'),
(11340,	5711,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11341,	5712,	'iwp_log_type',	'scheduleBackup'),
(11342,	5712,	'iwp_log_action',	'schedule'),
(11343,	5712,	'iwp_log_activities_type',	'iwp_log'),
(11344,	5712,	'iwp_log_actions',	'backups'),
(11345,	5712,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11346,	5713,	'iwp_log_type',	'plugins'),
(11347,	5713,	'iwp_log_action',	'update'),
(11348,	5713,	'iwp_log_activities_type',	'automatic'),
(11349,	5713,	'iwp_log_actions',	'plugins-updated'),
(11350,	5713,	'iwp_log_details',	'a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:23:\"wp-rocket/wp-rocket.php\";s:11:\"old_version\";s:7:\"3.6.0.1\";s:15:\"updated_version\";s:7:\"3.6.0.2\";}'),
(11351,	5714,	'iwp_log_type',	'scheduleBackup'),
(11352,	5714,	'iwp_log_action',	'schedule'),
(11353,	5714,	'iwp_log_activities_type',	'iwp_log'),
(11354,	5714,	'iwp_log_actions',	'backups'),
(11355,	5714,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11356,	5716,	'iwp_log_type',	'scheduleBackup'),
(11357,	5716,	'iwp_log_action',	'schedule'),
(11358,	5716,	'iwp_log_activities_type',	'iwp_log'),
(11359,	5716,	'iwp_log_actions',	'backups'),
(11360,	5716,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11361,	5717,	'iwp_log_type',	'scheduleBackup'),
(11362,	5717,	'iwp_log_action',	'schedule'),
(11363,	5717,	'iwp_log_activities_type',	'iwp_log'),
(11364,	5717,	'iwp_log_actions',	'backups'),
(11365,	5717,	'iwp_log_details',	'a:16:{s:11:\"backup_name\";s:9:\"All Sites\";s:5:\"limit\";s:2:\"15\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:2:\"db\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
(11366,	5722,	'_edit_lock',	'1633450173:1'),
(11367,	5722,	'_edit_last',	'1'),
(11368,	5723,	'_wp_attached_file',	'2020/06/NursingH10.jpg'),
(11369,	5723,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:405;s:6:\"height\";i:301;s:4:\"file\";s:22:\"2020/06/NursingH10.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"NursingH10-300x223.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:223;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"NursingH10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:22:\"NursingH10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:22:\"NursingH10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:22:\"NursingH10-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(11370,	5722,	'_thumbnail_id',	'5723'),
(11374,	5722,	'_title',	'Florida Nursing Home Subject Of Wrongful Death Lawsuit'),
(11375,	5722,	'_description',	'Contact the Tampa nursing home abuse attorneys at the Pawlowski//Mastrilli Law Group for help with your nursing home abuse case.'),
(11376,	5722,	'_keywords',	''),
(11377,	5722,	'_subslideID',	''),
(11378,	5722,	'_wp_old_date',	'2020-06-18'),
(11379,	5725,	'_edit_lock',	'1633450173:1'),
(11380,	5725,	'_edit_last',	'1'),
(11381,	5726,	'_wp_attached_file',	'2020/06/Legal13.jpg'),
(11382,	5726,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:489;s:6:\"height\";i:374;s:4:\"file\";s:19:\"2020/06/Legal13.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"Legal13-300x229.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:229;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"Legal13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:19:\"Legal13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"postThumbMult\";a:4:{s:4:\"file\";s:19:\"Legal13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"postThumbSingle\";a:4:{s:4:\"file\";s:19:\"Legal13-200x200.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(11383,	5725,	'_thumbnail_id',	'5726'),
(11387,	5725,	'_title',	'What Is A Catastrophic Injury?'),
(11388,	5725,	'_description',	'If your injury was caused by someone’s negligence, make sure you get the compensation you deserve.'),
(11389,	5725,	'_keywords',	''),
(11390,	5725,	'_subslideID',	''),
(11391,	5728,	'_edit_lock',	'1633450173:1'),
(11392,	5728,	'_edit_last',	'1'),
(11393,	5729,	'_wp_attached_file',	'2020/06/ProdLiab3.jpg'),
(11394,	5729,	'_wp_attachment_metadata',	'a:5:{s:5:\"width\";i:400;s:6:\"height\";i:416;s:4:\"file\";s:21:\"2020/06/ProdLiab3.jpg\";s:5:\"sizes\";a:5:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"ProdLiab3-288x300.jpg\";s:5:\"width\";i:288;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"ProdLiab3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:21:\"ProdLiab3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s: