<?php

$reCaptchaSiteKey = RECAPTCHA_SITE_KEY; //do not modify
$formHTML = <<<EOD
<form id="$formID" class="mc_form" action="/" method="post">
EOD;

$formHTML .= <<<EOD
	<div class="form-part form-part-input form-part-input-1">
		<input class="required" name="Name" type="text" placeholder="Name" />
	</div>
	<div class="form-part form-part-input form-part-input-2">
		<input name="Telephone" type="text" placeholder="Phone" />
	</div>
	<div class="form-part form-part-input form-part-input-3">
		<input class="required email" name="Email_Address" type="text" placeholder="Email" />
	</div>
	<div class="form-part form-part-textarea">
		<textarea name="Message" rows="5" placeholder="Please Type Your Message Here"></textarea>
	</div>

	<div class="form-part-action">
		<div class="form-part-disclaimer">
			By submitting this form I acknowledge that contacting The Pawlowski // Mastrilli Law Group, P.A., through this website does not create an attorney-client relationship, and any information I send is not protected by attorney-client privilege.
		</div>

		<div class="form-part-submit">
			<div class="form-part captcha-wrapper">
				<div class="captcha-container">
					<div class="gRecaptchaWrapper">
						<div id="grBox_4" class="googleRecaptchaBox" data-sitekey="{$reCaptchaSiteKey}"></div>
						<div class="grDisclaimerBox">
							<span class="grdbBadge"></span>
							<div class="grdbText">
								<span class="grdbHead">protected by reCAPTCHA</span>
								<span class="grdbLinks">
									<a href="https://www.google.com/intl/en/policies/privacy/" target="_blank">Privacy</a> <span class="grdbSep">-</span> <a href="https://www.google.com/intl/en/policies/terms/" target="_blank">Terms</a>
								</span>
							</div>
						</div>
					</div>
				</div>
			</div>
EOD;

/*	Part III
	Set the value for the line below to the name of the input that will store the email address.  Case sensitive.  If the email address looks valid enough, it will be used as the reply-to email address as well as the post title in the database.
*/
$formHTML .= <<<EOD
			<input type="hidden" class="hidden" name="replyTo" value="Email_Address" />
EOD;

/* 	PART IV
	You should not have to modify anything below this line.
*/

$formHTML .= <<<EOD
			<input type="hidden" class="hidden" name="Form_Used" value="Footer" />
			<input type="hidden" class="hidden" name="email" />
			<input type="hidden" class="hidden" name="ncFormSubmissionPH" value="$formID" />
			<input type="hidden" class="hidden" name="redirect" value="/thank-you/" />
			<input class="submit-button grSubmitBTN" id="submit_$formID" type="submit" value="Submit" />
		</div>
	</div>

</form>
EOD;
