<?php
/*
Plugin Name:  DSK Open Graph
Version: 1.0.3
Author: Enrique Aguilar
Description: This plugin adds Open Graph support. Works best when DSK SEO is installed and activated.
*/

add_action('wp_head', 'dsk_add_opengraph_support');
function dsk_add_opengraph_support() {
	global $post;
	if(is_null($post)) {return;}
	$postID = $post->ID;
	if(is_home()) {
		$postID = get_option("page_for_posts", $postID);
	}
	$seo_title = trim(get_post_meta( $postID, '_title', true ));
	$item_title = trim(get_the_title($postID));
	if($seo_title != '') {$title = $seo_title;}
	elseif( $item_title != '') {$title = $item_title;}
	else {$title = get_bloginfo( 'name' );}
	$title = str_replace("\"", "&quot;", $title);
	if($title == "Home" && is_front_page()) {
		$title = get_bloginfo( 'name' );
	}
?>
	<meta property="og:title" content="<?php echo $title; ?>"/>
<?php
$social_media_description = trim(get_post_meta( $postID, '_description', true ));
if(!is_home() && (!isset($social_media_description) || $social_media_description == "")) {
	$postInHead = get_post();
	$social_media_description = $postInHead->post_content;
	$social_media_description = trim(strip_tags($social_media_description));
	$firstLinebreakPos = stripos($social_media_description, "\n");
	if($firstLinebreakPos !== false) {
		$social_media_description = substr($social_media_description, 0, $firstLinebreakPos);
	}
	$social_media_description = trim(substr($social_media_description, 0, 240));
	$social_media_description = preg_replace( "/\r|\n/", " ", $social_media_description );
	$lastSpacePos = strripos($social_media_description, " ");
	if($lastSpacePos === false || $lastSpacePos < 200) {
		$social_media_description .= "...";
	} else {
		$social_media_description = substr($social_media_description, 0, $lastSpacePos) . "...";
	}
} 
$social_media_description = str_replace("\"", "&quot;", $social_media_description);
?>
	<meta property="og:description" content="<?php echo $social_media_description; ?>" />
	<meta property="og:url" content="<?php the_permalink($postID); ?>"/>
<?php $social_media_image = wp_get_attachment_image_src(get_post_thumbnail_id( $postID ), 'postThumbSingle'); ?>
<?php if ( $social_media_image && ( is_page() || is_single() ) ) : ?>
	<meta property="og:image" content="<?php echo $social_media_image[0]; ?>?t=<?= time() ?>" />
<?php else : ?>
	<meta property="og:image" content="<?php echo get_stylesheet_directory_uri(); ?>/screenshot.png?t=<?= time() ?>" />
<?php endif; ?>
	<meta property="og:type" content="<?php if(is_single() || is_page()) echo 'article'; else echo 'website'; ?>" />
	<meta property="og:site_name" content="<?php bloginfo('name'); ?>" />
<?php
}
add_filter( 'jetpack_enable_opengraph', '__return_false', 99 );