<?php
/*
Plugin Name:  DSK SEO
Version: 1.1.5
Author: Enrique Aguilar
Description: This plugin allows the use of custom SEO Titles and Descriptions.
*/

add_action( 'add_meta_boxes', 'dsk_seo_metabox' );
add_action( 'save_post', 'dsk_seo_save' );

function dsk_seo_metabox() {
	$thePostTypes = array( 'post', 'page' );
	foreach ($thePostTypes as $thePostType) {
		add_meta_box(
			'dsk_seo_section',
			__( 'SEO', 'dsk_seo_domain' ),
			'dsk_seo_mainfunc',
			$thePostType,
			'normal',
			'high'
		);
	}
}

function dsk_seo_mainfunc( $post ) {
	// Use nonce for verification
	wp_nonce_field( plugin_basename( __FILE__ ), 'dsk_seo_noncename' );
	$seo_title = get_post_meta( $post->ID, '_title', true );
	$seo_description = get_post_meta( $post->ID, '_description', true );
	$seo_keywords = get_post_meta( $post->ID, '_keywords', true );
?>
	<div class="dsk_seo"><label for="dsk_seo_title">Title:</label> <input type="text" id="dsk_seo_title" name="dsk_seo_title" value="<?php echo esc_attr($seo_title); ?>" /><div class="dsk_seo_goal" id="dsk_seo_title_goal"><span class="dsk_seo_count"></span> characters <span class="dsk_seo_tip">(70 is the recommended max)</span></div></div>
	<div class="dsk_seo"><label for="dsk_seo_description">Description:</label> <textarea id="dsk_seo_description" name="dsk_seo_description"><?php echo esc_attr($seo_description); ?></textarea><div class="dsk_seo_goal" id="dsk_seo_description_goal"><span class="dsk_seo_count"></span> characters <span class="dsk_seo_tip">(160 is the recommended max)</span></div></div>
	<div class="dsk_seo"><label for="dsk_seo_keywords">Keywords:</label> <input type="text" id="dsk_seo_keywords" name="dsk_seo_keywords" value="<?php echo esc_attr($seo_keywords); ?>" /><div class="dsk_seo_goal">Use commas to separate keywords.</div></div>
<?php
}

function dsk_seo_save( $post_id ) {
	if(!isset($_REQUEST['post_type'])) {return;}

	if ( 'page' == $_REQUEST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) {return;}
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) ) {return;}
	}

	// Secondly we need to check if the user intended to change this value.
	if ( ! isset( $_POST['dsk_seo_noncename'] ) || ! wp_verify_nonce( $_POST['dsk_seo_noncename'], plugin_basename( __FILE__ ) ) )
	  return;

	// Thirdly we can save the value to the database

	//if saving in a custom table, get post_ID
	$post_ID = $_POST['post_ID'];

	$seo_title = sanitize_text_field( $_POST['dsk_seo_title'] );
	update_post_meta($post_ID, '_title', $seo_title);

	$seo_description = sanitize_text_field( $_POST['dsk_seo_description'] );
	update_post_meta($post_ID, '_description', $seo_description);

	$seo_keywords = sanitize_text_field( $_POST['dsk_seo_keywords'] );
	update_post_meta($post_ID, '_keywords', $seo_keywords);

}

function dsk_seo_enqueue($hook) {
	$time = '20190624_11';
    if( 'post.php' != $hook && 'post-new.php' != $hook ) return;
 	wp_register_style( 'dsk_seo_css', plugins_url('/css/style.css', __FILE__ ), false, $time );
	wp_register_script( 'dsk_seo_script', plugins_url('/js/script.js', __FILE__), array('jquery'), $time, true );
	wp_enqueue_style( 'dsk_seo_css' );
	wp_enqueue_script( 'dsk_seo_script' );
}
add_action( 'admin_enqueue_scripts', 'dsk_seo_enqueue' );

function dsk_seo_post_meta_title_tag() {
	global $post;
	if(is_null($post)) {return "";}
	$postID = $post->ID;
	if(is_home()) {
		$postID = get_option("page_for_posts", $postID);
	}
	$seo_title = trim(get_post_meta( $postID, '_title', true ));		
	if($seo_title && !is_search() && !is_archive()) {
		$seo_title = str_replace("\"", "&quot;", $seo_title);
		return $seo_title;
	} else {
		return "";
	}
}
add_filter('pre_get_document_title', 'dsk_seo_post_meta_title_tag');

function dsk_seo_metas() {
	global $post;
	if(is_null($post)) {return;}	
	$postID = $post->ID;
	if(is_home()) {
		$postID = get_option("page_for_posts", $postID);
	}
	$seo_description = trim(get_post_meta( $postID, '_description', true ));
	if(!is_home() && $seo_description == '') {
		$seo_description = $post->post_content;
		$seo_description = trim(strip_tags($seo_description));
		$firstLinebreakPos = stripos($seo_description, "\n");
		if($firstLinebreakPos !== false) {
			$seo_description = substr($seo_description, 0, $firstLinebreakPos);
		}
		$seo_description = trim(substr($seo_description, 0, 240));
		$seo_description = preg_replace( "/\r|\n/", " ", $seo_description );
		$lastSpacePos = strripos($seo_description, " ");
		if($lastSpacePos === false || $lastSpacePos < 200) {
			$seo_description .= "...";
		} else {
			$seo_description = substr($seo_description, 0, $lastSpacePos) . "...";
		}
	}

	if($seo_description != '') {
		$seo_description = str_replace("\"", "&quot;", $seo_description); ?>
		<meta name="description" content="<?php echo $seo_description; ?>" />
<?php
	}
	$seo_keywords = get_post_meta( $postID, '_keywords', true );
	if($seo_keywords != '') {
		$seo_keywords = str_replace("\"", "&quot;", $seo_keywords); ?>
		<meta name="keywords" content="<?php echo $seo_keywords; ?>" />
<?php
	}
}
add_action('wp_head', 'dsk_seo_metas');

function dsk_seo_sitemap_plus_menu_item() {
	add_submenu_page( 'tools.php', 'DSK SEO', 'DSK SEO', 'manage_options', 'dsk-seo-page', 'dsk_seo_sitemap_plus' );
}
add_action('admin_menu', 'dsk_seo_sitemap_plus_menu_item');


function dsk_seo_sitemap_plus() {
		$url = home_url();
		$tdkPageURL = admin_url('/tools.php?page=dsk-seo-page');
		$contenido = <<<EOT
		<div id="tdkContent">
		<span id="tdkTogglemetas"><span id="tdkMetaStatus"></span>Toggle Metas</span>
		<h1>DSK SEO</h1>
		<div id="tdkPostTypes">
		<a href="$tdkPageURL&tdkposttype=1">View Pages Metadata</a> | <a href="$tdkPageURL&tdkposttype=0">View Posts Metadata</a>		
		</div>
		<ul id="tdkUL">
EOT;
	
		if(isset($_GET['tdkposttype'])) {
			$postTypeID = intval($_GET['tdkposttype']);
		} else {
			$postTypeID = 1;
		}
		if($postTypeID === 0) {
			//Viewing posts
			$myArgs = array(
				'posts_per_page' => -1,
				'offset' => 0,
				'order' => 'ASC',
				'orderby' => 'date',
				'post_type' => 'post',
				'post_status' => 'publish'
			);
			$bodyClassPrefix = "postid-";
			$myEntries = get_posts($myArgs);
		} else {
			//Viewing pages
			$myArgs = array(
				'sort_order' => 'ASC',
				'sort_column' => 'menu_order',
				'hierarchical' => 1,
				'post_type' => 'page',
				'post_status' => 'publish'
			);
			$bodyClassPrefix = "page-id-";
			$myEntries = get_pages($myArgs);
		}		
		$goodLength = 10;
        $haveBoth = array();
        $missingBoth = array();
        $missingTitle = array();
        $missingDescription = array();
		//dsk-seo/platinum standard
		$key_title = "_title";
		$key_description = "_description";
		foreach( $myEntries as $entry ) {
			//if ( ! $page->post_content ) continue;
			$entryID = $entry->ID;
			$editURL = admin_url() . "post.php?post=" . $entryID . "&action=edit";
			$editLink = "<a target='_blank' href='" . $editURL . "'>Edit</a>";
			$entryTitle = $entry->post_title;
			$permalink = get_permalink( $entryID );
			$slug = str_replace($url, '', $permalink);
			$entrySlugDB = $entry->post_name;
			$meta_values = get_post_meta($entryID);
			$seotitle = $meta_values[$key_title][0];
            $seodescription = $meta_values[$key_description][0];

            $titleLength = strlen($seotitle);
            $descriptionLength = strlen($seodescription);
            $goodlength = 20;
			if($titleLength > $goodLength && $descriptionLength > $goodLength ) {
            	$haveBoth[] = $permalink;
            	$metatest = "tdkMetapass";
              } elseif ($titleLength < $goodLength && $descriptionLength < $goodLength) {
              	$missingBoth[] = $permalink;
              	$metatest = "tdkMetafail";
              } elseif($titleLength < $goodLength) {
              	$missingTitle[] = $permalink;
              	$metatest = "tdkMetafail";
               } elseif($descriptionLength < $goodLength) {
              	$missingDescription[] = $permalink;
              	$metatest = "tdkMetafail";
              }
			$tempContent = <<<EOT
			<li id="post-id-{$entryID}" data-pid="{$entryID}" class="{$metatest}" data-slug="{$slug}">			
				<a target="_blank" class="tdkEntryTitleLink" title="{$entryTitle}" href="{$permalink}">{$entryTitle}</a>
				<div class="tdkEditLink">[{$editLink}]</div>
				<input class="tdkSlug" type="text" value="{$slug}"> <input type="text" class="tdkEntryid" value="body.{$bodyClassPrefix}{$entryID}"> <input type="text" class="tdkPermalink" value="{$slug}" readonly>
				<div class="tdkSEOdata">
				<span class="tdkLabel">Entry Title:</span> <input type="text" class="tdkField tdkEntryTitle" value="{$entryTitle}"> <br />
				<span class="tdkLabel">Entry Slug:</span> <input type="text" class="tdkField tdkEntrySlug" value="{$entrySlugDB}"> <br />				
				<span class="tdkLabel">SEO Title:</span> <input type="text" class="tdkField tdkTitle" value="{$seotitle}"> <br />
				<span class="tdkLabel">SEO Desc:</span> <input type="text" class="tdkField tdkDescription" value="{$seodescription}"></div>
				<input class="tdkUpdateEntry" type="submit" value="Update Entry">			
			</li>
EOT;

			$contenido .= $tempContent;
		}
	if($contenido != "") {
		$haveBothCount = count($haveBoth);
		$missingBothCount = count($missingBoth);
		$missingTitleCount = count($missingTitle);
		$missingDescriptionCount = count($missingDescription);
		$haveBoth = implode("<br>", $haveBoth);		
		$missingBoth = implode("<br>", $missingBoth);		
		$missingTitle = implode("<br>", $missingTitle);		
		$missingDescription = implode("<br>", $missingDescription);   		
    	$contenido .= <<<EOT
		<div id="tdkActualReport">
        <h2>SEO Meta Report</h2>
    	<h3>Missing Titles <span class="tdkRedem">and</span> Descriptions ($missingBothCount):</h3>$missingBoth
        <h3>Missing Titles <span class="tdkRedem">Only</span> ($missingTitleCount):</h3>$missingTitle
        <h3>Missing Descriptions <span class="tdkRedem">Only</span> ($missingDescriptionCount):</h3>$missingDescription
        </div><!-- actualReport -->
		</div><!-- tdkContent -->
EOT;
    	echo $contenido;

     } else {echo $content;}
}

function dsk_seo_sitemap_plus_includes($hook) {
    if( 'tools_page_dsk-seo-page' != $hook )
        return;
    $time = '20190624_11';
	wp_register_style('sitemap_plus_styles', plugins_url('/css/dsk-seo-sitemap-plus.css', __FILE__), array(), $time, 'all');
	wp_register_script('sitemap_plus_script', plugins_url('/js/dsk-seo-sitemap-plus.js', __FILE__), array('jquery'), $time, true);
	wp_enqueue_style('sitemap_plus_styles');
    wp_enqueue_script( 'sitemap_plus_script');
}
add_action( 'admin_enqueue_scripts', 'dsk_seo_sitemap_plus_includes' );

function dsk_seo_sitemap_plus_update_metadata() {
	global $wpdb;
	$pid = intval($_POST['tdkpid']);
	$newTitle = $_POST['tdktitle'];
	$newDescription = $_POST['tdkdescription'];
	$newEntryTitle = $_POST['tdkentrytitle'];
	$newSlug = $_POST['tdkslug'];
	
	$curTitle = get_post_meta($pid, "_title", true);
	$curDescription = get_post_meta($pid, "_description", true);
	$curEntryTitle = get_the_title($pid);
	$curSlug = get_post_field('post_name', $pid);
	if($newTitle === $curTitle) {
		$titleUpdated = -1;		
	} else {
		$titleUpdated = intval(update_post_meta($pid, "_title", $newTitle));	
	}
	if($newDescription === $curDescription) {
		$descriptionUpdated = -1;
	} else {
		$descriptionUpdated = intval(update_post_meta($pid, "_description", $newDescription));
	}
	if($newEntryTitle === $curEntryTitle) {
		$entryTitleUpdated = -1;
	} else {
		$newPostInfo = array(
			'ID'           => $pid,
			'post_title'   => $newEntryTitle,
		);
		if(wp_update_post( $newPostInfo ) === 0) {
			$entryTitleUpdated = -1;
		} else {
			$entryTitleUpdated = 1;  
			$newEntryTitle = get_the_title($pid);
		}
	}
	if($newSlug === $curSlug) {
		$slugUpdated = -1;
	} else {
		$newPostInfo = array(
			'ID'           => $pid,
			'post_name'   => $newSlug,
		);
		if(wp_update_post( $newPostInfo ) === 0) {
			$slugUpdated = -1;
		} else {
			$slugUpdated = 1;  
		}
	}	

	$homeURL = home_url();
	$permalink = get_permalink( $pid );
	$relativeURL = str_replace($homeURL, '', $permalink);
	
	echo json_encode(['permalink' => $permalink, 'relativeurl' => $relativeURL, 'entrytitle' => $newEntryTitle, 'titleupdated' => $titleUpdated, 'descriptionupdated' => $descriptionUpdated, 'entrytitleupdated' => $entryTitleUpdated, 'slugupdated' => $slugUpdated]);
	wp_die();
}
add_action('wp_ajax_tdk_update_pm', 'dsk_seo_sitemap_plus_update_metadata');
