(function ($) {
	if( $('.dsk_seo').length > 0) {dsk_seo_js();};
	function dsk_seo_js() {
		var dsk_seo_title = $('#dsk_seo_title');
		var dsk_seo_description = $('#dsk_seo_description');
		var dsk_seo_keywords = $('#dsk_seo_keywords');
		var title_counter = $('#dsk_seo_title_goal').children('.dsk_seo_count');
		var description_counter = $('#dsk_seo_description_goal').children('.dsk_seo_count');

		//initial character count
		updateGoal(1);
		updateGoal(2);

		//updated character count on change
		dsk_seo_title.on('input', function(){updateGoal(1);});
		dsk_seo_description.on('input', function(){updateGoal(2);});

		function updateGoal(loc) {
			var target, string, max, count;
			if(loc == 1) {
				target = title_counter;
				string = dsk_seo_title.val();
				max = 70;
			} else if(loc == 2) {
				target = description_counter;
				string = dsk_seo_description.val();
				max = 160;
			} else {
				return false;
			}
			count = string.length;
			if(count > max) target.closest('.dsk_seo').addClass('overTheLimit');
			else target.closest('.dsk_seo').removeClass('overTheLimit');

			target.html(count);
			return true;
		}
	}
}(jQuery));