<?php
/*
Plugin Name:  DSK Website Forms
Version: 1.4.8
Author: Enrique Aguilar
Description: Best if used with a reliable email delivery service (e.g. SendGrid, Mailgun, and Postmark).
*/

function dskWebsiteFormsncffcode($newValue = '') {
	static $ncffcode;
	if(empty($newValue)) {
		return $ncffcode;
	} else {
		$ncffcode = $newValue;	
	}
}
function create_dskwf_post_type() {
	register_post_type( 'ncforms', array(
		'labels' => array(
			'name' => __( 'Forms' ),
			'singular_name' => __( 'Form' ),
			'all_items' => __( 'View Entries' ),
		),
		'capabilities' => array(
    		'create_posts' => 'do_not_allow',
  		),
		'map_meta_cap' => true, // Set to `false` if users are not allowed to edit/delete existing posts 
		'public' => false,
		'has_archive' => false,
		'rewrite' => false,
		'exclude_from_search' => true,
		'show_ui' => true,
		'show_in_admin_bar' => false,
		'publicly_queryable' => false
		)
	);
}
add_action( 'init', 'create_dskwf_post_type' );

function create_ncformspa_post_type() {
	register_post_type( 'ncformspa', array(
		'labels' => array(
			'name' => __( 'FSPA' ),
			'singular_name' => __( 'FSPA' ),
			'all_items' => __( 'View FSPAs' ),
		),
		'capabilities' => array(
    		'create_posts' => 'do_not_allow',
  		),
		'map_meta_cap' => true, // Set to `false` if users are not allowed to edit/delete existing posts  		
	    'show_in_menu' => 'edit.php?post_type=ncformspa',
		'public' => false,
		'has_archive' => false,
		'rewrite' => false,
		'exclude_from_search' => true,
		'show_ui' => true,
		'show_in_admin_bar' => false,
		'publicly_queryable' => false
		)
	);
}
add_action( 'init', 'create_ncformspa_post_type' );

function dsk_website_forms_menu_item() {
	add_submenu_page( 'edit.php?post_type=ncforms', 'Options', 'Options', 'manage_options', 'website-forms-page', 'dsk_website_forms_func' );
	//Item below is temporary
	add_submenu_page( 'edit.php?post_type=ncforms', 'FSPA', 'FSPA', 'manage_options', 'edit.php?post_type=ncformspa' );

}
add_action('admin_menu', 'dsk_website_forms_menu_item');

function dskwf_edit_ncforms_columns($columns) {
	$columns = array(
		'cb' => '<input type="checkbox" />',
//		'title' => __('Title'),
		'fullncform' => __('Form Submissions'),
		'date' => __('Date')
	);
	return $columns;
}
add_filter( 'manage_edit-ncforms_columns', 'dskwf_edit_ncforms_columns');

function dskwf_manage_ncposts_columns( $column, $post_id ) {
	switch( $column ) {
		case 'fullncform' :
			$fullcontent = get_the_content();
			echo $fullcontent;
			break;
		default :
			break;
	}
}
add_action( 'manage_ncforms_posts_custom_column', 'dskwf_manage_ncposts_columns', 10, 2 );

add_filter( 'manage_edit-ncformspa_columns', 'dskwf_edit_ncforms_columns');
add_action( 'manage_ncformspa_posts_custom_column', 'dskwf_manage_ncposts_columns', 10, 2 );

function dsk_website_forms_func() {
	if(isset($_POST['update_website_forms'])) {
		$nextClient_forms = array(
			"recipients" => $_POST['recipients'],
			"recipientsFormSpecific" => $_POST['recipientsFormSpecific'],
			"subject" => $_POST['subject'],
			"uncaptcha" => $_POST['uncaptcha'],
			"blacklist" => $_POST['blacklist']
		);
		update_option('nextClient_forms', $nextClient_forms );
		$dskFeedback = 1;
	}
	$nextClient_forms = get_option('nextClient_forms');
?>
	<div class="dskwf-options-page ncfp_options">
	<h1>Form Options</h1>
	<div id="dskFeedback">
		<?php if(isset($dskFeedback)) {
			if($dskFeedback == 1) echo '<p>Options updated successfully.</p>';
		} ?>
	</div><!-- #dskFeedback -->
	<form action="<?php echo home_url(); ?>/wp-admin/admin.php?page=website-forms-page" method="POST">
	<table>
		<tr>
			<td>
				<h2>Recipient(s):</h2>
				<label>Separate multiple email addresses with commas (no spaces).
				<h3>Default:</h3>
				<label>Do not leave this field empty.</label>
				<input type="text" name="recipients" value="<?php echo $nextClient_forms['recipients']; ?>" />
				<h3>Form-Specific:</h3>
				<label>This field is optional.  Any values set here will override those specified above.  One form per line. Specify a form's id followed by a colon and the email addresses to be used as recipients for that form.  For example:<br />2:address1,address2,address3</label>
				<textarea name="recipientsFormSpecific"><?php echo $nextClient_forms['recipientsFormSpecific']; ?></textarea>
			</td>
		</tr>
		<tr>
			<td>
				<h2>Subject:</h2>
				<label>This preference can be overridden per form by including an input field in the form's HTML with the name of "subject."</label>
				<input type="text" name="subject" value="<?php echo $nextClient_forms['subject']; ?>" />
			</td>
		</tr>
		<tr>
			<td>
				<h2>Disable Captcha:</h2>
				<label>Indicate which forms can be submitted without captcha verification.  Digits and commas only.  No spaces.</label>
				<input type="text" name="uncaptcha" value="<?php echo $nextClient_forms['uncaptcha']; ?>" />
			</td>
		</tr>
		<tr>
			<td>
				<h2>Blacklisted Terms:</h2>
				<label>Use commas to separate blacklisted terms (no spaces).  If any of these terms are found in any of the fields the submission will be stored in the database but not mailed.</label>
				<input type="text" name="blacklist" value="<?php echo $nextClient_forms['blacklist']; ?>" />
			</td>
		</tr>
	</table>
	<input type="submit" value="Save" id="submitNCoptions" name="update_website_forms" />
	</form>
<?php
}

function dsk_website_forms_CSS() {
    wp_register_style($handle = 'dskwf_styles', $src = plugins_url('wp-admin.css', __FILE__), $deps = array(), $ver = '1.0.0', $media = 'all');
    wp_enqueue_style('dskwf_styles');
}
add_action('admin_print_styles', 'dsk_website_forms_CSS');

function dsk_website_forms_activate() {
	$nextClient_forms = get_option("nextClient_forms");
	$recipients = ( isset($nextClient_forms["recipients"]) ) ? $nextClient_forms["recipients"] : "cms@site-mail.com";
	$recipientsFormSpecific = ( isset($nextClient_forms["recipientsFormSpecific"]) ) ? $nextClient_forms["recipientsFormSpecific"] : "";
	$subject = ( isset($nextClient_forms["subject"]) ) ? $nextClient_forms['subject'] : "Website Form Submission";
	$uncaptcha = ( isset($nextClient_forms["uncaptcha"]) ) ? $nextClient_forms['uncaptcha'] : "";
	$blacklist = ( isset($nextClient_forms["blacklist"]) ) ? $nextClient_forms['blacklist'] : "http,www,url=";
	$nextClient_forms = array(
		"recipients" => $recipients,
		"recipientsFormSpecific" => $recipientsFormSpecific,
		"subject" => $subject,
		"uncaptcha" => $uncaptcha,
		"blacklist" => $blacklist
	);
	update_option('nextClient_forms', $nextClient_forms);
}
register_activation_hook( __FILE__, 'dsk_website_forms_activate' );

function dskWebsiteFormProcessCheck() {
	if(!isset($_POST['ncFormSubmission']) || is_admin()) {return false;}

	if( isset($_POST['submit']) || isset($_POST['Submit']) || isset($_POST['SUBMIT']) ) {
		return false;
	} else if(isset($_POST['s'])) {
		ncRedirectAndThanks(true); //decoy
	} else if($_POST['email'] == '' ) {
		dskWFBasicValidation();
		dskCaptchaTest();
	}
}
add_action('init', 'dskWebsiteFormProcessCheck');

function dskWFshowFormFeedback($content) {
	if(is_null(dskWebsiteFormsncffcode())) {
		return $content;
	}
	global $ncFormErrors;
	$successMSG = "<h1>Thank You</h1><p class=\"ncFormFeedback\">Your form has been submitted.</p>";
	$captchaError = "<h1>We Are Sorry</h1><p class=\"ncFormFeedback\">You have entered the wrong captcha value.  Please <a href='javascript: history.go(-1)'>try again</a>.</p>";
	$blacklistedError = "<h1>Thank You</h1><p class=\"ncFormFeedback blacklistedTerms\">Your form has been submitted.</p>";
	$mailingError = "<h1>We Are Sorry</h1><p>Your message was NOT sent successfully.</p>";

	$ncffcode = dskWebsiteFormsncffcode();
	if($ncffcode === 1 && is_front_page()) {$ncFormFeedback = $successMSG;}
	elseif($ncffcode === 2) {$ncFormFeedback = $captchaError;}
	elseif($ncffcode === 3) {$ncFormFeedback = $blacklistedError;}
	elseif($ncffcode === 4) {
		$ncFormFeedback = $mailingError;
		foreach($ncFormErrors as $error) {
			$ncFormFeedback .= '<p>' . $error . '</p>';
		}
	}
	if (isset($ncFormFeedback)) {$content = $ncFormFeedback;}
	return $content;
}
add_filter( 'the_content', 'dskWFshowFormFeedback', 100 );

function nextclient_form($id, $shortcodeCall = 0) {
	$self = get_permalink();
	$formID = 'form_' . $id;
	include(WP_CONTENT_DIR . '/forms/' . $id . '.php');
	if($shortcodeCall == 1) return $formHTML;
	else echo $formHTML;
}
function dskWF_shortcode_function($atts) {
     extract(shortcode_atts(array(
	      'id' => '1'
     ), $atts));
	return nextclient_form($id, 1);
}
add_shortcode('form', 'dskWF_shortcode_function');

function dskCaptchaTest() {
	$nextClient_forms = get_option('nextClient_forms');
	if(session_id() == '') {session_start();}	
	$captchaDisabledForTheseForms = $nextClient_forms['uncaptcha'];
	$captchaDisabledForTheseForms = explode(',', $captchaDisabledForTheseForms);
	$disableNCcaptcha = 0;
	if( $captchaDisabledForTheseForms >= 1) {
		$theIDofSubmittedFORM = returnNCformID();
		if(in_array($theIDofSubmittedFORM, $captchaDisabledForTheseForms)) {
			//captcha disabled - process form
			dskWFprocessForm();
		}
	}
	$sCaptcha = (isset($_SESSION['dsknc_captcha']) && $_SESSION['dsknc_captcha'] !== '') ? $_SESSION['dsknc_captcha'] : -1;
	$pCaptcha = (isset($_POST['nc_captcha']) && $_POST['nc_captcha'] !== '') ? htmlentities ( trim ( $_POST['nc_captcha'] ), ENT_NOQUOTES ) : -1;
	$sCaptcha = strtolower($sCaptcha);
	$pCaptcha = strtolower($pCaptcha);
	if( $sCaptcha != $pCaptcha || $sCaptcha == -1 || $pCaptcha == -1 ) {
		//will process no matter what, but captcha fail notice will trail
		dskWebsiteFormsncffcode(2);
	}
	dskWFprocessForm();	
}
function ncStringify($oldValue) {
	$newValue = '';
	foreach ($oldValue as $v) :
		$newValue = trim($newValue);
		$v = trim($v);
		if($newValue !== '' && $v != '') {$newValue .= '***';}
		$newValue .=  $v;
	endforeach;
	return $newValue;
}

function dskWFprocessForm() {
	$doNotMail = false;
	$badPhone = false;	

	$ncffcode = dskWebsiteFormsncffcode();
	//do only if captcha is ok
	if($ncffcode != 2) {
		do_action('dskwebsiteformspreprocess');
	}

	//Process uploads
	if(function_exists('dskWFprocessAttachments')) {
		$attachments = dskWFprocessAttachments();		
	} else {
		$attachments = [];
	}

	$messageEmail = "<html><body>";	
	$messageEmail .= "*PRE_FORM_CONTENT*";
	$messageDB = "<table>";
	$messagePartial = '';
	$namesToSkip = array('nc_captcha', 'ncFormSubmission', 'email', "replyTo", 'Agreement', 'subject', 'et', 'redirect', 'Dev_Notes');
	$namesToSkip = array_map('strtolower', $namesToSkip);
	foreach ($_POST as $key => $value) {
		if( in_array(strtolower($key), $namesToSkip) ) continue;
		$label = str_replace('_', ' ', $key);
		if( is_array($value) ) {$value = ncStringify($value);}
		if(strlen(trim($value)) == 0) continue;
		$lastChar = substr($label, -1);
		$sep = stripos($lastChar, ":") === false && stripos($lastChar, "?") === false ? ":" : "";

		//Straighten curly quotes, etc.
		$label = setThemCharactersStraight($label);
		$value = setThemCharactersStraight($value);

		//Cleanup strings for Emailing
		$labelEmail = htmlentities(trim($label), ENT_NOQUOTES);
		$valueEmail = htmlentities(trim($value), ENT_NOQUOTES);

		$messageEmail .= "<strong>{$labelEmail}$sep</strong><br />{$valueEmail}<br /><br />";
		$messageDB .= "<tr><td class='mdbLeft'>{$label}{$sep}</td><td class='mdbRight'>{$value}</td></tr>";
		$messagePartial .= "<tr><td>{$labelEmail}{$sep}</td><td>{$valueEmail}</td></tr>";
	}
	$homeURL = get_home_url();
	$messageEmail .= "<strong>Sent Via:</strong><br />{$homeURL}<br /><br />";
	$messageDB .= "</table>";
	
	
	//exit without emailing if a blacklisted term appears
	$nextClient_forms = get_option("nextClient_forms");
	$blacklist = $nextClient_forms['blacklist'];
	$blacklist = trim($blacklist);
	if(strlen($blacklist) > 0) {
		$blacklist = explode(',', $blacklist);
		foreach($blacklist as $term) {
			if(stripos($messagePartial, $term) === false) {continue;}
			dskWebsiteFormsncffcode(3);
			$doNotMail = true;
			$_POST['Failed_Blacklist_Validation'] = '1';
			$_POST['Blacklisted_Term_Found'] = $term;
			break;
		}
	}
	
	// set $badPhone to true if phone needs to be validated and it's not valid
	if( isset($_POST['et']) ) {
		$phoneHolder = trim($_POST['et']);
	} else {
		$phoneHolder = "Telephone";
	}
	if(isset($_POST[$phoneHolder])) {
		$phone = $_POST[$phoneHolder];
		if(ncPhoneReasonabilityCheck($phone) === false) {
			$badPhone = true;
		}	
	} else {
		$badPhone = true;
	}
	
	//$formID needed below and further down
	$formID = returnNCformID();
	if(!dskwfBypassCheck($formID, "bypass_phone_check_for_spam")) {	
		$abortMailifBadPhone = true;
	} else {
		$abortMailifBadPhone = false;	
	}

	//If we're still mailing, run another check	
	if(!$doNotMail) {
		$ncffcode = dskWebsiteFormsncffcode();
		if($formID >= 1000 || isset($_POST['Dev_Notes']) || $ncffcode == 2 || ($badPhone && $abortMailifBadPhone)) {
			$doNotMail = true;
		}	
	}

	if($doNotMail) {//Review
		$storedFSid = ncStoreSubmission($messageDB, "ncformspa");
		ncMailSubmission($messageEmail, 1, $attachments, $badPhone, $storedFSid);
	} else {
		$storedFSid = ncStoreSubmission($messageDB, "ncforms");
		ncMailSubmission($messageEmail, 0, $attachments, $badPhone, $storedFSid);	
	}
}
function ncStoreSubmission($message, $postType) {
	$curTime = time();
	$padder = "000" . rand(0, 9999);
	$padder = substr($padder, -4);
	$title = "{$curTime}_{$padder}";
	$add_cfr_to_msg = array(
		'post_title' => wp_strip_all_tags($title),
		'post_content' => $message,
		'post_status' => "publish",
		'post_type' => $postType,
	);
	$daPostID = wp_insert_post( $add_cfr_to_msg);
	return $daPostID;
}

function dskWFdetermineRecipients($nextClient_forms) {
	//Check for form-specific recipients
	$tempo = $nextClient_forms['recipientsFormSpecific'];
	$tempo = explode("\n", $tempo);
	$recipientsFormSpecific = Array();
	foreach($tempo as $v) {
		$sep = stripos($v, ":");
		if($sep === false) continue;
		$key = substr($v, 0, $sep);
		$value = substr($v, $sep+1);
		$recipientsFormSpecific[$key] = $value;
	}
	$tempo = null;
	$tempo = returnNCformID();
	$ncRecipients = $recipientsFormSpecific[$tempo];
	$ncRecipients = trim($ncRecipients);

	//If no specific form recipient, use default recipients
	if( strlen($ncRecipients) == 0 ) {
		$ncRecipients = $nextClient_forms['recipients'];
	}
	return $ncRecipients;
}

function ncMailSubmission($message, $needsFurtherReview, $attachments, $badPhone, $storedFSid) {
	global $ncFormErrors;
	$nextClient_forms = get_option("nextClient_forms");

	$ncRecipients = dskWFdetermineRecipients($nextClient_forms);
	
	//Add any dev notes	
	if(isset($_POST['Dev_Notes'])) {
		$devNotes = $_POST['Dev_Notes'];
		$devNotes = setThemCharactersStraight(trim($devNotes));
		$devNotes = htmlentities(trim($devNotes), ENT_NOQUOTES);
	} else {
		$devNotes = "";
	}

	if(returnNCformID() >= 1000) {
		$devNotes .= " Sent Via ADA Mirror;";
	}

	if(isset($_POST['Failed_Blacklist_Validation'])) {
		$devNotes .= " Failed Blacklist Validation;";
		$blacklistedTermNote = $_POST['Blacklisted_Term_Found'];
		$blacklistedTermNote = setThemCharactersStraight(trim($blacklistedTermNote));
	} else {
		$blacklistedTermNote = '';
	}

	if($needsFurtherReview == 1) {
		//add onto $devNotes
		if($badPhone) {
			$devNotes .= " Failed Telephone Validation;";
		}		
	}
		
	$devNotes = trim($devNotes);
	
	//Close the HTML for $message
	$sendingDomain = dskwf_get_setting('sending_domain');
	$message .= "<strong>Tip:</strong> To ensure delivery of your website emails, whitelist all emails coming from a {$sendingDomain} email address and never mark them as spam. Contact your website account representative for details.<br /><br />";
	$message .= "</body></html>";

	//striplashes
	$message = stripslashes($message);

	if(isset($_POST['Subject'])) {$ncSubject = $_POST['Subject'];}
	elseif(isset($_POST['subject'])) {$ncSubject = $_POST['subject'];}
	else {$ncSubject = $nextClient_forms['subject'];}
	$ncSubject = trim($ncSubject);
	if( strlen($ncSubject) == 0 ) {
		$ncSubject = "An email from your website";
	}
	$ncSubject = htmlentities(trim($ncSubject), ENT_NOQUOTES);

	if(dskwf_get_setting("discourage_reply", false)) {
		$email = "";
	} else {
		$email = dskwf_determine_sender_email();
	}
	
	//Will be used below and further down
	$fromName = dskwf_get_setting("smtp_name");
	$fromEmail = dskwf_get_setting("smtp_email");

	if(dskwf_get_setting("discourage_reply", false) || ncEmailReasonabilityCheck($email) !== false) {
		$message = str_replace("*PRE_FORM_CONTENT*", "", $message);
	} else {
		$message = str_replace("*PRE_FORM_CONTENT*", "<strong>Note:</strong> The sender may not have included a valid E-mail address. If you respond to this email it may go to {$fromEmail}, which is not monitored.<br /><br />", $message);
	}	
	
	$emailINFO = array(
		'email' => $email,
		'recipients' => $ncRecipients,
		'subject' => $ncSubject
	);
		
	$ncFormErrors = array();
	if($needsFurtherReview) {
		do_action('dskwebsiteformsneedsfurtherreviewstart');
		$adtlMessage = "";
		if(!empty($devNotes)) {
			$adtlMessage = "<strong>Possible Issues:</strong> <br />{$devNotes}<br /><br />";	
		}
		if(!empty($blacklistedTermNote)) {
			$adtlMessage .= "<strong>First Blacklisted Term(s) Found:</strong> <br />{$blacklistedTermNote}<br /><br />";	
		}
		
		$adtlMessage .= "<strong>Intended Recipient(s):</strong> <br />{$ncRecipients}";
		$adtlMessage .= "</body></html>";
		$message = str_ireplace("</body></html>", $adtlMessage, $message);

		//Send the form submission to the catchall email address for possible spam
		if(returnNCformID() < 1000) {
			$ncRecipients = dskwf_get_setting("email_address_spam");
		} else {
			$ncRecipients = dskwf_get_setting("email_address_spam_ada");
		}
		$emailINFO['recipients'] = $ncRecipients;
	}
	
	if( ncSendGridMail($fromName, $fromEmail, $emailINFO, $message, $attachments) ) {
		dskWFMailSent($needsFurtherReview);
	} elseif( ncPHPmail($fromName, $fromEmail, $emailINFO, $message) ) {
		dskWFMailSent($needsFurtherReview);
	} else {
		dskWebsiteFormsncffcode(4);
	}	
}

function ncWFMailContentType() {
    return "text/html";
}

function dskWFMailSent($needsFurtherReview) {
	if($needsFurtherReview) {
		do_action('dskwebsiteformsneedsfurtherreviewend');
	} else {
		do_action('dskwebsiteformsfullylegitsubmission');	
	}
	ncRedirectAndThanks();	
}
function ncRedirectAndThanks($decoy = false) {
	$ncffcode = dskWebsiteFormsncffcode();
	
	if(!$decoy && $ncffcode != 2) {// Captcha is ok
		do_action('dskwebsiteformspreredirect');	
	}
	
	if(isset($_POST['redirect'])) {
		$redirectionURL = wp_sanitize_redirect($_POST['redirect']);
	} else {$redirectionURL = "/";}
	wp_redirect($redirectionURL);
	exit;
}

function ncSendGridMail($fromName, $fromEmail, $info, $message, $attachments) {
	global $ncFormErrors;
	$headers = array();
	$headers[] = "From: {$fromName} <{$fromEmail}>";	
	$headersNoReply = $headers;
	$sender = $info['email'];
	if(ncEmailReasonabilityCheck($sender)) {
		$headers[] = "Reply-To: {$sender} <{$sender}>";	
	}
	add_filter('wp_mail_content_type', 'ncWFMailContentType');
	$sentSuccessfully = wp_mail($info['recipients'], $info['subject'], $message, $headers, $attachments);
	if(!$sentSuccessfully) {
		//Try resending without replyTo
		$sentSuccessfully = wp_mail($info['recipients'], $info['subject'], $message, $headersNoReply, $attachments);	
	}
	remove_filter('wp_mail_content_type', 'ncWFMailContentType');
	if($sentSuccessfully) {
		return true;
	} else {
		return false;
	}
}

function ncPHPmail($fromName, $fromEmail, $info, $message) {
	$to = $info['recipients'];
	$subject = $info['subject'];
	$headers  = "MIME-Version: 1.0" . "\r\n";
	$headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
	$headers .= "From: {$fromName} <{$fromEmail}>\r\n";
	$sender = $info['email'];
	if(ncEmailReasonabilityCheck($sender)) {
		$headers .= "Reply-To: " . $sender . "\r\n";
	}
	if( mail($to, $subject, $message, $headers) ) {
		return true;
	} else {
		return false;
	}
}

function ncEmailReasonabilityCheck($email) {
	if(stripos($email, ' ') !== false) {
		return false;
	}
	$atPos = stripos($email, '@');
	if($atPos !== false) {
		$uname = substr($email, 0, $atPos);
		if(strlen($uname) > 0) {
			$domain = substr($email, $atPos+1);
			//Looking for additional @s or multiple sequential periods
			if(stripos($domain, '@') !== false || stripos($domain, '..') !== false) {
				return false;
			}
			$domainDot = strripos($domain, '.');
			if(strlen($domain) < 3 || $domainDot === false) {
				return false;
			}
			if(strlen(substr($domain, $domainDot + 1)) < 2) {
				return false;			
			}
		} else {
			return false;
		}
	} else {
		return false;
	}
	return true;
}

function ncPhoneReasonabilityCheck($str) {
	$str = preg_replace('/\s+/', '', $str);

	//check for the presence of letters
	preg_match_all('/[a-z]/i', $str, $alpha);
	$letters = implode('', $alpha[0]);

	//If there are letters, the possible phone are the digits before the first letter
	if($letters !== '') {
		$firstLetter = substr($letters, 0, 1);
		$posFirstLetter = stripos($str, $firstLetter);
		$possiblePhone = substr($str, 0, $posFirstLetter);
	} else {
		$possiblePhone = $str;
	}

	//If there are no digits before the first letter, return false
	if($possiblePhone === '') {return false;}

	//Get all digits
	preg_match_all('!\d+!', $possiblePhone, $digits);
	$phone = implode('', $digits[0]);
	
	//Get the first digit - fail if 0, remove if 1
	$firstDigit = substr($phone, 0, 1);
	if($firstDigit === '0') {	
		return false;
	} elseif($firstDigit === '1') {
		$phone = substr($phone, 1);	
	}

	//return true for 10 digit phones
	if(strlen($phone) == 10) {return true;}	else {return false;}
}

function returnNCformID() {
	$id = $_POST['ncFormSubmission'];	
	if(stripos($id, "form_") !== 0) {return 0;}
	$id = str_replace('form_', '', $id);
	return intval($id);
}

function setThemCharactersStraight($source) {
	//UTF-8 characters
	$search_for =  array("\xe2\x80\x98", "\xe2\x80\x99", "\xe2\x80\x9c", "\xe2\x80\x9d", "\xe2\x80\x93", "\xe2\x80\x94", "\xe2\x80\xa6");
	$replace_with = array("'", "'", '"', '"', '-', '--', '...');
	$result = str_replace($search_for, $replace_with, $source);

	//Windows-1252 characters
	$search_for = array(chr(145), chr(146), chr(147), chr(148), chr(150), chr(151), chr(133));
	$replace_with = array("'", "'", '"', '"', '-', '--', '...');
	$result = str_replace($search_for, $replace_with, $result);
	return $result;
}

add_action( 'init', 'dskRecaptchaTest', 5 );
function dskRecaptchaTest() {
	if(is_admin()) {return false;}
	if (isset($_POST['g-recaptcha-response']) && !empty($_POST['g-recaptcha-response'])) {
		//  your site secret key
		$secret = RECAPTCHA_SECRET_KEY;
		// recaptcha response
		$reCaptchaResponse = $_POST['g-recaptcha-response'];
		//  get verify response data

		$grData = array(
			'secret' => $secret,
			'response' => $reCaptchaResponse
		);
		$grVerify = curl_init();
		curl_setopt($grVerify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");
		curl_setopt($grVerify, CURLOPT_POST, true);
		curl_setopt($grVerify, CURLOPT_POSTFIELDS, http_build_query($grData));
		curl_setopt($grVerify, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($grVerify, CURLOPT_RETURNTRANSFER, true);
		$verifyResponse = curl_exec($grVerify);			
		$responseData = json_decode($verifyResponse);
		if($responseData->success) {
			$_POST['ncFormSubmission'] = $_POST['ncFormSubmissionPH'];
			if(session_id() == '') {session_start();}
			$_POST['nc_captcha'] = "hello_world";
			$_SESSION['dsknc_captcha'] = "hello_world";		
			unset($_POST['ncFormSubmissionPH']);
			unset($_POST['g-recaptcha-response']);
		}
	}
}

function dskWFGetIP() {
	if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
	  $ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$ip = $_SERVER['REMOTE_ADDR'];
	}
	return $ip;
}

function dskupdatefsstatus() {
	if(!isset($_POST['dskupdatefsstatus'])) {return false;}
	if(!isset($_POST['fsid']) || !isset($_POST['fspw'])) {echo 0;}
	$fspaID = intval($_POST['fsid']);
	$fspaPW = $_POST['fspw'];
	$localPW = get_post_meta($fspaID, 'dskwfpw', true);
	if($fspaPW === $localPW) {
		if(get_post_type($fspaID) === 'ncformspa') {
			$result = set_post_type($fspaID, 'ncforms');
			echo $result;			
		} else {
			echo 2; //password matches
		}
	} else {
		echo 0;
	}
	die();
}
add_action( 'init', 'dskupdatefsstatus', 1 );

function dskWFReasonableSingleName($string) {
	if(strlen($string) >= 2) {//Contains at least two characters
		$subString = substr($string, 1);
		preg_match_all('/[A-Z]/', $subString, $matches);
		if(count($matches[0]) === 0) {		    
			return true;
		}
	}
	return false;	
}
function dskWFReasonableFullName($string) {
	$string = trim($string);
	$reasonability = 1;	
	$theNames = explode( " ", $string );
	if(count($theNames) < 2) {
		$reasonability -= 0.5;
	}
	foreach($theNames as $theName) {
		if(!dskWFReasonableSingleName($theName)) {
			$reasonability -= 0.25;
			break;
		}	
	}
	if($reasonability > .25) {
		return true;
	}
	return false;
}

function dskwfBypassCheck($formID, $key) {
	$bypassCheck = false;		
	$bypassCheckSetting = dskwf_get_setting($key);

	if(gettype($bypassCheckSetting) === "boolean") {
		$bypassCheck = $bypassCheckSetting;	
	} elseif(gettype($bypassCheckSetting) === "array") {
		if(in_array($formID, $bypassCheckSetting)) {
			$bypassCheck = true;
		}
	}
	return $bypassCheck;
}

function dskWFBasicValidation() {
	$devNotes = '';
	$formID = returnNCformID();		
	
	//Address old ADA Mirror bug
	if($formID >= 1000 && isset($_POST['Phone'])) {
		$decoyPhoneVal = trim($_POST['Phone']);
		$decoyPhoneVal = strtolower($decoyPhoneVal);
		if($decoyPhoneVal === 'phone') {
			unset($_POST['Phone']);
		}			
	}
	
	if(!dskwfBypassCheck($formID, "bypass_name_check_for_spam")) {
		//Re-Route for Review if the name is suspicious
		if( isset($_POST['Name']) ) {
			if(!dskWFReasonableFullName($_POST['Name'])) {
				$devNotes .=  ' Failed Name Validation;';
			}
		}			
	}

	if(!dskwfBypassCheck($formID, "bypass_email_check_for_spam")) {
		//Re-Route for Review if invalid email address format
		if( !dskwf_get_setting("discourage_reply", false) ) {
			$email = dskwf_determine_sender_email();
			if( empty($email) || !ncEmailReasonabilityCheck($email) ) {
				$devNotes .=  ' Failed Email Validation;';
			}	
		}
	}
	
	$devNotes = trim($devNotes);
	if(!empty($devNotes)) {
		$_POST['Dev_Notes'] = $devNotes;
	}
}

function dskwf_determine_sender_email() {
	$email = "";
	if(isset($_POST['replyTo'])) {
		$emailHolder = trim($_POST['replyTo']);
	} else {
		$emailHolder = "Email_Address";
	}	
	if(isset($_POST[$emailHolder])) {
		$email = trim($_POST[$emailHolder]);	
	}
	return $email;
}

function dskwf_get_setting($key, $returnWhenEmpty = "") {
	if(!defined('DSKWF_SETTINGS')) {
		return $returnWhenEmpty;
	}
	$dskwf_settings = DSKWF_SETTINGS;
	if(isset($dskwf_settings[$key])) {
		return $dskwf_settings[$key];
	} else {
		return $returnWhenEmpty;
	}
}

add_action('init', function(){
	if(!defined("DSKWF_SETTINGS")) {
		/*
		To bypass name/email/phone check, set to true/false. Or, if form-specific, set to array indicating form IDs (no quotes) for those that need a value of true.
		*/
		define('DSKWF_SETTINGS', [
			"discourage_reply" => false,
			"sending_domain" => "site-forms.com",
			"smtp_name" => "Contact Form",
			"smtp_email" => "do_not_reply@site-forms.com",
			"email_address_spam" => "review@site-mail.com",
			"email_address_spam_ada" => "review_ada@site-mail.com",
			"bypass_name_check_for_spam" => false,
			"bypass_email_check_for_spam" => false,
			"bypass_phone_check_for_spam" => false
		]);
	}
}, 0);