<?php
/*
Plugin Name:  Subslide Chooser
Version: 1.0
Author: Enrique Aguilar
Description: Specify a subslide on an entry-specific basis.
*/

add_action( 'add_meta_boxes', 'dsk_subslide_metabox' );
add_action( 'save_post', 'dsk_subslide_save' );

function dsk_subslide_metabox() {
	if(!function_exists('dsk_subslide_chooser_prefs') || !current_user_can( dsk_subslide_chooser_prefs('minCapRequired') )) {return false;}
	
	$thePostTypes = array( 'post', 'page' );
	foreach ($thePostTypes as $thePostType) {
		add_meta_box(
			'dsk_subslide_section',
			__( 'Subslide Chooser', 'dsk_subslide_domain' ),
			'dsk_subslide_mainfunc',
			$thePostType,
			'normal',
			'high'
		);
	}
}
function dsk_subslide_preview_class_builder($classes, $id, $defaultList, $entrySet, $count, $maxVisibleOnLoad) {
	if(in_array($id, $defaultList)) {$classes .= ' inDefaultSet';}
	if(in_array($id, $entrySet)) {$classes .= ' inEntrySet';}	
	if($count > $maxVisibleOnLoad) {$classes .= " subslidePreviewHiddenOnLoad";}
	echo $classes;
}
function dsk_subslide_mainfunc( $post ) {
	if(!function_exists('dsk_subslide_chooser_prefs')) {
		echo "<p><strong>Error:</strong> The Subslide Chooser Prefs function does not exist.</p>";
		return false;
	} elseif($post->ID == get_option('page_on_front')) {
		echo "<p>Not applicable on the homepage.</p>";
		return false;
	}

	// Use nonce for verification
	wp_nonce_field( plugin_basename( __FILE__ ), 'dsk_subslide_noncename' );
	$subslideIDstring = get_post_meta( $post->ID, '_subslideID', true );
	$subslideID = explode(",", $subslideIDstring);		
	$subslideID = array_filter( $subslideID, 'strlen' );
	$maxVisibleOnLoad = dsk_subslide_chooser_prefs("maxVisibleOnLoad");
	$possibleSlideIDs = dsk_subslide_chooser_prefs('allSlideIDs' );
	$possibleSlideIDsCount = count($possibleSlideIDs);
	$defaultSlideIDs = dsk_subslide_chooser_prefs('defaultSlideIDs' );
?>
	<div class="dsk_subslide">
		<input type="text" id="dsk_subslideID" name="dsk_subslideID" value="<?php echo esc_attr($subslideIDstring); ?>" />
		<p>Select one or more images below. Any selections made here may be overridden by preferences set in the actual code of the website.</p>
	<?php if($possibleSlideIDsCount > $maxVisibleOnLoad) { ?>
		<p id="viewAllSubslidePrompt">You are viewing <strong><?php echo $maxVisibleOnLoad; ?></strong> of <strong><?php echo $possibleSlideIDsCount; ?></strong> images available. <a id="viewAllSubslideImages" href="#viewAllSubslidePrompt">View All</a></p>		
	<?php } ?>
	</div>

	<div class="dsk_subslide">
	<?php
		$count = 0;
		foreach($possibleSlideIDs as $id) {
			$count++; ?>
		<div class="<?php dsk_subslide_preview_class_builder('dsk_subslide_preview', $id, $defaultSlideIDs, $subslideID, $count, $maxVisibleOnLoad); ?>" data-subslideid="<?php echo $id; ?>">
			<img src="<?php echo dsk_subslide_chooser_prefs('previewImage', $id); ?>" />
			<span class="slideInEntrySet">&#10004;</span>
			<span class='slideInDefaultSet'>Default Set</span>
		</div>
	<?php } ?>
	</div>
<?php
}

function dsk_subslide_save( $post_id ) {
	if(!isset($_REQUEST['post_type'])) {return;}

	if ( 'page' == $_REQUEST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) {return;}
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) ) {return;}
	}

	// Secondly we need to check if the user intended to change this value.
	if ( ! isset( $_POST['dsk_subslide_noncename'] ) || ! wp_verify_nonce( $_POST['dsk_subslide_noncename'], plugin_basename( __FILE__ ) ) )
	  return;

	// Thirdly we can save the value to the database

	//if saving in a custom table, get post_ID
	$post_ID = $_POST['post_ID'];

	$subslideID = sanitize_text_field( $_POST['dsk_subslideID'] );
	$subslideID = trim($subslideID);
	update_post_meta($post_ID, '_subslideID', $subslideID);
}

function dsk_subslide_enqueue($hook) {
    if( 'post.php' != $hook && 'post-new.php' != $hook ) return;
 	wp_register_style( 'dsk_subslide_css', plugins_url('/css/style.css', __FILE__ ), false, '1.0.0' );
	wp_register_script( 'dsk_subslide_script', plugins_url('/js/script.js', __FILE__), array('jquery'), '1.0.0' );
	wp_enqueue_style( 'dsk_subslide_css' );
	wp_enqueue_script( 'dsk_subslide_script' );
}
add_action( 'admin_enqueue_scripts', 'dsk_subslide_enqueue' );

function fetch_subslide_id() {
	if(!function_exists('dsk_subslide_chooser_prefs')) {
		return "ERROR: The Subslide Chooser Prefs function does not exist.";
	}
	$curObjectID = get_queried_object_id();
	$IDinDB = get_post_meta( $curObjectID, '_subslideID', true );	
	$IDinDB = trim($IDinDB);
	$allIDs = explode(",", $IDinDB);		
	$allIDs = array_filter( $allIDs, 'strlen' );
	$slidesCount = count($allIDs);
	if($slidesCount == 0) {
		$id = false;
	} else {
		shuffle($allIDs);
		$id = intval($allIDs[0]);		
	}
	$possibleSlideIDs = dsk_subslide_chooser_prefs('allSlideIDs');
	if(!$id || !is_int($id) || !in_array($id, $possibleSlideIDs)) {
		$defaultSlideIDs = dsk_subslide_chooser_prefs('defaultSlideIDs');
		shuffle($defaultSlideIDs);
		$id = $defaultSlideIDs[0];
	}
	return intval($id);
}
?>