<?php
/**
 * Sitemap settings page
 *
 * @package XML Sitemap & Google News
 */

?>
<style type="text/css">
<?php include XMLSF_DIR . '/assets/admin.css'; ?>
</style>
<div class="wrap">

	<h1><?php esc_html_e( 'XML Sitemap', 'xml-sitemap-feed' ); ?></h1>

	<p>
		<?php printf( /* translators: Plugin name */ esc_html__( 'These settings control the XML Sitemaps generated by the %s plugin.', 'xml-sitemap-feed' ), esc_html__( 'XML Sitemap & Google News', 'xml-sitemap-feed' ) ); ?>
	</p>

	<nav class="nav-tab-wrapper">
		<a class="nav-tab<?php echo 'general' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=general'; ?>"><?php echo esc_html( translate( 'General' ) ); ?></a>
		<a class="nav-tab<?php echo 'post_types' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=post_types'; ?>"><?php esc_attr_e( 'Post types', 'xml-sitemap-feed' ); ?></a>
		<?php
		if ( empty( $disabled ) || ! in_array( 'taxonomies', (array) $disabled, true ) ) {
			?>
		<a class="nav-tab<?php echo 'taxonomies' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=taxonomies'; ?>"><?php esc_attr_e( 'Taxonomies', 'xml-sitemap-feed' ); ?></a>
			<?php
		}
		if ( empty( $disabled ) || ! in_array( 'users', (array) $disabled, true ) ) {
			?>
		<a class="nav-tab<?php echo 'authors' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=authors'; ?>"><?php esc_attr_e( 'Authors', 'xml-sitemap-feed' ); ?></a>
			<?php
		}
		?>
		<a class="nav-tab<?php echo 'advanced' === $active_tab ? ' nav-tab-active' : '" href="?page=xmlsf&tab=advanced'; ?>"><?php echo esc_html( translate( 'Advanced' ) ); ?></a>
		<?php do_action( 'xmlsf_sitemap_nav_tabs', $active_tab ); ?>
	</nav>

	<div class="main">
		<form id="xmlsf-settings-form" method="post" action="options.php">

			<?php settings_fields( 'xmlsf_' . $active_tab ); ?>

			<?php do_settings_sections( 'xmlsf_' . $active_tab ); ?>

			<?php submit_button(); ?>

		</form>
	</div>

	<div class="sidebar">
		<h3><span class="dashicons dashicons-welcome-view-site"></span> <?php echo esc_html( translate( 'View' ) ); ?></h3>
		<p>
			<?php
			printf(
				/* translators: Sitemap name with URL */
				esc_html__( 'Open your %s', 'xml-sitemap-feed' ),
				'<strong><a href="' . esc_attr( $sitemap_url ) . '" target="_blank">' . esc_html__( 'XML Sitemap Index', 'xml-sitemap-feed' ) . '</a></strong><span class="dashicons dashicons-external"></span>'
			);
			?>
		</p>

		<h3><span class="dashicons dashicons-admin-tools"></span> <?php echo esc_html( translate( 'Tools' ) ); ?></h3>
		<form action="" method="post">
			<?php wp_nonce_field( XMLSF_BASENAME . '-help', '_xmlsf_help_nonce' ); ?>
			<p>
				<input type="submit" name="xmlsf-flush-rewrite-rules" class="button button-small" value="<?php esc_attr_e( 'Flush rewrite rules', 'xml-sitemap-feed' ); ?>" />
				<input type="submit" name="xmlsf-check-conflicts-sitemap" class="button button-small" value="<?php esc_attr_e( 'Check for conflicts', 'xml-sitemap-feed' ); ?>" />
			</p>
			<p>
				<?php // TODO add button(s) to prime medadata. ?>
				<input type="submit" name="xmlsf-clear-post-meta" class="button button-small" value="<?php esc_attr_e( 'Clear post cache', 'xml-sitemap-feed' ); ?>" />
				<input type="submit" name="xmlsf-clear-term-meta" class="button button-small" value="<?php esc_attr_e( 'Clear term cache', 'xml-sitemap-feed' ); ?>" />
				<input type="submit" name="xmlsf-clear-user-meta" class="button button-small" value="<?php esc_attr_e( 'Clear user cache', 'xml-sitemap-feed' ); ?>" />
			</p>
			<p>
				<input type="submit" name="xmlsf-clear-settings-sitemap" class="button button-small button-link-delete" value="<?php esc_attr_e( 'Reset settings', 'xml-sitemap-feed' ); ?>" onclick="javascript:return confirm('<?php echo esc_js( __( 'This will revert your sitemap settings to the plugin defaults.', 'xml-sitemap-feed' ) ); ?>\n\n<?php echo esc_js( translate( 'Are you sure you want to do this?' ) ); ?>')" />
			</p>
		</form>

		<?php do_action( 'xmlsf_admin_sidebar' ); ?>

	</div>

</div>
<script>
document.addEventListener('DOMContentLoaded', function () {
	var mainform, isSubmitting = false;
	jQuery(document).ready(function () {
		mainform = jQuery('#xmlsf-settings-form');
		mainform.submit(function(){
			isSubmitting = true
		})
		mainform.data('initial-state', mainform.serialize());
		jQuery(window).on('beforeunload', function(event) {
			if (!isSubmitting && mainform.length && mainform.serialize() != mainform.data('initial-state')){
				event.preventDefault();
				return "<?php esc_html_e( 'The changes you made will be lost if you navigate away from this page.' ); ?>";
			}
		});
	});
}, false );
</script>
