<?php

// START Register Navigations
register_nav_menus (
	array (
		'main-nav' => 'Main',
		'footer-nav' => 'Footer'
	)
);
// END Register Navigations

//Uncomment line below and set it to desired tag line for the main blog page:
//$nc_blog_home_tagline = 'Recent Blog Posts';

//Uncomment line below to allow automatic feeds - when client requests them
//add_theme_support( 'automatic-feed-links' );

add_filter ('jetpack_implode_frontend_css', '__return_false');
add_filter( 'jetpack_enable_open_graph', '__return_false' );

include_once('includes/data-core.php');

//  < mc_read_more_btn >
function nc_shortcode_read_more( $atts ) {
	$action = $atts['action'];
	if ( $action == 'open' ) {
		return <<<EOHTML
		<div class='mc_hidden'>
EOHTML;
	} else if ( $action == 'close' ) {
		return <<<EOHTML
		</div>
EOHTML;
	} else if ( $action == 'btn' ) {
		return <<<EOHTML
		<div class='mc_read_more'>
			<a href="#">View More</a>
		</div>
EOHTML;
	} else {
		return "<p>THE nc_read_more SHORTCODE WAS ENTERED INCORRECTLY</p>";
	}
}
add_shortcode( 'nc_read_more', 'nc_shortcode_read_more' );
//  </ mc_read_more_btn >

function dskvimeofunc($atts) {
	$id = $atts['id'];
	return <<<EOT
		<div class="vimeo-embed-cont">
			<iframe src="https://player.vimeo.com/video/{$id}?title=0&amp;byline=0&amp;portrait=0" allowfullscreen></iframe>
		</div>
EOT;
}
add_shortcode('vimeo', 'dskvimeofunc');

function dsk_subslide_chooser_prefs($task, $id = 0) {
	if($task == 'allSlideIDs') {return range(1, 8);}
	elseif($task == 'defaultSlideIDs') {return array(1, 3, 5);}
	elseif($task == 'previewImage') {
		return get_stylesheet_directory_uri() . "/img/slides/sub/1120/slides-sub-{$id}.jpg";
	} elseif($task == "maxVisibleOnLoad") {
		return 10;
	} elseif($task == "minCapRequired") {
		$adminOnly = true;
		if($adminOnly) {return "activate_plugins";}
		else {return "delete_others_pages";}
	}
	return false;
}

function nc_fn_mc_firm_cta($atts) {
	return <<<EOT

		<div class="mc_our_firm_cta">
			<ul>
				<li class="item_1"><a href="tel:+18132424404"><p>Click To Call Us <br>Today</p><b>1 (813) 242-4404</b></a></li>
				<li class="item_2"><a href="/contact-us/" rel="nofollow"><p>Schedule a <br>Consultation</p><b>CONTACT US</b></a></li>
			</ul>
		</div>
EOT;
}
add_shortcode('mc_firm_cta', 'nc_fn_mc_firm_cta');

if(!function_exists('nc_generate_more_posts_by_author_link')) {
	function nc_generate_more_posts_by_author_link() {
		global $authordata;
        $theAuthorID = isset( $authordata->ID ) ? $authordata->ID : 0;
		$defaultName = get_option('dsk_author_default_name', '');
		$defaultName = stripslashes($defaultName);
		$uniqueNames = get_option('dsk_authors_with_unique_name', []);
		if($defaultName && !in_array($theAuthorID, $uniqueNames)) {
			$theAuthorName = $defaultName;
		} else {
			$theAuthorName = get_the_author();			
		}
		return $theAuthorName;	
	}
}

function ncModTime() {
	if(isset($_GET['modding'])) {
		return time();
	} else {
		return 2024;
	}
}

