(function ($) {
	var htmlEL = $('html'),
	bodyEL = $('body'),
	htmlAndBody = $('html, body'),
	isFrontPage = bodyEL.hasClass('home'),
	rTO,
	mainMenu = $('#mainMenu'),
	syncMenu = $('#syncMenu'),
	fsMenuOn = false,
	lastPos,
	menuToggle = $('.menuToggle');

	if( isFrontPage ) {
		$('.homeslides').dsk_slides({
			slideClass : 'homeslide',
			effect : 'fade',
			pause: 7000,
			speed: 400,
			onInit: function() {
				setTimeout(function() {
					$('.homeslide_1').addClass('slide_text_animate');
				}, 400);
				setTimeout(function() {
					$('.homeslide_1').addClass('slide_text_animate_2');
				}, 1200);
				setTimeout(function() {
					$('.homeslide_1').addClass('slide_text_animate_3');
				}, 2000);
			},
			onStart: function() {
				setTimeout(function() {
					$('.incomingSlide').addClass('slide_text_animate');
				}, 400);
				setTimeout(function() {
					$('.incomingSlide').addClass('slide_text_animate_2');
				}, 1200);
				setTimeout(function() {
					$('.incomingSlide').addClass('slide_text_animate_3');
				}, 2000);
			},
			onComplete: function() {
				setTimeout(function() {
					$('.outgoingSlide').removeClass('slide_text_animate');
				}, 400);
				setTimeout(function() {
					$('.outgoingSlide').removeClass('slide_text_animate_2');
				}, 1200);
				setTimeout(function() {
					$('.outgoingSlide').removeClass('slide_text_animate_3');
				}, 2000);
			}
		});
	}

	function bodyMenuClassToggle(goMob) {
		if(goMob) {bodyEL.removeClass('dsktp_menu').addClass('mob_menu');}
		else {bodyEL.removeClass('mob_menu').addClass('dsktp_menu');}
	}
	function mmToggle(goMob) {
		if(goMob) {mainMenu.removeClass('mm').addClass('mm_mob');}
		else {mainMenu.removeClass('mm_mob').addClass('mm');}
	}
	function menuer() {
		if(syncMenu.css('z-index') == 1) {
			bodyMenuClassToggle(false);
			if(!fsMenuOn) {mmToggle(false);}
		} else {
			bodyMenuClassToggle(true);
			if(!fsMenuOn) {mmToggle(true);}
		}
	}
	function fullScreenMenu(enableFS) {
		if(enableFS) {
			fsMenuOn = true;
			lastPos = bodyEL.scrollTop();
			if(lastPos == 0) {lastPos = htmlEL.scrollTop();}
			bodyEL.addClass('fsMenuOn');
			htmlAndBody.animate({scrollTop: 0}, 0);
			mmToggle(true);
		} else {
			fsMenuOn = false;
			bodyEL.removeClass('fsMenuOn');
			htmlAndBody.animate({scrollTop: lastPos}, 0);
			menuer();
		}
	}
	menuToggle.click(function(e){
		e.preventDefault();
		if(!fsMenuOn) {fullScreenMenu(true);}
		else {fullScreenMenu(false);}
	});

	var stickyZone = false,
	isTouchDevice = 'ontouchstart' in window || 'onmsgesturechange' in window;
	function stickyMenu() {
		if( $(window).scrollTop() > 50 ) {
			if(stickyZone) {return;}
			bodyEL.addClass('sticky_zone');
			stickyZone = true;
		} else {
			if(!stickyZone) {return;}
			bodyEL.removeClass('sticky_zone');
			stickyZone = false;
		}
	}

	$("#menu-item-3565").addClass('multiCol');
	$("#menu-item-3588").addClass('multiCol');

	//Makes left and right anchors the same height
	$('.multiCol').hover(function(){
		if($('nav.mm').length === 0) {return false;}
		var directAnchors = $(this).children('ul').children('li').children('a'),
		count = 0, leftAnchor, leftAnchorHeight, rightAnchor, rightAnchorHeight;
		directAnchors.each(function(){
			var curAnchor = $(this);
			curAnchor.height('auto');
			var curAnchorHeight = curAnchor.height();
			count++;
			if(count % 2 != 0) {//odd
				leftAnchor = curAnchor;
				leftAnchorHeight = curAnchorHeight;
			} else {
				rightAnchor = curAnchor;
				rightAnchorHeight = curAnchorHeight;
				if(rightAnchorHeight > leftAnchorHeight) {
					leftAnchor.height(rightAnchorHeight);
					rightAnchor.height(rightAnchorHeight);
				} else {
					leftAnchor.height(leftAnchorHeight);
					rightAnchor.height(leftAnchorHeight);
				}
			}
		});
	});

	//  < sxn_marketing_areas >
	sync_marketing_contact_page = $('#sync_marketing_contact_page')
	function sxn_marketing_areas() {
		if ( sync_marketing_contact_page.css('z-index') == 1 ) {
			var marketing_contact_page = $('.sxn_marketing_contact_page ul .item_1 p').outerHeight();
			$('.sxn_marketing_contact_page ul .item_2 p').css('min-height', marketing_contact_page );
			$('.sxn_marketing_contact_page ul .item_3 p').css('min-height', marketing_contact_page );
		} else {
			$('.sxn_marketing_contact_page ul .item_2 p').css('min-height', 'inherit' );
			$('.sxn_marketing_contact_page ul .item_3 p').css('min-height', 'inherit' );
		}
	}
	sync_mc_locations = $('#sync_mc_locations')
	function sxn_mc_locations() {
		if ( sync_mc_locations.css('z-index') == 1 ) {
			var mc_locations = $('.mc_locations .list_addresses li[data-core-index=3]').outerHeight();
			$('.mc_locations .list_addresses li[data-core-index=6]').css('min-height', mc_locations );
		} else {
			$('.mc_locations .list_addresses li[data-core-index=6]').css('min-height', 'inherit' );
		}
	}
	//  </ sxn_marketing_areas >

	//  < mc_locations >
	$( '.mc_locations .list_addresses .item_1' ).addClass('active');
	$( '.mc_locations .list_maps .item_1' ).addClass('active');
	$( '.mc_locations .list_addresses li .cont_address' ).click(function(e) {
		e.preventDefault();
		e.stopPropagation();

		var el_button = $( '.mc_locations .list_addresses' )
		var el_content = $( '.mc_locations .list_maps' );
		var current_data_index = $(this).parent().data('core-index');

		el_button.children().removeClass('active');
		$( this ).parent().addClass('active');
		el_content.children().removeClass( 'active' );
		el_content.find("[data-core-index='" + current_data_index + "']" ).addClass('active');
	});
	//  </ mc_locations >

	//  < animate on scroll >
	var $animation_elements = $('.animated');
	function check_if_in_view() {
		var window_height = $(window).height();
		var window_top_position = $(window).scrollTop();
		var window_bottom_position = (window_top_position + window_height);

		$.each($animation_elements, function() {
			var $element = $(this);
			var element_top_position = $element.offset().top;
			var element_bottom_position = (element_top_position + $element.outerHeight());

			if ((element_bottom_position - .1*window_height >= window_top_position) && (element_top_position + .1*window_height <= window_bottom_position)) {
				var desiredAnimation = $element.data('animation') ? $element.data('animation') : "fadeIn";
				$element.addClass(desiredAnimation + " officiallyAnimated");
			}
		});
	}

	$(window).on('scroll resize', check_if_in_view);
	$(window).trigger('scroll');
	//  </ animate on scroll >

	//  < mc_read_more_btn >
	if ( isFrontPage ) {
		//  click
		$('.article .mc_read_more a').click(function(e) {
			e.preventDefault();
			e.stopPropagation();
			$('.article .mc_hidden').toggleClass('active');
			$('.article .mc_read_more a').toggleClass('active');
			if ( $('.article .mc_hidden').hasClass('active') ) {
				$('.article .mc_read_more a').text("View Less");
			} else {
				$('.article .mc_read_more a').text("View More");
			}
		});
	}
	//  </ mc_read_more_btn >

	//  < sxn_about >
	if ( isFrontPage ) {
		//  click
		$('.sxn_about .cont_read_more a').click(function(e) {
			e.preventDefault();
			e.stopPropagation();
			$('.sxn_about .mc_hidden').toggleClass('active');
			$('.sxn_about .cont_read_more a').toggleClass('active');
			if ( $('.mc_hidden').hasClass('active') ) {
				$('.sxn_about .cont_read_more a').text("View Less");
			} else {
				$('.sxn_about .cont_read_more a').text("View More");
			}
		});
	}
	//  </ sxn_about >

	//  < sidebar balancing >
	var body_sb_class = "",
	syncSidebar = $('#syncSidebar'),
	sb_custom_layout = $('.sb_custom_layout').length === 1;
	function body_sidebar_class() {
		if(sb_custom_layout) {return false;}
		var prev_body_sb_class = body_sb_class;
		if(syncSidebar.css('z-index') == 0) {
			body_sb_class = "sb_largest";
		} else {
			var mcHeight = $('#mainContent').height(),
			new_body_sb_class;
			if(mcHeight > 2400) {
				body_sb_class = "sb_largest";
			} else if(mcHeight > 1300) {
				body_sb_class = "sb_large";
			} else if(mcHeight > 820) {
				body_sb_class = "sb_medium";
			} else {
				body_sb_class = "sb_short";
			}
		}
		if(body_sb_class != prev_body_sb_class) {
			bodyEL.removeClass('sb_short sb_medium sb_large sb_largest').addClass(body_sb_class);
		}
	}
	//  </ sidebar balancing >

	//  < sb_testimonials.slick >
	$('.sb_testimonials .element_slide').slick({
		adaptiveHeight: false,
		arrows: false,
		infinite: true,
		mobileFirst: true,
		slidesToShow: 1,
		slidesToScroll: 1
	});
	//  </ sb_testimonials.slick >

	//  < sxn_testimonials.slick >
	//  disable default link behavior
	$('.sxn_testimonials .element_arrows a').click(function(e){
		e.preventDefault();
	});
	$('.sxn_testimonials .element_slide').slick({
		adaptiveHeight: false,
		infinite: true,
		mobileFirst: true,
		slidesToShow: 1,
		slidesToScroll: 1,
		prevArrow: $('.sxn_testimonials .prev_slide'),
		nextArrow: $('.sxn_testimonials .next_slide'),
	});
	//  </ sxn_testimonials.slick >

	//  < sxn_community.slick >
	//  disable default link behavior
	$('.sxn_community .element_arrows_photos a').click(function(e){
		e.preventDefault();
	});
	$('.sxn_community .element_slide_photos').slick({
		adaptiveHeight: false,
		autoplay: true,
		infinite: true,
		mobileFirst: true,
		slidesToShow: 1,
		slidesToScroll: 1,
		prevArrow: $('.sxn_community .element_arrows_photos .prev_slide'),
		nextArrow: $('.sxn_community .element_arrows_photos .next_slide'),
		responsive: [
			{
				breakpoint: 599,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 1
				}
			},
			{
				breakpoint: 799,
				settings: {
					slidesToShow: 3,
					slidesToScroll: 1
				}
			}
		]
	});
	//  </ sxn_community.slick >

	//  < sxn_community.slick >
	//  disable default link behavior
	$('.sxn_community .element_arrows_logos a').click(function(e){
		e.preventDefault();
	});
	$('.sxn_community .element_slide_logos').slick({
		prevArrow: $('.sxn_community .element_arrows_logos .prev_slide'),
		nextArrow: $('.sxn_community .element_arrows_logos .next_slide'),
		arrows: false,
		autoplay: true,
		autoplaySpeed: 0,
		cssEase: 'linear',
		dots: false,
		infinite: true,
		speed: 4000,
		slidesToShow: 2,
		pauseOnHover: false,
		centerMode: true,
		variableWidth: true
	});
	//  </ sxn_community.slick >

	/*  < modal window >  */
	var modal_search_window = $('.sxn_modal_search');
	var modal_search = document.getElementsByClassName('sxn_modal_search')[0];
	$('.nav_mm_nav_search').click(function(e){
		e.preventDefault();
		modal_search_window.fadeIn();
		$('.sxn_modal_search input')[0].focus();
	})
	if (modal_search_window.length === 1) {
		$('.sxn_modal_link_close').click(function(e){
			e.preventDefault();
			modal_search_window.fadeOut();
		})
	}

	var modal_form_window = $('.sxn_modal_form');
	var modal_form = document.getElementsByClassName('sxn_modal_form')[0];
	$('.sxn_marketing_contact_page .item_1 a, .article .mc_form_link a').click(function(e){
		e.preventDefault();
		modal_form_window.fadeIn();
	})
	if (modal_form_window.length === 1) {
		$('.sxn_modal_link_close').click(function(e){
			e.preventDefault();
			modal_form_window.fadeOut();
		})
	}

	window.onclick = function(event) {
		if (event.target == modal_search) {
			modal_search_window.fadeOut();
		}
		if (event.target == modal_form) {
			modal_form_window.fadeOut();
		}
	}
	/*  </ modal window >  */

	//Chat button on contact page
	$('#dskChatWithUsLink').click(function(){
		var apexChatURL = 'https://www.apex.live/pages/chat.aspx?companyId=15019';
		apexChatURL += '&requestedAgentId=25&originalReferrer=';
		apexChatURL += document.referrer;
		apexChatURL += '&referrer=';
		apexChatURL += window.location.href;
		window.open(apexChatURL,'','width=440,height=680');
	})

	//  < init >
	menuer();
	//	if(isTouchDevice) {animation_elements.removeClass('animated');}
	if(isTouchDevice) {$('.homeslide_img').addClass('ie_slide');}
	stickyMenu();
	body_sidebar_class();
	sxn_marketing_areas();
	sxn_mc_locations();
	//  </ init >

	//  < resize >
	$(window).resize(function(){
		rTO = setTimeout(function(){
			clearTimeout(rTO);
			menuer();
			stickyMenu();
			body_sidebar_class();
			sxn_marketing_areas();
			sxn_mc_locations();
		}, 100);
	});
	//  </ resize >

	//  < scroll >
	$(window).on({'scroll touchmove': function(){
		stickyMenu();
	}});
	//  </ scroll >

	//  < allow dropdowns on touchscreens >
	(function(){var touchedScreen = false;
	window.addEventListener('touchstart', function() {
		touchedScreen = true;
	});
	$('nav.mm a').click(function(e){
		if(!touchedScreen) {return true;}
		var clickedItem = $(this);
		if(clickedItem.siblings('ul').length === 0) {
			return true;
		}
		var clickedAttr = clickedItem.attr('data-clicked');
		if(typeof clickedAttr === typeof undefined) {
			e.preventDefault();
			clickedItem.attr('data-clicked', '1');
		}
	});})();
	//  </ allow dropdowns on touchscreens >
	//  < sharing icons >
	(function(){
		$('a.dskSharingIcon').click(function(){
			var url = $(this).data('url');
			$(this).attr('href', url);
		});
	})();
	//  </ sharing icons >
}(jQuery));

(function(){var head=document.getElementsByTagName("head")[0],fonts=document.createElement("link");fonts.rel="stylesheet",fonts.type="text/css",fonts.href="https://fonts.googleapis.com/css?family=Open+Sans:400,400i,700,700i|Montserrat:300,300i,400,400i,700,700i&display=fallback",fonts.media="all",head.appendChild(fonts);
})();

//Form Submissions
var thegrFormBeingSubmitted, thegrWidgetID;
function grFormValidation() {
	//When all validity tests are passed...
	grecaptcha.execute(thegrWidgetID);
}
function grOnloadCallback() {
	var allRecConts = document.getElementsByClassName('googleRecaptchaBox');
	for(var ii = 0; ii < allRecConts.length; ii++) {
		var curRecCont = allRecConts[ii];
		var theWidgetIDname = curRecCont.getAttribute('id');
		var theWidgetIDtemp = grecaptcha.render(theWidgetIDname, {
			'callback' : function() {thegrFormBeingSubmitted.submit();},
			'size' : 'invisible'
		});
		var theWidget = document.getElementById(theWidgetIDname);
		theWidget.setAttribute('data-rcwidgetid', theWidgetIDtemp);
	}
	var thegrSubmitBTNs = document.getElementsByClassName('grSubmitBTN');
	for(var ii = 00; ii < thegrSubmitBTNs.length; ii++) {
		var curgrSubmitBTN = thegrSubmitBTNs[ii];
		curgrSubmitBTN.addEventListener('click', function(e){
			e.preventDefault();
			thegrFormBeingSubmitted = this.form;
			var theWidget = thegrFormBeingSubmitted.getElementsByClassName('googleRecaptchaBox')[0];
			thegrWidgetID = theWidget.getAttribute('data-rcwidgetid');
			grFormValidation();
		});
	}
}
//Form Submissions - Ends

head.load("https://www.google.com/recaptcha/api.js?onload=grOnloadCallback&render=explicit");

(function(){
	// Vimeo Modal Window
	var modalContent = document.createElement('div');
	modalContent.classList.add('vmContent');
	var vimVidWrap = document.createElement('div');
	vimVidWrap.classList.add('vimeo-embed-cont');
	var vimVid = document.createElement('iframe');
	vimVid.classList.add('vm-video');
	vimVidWrap.appendChild(vimVid);
	modalContent.appendChild(vimVidWrap);
	var theBody = document.querySelector('body');
	//Create + Append Modal Window
	var vimeoLinks = document.querySelectorAll('a[data-vimeo]');
	for (var i = 0; i < vimeoLinks.length; i++) {
		vimeoLinks[i].addEventListener('click', function(e){
			e.preventDefault();
			//Set Vid Source
			var videoID = this.getAttribute('data-vimeo');
			var vimSrc = "https://player.vimeo.com/video/" + videoID + "?autoplay=true";
			vimVid.setAttribute('src', vimSrc);

			//Append Video + Modal
			var modal = document.createElement('div');
			modal.classList.add('vimeo-modal');

			modal.appendChild(modalContent);
			theBody.appendChild(modal);

			//Remove Modal Window
			modal.addEventListener('click',function(){
				theBody.removeChild(modal);
			});
		});
	}
})();

(function ($) {
	//Begins - Get More Posts - Ajax
	if($('body.blog, body.category').length > 0) {
		var mainContentZone = $('#mainContent');
		var thePath = window.location.pathname;
		var thePageStart = 1;
		if($('body').hasClass('paged')) {
			var pageSlugStarts = thePath.lastIndexOf('/page/');
			var pathRightSide = thePath.slice(pageSlugStarts);
			var theRegEx = /\/page\/\d+\//g;
			var theMatch = theRegEx.exec(pathRightSide);
			thePageStart = theMatch[0];
			//Determine page num
			thePageStart = thePageStart.replace('page', '');
			while(thePageStart.indexOf('/') != -1) {
				thePageStart = thePageStart.replace('/', '');
			}
			thePageStart = parseInt(thePageStart);
			//Cleaning up path - excluding the bits including/after '/page/'
			thePath = thePath.slice(0, pageSlugStarts);
		}
		//End thePath with a slash
		if(thePath.substr(-1) !== '/') {
			thePath += '/';
		}
		//Determine pageCountMax
		var maxPagesTotal;
		$.get(thePath + '?dsk_coapl=1&dsk_coapl_pages_total=1', function(data) {
			maxPagesTotal = parseInt(data);
			if(isNaN(maxPagesTotal)) {
				maxPagesTotal = 1;
			}
			thePath += 'page/';
			var pageCounter = thePageStart + 1;
			var thePostsURL = thePath + pageCounter + '?dsk_coapl';
			var thePostsHTML;
			if(pageCounter <= maxPagesTotal) {
				mainContentZone.append("<a id='univ_load_more_posts'>Load More Posts</a>");
				var univLoadMorePosts = $('#univ_load_more_posts');
				var loadingPosts = false;
				univLoadMorePosts.on('click', function(){
					if(loadingPosts) {return false;}
					loadingPosts = true;
					univLoadMorePosts.html('Loading Posts...');
					thePostsURL = thePath + pageCounter + '?dsk_coapl';
					$.get(thePostsURL, function(morePosts) {
						$(morePosts).insertBefore(univLoadMorePosts);
						pageCounter++;
						if(pageCounter > maxPagesTotal) {
							univLoadMorePosts.remove();
						} else {
							loadingPosts = false;
							univLoadMorePosts.html('Load More Posts');
						}
					});
				});
			}
		});
	}
	//Ends - Get More Posts - Ajax
})(jQuery);

(function ($) {
	var lazyElements = $('.delayLoad');
	var windowHeight = $(window).height();
	var processing;
	var sTO;
	var lastRanScroll = $.now();
	function lazyLoadEm() {
		processing = true;
		lazyElements.each(function(theIndex, item){
			if(!$(item).hasClass('delayLoad')) {return true;}
			var lazyElPos = $(item).offset();
			var scrollNeeded = lazyElPos.top - windowHeight;
			var docOffset = $(window).scrollTop();
			if (docOffset > (scrollNeeded - 500)) {
				if ($(item).attr("data-src")) {
					var newSRC = $(item).attr("data-src");
					$(item).attr("src", newSRC).removeAttr("data-src");
				} else {
					$(item).addClass('imgSet');
				}
				$(item).removeClass('delayLoad')
			}
		});
		processing = false;
		lastRanScroll = $.now();
	}
	lazyLoadEm();
	$(window).on({'scroll touchmove': function(){
		if(!processing && $.now() > lastRanScroll + 500 ) {
			lazyLoadEm();
		}
	}});
	$(window).resize(function(){
		clearTimeout(sTO);
		sTO = setTimeout(function(){
			windowHeight = $(window).height();
		}, 100);
	});

}(jQuery));