<?php

function dskPrintRecentPosts() {
	if(!is_singular('post')) {return false;}
	dskUnivDefineThePostCategory();
	if(defined('DSK_UNIV_POST_CATEGORY')) {
		$args = [
			'numberposts' => 5,
			'category' => DSK_UNIV_POST_CATEGORY,
			'orderby' => 'post_date',
			'order' => 'DESC',
			'post_type' => 'post',
			'post_status' => 'publish',
			'exclude' => get_the_ID(),
		];
		$theRecentPosts = wp_get_recent_posts($args);
		if(count($theRecentPosts) > 0) {
			$termID = DSK_UNIV_POST_CATEGORY;
			$theTerm = get_term($termID);
			$termName = $theTerm->name;

			$recentPostsHeadline = "More on <em>{$termName}</em>";
		} else {
			$recentPostsHeadline = "Most Recent Entries";
			$args = [
				'numberposts' => 5,
				'orderby' => 'post_date',
				'order' => 'DESC',
				'post_type' => 'post',
				'post_status' => 'publish',
				'exclude' => get_the_ID(),
			];
			$theRecentPosts = wp_get_recent_posts($args);
		}
		if(count($theRecentPosts) > 0) {
			echo "<h2>{$recentPostsHeadline}</h2>";
			echo "<ul class='sbRecentPostsList'>";
			foreach($theRecentPosts as $recentPost) {
				$permalink = get_permalink($recentPost['ID']);
				$title = $recentPost['post_title'];
				echo "<li><a href='{$permalink}'>{$title}</a></li>";
			}
			echo "</ul>";
		}
	}
}

function sb_blog_tags() {
	if (!is_page()) { ?>
	<div class="sb_bucket sb_blog_tags">
		<?php dskPrintRecentPosts() ?>
		<h2>Archives</h2>
		<ul>
			<?php wp_get_archives( array( 'type' => 'monthly', 'limit' => '5', 'format' => 'html', 'before' => '', 'after' => '', 'show_post_count' => false, 'echo' => 1 ) ); ?>
		</ul>
		<h2>Categories</h2>
		<ul>
			<?php wp_list_categories( array( 'orderby' => 'name', 'order' => 'ASC', 'show_last_update' => 1, 'style' => 'list', 'show_count' => false, 'hide_empty' => 1, 'hierarchical' => true, 'title_li' => '', 'show_option_none' => 'No categories', 'taxonomy' => 'category' ) );  ?>
		</ul>
	</div>
	<?php }
}
function sb_photo() { ?>
	<div class="sb_bucket sb_photo">
		<div><img class="delayLoad" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" data-src="<?php echo get_stylesheet_directory_uri(); ?>/img/sb/photo/sb-photo-1-v3.jpg" alt="Tampa Injury"></div>
	</div>
<?php }
function sb_practice_areas() { ?>
	<div class="sb_bucket sb_practice_areas">
		<h2>We can Help you With <br>the Following Cases:</h2>
		<?php sxn_core_practice_areas(); ?>
	</div>
<?php }
function sb_testimonials() { ?>
	<div class="sb_bucket sb_testimonials delayLoad">
		<h2>Client Testimonials</h2>
		<?php sb_core_testimonials(); ?>
	</div>
<?php }
function sb_form() { ?>
	<div class='sb_bucket sb_form'>
		<h2><span>Schedule a</span> Free Consultation</h2>
		<?php nextclient_form( 6 ); ?>
	</div>
<?php }
function sb_custom_layout() { ?>
	<div class="sb_custom_layout"></div>
<?php } ?>
<div id="sidebar" class="sidebar">
<?php
if ( is_front_page() ) {
	sb_photo();
} else if ( is_page( 2473 ) ) {
	sb_form();
} else {
	sb_blog_tags();
	sb_practice_areas();
	sb_testimonials();
}
?>
</div><!-- sidebar -->