/*
* DSK Slides, A Slideshow Plugin for jQuery
* By: DSKmedia, http://dskmedia.com
* Version: 1.0.2
* Updated: June 16, 2015
*/
(function($) {
	$.fn.dsk_slides = function( options ) {
        var settings = $.extend({
			pause : 5000,
			speed : 1200,
			auto : true,
			start : 1,
			effect : 'fade',
			slideClass : false,
			activeSlideClass : 'activeSlide',
			nav : false,
			activeNavClass : 'activeNavButton',
			incomingClass : 'incomingSlide',
			outgoingClass : 'outgoingSlide',
			playText : 'Play',
			pauseText : 'Pause',
			playingClass : 'playing',
			pausedClass : 'paused',
			toggleClass : false,
			pauseOnHover : false,
			onInit : false,
			onStart : false,
			onComplete : false
		}, options);

		return this.each( function() {
			var last_user_action = null,
			slides_in_movement = null,
			incomingClass = stripDot(settings.incomingClass),
			outgoingClass = stripDot(settings.outgoingClass),
			effect = settings.effect,
			start = settings.start,
			speed = settings.speed,
			activeSlideClass = stripDot(settings.activeSlideClass),
			activeNavClass = stripDot(settings.activeNavClass),
			auto = settings.auto,
			pause = settings.pause,
			kill_auto = (auto) ? null : 1,
			enableNav = false,
			cycle_slide_timeout,
			esto,
			lastSlideNum,
			lastClicked = false,
			onHoverDisabled = false,
			toggleClass,
			container = $(this);

			if( settings.onInit ) {var onInit = settings.onInit;}
			if( settings.onStart ) {var onStart = settings.onStart;}
			if( settings.onComplete ) {var onComplete = settings.onComplete;}
			if( settings.slideClass ) {
				var slideClass = turnToObject(settings.slideClass),
				esto = container.find(slideClass);
			} else {
				esto = container.children();
			}
			esto.each(function(index){
				$(this).attr('data-slidenum', index).css('z-index', '0');
			});
			lastSlideNum = esto.length - 1;
			toggleClass = settings.toggleClass
			if( toggleClass ) {
				var toggle_queued = null;
				var toggleBTN = turnToObject(toggleClass);
				var playingClass = stripDot(settings.playingClass),
				pausedClass = stripDot(settings.pausedClass),
				pauseText = settings.pauseText,
				playText = settings.playText;
				toggleBTN.click(function(e){
					e.preventDefault();
					onHoverDisabled = true;
					last_user_action = null;
					if(kill_auto == 1) {
						kill_auto = null;
						updateToggleBTN();
						if(slides_in_movement) {
							toggle_queued = true;
						} else {
							preTransition(1);
							queue_slide_qq(1);
						}
					} else {
						clearTimeout(cycle_slide_timeout);
						kill_auto = 1;												updateToggleBTN();
					}
				});
			}
			pauseOnHover = settings.pauseOnHover
			if( pauseOnHover ) {
				last_user_action = null;
				container.hover(function(){
					if(onHoverDisabled) {return false;}
					clearTimeout(cycle_slide_timeout);
					kill_auto = 1;
				},
				function() {
					if(onHoverDisabled) {return false;}
					if(slides_in_movement) {
						toggle_queued = true;
					} else {
						kill_auto = null;
						preTransition(1);
						queue_slide_qq(1);
					}
				});
			}
			if( settings.nav ) {
				enableNav = true;
				var nav = $(settings.nav),
				navContents = nav.html();
				navContents = navContents.replace(/\s+/g, '');
				if(navContents == '') {
					for(var ii = 1; ii <= esto.length; ii++) {
						nav.append("<li><a href='" + ii + "'>" + ii + "</a></li>");
					}
				}
				nav.find('a').click(function(e){
					e.preventDefault();
					onHoverDisabled = true;
					clearTimeout(cycle_slide_timeout);
					kill_auto = 1;
					updateToggleBTN();
					var navBTN = $(this);
					if(navBTN.parent('li').hasClass(activeNavClass)) {return;}
					if(queueClick($(this))) return false;
					last_user_action = "nav";
					nav.find($('.'+ activeNavClass)).removeClass(activeNavClass);
					navBTN.parent('li').addClass(activeNavClass);
					var newSlideNum = nav.find($('.'+ activeNavClass)).index();
					var incoming = esto.eq(newSlideNum);
					var outgoing = container.find($('.' + activeSlideClass));
					slidesTransition(outgoing, incoming);
				});
			}
			if( settings.prevClass) {
				var prev_class = turnToObject(settings.prevClass);
				prev_class.click(function(e){
					e.preventDefault();
					onHoverDisabled = true;
					nextPrevClicked(0, $(this));
				});
			}
			if( settings.nextClass) {
				var next_class = turnToObject(settings.nextClass);
				next_class.click(function(e){
					e.preventDefault();
					onHoverDisabled = true;
					nextPrevClicked(1, $(this));
				});
			}
			function nextPrevClicked(forward, btn) {
				clearTimeout(cycle_slide_timeout);
				kill_auto = 1;
				updateToggleBTN();
				if(queueClick(btn)) return false;
				last_user_action = "nextPrev"
				cycle_slide(forward);
			}
			if( start == -1 ) {
				start = Math.floor((Math.random()*esto.length)+1);
			}
			if(enableNav ) {
				nav.find('li:nth-child(' + start + ')').addClass(activeNavClass);
			}
			if(onInit) {onInit.call(this);}
			updateToggleBTN();
			esto.eq(start - 1).addClass(activeSlideClass).css({'z-index' : 5}).fadeIn(speed, function(){
				if(kill_auto == null) {queue_slide_qq(1);}
			});
			function cycle_slide(forward) {
				var outgoing = container.find($('.' + activeSlideClass)),
				curSlideNum = parseInt(outgoing.attr('data-slidenum')),
				incomingSlideNum,
				incoming;
				if( forward == 1) {
					incomingSlideNum = curSlideNum + 1;
					if( incomingSlideNum > lastSlideNum ) {incomingSlideNum = 0;}
				} else {
					incomingSlideNum = curSlideNum - 1;
					if( incomingSlideNum < 0 ) {incomingSlideNum = lastSlideNum;}
				}
				incoming = esto.eq(incomingSlideNum);
				if(enableNav) {updateNavButtons(incomingSlideNum);}
				slidesTransition(outgoing, incoming);
			}
			function updateNavButtons(incomingIndex) {
				nav.find($('.'+ activeNavClass)).removeClass(activeNavClass);
				nav.find('li:eq(' + incomingIndex + ')').addClass(activeNavClass);
			}
			function slidesTransition(outgoing, incoming){
				slides_in_movement = true;
				updateInOut(outgoing, incoming);
			    if(onStart) {onStart.call(this);}
				if(effect == 'slide') {
					slide_in(outgoing, incoming, activeSlideClass);
				} else {
					fade_in(outgoing, incoming, activeSlideClass);
				}
				if(kill_auto != 1) queue_slide_qq(1);
			}
			function fade_in(outgoing, incoming, activeSlideClass) {
				outgoing.removeClass(activeSlideClass).css('z-index', 0);
				incoming.css('z-index', 5).addClass(activeSlideClass).fadeIn(speed, function(){
					transition_complete(outgoing);
				});
			}
			function slide_in(outgoing, incoming, activeSlideClass) {
				var displacement = incoming.width(),
				a_s_index = parseInt(outgoing.attr('data-slidenum')),
				i_s_index = parseInt(incoming.attr('data-slidenum')),
				rightToLeft, i_s_start, mult;


				if(last_user_action == null) {
					if( i_s_index > a_s_index || i_s_index == 0 ) {
						rightToLeft = true;
					} else {
						rightToLeft = false;
					}
				} else {
					var fromFirstSlide, fromLastSlide, toFirstSlide, toLastSlide, userClickedOnNextprev, userClickedOnNav;
					fromFirstSlide = (a_s_index == 0) ? true : false;
					fromLastSlide = (a_s_index == esto.length - 1) ? true : false;
					toFirstSlide = (i_s_index == 0) ? true : false;
					toLastSlide = (i_s_index == esto.length - 1) ? true : false;
					userClickedOnNextprev = (last_user_action == 'nextPrev') ? true : false;
					userClickedOnNav = (last_user_action == 'nav') ? true : false;

					if( userClickedOnNextprev && fromFirstSlide && toLastSlide ) {
						rightToLeft = false;
					} else if( i_s_index > a_s_index ) {
						rightToLeft = true;
					} else if( toFirstSlide  && fromLastSlide && userClickedOnNav ) {
						rightToLeft = false;
					} else if( toFirstSlide && fromLastSlide ) {
						rightToLeft = true;
					} else {
						rightToLeft = false;
					}
				}

				mult = (rightToLeft) ? 1 : -1;
				i_s_start = {'left' : mult*displacement};
				outgoing.removeClass(activeSlideClass).css('z-index', 0);
				incoming.css('z-index', 5).addClass(activeSlideClass).css(i_s_start).show();

				if( rightToLeft) {
					outgoing.animate({'left' : -1 * displacement}, speed);
					incoming.animate({'left' : 0}, speed, function(){
						transition_complete(outgoing);
					});
				} else {
					outgoing.animate({'left' : displacement}, speed);
					incoming.animate({'left' : 0}, speed, function(){
						transition_complete(outgoing);
					});
				}
			}
			function transition_complete(outgoing) {
					outgoing.hide()
					if(onComplete) {onComplete.call(this);}
					slides_in_movement = false;
					if(toggle_queued) {
						toggle_queued = null;
						preTransition(1);
						queue_slide_qq(1);
					} else if(lastClicked) {
						lastClicked.click();
					}
			}
			function queue_slide_qq(forward) {
				clearTimeout(cycle_slide_timeout);
				cycle_slide_timeout = setTimeout(function(){
					preTransition(forward);
				}, pause);
			}
			function preTransition(forward) {
				if(onStart) {onStart.call(this);}
				cycle_slide(forward);
			}
			function stripDot(stringToStrip) {
				var strippedString = stringToStrip.replace('.', '');
				return strippedString;
			}
			function turnToObject(stringToTurn) {
				stringToTurn = stripDot(stringToTurn);
				return $('.' + stringToTurn);
			}
			function updateInOut(outgoing, incoming) {
				container.children('.' + outgoingClass).removeClass(outgoingClass);
				container.children('.' + incomingClass).removeClass(incomingClass);
				outgoing.addClass(outgoingClass);
				incoming.addClass(incomingClass);
			}
			function queueClick(btn) {
				if( slides_in_movement ) {
					lastClicked = btn;
					return true;
				} else {
					lastClicked = false;
				}
				return false;
			}
			function updateToggleBTN() {
				if(!toggleClass) return false;
				var classrem, classadd, newtext;
				if(kill_auto == null) {
					classrem = pausedClass;
					classadd = playingClass;
					newtext = pauseText;
				} else {
					classrem = playingClass;
					classadd = pausedClass;
					newtext = playText;
				}
				toggleBTN.removeClass(classrem).addClass(classadd).html(newtext);
			}
		});//this.each ends
	}
}(jQuery));